;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Expand/exit.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Apr 21 15:03:35 1995                          */
;*    Last change :  Thu Feb 10 10:32:25 2011 (serrano)                */
;*    Copyright   :  1995-2011 Manuel Serrano, see LICENSE file        */
;*    -------------------------------------------------------------    */
;*    The macro expansion of the `exit' machinery.                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_exit
   (include "Expand/expander.sch"
	    "Tools/trace.sch"
	    "Tools/location.sch")
   (import  tools_args
	    tools_speek
	    tools_misc
	    expand_expander
	    expand_eps
	    expand_lambda
	    engine_param
	    type_type
	    ast_ident
	    backend_backend
	    tools_location)
   (export  (expand-jump-exit      ::obj ::procedure)
	    (expand-set-exit       ::obj ::procedure)
	    (expand-bind-exit      ::obj ::procedure)
	    (expand-unwind-protect ::obj ::procedure)
	    (expand-with-handler   ::obj ::procedure)))

;*---------------------------------------------------------------------*/
;*    expand-jump-exit ...                                             */
;*---------------------------------------------------------------------*/
(define (expand-jump-exit x e)
   (match-case x
      ((?- ?exit . ?value)
       (let ((new `(jump-exit ,(e exit e) ,(e (expand-progn value) e))))
	  (replace! x new)))
      (else
       (error #f "Illegal 'jump-exit' form" x))))

;*---------------------------------------------------------------------*/
;*    expand-set-exit ...                                              */
;*---------------------------------------------------------------------*/
(define (expand-set-exit x e)
   (match-case x
      ((?- (?exit) . ?body)
       (let ((new `(set-exit (,exit) ,(e (expand-progn body) e))))
	  (replace! x new)))
      (else
       (error #f "Illegal `set-exit' form" x))))
	  
;*---------------------------------------------------------------------*/
;*    expand-bind-exit ...                                             */
;*---------------------------------------------------------------------*/
(define (expand-bind-exit x e)
   (match-case x
      ((?- (?exit) . ?body)
       (let ((an-exit  (mark-symbol-non-user! (gensym 'an_exit)))
	     (an-exitd (mark-symbol-non-user! (gensym 'an_exitd)))
	     (val      (mark-symbol-non-user! (gensym 'val)))
	     (res      (mark-symbol-non-user! (gensym 'res))))
	  (let ((new (e `(set-exit (,an-exit)
				   (let ()
				      (push-exit! ,an-exit 1)
				      (let ((,an-exitd ($get-exitd-top)))
					 (labels ((,exit (,val)
							 ((@ unwind-until! __bexit)
							  ,an-exitd
							  ,val)))
					    (let ((,res (begin ,@body)))
					       (pop-exit!)
					       ,res)))))
			e)))
	     (replace! x new))))
      (else
       (error #f "Illegal `bind-exit' form" x))))

;*---------------------------------------------------------------------*/
;*    expand-unwind-protect ...                                        */
;*---------------------------------------------------------------------*/
(define (expand-unwind-protect x e)
   (match-case x
      ((?- ?exp . (and (? pair?) ?cleanup))
       (let* ((val     (mark-symbol-non-user! (gensym 'val)))
	      (an-exit (mark-symbol-non-user! (gensym 'an_exit)))
	      (valbis  (mark-symbol-non-user! (gensym 'val)))
	      (eexp    (e exp e))
	      (aux     `(let ((,valbis ,eexp))
			   (pop-exit!)
			   ,valbis))
	      (eaux    (if (epair? eexp)
			   (econs (car aux) (cdr aux) (cer eexp))
			   aux)))
	  (let ((new `(let ((,val (set-exit (,an-exit)
					    (let ()
					       (push-exit! ,an-exit 0)
					       ,aux))))
			 ,(e (expand-progn cleanup) e)
			 (if (val-from-exit? ,val)
			     ((@ unwind-until! __bexit) (car ,val) (cdr ,val))
			     ,val))))
	     (replace! x new))))
      (else
       (error #f "Illegal `unwind-protect' form" x))))
			  
;*---------------------------------------------------------------------*/
;*    expand-with-handler ...                                          */
;*---------------------------------------------------------------------*/
(define (expand-with-handler x e)
   
  (define (expand handler body)
     (let ((ohs (gensym 'ohs))
	   (err (gensym 'err))
	   (res (gensym 'res))
	   (escape (gensym 'escape))
	   (hdl (gensym 'handler)))
	(e `(let ((,res #unspecified)
		  (,hdl ,handler))
	       (if (bind-exit (,escape)
		      (let ((,ohs ($get-error-handler)))
			 (unwind-protect
			    (begin
			       ($set-error-handler!
				(cons (lambda (e)
					 (set! ,res e)
					 (,escape #t))
				      ,ohs))
			       (set! ,res (begin ,@body))
			       #f)
			    ($set-error-handler! ,ohs))))
		   (,hdl ,res)
		   ,res))
	   e)))

   (define (add-trace body)
      (let ((loc (find-location x)))
	 (if (and (location? loc)
		  (>fx (bigloo-compiler-debug) 0)
		  (backend-trace-support (the-backend)))
	     (let ((loc `(at ,(location-full-fname loc) ,(location-pos loc)))
		   (vid (gensym))
		   (tmp1 (mark-symbol-non-user! (gensym 'name)))
		   (tmp2 (mark-symbol-non-user! (gensym 'loc))))
		`(let ((,tmp1 'with-handler)
		       (,tmp2 ',loc))
		    (let ()
		       ($push-trace ,tmp1 ,tmp2)
		       (let ((,vid ,body))
			  ,(econs '$pop-trace '() loc)
			  ,vid))))
	     body)))
   
   (match-case x
      ((?- ?handler . ?body)
       (replace! x (add-trace (expand handler body))))
      (else
       (error #f "Illegal `with-handler' form" x))))

   
			  
       
