/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2015 Blender Foundation.
 * All rights reserved.
 */

#include "openvdb_util.h"

#include <cstdio>

ScopeTimer::ScopeTimer(const std::string &message) : m_message(message), m_timer()
{
}

ScopeTimer::~ScopeTimer()
{
#if OPENVDB_LIBRARY_MAJOR_VERSION_NUMBER >= 7
  double delta = m_timer.milliseconds();
#else
  double delta = m_timer.delta(); /* Deprecated in OpenVDB 7. */
#endif
  std::printf("%s: %fms\n", m_message.c_str(), delta);
}
