# t00075 - Test case for class diagram styles in config file
## Config
```yaml
diagrams:
  t00075_class:
    type: class
    glob:
      - t00075.cc
    include:
      namespaces:
        - clanguml::t00075
    generate_packages: true
    using_namespace: clanguml::t00075
    plantuml:
      style:
        concept: "#line:green;back:lightblue"
        class: "#aliceblue;line:blue;line.dotted;text:blue"
        package: "#back:grey"
        enum: "#line.dotted"
        constraint: "up[#green,dashed,thickness=2]"

```
## Source code
File `tests/t00075/t00075.cc`
```cpp
namespace clanguml {
namespace t00075 {
namespace ns1 {
namespace ns2 {

template <typename T>
concept C = requires(T t) {
    T{};
    t.e();
};

enum class E { k1, k2 };

struct A {
    E e() const { return E::k1; };
};

class B {
public:
    E e() const { return E::k2; };
};

template <C T> class ABE {
    T a_or_b;
};

struct R {
    ABE<A> a;
    ABE<B> b;
};
} // namespace ns2
} // namespace ns1
}
}
```
## Generated PlantUML diagrams
![t00075_class](./t00075_class.svg "Test case for class diagram styles in config file")
## Generated Mermaid diagrams
![t00075_class](./t00075_class_mermaid.svg "Test case for class diagram styles in config file")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "display_name": "ns1",
      "elements": [
        {
          "display_name": "ns2",
          "elements": [
            {
              "display_name": "C<T>",
              "id": "14474656816215959881",
              "name": "C",
              "namespace": "clanguml::t00075::ns1::ns2",
              "parameters": [
                {
                  "name": "t",
                  "type": "T"
                }
              ],
              "source_location": {
                "column": 9,
                "file": "t00075.cc",
                "line": 7,
                "translation_unit": "t00075.cc"
              },
              "statements": [
                "T{}",
                "t.e()"
              ],
              "type": "concept"
            },
            {
              "constants": [
                "k1",
                "k2"
              ],
              "display_name": "E",
              "id": "11960608547770754184",
              "is_nested": false,
              "name": "E",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 12,
                "file": "t00075.cc",
                "line": 12,
                "translation_unit": "t00075.cc"
              },
              "type": "enum"
            },
            {
              "bases": [],
              "display_name": "A",
              "id": "7513503374639866918",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [
                {
                  "access": "public",
                  "display_name": "e",
                  "is_const": true,
                  "is_consteval": false,
                  "is_constexpr": false,
                  "is_constructor": false,
                  "is_copy_assignment": false,
                  "is_coroutine": false,
                  "is_defaulted": false,
                  "is_deleted": false,
                  "is_move_assignment": false,
                  "is_noexcept": false,
                  "is_operator": false,
                  "is_pure_virtual": false,
                  "is_static": false,
                  "is_virtual": false,
                  "name": "e",
                  "parameters": [],
                  "source_location": {
                    "column": 7,
                    "file": "t00075.cc",
                    "line": 15,
                    "translation_unit": "t00075.cc"
                  },
                  "template_parameters": [],
                  "type": "E"
                }
              ],
              "name": "A",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 8,
                "file": "t00075.cc",
                "line": 14,
                "translation_unit": "t00075.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "B",
              "id": "5657692626363523421",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": false,
              "is_union": false,
              "members": [],
              "methods": [
                {
                  "access": "public",
                  "display_name": "e",
                  "is_const": true,
                  "is_consteval": false,
                  "is_constexpr": false,
                  "is_constructor": false,
                  "is_copy_assignment": false,
                  "is_coroutine": false,
                  "is_defaulted": false,
                  "is_deleted": false,
                  "is_move_assignment": false,
                  "is_noexcept": false,
                  "is_operator": false,
                  "is_pure_virtual": false,
                  "is_static": false,
                  "is_virtual": false,
                  "name": "e",
                  "parameters": [],
                  "source_location": {
                    "column": 7,
                    "file": "t00075.cc",
                    "line": 20,
                    "translation_unit": "t00075.cc"
                  },
                  "template_parameters": [],
                  "type": "E"
                }
              ],
              "name": "B",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 7,
                "file": "t00075.cc",
                "line": 18,
                "translation_unit": "t00075.cc"
              },
              "template_parameters": [],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "ABE<ns1::ns2::C T>",
              "id": "6266824224471399124",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": true,
              "is_union": false,
              "members": [
                {
                  "access": "private",
                  "is_static": false,
                  "name": "a_or_b",
                  "source_location": {
                    "column": 7,
                    "file": "t00075.cc",
                    "line": 24,
                    "translation_unit": "t00075.cc"
                  },
                  "type": "T"
                }
              ],
              "methods": [],
              "name": "ABE",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 22,
                "file": "t00075.cc",
                "line": 23,
                "translation_unit": "t00075.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "template_type",
                  "name": "T",
                  "template_parameters": []
                }
              ],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "ABE<ns1::ns2::A>",
              "id": "11097931606724677197",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": true,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "ABE",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 12,
                "file": "t00075.cc",
                "line": 28,
                "translation_unit": "t00075.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "ns1::ns2::A"
                }
              ],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "ABE<ns1::ns2::B>",
              "id": "8958649478478523249",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": false,
              "is_template": true,
              "is_union": false,
              "members": [],
              "methods": [],
              "name": "ABE",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 12,
                "file": "t00075.cc",
                "line": 29,
                "translation_unit": "t00075.cc"
              },
              "template_parameters": [
                {
                  "is_variadic": false,
                  "kind": "argument",
                  "template_parameters": [],
                  "type": "ns1::ns2::B"
                }
              ],
              "type": "class"
            },
            {
              "bases": [],
              "display_name": "R",
              "id": "384663578720386827",
              "is_abstract": false,
              "is_nested": false,
              "is_struct": true,
              "is_template": false,
              "is_union": false,
              "members": [
                {
                  "access": "public",
                  "is_static": false,
                  "name": "a",
                  "source_location": {
                    "column": 12,
                    "file": "t00075.cc",
                    "line": 28,
                    "translation_unit": "t00075.cc"
                  },
                  "type": "ABE<A>"
                },
                {
                  "access": "public",
                  "is_static": false,
                  "name": "b",
                  "source_location": {
                    "column": 12,
                    "file": "t00075.cc",
                    "line": 29,
                    "translation_unit": "t00075.cc"
                  },
                  "type": "ABE<B>"
                }
              ],
              "methods": [],
              "name": "R",
              "namespace": "clanguml::t00075::ns1::ns2",
              "source_location": {
                "column": 8,
                "file": "t00075.cc",
                "line": 27,
                "translation_unit": "t00075.cc"
              },
              "template_parameters": [],
              "type": "class"
            }
          ],
          "name": "ns2",
          "type": "namespace"
        }
      ],
      "name": "ns1",
      "type": "namespace"
    }
  ],
  "name": "t00075_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "11960608547770754184",
      "source": "7513503374639866918",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11960608547770754184",
      "source": "5657692626363523421",
      "type": "dependency"
    },
    {
      "destination": "14474656816215959881",
      "label": "T",
      "source": "6266824224471399124",
      "type": "constraint"
    },
    {
      "access": "public",
      "destination": "7513503374639866918",
      "source": "11097931606724677197",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6266824224471399124",
      "source": "11097931606724677197",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "5657692626363523421",
      "source": "8958649478478523249",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "6266824224471399124",
      "source": "8958649478478523249",
      "type": "instantiation"
    },
    {
      "access": "public",
      "destination": "11097931606724677197",
      "label": "a",
      "source": "384663578720386827",
      "type": "aggregation"
    },
    {
      "access": "public",
      "destination": "8958649478478523249",
      "label": "b",
      "source": "384663578720386827",
      "type": "aggregation"
    }
  ],
  "using_namespace": "clanguml::t00075"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00075</data>
  <node id="n0">
   <data key="nd2">ns1</data>
   <data key="nd1">namespace</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">ns2</data>
     <data key="nd1">namespace</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd1">concept</data>
       <data key="nd2"><![CDATA[C<T>]]></data>
      </node>
      <node id="n3">
       <data key="nd1">enum</data>
       <data key="nd2"><![CDATA[E]]></data>
      </node>
      <node id="n4">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[A]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n5">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[B]]></data>
       <data key="nd6">false</data>
      </node>
      <node id="n6">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[ABE<ns1::ns2::C T>]]></data>
       <data key="nd6">true</data>
      </node>
      <node id="n7">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[ABE<ns1::ns2::A>]]></data>
       <data key="nd6">true</data>
      </node>
      <node id="n8">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[ABE<ns1::ns2::B>]]></data>
       <data key="nd6">true</data>
      </node>
      <node id="n9">
       <data key="nd1">class</data>
       <data key="nd2"><![CDATA[R]]></data>
       <data key="nd6">false</data>
      </node>
     </graph>
    </node>
   </graph>
  </node>
  <edge id="e0" source="n4" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n5" target="n3">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n6" target="n2">
   <data key="ed0">constraint</data>
   <data key="ed2">T</data>
  </edge>
  <edge id="e3" source="n7" target="n4">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n7" target="n6">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n8" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n8" target="n6">
   <data key="ed0">instantiation</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n9" target="n7">
   <data key="ed0">aggregation</data>
   <data key="ed2">a</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n9" target="n8">
   <data key="ed0">aggregation</data>
   <data key="ed2">b</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
