# t20018 - Recursive template sequence diagram test case
## Config
```yaml
diagrams:
  t20018_sequence:
    type: sequence
    glob:
      - t20018.cc
    include:
      namespaces:
        - clanguml::t20018
    using_namespace: clanguml::t20018
    from:
      - function: "clanguml::t20018::tmain()"
```
## Source code
File `tests/t20018/t20018.cc`
```cpp
#include <iostream>

namespace clanguml {
namespace t20018 {

template <int N> struct Factorial {
    static const int value = N * Factorial<N - 1>::value;

    static void print(int answer) { Factorial<N - 1>::print(answer); }
};

template <> struct Factorial<0> {
    static const int value = 1;

    static void print(int answer)
    {
        std::cout << "The answer is " << answer << "\n";
    }
};

template <typename T, int N = T::value> struct Answer {
    static void print() { T::print(N); }
};

void tmain() { Answer<Factorial<5>>::print(); }
}
}
```
## Generated PlantUML diagrams
![t20018_sequence](./t20018_sequence.svg "Recursive template sequence diagram test case")
## Generated Mermaid diagrams
![t20018_sequence](./t20018_sequence_mermaid.svg "Recursive template sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20018_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20018::tmain()",
      "id": "1820654064203230521",
      "name": "tmain",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 6,
        "file": "t20018.cc",
        "line": 25,
        "translation_unit": "t20018.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "print()",
          "full_name": "clanguml::t20018::Answer<clanguml::t20018::Factorial<5>,120>::print()",
          "id": "9486166129914439617",
          "name": "print",
          "namespace": "clanguml::t20018::Answer<clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 22,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Answer<Factorial<5>,120>",
      "full_name": "clanguml::t20018::Answer<clanguml::t20018::Factorial<5>,120>",
      "id": "9308173802812268017",
      "name": "Answer",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 48,
        "file": "t20018.cc",
        "line": 21,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "print(int)",
          "full_name": "clanguml::t20018::Factorial<5>::print(int)",
          "id": "6664807107626395688",
          "name": "print",
          "namespace": "clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Factorial<5>",
      "full_name": "clanguml::t20018::Factorial<5>",
      "id": "11862234988510799368",
      "name": "Factorial",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 25,
        "file": "t20018.cc",
        "line": 6,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "print(int)",
          "full_name": "clanguml::t20018::Factorial<4>::print(int)",
          "id": "14260693150511929978",
          "name": "print",
          "namespace": "clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Factorial<4>",
      "full_name": "clanguml::t20018::Factorial<4>",
      "id": "419331232524118585",
      "name": "Factorial",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 25,
        "file": "t20018.cc",
        "line": 6,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "print(int)",
          "full_name": "clanguml::t20018::Factorial<3>::print(int)",
          "id": "9904624228765893427",
          "name": "print",
          "namespace": "clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Factorial<3>",
      "full_name": "clanguml::t20018::Factorial<3>",
      "id": "13269824626368800150",
      "name": "Factorial",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 25,
        "file": "t20018.cc",
        "line": 6,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "print(int)",
          "full_name": "clanguml::t20018::Factorial<2>::print(int)",
          "id": "17306167603803814242",
          "name": "print",
          "namespace": "clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Factorial<2>",
      "full_name": "clanguml::t20018::Factorial<2>",
      "id": "7759227753334080993",
      "name": "Factorial",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 25,
        "file": "t20018.cc",
        "line": 6,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "print(int)",
          "full_name": "clanguml::t20018::Factorial<1>::print(int)",
          "id": "4009328130607501361",
          "name": "print",
          "namespace": "clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Factorial<1>",
      "full_name": "clanguml::t20018::Factorial<1>",
      "id": "16260969585524804132",
      "name": "Factorial",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 25,
        "file": "t20018.cc",
        "line": 6,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "print(int)",
          "full_name": "clanguml::t20018::Factorial<0>::print(int)",
          "id": "4617862618819132358",
          "name": "print",
          "namespace": "clanguml::t20018",
          "source_location": {
            "column": 17,
            "file": "t20018.cc",
            "line": 15,
            "translation_unit": "t20018.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Factorial<0>",
      "full_name": "clanguml::t20018::Factorial<0>",
      "id": "12654926397331091668",
      "name": "Factorial",
      "namespace": "clanguml::t20018",
      "source_location": {
        "column": 20,
        "file": "t20018.cc",
        "line": 12,
        "translation_unit": "t20018.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "from": {
        "id": "1820654064203230521",
        "location": "clanguml::t20018::tmain()"
      },
      "messages": [
        {
          "from": {
            "activity_id": "1820654064203230521",
            "participant_id": "1820654064203230521"
          },
          "name": "print()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20018.cc",
            "line": 25,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "9486166129914439617",
            "participant_id": "9308173802812268017"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9486166129914439617",
            "participant_id": "9308173802812268017"
          },
          "name": "print(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 27,
            "file": "t20018.cc",
            "line": 22,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "6664807107626395688",
            "participant_id": "11862234988510799368"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6664807107626395688",
            "participant_id": "11862234988510799368"
          },
          "name": "print(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "14260693150511929978",
            "participant_id": "419331232524118585"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14260693150511929978",
            "participant_id": "419331232524118585"
          },
          "name": "print(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "9904624228765893427",
            "participant_id": "13269824626368800150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9904624228765893427",
            "participant_id": "13269824626368800150"
          },
          "name": "print(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "17306167603803814242",
            "participant_id": "7759227753334080993"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17306167603803814242",
            "participant_id": "7759227753334080993"
          },
          "name": "print(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "4009328130607501361",
            "participant_id": "16260969585524804132"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "4009328130607501361",
            "participant_id": "16260969585524804132"
          },
          "name": "print(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20018.cc",
            "line": 9,
            "translation_unit": "t20018.cc"
          },
          "to": {
            "activity_id": "4617862618819132358",
            "participant_id": "12654926397331091668"
          },
          "type": "message"
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20018"
}
```
## Generated GraphML models
