# t00021 - Visitor pattern
## Config
```yaml
diagrams:
  t00021_class:
    type: class
    glob:
      - t00021.cc
    using_namespace: clanguml::t00021
    include:
      namespaces:
        - clanguml::t00021

```
## Source code
File `tests/t00021/t00021.cc`
```cpp
#include <memory>

namespace clanguml {
namespace t00021 {

class A;
class B;

class Visitor {
public:
    virtual ~Visitor() = default;
    virtual void visit_A(const A &item) const = 0;
    virtual void visit_B(const B &item) const = 0;
};

class Visitor1 : public Visitor {
public:
    void visit_A(const A &item) const override { }
    void visit_B(const B &item) const override { }
};

class Visitor2 : public Visitor {
public:
    void visit_A(const A &item) const override { }
    void visit_B(const B &item) const override { }
};

class Visitor3 : public Visitor {
public:
    void visit_A(const A &item) const override { }
    void visit_B(const B &item) const override { }
};

class Item {
public:
    virtual ~Item() = default;
    virtual void accept(const Visitor &visitor) const = 0;
};

class A : public Item {
public:
    void accept(const Visitor &visitor) const override { }
};

class B : public Item {
public:
    void accept(const Visitor &visitor) const override { }
};
} // namespace t00021
} // namespace clanguml

```
## Generated PlantUML diagrams
![t00021_class](./t00021_class.svg "Visitor pattern")
## Generated Mermaid diagrams
![t00021_class](./t00021_class_mermaid.svg "Visitor pattern")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "Visitor",
      "id": "13349368885381955166",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "~Visitor",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "~Visitor",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00021.cc",
            "line": 11,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "visit_A",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_A",
          "parameters": [
            {
              "name": "item",
              "type": "const A &"
            }
          ],
          "source_location": {
            "column": 18,
            "file": "t00021.cc",
            "line": 12,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "visit_B",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_B",
          "parameters": [
            {
              "name": "item",
              "type": "const B &"
            }
          ],
          "source_location": {
            "column": 18,
            "file": "t00021.cc",
            "line": 13,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Visitor",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 9,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "13349368885381955166",
          "is_virtual": false
        }
      ],
      "display_name": "Visitor1",
      "id": "8226953755203215571",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "visit_A",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_A",
          "parameters": [
            {
              "name": "item",
              "type": "const A &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 18,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "visit_B",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_B",
          "parameters": [
            {
              "name": "item",
              "type": "const B &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 19,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Visitor1",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 16,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "13349368885381955166",
          "is_virtual": false
        }
      ],
      "display_name": "Visitor2",
      "id": "13682986523810297046",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "visit_A",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_A",
          "parameters": [
            {
              "name": "item",
              "type": "const A &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 24,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "visit_B",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_B",
          "parameters": [
            {
              "name": "item",
              "type": "const B &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 25,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Visitor2",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 22,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "13349368885381955166",
          "is_virtual": false
        }
      ],
      "display_name": "Visitor3",
      "id": "11192209825433424201",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "visit_A",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_A",
          "parameters": [
            {
              "name": "item",
              "type": "const A &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 30,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "visit_B",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "visit_B",
          "parameters": [
            {
              "name": "item",
              "type": "const B &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 31,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Visitor3",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 28,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "Item",
      "id": "11932550614071581777",
      "is_abstract": true,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "~Item",
          "is_const": false,
          "is_consteval": false,
          "is_constexpr": true,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": true,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "~Item",
          "parameters": [],
          "source_location": {
            "column": 13,
            "file": "t00021.cc",
            "line": 36,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        },
        {
          "access": "public",
          "display_name": "accept",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": true,
          "is_static": false,
          "is_virtual": true,
          "name": "accept",
          "parameters": [
            {
              "name": "visitor",
              "type": "const Visitor &"
            }
          ],
          "source_location": {
            "column": 18,
            "file": "t00021.cc",
            "line": 37,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "Item",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 34,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "11932550614071581777",
          "is_virtual": false
        }
      ],
      "display_name": "A",
      "id": "11953141964512214591",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "accept",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "accept",
          "parameters": [
            {
              "name": "visitor",
              "type": "const Visitor &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 42,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "A",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 40,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [
        {
          "access": "public",
          "id": "11932550614071581777",
          "is_virtual": false
        }
      ],
      "display_name": "B",
      "id": "11623589203607996547",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": false,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [
        {
          "access": "public",
          "display_name": "accept",
          "is_const": true,
          "is_consteval": false,
          "is_constexpr": false,
          "is_constructor": false,
          "is_copy_assignment": false,
          "is_coroutine": false,
          "is_defaulted": false,
          "is_deleted": false,
          "is_move_assignment": false,
          "is_noexcept": false,
          "is_operator": false,
          "is_pure_virtual": false,
          "is_static": false,
          "is_virtual": true,
          "name": "accept",
          "parameters": [
            {
              "name": "visitor",
              "type": "const Visitor &"
            }
          ],
          "source_location": {
            "column": 10,
            "file": "t00021.cc",
            "line": 47,
            "translation_unit": "t00021.cc"
          },
          "template_parameters": [],
          "type": "void"
        }
      ],
      "name": "B",
      "namespace": "clanguml::t00021",
      "source_location": {
        "column": 7,
        "file": "t00021.cc",
        "line": 45,
        "translation_unit": "t00021.cc"
      },
      "template_parameters": [],
      "type": "class"
    }
  ],
  "name": "t00021_class",
  "package_type": "namespace",
  "relationships": [
    {
      "access": "public",
      "destination": "11953141964512214591",
      "source": "13349368885381955166",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11623589203607996547",
      "source": "13349368885381955166",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11953141964512214591",
      "source": "8226953755203215571",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11623589203607996547",
      "source": "8226953755203215571",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13349368885381955166",
      "source": "8226953755203215571",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11953141964512214591",
      "source": "13682986523810297046",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11623589203607996547",
      "source": "13682986523810297046",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13349368885381955166",
      "source": "13682986523810297046",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "11953141964512214591",
      "source": "11192209825433424201",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11623589203607996547",
      "source": "11192209825433424201",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13349368885381955166",
      "source": "11192209825433424201",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "13349368885381955166",
      "source": "11932550614071581777",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "13349368885381955166",
      "source": "11953141964512214591",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11932550614071581777",
      "source": "11953141964512214591",
      "type": "extension"
    },
    {
      "access": "public",
      "destination": "13349368885381955166",
      "source": "11623589203607996547",
      "type": "dependency"
    },
    {
      "access": "public",
      "destination": "11932550614071581777",
      "source": "11623589203607996547",
      "type": "extension"
    }
  ],
  "using_namespace": "clanguml::t00021"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00021</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Visitor]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Visitor1]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Visitor2]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Visitor3]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[Item]]></data>
   <data key="nd3">abstract</data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <edge id="e0" source="n0" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e1" source="n0" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e2" source="n1" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e3" source="n1" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e4" source="n1" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e5" source="n2" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e6" source="n2" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e7" source="n2" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e8" source="n3" target="n5">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e9" source="n3" target="n6">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e10" source="n3" target="n0">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e11" source="n4" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e12" source="n5" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e13" source="n5" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e14" source="n6" target="n0">
   <data key="ed0">dependency</data>
   <data key="ed1">public</data>
  </edge>
  <edge id="e15" source="n6" target="n4">
   <data key="ed0">extension</data>
   <data key="ed1">public</data>
  </edge>
 </graph>
</graphml>

```
