# t00053 - Test case for `together` layout hint in class diagram
## Config
```yaml
diagrams:
  t00053_class:
    type: class
    glob:
      - t00053.cc
    include:
      namespaces:
        - clanguml::t00053
    using_namespace: clanguml::t00053
    layout:
      a:
        - together: [c,e,f]
      A:
        - together: [C,E,F]
      h:
        - together: [j]

```
## Source code
File `tests/t00053/t00053.cc`
```cpp
namespace clanguml {
namespace t00053 {
struct a { };
struct b { };
struct c { };
struct d { };
struct e { };
struct f { };
struct g { };

struct A { };
struct B { };
struct C { };
struct D { };
struct E { };
struct F { };
struct G { };

enum class h { hhh };
enum class i { iii };
enum class j { jjj };

}
}
```
## Generated PlantUML diagrams
![t00053_class](./t00053_class.svg "Test case for `together` layout hint in class diagram")
## Generated Mermaid diagrams
![t00053_class](./t00053_class_mermaid.svg "Test case for `together` layout hint in class diagram")
## Generated JSON models
```json
{
  "diagram_type": "class",
  "elements": [
    {
      "bases": [],
      "display_name": "a",
      "id": "2781038698340153159",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "a",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 3,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "b",
      "id": "11010757161954084380",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "b",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 4,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "c",
      "id": "4035710408756550430",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "c",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 5,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "d",
      "id": "10115641318897792718",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "d",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 6,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "e",
      "id": "7263375710215516879",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "e",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 7,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "f",
      "id": "11370313029314192677",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "f",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 8,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "g",
      "id": "1601817013670096009",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "g",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 9,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "A",
      "id": "2581142729043675406",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "A",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 11,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "B",
      "id": "7012991760569303265",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "B",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 12,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "C",
      "id": "9987791926272995751",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "C",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 13,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "D",
      "id": "3761824362382283158",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "D",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 14,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "E",
      "id": "8307078113770890060",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "E",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 15,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "F",
      "id": "4242029990488317339",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "F",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 16,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "bases": [],
      "display_name": "G",
      "id": "8252914587750588627",
      "is_abstract": false,
      "is_nested": false,
      "is_struct": true,
      "is_template": false,
      "is_union": false,
      "members": [],
      "methods": [],
      "name": "G",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 8,
        "file": "t00053.cc",
        "line": 17,
        "translation_unit": "t00053.cc"
      },
      "template_parameters": [],
      "type": "class"
    },
    {
      "constants": [
        "hhh"
      ],
      "display_name": "h",
      "id": "1527826936592257484",
      "is_nested": false,
      "name": "h",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 12,
        "file": "t00053.cc",
        "line": 19,
        "translation_unit": "t00053.cc"
      },
      "type": "enum"
    },
    {
      "constants": [
        "iii"
      ],
      "display_name": "i",
      "id": "11785716967071887447",
      "is_nested": false,
      "name": "i",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 12,
        "file": "t00053.cc",
        "line": 20,
        "translation_unit": "t00053.cc"
      },
      "type": "enum"
    },
    {
      "constants": [
        "jjj"
      ],
      "display_name": "j",
      "id": "7720668843789291480",
      "is_nested": false,
      "name": "j",
      "namespace": "clanguml::t00053",
      "source_location": {
        "column": 12,
        "file": "t00053.cc",
        "line": 21,
        "translation_unit": "t00053.cc"
      },
      "type": "enum"
    }
  ],
  "name": "t00053_class",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t00053"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="is_template" attr.type="boolean" for="node" id="nd6" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t00053</data>
  <node id="n0">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[a]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n1">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[b]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n2">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[c]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n3">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[d]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n4">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[e]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n5">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[f]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n6">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[g]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n7">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[A]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n8">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[B]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n9">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[C]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n10">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[D]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n11">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[E]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n12">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[F]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n13">
   <data key="nd1">class</data>
   <data key="nd2"><![CDATA[G]]></data>
   <data key="nd6">false</data>
  </node>
  <node id="n14">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[h]]></data>
  </node>
  <node id="n15">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[i]]></data>
  </node>
  <node id="n16">
   <data key="nd1">enum</data>
   <data key="nd2"><![CDATA[j]]></data>
  </node>
 </graph>
</graphml>

```
