/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import hhapplet.BsscFontFixPatch;
import hhapplet.CanvasButton;
import hhapplet.TabManagerAdaper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

public class TabButton
extends CanvasButton {
    protected String label;
    protected int x_offset = -1;
    protected int y_offset = -1;
    protected Font active;
    protected Font inactive;
    protected int tab_x;
    protected int tab_y;
    protected int tab_width;
    protected int tab_height;
    protected boolean m_bDrawLeft = true;
    protected boolean m_bDrawRight = true;
    protected boolean m_bActive = false;
    protected boolean m_bFocused = false;
    protected TabManagerAdaper m_manager = null;
    protected boolean m_bCenterBroken = false;

    protected void centerText(Font font) {
        Rectangle rectangle = this.bounds();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n = fontMetrics.stringWidth(this.label);
        int n2 = fontMetrics.getMaxAscent();
        this.y_offset = rectangle.height - n2;
        this.y_offset = this.y_offset / 2 + n2;
        this.x_offset = rectangle.width - n;
        this.x_offset /= 2;
        if (this.m_bCenterBroken && this.isActived()) {
            this.x_offset += 3;
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.tab_x = n;
        this.tab_y = n2;
        this.tab_width = n3;
        this.tab_height = n4;
        this.centerText(this.getFont());
    }

    public void disactive() {
        if (this.isActived()) {
            this.setFont(this.inactive);
            super.reshape(this.tab_x, this.tab_y, this.tab_width, this.tab_height);
            this.centerText(this.inactive);
            this.repaint();
            this.m_bActive = false;
        }
    }

    public boolean isFocusTraversable() {
        return this.isActived();
    }

    public TabButton(String string, TabManagerAdaper tabManagerAdaper) {
        this.m_manager = tabManagerAdaper;
        int n = BsscFontFixPatch.GetFontSize();
        this.active = new Font(BsscFontFixPatch.GetFontName(), 1, n);
        while (this.active.getSize() != n && n < BsscFontFixPatch.GetFontSize() + 10) {
            this.active = new Font(BsscFontFixPatch.GetFontName(), 1, ++n);
        }
        this.inactive = new Font(BsscFontFixPatch.GetFontName(), 0, n);
        this.setFont(this.inactive);
        this.label = string;
        if (System.getProperty("java.vendor").startsWith("Netscape") && System.getProperty("os.name").startsWith("Windows 95")) {
            try {
                String string2 = System.getProperty("java.version");
                if (string2.startsWith("1.02")) {
                    this.m_bCenterBroken = true;
                }
                Integer n2 = new Integer(string2.substring(0, 1));
                Integer n3 = new Integer(string2.substring(2, 3));
                Integer n4 = new Integer(string2.substring(4, 5));
                if (n2 <= 1 && n3 <= 1 && n4 <= 2) {
                    this.m_bCenterBroken = true;
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void paint(Graphics graphics) {
        try {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.bounds().width, this.bounds().height);
            if (this.img != null) {
                graphics.drawImage(this.img, 2, 2, null);
            } else if (this.label != null) {
                this.centerText(this.getFont());
                graphics.setColor(this.getForeground());
                graphics.setFont(this.getFont());
                graphics.drawString(this.label, this.x_offset, this.y_offset);
                if (this.m_bFocused) {
                    graphics.drawRect(3, 3, this.bounds().width - 7, this.bounds().height - 7);
                }
            }
            this.paintBorderOut(graphics);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean isActived() {
        return this.m_bActive;
    }

    public void paintBorderOut(Graphics graphics) {
        Rectangle rectangle = this.bounds();
        if (this.isActived()) {
            graphics.setColor(Color.white);
            graphics.drawLine(2, 0, rectangle.width - 3, 0);
            graphics.drawLine(1, 1, 1, 1);
            graphics.drawLine(0, 2, 0, rectangle.height - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(2, 0, rectangle.width - 3, 0);
        } else if (this.m_bDrawLeft) {
            graphics.setColor(Color.white);
            graphics.drawLine(2, 3, rectangle.width - 3, 3);
            graphics.drawLine(1, 4, 1, 4);
            graphics.drawLine(0, 5, 0, rectangle.height - 1);
        } else {
            graphics.setColor(Color.white);
            graphics.drawLine(0, 3, rectangle.width - 3, 3);
        }
        if (this.isActived()) {
            graphics.setColor(Color.darkGray);
            graphics.drawLine(rectangle.width - 2, 2, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, 1);
            graphics.drawLine(rectangle.width - 1, 2, rectangle.width - 1, rectangle.height - 1);
        } else if (this.m_bDrawRight) {
            graphics.setColor(Color.darkGray);
            graphics.drawLine(rectangle.width - 2, 5, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(Color.black);
            graphics.drawLine(rectangle.width - 2, 4, rectangle.width - 2, 4);
            graphics.drawLine(rectangle.width - 1, 5, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.setColor(Color.white);
            graphics.drawLine(2, 3, rectangle.width - 1, 3);
        }
        if (!this.isActived()) {
            graphics.setColor(Color.white);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.setColor(this.getBackground());
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, 1, rectangle.width - 1, 1);
            graphics.drawLine(0, 2, rectangle.width - 1, 2);
        }
    }

    public void active() {
        if (!this.isActived()) {
            this.setFont(this.active);
            super.reshape(this.tab_x, this.tab_y, this.tab_width, this.tab_height);
            this.centerText(this.active);
            this.repaint();
            this.m_bActive = true;
        }
    }

    public void SetDrawRight(boolean bl) {
        this.m_bDrawRight = bl;
        this.repaint();
    }

    public Dimension preferredSize() {
        try {
            if (this.img != null) {
                return new Dimension(this.img.getWidth(this) + 4, this.img.getHeight(this) + 4);
            }
            if (this.label != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.active);
                FontMetrics fontMetrics2 = this.getFontMetrics(this.inactive);
                int n = fontMetrics.stringWidth(this.label) > fontMetrics2.stringWidth(this.label) ? fontMetrics.stringWidth(this.label) : fontMetrics2.stringWidth(this.label);
                int n2 = fontMetrics.getMaxAscent() > fontMetrics2.getMaxAscent() ? fontMetrics.stringWidth(this.label) : fontMetrics2.stringWidth(this.label);
                int n3 = fontMetrics.getDescent() > fontMetrics2.getDescent() ? fontMetrics.getDescent() : fontMetrics2.getDescent();
                return new Dimension(n += 20, n2 += 8 + n3);
            }
            return new Dimension(20, 20);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new Dimension(20, 20);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.target == this) {
            if (event.id == 501) {
                this.requestFocus();
            } else if (event.id == 1005) {
                this.m_bFocused = false;
                this.repaint();
            } else if (event.id == 1004) {
                this.m_bFocused = true;
                this.repaint();
            } else if (event.key == 1006 && event.id == 403) {
                if (this.m_manager != null) {
                    return this.m_manager.GoPrev(this);
                }
            } else if (event.key == 1007 && event.id == 403 && this.m_manager != null) {
                return this.m_manager.GoNext(this);
            }
        }
        return super.handleEvent(event);
    }

    public void SetDrawLeft(boolean bl) {
        this.m_bDrawLeft = bl;
        this.repaint();
    }
}

