; master library - VGA 16color - trapezoid - noclip
;
; Description:
;	`hԂ(ES:`Ώ)
;
; Subroutines:
;	vgc_draw_trapezoidx
;
; Variables:
;	trapez_a, trapez_b	``ƕϐ
;
; Binding Target:
;	asm routine
;
; Running Target:
;	VGA/SVGA 16color
;
; Requiring Resources:
;	CPU: 186
;
; Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Notes:
;	E炩ߐF≉Z[h vgc_setcolor()Ŏw肵ĂB
;	ENbsO͈؂܂B
;	EӓmĂƁA`܂B
;
; Author:
;	ˏF
;
; ֘A֐:
;
; Revision History:
;	92/3/21 Initial
;	92/3/29 bug fix, `ɑӂ̌F߂悤ɂ
;	92/4/2 X
;	92/4/18 Op`ٰ݂番BدݸޕtB
;	92/4/19 X
;	92/5/7 ȏɂ
;	92/5/20 CӸدݸނ̉ɂΉB:-)
;	92/5/22 ȏ`
;	92/6/4	grcg_trapezoid()֐gc_zoid.asmɕB
;	92/6/5	bugfix(make_lineworkCX0̎div 0)
;	92/6/5	[NbvΉ
;	92/6/12 `
;	92/6/16 TASMɑΉ
;	92/7/10 NbsOӌ(koizoidx.asm)
;	92/7/14 
;	92/7/17 ŏ̓_xƕςɂȂĂbugfix...(;_;)
;		x́A 1dot̕sȐ}`͂x
;	93/3/2 (>_<)<-ӖȂ
;	93/ 5/29 [M0.18] .CONST->.DATA
;	94/ 2/23 [M0.23] make_lineworkEXTRN폜(ꂾ(^^;)
;	94/ 4/ 9 Initial: vgczoidx.asm/master.lib 0.23

	.186

	.MODEL SMALL

; LINEWORK\̂̊eo̒`
;   - ̾ - 
x	= 0	; ݂xW
dlx	= 2	; 덷ϐւ̉Zl
s	= 4	; 덷ϐ
d	= 6	; ŏړ(t)

	.DATA

	EXTRN	EDGES:WORD

	; ``pϐ
	EXTRN trapez_a: WORD, trapez_b: WORD
	EXTRN graph_VramWidth: WORD

	.CODE
	include vgc.inc

;-------------------------------------------------------------------------
; draw_trapezoidx - `̕` i@\팸j
; IN:
;	SI : unsigned yadr	; `悷Op`̏̃C̍[VRAM̾
;	DX : unsigned ylen	; `悷Op`̏㉺̃C(y2-y1)
;	ES : unsigned gseg	; `悷VRAM̃ZOg(ClipYT_seg)
;	trapez_a		; ax̏lƌX
;	trapez_b		; bx̏lƌX
; BREAKS:
;	AX,BX,CX,DX,SI,DI,flags
;
	public vgc_draw_trapezoidx
vgc_draw_trapezoidx	PROC NEAR
	push	BP
	mov	AX,graph_VramWidth
	mov	CS:add_width,AX

	mov	AX,[trapez_a+d]
	mov	CS:trapez_a_d,AX
	mov	AX,[trapez_b+d]
	mov	CS:trapez_b_d,AX

	mov	AX,[trapez_a+dlx]
	mov	CS:trapez_a_dlx,AX
	mov	AX,[trapez_b+dlx]
	mov	CS:trapez_b_dlx,AX

	jmp	$+2		; break pipeline

	mov	BP,[trapez_a+x]
	mov	CX,[trapez_b+x]

	EVEN
YLOOP:
	;  (without clipping) start ===================================
	; IN: SI... x=0̎VRAM ADDR(y*80)	BP,CX... xW
	mov	BX,BP

	sub	CX,BX		; CX := bitlen
				; BX := left-x
	sbb	AX,AX
	xor	CX,AX
	sub	CX,AX
	and	AX,CX
	sub	BX,AX

	mov	DI,BX		; addr := yaddr + xl div 8
	shr	DI,3
	add	DI,SI

	and	BX,7		; BX := xl and 7
	add	CX,BX
	shl	BX,1
	mov	AL,byte ptr [EDGES+BX]	; GbW
	not	AX

	mov	BX,CX		;
	and	BX,7
	shl	BX,1

	shr	CX,3
	jz	short LASTW

	test	ES:[DI],AL
	stosb

	mov	AL,0ffh
	dec	CX
	jz	short REPSTOSB2
REPSTOSB:
	or	ES:[DI],AL
	inc	DI
	loop	short REPSTOSB
REPSTOSB2:
LASTW:	and	AL,byte ptr [EDGES+2+BX]	; EGbW
	test	ES:[DI],AL
	mov	ES:[DI],AL
	;  (without clipping) end ===================================

	add	[trapez_b+s],1234h
	org $-2
trapez_b_dlx	dw ?
	mov	CX,[trapez_b+x]
	adc	CX,1234h
	org $-2
trapez_b_d	dw ?
	mov	[trapez_b+x],CX

	add	[trapez_a+s],1234h
	org $-2
trapez_a_dlx	dw ?
	adc	BP,1234h
	org $-2
trapez_a_d	dw ?

	add	SI,1234h		; yadr
	org $-2
add_width	dw ?
	dec	DX			; ylen
	jns	short YLOOP

	mov	[trapez_a+x],BP
	pop	BP
	ret
vgc_draw_trapezoidx	ENDP

END
