#!/usr/bin/perl
use strict;
use File::Basename;

my $samplesdir="../samples";
my @sub;
navigate(".");
foreach my $d ( sort @sub )
{
  process($d);
}
@sub=();

sub navigate {
	my ($dir) = @_;

	opendir(DIR,$dir);
	foreach my $d ( readdir(DIR) )
	{
		next if($d =~ /^\./);

		if(-d "$dir/$d")
		{
			push @sub , "$dir/$d";
			navigate("$dir/$d");
		}
	}
	closedir(DIR);
}

sub process_samples {
	my ($out) = @_;
    my @files;
	my $dir=$samplesdir;

	opendir(DIR,$dir);
	foreach my $d ( readdir(DIR) )
	{
		#next if($d =~ /^\./);

		unless (-d $d) {
			push @files, "../$dir/$d" if($d =~ /\.(tmpl)$/);
		}

	}
	closedir(DIR);

	if(@files)
	{
		foreach my $f ( sort @files )
		{
			my $filename = fileparse($f);
			print $out "\\\n\t$filename ";
		}
		print $out "\n\n";
		foreach my $f ( sort @files )
		{
			my $filename = fileparse($f);
			print $out "$filename: $f\n";
			print $out "\tcp -f $f .\n\n";
		}
		print $out "\n\n";
	}


}
sub process {
	my ($dir) = @_;
    my @files;
	my $out;

	opendir(DIR,$dir);
	foreach my $d ( readdir(DIR) )
	{
		next if($d =~ /^\./);

		unless (-d $d) {
			push @files, $d if($d =~ /\.(tmpl)$/);
		}

	}
	closedir(DIR);

	if(@files)
	{
		my $name;
		$dir  =~ s/^\.\///;
		$name = "$dir";
		$name =~ s/\W/_/g;
		my $makefile="$name/Makefile.am";

		system("p4 edit $makefile");
		open($out,"> $makefile") or die "unable to open $makefile: $!";

		print $out "#This file is generated by make_makefile_am.pl\n";
		print $out "#  DON'T EDIT!!!\n\n";
		print $out $name."dir = \@IFS_SAMPLES_DIR\@/$name\n\n";
		print $out "dist_".$name."_DATA = ";

		foreach my $f ( sort @files )
		{
			print $out "\\\n\t$f ";
		}
		print $out "\n\n";
		print $out "nodist_".$name."_DATA = ";
		process_samples($out);
		print $out "\n";
		close($out);
	}


}
