/* -----------------------------------------------------------------------------
 * krb5help.h declares Kerberos version 5 helper APIs.
 *
 * Author: Frank Balluffi
 *
 * Copyright (C) 2002-2005 Frank Balluffi. All rights reserved.
 * -----------------------------------------------------------------------------
 */

#ifndef KRB5HELP_H
#define KRB5HELP_H

#ifdef __cplusplus
extern "C" {
#endif

#include <openssl/asn1.h>

/* Object identifier declarations. */

/*
RFC 1964 defines the Kerberos V5 GSS-API mechanism as 1.2.840.113554.1.2.2. For
some reason, Microsoft defines the Kerberos V5 GSS-API Legacy mechanism as
1.2.840.48018.1.2.2 (see
http://msdn.microsoft.com/library/en-us/dnsecure/html/http-sso-2.asp). Note that
the object identifiers differ by one bit. One possible explanation is that
Microsoft made a mistake and then needed to provide backward compatibility.
*/

extern const ASN1_OBJECT krb5GssApi;         /* 1.2.840.113554.1.2.2 */
extern const ASN1_OBJECT msKrb5GssApiLegacy; /* 1.2.840.48018.1.2.2 */

#ifdef __cplusplus
}
#endif

#endif /* KRB5HELP_H */
