#! /usr/local/bin/gosh
(use readline)
(use readline.history)
(use readline.keymap)
(use readline.term-util)
(use gauche.interactive)

(define (unfinished? s)
  (with-error-handler
   (lambda (e) (string=? (slot-ref e 'message) "EOF inside a list"))
   (lambda ()
     (let loop ((p (open-input-string s)))
       (if (not (eof-object? (read s2)))
           (loop p))))))

(define (%%repl p)
  (let1 t (read p)
    (unless (eof-object? t)
      (write (eval t (current-module)))
      (newline)
      (%%repl p))))

(define (%repl state s)
  (let* ((new-state (readline state))
         (new-s (string-append s (hash-table-get new-state 'string))))
    (newline)
    (if (unfinished? new-s)
        (%repl new-state new-s)
        (begin
          (%%repl (open-input-string new-s))
          new-state))))

(define (repl)
  (let loop ((state #f))
    (display "gosh> ") (flush)
    (let1 new-state (%repl state "")
      (loop new-state))))
  
(define (main _)
  (with-immediate-input repl))

(hash-table-put! *readline-keymap* (char->control #\x)
  (lambda (state spec exit2) (exit 0)))

