#!/bin/sh
# Copyright (c) 2008 David Soria Parra <dsp at php dot net>
#
# Licensed under the terms of the MIT License
# See /usr/share/doc/gcutils/copyright
# or http://www.opensource.org/licenses/mit-license.php
unset CDPATH

VERSION="$VERSION$"
PROGNAME="$PROGNAME$"

die()
{
        echo >&2 "$@"
        exit 127
}

check_git ()
{
    git --version > /dev/null

    if test $? != 0
    then
        die "Git not found. It's either not installed or not in \$PATH"
    fi

    version=`git --version | grep -o -E "[12]\.([5]\.([0-9]{2,}|[3-9]+)|[6-9]\.[0-9]+)"`
    if test -z "$version"
    then
        die "Wrong git version. $prog needs git 1.5.3 or higher, but "`git --version`" found."
    fi
}

version ()
{
    echo "$PROGNAME: "`basename $0`-$VERSION
}

locate_git_repo ()
{
    gitdir=`git rev-parse --git-dir 2> /dev/null`
    test "$gitdir" = "" && die "Please use this command from a git working tree."
    cd $gitdir/..
}
