#!/bin/bash
TESTS="gc-commit.sh depth.sh gc-import.sh gc-import-r.sh gc-import-u.sh gc-import-v.sh gc-import-gu.sh gc-update.sh gc-update-cn.sh"

success ()
{
    echo -n "."
}

failure () 
{ 
    echo -n "F"
    exit 127
}


verbose=
while test $# != 0
do
    case "$1" in
        -v)
            verbose="-v"
            ;;
    esac
    shift
done

TESTDIR=`pwd`
for test in $TESTS
do   
    cd $TESTDIR
    if test -z "$verbose"
    then
	bash $test 2>tests.log 1>/dev/null
    else
	echo "#################### $test ######################"
	bash $test
    fi

    if test $? -ne 0
    then
	cd $TESTDIR && bash cleanup.sh > /dev/null
	failure 
    else
	cd $TESTDIR && bash cleanup.sh > /dev/null
	success
    fi
done
