/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.MathUtils;
import org.junit.Assert;
import org.junit.Test;

public class MathUtilsTest {
    @Test
    public void lerpAngleDeg() {
        Assert.assertEquals((float)10.0f, (float)MathUtils.lerpAngleDeg(10.0f, 30.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)20.0f, (float)MathUtils.lerpAngleDeg(10.0f, 30.0f, 0.5f), (float)0.01f);
        Assert.assertEquals((float)30.0f, (float)MathUtils.lerpAngleDeg(10.0f, 30.0f, 1.0f), (float)0.01f);
    }

    @Test
    public void lerpAngleDegCrossingZero() {
        Assert.assertEquals((float)350.0f, (float)MathUtils.lerpAngleDeg(350.0f, 10.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.lerpAngleDeg(350.0f, 10.0f, 0.5f), (float)0.01f);
        Assert.assertEquals((float)10.0f, (float)MathUtils.lerpAngleDeg(350.0f, 10.0f, 1.0f), (float)0.01f);
    }

    @Test
    public void lerpAngleDegCrossingZeroBackwards() {
        Assert.assertEquals((float)10.0f, (float)MathUtils.lerpAngleDeg(10.0f, 350.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.lerpAngleDeg(10.0f, 350.0f, 0.5f), (float)0.01f);
        Assert.assertEquals((float)350.0f, (float)MathUtils.lerpAngleDeg(10.0f, 350.0f, 1.0f), (float)0.01f);
    }

    @Test
    public void testNorm() {
        Assert.assertEquals((float)-1.0f, (float)MathUtils.norm(10.0f, 20.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)0.0f, (float)MathUtils.norm(10.0f, 20.0f, 10.0f), (float)0.01f);
        Assert.assertEquals((float)0.5f, (float)MathUtils.norm(10.0f, 20.0f, 15.0f), (float)0.01f);
        Assert.assertEquals((float)1.0f, (float)MathUtils.norm(10.0f, 20.0f, 20.0f), (float)0.01f);
        Assert.assertEquals((float)2.0f, (float)MathUtils.norm(10.0f, 20.0f, 30.0f), (float)0.01f);
    }

    @Test
    public void testMap() {
        Assert.assertEquals((float)0.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 0.0f), (float)0.01f);
        Assert.assertEquals((float)100.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 10.0f), (float)0.01f);
        Assert.assertEquals((float)150.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 15.0f), (float)0.01f);
        Assert.assertEquals((float)200.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 20.0f), (float)0.01f);
        Assert.assertEquals((float)300.0f, (float)MathUtils.map(10.0f, 20.0f, 100.0f, 200.0f, 30.0f), (float)0.01f);
    }
}

