/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.utils.Array;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterRow;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Line;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterStats;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.util.Menu;

public class MonsterStatsCard
extends Table {
    private final MonsterRow row;
    private MonsterData data;
    private final Drawable normalOverlay = App.skin.getDrawable("psd/monsterStats-normal-overlay");
    private final Drawable eliteOverlay = App.skin.getDrawable("psd/monsterStats-elite-overlay");
    private final Drawable bossOverlay = App.skin.getDrawable("psd/monsterStats-boss-overlay");
    private final Drawable flyingStatDrawable = App.skin.getDrawable("psd/flying-stat");
    private final Drawable curseDrawable = App.skin.getDrawable("abilities/curse-medium");
    private final Drawable pushDrawable = App.skin.getDrawable("abilities/push-medium");
    private final Drawable pullDrawable = App.skin.getDrawable("abilities/pull-medium");
    private TextureRegion levelRegion = App.skin.getRegion("psd/level-white");
    private float normalDim = 1.0f;
    private float eliteDim = 1.0f;
    final ClickListener clickListener;

    public MonsterStatsCard(MonsterRow row) {
        super(App.skin);
        this.row = row;
        this.data = row.data;
        this.background("psd/monsterStats-" + (this.data.isBoss() ? "boss" : "normal"));
        this.setTouchable(Touchable.enabled);
        this.clickListener = new ClickListener();
        this.addListener(this.clickListener);
    }

    @Override
    public void act(float delta) {
        float eliteTarget = 1.0f;
        float normalTarget = 1.0f;
        boolean hasElite = this.row.hasElite();
        boolean hasNormal = this.row.hasNormal();
        if (this.clickListener.isPressed()) {
            hasElite = true;
            hasNormal = true;
        } else if (!App.state.hideStats) {
            eliteTarget = 0.0f;
            normalTarget = 0.0f;
        }
        if (Menu.menusShown == 0) {
            this.eliteDim = App.animate(this.eliteDim, hasElite ? 0.0f : eliteTarget, 0.25f, 2.0f, 0.25f, delta);
            this.normalDim = App.animate(this.normalDim, hasNormal ? 0.0f : normalTarget, 0.25f, 2.0f, 0.25f, delta);
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        int fontX;
        boolean disableDesatShader;
        boolean bl = disableDesatShader = batch.getShader() == App.desatShader && this.clickListener.isPressed();
        if (disableDesatShader) {
            batch.setShader(null);
        }
        super.draw(batch, parentAlpha);
        MonsterStatsCard.drawLevel(batch, this.levelRegion, this.x(204.0f), this.y(202.0f), this.row.level, this.row.levelString, parentAlpha);
        int n = fontX = App.config.language.equals("en") || App.config.language.equals("pl") || App.config.language.equals("cz") || App.config.language.equals("de") || App.config.language.equals("fr") || App.config.language.equals("it") ? 0 : -4;
        if (this.data.isBoss()) {
            if (this.data.flying) {
                this.flyingStatDrawable.draw(batch, this.x(152.0f), this.y(86.0f), 37.0f, 40.0f);
            }
            if (this.normalDim != 1.0f) {
                Line notes;
                Line line;
                Array<Line> special;
                float a = (1.0f - this.normalDim) * parentAlpha;
                batch.setColor(1.0f, 1.0f, 1.0f, a);
                MonsterStats boss = this.data.stats[MonsterType.boss.ordinal()][this.row.level];
                float x = this.x(9.0f);
                float y = this.y(49.0f);
                int i = 0;
                for (Condition condition : boss.immunities) {
                    condition.drawableMedium.draw(batch, x, y, 28.0f, 28.0f);
                    if (i % 2 == 0) {
                        x += 14.0f;
                    }
                    y += (float)(i % 2 == 0 ? 14 : -28);
                    ++i;
                }
                if (boss.immunePush) {
                    this.pushDrawable.draw(batch, x, y, 28.0f, 28.0f);
                    if (i % 2 == 0) {
                        x += 14.0f;
                    }
                    y += (float)(i % 2 == 0 ? 14 : -28);
                    ++i;
                }
                if (boss.immunePull) {
                    this.pullDrawable.draw(batch, x, y, 28.0f, 28.0f);
                }
                if (boss.immuneCurse) {
                    this.curseDrawable.draw(batch, x, y, 28.0f, 28.0f);
                    if (i % 2 == 0) {
                        x += 14.0f;
                    }
                    y += (float)(i % 2 == 0 ? 14 : -28);
                    ++i;
                }
                int startX = 202;
                int startY = 15;
                int space = 20;
                if (this.data.id == -37) {
                    startX -= 8;
                    startY -= 4;
                    space -= 2;
                } else if (this.data.id == -38) {
                    startX -= 5;
                    startY -= 5;
                    space = -9;
                } else if (this.data.id == -39) {
                    startY -= 5;
                } else if (this.data.id == -40) {
                    startX -= 5;
                    space += 37;
                } else if (this.data.id == -41) {
                    startX += 10;
                    startY -= 6;
                    space -= 4;
                } else if (this.data.id == -42) {
                    startX -= 4;
                    --startY;
                    space += 15;
                } else if (this.data.id == -43) {
                    startX -= 6;
                    startY -= 4;
                } else if (this.data.id == -46) {
                    startX -= 10;
                    startY -= 8;
                    space += 21;
                } else if (this.data.id == -47) {
                    startX -= 9;
                    startY -= 8;
                    space -= 8;
                } else if (this.data.id == -45) {
                    startX -= 7;
                    startY -= 9;
                    space -= 6;
                } else if (this.data.id == -54) {
                    startX -= 18;
                    startY -= 8;
                    space -= 6;
                } else if (this.data.id == -55) {
                    startX -= 16;
                    startY -= 8;
                    space -= 9;
                } else if (this.data.id == -68) {
                    startX -= 16;
                    startY -= 8;
                    space -= 9;
                } else if (this.data.id == -69) {
                    startX -= 14;
                    startY -= 8;
                    space -= 9;
                }
                int numberX = startX;
                int numberY = 4;
                if (App.config.isRussian()) {
                    startX = Math.min(192, startX);
                    startY = Math.min(7, startY);
                    numberX = startX + 2;
                    numberY = 2;
                }
                batch.setColor(1.0f, 1.0f, 1.0f, a);
                App.plainSmallOutline.setColor(1.0f, 1.0f, 1.0f, a);
                float x2 = this.x(startX + 22);
                float y2 = this.y(startY);
                float height = 0.0f;
                Line.loadAttributeLines(this.data, boss, true);
                int i2 = 0;
                int n2 = boss.attributeLines.size;
                while (i2 < n2) {
                    Line line2 = boss.attributeLines.get(i2);
                    line2.draw(batch, x2, y2 - line2.height, this.data, a);
                    height += line2.height;
                    ++i2;
                }
                if (boss.attributeLines.notEmpty()) {
                    y2 -= height + (float)space;
                }
                height = 0.0f;
                Array<Line> array = special = App.state.calculateStats ? boss.specialCalculated1 : boss.special1;
                if (special.size > 0) {
                    App.plainSmallOutline.draw(batch, "1:", this.x(numberX), y2 + (float)numberY, 0.0f, 8, false);
                }
                Line.loadSpecialLines(this.data, boss);
                int i3 = 0;
                int n3 = special.size;
                while (i3 < n3) {
                    line = special.get(i3);
                    if (i3 != 0) {
                        height += line.spaceTop;
                    }
                    this.drawSpecialLine(line, batch, x2, y2, boss, a);
                    height += line.height;
                    ++i3;
                }
                y2 -= height + (float)space;
                height = 0.0f;
                Array<Line> array2 = special = App.state.calculateStats ? boss.specialCalculated2 : boss.special2;
                if (special.size > 0) {
                    App.plainSmallOutline.draw(batch, "2:", this.x(numberX), y2 + (float)numberY, 0.0f, 8, false);
                }
                i3 = 0;
                n3 = special.size;
                while (i3 < n3) {
                    line = special.get(i3);
                    if (i3 != 0) {
                        height += line.spaceTop;
                    }
                    this.drawSpecialLine(line, batch, x2, y2, boss, a);
                    height += line.height;
                    ++i3;
                }
                y2 -= height + (float)space;
                Line line3 = notes = App.state.calculateStats ? boss.notesCalculated : boss.notes;
                if (notes != null) {
                    this.drawSpecialLine(notes, batch, x2, y2, boss, a);
                }
                App.plainLargeFixedNumbers.setColor(0.0f, 0.0f, 0.0f, a);
                String hpMax = boss.hpMax;
                if (App.state.calculateStats && hpMax.contains("xC")) {
                    hpMax = Integer.toString(boss.hpMax());
                }
                App.plainLargeFixedNumbers.draw(batch, hpMax, this.x(145.0f), this.y(17 + fontX), 0.0f, 16, false);
                App.plainLargeFixedNumbers.draw(batch, boss.move, this.x(145.0f), this.y(58 + fontX), 0.0f, 16, false);
                String attack = boss.attack;
                if (App.state.calculateStats && attack.endsWith("C")) {
                    attack = Integer.toString(boss.attack());
                }
                App.plainLargeFixedNumbers.draw(batch, attack, this.x(145.0f), this.y(100 + fontX), 0.0f, 16, false);
                App.plainLargeFixedNumbers.draw(batch, boss.range, this.x(145.0f), this.y(140 + fontX), 0.0f, 16, false);
            }
        } else {
            float y;
            float x;
            float a;
            if (this.data.flying) {
                this.flyingStatDrawable.draw(batch, this.x(202.0f), this.y(82.0f), 37.0f, 40.0f);
            }
            if (this.normalDim != 1.0f) {
                a = (1.0f - this.normalDim) * parentAlpha;
                batch.setColor(1.0f, 1.0f, 1.0f, a);
                MonsterStats normal = this.data.stats[MonsterType.normal.ordinal()][this.row.level];
                App.plainSmall.setColor(0.0f, 0.0f, 0.0f, a);
                x = this.x(22.0f);
                y = this.y(12.0f);
                Line.loadAttributeLines(this.data, normal, false);
                int i = 0;
                int n4 = normal.attributeLines.size;
                while (i < n4) {
                    Line line = normal.attributeLines.get(i);
                    line.draw(batch, x, y - line.height, this.data, a);
                    ++i;
                }
                App.plainLargeFixedNumbers.setColor(0.0f, 0.0f, 0.0f, a);
                App.plainLargeFixedNumbers.draw(batch, normal.hpMax, this.x(182.0f), this.y(15 + fontX), 0.0f, 1, false);
                App.plainLargeFixedNumbers.draw(batch, normal.move, this.x(182.0f), this.y(54 + fontX), 0.0f, 1, false);
                App.plainLargeFixedNumbers.draw(batch, normal.attack, this.x(182.0f), this.y(96 + fontX), 0.0f, 1, false);
                App.plainLargeFixedNumbers.draw(batch, normal.range, this.x(182.0f), this.y(138 + fontX), 0.0f, 1, false);
            }
            if (this.eliteDim != 1.0f) {
                Line line;
                a = (1.0f - this.eliteDim) * parentAlpha;
                batch.setColor(1.0f, 1.0f, 1.0f, a);
                MonsterStats elite = this.data.stats[MonsterType.elite.ordinal()][this.row.level];
                App.plainSmall.setColor(1.0f, 1.0f, 1.0f, a);
                x = this.x(289.0f);
                y = this.y(12.0f);
                float maxX = this.x(437.0f);
                Line.loadAttributeLines(this.data, elite, true);
                int i = 0;
                int n5 = elite.attributeLines.size;
                while (i < n5) {
                    line = elite.attributeLines.get(i);
                    if (x + line.width > maxX) {
                        x = maxX - line.width;
                    }
                    ++i;
                }
                i = 0;
                n5 = elite.attributeLines.size;
                while (i < n5) {
                    line = elite.attributeLines.get(i);
                    line.draw(batch, x, y - line.height, this.data, a);
                    ++i;
                }
                x = this.x(260.0f);
                App.plainLargeOutlineFixedNumbers.setColor(1.0f, 1.0f, 1.0f, a);
                App.plainLargeOutlineFixedNumbers.draw(batch, elite.hpMax, x, this.y(15 + fontX), 0.0f, 1, false);
                App.plainLargeOutlineFixedNumbers.draw(batch, elite.move, x, this.y(54 + fontX), 0.0f, 1, false);
                App.plainLargeOutlineFixedNumbers.draw(batch, elite.attack, x, this.y(96 + fontX), 0.0f, 1, false);
                App.plainLargeOutlineFixedNumbers.draw(batch, elite.range, x, this.y(138 + fontX), 0.0f, 1, false);
            }
            if (this.normalDim != 1.0f || this.eliteDim != 1.0f) {
                if (this.eliteDim > 0.0f) {
                    batch.setColor(0.0f, 0.0f, 0.0f, 0.4f * this.eliteDim * parentAlpha);
                    this.eliteOverlay.draw(batch, this.x(220.0f), this.y(182.0f), 219.0f, 181.0f);
                }
                if (this.normalDim > 0.0f) {
                    batch.setColor(0.0f, 0.0f, 0.0f, 0.4f * this.normalDim * parentAlpha);
                    this.normalOverlay.draw(batch, this.x(2.0f), this.y(182.0f), 219.0f, 181.0f);
                }
            }
        }
        if (this.data.isBoss() || this.normalDim == 1.0f && this.eliteDim == 1.0f) {
            batch.setColor(0.0f, 0.0f, 0.0f, 0.4f * this.normalDim * parentAlpha);
            this.bossOverlay.draw(batch, this.x(2.0f), this.y(182.0f), 437.0f, 181.0f);
        }
        if (disableDesatShader) {
            batch.setShader(App.desatShader);
        }
    }

    private void drawSpecialLine(Line line, Batch batch, float x, float y, MonsterStats stats, float a) {
        for (Line.LinePart part : line.parts) {
            if (part instanceof Line.TextPart) {
                Line.TextPart textPart = (Line.TextPart)part;
                String text = textPart.text;
                int index = text.indexOf("!!");
                if (index != -1) {
                    int attack = stats.attack() + Integer.parseInt(text.substring(index + 3, index + 4)) * (text.charAt(index + 2) == '-' ? -1 : 1);
                    text = String.valueOf(text.substring(0, index)) + attack + text.substring(index + 4);
                    line.font.draw(batch, text, x + line.x + part.x, y + line.y + part.y + textPart.layout.height);
                    continue;
                }
            }
            part.draw(batch, line, x, y, this.data, a);
        }
    }

    private float x(float value) {
        return this.getX() + value;
    }

    private float y(float value) {
        return this.getY() + 209.0f - value;
    }

    public static void drawLevel(Batch batch, TextureRegion levelRegion, float x, float y, int level, String levelString, float a) {
        batch.setColor(App.c(App.lightGray, a));
        batch.draw(levelRegion, x, y);
        App.plainSmall.setColor(0.0f, 0.0f, 0.0f, a);
        float levelX = 16.0f;
        if (level == 0 || level == 1 || level == 4 || level == 6) {
            levelX -= 1.0f;
        }
        App.plainSmall.draw(batch, levelString, x + levelX, y + 16.0f, 0.0f, 1, false);
    }
}

