/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.tcpserver;

import com.esotericsoftware.minlog.Log;
import com.esotericsoftware.tcpserver.BroadcastServer;
import com.esotericsoftware.tcpserver.Retry;
import com.esotericsoftware.tcpserver.Util;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.Enumeration;

public class BroadcastClient
extends Retry {
    private int port;
    private int timeoutMillis = 3000;
    private final byte[] receive = new byte[BroadcastServer.prefix.length];
    private final byte[] request = new byte[BroadcastServer.prefix.length];

    public BroadcastClient(String category, String name) {
        this(category, name, 0);
    }

    public BroadcastClient(String category, String name, int port) {
        super(category, name);
        this.port = port;
        this.setRetryDelays(6);
    }

    @Override
    protected void retry() {
        DatagramPacket packet = BroadcastClient.find(this.port, this.timeoutMillis, this.requestBuffer(), this.receiveBuffer());
        if (this.running && packet != null) {
            this.received(packet);
        }
        this.failed();
    }

    protected byte[] requestBuffer() {
        return this.request;
    }

    protected byte[] receiveBuffer() {
        return this.receive;
    }

    protected void received(DatagramPacket packet) {
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeoutMillis;
    }

    public void setTimeout(int millis) {
        this.timeoutMillis = millis;
    }

    public static DatagramPacket find(int port, int timeoutMillis) {
        byte[] request = new byte[BroadcastServer.prefix.length + 4];
        byte[] receive = new byte[BroadcastServer.prefix.length];
        return BroadcastClient.find(port, timeoutMillis, request, receive);
    }

    public static DatagramPacket find(int port, int timeoutMillis, byte[] requestBuffer, byte[] receiveBuffer) {
        System.arraycopy(BroadcastServer.prefix, 0, requestBuffer, 0, BroadcastServer.prefix.length);
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> addresses = iface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    byte[] ip = addresses.nextElement().getAddress();
                    ip[3] = -1;
                    try {
                        socket.send(new DatagramPacket(requestBuffer, requestBuffer.length, InetAddress.getByAddress(ip), port));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ip[2] = -1;
                    try {
                        socket.send(new DatagramPacket(requestBuffer, requestBuffer.length, InetAddress.getByAddress(ip), port));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (Log.DEBUG) {
                Log.debug("broadcast", "Broadcasted on port: UDP " + port);
            }
            socket.setSoTimeout(timeoutMillis);
            DatagramPacket packet = new DatagramPacket(receiveBuffer, receiveBuffer.length);
            try {
                socket.receive(packet);
            }
            catch (SocketTimeoutException ex) {
                if (Log.DEBUG) {
                    Log.debug("broadcast", "Host discovery timed out.");
                }
                Util.closeQuietly(socket);
                return null;
            }
            int i = 0;
            int n = BroadcastServer.prefix.length;
            while (i < n) {
                if (receiveBuffer[i] != BroadcastServer.prefix[i]) {
                    if (Log.DEBUG) {
                        StringBuilder buffer = new StringBuilder();
                        i = 0;
                        while (i < n) {
                            buffer.append(String.valueOf(Integer.toHexString(receiveBuffer[i])) + " ");
                            ++i;
                        }
                        buffer.setLength(buffer.length() - 1);
                        Log.debug("broadcast", "Client received invalid packet, prefix: " + buffer);
                    }
                    return null;
                }
                ++i;
            }
            if (Log.INFO) {
                Log.info("broadcast", "Discovered server: " + packet.getAddress());
            }
            DatagramPacket datagramPacket = packet;
            return datagramPacket;
        }
        catch (IOException ex) {
            if (Log.ERROR) {
                Log.error("broadcast", "Host discovery failed.", ex);
            }
            return null;
        }
        finally {
            Util.closeQuietly(socket);
        }
    }
}

