// Gmsh - Copyright (C) 1997-2019 C. Geuzaine, J.-F. Remacle
//
// See the LICENSE.txt file for license information. Please report all
// issues on https://gitlab.onelab.info/gmsh/gmsh/issues.

// code to generate this file (using alglib) :
#if 0
//alglib
#include "ap.h"
#include "gq.h"
int main(int argc, char **argv)
{
  int maxA = 4;
  int maxN = 20;
  ap::real_1d_array x, w;
  int info;
  for (int n = 1; n <= maxN; n++) {
    printf("static double _gaussJacobiPt_%i[%i][%i][%i] = {\n", n, maxA + 1, maxA + 1, n);
    for (int a = 0; a <= maxA; a++) {
      printf("  { // a = %i\n", a);
      for (int b = 0; b <= maxA; b++) {
        gqgenerategaussjacobi(n, a, b, info, x, w);
        printf("    {");
        for (int i = 0; i < n-1; ++i) {
          printf("% .15e, ", x(i));
        }
        printf("% .15e", x(n-1));
        if (b != maxA)
          printf("},\n");
        else
          printf("}\n");
      }
      if (a != maxA)
        printf("  },\n");
      else
        printf("  }\n");
    }
    printf("};\n");
  }
  printf("\n");
  for (int n = 1; n <= maxN; n++) {
    printf("static double _gaussJacobiWt_%i[%i][%i][%i] = {\n", n, maxA + 1, maxA + 1, n);
    for (int a = 0; a <= maxA; a++) {
      printf("  { // a = %i\n", a);
      for (int b = 0; b <= maxA; b++) {
        gqgenerategaussjacobi(n, a, b, info, x, w);
        printf("    {");
        for (int i = 0; i < n-1; ++i) {
          printf("% .15e, ", w(i));
        }
        printf("% .15e", w(n-1));
        if (b != maxA)
          printf("},\n");
        else
          printf("}\n");
      }
      if (a != maxA)
        printf("  },\n");
      else
        printf("  }\n");
    }
    printf("};\n");
  }
  printf("\n");
  printf(
    "void getGaussJacobiQuadrature(int a, int b, int n, double **pt, double **wt)\n"
    "{\n"
    "  *pt = NULL;\n"
    "  *wt = NULL;\n"
    "  if(a < 0 || a > %i || b < 0 || b > %i)\n"
    "    Msg::Error(\"Gauss-Jacobi %%i %%i quadrature not available.\", a, b);\n"
    "  switch (n) {\n", maxA, maxA);
  for (int i = 1; i <= maxN; i++) {
    printf("    case %i :\n", i);
    printf("      *pt = _gaussJacobiPt_%i[a][b];\n", i);
    printf("      *wt = _gaussJacobiWt_%i[a][b];\n", i);
    printf("      break;\n", i);
  }
  printf("    default :\n");
  printf("      Msg::Error(\"%%i-points Gauss-Jacobi quadrature not available.\", n);\n");
  printf("  }\n");
  printf("}\n");
}
#endif

#include <stdlib.h>
#include <stdio.h>
#include "GmshMessage.h"
static double _gaussJacobiPt_1[5][5][1] = {{// a = 0
                                            {0.000000000000000e+00},
                                            {3.333333333333333e-01},
                                            {5.000000000000000e-01},
                                            {6.000000000000000e-01},
                                            {6.666666666666666e-01}},
                                           {// a = 1
                                            {-3.333333333333333e-01},
                                            {0.000000000000000e+00},
                                            {2.000000000000000e-01},
                                            {3.333333333333333e-01},
                                            {4.285714285714285e-01}},
                                           {// a = 2
                                            {-5.000000000000000e-01},
                                            {-2.000000000000000e-01},
                                            {0.000000000000000e+00},
                                            {1.428571428571428e-01},
                                            {2.500000000000000e-01}},
                                           {// a = 3
                                            {-6.000000000000000e-01},
                                            {-3.333333333333333e-01},
                                            {-1.428571428571428e-01},
                                            {0.000000000000000e+00},
                                            {1.111111111111111e-01}},
                                           {// a = 4
                                            {-6.666666666666666e-01},
                                            {-4.285714285714285e-01},
                                            {-2.500000000000000e-01},
                                            {-1.111111111111111e-01},
                                            {0.000000000000000e+00}}};
static double _gaussJacobiPt_2[5][5][2] = {
  {// a = 0
   {-5.773502691896257e-01, 5.773502691896257e-01},
   {-2.898979485566356e-01, 6.898979485566357e-01},
   {-8.830368802245062e-02, 7.549703546891172e-01},
   {5.971587178976978e-02, 7.974269853530873e-01},
   {1.726731646460114e-01, 8.273268353539885e-01}},
  {// a = 1
   {-6.898979485566357e-01, 2.898979485566356e-01},
   {-4.472135954999579e-01, 4.472135954999579e-01},
   {-2.612038749637415e-01, 5.469181606780271e-01},
   {-1.159625273557000e-01, 6.159625273556999e-01},
   {-2.775557561562891e-17, 6.666666666666667e-01}},
  {// a = 2
   {-7.549703546891172e-01, 8.830368802245062e-02},
   {-5.469181606780271e-01, 2.612038749637415e-01},
   {-3.779644730092272e-01, 3.779644730092272e-01},
   {-2.402530733520422e-01, 4.624752955742643e-01},
   {-1.265986323710904e-01, 5.265986323710904e-01}},
  {// a = 3
   {-7.974269853530873e-01, -5.971587178976978e-02},
   {-6.159625273556999e-01, 1.159625273557000e-01},
   {-4.624752955742643e-01, 2.402530733520422e-01},
   {-3.333333333333333e-01, 3.333333333333333e-01},
   {-2.240092377397959e-01, 4.058274195579776e-01}},
  {// a = 4
   {-8.273268353539885e-01, -1.726731646460114e-01},
   {-6.666666666666667e-01, 2.775557561562891e-17},
   {-5.265986323710904e-01, 1.265986323710904e-01},
   {-4.058274195579776e-01, 2.240092377397959e-01},
   {-3.015113445777636e-01, 3.015113445777636e-01}}};
static double _gaussJacobiPt_3[5][5][3] = {
  {// a = 0
   {-7.745966692414833e-01, 1.205632815803881e-16, 7.745966692414832e-01},
   {-5.753189235216941e-01, 1.810662711185308e-01, 8.228240809745919e-01},
   {-4.100044197769969e-01, 3.059924679232963e-01, 8.540119518537008e-01},
   {-2.734707395669761e-01, 3.976225383272270e-01, 8.758482012397490e-01},
   {-1.597738813262838e-01, 4.677787104157496e-01, 8.919951709105340e-01}},
  {// a = 1
   {-8.228240809745919e-01, -1.810662711185308e-01, 5.753189235216941e-01},
   {-6.546536707079771e-01, -9.844555726168380e-17, 6.546536707079772e-01},
   {-5.077876295583149e-01, 1.323008207773232e-01, 7.088201421143250e-01},
   {-3.816683386353370e-01, 2.334502967228511e-01, 7.482180419124858e-01},
   {-2.733778240471743e-01, 3.133731347413368e-01, 7.781865074876556e-01}},
  {// a = 2
   {-8.540119518537008e-01, -3.059924679232963e-01, 4.100044197769969e-01},
   {-7.088201421143250e-01, -1.323008207773232e-01, 5.077876295583149e-01},
   {-5.773502691896258e-01, 5.724587470723463e-17, 5.773502691896257e-01},
   {-4.611587037808975e-01, 1.043853303832390e-01, 6.295006461249313e-01},
   {-3.590327974759225e-01, 1.889305092895958e-01, 6.701022881863266e-01}},
  {// a = 3
   {-8.758482012397490e-01, -3.976225383272270e-01, 2.734707395669761e-01},
   {-7.482180419124858e-01, -2.334502967228511e-01, 3.816683386353370e-01},
   {-6.295006461249313e-01, -1.043853303832390e-01, 4.611587037808975e-01},
   {-5.222329678670936e-01, -7.155734338404329e-18, 5.222329678670936e-01},
   {-4.261936288339650e-01, 8.625035138615555e-02, 5.707125082170403e-01}},
  {// a = 4
   {-8.919951709105340e-01, -4.677787104157496e-01, 1.597738813262838e-01},
   {-7.781865074876556e-01, -3.133731347413368e-01, 2.733778240471743e-01},
   {-6.701022881863266e-01, -1.889305092895958e-01, 3.590327974759225e-01},
   {-5.707125082170403e-01, -8.625035138615555e-02, 4.261936288339650e-01},
   {-4.803844614152614e-01, -9.757819552369540e-18, 4.803844614152614e-01}}};
static double _gaussJacobiPt_4[5][5][4] = {
  {// a = 0
   {-8.611363115940525e-01, -3.399810435848561e-01, 3.399810435848563e-01,
    8.611363115940522e-01},
   {-7.204802713124385e-01, -1.671808647378336e-01, 4.463139727237523e-01,
    8.857916077709644e-01},
   {-5.917028357935457e-01, -3.409459020873494e-02, 5.227985248962753e-01,
    9.029989011060053e-01},
   {-4.770444223382206e-01, 7.169289217650020e-02, 5.805664599385740e-01,
    9.156941611322373e-01},
   {-3.757290143059655e-01, 1.578313191246453e-01, 6.257830332324487e-01,
    9.254479952822050e-01}},
  {// a = 1
   {-8.857916077709644e-01, -4.463139727237523e-01, 1.671808647378336e-01,
    7.204802713124385e-01},
   {-7.650553239294647e-01, -2.852315164806452e-01, 2.852315164806453e-01,
    7.650553239294645e-01},
   {-6.507788566919654e-01, -1.563704318081081e-01, 3.734893787362535e-01,
    7.972962734001834e-01},
   {-5.462841953788393e-01, -5.089520957245923e-02, 4.421244835661375e-01,
    8.217215880518276e-01},
   {-4.519097560851453e-01, 3.702073588896999e-02, 4.970906821069787e-01,
    8.408752611661195e-01}},
  {// a = 2
   {-9.029989011060053e-01, -5.227985248962753e-01, 3.409459020873494e-02,
    5.917028357935457e-01},
   {-7.972962734001834e-01, -3.734893787362535e-01, 1.563704318081081e-01,
    6.507788566919654e-01},
   {-6.947465906068658e-01, -2.505628070857315e-01, 2.505628070857316e-01,
    6.947465906068658e-01},
   {-5.990347085082480e-01, -1.476110519995259e-01, 3.255437708118887e-01,
    7.287942973881928e-01},
   {-5.110896002353021e-01, -6.017330591592821e-02, 3.867299771317085e-01,
    7.559615004480931e-01}},
  {// a = 3
   {-9.156941611322373e-01, -5.805664599385740e-01, -7.169289217650020e-02,
    4.770444223382206e-01},
   {-8.217215880518276e-01, -4.421244835661375e-01, 5.089520957245923e-02,
    5.462841953788393e-01},
   {-7.287942973881928e-01, -3.255437708118887e-01, 1.476110519995259e-01,
    5.990347085082480e-01},
   {-6.406425159697439e-01, -2.260876561655187e-01, 2.260876561655185e-01,
    6.406425159697442e-01},
   {-5.585054900997352e-01, -1.403071030756702e-01, 2.911390755462105e-01,
    6.743401842958617e-01}},
  {// a = 4
   {-9.254479952822050e-01, -6.257830332324487e-01, -1.578313191246453e-01,
    3.757290143059655e-01},
   {-8.408752611661195e-01, -4.970906821069787e-01, -3.702073588896999e-02,
    4.519097560851453e-01},
   {-7.559615004480931e-01, -3.867299771317085e-01, 6.017330591592821e-02,
    5.110896002353021e-01},
   {-6.743401842958617e-01, -2.911390755462105e-01, 1.403071030756702e-01,
    5.585054900997352e-01},
   {-5.974051457014303e-01, -2.076224744324486e-01, 2.076224744324486e-01,
    5.974051457014302e-01}}};
static double _gaussJacobiPt_5[5][5][5] = {
  {// a = 0
   {-9.061798459386639e-01, -5.384693101056829e-01, -2.296712866029664e-17,
    5.384693101056830e-01, 9.061798459386639e-01},
   {-8.029298284023467e-01, -3.909285467072722e-01, 1.240503795052278e-01,
    6.039731642527837e-01, 9.203802858970622e-01},
   {-7.021084258940329e-01, -2.686669452617738e-01, 2.202272258689614e-01,
    6.530393584566088e-01, 9.308421201635702e-01},
   {-6.075759852065801e-01, -1.657995763555987e-01, 2.971400084741230e-01,
    6.912102999476756e-01, 9.388714069865340e-01},
   {-5.204159103950381e-01, -7.813265093696906e-02, 3.601184654820193e-01,
    7.217726873528852e-01, 9.452288370685311e-01}},
  {// a = 1
   {-9.203802858970622e-01, -6.039731642527837e-01, -1.240503795052278e-01,
    3.909285467072722e-01, 8.029298284023467e-01},
   {-8.302238962785672e-01, -4.688487934707142e-01, 5.063780056112226e-17,
    4.688487934707142e-01, 8.302238962785672e-01},
   {-7.401236485798885e-01, -3.538526341284552e-01, 9.890279315083066e-02,
    5.288423044511161e-01, 8.508465697217814e-01},
   {-6.539998151013593e-01, -2.549967597332658e-01, 1.797678318882373e-01,
    5.765287751266746e-01, 8.669856821054276e-01},
   {-5.732884185071708e-01, -1.692400163826446e-01, 2.471879027735052e-01,
    6.153765309147026e-01, 8.799640012016079e-01}},
  {// a = 2
   {-9.308421201635702e-01, -6.530393584566088e-01, -2.202272258689614e-01,
    2.686669452617738e-01, 7.021084258940329e-01},
   {-8.508465697217814e-01, -5.288423044511161e-01, -9.890279315083066e-02,
    3.538526341284552e-01, 7.401236485798885e-01},
   {-7.694553243317872e-01, -4.209148050238113e-01, 1.220627971223391e-16,
    4.209148050238114e-01, 7.694553243317872e-01},
   {-6.904577501267610e-01, -3.265199313490006e-01, 8.233784955203487e-02,
    4.751788706128313e-01, 7.927942946442286e-01},
   {-6.154421152496427e-01, -2.434337651431532e-01, 1.520219788537995e-01,
    5.200367263054764e-01, 8.118171752335199e-01}},
  {// a = 3
   {-9.388714069865340e-01, -6.912102999476756e-01, -2.971400084741230e-01,
    1.657995763555987e-01, 6.075759852065801e-01},
   {-8.669856821054276e-01, -5.765287751266746e-01, -1.797678318882373e-01,
    2.549967597332658e-01, 6.539998151013593e-01},
   {-7.927942946442286e-01, -4.751788706128313e-01, -8.233784955203487e-02,
    3.265199313490006e-01, 6.904577501267610e-01},
   {-7.198842953848503e-01, -3.852703828805474e-01, 6.265476865476206e-17,
    3.852703828805473e-01, 7.198842953848507e-01},
   {-6.498906441312227e-01, -3.051663960317241e-01, 7.057137877891513e-02,
    4.344497877305027e-01, 7.441535207123526e-01}},
  {// a = 4
   {-9.452288370685311e-01, -7.217726873528852e-01, -3.601184654820193e-01,
    7.813265093696906e-02, 5.204159103950381e-01},
   {-8.799640012016079e-01, -6.153765309147026e-01, -2.471879027735052e-01,
    1.692400163826446e-01, 5.732884185071708e-01},
   {-8.118171752335199e-01, -5.200367263054764e-01, -1.520219788537995e-01,
    2.434337651431532e-01, 6.154421152496427e-01},
   {-7.441535207123526e-01, -4.344497877305027e-01, -7.057137877891513e-02,
    3.051663960317241e-01, 6.498906441312227e-01},
   {-6.785983445458468e-01, -3.574067443365933e-01, 1.135699304818221e-16,
    3.574067443365931e-01, 6.785983445458470e-01}}};
static double _gaussJacobiPt_6[5][5][6] = {
  {// a = 0
   {-9.324695142031519e-01, -6.612093864662646e-01, -2.386191860831971e-01,
    2.386191860831968e-01, 6.612093864662646e-01, 9.324695142031523e-01},
   {-8.538913426394820e-01, -5.384677240601088e-01, -1.173430375431004e-01,
    3.260306194376912e-01, 7.038428006630316e-01, 9.413671456804302e-01},
   {-7.736112323551240e-01, -4.313622546234276e-01, -1.807282632950416e-02,
    3.951261639542176e-01, 7.368721166840299e-01, 9.481908898126653e-01},
   {-6.954536764313222e-01, -3.373990859248842e-01, 6.482313345808229e-02,
    4.512055566591650e-01, 7.632333688745154e-01, 9.535907033644436e-01},
   {-6.210608321550133e-01, -2.544976879714631e-01, 1.351447457091878e-01,
    4.976729950111234e-01, 7.847703168931964e-01, 9.579704625129687e-01}},
  {// a = 1
   {-9.413671456804302e-01, -7.038428006630316e-01, -3.260306194376912e-01,
    1.173430375431004e-01, 5.384677240601088e-01, 8.538913426394820e-01},
   {-8.717401485096062e-01, -5.917001814331421e-01, -2.092992179024789e-01,
    2.092992179024784e-01, 5.917001814331418e-01, 8.717401485096067e-01},
   {-7.993818545492362e-01, -4.919057913388810e-01, -1.117339353995897e-01,
    2.835397724481963e-01, 6.337933270557147e-01, 8.856884817837958e-01},
   {-7.279042649828523e-01, -4.029169178070013e-01, -2.885478667483911e-02,
    3.448376945011423e-01, 6.679457984322057e-01, 8.968924765313449e-01},
   {-6.590086789824122e-01, -3.233115599281374e-01, 4.246736788877636e-02,
    3.963569738302052e-01, 6.962280608304199e-01, 9.060913657729128e-01}},
  {// a = 2
   {-9.481908898126653e-01, -7.368721166840299e-01, -3.951261639542176e-01,
    1.807282632950416e-02, 4.313622546234276e-01, 7.736112323551240e-01},
   {-8.856884817837958e-01, -6.337933270557147e-01, -2.835397724481963e-01,
    1.117339353995897e-01, 4.919057913388810e-01, 7.993818545492362e-01},
   {-8.198459954634868e-01, -5.406046373873585e-01, -1.886774224907859e-01,
    1.886774224907859e-01, 5.406046373873586e-01, 8.198459954634867e-01},
   {-7.540309604648933e-01, -4.563858095825369e-01, -1.069422717353892e-01,
    2.531275817031343e-01, 5.806736588601311e-01, 8.364989776901421e-01},
   {-6.899306434299896e-01, -3.801739750840734e-01, -3.575072875934796e-02,
    3.079564307616816e-01, 6.142457880527944e-01, 8.503197951256017e-01}},
  {// a = 3
   {-9.535907033644436e-01, -7.632333688745154e-01, -4.512055566591650e-01,
    -6.482313345808229e-02, 3.373990859248842e-01, 6.954536764313222e-01},
   {-8.968924765313449e-01, -6.679457984322057e-01, -3.448376945011423e-01,
    2.885478667483911e-02, 4.029169178070013e-01, 7.279042649828523e-01},
   {-8.364989776901421e-01, -5.806736588601311e-01, -2.531275817031343e-01,
    1.069422717353892e-01, 4.563858095825369e-01, 7.540309604648933e-01},
   {-7.755355259865796e-01, -5.009134932118855e-01, -1.731567539181084e-01,
    1.731567539181084e-01, 5.009134932118857e-01, 7.755355259865793e-01},
   {-7.156393366264865e-01, -4.280278563380202e-01, -1.027801644267999e-01,
    2.300782005729258e-01, 5.386042094609106e-01, 7.935544210416807e-01}},
  {// a = 4
   {-9.579704625129687e-01, -7.847703168931964e-01, -4.976729950111234e-01,
    -1.351447457091878e-01, 2.544976879714631e-01, 6.210608321550133e-01},
   {-9.060913657729128e-01, -6.962280608304199e-01, -3.963569738302052e-01,
    -4.246736788877636e-02, 3.233115599281374e-01, 6.590086789824122e-01},
   {-8.503197951256017e-01, -6.142457880527944e-01, -3.079564307616816e-01,
    3.575072875934796e-02, 3.801739750840734e-01, 6.899306434299896e-01},
   {-7.935544210416807e-01, -5.386042094609106e-01, -2.300782005729258e-01,
    1.027801644267999e-01, 4.280278563380202e-01, 7.156393366264865e-01},
   {-7.373657361102366e-01, -4.688999449180306e-01, -1.609294785830220e-01,
    1.609294785830219e-01, 4.688999449180306e-01, 7.373657361102364e-01}}};
static double _gaussJacobiPt_7[5][5][7] = {
  {// a = 0
   {-9.491079123427586e-01, -7.415311855993943e-01, -4.058451513773970e-01,
    1.193908377356533e-16, 4.058451513773974e-01, 7.415311855993942e-01,
    9.491079123427585e-01},
   {-8.874748789261557e-01, -6.395186165262153e-01, -2.947505657736608e-01,
    9.430725266111044e-02, 4.684203544308211e-01, 7.706418936781918e-01,
    9.550412271225752e-01},
   {-8.223663331260054e-01, -5.470344931828751e-01, -2.000430265579859e-01,
    1.719957108058808e-01, 5.188917479038850e-01, 7.938219417039016e-01,
    9.597344524531991e-01},
   {-7.571457423351552e-01, -4.632731193770239e-01, -1.182670787543269e-01,
    2.372080568631812e-01, 5.605071039321651e-01, 8.127250682903714e-01,
    9.635398290278467e-01},
   {-6.935171222617036e-01, -3.873469549165231e-01, -4.691981399801844e-02,
    2.927786050394288e-01, 5.954333796292736e-01, 8.284398011290520e-01,
    9.666876609340463e-01}},
  {// a = 1
   {-9.550412271225752e-01, -7.706418936781918e-01, -4.684203544308211e-01,
    -9.430725266111044e-02, 2.947505657736608e-01, 6.395186165262153e-01,
    8.874748789261557e-01},
   {-8.997579954114601e-01, -6.771862795107377e-01, -3.631174638261781e-01,
    -3.020666787869917e-17, 3.631174638261780e-01, 6.771862795107376e-01,
    8.997579954114603e-01},
   {-8.405901445935972e-01, -5.911813487913296e-01, -2.718937884336990e-01,
    7.898300551160212e-02, 4.191737999226332e-01, 7.076570510566212e-01,
    9.096161312101220e-01},
   {-7.806436006674152e-01, -5.122885621840089e-01, -1.920542687645395e-01,
    1.462023496817571e-01, 4.660272611591706e-01, 7.328300530177787e-01,
    9.177045455350352e-01},
   {-7.215735195976674e-01, -4.399832807349889e-01, -1.215869111005672e-01,
    2.041569362298995e-01, 5.058029972816601e-01, 7.539854765822848e-01,
    9.244614592341160e-01}},
  {// a = 2
   {-9.597344524531991e-01, -7.938219417039016e-01, -5.188917479038850e-01,
    -1.719957108058808e-01, 2.000430265579859e-01, 5.470344931828751e-01,
    8.223663331260054e-01},
   {-9.096161312101220e-01, -7.076570510566212e-01, -4.191737999226332e-01,
    -7.898300551160212e-02, 2.718937884336990e-01, 5.911813487913296e-01,
    8.405901445935972e-01},
   {-8.554020262848745e-01, -6.273781397626187e-01, -3.316295536027899e-01,
    1.696236582304631e-16, 3.316295536027896e-01, 6.273781397626187e-01,
    8.554020262848745e-01},
   {-7.999546795922177e-01, -5.529486988055030e-01, -2.541331370777906e-01,
    6.801075022236561e-02, 3.821440122181823e-01, 6.576200959973667e-01,
    8.676827096691756e-01},
   {-7.448575365180665e-01, -4.840945559720232e-01, -1.850563195192408e-01,
    1.272401577969688e-01, 4.254565070960148e-01, 6.832791838943486e-01,
    8.780325632219984e-01}},
  {// a = 3
   {-9.635398290278467e-01, -8.127250682903714e-01, -5.605071039321651e-01,
    -2.372080568631812e-01, 1.182670787543269e-01, 4.632731193770239e-01,
    7.571457423351552e-01},
   {-9.177045455350352e-01, -7.328300530177787e-01, -4.660272611591706e-01,
    -1.462023496817571e-01, 1.920542687645395e-01, 5.122885621840089e-01,
    7.806436006674152e-01},
   {-8.676827096691756e-01, -6.576200959973667e-01, -3.821440122181823e-01,
    -6.801075022236561e-02, 2.541331370777906e-01, 5.529486988055030e-01,
    7.999546795922177e-01},
   {-8.161152234442209e-01, -5.872564900763582e-01, -3.071626846160234e-01,
    9.092219072621500e-17, 3.071626846160234e-01, 5.872564900763583e-01,
    8.161152234442204e-01},
   {-7.645054103328334e-01, -5.216402272912483e-01, -2.397563306151332e-01,
    5.974952126508076e-02, 3.530300783204262e-01, 6.166124827563498e-01,
    8.298432192306912e-01}},
  {// a = 4
   {-9.666876609340463e-01, -8.284398011290520e-01, -5.954333796292736e-01,
    -2.927786050394288e-01, 4.691981399801844e-02, 3.873469549165231e-01,
    6.935171222617036e-01},
   {-9.244614592341160e-01, -7.539854765822848e-01, -5.058029972816601e-01,
    -2.041569362298995e-01, 1.215869111005672e-01, 4.399832807349889e-01,
    7.215735195976674e-01},
   {-8.780325632219984e-01, -6.832791838943486e-01, -4.254565070960148e-01,
    -1.272401577969688e-01, 1.850563195192408e-01, 4.840945559720232e-01,
    7.448575365180665e-01},
   {-8.298432192306912e-01, -6.166124827563498e-01, -3.530300783204262e-01,
    -5.974952126508076e-02, 2.397563306151332e-01, 5.216402272912483e-01,
    7.645054103328334e-01},
   {-7.813155385456068e-01, -5.540100741142812e-01, -2.874349787466332e-01,
    -1.330996207987286e-16, 2.874349787466332e-01, 5.540100741142814e-01,
    7.813155385456063e-01}}};
static double _gaussJacobiPt_8[5][5][8] = {
  {// a = 0
   {-9.602898564975361e-01, -7.966664774136268e-01, -5.255324099163290e-01,
    -1.834346424956498e-01, 1.834346424956497e-01, 5.255324099163293e-01,
    7.966664774136266e-01, 9.602898564975361e-01},
   {-9.107320894200608e-01, -7.112674859157088e-01, -4.263504857111389e-01,
    -9.037336960685306e-02, 2.561356708334552e-01, 5.713830412087384e-01,
    8.173527842004120e-01, 9.644401697052731e-01},
   {-8.570179299198136e-01, -6.315434071665675e-01, -3.391045436487230e-01,
    -1.119415636897813e-02, 3.166960170455960e-01, 6.090496630225205e-01,
    8.341987650286973e-01, 9.678044808961578e-01},
   {-8.019964845798543e-01, -5.575129853004078e-01, -2.617521999756697e-01,
    5.709086240380931e-02, 3.679864968632376e-01, 6.405678993571100e-01,
    8.481874257978048e-01, 9.705868801708124e-01},
   {-7.472540512432631e-01, -4.889418958435321e-01, -1.927174022123253e-01,
    1.166333515795879e-01, 4.120190857656781e-01, 6.673430840774790e-01,
    8.599914321053584e-01, 9.729263957710169e-01}},
  {// a = 1
   {-9.644401697052731e-01, -8.173527842004120e-01, -5.713830412087384e-01,
    -2.561356708334552e-01, 9.037336960685306e-02, 4.263504857111389e-01,
    7.112674859157088e-01, 9.107320894200608e-01},
   {-9.195339081664592e-01, -7.387738651055049e-01, -4.779249498104446e-01,
    -1.652789576663870e-01, 1.652789576663869e-01, 4.779249498104450e-01,
    7.387738651055050e-01, 9.195339081664591e-01},
   {-8.703573241268080e-01, -6.645470948363091e-01, -3.946644000536821e-01,
    -8.695007955319405e-02, 2.285115660779311e-01, 5.208520499369652e-01,
    7.614560676074159e-01, 9.267518465266287e-01},
   {-8.195233921518306e-01, -5.949138061049166e-01, -3.200375269392208e-01,
    -1.863585738859826e-02, 2.826720570759457e-01, 5.571701327304996e-01,
    7.804894180746164e-01, 9.327789747035043e-01},
   {-7.685354791349837e-01, -5.298348546428772e-01, -2.528017363011083e-01,
    4.151229262559467e-02, 3.296204876806622e-01, 5.883145946940839e-01,
    7.966938216380223e-01, 9.378880162977485e-01}},
  {// a = 2
   {-9.678044808961578e-01, -8.341987650286973e-01, -6.090496630225205e-01,
    -3.166960170455960e-01, 1.119415636897813e-02, 3.391045436487230e-01,
    6.315434071665675e-01, 8.570179299198136e-01},
   {-9.267518465266287e-01, -7.614560676074159e-01, -5.208520499369652e-01,
    -2.285115660779311e-01, 8.695007955319405e-02, 3.946644000536821e-01,
    6.645470948363091e-01, 8.703573241268080e-01},
   {-8.814085756174123e-01, -6.920606182568352e-01, -4.414329761085157e-01,
    -1.516316642932666e-01, 1.516316642932666e-01, 4.414329761085160e-01,
    6.920606182568353e-01, 8.814085756174119e-01},
   {-8.341761817227134e-01, -6.263929253413220e-01, -3.695845236865031e-01,
    -8.393148155168002e-02, 2.075757323546850e-01, 4.813831786277564e-01,
    7.153622848580607e-01, 8.907162974140972e-01},
   {-7.864720177123645e-01, -5.645463876430995e-01, -3.043211015125024e-01,
    -2.382031564025630e-02, 2.564819459809511e-01, 5.159276939944784e-01,
    7.353585492129080e-01, 8.986643605926121e-01}},
  {// a = 3
   {-9.705868801708124e-01, -8.481874257978048e-01, -6.405678993571100e-01,
    -3.679864968632376e-01, -5.709086240380931e-02, 2.617521999756697e-01,
    5.575129853004078e-01, 8.019964845798543e-01},
   {-9.327789747035043e-01, -7.804894180746164e-01, -5.571701327304996e-01,
    -2.826720570759457e-01, 1.863585738859826e-02, 3.200375269392208e-01,
    5.949138061049166e-01, 8.195233921518306e-01},
   {-8.907162974140972e-01, -7.153622848580607e-01, -4.813831786277564e-01,
    -2.075757323546850e-01, 8.393148155168002e-02, 3.695845236865031e-01,
    6.263929253413220e-01, 8.341761817227134e-01},
   {-8.466129750532434e-01, -6.532727259934625e-01, -4.122676659703658e-01,
    -1.408897472254330e-01, 1.408897472254329e-01, 4.122676659703658e-01,
    6.532727259934625e-01, 8.466129750532435e-01},
   {-8.018025475096356e-01, -5.944045793960987e-01, -3.490378929922565e-01,
    -8.124065226338430e-02, 1.910552607065690e-01, 4.494483070822128e-01,
    6.765041657375356e-01, 8.573040255915798e-01}},
  {// a = 4
   {-9.729263957710169e-01, -8.599914321053584e-01, -6.673430840774790e-01,
    -4.120190857656781e-01, -1.166333515795879e-01, 1.927174022123253e-01,
    4.889418958435321e-01, 7.472540512432631e-01},
   {-9.378880162977485e-01, -7.966938216380223e-01, -5.883145946940839e-01,
    -3.296204876806622e-01, -4.151229262559467e-02, 2.528017363011083e-01,
    5.298348546428772e-01, 7.685354791349837e-01},
   {-8.986643605926121e-01, -7.353585492129080e-01, -5.159276939944784e-01,
    -2.564819459809511e-01, 2.382031564025630e-02, 3.043211015125024e-01,
    5.645463876430995e-01, 7.864720177123645e-01},
   {-8.573040255915798e-01, -6.765041657375356e-01, -4.494483070822128e-01,
    -1.910552607065690e-01, 8.124065226338430e-02, 3.490378929922565e-01,
    5.944045793960987e-01, 8.018025475096356e-01},
   {-8.150613531510142e-01, -6.203761367241419e-01, -3.882476639637909e-01,
    -1.321495189448358e-01, 1.321495189448357e-01, 3.882476639637909e-01,
    6.203761367241423e-01, 8.150613531510140e-01}}};
static double _gaussJacobiPt_9[5][5][9] = {
  {// a = 0
   {-9.681602395076263e-01, -8.360311073266357e-01, -6.133714327005902e-01,
    -3.242534234038092e-01, 1.326953380915175e-16, 3.242534234038091e-01,
    6.133714327005909e-01, 8.360311073266358e-01, 9.681602395076259e-01},
   {-9.274843742335809e-01, -7.638420424200024e-01, -5.256460303700794e-01,
    -2.362344693905879e-01, 7.605919783797824e-02, 3.806648401447243e-01,
    6.477666876740095e-01, 8.512252205816079e-01, 9.711751807022464e-01},
   {-8.824917284265482e-01, -6.948736840264746e-01, -4.465371434806706e-01,
    -1.593881127023262e-01, 1.410927092243745e-01, 4.282178233215592e-01,
    6.764809664718510e-01, 8.638309408124645e-01, 9.736682288057708e-01},
   {-8.355699007465744e-01, -6.295336343600942e-01, -3.748857803554502e-01,
    -9.163895512654086e-02, 1.974060716007357e-01, 4.688847536930802e-01,
    7.008274627772243e-01, 8.744601050923133e-01, 9.757641631395919e-01},
   {-7.881340969377992e-01, -5.679366071879309e-01, -3.097390830018205e-01,
    -3.142696039742536e-02, 2.466818663525159e-01, 5.040823074972006e-01,
    7.217401049086223e-01, 8.835451997712869e-01, 9.775509053589865e-01}},
  {// a = 1
   {-9.711751807022464e-01, -8.512252205816079e-01, -6.477666876740095e-01,
    -3.806648401447243e-01, -7.605919783797824e-02, 2.362344693905879e-01,
    5.256460303700794e-01, 7.638420424200024e-01, 9.274843742335809e-01},
   {-9.340014304080591e-01, -7.844834736631441e-01, -5.652353269962053e-01,
    -2.957581355869396e-01, 1.657705705033761e-16, 2.957581355869396e-01,
    5.652353269962049e-01, 7.844834736631443e-01, 9.340014304080594e-01},
   {-8.925384000020725e-01, -7.201109148685505e-01, -4.900440596696391e-01,
    -2.208314223042547e-01, 6.574716964719765e-02, 3.464843764286125e-01,
    5.986396729615450e-01, 8.017835761840958e-01, 9.394414301944946e-01},
   {-8.489741483615989e-01, -6.586135324720294e-01, -4.213302803386361e-01,
    -1.541595263825746e-01, 1.232164245971234e-01, 3.902723508949431e-01,
    6.272215113080293e-01, 8.164975743684556e-01, 9.440514445681056e-01},
   {-8.046361404063783e-01, -6.002072581691080e-01, -3.583609511932042e-01,
    -9.442184263442212e-02, 1.739175857079093e-01, 4.284797926931285e-01,
    6.519657612574546e-01, 8.291678634722249e-01, 9.480082327506564e-01}},
  {// a = 2
   {-9.736682288057708e-01, -8.638309408124645e-01, -6.764809664718510e-01,
    -4.282178233215592e-01, -1.410927092243745e-01, 1.593881127023262e-01,
    4.465371434806706e-01, 6.948736840264746e-01, 8.824917284265482e-01},
   {-9.394414301944946e-01, -8.017835761840958e-01, -5.986396729615450e-01,
    -3.464843764286125e-01, -6.574716964719765e-02, 2.208314223042547e-01,
    4.900440596696391e-01, 7.201109148685505e-01, 8.925384000020725e-01},
   {-9.009956399852163e-01, -7.414536200077351e-01, -5.270976864620975e-01,
    -2.736916683369723e-01, 1.906164022956036e-16, 2.736916683369724e-01,
    5.270976864620979e-01, 7.414536200077346e-01, 9.009956399852161e-01},
   {-8.603434933842060e-01, -6.834031465006075e-01, -4.612126320788709e-01,
    -2.083953491716633e-01, 5.794283012626211e-02, 3.196976196385388e-01,
    5.590578592345261e-01, 7.597463643479582e-01, 9.082142956141493e-01},
   {-8.187289806673660e-01, -6.279144513982540e-01, -4.004199861805029e-01,
    -1.494726032171039e-01, 1.094320494310559e-01, 3.601297218463011e-01,
    5.869214550374694e-01, 7.756040809473087e-01, 9.144487142010916e-01}},
  {// a = 3
   {-9.757641631395919e-01, -8.744601050923133e-01, -7.008274627772243e-01,
    -4.688847536930802e-01, -1.974060716007357e-01, 9.163895512654086e-02,
    3.748857803554502e-01, 6.295336343600942e-01, 8.355699007465744e-01},
   {-9.440514445681056e-01, -8.164975743684556e-01, -6.272215113080293e-01,
    -3.902723508949431e-01, -1.232164245971234e-01, 1.541595263825746e-01,
    4.213302803386361e-01, 6.586135324720294e-01, 8.489741483615989e-01},
   {-9.082142956141493e-01, -7.597463643479582e-01, -5.590578592345261e-01,
    -3.196976196385388e-01, -5.794283012626211e-02, 2.083953491716633e-01,
    4.612126320788709e-01, 6.834031465006075e-01, 8.603434933842060e-01},
   {-8.701112990998542e-01, -7.047978089781992e-01, -4.958599884031408e-01,
    -2.559426475667511e-01, -3.812130663754214e-17, 2.559426475667511e-01,
    4.958599884031407e-01, 7.047978089781995e-01, 8.701112990998543e-01},
   {-8.309087961009430e-01, -6.519770894105430e-01, -4.371938639535175e-01,
    -1.980481288632627e-01, 5.182013173722937e-02, 2.979980392716625e-01,
    5.262570717976479e-01, 7.234572361307320e-01, 8.785953993909942e-01}},
  {// a = 4
   {-9.775509053589865e-01, -8.835451997712869e-01, -7.217401049086223e-01,
    -5.040823074972006e-01, -2.466818663525159e-01, 3.142696039742536e-02,
    3.097390830018205e-01, 5.679366071879309e-01, 7.881340969377992e-01},
   {-9.480082327506564e-01, -8.291678634722249e-01, -6.519657612574546e-01,
    -4.284797926931285e-01, -1.739175857079093e-01, 9.442184263442212e-02,
    3.583609511932042e-01, 6.002072581691080e-01, 8.046361404063783e-01},
   {-9.144487142010916e-01, -7.756040809473087e-01, -5.869214550374694e-01,
    -3.601297218463011e-01, -1.094320494310559e-01, 1.494726032171039e-01,
    4.004199861805029e-01, 6.279144513982540e-01, 8.187289806673660e-01},
   {-8.785953993909942e-01, -7.234572361307320e-01, -5.262570717976479e-01,
    -2.979980392716625e-01, -5.182013173722937e-02, 1.980481288632627e-01,
    4.371938639535175e-01, 6.519770894105430e-01, 8.309087961009430e-01},
   {-8.415432338524422e-01, -6.730793583747041e-01, -4.696405716393736e-01,
    -2.412610543732914e-01, -1.755982678689780e-17, 2.412610543732915e-01,
    4.696405716393739e-01, 6.730793583747037e-01, 8.415432338524426e-01}}};
static double _gaussJacobiPt_10[5][5][10] = {
  {// a = 0
   {-9.739065285171717e-01, -8.650633666889843e-01, -6.794095682990244e-01,
    -4.333953941292470e-01, -1.488743389816313e-01, 1.488743389816313e-01,
    4.333953941292470e-01, 6.794095682990243e-01, 8.650633666889843e-01,
    9.739065285171715e-01},
   {-9.399419356770270e-01, -8.034219755802933e-01, -6.019578420737978e-01,
    -3.518889233533303e-01, -7.347753143132112e-02, 2.107203062284260e-01,
    4.776806479830875e-01, 7.057771007138595e-01, 8.765358562457040e-01,
    9.761647731351693e-01},
   {-9.017485852810456e-01, -7.434201491488169e-01, -5.306953590962158e-01,
    -2.792189773094194e-01, -7.614252829747811e-03, 2.639842991013244e-01,
    5.154376077349526e-01, 7.280995318995418e-01, 8.862036989326839e-01,
    9.780630950876519e-01},
   {-8.613271088850980e-01, -6.856332660312396e-01, -4.650086703114362e-01,
    -2.139744802399369e-01, 5.048251851516934e-02, 3.103826659850264e-01,
    5.480331483513736e-01, 7.472488397741176e-01, 8.944629538061557e-01,
    9.796812251228244e-01},
   {-8.199178362351495e-01, -6.303550954878622e-01, -4.043537027125084e-01,
    -1.550546219842314e-01, 1.021468439538920e-01, 3.511897906371766e-01,
    5.764716294274184e-01, 7.638613323722466e-01, 9.016013710454236e-01,
    9.810769556502610e-01}},
  {// a = 1
   {-9.761647731351693e-01, -8.765358562457040e-01, -7.057771007138595e-01,
    -4.776806479830875e-01, -2.107203062284260e-01, 7.347753143132112e-02,
    3.518889233533303e-01, 6.019578420737978e-01, 8.034219755802933e-01,
    9.399419356770270e-01},
   {-9.448992722228821e-01, -8.192793216440065e-01, -6.328761530318606e-01,
    -3.995309409653489e-01, -1.365529328549276e-01, 1.365529328549271e-01,
    3.995309409653491e-01, 6.328761530318606e-01, 8.192793216440070e-01,
    9.448992722228819e-01},
   {-9.094983608302611e-01, -7.631088440019468e-01, -5.652332575100812e-01,
    -3.292354970041083e-01, -7.117334827324186e-02, 1.913747164426928e-01,
    4.405195498504024e-01, 6.592831498785090e-01, 8.327552288678481e-01,
    9.490992712758392e-01},
   {-8.717988602357006e-01, -7.086348926458873e-01, -5.024174899448293e-01,
    -2.656314293511225e-01, -1.304427122046542e-02, 2.395117022503627e-01,
    4.761841196319480e-01, 6.821096827661082e-01, 8.443513542364890e-01,
    9.527034178464308e-01},
   {-8.329595255944936e-01, -6.561998977483142e-01, -4.440277436855557e-01,
    -2.077966706765967e-01, 3.901170739715901e-02, 2.821452398625555e-01,
    5.075151520208082e-01, 7.020443972389159e-01, 8.544370670976112e-01,
    9.558302740879103e-01}},
  {// a = 2
   {-9.780630950876519e-01, -8.862036989326839e-01, -7.280995318995418e-01,
    -5.154376077349526e-01, -2.639842991013244e-01, 7.614252829747811e-03,
    2.792189773094194e-01, 5.306953590962158e-01, 7.434201491488169e-01,
    9.017485852810456e-01},
   {-9.490992712758392e-01, -8.327552288678481e-01, -6.592831498785090e-01,
    -4.405195498504024e-01, -1.913747164426928e-01, 7.117334827324186e-02,
    3.292354970041083e-01, 5.652332575100812e-01, 7.631088440019468e-01,
    9.094983608302611e-01},
   {-9.161107762068036e-01, -7.799669939442457e-01, -5.949632458480204e-01,
    -3.726118186991069e-01, -1.268599300863403e-01, 1.268599300863403e-01,
    3.726118186991069e-01, 5.949632458480203e-01, 7.799669939442458e-01,
    9.161107762068036e-01},
   {-8.807912109437932e-01, -7.284632806046210e-01, -5.348443890505100e-01,
    -3.107491243455487e-01, -6.909824387191019e-02, 1.761014975938553e-01,
    4.106184090051115e-01, 6.208379342182873e-01, 7.945685564256927e-01,
    9.218198515734364e-01},
   {-8.442242737922968e-01, -6.786158236511477e-01, -4.786347594797316e-01,
    -2.541552139983547e-01, -1.704941403243429e-02, 2.199859984581642e-01,
    4.442133105112832e-01, 6.435704988651870e-01, 8.073410928638888e-01,
    9.267993534862115e-01}},
  {// a = 3
   {-9.796812251228244e-01, -8.944629538061557e-01, -7.472488397741176e-01,
    -5.480331483513736e-01, -3.103826659850264e-01, -5.048251851516934e-02,
    2.139744802399369e-01, 4.650086703114362e-01, 6.856332660312396e-01,
    8.613271088850980e-01},
   {-9.527034178464308e-01, -8.443513542364890e-01, -6.821096827661082e-01,
    -4.761841196319480e-01, -2.395117022503627e-01, 1.304427122046542e-02,
    2.656314293511225e-01, 5.024174899448293e-01, 7.086348926458873e-01,
    8.717988602357006e-01},
   {-9.218198515734364e-01, -7.945685564256927e-01, -6.208379342182873e-01,
    -4.106184090051115e-01, -1.761014975938553e-01, 6.909824387191019e-02,
    3.107491243455487e-01, 5.348443890505100e-01, 7.284632806046210e-01,
    8.807912109437932e-01},
   {-8.885985593332147e-01, -7.457393868160163e-01, -5.632398897449369e-01,
    -3.505293497675201e-01, -1.189763373695647e-01, 1.189763373695645e-01,
    3.505293497675201e-01, 5.632398897449366e-01, 7.457393868160164e-01,
    8.885985593332155e-01},
   {-8.540547736606900e-01, -6.982518869219184e-01, -5.091080491652173e-01,
    -2.952602241318521e-01, -6.721510331152565e-02, 1.636772801427245e-01,
    3.858878375165101e-01, 5.883230379225718e-01, 7.609305533813385e-01,
    8.954416985984290e-01}},
  {// a = 4
   {-9.810769556502610e-01, -9.016013710454236e-01, -7.638613323722466e-01,
    -5.764716294274184e-01, -3.511897906371766e-01, -1.021468439538920e-01,
    1.550546219842314e-01, 4.043537027125084e-01, 6.303550954878622e-01,
    8.199178362351495e-01},
   {-9.558302740879103e-01, -8.544370670976112e-01, -7.020443972389159e-01,
    -5.075151520208082e-01, -2.821452398625555e-01, -3.901170739715901e-02,
    2.077966706765967e-01, 4.440277436855557e-01, 6.561998977483142e-01,
    8.329595255944936e-01},
   {-9.267993534862115e-01, -8.073410928638888e-01, -6.435704988651870e-01,
    -4.442133105112832e-01, -2.199859984581642e-01, 1.704941403243429e-02,
    2.541552139983547e-01, 4.786347594797316e-01, 6.786158236511477e-01,
    8.442242737922968e-01},
   {-8.954416985984290e-01, -7.609305533813385e-01, -5.883230379225718e-01,
    -3.858878375165101e-01, -1.636772801427245e-01, 6.721510331152565e-02,
    2.952602241318521e-01, 5.091080491652173e-01, 6.982518869219184e-01,
    8.540547736606900e-01},
   {-8.627103339975803e-01, -7.156009978402934e-01, -5.361601043856260e-01,
    -3.319805614805308e-01, -1.124011006827486e-01, 1.124011006827486e-01,
    3.319805614805308e-01, 5.361601043856263e-01, 7.156009978402929e-01,
    8.627103339975802e-01}}};
static double _gaussJacobiPt_11[5][5][11] = {
  {// a = 0
   {-9.782286581460572e-01, -8.870625997680954e-01, -7.301520055740494e-01,
    -5.190961292068116e-01, -2.695431559523448e-01, 8.990116993431148e-17,
    2.695431559523452e-01, 5.190961292068121e-01, 7.301520055740492e-01,
    8.870625997680951e-01, 9.782286581460565e-01},
   {-9.494527592049596e-01, -8.339167731051895e-01, -6.616497992456370e-01,
    -4.444065697819357e-01, -1.969945595342782e-01, 6.372477382083178e-02,
    3.199836841706696e-01, 5.543187859123245e-01, 7.507615497111143e-01,
    8.959290977456387e-01, 9.799634390766393e-01},
   {-9.166502875732961e-01, -7.813821987087842e-01, -5.975687171818291e-01,
    -3.766484797259134e-01, -1.324796783091365e-01, 1.196032002822751e-01,
    3.637640961875316e-01, 5.846633168058799e-01, 7.684227467412095e-01,
    9.035006158114272e-01, 9.814420523373022e-01},
   {-8.815050981582672e-01, -7.300895420693674e-01, -5.376306582815262e-01,
    -3.148786315648594e-01, -7.467746164964285e-02, 1.690488271761821e-01,
    4.021513598077393e-01, 6.110911177561568e-01, 7.837304284250708e-01,
    9.100423014430291e-01, 9.827173571154848e-01},
   {-8.450970699006651e-01, -6.804166869434627e-01, -4.815566464700486e-01,
    -2.583360920470064e-01, -2.256130427059169e-02, 2.131411465156455e-01,
    4.361026703374636e-01, 6.343232294876886e-01, 7.971284747718846e-01,
    9.157513698038646e-01, 9.838286010229199e-01}},
  {// a = 1
   {-9.799634390766393e-01, -8.959290977456387e-01, -7.507615497111143e-01,
    -5.543187859123245e-01, -3.199836841706696e-01, -6.372477382083178e-02,
    1.969945595342782e-01, 4.444065697819357e-01, 6.616497992456370e-01,
    8.339167731051895e-01, 9.494527592049596e-01},
   {-9.533098466421640e-01, -8.463475646518723e-01, -6.861884690817576e-01,
    -4.829098210913363e-01, -2.492869301062400e-01, -1.108639036007883e-16,
    2.492869301062400e-01, 4.829098210913361e-01, 6.861884690817573e-01,
    8.463475646518727e-01, 9.533098466421642e-01},
   {-9.227507501505473e-01, -7.970153602414491e-01, -6.253560933791470e-01,
    -4.176466650618614e-01, -1.859372436416418e-01, 5.631285370564750e-02,
    2.950276358082067e-01, 5.163349586454838e-01, 7.073732767467203e-01,
    8.570382107575023e-01, 9.566191768110855e-01},
   {-8.898367245100568e-01, -7.485662540163880e-01, -5.680981744017178e-01,
    -3.577590638131492e-01, -1.287946644776952e-01, 1.064841567596346e-01,
    3.354075673360336e-01, 5.456411031715711e-01, 7.258542657054387e-01,
    8.663317891939751e-01, 9.594898452062001e-01},
   {-8.555756571796961e-01, -7.013974542586021e-01, -5.142279489925600e-01,
    -3.026160560151034e-01, -7.696225083294500e-02, 1.514958061896425e-01,
    3.713372609314780e-01, 5.715561659012299e-01, 7.421222103097419e-01,
    8.744863989765731e-01, 9.620037471924632e-01}},
  {// a = 2
   {-9.814420523373022e-01, -9.035006158114272e-01, -7.684227467412095e-01,
    -5.846633168058799e-01, -3.637640961875316e-01, -1.196032002822751e-01,
    1.324796783091365e-01, 3.766484797259134e-01, 5.975687171818291e-01,
    7.813821987087842e-01, 9.166502875732961e-01},
   {-9.566191768110855e-01, -8.570382107575023e-01, -7.073732767467203e-01,
    -5.163349586454838e-01, -2.950276358082067e-01, -5.631285370564750e-02,
    1.859372436416418e-01, 4.176466650618614e-01, 6.253560933791470e-01,
    7.970153602414491e-01, 9.227507501505473e-01},
   {-9.280164504291800e-01, -8.105462166425115e-01, -6.495055391494071e-01,
    -4.534807213176902e-01, -2.330195022455460e-01, -8.622673226532133e-17,
    2.330195022455463e-01, 4.534807213176898e-01, 6.495055391494077e-01,
    8.105462166425111e-01, 9.280164504291800e-01},
   {-8.970679126941687e-01, -7.646511545017334e-01, -5.947359989878861e-01,
    -3.954678201717901e-01, -1.767513641082236e-01, 5.047694502127038e-02,
    2.748372403061862e-01, 4.850881398161955e-01, 6.706962723986961e-01,
    8.223748504646330e-01, 9.326082098642275e-01},
   {-8.647161717639213e-01, -7.197589131798050e-01, -5.429481353816696e-01,
    -3.417707669419396e-01, -1.254372559510012e-01, 9.600953090830763e-02,
    3.122485942369511e-01, 5.131878133741616e-01, 6.894463729644811e-01,
    8.328052835847137e-01, 9.366479338640069e-01}},
  {// a = 3
   {-9.827173571154848e-01, -9.100423014430291e-01, -7.837304284250708e-01,
    -6.110911177561568e-01, -4.021513598077393e-01, -1.690488271761821e-01,
    7.467746164964285e-02, 3.148786315648594e-01, 5.376306582815262e-01,
    7.300895420693674e-01, 8.815050981582672e-01},
   {-9.594898452062001e-01, -8.663317891939751e-01, -7.258542657054387e-01,
    -5.456411031715711e-01, -3.354075673360336e-01, -1.064841567596346e-01,
    1.287946644776952e-01, 3.577590638131492e-01, 5.680981744017178e-01,
    7.485662540163880e-01, 8.898367245100568e-01},
   {-9.326082098642275e-01, -8.223748504646330e-01, -6.706962723986961e-01,
    -4.850881398161955e-01, -2.748372403061862e-01, -5.047694502127038e-02,
    1.767513641082236e-01, 3.954678201717901e-01, 5.947359989878861e-01,
    7.646511545017334e-01, 8.970679126941687e-01},
   {-9.034041403870294e-01, -7.787845784779767e-01, -6.182345728494725e-01,
    -4.289096757953184e-01, -2.195793237904602e-01, 1.880251561444324e-16,
    2.195793237904604e-01, 4.289096757953185e-01, 6.182345728494730e-01,
    7.787845784779760e-01, 9.034041403870291e-01},
   {-8.727612048660429e-01, -7.359684858680122e-01, -5.684065507932738e-01,
    -3.766663677964620e-01, -1.689427615236661e-01, 4.575611394302053e-02,
    2.580828632077494e-01, 4.587847623799057e-01, 6.391253205952770e-01,
    7.913041329664285e-01, 9.090025225826618e-01}},
  {// a = 4
   {-9.838286010229199e-01, -9.157513698038646e-01, -7.971284747718846e-01,
    -6.343232294876886e-01, -4.361026703374636e-01, -2.131411465156455e-01,
    2.256130427059169e-02, 2.583360920470064e-01, 4.815566464700486e-01,
    6.804166869434627e-01, 8.450970699006651e-01},
   {-9.620037471924632e-01, -8.744863989765731e-01, -7.421222103097419e-01,
    -5.715561659012299e-01, -3.713372609314780e-01, -1.514958061896425e-01,
    7.696225083294500e-02, 3.026160560151034e-01, 5.142279489925600e-01,
    7.013974542586021e-01, 8.555756571796961e-01},
   {-9.366479338640069e-01, -8.328052835847137e-01, -6.894463729644811e-01,
    -5.131878133741616e-01, -3.122485942369511e-01, -9.600953090830763e-02,
    1.254372559510012e-01, 3.417707669419396e-01, 5.429481353816696e-01,
    7.197589131798050e-01, 8.647161717639213e-01},
   {-9.090025225826618e-01, -7.913041329664285e-01, -6.391253205952770e-01,
    -4.587847623799057e-01, -2.580828632077494e-01, -4.575611394302053e-02,
    1.689427615236661e-01, 3.766663677964620e-01, 5.684065507932738e-01,
    7.359684858680122e-01, 8.727612048660429e-01},
   {-8.798977019228941e-01, -7.503874112500294e-01, -5.911380520239878e-01,
    -4.079784824393289e-01, -2.082302875232295e-01, 5.390152688331639e-17,
    2.082302875232296e-01, 4.079784824393290e-01, 5.911380520239875e-01,
    7.503874112500289e-01, 8.798977019228944e-01}}};
static double _gaussJacobiPt_12[5][5][12] = {
  {// a = 0
   {-9.815606342467196e-01, -9.041172563704754e-01, -7.699026741943048e-01,
    -5.873179542866176e-01, -3.678314989981800e-01, -1.252334085114694e-01,
    1.252334085114691e-01, 3.678314989981800e-01, 5.873179542866177e-01,
    7.699026741943049e-01, 9.041172563704749e-01, 9.815606342467198e-01},
   {-9.568758736682992e-01, -8.578842025288225e-01, -7.091050875298717e-01,
    -5.191977790504539e-01, -2.992013005545100e-01, -6.190169862563523e-02,
    1.789098375970846e-01, 4.092382314748395e-01, 6.156978909402920e-01,
    7.862910182330464e-01, 9.111070736891850e-01, 9.829218900231450e-01},
   {-9.284130705853431e-01, -8.115901470890873e-01, -6.514370284295737e-01,
    -4.564929059061454e-01, -2.372477269169123e-01, -5.514720898064603e-03,
    2.262159800046200e-01, 4.454530844013695e-01, 6.403784218951537e-01,
    8.004847489147718e-01, 9.171443790914112e-01, 9.840959085947233e-01},
   {-8.975985245538983e-01, -7.658644530411951e-01, -5.968254805124207e-01,
    -3.985851767850569e-01, -1.809975303605268e-01, 4.505689466379486e-02,
    2.682559251563394e-01, 4.774140753925782e-01, 6.620471364134675e-01,
    8.128997139816979e-01, 9.224119060591074e-01, 9.851188469194457e-01},
   {-8.653713567789760e-01, -7.211162307744255e-01, -5.451620543220070e-01,
    -3.449596695560612e-01, -1.296751980287479e-01, 9.069665054560958e-02,
    3.058839569922088e-01, 5.058415548115412e-01, 6.812292401370837e-01,
    8.238523505345596e-01, 9.270483578727584e-01, 9.860181128521710e-01}},
  {// a = 1
   {-9.829218900231450e-01, -9.111070736891850e-01, -7.862910182330464e-01,
    -6.156978909402920e-01, -4.092382314748395e-01, -1.789098375970846e-01,
    6.190169862563523e-02, 2.992013005545100e-01, 5.191977790504539e-01,
    7.091050875298717e-01, 8.578842025288225e-01, 9.568758736682992e-01},
   {-9.599350452672614e-01, -8.678010538303474e-01, -7.288685990913262e-01,
    -5.506394029286470e-01, -3.427240133427128e-01, -1.163318688837038e-01,
    1.163318688837040e-01, 3.427240133427129e-01, 5.506394029286469e-01,
    7.288685990913261e-01, 8.678010538303473e-01, 9.599350452672608e-01},
   {-9.332995079627837e-01, -8.241972989426256e-01, -6.740760996874169e-01,
    -4.903756525854291e-01, -2.822893850278608e-01, -6.024581279546619e-02,
    1.646232114144044e-01, 3.810428592335757e-01, 5.781613306985280e-01,
    7.460940443267943e-01, 8.764183644350997e-01, 9.625883913376251e-01},
   {-9.043331546184969e-01, -7.809126253419221e-01, -6.219083835463991e-01,
    -4.344082673160836e-01, -2.270991419035120e-01, -9.646622564773525e-03,
    2.077935066056401e-01, 4.150599242580991e-01, 6.024641833517987e-01,
    7.612448577054650e-01, 8.839768468276173e-01, 9.649117336854240e-01},
   {-8.739130405699720e-01, -7.383592484595911e-01, -5.723160028857331e-01,
    -3.823156444185185e-01, -1.764804636187008e-01, 3.626016647351250e-02,
    2.466384345791495e-01, 4.454751347453242e-01, 6.240886140472163e-01,
    7.746772510739069e-01, 8.906610149309094e-01, 9.669630944473241e-01}},
  {// a = 2
   {-9.840959085947233e-01, -9.171443790914112e-01, -8.004847489147718e-01,
    -6.403784218951537e-01, -4.454530844013695e-01, -2.262159800046200e-01,
    5.514720898064603e-03, 2.372477269169123e-01, 4.564929059061454e-01,
    6.514370284295737e-01, 8.115901470890873e-01, 9.284130705853431e-01},
   {-9.625883913376251e-01, -8.764183644350997e-01, -7.460940443267943e-01,
    -5.781613306985280e-01, -3.810428592335757e-01, -1.646232114144044e-01,
    6.024581279546619e-02, 2.822893850278608e-01, 4.903756525854291e-01,
    6.740760996874169e-01, 8.241972989426256e-01, 9.332995079627837e-01},
   {-9.375597349081080e-01, -8.352126561026334e-01, -6.939208718647533e-01,
    -5.202087732305216e-01, -3.221818845733797e-01, -1.090939783245157e-01,
    1.090939783245159e-01, 3.221818845733799e-01, 5.202087732305219e-01,
    6.939208718647533e-01, 8.352126561026330e-01, 9.375597349081080e-01},
   {-9.102327624610815e-01, -7.941268989273503e-01, -6.440098121005434e-01,
    -4.661176002087244e-01, -2.681497149953622e-01, -5.873195293835499e-02,
    1.529949068722340e-01, 3.577839774894385e-01, 5.466901395218944e-01,
    7.114641560912678e-01, 8.449215035762696e-01, 9.413071615285881e-01},
   {-8.814285988340554e-01, -7.535707100992809e-01, -5.963560239063559e-01,
    -4.155417840165797e-01, -2.183604632007295e-01, -1.282219763078040e-02,
    1.926867198241465e-01, 3.897680125529990e-01, 5.703631554143442e-01,
    7.270881350352043e-01, 8.535444412555850e-01, 9.446293136055027e-01}},
  {// a = 3
   {-9.851188469194457e-01, -9.224119060591074e-01, -8.128997139816979e-01,
    -6.620471364134675e-01, -4.774140753925782e-01, -2.682559251563394e-01,
    -4.505689466379486e-02, 1.809975303605268e-01, 3.985851767850569e-01,
    5.968254805124207e-01, 7.658644530411951e-01, 8.975985245538983e-01},
   {-9.649117336854240e-01, -8.839768468276173e-01, -7.612448577054650e-01,
    -6.024641833517987e-01, -4.150599242580991e-01, -2.077935066056401e-01,
    9.646622564773525e-03, 2.270991419035120e-01, 4.344082673160836e-01,
    6.219083835463991e-01, 7.809126253419221e-01, 9.043331546184969e-01},
   {-9.413071615285881e-01, -8.449215035762696e-01, -7.114641560912678e-01,
    -5.466901395218944e-01, -3.577839774894385e-01, -1.529949068722340e-01,
    5.873195293835499e-02, 2.681497149953622e-01, 4.661176002087244e-01,
    6.440098121005434e-01, 7.941268989273503e-01, 9.102327624610815e-01},
   {-9.154441928381977e-01, -8.058259018763845e-01, -6.636387128706127e-01,
    -4.943982121529223e-01, -3.049616623290851e-01, -1.030585549013792e-01,
    1.030585549013790e-01, 3.049616623290852e-01, 4.943982121529225e-01,
    6.636387128706129e-01, 8.058259018763847e-01, 9.154441928381978e-01},
   {-8.880935320208031e-01, -7.670933934819978e-01, -6.177975944271482e-01,
    -4.453039951958354e-01, -2.560808727544255e-01, -5.734006950825194e-02,
    1.433097819098507e-01, 3.381761358407890e-01, 5.197877891222927e-01,
    6.811929286730756e-01, 8.162579526423345e-01, 9.200816433936687e-01}},
  {// a = 4
   {-9.860181128521710e-01, -9.270483578727584e-01, -8.238523505345596e-01,
    -6.812292401370837e-01, -5.058415548115412e-01, -3.058839569922088e-01,
    -9.069665054560958e-02, 1.296751980287479e-01, 3.449596695560612e-01,
    5.451620543220070e-01, 7.211162307744255e-01, 8.653713567789760e-01},
   {-9.669630944473241e-01, -8.906610149309094e-01, -7.746772510739069e-01,
    -6.240886140472163e-01, -4.454751347453242e-01, -2.466384345791495e-01,
    -3.626016647351250e-02, 1.764804636187008e-01, 3.823156444185185e-01,
    5.723160028857331e-01, 7.383592484595911e-01, 8.739130405699720e-01},
   {-9.446293136055027e-01, -8.535444412555850e-01, -7.270881350352043e-01,
    -5.703631554143442e-01, -3.897680125529990e-01, -1.926867198241465e-01,
    1.282219763078040e-02, 2.183604632007295e-01, 4.155417840165797e-01,
    5.963560239063559e-01, 7.535707100992809e-01, 8.814285988340554e-01},
   {-9.200816433936687e-01, -8.162579526423345e-01, -6.811929286730756e-01,
    -5.197877891222927e-01, -3.381761358407890e-01, -1.433097819098507e-01,
    5.734006950825194e-02, 2.560808727544255e-01, 4.453039951958354e-01,
    6.177975944271482e-01, 7.670933934819978e-01, 8.880935320208031e-01},
   {-8.940452670188849e-01, -7.791963246910317e-01, -6.370465362841737e-01,
    -4.721286777836322e-01, -2.902502314930908e-01, -9.792564278297608e-02,
    9.792564278297598e-02, 2.902502314930907e-01, 4.721286777836323e-01,
    6.370465362841733e-01, 7.791963246910319e-01, 8.940452670188848e-01}}};
static double _gaussJacobiPt_13[5][5][13] = {
  {// a = 0
   {-9.841830547185881e-01, -9.175983992229780e-01, -8.015780907333101e-01,
    -6.423493394403400e-01, -4.484927510364468e-01, -2.304583159551350e-01,
    -1.825585923415764e-17, 2.304583159551348e-01, 4.484927510364468e-01,
    6.423493394403403e-01, 8.015780907333100e-01, 9.175983992229779e-01,
    9.841830547185880e-01},
   {-9.627792699780243e-01, -8.770489182014617e-01, -7.473896426133787e-01,
    -5.803140565468751e-01, -3.842020034392034e-01, -1.688879280426809e-01,
    5.483122799176440e-02, 2.757372054355224e-01, 4.827529185884745e-01,
    6.654979772168846e-01, 8.148095506019946e-01, 9.232037225206431e-01,
    9.852706979478216e-01},
   {-9.378577884571782e-01, -8.359992910744131e-01, -6.953820878944645e-01,
    -5.224995326165541e-01, -3.254186271207771e-01, -1.133492452589102e-01,
    1.037947221885803e-01, 3.158609747078495e-01, 5.129342008257433e-01,
    6.858000516069814e-01, 8.263764396848292e-01, 9.280932745996597e-01,
    9.862183373800824e-01},
   {-9.106353256416408e-01, -7.950501880808041e-01, -6.456064598075977e-01,
    -4.685123736589696e-01, -2.714330101999745e-01, -6.295573766798158e-02,
    1.478192177054831e-01, 3.516856060316347e-01, 5.397366495788333e-01,
    7.037556485667396e-01, 8.365759709534939e-01, 9.323962103257980e-01,
    9.870513781018821e-01},
   {-8.819299912717916e-01, -7.546128207084335e-01, -5.980631053849997e-01,
    -4.180138386608684e-01, -2.216670569070099e-01, -1.699926205218229e-02,
    1.876383043526464e-01, 3.838820988418686e-01, 5.637060045203091e-01,
    7.197530330541561e-01, 8.456382235310491e-01, 9.362123163978009e-01,
    9.877894276207884e-01}},
  {// a = 1
   {-9.852706979478216e-01, -9.232037225206431e-01, -8.148095506019946e-01,
    -6.654979772168846e-01, -4.827529185884745e-01, -2.757372054355224e-01,
    -5.483122799176440e-02, 1.688879280426809e-01, 3.842020034392034e-01,
    5.803140565468751e-01, 7.473896426133787e-01, 8.770489182014617e-01,
    9.627792699780243e-01},
   {-9.652459265038384e-01, -8.850820442229769e-01, -7.635196899518156e-01,
    -6.062532054698457e-01, -4.206380547136724e-01, -2.153539553637941e-01,
    -1.158883731072409e-16, 2.153539553637944e-01, 4.206380547136724e-01,
    6.062532054698455e-01, 7.635196899518154e-01, 8.850820442229765e-01,
    9.652459265038388e-01},
   {-9.418312621637074e-01, -8.463065055546860e-01, -7.140417072439607e-01,
    -5.507411438219464e-01, -3.635261963879374e-01, -1.605740533846422e-01,
    4.924732876650102e-02, 2.567686837832749e-01, 4.529207661918739e-01,
    6.291308945030947e-01, 7.776975152952331e-01, 8.921259396516220e-01,
    9.674056024342457e-01},
   {-9.161548669307376e-01, -8.074581835226583e-01, -6.664670058592463e-01,
    -4.986511763145122e-01, -3.108112704919443e-01, -1.106133190663083e-01,
    9.375695179582762e-02, 2.939377397626047e-01, 4.817363810899637e-01,
    6.494658682590815e-01, 7.902598912526678e-01, 8.983533522410839e-01,
    9.693123044508440e-01},
   {-8.889818875272764e-01, -7.689426467374832e-01, -6.208330748596507e-01,
    -4.497111437325291e-01, -2.619946702262355e-01, -6.483965382272970e-02,
    1.342032992982673e-01, 3.274983541528479e-01, 5.076246936830698e-01,
    6.676644755102082e-01, 8.014698135747076e-01, 9.038988956134982e-01,
    9.710080612023384e-01}},
  {// a = 2
   {-9.862183373800824e-01, -9.280932745996597e-01, -8.263764396848292e-01,
    -6.858000516069814e-01, -5.129342008257433e-01, -3.158609747078495e-01,
    -1.037947221885803e-01, 1.133492452589102e-01, 3.254186271207771e-01,
    5.224995326165541e-01, 6.953820878944645e-01, 8.359992910744131e-01,
    9.378577884571782e-01},
   {-9.674056024342457e-01, -8.921259396516220e-01, -7.776975152952331e-01,
    -6.291308945030947e-01, -4.529207661918739e-01, -2.567686837832749e-01,
    -4.924732876650102e-02, 1.605740533846422e-01, 3.635261963879374e-01,
    5.507411438219464e-01, 7.140417072439607e-01, 8.463065055546860e-01,
    9.418312621637074e-01},
   {-9.453259519042577e-01, -8.553876327107929e-01, -7.305245163043851e-01,
    -5.757768514612055e-01, -3.974652678425383e-01, -2.028850022403152e-01,
    1.862729696854636e-16, 2.028850022403152e-01, 3.974652678425381e-01,
    5.757768514612053e-01, 7.305245163043851e-01, 8.553876327107927e-01,
    9.453259519042574e-01},
   {-9.210296137771264e-01, -8.184382169675549e-01, -6.849778326927073e-01,
    -5.254931513420590e-01, -3.460474803730903e-01, -1.535140263506328e-01,
    4.471826297434506e-02, 2.410367231256098e-01, 4.279004525950136e-01,
    5.981317381870436e-01, 7.451940552878702e-01, 8.634502697656881e-01,
    9.484236582772773e-01},
   {-8.952341031014633e-01, -7.816747334968547e-01, -6.411227209112407e-01,
    -4.780615105195047e-01, -2.982357362646483e-01, -1.080903642726692e-01,
    8.552681931385767e-02, 2.756308606370586e-01, 4.553586993533330e-01,
    6.182203855088778e-01, 7.583364539007535e-01, 8.706574334491421e-01,
    9.511885164033581e-01}},
  {// a = 3
   {-9.870513781018821e-01, -9.323962103257980e-01, -8.365759709534939e-01,
    -7.037556485667396e-01, -5.397366495788333e-01, -3.516856060316347e-01,
    -1.478192177054831e-01, 6.295573766798158e-02, 2.714330101999745e-01,
    4.685123736589696e-01, 6.456064598075977e-01, 7.950501880808041e-01,
    9.106353256416408e-01},
   {-9.693123044508440e-01, -8.983533522410839e-01, -7.902598912526678e-01,
    -6.494658682590815e-01, -4.817363810899637e-01, -2.939377397626047e-01,
    -9.375695179582762e-02, 1.106133190663083e-01, 3.108112704919443e-01,
    4.986511763145122e-01, 6.664670058592463e-01, 8.074581835226583e-01,
    9.161548669307376e-01},
   {-9.484236582772773e-01, -8.634502697656881e-01, -7.451940552878702e-01,
    -5.981317381870436e-01, -4.279004525950136e-01, -2.410367231256098e-01,
    -4.471826297434506e-02, 1.535140263506328e-01, 3.460474803730903e-01,
    5.254931513420590e-01, 6.849778326927073e-01, 8.184382169675549e-01,
    9.210296137771264e-01},
   {-9.253667145266221e-01, -8.282251089102080e-01, -7.015195418872225e-01,
    -5.495612784412456e-01, -3.777802389330993e-01, -1.923628590319902e-01,
    1.421753408307642e-16, 1.923628590319905e-01, 3.777802389330995e-01,
    5.495612784412456e-01, 7.015195418872221e-01, 8.282251089102080e-01,
    9.253667145266217e-01},
   {-9.008160699206721e-01, -7.930646544109481e-01, -6.593223567858463e-01,
    -5.035800839674237e-01, -3.310006752666606e-01, -1.474091888902083e-01,
    4.096661645938558e-02, 2.277258470854101e-01, 4.065194629697887e-01,
    5.712714108286815e-01, 7.163938040499569e-01, 8.370045341964304e-01,
    9.292507475914998e-01}},
  {// a = 4
   {-9.877894276207884e-01, -9.362123163978009e-01, -8.456382235310491e-01,
    -7.197530330541561e-01, -5.637060045203091e-01, -3.838820988418686e-01,
    -1.876383043526464e-01, 1.699926205218229e-02, 2.216670569070099e-01,
    4.180138386608684e-01, 5.980631053849997e-01, 7.546128207084335e-01,
    8.819299912717916e-01},
   {-9.710080612023384e-01, -9.038988956134982e-01, -8.014698135747076e-01,
    -6.676644755102082e-01, -5.076246936830698e-01, -3.274983541528479e-01,
    -1.342032992982673e-01, 6.483965382272970e-02, 2.619946702262355e-01,
    4.497111437325291e-01, 6.208330748596507e-01, 7.689426467374832e-01,
    8.889818875272764e-01},
   {-9.511885164033581e-01, -8.706574334491421e-01, -7.583364539007535e-01,
    -6.182203855088778e-01, -4.553586993533330e-01, -2.756308606370586e-01,
    -8.552681931385767e-02, 1.080903642726692e-01, 2.982357362646483e-01,
    4.780615105195047e-01, 6.411227209112407e-01, 7.816747334968547e-01,
    8.952341031014633e-01},
   {-9.292507475914998e-01, -8.370045341964304e-01, -7.163938040499569e-01,
    -5.712714108286815e-01, -4.065194629697887e-01, -2.277258470854101e-01,
    -4.096661645938558e-02, 1.474091888902083e-01, 3.310006752666606e-01,
    5.035800839674237e-01, 6.593223567858463e-01, 7.930646544109481e-01,
    9.008160699206721e-01},
   {-9.058305855710760e-01, -8.033157644669905e-01, -6.757433171702266e-01,
    -5.266790973840587e-01, -3.607799904378995e-01, -1.833275555317881e-01,
    -5.624830782443055e-17, 1.833275555317884e-01, 3.607799904378998e-01,
    5.266790973840583e-01, 6.757433171702257e-01, 8.033157644669903e-01,
    9.058305855710764e-01}}};
static double _gaussJacobiPt_14[5][5][14] = {
  {// a = 0
   {-9.862838086968119e-01, -9.284348836635733e-01, -8.272013150697648e-01,
    -6.872929048116856e-01, -5.152486363581542e-01, -3.191123689278900e-01,
    -1.080549487073435e-01, 1.080549487073435e-01, 3.191123689278900e-01,
    5.152486363581542e-01, 6.872929048116850e-01, 8.272013150697648e-01,
    9.284348836635735e-01, 9.862838086968122e-01},
   {-9.675504681972001e-01, -8.926054001205508e-01, -7.786856176390310e-01,
    -6.307794788869493e-01, -4.553529057785293e-01, -2.600733767408079e-01,
    -5.347572267974627e-02, 1.554106853848594e-01, 3.574565120221275e-01,
    5.438314587014840e-01, 7.063902646375723e-01, 8.380290006360896e-01,
    9.329971909359740e-01, 9.871664784143631e-01},
   {-9.455542414823662e-01, -8.559914774935045e-01, -7.316498014631939e-01,
    -5.775484768691215e-01, -3.999818343398130e-01, -2.062147934551938e-01,
    -4.178279499956644e-03, 1.978572426056912e-01, 3.916209437166875e-01,
    5.691804858622089e-01, 7.232669480810515e-01, 8.475727550502922e-01,
    9.370114803626848e-01, 9.879423822578670e-01},
   {-9.213405323982298e-01, -8.191530812718913e-01, -6.862182421056147e-01,
    -5.273616882897626e-01, -3.486229419300244e-01, -1.568482829897273e-01,
    4.060221440065589e-02, 2.361454791491090e-01, 4.222695774228935e-01,
    5.918235067181938e-01, 7.382925716753266e-01, 8.560492581055449e-01,
    9.405710797542279e-01, 9.886297914367171e-01},
   {-8.956243128031848e-01, -7.824879388346706e-01, -6.424595258511370e-01,
    -4.800058744226682e-01, -3.008503036738516e-01, -1.114139007278459e-01,
    8.148084907040697e-02, 2.708746515343146e-01, 4.499293275199216e-01,
    6.121776361861849e-01, 7.517583176886480e-01, 8.636288139522612e-01,
    9.437492282057267e-01, 9.892430321558936e-01}},
  {// a = 1
   {-9.871664784143631e-01, -9.329971909359740e-01, -8.380290006360896e-01,
    -7.063902646375723e-01, -5.438314587014840e-01, -3.574565120221275e-01,
    -1.554106853848594e-01, 5.347572267974627e-02, 2.600733767408079e-01,
    4.553529057785293e-01, 6.307794788869493e-01, 7.786856176390310e-01,
    8.926054001205508e-01, 9.675504681972001e-01},
   {-9.695680462702181e-01, -8.992005330934723e-01, -7.920082918618153e-01,
    -6.523887028824931e-01, -4.860594218871375e-01, -2.998304689007633e-01,
    -1.013262735219493e-01, 1.013262735219494e-01, 2.998304689007631e-01,
    4.860594218871379e-01, 6.523887028824933e-01, 7.920082918618150e-01,
    8.992005330934723e-01, 9.695680462702181e-01},
   {-9.488282127349588e-01, -8.645214689380346e-01, -7.471933239124674e-01,
    -6.012857583849247e-01, -4.323922573304602e-01, -2.469989436350616e-01,
    -5.222861229576757e-02, 1.444346476503013e-01, 3.354335885984767e-01,
    5.134284108882744e-01, 6.715788624029718e-01, 8.038069681730003e-01,
    9.050298305711774e-01, 9.713491721732797e-01},
   {-9.259196266960135e-01, -8.294978563227613e-01, -7.037315434527489e-01,
    -5.529003696348437e-01, -3.823945623908705e-01, -1.983555397813217e-01,
    -7.425888570215776e-03, 1.834981744510787e-01, 3.675185843502905e-01,
    5.379857442116746e-01, 6.887392688167489e-01, 8.143306946055725e-01,
    9.102197714126011e-01, 9.729331490008095e-01},
   {-9.015122251643732e-01, -7.945173126562066e-01, -6.617143688762277e-01,
    -5.070666283409846e-01, -3.357011963889833e-01, -1.534030104128147e-01,
    3.364266638379835e-02, 2.190778018779264e-01, 3.965941037313985e-01,
    5.601503105969163e-01, 7.041790253866186e-01, 8.237767275748286e-01,
    9.148703595248108e-01, 9.743510194905652e-01}},
  {// a = 2
   {-9.879423822578670e-01, -9.370114803626848e-01, -8.475727550502922e-01,
    -7.232669480810515e-01, -5.691804858622089e-01, -3.916209437166875e-01,
    -1.978572426056912e-01, 4.178279499956644e-03, 2.062147934551938e-01,
    3.999818343398130e-01, 5.775484768691215e-01, 7.316498014631939e-01,
    8.559914774935045e-01, 9.455542414823662e-01},
   {-9.713491721732797e-01, -9.050298305711774e-01, -8.038069681730003e-01,
    -6.715788624029718e-01, -5.134284108882744e-01, -3.354335885984767e-01,
    -1.444346476503013e-01, 5.222861229576757e-02, 2.469989436350616e-01,
    4.323922573304602e-01, 6.012857583849247e-01, 7.471933239124674e-01,
    8.645214689380346e-01, 9.488282127349588e-01},
   {-9.517299551512826e-01, -8.720925079976581e-01, -7.610187556794574e-01,
    -6.224601813697707e-01, -4.614117410818559e-01, -2.836899503115700e-01,
    -9.571632215598336e-02, 9.571632215598339e-02, 2.836899503115702e-01,
    4.614117410818562e-01, 6.224601813697704e-01, 7.610187556794574e-01,
    8.720925079976578e-01, 9.517299551512816e-01},
   {-9.299930693574174e-01, -8.387151945704939e-01, -7.193714788656792e-01,
    -5.757752998715386e-01, -4.127589541066776e-01, -2.358538267037598e-01,
    -5.107555113027149e-02, 1.352879146599514e-01, 3.168928900212988e-01,
    4.875571404387233e-01, 6.414713137074618e-01, 7.733984560034671e-01,
    8.788584305988894e-01, 9.543196534184706e-01},
   {-9.067679404933646e-01, -8.052741220001853e-01, -6.789732449993078e-01,
    -5.313965758720792e-01, -3.671559798643468e-01, -1.914824466486846e-01,
    -1.000079958841649e-02, 1.714671012158039e-01, 3.470952113819603e-01,
    5.112430718865147e-01, 6.586386330283140e-01, 7.845496440369255e-01,
    8.849417008614823e-01, 9.566451588200905e-01}},
  {// a = 3
   {-9.886297914367171e-01, -9.405710797542279e-01, -8.560492581055449e-01,
    -7.382925716753266e-01, -5.918235067181938e-01, -4.222695774228935e-01,
    -2.361454791491090e-01, -4.060221440065589e-02, 1.568482829897273e-01,
    3.486229419300244e-01, 5.273616882897626e-01, 6.862182421056147e-01,
    8.191530812718913e-01, 9.213405323982298e-01},
   {-9.729331490008095e-01, -9.102197714126011e-01, -8.143306946055725e-01,
    -6.887392688167489e-01, -5.379857442116746e-01, -3.675185843502905e-01,
    -1.834981744510787e-01, 7.425888570215776e-03, 1.983555397813217e-01,
    3.823945623908705e-01, 5.529003696348437e-01, 7.037315434527489e-01,
    8.294978563227613e-01, 9.259196266960135e-01},
   {-9.543196534184706e-01, -8.788584305988894e-01, -7.733984560034671e-01,
    -6.414713137074618e-01, -4.875571404387233e-01, -3.168928900212988e-01,
    -1.352879146599514e-01, 5.107555113027149e-02, 2.358538267037598e-01,
    4.127589541066776e-01, 5.757752998715386e-01, 7.193714788656792e-01,
    8.387151945704939e-01, 9.299930693574174e-01},
   {-9.336404975104380e-01, -8.469810432842003e-01, -7.334265985449164e-01,
    -5.963895043330733e-01, -4.402194426468624e-01, -2.699166024363143e-01,
    -9.094583560853807e-02, 9.094583560853824e-02, 2.699166024363141e-01,
    4.402194426468622e-01, 5.963895043330731e-01, 7.334265985449161e-01,
    8.469810432842000e-01, 9.336404975104384e-01},
   {-9.114885667667870e-01, -8.149518299963644e-01, -6.945353123697448e-01,
    -5.533973172747298e-01, -3.957016938581564e-01, -2.261943417931378e-01,
    -5.000477651748858e-02, 1.275250408431297e-01, 3.010087548760103e-01,
    4.651823505033575e-01, 6.150672654932331e-01, 7.461284802953800e-01,
    8.544363353075707e-01, 9.369256112577277e-01}},
  {// a = 4
   {-9.892430321558936e-01, -9.437492282057267e-01, -8.636288139522612e-01,
    -7.517583176886480e-01, -6.121776361861849e-01, -4.499293275199216e-01,
    -2.708746515343146e-01, -8.148084907040697e-02, 1.114139007278459e-01,
    3.008503036738516e-01, 4.800058744226682e-01, 6.424595258511370e-01,
    7.824879388346706e-01, 8.956243128031848e-01},
   {-9.743510194905652e-01, -9.148703595248108e-01, -8.237767275748286e-01,
    -7.041790253866186e-01, -5.601503105969163e-01, -3.965941037313985e-01,
    -2.190778018779264e-01, -3.364266638379835e-02, 1.534030104128147e-01,
    3.357011963889833e-01, 5.070666283409846e-01, 6.617143688762277e-01,
    7.945173126562066e-01, 9.015122251643732e-01},
   {-9.566451588200905e-01, -8.849417008614823e-01, -7.845496440369255e-01,
    -6.586386330283140e-01, -5.112430718865147e-01, -3.470952113819603e-01,
    -1.714671012158039e-01, 1.000079958841649e-02, 1.914824466486846e-01,
    3.671559798643468e-01, 5.313965758720792e-01, 6.789732449993078e-01,
    8.052741220001853e-01, 9.067679404933646e-01},
   {-9.369256112577277e-01, -8.544363353075707e-01, -7.461284802953800e-01,
    -6.150672654932331e-01, -4.651823505033575e-01, -3.010087548760103e-01,
    -1.275250408431297e-01, 5.000477651748858e-02, 2.261943417931378e-01,
    3.957016938581564e-01, 5.533973172747298e-01, 6.945353123697448e-01,
    8.149518299963644e-01, 9.114885667667870e-01},
   {-9.157522075247713e-01, -8.237062724568985e-01, -7.086420304384200e-01,
    -5.733938373825735e-01, -4.217337559554012e-01, -2.579806669485394e-01,
    -8.682433786103685e-02, 8.682433786103677e-02, 2.579806669485393e-01,
    4.217337559554015e-01, 5.733938373825737e-01, 7.086420304384200e-01,
    8.237062724568984e-01, 9.157522075247710e-01}}};
static double _gaussJacobiPt_15[5][5][15] = {
  {// a = 0
   {-9.879925180204854e-01, -9.372733924007058e-01, -8.482065834104272e-01,
    -7.244177313601701e-01, -5.709721726085393e-01, -3.941513470775634e-01,
    -2.011940939974345e-01, -8.775352290365505e-18, 2.011940939974347e-01,
    3.941513470775633e-01, 5.709721726085393e-01, 7.244177313601702e-01,
    8.482065834104268e-01, 9.372733924007057e-01, 9.879925180204855e-01},
   {-9.714610905263487e-01, -9.054008198116664e-01, -8.045734013587562e-01,
    -6.728619212112202e-01, -5.153294780626855e-01, -3.380303900599199e-01,
    -1.477783218133716e-01, 4.811538307353035e-02, 2.421226227060440e-01,
    4.267878274849456e-01, 5.950144898997918e-01, 7.403379488928178e-01,
    8.571740937696825e-01, 9.410354027041151e-01, 9.887186220549768e-01},
   {-9.519077486700472e-01, -8.725636434710378e-01, -7.618990574306275e-01,
    -6.238509545500194e-01, -4.633959461050459e-01, -2.863292035375701e-01,
    -9.904871118710282e-02, 9.167752849104549e-02, 2.789566128258846e-01,
    4.560200681410275e-01, 6.164685874446926e-01, 7.545034275690048e-01,
    8.651362683220029e-01, 9.443708761634801e-01, 9.893618959943125e-01},
   {-9.302370030518765e-01, -8.392771956636823e-01, -7.203493790211057e-01,
    -5.772536773256602e-01, -4.148055995879016e-01, -2.385173322680288e-01,
    -5.438366372937470e-02, 1.313291689648413e-01, 3.122992582302949e-01,
    4.823652765933844e-01, 6.357367475568939e-01, 7.671915120184530e-01,
    8.722539177842026e-01, 9.473485817737878e-01, 9.899357513621353e-01},
   {-9.070761581549767e-01, -8.059178909088814e-01, -6.800346165868267e-01,
    -5.329459599609458e-01, -3.692485872705891e-01, -1.941562655040178e-01,
    -1.327533184434133e-02, 1.675914220447396e-01, 3.426368994804752e-01,
    5.062386877385864e-01, 6.531408708912725e-01, 7.786235676115519e-01,
    8.786551557289582e-01, 9.500232370953487e-01, 9.904508519925874e-01}},
  {// a = 1
   {-9.887186220549768e-01, -9.410354027041151e-01, -8.571740937696825e-01,
    -7.403379488928178e-01, -5.950144898997918e-01, -4.267878274849456e-01,
    -2.421226227060440e-01, -4.811538307353035e-02, 1.477783218133716e-01,
    3.380303900599199e-01, 5.153294780626855e-01, 6.728619212112202e-01,
    8.045734013587562e-01, 9.054008198116664e-01, 9.714610905263487e-01},
   {-9.731321766314176e-01, -9.108799959155736e-01, -8.156962512217703e-01,
    -6.910289806276844e-01, -5.413853993301014e-01, -3.721744335654771e-01,
    -1.895119735183171e-01, -1.062702462397255e-16, 1.895119735183174e-01,
    3.721744335654765e-01, 5.413853993301015e-01, 6.910289806276848e-01,
    8.156962512217705e-01, 9.108799959155733e-01, 9.731321766314182e-01},
   {-9.546368989897532e-01, -8.796998267938857e-01, -7.749725606727137e-01,
    -6.439623806560700e-01, -4.911186416765717e-01, -3.216424211165446e-01,
    -1.413034773917096e-01, 4.375769163449201e-02, 2.272394230515447e-01,
    4.028936578980453e-01, 5.647387725977340e-01, 7.072632657024025e-01,
    8.256133057273756e-01, 9.157573308768492e-01, 9.746182143542607e-01},
   {-9.340771185735171e-01, -8.479879583912526e-01, -7.351810111688980e-01,
    -5.990463806247165e-01, -4.439054441337806e-01, -2.747259553942212e-01,
    -9.693751531355099e-02, 8.374954028591096e-02, 2.615299181081761e-01,
    4.306908476223183e-01, 5.857960839438230e-01, 7.218607883366844e-01,
    8.345117004808159e-01, 9.201270930490951e-01, 9.759483529495837e-01},
   {-9.120418435252217e-01, -8.161086826141644e-01, -6.964452749078387e-01,
    -5.561903872314952e-01, -3.994821387837031e-01, -2.310372004666394e-01,
    -5.595368849274608e-02, 1.204587645778244e-01, 2.928456554515722e-01,
    4.559724985456258e-01, 6.048848773904851e-01, 7.350594536294244e-01,
    8.425415407228948e-01, 9.240647910019436e-01, 9.771459204163240e-01}},
  {// a = 2
   {-9.893618959943125e-01, -9.443708761634801e-01, -8.651362683220029e-01,
    -7.545034275690048e-01, -6.164685874446926e-01, -4.560200681410275e-01,
    -2.789566128258846e-01, -9.167752849104549e-02, 9.904871118710282e-02,
    2.863292035375701e-01, 4.633959461050459e-01, 6.238509545500194e-01,
    7.618990574306275e-01, 8.725636434710378e-01, 9.519077486700472e-01},
   {-9.746182143542607e-01, -9.157573308768492e-01, -8.256133057273756e-01,
    -7.072632657024025e-01, -5.647387725977340e-01, -4.028936578980453e-01,
    -2.272394230515447e-01, -4.375769163449201e-02, 1.413034773917096e-01,
    3.216424211165446e-01, 4.911186416765717e-01, 6.439623806560700e-01,
    7.749725606727137e-01, 8.796998267938857e-01, 9.546368989897532e-01},
   {-9.570723569250649e-01, -8.860756470171520e-01, -7.866736157817856e-01,
    -6.620052748493139e-01, -5.160661648573681e-01, -3.535432174725606e-01,
    -1.796585048481437e-01, -4.609842526636674e-16, 1.796585048481435e-01,
    3.535432174725607e-01, 5.160661648573680e-01, 6.620052748493132e-01,
    7.866736157817855e-01, 8.860756470171529e-01, 9.570723569250653e-01},
   {-9.375152153081482e-01, -8.557973197264757e-01, -7.485028549147995e-01,
    -6.186689672872857e-01, -4.701894279164579e-01, -3.075580988701691e-01,
    -1.357088578802053e-01, 4.014057436815714e-02, 2.146493274139599e-01,
    3.825165807978498e-01, 5.386431713491237e-01, 6.782871379922397e-01,
    7.972092103695705e-01, 8.918069782350803e-01, 9.592591899489894e-01},
   {-9.165012968427499e-01, -8.252741537357187e-01, -7.112340906696808e-01,
    -5.771908195301713e-01, -4.268836655920332e-01, -2.645942743101839e-01,
    -9.497246357770434e-02, 7.711178614625226e-02, 2.467134954931324e-01,
    4.089570916809139e-01, 5.591777863472297e-01, 6.930566578591542e-01,
    8.067464015278942e-01, 8.969871994293460e-01, 9.612336791076534e-01}},
  {// a = 3
   {-9.899357513621353e-01, -9.473485817737878e-01, -8.722539177842026e-01,
    -7.671915120184530e-01, -6.357367475568939e-01, -4.823652765933844e-01,
    -3.122992582302949e-01, -1.313291689648413e-01, 5.438366372937470e-02,
    2.385173322680288e-01, 4.148055995879016e-01, 5.772536773256602e-01,
    7.203493790211057e-01, 8.392771956636823e-01, 9.302370030518765e-01},
   {-9.759483529495837e-01, -9.201270930490951e-01, -8.345117004808159e-01,
    -7.218607883366844e-01, -5.857960839438230e-01, -4.306908476223183e-01,
    -2.615299181081761e-01, -8.374954028591096e-02, 9.693751531355099e-02,
    2.747259553942212e-01, 4.439054441337806e-01, 5.990463806247165e-01,
    7.351810111688980e-01, 8.479879583912526e-01, 9.340771185735171e-01},
   {-9.592591899489894e-01, -8.918069782350803e-01, -7.972092103695705e-01,
    -6.782871379922397e-01, -5.386431713491237e-01, -3.825165807978498e-01,
    -2.146493274139599e-01, -4.014057436815714e-02, 1.357088578802053e-01,
    3.075580988701691e-01, 4.701894279164579e-01, 6.186689672872857e-01,
    7.485028549147995e-01, 8.557973197264757e-01, 9.375152153081482e-01},
   {-9.406114633231666e-01, -8.628391076256091e-01, -7.605365042686635e-01,
    -6.364350506390479e-01, -4.940562478763855e-01, -3.374791447825760e-01,
    -1.712006196860757e-01, 5.320929732608815e-18, 1.712006196860760e-01,
    3.374791447825756e-01, 4.940562478763855e-01, 6.364350506390479e-01,
    7.605365042686636e-01, 8.628391076256089e-01, 9.406114633231664e-01},
   {-9.205285031164320e-01, -8.335627913756348e-01, -7.246330284619493e-01,
    -5.962629586010140e-01, -4.518431265230561e-01, -2.952724832473960e-01,
    -1.308035671394406e-01, 3.708709078110611e-02, 2.038260180478653e-01,
    3.648698701790187e-01, 5.158310383530933e-01, 6.525997025097098e-01,
    7.714618119693399e-01, 8.692217675427797e-01, 9.434145644874151e-01}},
  {// a = 4
   {-9.904508519925874e-01, -9.500232370953487e-01, -8.786551557289582e-01,
    -7.786235676115519e-01, -6.531408708912725e-01, -5.062386877385864e-01,
    -3.426368994804752e-01, -1.675914220447396e-01, 1.327533184434133e-02,
    1.941562655040178e-01, 3.692485872705891e-01, 5.329459599609458e-01,
    6.800346165868267e-01, 8.059178909088814e-01, 9.070761581549767e-01},
   {-9.771459204163240e-01, -9.240647910019436e-01, -8.425415407228948e-01,
    -7.350594536294244e-01, -6.048848773904851e-01, -4.559724985456258e-01,
    -2.928456554515722e-01, -1.204587645778244e-01, 5.595368849274608e-02,
    2.310372004666394e-01, 3.994821387837031e-01, 5.561903872314952e-01,
    6.964452749078387e-01, 8.161086826141644e-01, 9.120418435252217e-01},
   {-9.612336791076534e-01, -8.969871994293460e-01, -8.067464015278942e-01,
    -6.930566578591542e-01, -5.591777863472297e-01, -4.089570916809139e-01,
    -2.467134954931324e-01, -7.711178614625226e-02, 9.497246357770434e-02,
    2.645942743101839e-01, 4.268836655920332e-01, 5.771908195301713e-01,
    7.112340906696808e-01, 8.252741537357187e-01, 9.165012968427499e-01},
   {-9.434145644874151e-01, -8.692217675427797e-01, -7.714618119693399e-01,
    -6.525997025097098e-01, -5.158310383530933e-01, -3.648698701790187e-01,
    -2.038260180478653e-01, -3.708709078110611e-02, 1.308035671394406e-01,
    2.952724832473960e-01, 4.518431265230561e-01, 5.962629586010140e-01,
    7.246330284619493e-01, 8.335627913756348e-01, 9.205285031164320e-01},
   {-9.241836441156038e-01, -8.410955304608326e-01, -7.368313252269588e-01,
    -6.136649010261924e-01, -4.746801705494179e-01, -3.234377875279980e-01,
    -1.638366843073226e-01, 6.866986139640594e-17, 1.638366843073226e-01,
    3.234377875279979e-01, 4.746801705494182e-01, 6.136649010261921e-01,
    7.368313252269589e-01, 8.410955304608326e-01, 9.241836441156041e-01}}};
static double _gaussJacobiPt_16[5][5][16] = {
  {// a = 0
   {-9.894009349916498e-01, -9.445750230732327e-01, -8.656312023878318e-01,
    -7.554044083550032e-01, -6.178762444026438e-01, -4.580167776572273e-01,
    -2.816035507792587e-01, -9.501250983763743e-02, 9.501250983763739e-02,
    2.816035507792591e-01, 4.580167776572278e-01, 6.178762444026438e-01,
    7.554044083550032e-01, 8.656312023878316e-01, 9.445750230732322e-01,
    9.894009349916498e-01},
   {-9.747060412520832e-01, -9.160488353809505e-01, -8.262167530742823e-01,
    -7.082762955504214e-01, -5.662451079297364e-01, -4.049602758500824e-01,
    -2.299143037529789e-01, -4.706823205033688e-02, 1.373513128087494e-01,
    3.170641449043537e-01, 4.859503843096581e-01, 6.382588806842324e-01,
    7.688031248403683e-01, 8.731381088323267e-01, 9.477129726372123e-01,
    9.900054006724562e-01},
   {-9.572128749973940e-01, -8.864485714244914e-01, -7.873719490976079e-01,
    -6.631117660529239e-01, -5.176505158982829e-01, -3.556598348291217e-01,
    -1.823447706330063e-01, -3.275112306375042e-03, 1.757940717662811e-01,
    3.491075799517409e-01, 5.110951365109774e-01, 6.565504810339957e-01,
    7.807987814824587e-01, 8.798471245667236e-01, 9.505140647611299e-01,
    9.905446257541308e-01},
   {-9.377092719183144e-01, -8.562451750037930e-01, -7.492839650298050e-01,
    -6.198533769301103e-01, -4.718351192889191e-01, -3.097091416491135e-01,
    -1.383940640462959e-01, 3.690849614668840e-02, 2.108740894722364e-01,
    3.782180657649011e-01, 5.338565354412820e-01, 6.730610490487624e-01,
    7.916024265417829e-01, 8.858795299221087e-01, 9.530298592323596e-01,
    9.910286337248018e-01},
   {-9.167479775042821e-01, -8.257903604647133e-01, -7.120872458188394e-01,
    -5.784400647678622e-01, -4.285771241777813e-01, -2.667674616449476e-01,
    -9.764721963226911e-02, 7.392791326390238e-02, 2.430274096054646e-01,
    4.047898233844638e-01, 5.545636130543964e-01, 6.880414611442671e-01,
    8.013845042207106e-01, 8.913331227981797e-01, 9.553018899056175e-01,
    9.914654944114704e-01}},
  {// a = 1
   {-9.900054006724562e-01, -9.477129726372123e-01, -8.731381088323267e-01,
    -7.688031248403683e-01, -6.382588806842324e-01, -4.859503843096581e-01,
    -3.170641449043537e-01, -1.373513128087494e-01, 4.706823205033688e-02,
    2.299143037529789e-01, 4.049602758500824e-01, 5.662451079297364e-01,
    7.082762955504214e-01, 8.262167530742823e-01, 9.160488353809505e-01,
    9.747060412520832e-01},
   {-9.761055574121982e-01, -9.206491853475337e-01, -8.355935352180905e-01,
    -7.236793292832425e-01, -5.885048343186619e-01, -4.344150369121241e-01,
    -2.663626528782810e-01, -8.974909348465208e-02, 8.974909348465229e-02,
    2.663626528782810e-01, 4.344150369121239e-01, 5.885048343186617e-01,
    7.236793292832425e-01, 8.355935352180902e-01, 9.206491853475338e-01,
    9.761055574121985e-01},
   {-9.595114682455033e-01, -8.924769893388035e-01, -7.984651844798845e-01,
    -6.802799728644459e-01, -5.415016596022540e-01, -3.863435570617144e-01,
    -2.195186934229180e-01, -4.609531222738535e-02, 1.286575395980946e-01,
    2.994302662032589e-01, 4.610341154503937e-01, 6.085588543979088e-01,
    7.375219388154022e-01, 8.440045809240291e-01, 9.247702002457903e-01,
    9.773581987508880e-01},
   {-9.409608366407752e-01, -8.636460712122042e-01, -7.619455202124780e-01,
    -6.385746462731227e-01, -4.970344264511430e-01, -3.413801895594403e-01,
    -1.760827651118862e-01, -5.893982585463109e-03, 1.642920271882932e-01,
    3.295804243787531e-01, 4.852168301957202e-01, 6.267242648147607e-01,
    7.500319955706670e-01, 8.515925628534156e-01, 9.284832715262351e-01,
    9.784859504075568e-01},
   {-9.209737734118978e-01, -8.344954070119577e-01, -7.261762199358890e-01,
    -5.985259449824257e-01, -4.549163129786197e-01, -2.992246909546222e-01,
    -1.356801738983313e-01, 3.126520422397432e-02, 1.970626556302207e-01,
    3.571926768572186e-01, 5.072892310515162e-01, 6.432592858831594e-01,
    7.613946691623876e-01, 8.584732305760546e-01, 9.318462517780637e-01,
    9.795066153084454e-01}},
  {// a = 2
   {-9.905446257541308e-01, -9.505140647611299e-01, -8.798471245667236e-01,
    -7.807987814824587e-01, -6.565504810339957e-01, -5.110951365109774e-01,
    -3.491075799517409e-01, -1.757940717662811e-01, 3.275112306375042e-03,
    1.823447706330063e-01, 3.556598348291217e-01, 5.176505158982829e-01,
    6.631117660529239e-01, 7.873719490976079e-01, 8.864485714244914e-01,
    9.572128749973940e-01},
   {-9.773581987508880e-01, -9.247702002457903e-01, -8.440045809240291e-01,
    -7.375219388154022e-01, -6.085588543979088e-01, -4.610341154503937e-01,
    -2.994302662032589e-01, -1.286575395980946e-01, 4.609531222738535e-02,
    2.195186934229180e-01, 3.863435570617144e-01, 5.415016596022540e-01,
    6.802799728644459e-01, 7.984651844798845e-01, 8.924769893388035e-01,
    9.595114682455033e-01},
   {-9.615752688648729e-01, -8.978950350642905e-01, -8.084499084464360e-01,
    -6.957632079030802e-01, -5.630665755046921e-01, -4.141742040127355e-01,
    -2.533681074573462e-01, -8.527369670920626e-02, 8.527369670920577e-02,
    2.533681074573459e-01, 4.141742040127351e-01, 5.630665755046921e-01,
    6.957632079030803e-01, 8.084499084464359e-01, 8.978950350642909e-01,
    9.615752688648739e-01},
   {-9.438888240199840e-01, -8.703180459982073e-01, -7.733780575517809e-01,
    -6.555135690475470e-01, -5.198939197866800e-01, -3.702027782115193e-01,
    -2.105166025818927e-01, -4.518785730822867e-02, 1.212756205471697e-01,
    2.843343709525846e-01, 4.395415393726846e-01, 5.826644873682109e-01,
    7.098007121044375e-01, 8.174855142419918e-01, 9.027912835169776e-01,
    9.634385588342155e-01},
   {-9.247895108353522e-01, -8.423656112568880e-01, -7.389353075463891e-01,
    -6.167546547591967e-01, -4.788834203333949e-01, -3.288545112075327e-01,
    -1.705367278255938e-01, -8.021803085205316e-03, 1.544860902785040e-01,
    3.127811143606774e-01, 4.627656149166524e-01, 6.005568188437546e-01,
    7.225879867803563e-01, 8.257020348063675e-01, 9.072379035241481e-01,
    9.651292464969872e-01}},
  {// a = 3
   {-9.910286337248018e-01, -9.530298592323596e-01, -8.858795299221087e-01,
    -7.916024265417829e-01, -6.730610490487624e-01, -5.338565354412820e-01,
    -3.782180657649011e-01, -2.108740894722364e-01, -3.690849614668840e-02,
    1.383940640462959e-01, 3.097091416491135e-01, 4.718351192889191e-01,
    6.198533769301103e-01, 7.492839650298050e-01, 8.562451750037930e-01,
    9.377092719183144e-01},
   {-9.784859504075568e-01, -9.284832715262351e-01, -8.515925628534156e-01,
    -7.500319955706670e-01, -6.267242648147607e-01, -4.852168301957202e-01,
    -3.295804243787531e-01, -1.642920271882932e-01, 5.893982585463109e-03,
    1.760827651118862e-01, 3.413801895594403e-01, 4.970344264511430e-01,
    6.385746462731227e-01, 7.619455202124780e-01, 8.636460712122042e-01,
    9.409608366407752e-01},
   {-9.634385588342155e-01, -9.027912835169776e-01, -8.174855142419918e-01,
    -7.098007121044375e-01, -5.826644873682109e-01, -4.395415393726846e-01,
    -2.843343709525846e-01, -1.212756205471697e-01, 4.518785730822867e-02,
    2.105166025818927e-01, 3.702027782115193e-01, 5.198939197866800e-01,
    6.555135690475470e-01, 7.733780575517809e-01, 8.703180459982073e-01,
    9.438888240199840e-01},
   {-9.465393703611532e-01, -8.763642873336548e-01, -7.837538028121771e-01,
    -6.709165393977796e-01, -5.407313772935233e-01, -3.965549962084527e-01,
    -2.421148815938047e-01, -8.140743165627992e-02, 8.140743165627992e-02,
    2.421148815938046e-01, 3.965549962084526e-01, 5.407313772935235e-01,
    6.709165393977797e-01, 7.837538028121770e-01, 8.763642873336551e-01,
    9.465393703611527e-01},
   {-9.282523434212562e-01, -8.495163902626972e-01, -7.505463464780788e-01,
    -6.333764810492698e-01, -5.007922253354110e-01, -3.560220833420524e-01,
    -2.026145434279687e-01, -4.433851788871399e-02, 1.149138254938367e-01,
    2.712248220317488e-01, 4.207489017311875e-01, 5.598083768784687e-01,
    6.849859355910252e-01, 7.932139708221823e-01, 8.818692907531401e-01,
    9.489502181602690e-01}},
  {// a = 4
   {-9.914654944114704e-01, -9.553018899056175e-01, -8.913331227981797e-01,
    -8.013845042207106e-01, -6.880414611442671e-01, -5.545636130543964e-01,
    -4.047898233844638e-01, -2.430274096054646e-01, -7.392791326390238e-02,
    9.764721963226911e-02, 2.667674616449476e-01, 4.285771241777813e-01,
    5.784400647678622e-01, 7.120872458188394e-01, 8.257903604647133e-01,
    9.167479775042821e-01},
   {-9.795066153084454e-01, -9.318462517780637e-01, -8.584732305760546e-01,
    -7.613946691623876e-01, -6.432592858831594e-01, -5.072892310515162e-01,
    -3.571926768572186e-01, -1.970626556302207e-01, -3.126520422397432e-02,
    1.356801738983313e-01, 2.992246909546222e-01, 4.549163129786197e-01,
    5.985259449824257e-01, 7.261762199358890e-01, 8.344954070119577e-01,
    9.209737734118978e-01},
   {-9.651292464969872e-01, -9.072379035241481e-01, -8.257020348063675e-01,
    -7.225879867803563e-01, -6.005568188437546e-01, -4.627656149166524e-01,
    -3.127811143606774e-01, -1.544860902785040e-01, 8.021803085205316e-03,
    1.705367278255938e-01, 3.288545112075327e-01, 4.788834203333949e-01,
    6.167546547591967e-01, 7.389353075463891e-01, 8.423656112568880e-01,
    9.247895108353522e-01},
   {-9.489502181602690e-01, -8.818692907531401e-01, -7.932139708221823e-01,
    -6.849859355910252e-01, -5.598083768784687e-01, -4.207489017311875e-01,
    -2.712248220317488e-01, -1.149138254938367e-01, 4.433851788871399e-02,
    2.026145434279687e-01, 3.560220833420524e-01, 5.007922253354110e-01,
    6.333764810492698e-01, 7.505463464780788e-01, 8.495163902626972e-01,
    9.282523434212562e-01},
   {-9.314092374214358e-01, -8.560426877689151e-01, -7.611591267205700e-01,
    -6.485979623693823e-01, -5.209022245954822e-01, -3.810302000144717e-01,
    -2.322444337687661e-01, -7.802355528024467e-02, 7.802355528024484e-02,
    2.322444337687661e-01, 3.810302000144720e-01, 5.209022245954824e-01,
    6.485979623693826e-01, 7.611591267205696e-01, 8.560426877689152e-01,
    9.314092374214352e-01}}};
static double _gaussJacobiPt_17[5][5][17] = {
  {// a = 0
   {-9.905754753144175e-01, -9.506755217687679e-01, -8.802391537269858e-01,
    -7.815140038968016e-01, -6.576711592166909e-01, -5.126905370864770e-01,
    -3.512317634538761e-01, -1.784841814958475e-01, 2.891240832020117e-16,
    1.784841814958480e-01, 3.512317634538758e-01, 5.126905370864769e-01,
    6.576711592166909e-01, 7.815140038968014e-01, 8.802391537269861e-01,
    9.506755217687678e-01, 9.905754753144176e-01},
   {-9.774280812644873e-01, -9.250023956466999e-01, -8.444860691845969e-01,
    -7.383321191348272e-01, -6.097671570499329e-01, -4.626979054681029e-01,
    -3.015931169067645e-01, -1.313479337732691e-01, 4.286480629384036e-02,
    2.157517305558086e-01, 3.820597644956084e-01, 5.367357484456553e-01,
    6.750799931437268e-01, 7.928891341296058e-01, 8.865840624618436e-01,
    9.533198117524516e-01, 9.910840128644255e-01},
   {-9.616877876948248e-01, -8.981940331930888e-01, -8.090108466286575e-01,
    -6.966541714199016e-01, -5.643462061624421e-01, -4.158900027701711e-01,
    -2.555550770936288e-01, -8.795335618095160e-02, 8.209389329396230e-02,
    2.496949167183642e-01, 4.100282674039528e-01, 5.584815496156972e-01,
    6.907841434682287e-01, 8.031301263389173e-01, 8.922879703456302e-01,
    9.556945893763397e-01, 9.915404690270184e-01},
   {-9.440451254615260e-01, -8.706792905502057e-01, -7.740093571093564e-01,
    -6.564732388028863e-01, -5.212314653521029e-01, -3.719574707953516e-01,
    -2.127163966347863e-01, -4.784864049312098e-02, 1.181504282279267e-01,
    2.807538473356057e-01, 4.355268889593358e-01, 5.782482020488821e-01,
    7.050250660668096e-01, 8.123996757237790e-01, 8.974436826849810e-01,
    9.578391162452090e-01, 9.919524562851854e-01},
   {-9.249892783053915e-01, -8.427843144252944e-01, -7.396287586026777e-01,
    -6.177726863246541e-01, -4.802677558932255e-01, -3.306375157462263e-01,
    -1.727405267608647e-01, -1.065770795451046e-02, 1.514178501087743e-01,
    3.092913409538758e-01, 4.588757464889782e-01, 5.962981277200242e-01,
    7.180001816621536e-01, 8.208305814129484e-01, 9.021268559589816e-01,
    9.597853716854473e-01, 9.923261722321879e-01}},
  {// a = 1
   {-9.910840128644255e-01, -9.533198117524516e-01, -8.865840624618436e-01,
    -7.928891341296058e-01, -6.750799931437268e-01, -5.367357484456553e-01,
    -3.820597644956084e-01, -2.157517305558086e-01, -4.286480629384036e-02,
    1.313479337732691e-01, 3.015931169067645e-01, 4.626979054681029e-01,
    6.097671570499329e-01, 7.383321191348272e-01, 8.444860691845969e-01,
    9.250023956466999e-01, 9.774280812644873e-01},
   {-9.786117662220799e-01, -9.289015281525864e-01, -8.524605777966460e-01,
    -7.514942025526127e-01, -6.289081372652203e-01, -4.882292856807139e-01,
    -3.335048478244987e-01, -1.691860234092818e-01, -1.665046143760084e-16,
    1.691860234092817e-01, 3.335048478244990e-01, 4.882292856807132e-01,
    6.289081372652205e-01, 7.514942025526128e-01, 8.524605777966462e-01,
    9.289015281525863e-01, 9.786117662220806e-01},
   {-9.636416865082660e-01, -9.033313870695993e-01, -8.184996794834295e-01,
    -7.114134481279344e-01, -5.849841648087440e-01, -4.426574597624207e-01,
    -2.883144119743151e-01, -1.261645224344254e-01, 3.936948234963909e-02,
    2.037724323515019e-01, 3.625599355735324e-01, 5.114007245456810e-01,
    6.462348034849609e-01, 7.633841646531336e-01, 8.596529930005170e-01,
    9.324142828193726e-01, 9.796774008502553e-01},
   {-9.468222497938702e-01, -8.770185326029446e-01, -7.848982279745622e-01,
    -6.726583574659784e-01, -5.431626894326741e-01, -3.997503128986412e-01,
    -2.461292332798860e-01, -8.627505968926927e-02, 7.567375096313100e-02,
    2.355237922490816e-01, 3.891356348643729e-01, 5.325311889144551e-01,
    6.619968051286731e-01, 7.741794671498309e-01, 8.661735399229268e-01,
    9.355955080676056e-01, 9.806418179830122e-01},
   {-9.286147395489064e-01, -8.502765366317450e-01, -7.518065551615287e-01,
    -6.352288720488580e-01, -5.033149654427417e-01, -3.592771942669792e-01,
    -2.066463540871556e-01, -4.917265901033056e-02, 1.092708637575098e-01,
    2.647854992377059e-01, 4.135436549332882e-01, 5.518835134075636e-01,
    6.763994067228070e-01, 7.840257663815949e-01, 8.721125674704689e-01,
    9.384901185215214e-01, 9.815187934580930e-01}},
  {// a = 2
   {-9.915404690270184e-01, -9.556945893763397e-01, -8.922879703456302e-01,
    -8.031301263389173e-01, -6.907841434682287e-01, -5.584815496156972e-01,
    -4.100282674039528e-01, -2.496949167183642e-01, -8.209389329396230e-02,
    8.795335618095160e-02, 2.555550770936288e-01, 4.158900027701711e-01,
    5.643462061624421e-01, 6.966541714199016e-01, 8.090108466286575e-01,
    8.981940331930888e-01, 9.616877876948248e-01},
   {-9.796774008502553e-01, -9.324142828193726e-01, -8.596529930005170e-01,
    -7.633841646531336e-01, -6.462348034849609e-01, -5.114007245456810e-01,
    -3.625599355735324e-01, -2.037724323515019e-01, -3.936948234963909e-02,
    1.261645224344254e-01, 2.883144119743151e-01, 4.426574597624207e-01,
    5.849841648087440e-01, 7.114134481279344e-01, 8.184996794834295e-01,
    9.033313870695993e-01, 9.636416865082660e-01},
   {-9.654056566363756e-01, -9.079732908611975e-01, -8.270840670608106e-01,
    -7.247881935933748e-01, -6.037259844098118e-01, -4.670299895594999e-01,
    -3.182393733097758e-01, -1.612071437949028e-01, 1.150186551453999e-16,
    1.612071437949027e-01, 3.182393733097758e-01, 4.670299895594998e-01,
    6.037259844098116e-01, 7.247881935933748e-01, 8.270840670608109e-01,
    9.079732908611978e-01, 9.654056566363753e-01},
   {-9.493360375532447e-01, -8.827622111968597e-01, -7.947773237268659e-01,
    -6.873681609495105e-01, -5.631384234390187e-01, -4.251330011379990e-01,
    -2.767440389967885e-01, -1.216223878338291e-01, 3.641400098237035e-02,
    1.934747798438161e-01, 3.456933308446512e-01, 4.893221814341125e-01,
    6.208254882814699e-01, 7.369664831223374e-01, 8.348882494392900e-01,
    9.121883604997983e-01, 9.670061462837062e-01},
   {-9.319045732496574e-01, -8.570824487650820e-01, -7.628845637619294e-01,
    -6.511372729771566e-01, -5.243655614869540e-01, -3.855067963818991e-01,
    -2.378005881335030e-01, -8.470135365007662e-02, 7.020671612619145e-02,
    2.232953532172637e-01, 3.709780547084832e-01, 5.097945900205915e-01,
    6.364924385626791e-01, 7.481034669599836e-01, 8.420145731709701e-01,
    9.160330611344176e-01, 9.684649045056777e-01}},
  {// a = 3
   {-9.919524562851854e-01, -9.578391162452090e-01, -8.974436826849810e-01,
    -8.123996757237790e-01, -7.050250660668096e-01, -5.782482020488821e-01,
    -4.355268889593358e-01, -2.807538473356057e-01, -1.181504282279267e-01,
    4.784864049312098e-02, 2.127163966347863e-01, 3.719574707953516e-01,
    5.212314653521029e-01, 6.564732388028863e-01, 7.740093571093564e-01,
    8.706792905502057e-01, 9.440451254615260e-01},
   {-9.806418179830122e-01, -9.355955080676056e-01, -8.661735399229268e-01,
    -7.741794671498309e-01, -6.619968051286731e-01, -5.325311889144551e-01,
    -3.891356348643729e-01, -2.355237922490816e-01, -7.567375096313100e-02,
    8.627505968926927e-02, 2.461292332798860e-01, 3.997503128986412e-01,
    5.431626894326741e-01, 6.726583574659784e-01, 7.848982279745622e-01,
    8.770185326029446e-01, 9.468222497938702e-01},
   {-9.670061462837062e-01, -9.121883604997983e-01, -8.348882494392900e-01,
    -7.369664831223374e-01, -6.208254882814699e-01, -4.893221814341125e-01,
    -3.456933308446512e-01, -1.934747798438161e-01, -3.641400098237035e-02,
    1.216223878338291e-01, 2.767440389967885e-01, 4.251330011379990e-01,
    5.631384234390187e-01, 6.873681609495105e-01, 7.947773237268659e-01,
    8.827622111968597e-01, 9.493360375532447e-01},
   {-9.516223373047707e-01, -8.879908826152110e-01, -8.037819975688445e-01,
    -7.007980407964133e-01, -5.814136612436279e-01, -4.484136433201561e-01,
    -3.049095404575777e-01, -1.542619339178430e-01, -1.418789690956185e-16,
    1.542619339178432e-01, 3.049095404575780e-01, 4.484136433201565e-01,
    5.814136612436285e-01, 7.007980407964132e-01, 8.037819975688439e-01,
    8.879908826152105e-01, 9.516223373047705e-01},
   {-9.349034872157332e-01, -8.632928073826790e-01, -7.730067925955711e-01,
    -6.656979776524788e-01, -5.436734702399830e-01, -4.096265485206677e-01,
    -2.665370690765072e-01, -1.175939058162494e-01, 3.388019332106498e-02,
    1.845044982654642e-01, 3.309166897023827e-01, 4.698486159552260e-01,
    5.982001155246841e-01, 7.131099311825061e-01, 8.120242635794045e-01,
    8.927711382360564e-01, 9.537107590745444e-01}},
  {// a = 4
   {-9.923261722321879e-01, -9.597853716854473e-01, -9.021268559589816e-01,
    -8.208305814129484e-01, -7.180001816621536e-01, -5.962981277200242e-01,
    -4.588757464889782e-01, -3.092913409538758e-01, -1.514178501087743e-01,
    1.065770795451046e-02, 1.727405267608647e-01, 3.306375157462263e-01,
    4.802677558932255e-01, 6.177726863246541e-01, 7.396287586026777e-01,
    8.427843144252944e-01, 9.249892783053915e-01},
   {-9.815187934580930e-01, -9.384901185215214e-01, -8.721125674704689e-01,
    -7.840257663815949e-01, -6.763994067228070e-01, -5.518835134075636e-01,
    -4.135436549332882e-01, -2.647854992377059e-01, -1.092708637575098e-01,
    4.917265901033056e-02, 2.066463540871556e-01, 3.592771942669792e-01,
    5.033149654427417e-01, 6.352288720488580e-01, 7.518065551615287e-01,
    8.502765366317450e-01, 9.286147395489064e-01},
   {-9.684649045056777e-01, -9.160330611344176e-01, -8.420145731709701e-01,
    -7.481034669599836e-01, -6.364924385626791e-01, -5.097945900205915e-01,
    -3.709780547084832e-01, -2.232953532172637e-01, -7.020671612619145e-02,
    8.470135365007662e-02, 2.378005881335030e-01, 3.855067963818991e-01,
    5.243655614869540e-01, 6.511372729771566e-01, 7.628845637619294e-01,
    8.570824487650820e-01, 9.319045732496574e-01},
   {-9.537107590745444e-01, -8.927711382360564e-01, -8.120242635794045e-01,
    -7.131099311825061e-01, -5.982001155246841e-01, -4.698486159552260e-01,
    -3.309166897023827e-01, -1.845044982654642e-01, -3.388019332106498e-02,
    1.175939058162494e-01, 2.665370690765072e-01, 4.096265485206677e-01,
    5.436734702399830e-01, 6.656979776524788e-01, 7.730067925955711e-01,
    8.632928073826790e-01, 9.349034872157332e-01},
   {-9.376485606026945e-01, -8.689829496453235e-01, -7.822929230769724e-01,
    -6.790775203475938e-01, -5.614504190051148e-01, -4.318873330057092e-01,
    -2.931355035976249e-01, -1.481445906475424e-01, 2.150030887489372e-16,
    1.481445906475425e-01, 2.931355035976240e-01, 4.318873330057091e-01,
    5.614504190051155e-01, 6.790775203475938e-01, 7.822929230769724e-01,
    8.689829496453246e-01, 9.376485606026940e-01}}};
static double _gaussJacobiPt_18[5][5][18] = {
  {// a = 0
   {-9.915651684209310e-01, -9.558239495713977e-01, -8.926024664975554e-01,
    -8.037049589725231e-01, -6.916870430603531e-01, -5.597708310739477e-01,
    -4.117511614628424e-01, -2.518862256915055e-01, -8.477501304173533e-02,
    8.477501304173478e-02, 2.518862256915057e-01, 4.117511614628427e-01,
    5.597708310739473e-01, 6.916870430603532e-01, 8.037049589725230e-01,
    8.926024664975557e-01, 9.558239495713977e-01, 9.915651684209309e-01},
   {-9.797336964051945e-01, -9.326015038912652e-01, -8.600417793993865e-01,
    -7.640396507241585e-01, -6.472148595497391e-01, -5.127543868123012e-01,
    -3.643260782273030e-01, -2.059787211196644e-01, -4.203164174155230e-02,
    1.230431015517241e-01, 2.847427000467310e-01, 4.386564198796566e-01,
    5.805859208223142e-01, 7.066597926447641e-01, 8.134392081429099e-01,
    8.980119168242189e-01, 9.580727032124667e-01, 9.919970412322650e-01},
   {-9.654968151885738e-01, -9.082157910346329e-01, -8.275397282215858e-01,
    -7.255134414001100e-01, -6.047702996728351e-01, -4.684346162700265e-01,
    -3.200362544506315e-01, -1.634181053418361e-01, -2.636205500547094e-03,
    1.581454482593639e-01, 3.147628043959833e-01, 4.631596344267958e-01,
    5.994926081527394e-01, 7.202308583296615e-01, 8.222474817670050e-01,
    9.029007093915506e-01, 9.601032979053139e-01, 9.923868355049964e-01},
   {-9.494633358614275e-01, -8.830567874178292e-01, -7.952929854218481e-01,
    -6.881537322533672e-01, -5.642361984904343e-01, -4.265776402741575e-01,
    -2.785617030491334e-01, -1.238300984934756e-01, 3.380876425338892e-02,
    1.904742330566806e-01, 3.423092737126247e-01, 4.855755959179479e-01,
    6.167457880276481e-01, 7.325902337993169e-01, 8.302567088965966e-01,
    9.073408014613273e-01, 9.619460504511647e-01, 9.927404163003614e-01},
   {-9.320680711544124e-01, -8.574256011734057e-01, -7.634539032404926e-01,
    -6.519749553303759e-01, -5.255076915542232e-01, -3.869824423142821e-01,
    -2.396310621188066e-01, -8.689970601284235e-02, 6.763599254962109e-02,
    2.203564015650038e-01, 3.676835040083336e-01, 5.061651544605044e-01,
    6.325562096613778e-01, 7.438947259655249e-01, 8.375714999820000e-01,
    9.113914351713388e-01, 9.636259026153904e-01, 9.930626069197461e-01}},
  {// a = 1
   {-9.919970412322650e-01, -9.580727032124667e-01, -8.980119168242189e-01,
    -8.134392081429099e-01, -7.066597926447641e-01, -5.805859208223142e-01,
    -4.386564198796566e-01, -2.847427000467310e-01, -1.230431015517241e-01,
    4.203164174155230e-02, 2.059787211196644e-01, 3.643260782273030e-01,
    5.127543868123012e-01, 6.472148595497391e-01, 7.640396507241585e-01,
    8.600417793993865e-01, 9.326015038912652e-01, 9.797336964051945e-01},
   {-9.807437048939144e-01, -9.359344988126653e-01, -8.668779780899500e-01,
    -7.753682609520556e-01, -6.637764022903112e-01, -5.349928640318862e-01,
    -3.923531837139092e-01, -2.395517059229865e-01, -8.054593723882174e-02,
    8.054593723882221e-02, 2.395517059229864e-01, 3.923531837139091e-01,
    5.349928640318862e-01, 6.637764022903111e-01, 7.753682609520564e-01,
    8.668779780899500e-01, 9.359344988126651e-01, 9.807437048939139e-01},
   {-9.671715346739649e-01, -9.126285555530927e-01, -8.357160065906806e-01,
    -7.382852879071825e-01, -6.227268653309460e-01, -4.918834487495606e-01,
    -3.489757413144571e-01, -1.975220899813244e-01, -4.125151717547191e-02,
    1.159882277809087e-01, 2.703254675735441e-01, 4.179599547137846e-01,
    5.552564548060258e-01, 6.788342531396245e-01, 7.856503691197853e-01,
    8.730743731339660e-01, 9.389526537953393e-01, 9.816577547521641e-01},
   {-9.518538220458710e-01, -8.885268701941211e-01, -8.047210165392289e-01,
    -7.022300516974338e-01, -5.834173407157311e-01, -4.510544517248982e-01,
    -3.082382010388641e-01, -1.583133053787015e-01, -4.792371471985597e-03,
    1.487270800496405e-01, 2.986472259694831e-01, 4.414544106880812e-01,
    5.738015737454587e-01, 6.925867323817538e-01, 7.950256814092369e-01,
    8.787171589479275e-01, 9.416986583232526e-01, 9.824889092920019e-01},
   {-9.352014348342639e-01, -8.639185558803630e-01, -7.740458928102649e-01,
    -6.672284715254208e-01, -5.457629155697068e-01, -4.123302795456282e-01,
    -2.698969250762572e-01, -1.216373353085339e-01, 2.914064845107950e-02,
    1.790713055670388e-01, 3.248069526250779e-01, 4.630930918907747e-01,
    5.908413054531469e-01, 7.051983471363626e-01, 8.036099153174605e-01,
    8.838776492971402e-01, 9.442078032684286e-01, 9.832479622756365e-01}},
  {// a = 2
   {-9.923868355049964e-01, -9.601032979053139e-01, -9.029007093915506e-01,
    -8.222474817670050e-01, -7.202308583296615e-01, -5.994926081527394e-01,
    -4.631596344267958e-01, -3.147628043959833e-01, -1.581454482593639e-01,
    2.636205500547094e-03, 1.634181053418361e-01, 3.200362544506315e-01,
    4.684346162700265e-01, 6.047702996728351e-01, 7.255134414001100e-01,
    8.275397282215858e-01, 9.082157910346329e-01, 9.654968151885738e-01},
   {-9.816577547521641e-01, -9.389526537953393e-01, -8.730743731339660e-01,
    -7.856503691197853e-01, -6.788342531396245e-01, -5.552564548060258e-01,
    -4.179599547137846e-01, -2.703254675735441e-01, -1.159882277809087e-01,
    4.125151717547191e-02, 1.975220899813244e-01, 3.489757413144571e-01,
    4.918834487495606e-01, 6.227268653309460e-01, 7.382852879071825e-01,
    8.357160065906806e-01, 9.126285555530927e-01, 9.671715346739649e-01},
   {-9.686909783865258e-01, -9.166350766447443e-01, -8.431474467170091e-01,
    -7.499101295243042e-01, -6.391003286370385e-01, -5.133127283086356e-01,
    -3.754946217673181e-01, -2.288758312146870e-01, -7.689268019371842e-02,
    7.689268019371846e-02, 2.288758312146867e-01, 3.754946217673183e-01,
    5.133127283086359e-01, 6.391003286370388e-01, 7.499101295243040e-01,
    8.431474467170090e-01, 9.166350766447436e-01, 9.686909783865253e-01},
   {-9.540278442594630e-01, -8.935057475607323e-01, -8.133122649255592e-01,
    -7.150761166059388e-01, -6.009546177650399e-01, -4.734843749889841e-01,
    -3.355074618108145e-01, -1.901033901605648e-01, -4.051877786408334e-02,
    1.099057957723520e-01, 2.578107011395917e-01, 3.998924667022931e-01,
    5.329776953162680e-01, 6.540941092273742e-01, 7.605372739175675e-01,
    8.499319751911004e-01, 9.202891565580816e-01, 9.700758123604537e-01},
   {-9.380574875508457e-01, -8.698423210174842e-01, -7.837211574147637e-01,
    -6.811833582361538e-01, -5.643289492029844e-01, -4.356176947021973e-01,
    -2.977792142157404e-01, -1.537443802667707e-01, -6.579175083963535e-03,
    1.405821755931029e-01, 2.846047134068398e-01, 4.224199379905137e-01,
    5.510914442276028e-01, 6.678777255585759e-01, 7.702909596414218e-01,
    8.561509802194558e-01, 9.236354714303612e-01, 9.713431867658865e-01}},
  {// a = 3
   {-9.927404163003614e-01, -9.619460504511647e-01, -9.073408014613273e-01,
    -8.302567088965966e-01, -7.325902337993169e-01, -6.167457880276481e-01,
    -4.855755959179479e-01, -3.423092737126247e-01, -1.904742330566806e-01,
    -3.380876425338892e-02, 1.238300984934756e-01, 2.785617030491334e-01,
    4.265776402741575e-01, 5.642361984904343e-01, 6.881537322533672e-01,
    7.952929854218481e-01, 8.830567874178292e-01, 9.494633358614275e-01},
   {-9.824889092920019e-01, -9.416986583232526e-01, -8.787171589479275e-01,
    -7.950256814092369e-01, -6.925867323817538e-01, -5.738015737454587e-01,
    -4.414544106880812e-01, -2.986472259694831e-01, -1.487270800496405e-01,
    4.792371471985597e-03, 1.583133053787015e-01, 3.082382010388641e-01,
    4.510544517248982e-01, 5.834173407157311e-01, 7.022300516974338e-01,
    8.047210165392289e-01, 8.885268701941211e-01, 9.518538220458710e-01},
   {-9.700758123604537e-01, -9.202891565580816e-01, -8.499319751911004e-01,
    -7.605372739175675e-01, -6.540941092273742e-01, -5.329776953162680e-01,
    -3.998924667022931e-01, -2.578107011395917e-01, -1.099057957723520e-01,
    4.051877786408334e-02, 1.901033901605648e-01, 3.355074618108145e-01,
    4.734843749889841e-01, 6.009546177650399e-01, 7.150761166059388e-01,
    8.133122649255592e-01, 8.935057475607323e-01, 9.540278442594630e-01},
   {-9.560135943888842e-01, -8.980570243572540e-01, -8.211742079281799e-01,
    -7.268482562554985e-01, -6.170540638861418e-01, -4.941195380654311e-01,
    -3.606595744420355e-01, -2.195159750236575e-01, -7.369538959516307e-02,
    7.369538959516310e-02, 2.195159750236572e-01, 3.606595744420353e-01,
    4.941195380654312e-01, 6.170540638861415e-01, 7.268482562554986e-01,
    8.211742079281799e-01, 8.980570243572534e-01, 9.560135943888849e-01},
   {-9.406716018299898e-01, -8.752690235990669e-01, -7.925948396415901e-01,
    -6.940008697968770e-01, -5.814125292148909e-01, -4.570923251529789e-01,
    -3.235579576772019e-01, -1.835210867072505e-01, -3.982859819235517e-02,
    1.045968327724419e-01, 2.468169713048031e-01, 3.839382955954997e-01,
    5.131713325873237e-01, 6.318881063328614e-01, 7.376771018524569e-01,
    8.283965454283431e-01, 9.022337344110721e-01, 9.578345626901899e-01}},
  {// a = 4
   {-9.930626069197461e-01, -9.636259026153904e-01, -9.113914351713388e-01,
    -8.375714999820000e-01, -7.438947259655249e-01, -6.325562096613778e-01,
    -5.061651544605044e-01, -3.676835040083336e-01, -2.203564015650038e-01,
    -6.763599254962109e-02, 8.689970601284235e-02, 2.396310621188066e-01,
    3.869824423142821e-01, 5.255076915542232e-01, 6.519749553303759e-01,
    7.634539032404926e-01, 8.574256011734057e-01, 9.320680711544124e-01},
   {-9.832479622756365e-01, -9.442078032684286e-01, -8.838776492971402e-01,
    -8.036099153174605e-01, -7.051983471363626e-01, -5.908413054531469e-01,
    -4.630930918907747e-01, -3.248069526250779e-01, -1.790713055670388e-01,
    -2.914064845107950e-02, 1.216373353085339e-01, 2.698969250762572e-01,
    4.123302795456282e-01, 5.457629155697068e-01, 6.672284715254208e-01,
    7.740458928102649e-01, 8.639185558803630e-01, 9.352014348342639e-01},
   {-9.713431867658865e-01, -9.236354714303612e-01, -8.561509802194558e-01,
    -7.702909596414218e-01, -6.678777255585759e-01, -5.510914442276028e-01,
    -4.224199379905137e-01, -2.846047134068398e-01, -1.405821755931029e-01,
    6.579175083963535e-03, 1.537443802667707e-01, 2.977792142157404e-01,
    4.356176947021973e-01, 5.643289492029844e-01, 6.811833582361538e-01,
    7.837211574147637e-01, 8.698423210174842e-01, 9.380574875508457e-01},
   {-9.578345626901899e-01, -9.022337344110721e-01, -8.283965454283431e-01,
    -7.376771018524569e-01, -6.318881063328614e-01, -5.131713325873237e-01,
    -3.839382955954997e-01, -2.468169713048031e-01, -1.045968327724419e-01,
    3.982859819235517e-02, 1.835210867072505e-01, 3.235579576772019e-01,
    4.570923251529789e-01, 5.814125292148909e-01, 6.940008697968770e-01,
    7.925948396415901e-01, 8.752690235990669e-01, 9.406716018299898e-01},
   {-9.430733616755570e-01, -8.802590331203356e-01, -8.007634086732659e-01,
    -7.058162784628557e-01, -5.971873476945267e-01, -4.769626082578843e-01,
    -3.474693703678786e-01, -2.112213791304131e-01, -7.086646675516287e-02,
    7.086646675516269e-02, 2.112213791304132e-01, 3.474693703678784e-01,
    4.769626082578839e-01, 5.971873476945273e-01, 7.058162784628557e-01,
    8.007634086732658e-01, 8.802590331203353e-01, 9.430733616755580e-01}}};
static double _gaussJacobiPt_19[5][5][19] = {
  {// a = 0
   {-9.924068438435840e-01, -9.602081521348295e-01, -9.031559036148181e-01,
    -8.227146565371428e-01, -7.209661773352293e-01, -6.005453046616812e-01,
    -4.645707413759610e-01, -3.165640999636298e-01, -1.603586456402251e-01,
    -4.532915871182588e-17, 1.603586456402255e-01, 3.165640999636301e-01,
    4.645707413759610e-01, 6.005453046616810e-01, 7.209661773352293e-01,
    8.227146565371430e-01, 9.031559036148178e-01, 9.602081521348298e-01,
    9.924068438435842e-01},
   {-9.817036105419110e-01, -9.391052741604416e-01, -8.733916961487305e-01,
    -7.861862699636901e-01, -6.796372314174222e-01, -5.563684459535231e-01,
    -4.194153033078046e-01, -2.721500897585415e-01, -1.181989852980638e-01,
    3.864721284289620e-02, 1.945264276698457e-01, 3.456003984723762e-01,
    4.881491930357941e-01, 6.186628101904733e-01, 7.339276228838024e-01,
    8.311055544315803e-01, 9.078041339031377e-01, 9.621363259368234e-01,
    9.927767143628865e-01},
   {-9.687656131034041e-01, -9.168338048468146e-01, -8.435213634582798e-01,
    -7.505063259676529e-01, -6.399607141264746e-01, -5.144730383465962e-01,
    -3.769835818281900e-01, -2.307144896090938e-01, -7.909392558417634e-02,
    7.432440289595950e-02, 2.259445944613356e-01, 3.722128651635634e-01,
    5.097008618096635e-01, 6.351860326618163e-01, 7.457271802768796e-01,
    8.387334472666771e-01, 9.120252098183146e-01, 9.638860433241988e-01,
    9.931122191922750e-01},
   {-9.541325657289441e-01, -8.937483372930265e-01, -8.137375397998309e-01,
    -7.157251890846623e-01, -6.018636940213240e-01, -4.746838938427767e-01,
    -3.370214029861148e-01, -1.919487394244451e-01, -4.270515565537299e-02,
    1.073763332826841e-01, 2.549436795335277e-01, 3.967008181520774e-01,
    5.294813697335221e-01, 6.503194177091137e-01, 7.565157996610259e-01,
    8.456984585556585e-01, 9.158755965848563e-01, 9.654810111292242e-01,
    9.934179359338322e-01},
   {-9.381925880961598e-01, -8.701262070446421e-01, -7.841928905697005e-01,
    -6.818787573429902e-01, -5.652792604234657e-01, -4.368488096626384e-01,
    -2.993110852898324e-01, -1.555905873293583e-01, -8.746639675228289e-03,
    1.380933246873833e-01, 2.818011169668809e-01, 4.193148161952170e-01,
    5.477042199321511e-01, 6.642334092163530e-01, 7.664191373856486e-01,
    8.520838358367295e-01, 9.194022002927418e-01, 9.669409108013977e-01,
    9.936976636433223e-01}},
  {// a = 1
   {-9.927767143628865e-01, -9.621363259368234e-01, -9.078041339031377e-01,
    -8.311055544315803e-01, -7.339276228838024e-01, -6.186628101904733e-01,
    -4.881491930357941e-01, -3.456003984723762e-01, -1.945264276698457e-01,
    -3.864721284289620e-02, 1.181989852980638e-01, 2.721500897585415e-01,
    4.194153033078046e-01, 5.563684459535231e-01, 6.796372314174222e-01,
    7.861862699636901e-01, 8.733916961487305e-01, 9.391052741604416e-01,
    9.817036105419110e-01},
   {-9.825722966045483e-01, -9.419762969597455e-01, -8.792947553235908e-01,
    -7.960019260777124e-01, -6.940510260622235e-01, -5.758319602618305e-01,
    -4.441157832790019e-01, -3.019898565087649e-01, -1.527855158021848e-01,
    2.289005659682439e-16, 1.527855158021857e-01, 3.019898565087648e-01,
    4.441157832790021e-01, 5.758319602618305e-01, 6.940510260622232e-01,
    7.960019260777121e-01, 8.792947553235905e-01, 9.419762969597457e-01,
    9.825722966045478e-01},
   {-9.702118352226099e-01, -9.206515031851537e-01, -8.506141897553071e-01,
    -7.616259702846082e-01, -6.556669138762707e-01, -5.351015124839219e-01,
    -4.026220096978030e-01, -2.611873147766147e-01, -1.139566025748227e-01,
    3.578137274376932e-02, 1.846817927510595e-01, 3.294185154274714e-01,
    4.667583859081779e-01, 5.936334619153820e-01, 7.072095391454226e-01,
    8.049494340124221e-01, 8.846695584095992e-01, 9.445882416976967e-01,
    9.833621839924535e-01},
   {-9.562048482655054e-01, -8.985002947097739e-01, -8.219518315937427e-01,
    -7.280361591823064e-01, -6.187196373985259e-01, -4.963201229057058e-01,
    -3.634412390034732e-01, -2.229125664979379e-01, -7.772787461820081e-02,
    6.901926865596085e-02, 2.142016919024650e-01, 3.547253981975705e-01,
    4.875955742268418e-01, 6.099804531094561e-01, 7.192716801502376e-01,
    8.131398893527734e-01, 8.895842597576115e-01, 9.469747283673363e-01,
    9.840835352168241e-01},
   {-9.409188193395728e-01, -8.757887952146138e-01, -7.934591851841005e-01,
    -6.952762130983182e-01, -5.831573214072102e-01, -4.593556577126222e-01,
    -3.263785236182557e-01, -1.869264081809693e-01, -4.383451773857224e-02,
    9.998638036435302e-02, 2.416098761657177e-01, 3.781538232699593e-01,
    5.068391888221000e-01, 6.250467245882182e-01, 7.303703378559132e-01,
    8.206660817270313e-01, 8.940957291165776e-01, 9.491637909883229e-01,
    9.847449039448798e-01}},
  {// a = 2
   {-9.931122191922750e-01, -9.638860433241988e-01, -9.120252098183146e-01,
    -8.387334472666771e-01, -7.457271802768796e-01, -6.351860326618163e-01,
    -5.097008618096635e-01, -3.722128651635634e-01, -2.259445944613356e-01,
    -7.432440289595950e-02, 7.909392558417634e-02, 2.307144896090938e-01,
    3.769835818281900e-01, 5.144730383465962e-01, 6.399607141264746e-01,
    7.505063259676529e-01, 8.435213634582798e-01, 9.168338048468146e-01,
    9.687656131034041e-01},
   {-9.833621839924535e-01, -9.445882416976967e-01, -8.846695584095992e-01,
    -8.049494340124221e-01, -7.072095391454226e-01, -5.936334619153820e-01,
    -4.667583859081779e-01, -3.294185154274714e-01, -1.846817927510595e-01,
    -3.578137274376932e-02, 1.139566025748227e-01, 2.611873147766147e-01,
    4.026220096978030e-01, 5.351015124839219e-01, 6.556669138762707e-01,
    7.616259702846082e-01, 8.506141897553071e-01, 9.206515031851537e-01,
    9.702118352226099e-01},
   {-9.715298869015092e-01, -9.241330296344175e-01, -8.570883531701216e-01,
    -7.717880819083639e-01, -6.700428106461579e-01, -5.540187095782213e-01,
    -4.261876765017645e-01, -2.892737483770999e-01, -1.461947517314944e-01,
    6.526506903617471e-17, 1.461947517314943e-01, 2.892737483771002e-01,
    4.261876765017646e-01, 5.540187095782215e-01, 6.700428106461577e-01,
    7.717880819083637e-01, 8.570883531701212e-01, 9.241330296344171e-01,
    9.715298869015094e-01},
   {-9.580975732361291e-01, -9.028436165169708e-01, -8.294671774016156e-01,
    -7.393140219060632e-01, -6.341856925553612e-01, -5.162108026174503e-01,
    -3.877860952555865e-01, -2.515235262396889e-01, -1.101956939692327e-01,
    3.332116272227584e-02, 1.761059725051167e-01, 3.152524302106142e-01,
    4.479282475419564e-01, 5.714328923847800e-01, 6.832526907653459e-01,
    7.811122875376469e-01, 8.630218377970922e-01, 9.273210396417414e-01,
    9.727361037078076e-01},
   {-9.434139449248803e-01, -8.809754982163734e-01, -8.019556994543423e-01,
    -7.075770854962449e-01, -5.995989154410151e-01, -4.800948915950720e-01,
    -3.513786579154723e-01, -2.159492745201093e-01, -7.643923222398297e-02,
    6.443816513809246e-02, 2.039422522098615e-01, 3.393586755707776e-01,
    4.680524180005532e-01, 5.875192275027991e-01, 6.954345189343037e-01,
    7.896989201972935e-01, 8.684799845070860e-01, 9.302512460396403e-01,
    9.738441553234483e-01}},
  {// a = 3
   {-9.934179359338322e-01, -9.654810111292242e-01, -9.158755965848563e-01,
    -8.456984585556585e-01, -7.565157996610259e-01, -6.503194177091137e-01,
    -5.294813697335221e-01, -3.967008181520774e-01, -2.549436795335277e-01,
    -1.073763332826841e-01, 4.270515565537299e-02, 1.919487394244451e-01,
    3.370214029861148e-01, 4.746838938427767e-01, 6.018636940213240e-01,
    7.157251890846623e-01, 8.137375397998309e-01, 8.937483372930265e-01,
    9.541325657289441e-01},
   {-9.840835352168241e-01, -9.469747283673363e-01, -8.895842597576115e-01,
    -8.131398893527734e-01, -7.192716801502376e-01, -6.099804531094561e-01,
    -4.875955742268418e-01, -3.547253981975705e-01, -2.142016919024650e-01,
    -6.901926865596085e-02, 7.772787461820081e-02, 2.229125664979379e-01,
    3.634412390034732e-01, 4.963201229057058e-01, 6.187196373985259e-01,
    7.280361591823064e-01, 8.219518315937427e-01, 8.985002947097739e-01,
    9.562048482655054e-01},
   {-9.727361037078076e-01, -9.273210396417414e-01, -8.630218377970922e-01,
    -7.811122875376469e-01, -6.832526907653459e-01, -5.714328923847800e-01,
    -4.479282475419564e-01, -3.152524302106142e-01, -1.761059725051167e-01,
    -3.332116272227584e-02, 1.101956939692327e-01, 2.515235262396889e-01,
    3.877860952555865e-01, 5.162108026174503e-01, 6.341856925553612e-01,
    7.393140219060632e-01, 8.294671774016156e-01, 9.028436165169708e-01,
    9.580975732361291e-01},
   {-9.598331551372716e-01, -9.068290470846583e-01, -8.363697393818060e-01,
    -7.496849118004351e-01, -6.484294844485208e-01, -5.345632402111724e-01,
    -4.102977278024534e-01, -2.780492595141671e-01, -1.403905321985083e-01,
    1.712118613001251e-16, 1.403905321985082e-01, 2.780492595141668e-01,
    4.102977278024532e-01, 5.345632402111721e-01, 6.484294844485208e-01,
    7.496849118004354e-01, 8.363697393818065e-01, 9.068290470846581e-01,
    9.598331551372720e-01},
   {-9.457062435701694e-01, -8.857442001833971e-01, -8.097753194824441e-01,
    -7.189123398745034e-01, -6.147733966267394e-01, -4.992715873240594e-01,
    -3.745466083255027e-01, -2.429157943553277e-01, -1.068277382208775e-01,
    3.118465840212984e-02, 1.685520081441182e-01, 3.027166648820372e-01,
    4.311806441713941e-01, 5.515524780026212e-01, 6.615923289492358e-01,
    7.592550290653267e-01, 8.427319868191872e-01, 9.104992318340046e-01,
    9.614304199151867e-01}},
  {// a = 4
   {-9.936976636433223e-01, -9.669409108013977e-01, -9.194022002927418e-01,
    -8.520838358367295e-01, -7.664191373856486e-01, -6.642334092163530e-01,
    -5.477042199321511e-01, -4.193148161952170e-01, -2.818011169668809e-01,
    -1.380933246873833e-01, 8.746639675228289e-03, 1.555905873293583e-01,
    2.993110852898324e-01, 4.368488096626384e-01, 5.652792604234657e-01,
    6.818787573429902e-01, 7.841928905697005e-01, 8.701262070446421e-01,
    9.381925880961598e-01},
   {-9.847449039448798e-01, -9.491637909883229e-01, -8.940957291165776e-01,
    -8.206660817270313e-01, -7.303703378559132e-01, -6.250467245882182e-01,
    -5.068391888221000e-01, -3.781538232699593e-01, -2.416098761657177e-01,
    -9.998638036435302e-02, 4.383451773857224e-02, 1.869264081809693e-01,
    3.263785236182557e-01, 4.593556577126222e-01, 5.831573214072102e-01,
    6.952762130983182e-01, 7.934591851841005e-01, 8.757887952146138e-01,
    9.409188193395728e-01},
   {-9.738441553234483e-01, -9.302512460396403e-01, -8.684799845070860e-01,
    -7.896989201972935e-01, -6.954345189343037e-01, -5.875192275027991e-01,
    -4.680524180005532e-01, -3.393586755707776e-01, -2.039422522098615e-01,
    -6.443816513809246e-02, 7.643923222398297e-02, 2.159492745201093e-01,
    3.513786579154723e-01, 4.800948915950720e-01, 5.995989154410151e-01,
    7.075770854962449e-01, 8.019556994543423e-01, 8.809754982163734e-01,
    9.434139449248803e-01},
   {-9.614304199151867e-01, -9.104992318340046e-01, -8.427319868191872e-01,
    -7.592550290653267e-01, -6.615923289492358e-01, -5.515524780026212e-01,
    -4.311806441713941e-01, -3.027166648820372e-01, -1.685520081441182e-01,
    -3.118465840212984e-02, 1.068277382208775e-01, 2.429157943553277e-01,
    3.745466083255027e-01, 4.992715873240594e-01, 6.147733966267394e-01,
    7.189123398745034e-01, 8.097753194824441e-01, 8.857442001833971e-01,
    9.457062435701694e-01},
   {-9.478195484252341e-01, -8.901437173510250e-01, -8.169964473303695e-01,
    -7.293926385108993e-01, -6.288240517036139e-01, -5.170595252735890e-01,
    -3.960819796175919e-01, -2.680442820640357e-01, -1.352277250309032e-01,
    6.200982416265827e-17, 1.352277250309034e-01, 2.680442820640360e-01,
    3.960819796175923e-01, 5.170595252735887e-01, 6.288240517036128e-01,
    7.293926385108987e-01, 8.169964473303695e-01, 8.901437173510254e-01,
    9.478195484252345e-01}}};
static double _gaussJacobiPt_20[5][5][20] = {
  {// a = 0
   {-9.931285991850952e-01, -9.639719272779143e-01, -9.122344282513257e-01,
    -8.391169718222189e-01, -7.463319064601509e-01, -6.360536807265149e-01,
    -5.108670019508269e-01, -3.737060887154198e-01, -2.277858511416452e-01,
    -7.652652113349705e-02, 7.652652113349773e-02,  2.277858511416454e-01,
    3.737060887154196e-01,  5.108670019508272e-01,  6.360536807265154e-01,
    7.463319064601509e-01,  8.391169718222189e-01,  9.122344282513255e-01,
    9.639719272779136e-01,  9.931285991850951e-01},
   {-9.833999115858654e-01, -9.447138932948739e-01, -8.849310847263726e-01,
    -8.053917435869075e-01, -7.078735060717811e-01, -5.945550166731893e-01,
    -4.679677164713189e-01, -3.309393978110274e-01, -1.865310669670130e-01,
    -3.796857740714772e-02, 1.114294260739779e-01,  2.583256388312061e-01,
    3.994386463281002e-01,  5.316162273728158e-01,  6.519057747289156e-01,
    7.576202653526481e-01,  8.463983258207562e-01,  9.162571377644696e-01,
    9.656375637094887e-01,  9.934477866618997e-01},
   {-9.715915776812837e-01, -9.242974243009963e-01, -8.573980298375014e-01,
    -7.722826058290941e-01, -6.707578292631232e-01, -5.549851840709735e-01,
    -4.274312220305754e-01, -2.908140915547353e-01, -1.480453163656539e-01,
    -2.167630965696736e-03, 1.437099181334871e-01,  2.864782597950937e-01,
    4.230945756374549e-01,  5.506471612313897e-01,  6.664174930379810e-01,
    7.679381846890263e-01,  8.530456164294296e-01,  9.199261990761861e-01,
    9.671558237320242e-01,  9.937386325185127e-01},
   {-9.581845086238181e-01, -9.030451899112609e-01, -8.298209923457061e-01,
    -7.398548937355769e-01, -6.349447042574379e-01, -5.172146281327684e-01,
    -3.890564457287243e-01, -2.530767071271488e-01, -1.120422771293650e-01,
    3.117654567263744e-02,  1.736647095100555e-01,  3.125218745772579e-01,
    4.449215213686147e-01,  5.681685289058432e-01,  6.797540659287594e-01,
    7.774066892722269e-01,  8.591386303112140e-01,  9.232864082692881e-01,
    9.685454587723635e-01,  9.940047516128481e-01},
   {-9.435265556341332e-01, -8.812123690364497e-01, -8.023498337699549e-01,
    -7.081590575458313e-01, -6.003958035470570e-01, -4.811296541505814e-01,
    -3.526696582764543e-01, -2.175099154401632e-01, -7.827769544334341e-02,
    6.231907170262852e-02,  2.015451357980186e-01,  3.366914836259650e-01,
    4.651282390350354e-01,  5.843559500013151e-01,  6.920543004188958e-01,
    7.861273205203085e-01,  8.647442419716747e-01,  9.263752833783981e-01,
    9.698221655249791e-01,  9.942491690485675e-01}},
  {// a = 1
   {-9.934477866618997e-01, -9.656375637094887e-01, -9.162571377644696e-01,
    -8.463983258207562e-01, -7.576202653526481e-01, -6.519057747289156e-01,
    -5.316162273728158e-01, -3.994386463281002e-01, -2.583256388312061e-01,
    -1.114294260739779e-01, 3.796857740714772e-02,  1.865310669670130e-01,
    3.309393978110274e-01,  4.679677164713189e-01,  5.945550166731893e-01,
    7.078735060717811e-01,  8.053917435869075e-01,  8.849310847263726e-01,
    9.447138932948739e-01,  9.833999115858654e-01},
   {-9.841524384576462e-01, -9.472042839992285e-01, -8.900622901909047e-01,
    -8.139489276119214e-01, -7.204872399612022e-01, -6.116694382842588e-01,
    -4.898148751899025e-01, -3.575207101389196e-01, -2.176065851592846e-01,
    -7.305454001089838e-02, 7.305454001089846e-02,  2.176065851592850e-01,
    3.575207101389195e-01,  4.898148751899022e-01,  6.116694382842589e-01,
    7.204872399612018e-01,  8.139489276119213e-01,  8.900622901909043e-01,
    9.472042839992284e-01,  9.841524384576464e-01},
   {-9.728490003223152e-01, -9.276220046420424e-01, -8.635890950328927e-01,
    -7.820188121879189e-01, -6.845646193893430e-01, -5.732081715663796e-01,
    -4.502154691435611e-01, -3.180898688918408e-01, -1.795208475273123e-01,
    -3.732914672814721e-02, 1.055906943388334e-01,  2.463292847437273e-01,
    3.820216188437758e-01,  5.099054037185025e-01,  6.273772907633637e-01,
    7.320458642347447e-01,  8.217802966869686e-01,  8.947536334874647e-01,
    9.494795693351372e-01,  9.848396583490030e-01},
   {-9.599925533680100e-01, -9.071988008260675e-01, -8.370191490220766e-01,
    -7.506784236818881e-01, -6.498250129881387e-01, -5.364109703528316e-01,
    -4.126391323267534e-01, -2.809163094878119e-01, -1.438051101890145e-01,
    -3.973532273301354e-03, 1.358572040742253e-01,  2.729657381390465e-01,
    4.046835976024960e-01,  5.284471699380933e-01,  6.418476163755474e-01,
    7.426777597540268e-01,  8.289750254961494e-01,  8.990595560693609e-01,
    9.515665127550957e-01,  9.854697234027601e-01},
   {-9.459130880025061e-01, -8.861795017091665e-01, -8.105000946410110e-01,
    -7.199833913967633e-01, -6.162413969143141e-01, -5.011799661761364e-01,
    -3.769307051321039e-01, -2.458022032072700e-01, -1.102338401037254e-01,
    2.725096715742614e-02,  1.640923749944930e-01,  2.977421015068777e-01,
    4.257110585991223e-01,  5.456158100705951e-01,  6.552230219023855e-01,
    7.524910898128965e-01,  8.356081663539943e-01,  9.030258401954091e-01,
    9.534876075209534e-01,  9.860494825021773e-01}},
  {// a = 2
   {-9.937386325185127e-01, -9.671558237320242e-01, -9.199261990761861e-01,
    -8.530456164294296e-01, -7.679381846890263e-01, -6.664174930379810e-01,
    -5.506471612313897e-01, -4.230945756374549e-01, -2.864782597950937e-01,
    -1.437099181334871e-01, 2.167630965696736e-03,  1.480453163656539e-01,
    2.908140915547353e-01,  4.274312220305754e-01,  5.549851840709735e-01,
    6.707578292631232e-01,  7.722826058290941e-01,  8.573980298375014e-01,
    9.242974243009963e-01,  9.715915776812837e-01},
   {-9.848396583490030e-01, -9.494795693351372e-01, -8.947536334874647e-01,
    -8.217802966869686e-01, -7.320458642347447e-01, -6.273772907633637e-01,
    -5.099054037185025e-01, -3.820216188437758e-01, -2.463292847437273e-01,
    -1.055906943388334e-01, 3.732914672814721e-02,  1.795208475273123e-01,
    3.180898688918408e-01,  4.502154691435611e-01,  5.732081715663796e-01,
    6.845646193893430e-01,  7.820188121879189e-01,  8.635890950328927e-01,
    9.276220046420424e-01,  9.728490003223152e-01},
   {-9.739996980631568e-01, -9.306660538330068e-01, -8.692622359998137e-01,
    -7.909499184461404e-01, -6.972465925942919e-01, -5.899739481326430e-01,
    -4.712190610894856e-01, -3.432929478249571e-01, -2.086853191283322e-01,
    -7.001601826403463e-02, 7.001601826403488e-02,  2.086853191283322e-01,
    3.432929478249571e-01,  4.712190610894858e-01,  5.899739481326426e-01,
    6.972465925942918e-01,  7.909499184461403e-01,  8.692622359998134e-01,
    9.306660538330068e-01,  9.739996980631566e-01},
   {-9.616504155940135e-01, -9.110097715946518e-01, -8.436291898796430e-01,
    -7.606286634638074e-01, -6.635235706432816e-01, -5.541123216395500e-01,
    -4.344285990374992e-01, -3.066997074854389e-01, -1.733038086619201e-01,
    -3.672511147229498e-02, 1.004926347760595e-01,  2.357936429264362e-01,
    3.666577666363077e-01,  4.906474988000649e-01,  6.054534387450493e-01,
    7.089374200734915e-01,  7.991726003810313e-01,  8.744801478869817e-01,
    9.334637336715732e-01,  9.750567200195495e-01},
   {-9.481055003979928e-01, -8.907457878377200e-01, -8.179995202368456e-01,
    -7.308761083974978e-01, -6.308592355980930e-01, -5.197081762147855e-01,
    -3.993951562253618e-01, -2.720614769940173e-01, -1.399762483482133e-01,
    -5.494638151929874e-03, 1.289847373845600e-01,  2.610629129517353e-01,
    3.883835497638911e-01,  5.086750923626424e-01,  6.197913974299832e-01,
    7.197501567964062e-01,  8.067685347217822e-01,  8.792957531093589e-01,
    9.360438621263841e-01,  9.760310691470183e-01}},
  {// a = 3
   {-9.940047516128481e-01, -9.685454587723635e-01, -9.232864082692881e-01,
    -8.591386303112140e-01, -7.774066892722269e-01, -6.797540659287594e-01,
    -5.681685289058432e-01, -4.449215213686147e-01, -3.125218745772579e-01,
    -1.736647095100555e-01, -3.117654567263744e-02, 1.120422771293650e-01,
    2.530767071271488e-01,  3.890564457287243e-01,  5.172146281327684e-01,
    6.349447042574379e-01,  7.398548937355769e-01,  8.298209923457061e-01,
    9.030451899112609e-01,  9.581845086238181e-01},
   {-9.854697234027601e-01, -9.515665127550957e-01, -8.990595560693609e-01,
    -8.289750254961494e-01, -7.426777597540268e-01, -6.418476163755474e-01,
    -5.284471699380933e-01, -4.046835976024960e-01, -2.729657381390465e-01,
    -1.358572040742253e-01, 3.973532273301354e-03,  1.438051101890145e-01,
    2.809163094878119e-01,  4.126391323267534e-01,  5.364109703528316e-01,
    6.498250129881387e-01,  7.506784236818881e-01,  8.370191490220766e-01,
    9.071988008260675e-01,  9.599925533680100e-01},
   {-9.750567200195495e-01, -9.334637336715732e-01, -8.744801478869817e-01,
    -7.991726003810313e-01, -7.089374200734915e-01, -6.054534387450493e-01,
    -4.906474988000649e-01, -3.666577666363077e-01, -2.357936429264362e-01,
    -1.004926347760595e-01, 3.672511147229498e-02,  1.733038086619201e-01,
    3.066997074854389e-01,  4.344285990374992e-01,  5.541123216395500e-01,
    6.635235706432816e-01,  7.606286634638074e-01,  8.436291898796430e-01,
    9.110097715946518e-01,  9.616504155940135e-01},
   {-9.631760954318513e-01, -9.145189742513045e-01, -8.497208044210458e-01,
    -7.698081976860754e-01, -6.761776737233162e-01, -5.704900044992628e-01,
    -4.546268952239742e-01, -3.306537887548358e-01, -2.007817797384749e-01,
    -6.732766017970912e-02, 6.732766017970879e-02,  2.007817797384753e-01,
    3.306537887548358e-01,  4.546268952239739e-01,  5.704900044992632e-01,
    6.761776737233161e-01,  7.698081976860757e-01,  8.497208044210460e-01,
    9.145189742513045e-01,  9.631760954318507e-01},
   {-9.501266164899248e-01, -8.949581014155217e-01, -8.249236667203856e-01,
    -7.409443589443760e-01, -6.443888980269158e-01, -5.368848635844138e-01,
    -4.202608433938532e-01, -2.965068087081985e-01, -1.677371279190688e-01,
    -3.615317339296357e-02, 9.599491703313548e-02,  2.264470491500666e-01,
    3.529720469273613e-01,  4.734060161816378e-01,  5.856896291267025e-01,
    6.879038579984679e-01,  7.783040026070599e-01,  8.553530256947313e-01,
    9.177610066872539e-01,  9.645848220828218e-01}},
  {// a = 4
   {-9.942491690485675e-01, -9.698221655249791e-01, -9.263752833783981e-01,
    -8.647442419716747e-01, -7.861273205203085e-01, -6.920543004188958e-01,
    -5.843559500013151e-01, -4.651282390350354e-01, -3.366914836259650e-01,
    -2.015451357980186e-01, -6.231907170262852e-02, 7.827769544334341e-02,
    2.175099154401632e-01,  3.526696582764543e-01,  4.811296541505814e-01,
    6.003958035470570e-01,  7.081590575458313e-01,  8.023498337699549e-01,
    8.812123690364497e-01,  9.435265556341332e-01},
   {-9.860494825021773e-01, -9.534876075209534e-01, -9.030258401954091e-01,
    -8.356081663539943e-01, -7.524910898128965e-01, -6.552230219023855e-01,
    -5.456158100705951e-01, -4.257110585991223e-01, -2.977421015068777e-01,
    -1.640923749944930e-01, -2.725096715742614e-02, 1.102338401037254e-01,
    2.458022032072700e-01,  3.769307051321039e-01,  5.011799661761364e-01,
    6.162413969143141e-01,  7.199833913967633e-01,  8.105000946410110e-01,
    8.861795017091665e-01,  9.459130880025061e-01},
   {-9.760310691470183e-01, -9.360438621263841e-01, -8.792957531093589e-01,
    -8.067685347217822e-01, -7.197501567964062e-01, -6.197913974299832e-01,
    -5.086750923626424e-01, -3.883835497638911e-01, -2.610629129517353e-01,
    -1.289847373845600e-01, 5.494638151929874e-03,  1.399762483482133e-01,
    2.720614769940173e-01,  3.993951562253618e-01,  5.197081762147855e-01,
    6.308592355980930e-01,  7.308761083974978e-01,  8.179995202368456e-01,
    8.907457878377200e-01,  9.481055003979928e-01},
   {-9.645848220828218e-01, -9.177610066872539e-01, -8.553530256947313e-01,
    -7.783040026070599e-01, -6.879038579984679e-01, -5.856896291267025e-01,
    -4.734060161816378e-01, -3.529720469273613e-01, -2.264470491500666e-01,
    -9.599491703313548e-02, 3.615317339296357e-02,  1.677371279190688e-01,
    2.965068087081985e-01,  4.202608433938532e-01,  5.368848635844138e-01,
    6.443888980269158e-01,  7.409443589443760e-01,  8.249236667203856e-01,
    8.949581014155217e-01,  9.501266164899248e-01},
   {-9.519958077802642e-01, -8.988562490531128e-01, -8.313367459311208e-01,
    -7.502792899007257e-01, -6.569492492298097e-01, -5.528554873154808e-01,
    -4.396967278749787e-01, -3.193256384373270e-01, -1.937155739696671e-01,
    -6.492698686090238e-02, 6.492698686090227e-02,  1.937155739696671e-01,
    3.193256384373275e-01,  4.396967278749784e-01,  5.528554873154808e-01,
    6.569492492298099e-01,  7.502792899007257e-01,  8.313367459311209e-01,
    8.988562490531121e-01,  9.519958077802642e-01}}};

static double _gaussJacobiWt_1[5][5][1] = {{// a = 0
                                            {2.000000000000000e+00},
                                            {2.000000000000000e+00},
                                            {2.666666666666667e+00},
                                            {3.999999999999999e+00},
                                            {6.400000000000002e+00}},
                                           {// a = 1
                                            {2.000000000000000e+00},
                                            {1.333333333333333e+00},
                                            {1.333333333333333e+00},
                                            {1.600000000000000e+00},
                                            {2.133333333333333e+00}},
                                           {// a = 2
                                            {2.666666666666667e+00},
                                            {1.333333333333333e+00},
                                            {1.066666666666667e+00},
                                            {1.066666666666667e+00},
                                            {1.219047619047619e+00}},
                                           {// a = 3
                                            {3.999999999999999e+00},
                                            {1.600000000000000e+00},
                                            {1.066666666666667e+00},
                                            {9.142857142857136e-01},
                                            {9.142857142857136e-01}},
                                           {// a = 4
                                            {6.400000000000002e+00},
                                            {2.133333333333333e+00},
                                            {1.219047619047619e+00},
                                            {9.142857142857136e-01},
                                            {8.126984126984133e-01}}};
static double _gaussJacobiWt_2[5][5][2] = {
  {// a = 0
   {9.999999999999998e-01, 9.999999999999998e-01},
   {7.278344730240912e-01, 1.272165526975909e+00},
   {8.062870566386036e-01, 1.860379610028064e+00},
   {1.070483996910220e+00, 2.929516003089780e+00},
   {1.570639752904591e+00, 4.829360247095410e+00}},
  {// a = 1
   {1.272165526975909e+00, 7.278344730240912e-01},
   {6.666666666666665e-01, 6.666666666666665e-01},
   {5.723857625084603e-01, 7.609475708248731e-01},
   {6.178319863829406e-01, 9.821680136170595e-01},
   {7.619047619047621e-01, 1.371428571428571e+00}},
  {// a = 2
   {1.860379610028064e+00, 8.062870566386036e-01},
   {7.609475708248731e-01, 5.723857625084603e-01},
   {5.333333333333332e-01, 5.333333333333332e-01},
   {4.851462451783867e-01, 5.815204214882800e-01},
   {5.162099145606410e-01, 7.028377044869784e-01}},
  {// a = 3
   {2.929516003089780e+00, 1.070483996910220e+00},
   {9.821680136170595e-01, 6.178319863829406e-01},
   {5.815204214882800e-01, 4.851462451783867e-01},
   {4.571428571428567e-01, 4.571428571428567e-01},
   {4.278171291840188e-01, 4.864685851016950e-01}},
  {// a = 4
   {4.829360247095410e+00, 1.570639752904591e+00},
   {1.371428571428571e+00, 7.619047619047621e-01},
   {7.028377044869784e-01, 5.162099145606410e-01},
   {4.864685851016950e-01, 4.278171291840188e-01},
   {4.063492063492065e-01, 4.063492063492065e-01}}};
static double _gaussJacobiWt_3[5][5][3] = {
  {// a = 0
   {5.555555555555554e-01, 8.888888888888888e-01, 5.555555555555551e-01},
   {2.793079196058165e-01, 9.169644254383441e-01, 8.037276549558382e-01},
   {2.396056240686457e-01, 1.169970154078928e+00, 1.257090888519093e+00},
   {2.636649485227477e-01, 1.673598360908908e+00, 2.062736690568345e+00},
   {3.350093498638904e-01, 2.568853550597510e+00, 3.496137099538602e+00}},
  {// a = 1
   {8.037276549558382e-01, 9.169644254383441e-01, 2.793079196058165e-01},
   {3.111111111111109e-01, 7.111111111111114e-01, 3.111111111111109e-01},
   {2.149692150245489e-01, 7.231217117171123e-01, 3.952424065916725e-01},
   {1.969322326330964e-01, 8.572885350869465e-01, 5.457792322799566e-01},
   {2.135584815618425e-01, 1.121471649365120e+00, 7.983032024063695e-01}},
  {// a = 2
   {1.257090888519093e+00, 1.169970154078928e+00, 2.396056240686457e-01},
   {3.952424065916725e-01, 7.231217117171123e-01, 2.149692150245489e-01},
   {2.285714285714288e-01, 6.095238095238090e-01, 2.285714285714287e-01},
   {1.793761350221325e-01, 6.159564099114720e-01, 2.713341217330624e-01},
   {1.697182757645627e-01, 7.013330305371294e-01, 3.479963127459271e-01}},
  {// a = 3
   {2.062736690568345e+00, 1.673598360908908e+00, 2.636649485227477e-01},
   {5.457792322799566e-01, 8.572885350869465e-01, 1.969322326330964e-01},
   {2.713341217330624e-01, 6.159564099114720e-01, 1.793761350221325e-01},
   {1.862433862433863e-01, 5.417989417989422e-01, 1.862433862433863e-01},
   {1.563116811307890e-01, 5.457163448164892e-01, 2.122576883384357e-01}},
  {// a = 4
   {3.496137099538602e+00, 2.568853550597510e+00, 3.350093498638904e-01},
   {7.983032024063695e-01, 1.121471649365120e+00, 2.135584815618425e-01},
   {3.479963127459271e-01, 7.013330305371294e-01, 1.697182757645627e-01},
   {2.122576883384357e-01, 5.457163448164892e-01, 1.563116811307890e-01},
   {1.600769600769601e-01, 4.925444925444932e-01, 1.600769600769602e-01}}};
static double _gaussJacobiWt_4[5][5][4] = {
  {// a = 0
   {3.478548451374539e-01, 6.521451548625463e-01, 6.521451548625460e-01,
    3.478548451374541e-01},
   {1.247238838000323e-01, 5.193901904329290e-01, 8.138582720410841e-01,
    5.420276537259530e-01},
   {8.281792599934459e-02, 5.490710973833848e-01, 1.147670318393714e+00,
    8.871073248902248e-01},
   {7.453387296111182e-02, 6.806675862842664e-01, 1.744069903018255e+00,
    1.500728637736366e+00},
   {8.052325269261341e-02, 9.334202291982018e-01, 2.786166786040798e+00,
    2.599889732068390e+00}},
  {// a = 1
   {5.420276537259530e-01, 8.138582720410841e-01, 5.193901904329290e-01,
    1.247238838000323e-01},
   {1.569499125956940e-01, 5.097167540709726e-01, 5.097167540709733e-01,
    1.569499125956941e-01},
   {8.666291257402473e-02, 4.412333545929730e-01, 5.901533609926285e-01,
    2.152837051737071e-01},
   {6.638113568870473e-02, 4.612300776638222e-01, 7.590529887421843e-01,
    3.133357979052909e-01},
   {6.218189651967275e-02, 5.452982185335850e-01, 1.049649305865381e+00,
    4.762039124146956e-01}},
  {// a = 2
   {8.871073248902248e-01, 1.147670318393714e+00, 5.490710973833848e-01,
    8.281792599934459e-02},
   {2.152837051737071e-01, 5.901533609926285e-01, 4.412333545929730e-01,
    8.666291257402473e-02},
   {1.017094468982020e-01, 4.316238864351311e-01, 4.316238864351309e-01,
    1.017094468982023e-01},
   {6.780964183677224e-02, 3.895640495203256e-01, 4.799597086802413e-01,
    1.293332666293279e-01},
   {5.607674171114099e-02, 4.044763521362413e-01, 5.840016959463765e-01,
    1.744928292538610e-01}},
  {// a = 3
   {1.500728637736366e+00, 1.744069903018255e+00, 6.806675862842664e-01,
    7.453387296111182e-02},
   {3.133357979052909e-01, 7.590529887421843e-01, 4.612300776638222e-01,
    6.638113568870473e-02},
   {1.293332666293279e-01, 4.799597086802413e-01, 3.895640495203256e-01,
    6.780964183677224e-02},
   {7.633163504650844e-02, 3.808112220963483e-01, 3.808112220963482e-01,
    7.633163504650840e-02},
   {5.650779719733934e-02, 3.522705749121590e-01, 4.131267636004213e-01,
    9.238057857579422e-02}},
  {// a = 4
   {2.599889732068390e+00, 2.786166786040798e+00, 9.334202291982018e-01,
    8.052325269261341e-02},
   {4.762039124146956e-01, 1.049649305865381e+00, 5.452982185335850e-01,
    6.218189651967275e-02},
   {1.744928292538610e-01, 5.840016959463765e-01, 4.044763521362413e-01,
    5.607674171114099e-02},
   {9.238057857579422e-02, 4.131267636004213e-01, 3.522705749121590e-01,
    5.650779719733934e-02},
   {6.190306686727069e-02, 3.444461394819360e-01, 3.444461394819356e-01,
    6.190306686727064e-02}}};
static double _gaussJacobiWt_5[5][5][5] = {
  {// a = 0
   {2.369268850561887e-01, 4.786286704993663e-01, 5.688888888888893e-01,
    4.786286704993676e-01, 2.369268850561885e-01},
   {6.299165808676893e-02, 2.956354802904664e-01, 5.855479483386790e-01,
    6.686985523774791e-01, 3.871263609066063e-01},
   {3.291060162479219e-02, 2.564448057836955e-01, 7.136012897727206e-01,
    1.009591695199294e+00, 6.541182742861671e-01},
   {2.433102994064120e-02, 2.713171978123492e-01, 9.671192512595976e-01,
    1.605064071439325e+00, 1.132168449548085e+00},
   {2.230326649360302e-02, 3.267373352151112e-01, 1.408783024172256e+00,
    2.646806819262076e+00, 1.995369554856960e+00}},
  {// a = 1
   {3.871263609066063e-01, 6.686985523774791e-01, 5.855479483386790e-01,
    2.956354802904664e-01, 6.299165808676893e-02},
   {8.601768212280758e-02, 3.368394607343355e-01, 4.876190476190479e-01,
    3.368394607343353e-01, 8.601768212280750e-02},
   {3.831930848119028e-02, 2.452059739900081e-01, 4.967399704812981e-01,
    4.282880432585657e-01, 1.247800371222710e-01},
   {2.456646444319764e-02, 2.225592686751806e-01, 5.765700495773455e-01,
    5.871497496181131e-01, 1.891544676861635e-01},
   {1.980513588884996e-02, 2.339699037681826e-01, 7.329078641092172e-01,
    8.501544609361894e-01, 2.964959686308937e-01}},
  {// a = 2
   {6.541182742861671e-01, 1.009591695199294e+00, 7.136012897727206e-01,
    2.564448057836955e-01, 3.291060162479219e-02},
   {1.247800371222710e-01, 4.282880432585657e-01, 4.967399704812981e-01,
    2.452059739900081e-01, 3.831930848119028e-02},
   {4.843727109064629e-02, 2.681764855231103e-01, 4.334391534391542e-01,
    2.681764855231104e-01, 4.843727109064622e-02},
   {2.741017806633719e-02, 2.129178606036481e-01, 4.390843794439510e-01,
    3.222065654722181e-01, 6.504768308051222e-02},
   {1.972253761462016e-02, 1.984881119078501e-01, 4.944191223907425e-01,
    4.149098629289183e-01, 9.150798420548717e-02}},
  {// a = 3
   {1.132168449548085e+00, 1.605064071439325e+00, 9.671192512595976e-01,
    2.713171978123492e-01, 2.433102994064120e-02},
   {1.891544676861635e-01, 5.871497496181131e-01, 5.765700495773455e-01,
    2.225592686751806e-01, 2.456646444319764e-02},
   {6.504768308051222e-02, 3.222065654722181e-01, 4.390843794439510e-01,
    2.129178606036481e-01, 2.741017806633719e-02},
   {3.294330378740572e-02, 2.271817563376542e-01, 3.940355940355940e-01,
    2.271817563376544e-01, 3.294330378740577e-02},
   {2.140403046183203e-02, 1.901585833153595e-01, 3.978207020574319e-01,
    2.629653755603543e-01, 4.193702289073592e-02}},
  {// a = 4
   {1.995369554856960e+00, 2.646806819262076e+00, 1.408783024172256e+00,
    3.267373352151112e-01, 2.230326649360302e-02},
   {2.964959686308937e-01, 8.501544609361894e-01, 7.329078641092172e-01,
    2.339699037681826e-01, 1.980513588884996e-02},
   {9.150798420548717e-02, 4.149098629289183e-01, 4.944191223907425e-01,
    1.984881119078501e-01, 1.972253761462016e-02},
   {4.193702289073592e-02, 2.629653755603543e-01, 3.978207020574319e-01,
    1.901585833153595e-01, 2.140403046183203e-02},
   {2.483803845828180e-02, 1.996485860283427e-01, 3.637251637251640e-01,
    1.996485860283425e-01, 2.483803845828179e-02}}};
static double _gaussJacobiWt_6[5][5][6] = {
  {// a = 0
   {1.713244923791702e-01, 3.607615730481386e-01, 4.679139345726911e-01,
    4.679139345726911e-01, 3.607615730481376e-01, 1.713244923791706e-01},
   {3.495320725443805e-02, 1.758206622020359e-01, 3.946446035626222e-01,
    5.631702151527973e-01, 5.421699889260740e-01, 2.892413229020351e-01},
   {1.464860645495436e-02, 1.257623774795602e-01, 4.103165690369300e-01,
    7.566174939883293e-01, 8.590119978942456e-01, 5.003096218126468e-01},
   {8.987373976578002e-03, 1.133650549076629e-01, 4.884190756130669e-01,
    1.095092508282256e+00, 1.412815859853395e+00, 8.813201273670372e-01},
   {7.021247827874482e-03, 1.192571020536328e-01, 6.386004701784105e-01,
    1.671678537383974e+00, 2.388772810023287e+00, 1.574669832532825e+00}},
  {// a = 1
   {2.892413229020351e-01, 5.421699889260740e-01, 5.631702151527973e-01,
    3.946446035626222e-01, 1.758206622020359e-01, 3.495320725443805e-02},
   {5.058357701608170e-02, 2.216925320225180e-01, 3.943905576280664e-01,
    3.943905576280665e-01, 2.216925320225174e-01, 5.058357701608157e-02},
   {1.843529878587512e-02, 1.358529778168891e-01, 3.489876099449661e-01,
    4.515030795218800e-01, 3.020152876737603e-01, 7.653907958996159e-02},
   {9.961013589566662e-03, 1.066909507493963e-01, 3.604023838564919e-01,
    5.679937419135328e-01, 4.351533970782932e-01, 1.197985128127204e-01},
   {6.928693007278721e-03, 9.913784846400839e-02, 4.151288701788876e-01,
    7.654986227904429e-01, 6.540853399480817e-01, 1.925539589446358e-01}},
  {// a = 2
   {5.003096218126468e-01, 8.590119978942456e-01, 7.566174939883293e-01,
    4.103165690369300e-01, 1.257623774795602e-01, 1.464860645495436e-02},
   {7.653907958996159e-02, 3.020152876737603e-01, 4.515030795218800e-01,
    3.489876099449661e-01, 1.358529778168891e-01, 1.843529878587512e-02},
   {2.467268662655667e-02, 1.616918610467478e-01, 3.469687856600291e-01,
    3.469687856600285e-01, 1.616918610467480e-01, 2.467268662655670e-02},
   {1.190918435049791e-02, 1.124106922355262e-01, 3.159318481963147e-01,
    3.851301217260023e-01, 2.066707140383849e-01, 3.461410611994043e-02},
   {7.465506062062473e-03, 9.349129673941403e-02, 3.248487564768479e-01,
    4.638613909718463e-01, 2.789755555810522e-01, 5.040511321639656e-02}},
  {// a = 3
   {8.813201273670372e-01, 1.412815859853395e+00, 1.095092508282256e+00,
    4.884190756130669e-01, 1.133650549076629e-01, 8.987373976578002e-03},
   {1.197985128127204e-01, 4.351533970782932e-01, 5.679937419135328e-01,
    3.604023838564919e-01, 1.066909507493963e-01, 9.961013589566662e-03},
   {3.461410611994043e-02, 2.066707140383849e-01, 3.851301217260023e-01,
    3.159318481963147e-01, 1.124106922355262e-01, 1.190918435049791e-02},
   {1.509646565423384e-02, 1.288175931617939e-01, 3.132287983268299e-01,
    3.132287983268291e-01, 1.288175931617941e-01, 1.509646565423381e-02},
   {8.612784576503985e-03, 9.692537560473276e-02, 2.906135774136844e-01,
    3.405664410139636e-01, 1.575185821600764e-01, 2.004895351675277e-02}},
  {// a = 4
   {1.574669832532825e+00, 2.388772810023287e+00, 1.671678537383974e+00,
    6.386004701784105e-01, 1.192571020536328e-01, 7.021247827874482e-03},
   {1.925539589446358e-01, 6.540853399480817e-01, 7.654986227904429e-01,
    4.151288701788876e-01, 9.913784846400839e-02, 6.928693007278721e-03},
   {5.040511321639656e-02, 2.789755555810522e-01, 4.638613909718463e-01,
    3.248487564768479e-01, 9.349129673941403e-02, 7.465506062062473e-03},
   {2.004895351675277e-02, 1.575185821600764e-01, 3.405664410139636e-01,
    2.906135774136844e-01, 9.692537560473276e-02, 8.612784576503985e-03},
   {1.049480686269434e-02, 1.081759676054256e-01, 2.876784318810869e-01,
    2.876784318810872e-01, 1.081759676054254e-01, 1.049480686269431e-02}}};
static double _gaussJacobiWt_7[5][5][7] = {
  {// a = 0
   {1.294849661688698e-01, 2.797053914892769e-01, 3.818300505051181e-01,
    4.179591836734698e-01, 3.818300505051184e-01, 2.797053914892769e-01,
    1.294849661688693e-01},
   {2.085744881122954e-02, 1.096334268874941e-01, 2.655387858619662e-01,
    4.285002627834957e-01, 5.095635891983534e-01, 4.420370327634995e-01,
    2.238694536939636e-01},
   {7.141504269513715e-03, 6.530340505843775e-02, 2.353776903162285e-01,
    5.051710296711309e-01, 7.338704262383613e-01, 7.255905969014901e-01,
    3.942120142115044e-01},
   {3.678466030780718e-03, 5.036154251066968e-02, 2.449946740199021e-01,
    6.559226976607052e-01, 1.116001569715522e+00, 1.224904981815210e+00,
    7.041360682472115e-01},
   {2.466358609245232e-03, 4.630428125875304e-02, 2.856629636061731e-01,
    9.135309681033585e-01, 1.767195973241718e+00, 2.112699069906774e+00,
    1.272140385273975e+00}},
  {// a = 1
   {2.238694536939636e-01, 4.420370327634995e-01, 5.095635891983534e-01,
    4.285002627834957e-01, 2.655387858619662e-01, 1.096334268874941e-01,
    2.085744881122954e-02},
   {3.151620015049874e-02, 1.486404045834101e-01, 3.007504247445494e-01,
    3.715192743764176e-01, 3.007504247445494e-01, 1.486404045834105e-01,
    3.151620015049873e-02},
   {9.532643339678785e-03, 7.715728171811140e-02, 2.305847060006972e-01,
    3.781277874504896e-01, 3.752913023507270e-01, 2.133648594462040e-01,
    4.927475302742602e-02},
   {4.379899959590618e-03, 5.253609983883843e-02, 2.107827034784674e-01,
    4.308341311075597e-01, 5.025896761789808e-01, 3.197482880841080e-01,
    7.912920135245609e-02},
   {2.642311378657445e-03, 4.312011267525697e-02, 2.185688182208882e-01,
    5.335551901841303e-01, 7.100879649121659e-01, 4.955201006997029e-01,
    1.298388352625310e-01}},
  {// a = 2
   {3.942120142115044e-01, 7.255905969014901e-01, 7.338704262383613e-01,
    5.051710296711309e-01, 2.353776903162285e-01, 6.530340505843775e-02,
    7.141504269513715e-03},
   {4.927475302742602e-02, 2.133648594462040e-01, 3.752913023507270e-01,
    3.781277874504896e-01, 2.305847060006972e-01, 7.715728171811140e-02,
    9.532643339678785e-03},
   {1.334549735945821e-02, 9.805327628228531e-02, 2.530621622477638e-01,
    3.377447948876519e-01, 2.530621622477643e-01, 9.805327628228526e-02,
    1.334549735945821e-02},
   {5.533765135448010e-03, 5.972976517243198e-02, 2.059687370691036e-01,
    3.422207058046752e-01, 3.020722731851695e-01, 1.317412132665570e-01,
    1.940020703328168e-02},
   {3.034276182623651e-03, 4.425535951665623e-02, 1.921252934435704e-01,
    3.810336414431639e-01, 3.845887142013036e-01, 1.849354686244639e-01,
    2.907486563583823e-02}},
  {// a = 3
   {7.041360682472115e-01, 1.224904981815210e+00, 1.116001569715522e+00,
    6.559226976607052e-01, 2.449946740199021e-01, 5.036154251066968e-02,
    3.678466030780718e-03},
   {7.912920135245609e-02, 3.197482880841080e-01, 5.025896761789808e-01,
    4.308341311075597e-01, 2.107827034784674e-01, 5.253609983883843e-02,
    4.379899959590618e-03},
   {1.940020703328168e-02, 1.317412132665570e-01, 3.020722731851695e-01,
    3.422207058046752e-01, 2.059687370691036e-01, 5.972976517243198e-02,
    5.533765135448010e-03},
   {7.329141196234674e-03, 7.256869444637780e-02, 2.213628084751741e-01,
    3.117644260501397e-01, 2.213628084751741e-01, 7.256869444637799e-02,
    7.329141196234693e-03},
   {3.683138566713657e-03, 4.898574137818602e-02, 1.875104432454986e-01,
    3.149663131830458e-01, 2.561146864945805e-01, 9.293860268022443e-02,
    1.008678873746496e-02}},
  {// a = 4
   {1.272140385273975e+00, 2.112699069906774e+00, 1.767195973241718e+00,
    9.135309681033585e-01, 2.856629636061731e-01, 4.630428125875304e-02,
    2.466358609245232e-03},
   {1.298388352625310e-01, 4.955201006997029e-01, 7.100879649121659e-01,
    5.335551901841303e-01, 2.185688182208882e-01, 4.312011267525697e-02,
    2.642311378657445e-03},
   {2.907486563583823e-02, 1.849354686244639e-01, 3.845887142013036e-01,
    3.810336414431639e-01, 1.921252934435704e-01, 4.425535951665623e-02,
    3.034276182623651e-03},
   {1.008678873746496e-02, 9.293860268022443e-02, 2.561146864945805e-01,
    3.149663131830458e-01, 1.875104432454986e-01, 4.898574137818602e-02,
    3.683138566713657e-03},
   {4.678245726339981e-03, 5.759754869493600e-02, 1.985833464378651e-01,
    2.909801309801314e-01, 1.985833464378650e-01, 5.759754869493602e-02,
    4.678245726340002e-03}}};
static double _gaussJacobiWt_8[5][5][8] = {
  {// a = 0
   {1.012285362903761e-01, 2.223810344533746e-01, 3.137066458778874e-01,
    3.626837833783613e-01, 3.626837833783629e-01, 3.137066458778879e-01,
    2.223810344533742e-01, 1.012285362903756e-01},
   {1.318076576899512e-02, 7.137161062394448e-02, 1.817572780187955e-01,
    3.167983979692773e-01, 4.241894377437207e-01, 4.500231978835504e-01,
    3.644760945454947e-01, 1.782032174462240e-01},
   {3.748142272277550e-03, 3.579617370411527e-02, 1.379749102418798e-01,
    3.265154111083508e-01, 5.475774673732261e-01, 6.822781533755100e-01,
    6.145447461377790e-01, 3.182316624535267e-01},
   {1.639361248317194e-03, 2.377094533317060e-02, 1.256811814607175e-01,
    3.781052906942359e-01, 7.592700769857601e-01, 1.077789430280474e+00,
    1.058912565145634e+00, 5.748311488516893e-01},
   {9.506953721303734e-04, 1.916640120390382e-02, 1.304935723309592e-01,
    4.771178704140306e-01, 1.111038421145520e+00, 1.757123113317146e+00,
    1.856018088575039e+00, 1.048091837641275e+00}},
  {// a = 1
   {1.782032174462240e-01, 3.644760945454947e-01, 4.500231978835504e-01,
    4.241894377437207e-01, 3.167983979692773e-01, 1.817572780187955e-01,
    7.137161062394448e-02, 1.318076576899512e-02},
   {2.059009564912193e-02, 1.021477023603583e-01, 2.253365549698582e-01,
    3.185923136873289e-01, 3.185923136873280e-01, 2.253365549698585e-01,
    1.021477023603587e-01, 2.059009564912189e-02},
   {5.238552377780736e-03, 4.528118112126706e-02, 1.500406762783725e-01,
    2.870401661205415e-01, 3.597380415060730e-01, 3.002369137811520e-01,
    1.527157338016535e-01, 3.304206834649234e-02},
   {2.065739340562864e-03, 2.685329227552708e-02, 1.213601585989501e-01,
    2.944871735464791e-01, 4.423861616913500e-01, 4.224558133538641e-01,
    2.362061416285682e-01, 5.418551956469873e-02},
   {1.087611730783180e-03, 1.950920488347055e-02, 1.130503382722116e-01,
    3.329077231648351e-01, 5.806711112295920e-01, 6.202631214886722e-01,
    3.753897779892454e-01, 9.045444457452227e-02}},
  {// a = 2
   {3.182316624535267e-01, 6.145447461377790e-01, 6.822781533755100e-01,
    5.475774673732261e-01, 3.265154111083508e-01, 1.379749102418798e-01,
    3.579617370411527e-02, 3.748142272277550e-03},
   {3.304206834649234e-02, 1.527157338016535e-01, 3.002369137811520e-01,
    3.597380415060730e-01, 2.870401661205415e-01, 1.500406762783725e-01,
    4.528118112126706e-02, 5.238552377780736e-03},
   {7.604803485383861e-03, 6.061158316018715e-02, 1.777998015448418e-01,
    2.873171451429209e-01, 2.873171451429211e-01, 1.777998015448412e-01,
    6.061158316018710e-02, 7.604803485383872e-03},
   {2.729955919133130e-03, 3.245563265976652e-02, 1.291970707835632e-01,
    2.642124004061389e-01, 3.168304818118640e-01, 2.250337703756065e-01,
    8.482314252379990e-02, 1.138421218679475e-02},
   {1.316071835548569e-03, 2.144888716307647e-02, 1.090504123249688e-01,
    2.702184288613528e-01, 3.764958077560768e-01, 2.999974929296935e-01,
    1.230408981710883e-01, 1.747962000581336e-02}},
  {// a = 3
   {5.748311488516893e-01, 1.058912565145634e+00, 1.077789430280474e+00,
    7.592700769857601e-01, 3.781052906942359e-01, 1.256811814607175e-01,
    2.377094533317060e-02, 1.639361248317194e-03},
   {5.418551956469873e-02, 2.362061416285682e-01, 4.224558133538641e-01,
    4.423861616913500e-01, 2.944871735464791e-01, 1.213601585989501e-01,
    2.685329227552708e-02, 2.065739340562864e-03},
   {1.138421218679475e-02, 8.482314252379990e-02, 2.250337703756065e-01,
    3.168304818118640e-01, 2.642124004061389e-01, 1.291970707835632e-01,
    3.245563265976652e-02, 2.729955919133130e-03},
   {3.750222228158977e-03, 4.138608360546010e-02, 1.483214149682089e-01,
    2.636851363410289e-01, 2.636851363410289e-01, 1.483214149682089e-01,
    4.138608360546023e-02, 3.750222228158972e-03},
   {1.667252698843120e-03, 2.507758136623631e-02, 1.143814533710352e-01,
    2.459996537221724e-01, 2.859103573133612e-01, 1.808092061439313e-01,
    5.512024438244439e-02, 5.319965287689448e-03}},
  {// a = 4
   {1.048091837641275e+00, 1.856018088575039e+00, 1.757123113317146e+00,
    1.111038421145520e+00, 4.771178704140306e-01, 1.304935723309592e-01,
    1.916640120390382e-02, 9.506953721303734e-04},
   {9.045444457452227e-02, 3.753897779892454e-01, 6.202631214886722e-01,
    5.806711112295920e-01, 3.329077231648351e-01, 1.130503382722116e-01,
    1.950920488347055e-02, 1.087611730783180e-03},
   {1.747962000581336e-02, 1.230408981710883e-01, 2.999974929296935e-01,
    3.764958077560768e-01, 2.702184288613528e-01, 1.090504123249688e-01,
    2.144888716307647e-02, 1.316071835548569e-03},
   {5.319965287689448e-03, 5.512024438244439e-02, 1.808092061439313e-01,
    2.859103573133612e-01, 2.459996537221724e-01, 1.143814533710352e-01,
    2.507758136623631e-02, 1.667252698843120e-03},
   {2.194344706426763e-03, 3.083030321571734e-02, 1.282931004441076e-01,
    2.450314579829549e-01, 2.450314579829549e-01, 1.282931004441075e-01,
    3.083030321571735e-02, 2.194344706426775e-03}}};
static double _gaussJacobiWt_9[5][5][9] = {
  {// a = 0
   {8.127438836157411e-02, 1.806481606948576e-01, 2.606106964029355e-01,
    3.123470770400029e-01, 3.302393550012604e-01, 3.123470770400026e-01,
    2.606106964029358e-01, 1.806481606948577e-01, 8.127438836157462e-02},
   {8.723388343092522e-03, 4.824001713914176e-02, 1.272192859642164e-01,
    2.336047811806602e-01, 3.374332873796808e-01, 4.012352367734722e-01,
    3.941349686893823e-01, 3.042970204372327e-01, 1.451120140931190e-01},
   {2.090098772155721e-03, 2.059518916486971e-02, 8.324893263481772e-02,
    2.107462472203986e-01, 3.883250229160511e-01, 5.542751655184366e-01,
    6.213885532844445e-01, 5.239162962671715e-01, 2.620811608883183e-01},
   {7.845319977778029e-04, 1.186239691255504e-02, 6.658886187786846e-02,
    2.174021008992404e-01, 4.877532225754264e-01, 8.086861710341628e-01,
    1.011430820366790e+00, 9.176978056758962e-01, 4.777940886602817e-01},
   {3.965682418173630e-04, 8.426634988953123e-03, 6.164203230608564e-02,
    2.478976287781169e-01, 6.548686598515728e-01, 1.230854190469301e+00,
    1.688161800534614e+00, 1.629871337573286e+00, 8.778811472562599e-01}},
  {// a = 1
   {1.451120140931190e-01, 3.042970204372327e-01, 3.941349686893823e-01,
    4.012352367734722e-01, 3.374332873796808e-01, 2.336047811806602e-01,
    1.272192859642164e-01, 4.824001713914176e-02, 8.723388343092522e-03},
   {1.399105612442674e-02, 7.198285617566078e-02, 1.687989736144606e-01,
    2.617849830242733e-01, 3.002175954556906e-01, 2.617849830242739e-01,
    1.687989736144598e-01, 7.198285617566107e-02, 1.399105612442681e-02},
   {3.030817632182705e-03, 2.748374753453522e-02, 9.805812910221282e-02,
    2.087932895712605e-01, 3.051311007659898e-01, 3.200280655639854e-01,
    2.367140611838098e-01, 1.111609349017288e-01, 2.293318707762953e-02},
   {1.034922348157220e-03, 1.427547148407746e-02, 7.032863437209930e-02,
    1.925454294714609e-01, 3.424554571282205e-01, 4.180731001947779e-01,
    3.465889255613732e-01, 1.764296268206113e-01, 3.826843261922368e-02},
   {4.786263988780120e-04, 9.212258249834964e-03, 5.887792199407641e-02,
    1.981190855706645e-01, 4.148750183845514e-01, 5.753500819840168e-01,
    5.252549930815448e-01, 2.863458082051972e-01, 6.481953946456900e-02}},
  {// a = 2
   {2.620811608883183e-01, 5.239162962671715e-01, 6.213885532844445e-01,
    5.542751655184366e-01, 3.883250229160511e-01, 2.107462472203986e-01,
    8.324893263481772e-02, 2.059518916486971e-02, 2.090098772155721e-03},
   {2.293318707762953e-02, 1.111609349017288e-01, 2.367140611838098e-01,
    3.200280655639854e-01, 3.051311007659898e-01, 2.087932895712605e-01,
    9.805812910221282e-02, 2.748374753453522e-02, 3.030817632182705e-03},
   {4.532848780190382e-03, 3.836522894944150e-02, 1.235014142449354e-01,
    2.283718742253705e-01, 2.771239342667918e-01, 2.283718742253703e-01,
    1.235014142449353e-01, 3.836522894944139e-02, 4.532848780190396e-03},
   {1.419556432490855e-03, 1.813834092782009e-02, 8.021608746285096e-02,
    1.901798804976253e-01, 2.806631498803743e-01, 2.695875591080467e-01,
    1.639747057251420e-01, 5.553300732494925e-02, 6.954379307367488e-03},
   {6.050195730337762e-04, 1.072010839565942e-02, 6.125688594656706e-02,
    1.781164561605714e-01, 3.093861808649055e-01, 3.380708352029016e-01,
    2.271764603321054e-01, 8.281530039514041e-02, 1.090037217673476e-02}},
  {// a = 3
   {4.777940886602817e-01, 9.176978056758962e-01, 1.011430820366790e+00,
    8.086861710341628e-01, 4.877532225754264e-01, 2.174021008992404e-01,
    6.658886187786846e-02, 1.186239691255504e-02, 7.845319977778029e-04},
   {3.826843261922368e-02, 1.764296268206113e-01, 3.465889255613732e-01,
    4.180731001947779e-01, 3.424554571282205e-01, 1.925454294714609e-01,
    7.032863437209930e-02, 1.427547148407746e-02, 1.034922348157220e-03},
   {6.954379307367488e-03, 5.553300732494925e-02, 1.639747057251420e-01,
    2.695875591080467e-01, 2.806631498803743e-01, 1.901798804976253e-01,
    8.021608746285096e-02, 1.813834092782009e-02, 1.419556432490855e-03},
   {2.011157144719757e-03, 2.408461451798091e-02, 9.725756139115974e-02,
    2.044650214311605e-01, 2.586490053156716e-01, 2.044650214311607e-01,
    9.725756139115969e-02, 2.408461451798086e-02, 2.011157144719762e-03},
   {7.948083143692002e-04, 1.312668794657135e-02, 6.824097450514767e-02,
    1.755898455477392e-01, 2.613016730817572e-01, 2.352175534981812e-01,
    1.239193872628280e-01, 3.316676971481035e-02, 2.928014414309612e-03}},
  {// a = 4
   {8.778811472562599e-01, 1.629871337573286e+00, 1.688161800534614e+00,
    1.230854190469301e+00, 6.548686598515728e-01, 2.478976287781169e-01,
    6.164203230608564e-02, 8.426634988953123e-03, 3.965682418173630e-04},
   {6.481953946456900e-02, 2.863458082051972e-01, 5.252549930815448e-01,
    5.753500819840168e-01, 4.148750183845514e-01, 1.981190855706645e-01,
    5.887792199407641e-02, 9.212258249834964e-03, 4.786263988780120e-04},
   {1.090037217673476e-02, 8.281530039514041e-02, 2.271764603321054e-01,
    3.380708352029016e-01, 3.093861808649055e-01, 1.781164561605714e-01,
    6.125688594656706e-02, 1.072010839565942e-02, 6.050195730337762e-04},
   {2.928014414309612e-03, 3.316676971481035e-02, 1.239193872628280e-01,
    2.352175534981812e-01, 2.613016730817572e-01, 1.755898455477392e-01,
    6.824097450514767e-02, 1.312668794657135e-02, 7.948083143692002e-04},
   {1.078664987774300e-03, 1.676843637593469e-02, 8.038851350441679e-02,
    1.863964125090003e-01, 2.434343579441625e-01, 1.863964125090002e-01,
    8.038851350441661e-02, 1.676843637593475e-02, 1.078664987774288e-03}}};
static double _gaussJacobiWt_10[5][5][10] = {
  {// a = 0
   {6.667134430868796e-02, 1.494513491505811e-01, 2.190863625159821e-01,
    2.692667193099963e-01, 2.955242247147531e-01, 2.955242247147530e-01,
    2.692667193099950e-01, 2.190863625159810e-01, 1.494513491505806e-01,
    6.667134430868778e-02},
   {5.996562409625547e-03, 3.367727913193280e-02, 9.109836581305251e-02,
    1.736076256286021e-01, 2.642123022534021e-01, 3.382284387633099e-01,
    3.707875747108959e-01, 3.448452011567033e-01, 2.571486180363293e-01,
    1.203980320961483e-01},
   {1.225920293577290e-03, 1.236418555789262e-02, 5.175911254846813e-02,
    1.375806003724243e-01, 2.708365201345128e-01, 4.230703101357128e-01,
    5.396177550515026e-01, 5.605560616693339e-01, 4.501834912224668e-01,
    2.194727096807776e-01},
   {3.987380445189374e-04, 6.222149508714171e-03, 3.652163224889284e-02,
    1.266064472484918e-01, 3.074176848778439e-01, 5.662005832870052e-01,
    8.196507122185764e-01, 9.345810965658908e-01, 7.991845596077661e-01,
    4.032163963923006e-01},
   {1.769883681770343e-04, 3.914215649037393e-03, 3.022337095838256e-02,
    1.304380877942701e-01, 3.774434228870330e-01, 7.988833608734847e-01,
    1.287936562606778e+00, 1.590225340423518e+00, 1.435055060650287e+00,
    7.457035897890363e-01}},
  {// a = 1
   {1.203980320961483e-01, 2.571486180363293e-01, 3.448452011567033e-01,
    3.707875747108959e-01, 3.382284387633099e-01, 2.642123022534021e-01,
    1.736076256286021e-01, 9.109836581305251e-02, 3.367727913193280e-02,
    5.996562409625547e-03},
   {9.825404805768089e-03, 5.193914377420801e-02, 1.273919483477327e-01,
    2.111657418760754e-01, 2.663444278628828e-01, 2.663444278628820e-01,
    2.111657418760756e-01, 1.273919483477328e-01, 5.193914377420816e-02,
    9.825404805768235e-03},
   {1.832057042737568e-03, 1.722313873549234e-02, 6.492067351505550e-02,
    1.494378024738416e-01, 2.433228507440566e-01, 2.970266172545428e-01,
    2.747429441803760e-01, 1.860911217803869e-01, 8.234582767628330e-02,
    1.639029993056046e-02},
   {5.462394333370451e-04, 7.882014015731303e-03, 4.142722670706492e-02,
    1.239436761798637e-01, 2.485884205662773e-01, 3.580177743107589e-01,
    3.768424674561625e-01, 2.814735121059265e-01, 1.335242156496223e-01,
    2.775445357525714e-02},
   {2.233142705313782e-04, 4.536712221208265e-03, 3.122730629731009e-02,
    1.160081068088709e-01, 2.770339268510800e-01, 4.588756720797210e-01,
    5.392437346710152e-01, 4.379961709280589e-01, 2.205892704417909e-01,
    4.759911876374553e-02}},
  {// a = 2
   {2.194727096807776e-01, 4.501834912224668e-01, 5.605560616693339e-01,
    5.396177550515026e-01, 4.230703101357128e-01, 2.708365201345128e-01,
    1.375806003724243e-01, 5.175911254846813e-02, 1.236418555789262e-02,
    1.225920293577290e-03},
   {1.639029993056046e-02, 8.234582767628330e-02, 1.860911217803869e-01,
    2.747429441803760e-01, 2.970266172545428e-01, 2.433228507440566e-01,
    1.494378024738416e-01, 6.492067351505550e-02, 1.722313873549234e-02,
    1.832057042737568e-03},
   {2.808941213367817e-03, 2.488609750147603e-02, 8.590158815236659e-02,
    1.754113673268373e-01, 2.443253391392856e-01, 2.443253391392861e-01,
    1.754113673268374e-01, 8.590158815236641e-02, 2.488609750147600e-02,
    2.808941213367841e-03},
   {7.730524588664571e-04, 1.043934319224347e-02, 4.999771360892913e-02,
    1.322845011659509e-01, 2.266422530788494e-01, 2.674654289496634e-01,
    2.189397652323106e-01, 1.186681094634199e-01, 3.705619872334139e-02,
    4.400300793092868e-03},
   {2.929041347145321e-04, 5.536370347918375e-03, 3.458592594755515e-02,
    1.133460102777502e-01, 2.309929948180737e-01, 3.136606795061906e-01,
    2.871907378094203e-01, 1.698401658098329e-01, 5.658135757422238e-02,
    7.020472821941071e-03}},
  {// a = 3
   {4.032163963923006e-01, 7.991845596077661e-01, 9.345810965658908e-01,
    8.196507122185764e-01, 5.662005832870052e-01, 3.074176848778439e-01,
    1.266064472484918e-01, 3.652163224889284e-02, 6.222149508714171e-03,
    3.987380445189374e-04},
   {2.775445357525714e-02, 1.335242156496223e-01, 2.814735121059265e-01,
    3.768424674561625e-01, 3.580177743107589e-01, 2.485884205662773e-01,
    1.239436761798637e-01, 4.142722670706492e-02, 7.882014015731303e-03,
    5.462394333370451e-04},
   {4.400300793092868e-03, 3.705619872334139e-02, 1.186681094634199e-01,
    2.189397652323106e-01, 2.674654289496634e-01, 2.266422530788494e-01,
    1.322845011659509e-01, 4.999771360892913e-02, 1.043934319224347e-02,
    7.730524588664571e-04},
   {1.124433170553250e-03, 1.434465433125631e-02, 6.345603076730036e-02,
    1.512552800345786e-01, 2.269624588391684e-01, 2.269624588391684e-01,
    1.512552800345791e-01, 6.345603076730053e-02, 1.434465433125623e-02,
    1.124433170553240e-03},
   {3.969709655448310e-04, 7.051772659876825e-03, 4.054135817725277e-02,
    1.194221947109241e-01, 2.129306406750290e-01, 2.450507596235002e-01,
    1.829292062176269e-01, 8.395914704503786e-02, 2.032943574788931e-02,
    1.674228463030883e-03}},
  {// a = 4
   {7.457035897890363e-01, 1.435055060650287e+00, 1.590225340423518e+00,
    1.287936562606778e+00, 7.988833608734847e-01, 3.774434228870330e-01,
    1.304380877942701e-01, 3.022337095838256e-02, 3.914215649037393e-03,
    1.769883681770343e-04},
   {4.759911876374553e-02, 2.205892704417909e-01, 4.379961709280589e-01,
    5.392437346710152e-01, 4.588756720797210e-01, 2.770339268510800e-01,
    1.160081068088709e-01, 3.122730629731009e-02, 4.536712221208265e-03,
    2.233142705313782e-04},
   {7.020472821941071e-03, 5.658135757422238e-02, 1.698401658098329e-01,
    2.871907378094203e-01, 3.136606795061906e-01, 2.309929948180737e-01,
    1.133460102777502e-01, 3.458592594755515e-02, 5.536370347918375e-03,
    2.929041347145321e-04},
   {1.674228463030883e-03, 2.032943574788931e-02, 8.395914704503786e-02,
    1.829292062176269e-01, 2.450507596235002e-01, 2.129306406750290e-01,
    1.194221947109241e-01, 4.054135817725277e-02, 7.051772659876825e-03,
    3.969709655448310e-04},
   {5.533092611488388e-04, 9.312078732135522e-03, 4.981615856567945e-02,
    1.338440861946089e-01, 2.128235735956336e-01, 2.128235735956340e-01,
    1.338440861946093e-01, 4.981615856567939e-02, 9.312078732135546e-03,
    5.533092611488373e-04}}};
static double _gaussJacobiWt_11[5][5][11] = {
  {// a = 0
   {5.566856711617359e-02, 1.255803694649046e-01, 1.862902109277350e-01,
    2.331937645919905e-01, 2.628045445102469e-01, 2.729250867779014e-01,
    2.628045445102468e-01, 2.331937645919903e-01, 1.862902109277345e-01,
    1.255803694649044e-01, 5.566856711617318e-02},
   {4.254669172978147e-03, 2.417568384191924e-02, 6.665449380672291e-02,
    1.305661868553332e-01, 2.063654426891905e-01, 2.781275006327323e-01,
    3.275164119522538e-01, 3.386376915360718e-01, 3.024801922287482e-01,
    2.197523645314864e-01, 1.014693627525651e-01},
   {7.504038880782284e-04, 7.704164604345901e-03, 3.312003410575227e-02,
    9.131672734478077e-02, 1.887173083104552e-01, 3.143217423874861e-01,
    4.370577785683599e-01, 5.134684747980476e-01, 5.038363440029392e-01,
    3.899668882453152e-01, 1.864068004111078e-01},
   {2.133502587477222e-04, 3.411276856284806e-03, 2.071970073321518e-02,
    7.516721727852196e-02, 1.935791520138537e-01, 3.846472609341519e-01,
    6.152504691304241e-01, 8.056538714959643e-01, 8.566217628420132e-01,
    7.000185078915774e-01, 3.447174305652413e-01},
   {8.373308015001190e-05, 1.910381097398653e-03, 1.538057913605891e-02,
    7.006400214752159e-02, 2.171198836550185e-01, 5.012202707328959e-01,
    9.038653956468931e-01, 1.299520565991693e+00, 1.481068587210711e+00,
    1.268666943139948e+00, 6.410996581617191e-01}},
  {// a = 1
   {1.014693627525651e-01, 2.197523645314864e-01, 3.024801922287482e-01,
    3.386376915360718e-01, 3.275164119522538e-01, 2.781275006327323e-01,
    2.063654426891905e-01, 1.305661868553332e-01, 6.665449380672291e-02,
    2.417568384191924e-02, 4.254669172978147e-03},
   {7.095539995635450e-03, 3.829380565181230e-02, 9.717589117367044e-02,
    1.692843256838664e-01, 2.288516794949587e-01, 2.519308493334464e-01,
    2.288516794949586e-01, 1.692843256838672e-01, 9.717589117367048e-02,
    3.829380565181205e-02, 7.095539995635458e-03},
   {1.149899262705060e-03, 1.111523459854731e-02, 4.369574953640146e-02,
    1.066649642595343e-01, 1.880714727028224e-01, 2.557004122008758e-01,
    2.746085708964524e-01, 2.315271861986933e-01, 1.467419246783587e-01,
    6.204547371934391e-02, 1.201244527959806e-02},
   {3.016629546290895e-04, 4.508258947434251e-03, 2.490755722153995e-02,
    7.971906620710731e-02, 1.748287416827368e-01, 2.834908718635391e-01,
    3.506808225567526e-01, 3.305087708885728e-01, 2.280226846392065e-01,
    1.024342121217006e-01, 2.059735091678128e-02},
   {1.096783521306954e-04, 2.324551515253453e-03, 1.694941861111087e-02,
    6.792551436237800e-02, 1.789973972638532e-01, 3.371979991598771e-01,
    4.708939598294999e-01, 4.886006136701065e-01, 3.628202611779144e-01,
    1.718078254086433e-01, 3.570611398256825e-02}},
  {// a = 2
   {1.864068004111078e-01, 3.899668882453152e-01, 5.038363440029392e-01,
    5.134684747980476e-01, 4.370577785683599e-01, 3.143217423874861e-01,
    1.887173083104552e-01, 9.131672734478077e-02, 3.312003410575227e-02,
    7.704164604345901e-03, 7.504038880782284e-04},
   {1.201244527959806e-02, 6.204547371934391e-02, 1.467419246783587e-01,
    2.315271861986933e-01, 2.746085708964524e-01, 2.557004122008758e-01,
    1.880714727028224e-01, 1.066649642595343e-01, 4.369574953640146e-02,
    1.111523459854731e-02, 1.149899262705060e-03},
   {1.800505712143062e-03, 1.652979749395006e-02, 6.021451394938584e-02,
    1.325938441003085e-01, 2.046269423886040e-01, 2.351354593778834e-01,
    2.046269423886035e-01, 1.325938441003083e-01, 6.021451394938595e-02,
    1.652979749395013e-02, 1.800505712143067e-03},
   {4.384344964523082e-04, 6.183266472687995e-03, 3.150640500283894e-02,
    9.066995484349000e-02, 1.737233827592598e-01, 2.379749388872305e-01,
    2.387560489479536e-01, 1.733323982904236e-01, 8.599874690757750e-02,
    2.521164399849497e-02, 2.871446060256749e-03},
   {1.484733835020589e-04, 2.953427403304018e-03, 1.978315420318005e-02,
    7.109997502153002e-02, 1.634634630424583e-01, 2.600835280107577e-01,
    2.948607419574116e-01, 2.361731707811737e-01, 1.265434095391612e-01,
    3.928594784442110e-02, 4.652327860721107e-03}},
  {// a = 3
   {3.447174305652413e-01, 7.000185078915774e-01, 8.566217628420132e-01,
    8.056538714959643e-01, 6.152504691304241e-01, 3.846472609341519e-01,
    1.935791520138537e-01, 7.516721727852196e-02, 2.071970073321518e-02,
    3.411276856284806e-03, 2.133502587477222e-04},
   {2.059735091678128e-02, 1.024342121217006e-01, 2.280226846392065e-01,
    3.305087708885728e-01, 3.506808225567526e-01, 2.834908718635391e-01,
    1.748287416827368e-01, 7.971906620710731e-02, 2.490755722153995e-02,
    4.508258947434251e-03, 3.016629546290895e-04},
   {2.871446060256749e-03, 2.521164399849497e-02, 8.599874690757750e-02,
    1.733323982904236e-01, 2.387560489479536e-01, 2.379749388872305e-01,
    1.737233827592598e-01, 9.066995484349000e-02, 3.150640500283894e-02,
    6.183266472687995e-03, 4.384344964523082e-04},
   {6.523613474704498e-04, 8.748910971782960e-03, 4.156660510678858e-02,
    1.091649348532573e-01, 1.863580639798480e-01, 2.213039617674194e-01,
    1.863580639798469e-01, 1.091649348532574e-01, 4.156660510678864e-02,
    8.748910971782996e-03, 6.523613474704435e-04},
   {2.067362223280178e-04, 3.891630830430294e-03, 2.421953842084509e-02,
    7.924262835390317e-02, 1.621005459870287e-01, 2.235084160660967e-01,
    2.128254368400618e-01, 1.377782067838998e-01, 5.681049195022907e-02,
    1.271152895582430e-02, 9.905538750657984e-04}},
  {// a = 4
   {6.410996581617191e-01, 1.268666943139948e+00, 1.481068587210711e+00,
    1.299520565991693e+00, 9.038653956468931e-01, 5.012202707328959e-01,
    2.171198836550185e-01, 7.006400214752159e-02, 1.538057913605891e-02,
    1.910381097398653e-03, 8.373308015001190e-05},
   {3.570611398256825e-02, 1.718078254086433e-01, 3.628202611779144e-01,
    4.886006136701065e-01, 4.708939598294999e-01, 3.371979991598771e-01,
    1.789973972638532e-01, 6.792551436237800e-02, 1.694941861111087e-02,
    2.324551515253453e-03, 1.096783521306954e-04},
   {4.652327860721107e-03, 3.928594784442110e-02, 1.265434095391612e-01,
    2.361731707811737e-01, 2.948607419574116e-01, 2.600835280107577e-01,
    1.634634630424583e-01, 7.109997502153002e-02, 1.978315420318005e-02,
    2.953427403304018e-03, 1.484733835020589e-04},
   {9.905538750657984e-04, 1.271152895582430e-02, 5.681049195022907e-02,
    1.377782067838998e-01, 2.128254368400618e-01, 2.235084160660967e-01,
    1.621005459870287e-01, 7.924262835390317e-02, 2.421953842084509e-02,
    3.891630830430294e-03, 2.067362223280178e-04},
   {2.949699603442579e-04, 5.289865663661539e-03, 3.086829305071137e-02,
    9.305474127317909e-02, 1.720131439851640e-01, 2.096563848322926e-01,
    1.720131439851645e-01, 9.305474127317945e-02, 3.086829305071124e-02,
    5.289865663661513e-03, 2.949699603442520e-04}}};
static double _gaussJacobiWt_12[5][5][12] = {
  {// a = 0
   {4.717533638651165e-02, 1.069393259953177e-01, 1.600783285433471e-01,
    2.031674267230658e-01, 2.334925365383551e-01, 2.491470458134026e-01,
    2.491470458134035e-01, 2.334925365383542e-01, 2.031674267230665e-01,
    1.600783285433462e-01, 1.069393259953178e-01, 4.717533638651158e-02},
   {3.100728883752147e-03, 1.777923118267409e-02, 4.974403666568916e-02,
    9.950712163706166e-02, 1.618066148276543e-01, 2.264553748546699e-01,
    2.804373599905204e-01, 3.107852672621240e-01, 3.075864107201645e-01,
    2.664270025066927e-01, 1.897114079215105e-01, 8.665944354748625e-02},
   {4.764028784664954e-04, 4.959627188356132e-03, 2.176673715283072e-02,
    6.173093619109135e-02, 1.323787491568754e-01, 2.312644147098197e-01,
    3.421181085615115e-01, 4.365915293138515e-01, 4.820048599008365e-01,
    4.526734779957938e-01, 3.404529229392461e-01, 1.602489006779884e-01},
   {1.193330081565083e-04, 1.945006560838395e-03, 1.213502956040336e-02,
    4.560803582593135e-02, 1.228862623362184e-01, 2.585409591884750e-01,
    4.447159771712300e-01, 6.403133491695374e-01, 7.766469990726416e-01,
    7.822051788980672e-01, 6.168690025573704e-01, 2.980148666511306e-01},
   {4.167550989594096e-05, 9.746484451651032e-04, 8.110511582616609e-03,
    3.854481130511551e-02, 1.259585671789702e-01, 3.106195879667678e-01,
    6.083968301148478e-01, 9.725643700996832e-01, 1.280325087870005e+00,
    1.370700913695420e+00, 1.126816800360463e+00, 5.569461958710573e-01}},
  {// a = 1
   {8.665944354748625e-02, 1.897114079215105e-01, 2.664270025066927e-01,
    3.075864107201645e-01, 3.107852672621240e-01, 2.804373599905204e-01,
    2.264553748546699e-01, 1.618066148276543e-01, 9.950712163706166e-02,
    4.974403666568916e-02, 1.777923118267409e-02, 3.100728883752147e-03},
   {5.248378306690829e-03, 2.878773224796075e-02, 7.501033346761930e-02,
    1.357541298844588e-01, 1.933877382614317e-01, 2.284783544985051e-01,
    2.284783544985060e-01, 1.933877382614313e-01, 1.357541298844587e-01,
    7.501033346761908e-02, 2.878773224796063e-02, 5.248378306690834e-03},
   {7.456481160415842e-04, 7.367522276476792e-03, 2.993159664982637e-02,
    7.646513872066901e-02, 1.432531534925865e-01, 2.109979259488977e-01,
    2.521139155965506e-01, 2.461565322299591e-01, 1.933856185056310e-01,
    1.164183433759065e-01, 4.750023002042897e-02, 8.997708400360172e-03},
   {1.733201954603828e-04, 2.663375924142158e-03, 1.530538769641553e-02,
    5.163296826317448e-02, 1.212728758681529e-01, 2.149277465007842e-01,
    2.987288283147951e-01, 3.296424030105624e-01, 2.853791830959428e-01,
    1.850479228618409e-01, 7.963049002866893e-02, 1.559549824006065e-02},
   {5.636000883929227e-05, 1.235639203329192e-03, 9.431187007408585e-03,
    4.011459085676399e-02, 1.140748319888013e-01, 2.368318931636009e-01,
    3.750272556032356e-01, 4.602252951282348e-01, 4.336459582840581e-01,
    3.000874153659292e-01, 1.353132928880176e-01, 2.728961383511349e-02}},
  {// a = 2
   {1.602489006779884e-01, 3.404529229392461e-01, 4.526734779957938e-01,
    4.820048599008365e-01, 4.365915293138515e-01, 3.421181085615115e-01,
    2.312644147098197e-01, 1.323787491568754e-01, 6.173093619109135e-02,
    2.176673715283072e-02, 4.959627188356132e-03, 4.764028784664954e-04},
   {8.997708400360172e-03, 4.750023002042897e-02, 1.164183433759065e-01,
    1.933856185056310e-01, 2.461565322299591e-01, 2.521139155965506e-01,
    2.109979259488977e-01, 1.432531534925865e-01, 7.646513872066901e-02,
    2.993159664982637e-02, 7.367522276476792e-03, 7.456481160415842e-04},
   {1.188743462219393e-03, 1.122649323736320e-02, 4.267068321985847e-02,
    9.965956754203634e-02, 1.663963219714445e-01, 2.121915239004110e-01,
    2.121915239004118e-01, 1.663963219714444e-01, 9.965956754203625e-02,
    4.267068321985902e-02, 1.122649323736324e-02, 1.188743462219383e-03},
   {2.577369625023287e-04, 3.763263514317599e-03, 2.014208651189309e-02,
    6.192061938238031e-02, 1.293473345939407e-01, 1.982851263604149e-01,
    2.306926096950135e-01, 2.047209310033421e-01, 1.354431301030032e-01,
    6.268919235475058e-02, 1.747921950928045e-02, 1.925416675828279e-03},
   {7.840742034268568e-05, 1.625091831063023e-03, 1.150901408639995e-02,
    4.448959898667763e-02, 1.123347127135556e-01, 2.015952487575734e-01,
    2.672983975138279e-01, 2.641333767278580e-01, 1.906288199813589e-01,
    9.447154448063547e-02, 2.772150868146296e-02, 3.161897866864669e-03}},
  {// a = 3
   {2.980148666511306e-01, 6.168690025573704e-01, 7.822051788980672e-01,
    7.766469990726416e-01, 6.403133491695374e-01, 4.447159771712300e-01,
    2.585409591884750e-01, 1.228862623362184e-01, 4.560803582593135e-02,
    1.213502956040336e-02, 1.945006560838395e-03, 1.193330081565083e-04},
   {1.559549824006065e-02, 7.963049002866893e-02, 1.850479228618409e-01,
    2.853791830959428e-01, 3.296424030105624e-01, 2.987288283147951e-01,
    2.149277465007842e-01, 1.212728758681529e-01, 5.163296826317448e-02,
    1.530538769641553e-02, 2.663375924142158e-03, 1.733201954603828e-04},
   {1.925416675828279e-03, 1.747921950928045e-02, 6.268919235475058e-02,
    1.354431301030032e-01, 2.047209310033421e-01, 2.306926096950135e-01,
    1.982851263604149e-01, 1.293473345939407e-01, 6.192061938238031e-02,
    2.014208651189309e-02, 3.763263514317599e-03, 2.577369625023287e-04},
   {3.911486181435101e-04, 5.461105384452814e-03, 2.746919446371457e-02,
    7.788624927503261e-02, 1.469991263025606e-01, 1.989360330989531e-01,
    1.989360330989529e-01, 1.469991263025605e-01, 7.788624927503256e-02,
    2.746919446371462e-02, 5.461105384452812e-03, 3.911486181435191e-04},
   {1.117846511781470e-04, 2.205326630343932e-03, 1.462738139401716e-02,
    5.202304164220765e-02, 1.184941629093040e-01, 1.875938598228309e-01,
    2.138206304777831e-01, 1.761070201336626e-01, 1.019753091517070e-01,
    3.861402950916015e-02, 8.108924612841111e-03, 6.042433506779847e-04}},
  {// a = 4
   {5.569461958710573e-01, 1.126816800360463e+00, 1.370700913695420e+00,
    1.280325087870005e+00, 9.725643700996832e-01, 6.083968301148478e-01,
    3.106195879667678e-01, 1.259585671789702e-01, 3.854481130511551e-02,
    8.110511582616609e-03, 9.746484451651032e-04, 4.167550989594096e-05},
   {2.728961383511349e-02, 1.353132928880176e-01, 3.000874153659292e-01,
    4.336459582840581e-01, 4.602252951282348e-01, 3.750272556032356e-01,
    2.368318931636009e-01, 1.140748319888013e-01, 4.011459085676399e-02,
    9.431187007408585e-03, 1.235639203329192e-03, 5.636000883929227e-05},
   {3.161897866864669e-03, 2.772150868146296e-02, 9.447154448063547e-02,
    1.906288199813589e-01, 2.641333767278580e-01, 2.672983975138279e-01,
    2.015952487575734e-01, 1.123347127135556e-01, 4.448959898667763e-02,
    1.150901408639995e-02, 1.625091831063023e-03, 7.840742034268568e-05},
   {6.042433506779847e-04, 8.108924612841111e-03, 3.861402950916015e-02,
    1.019753091517070e-01, 1.761070201336626e-01, 2.138206304777831e-01,
    1.875938598228309e-01, 1.184941629093040e-01, 5.202304164220765e-02,
    1.462738139401716e-02, 2.205326630343932e-03, 1.117846511781470e-04},
   {1.628181143406894e-04, 3.074794517936475e-03, 1.924705568647300e-02,
    6.361096326827916e-02, 1.323750332742049e-01, 1.878785414879722e-01,
    1.878785414879728e-01, 1.323750332742052e-01, 6.361096326827892e-02,
    1.924705568647300e-02, 3.074794517936469e-03, 1.628181143406876e-04}}};
static double _gaussJacobiWt_13[5][5][13] = {
  {// a = 0
   {4.048400476531575e-02, 9.212149983772837e-02, 1.388735102197882e-01,
    1.781459807619455e-01, 2.078160475368879e-01, 2.262831802628978e-01,
    2.325515532308743e-01, 2.262831802628966e-01, 2.078160475368891e-01,
    1.781459807619461e-01, 1.388735102197881e-01, 9.212149983772847e-02,
    4.048400476531563e-02},
   {2.312226819744752e-03, 1.335343700309510e-02, 3.779569791837089e-02,
    7.685582865887940e-02, 1.277471486488124e-01, 1.839831227042100e-01,
    2.364819252563691e-01, 2.752621179502622e-01, 2.913987860632732e-01,
    2.788538731285788e-01, 2.358157518265868e-01, 1.652811576793572e-01,
    7.485892634246154e-02},
   {3.121359461131697e-04, 3.285767134327090e-03, 1.465912911391509e-02,
    4.250855471066116e-02, 9.382607674481498e-02, 1.700399737180531e-01,
    2.635236134274632e-01, 3.569968060449198e-01, 4.267201728469727e-01,
    4.488922970466200e-01, 4.072786457015594e-01, 2.994136653507510e-01,
    1.392098288804964e-01},
   {6.937390186694232e-05, 1.148285284471928e-03, 7.319582997219005e-03,
    2.829353227289212e-02, 7.899581366652146e-02, 1.737411980856215e-01,
    3.158212716990506e-01, 4.874953331555133e-01, 6.473175933518743e-01,
    7.394215458673388e-01, 7.133884534469215e-01, 5.468339215681184e-01,
    2.601540947025925e-01},
   {2.168601794925228e-05, 5.174028875011276e-04, 4.421556577357340e-03,
    2.173743508511354e-02, 7.408929962728636e-02, 1.923993910880153e-01,
    4.015101204430444e-01, 6.943966563830739e-01, 1.010970989863907e+00,
    1.241523395706928e+00, 1.264462345661009e+00, 1.005683466539794e+00,
    4.882662541190213e-01}},
  {// a = 1
   {7.485892634246154e-02, 1.652811576793572e-01, 2.358157518265868e-01,
    2.788538731285788e-01, 2.913987860632732e-01, 2.752621179502622e-01,
    2.364819252563691e-01, 1.839831227042100e-01, 1.277471486488124e-01,
    7.685582865887940e-02, 3.779569791837089e-02, 1.335343700309510e-02,
    2.312226819744752e-03},
   {3.963459182191560e-03, 2.202259816054245e-02, 5.859867372784859e-02,
    1.092820307207265e-01, 1.621330288912999e-01, 2.021428178096500e-01,
    2.170481163488148e-01, 2.021428178096503e-01, 1.621330288913002e-01,
    1.092820307207269e-01, 5.859867372784814e-02, 2.202259816054258e-02,
    3.963459182191537e-03},
   {4.974697396217912e-04, 5.002681014390005e-03, 2.086493921623218e-02,
    5.525688426182686e-02, 1.085484975066134e-01, 1.700194948735662e-01,
    2.200217680401301e-01, 2.386791532071573e-01, 2.165954959761593e-01,
    1.610154481635283e-01, 9.305911626472203e-02, 3.690349010142586e-02,
    6.868894967957435e-03},
   {1.031100740970801e-04, 1.620522373394041e-03, 9.611568848164579e-03,
    3.381296713438840e-02, 8.382448867815685e-02, 1.591371702342223e-01,
    2.415053788486821e-01, 2.987711704546474e-01, 3.017760050589875e-01,
    2.443408860166679e-01, 1.507931911828451e-01, 6.268541649393325e-02,
    1.201812460181474e-02},
   {3.014616932438513e-05, 6.793549303198244e-04, 5.380402912272425e-03,
    2.400342141421549e-02, 7.250399049992343e-02, 1.623672833574305e-01,
    2.828789150684345e-01, 3.924556097743016e-01, 4.354347544679585e-01,
    3.800960790498376e-01, 2.485665142539380e-01, 1.077332484690910e-01,
    2.120361296628662e-02}},
  {// a = 2
   {1.392098288804964e-01, 2.994136653507510e-01, 4.072786457015594e-01,
    4.488922970466200e-01, 4.267201728469727e-01, 3.569968060449198e-01,
    2.635236134274632e-01, 1.700399737180531e-01, 9.382607674481498e-02,
    4.250855471066116e-02, 1.465912911391509e-02, 3.285767134327090e-03,
    3.121359461131697e-04},
   {6.868894967957435e-03, 3.690349010142586e-02, 9.305911626472203e-02,
    1.610154481635283e-01, 2.165954959761593e-01, 2.386791532071573e-01,
    2.200217680401301e-01, 1.700194948735662e-01, 1.085484975066134e-01,
    5.525688426182686e-02, 2.086493921623218e-02, 5.002681014390005e-03,
    4.974697396217912e-04},
   {8.055421013939556e-04, 7.783410603515764e-03, 3.061136703734236e-02,
    7.492798978976632e-02, 1.330992358210581e-01, 1.839654979337558e-01,
    2.042805800930028e-01, 1.839654979337549e-01, 1.330992358210576e-01,
    7.492798978976679e-02, 3.061136703734238e-02, 7.783410603515736e-03,
    8.055421013939598e-04},
   {1.564122466970863e-04, 2.349147984501424e-03, 1.308305096663412e-02,
    4.240412564469897e-02, 9.484987207187981e-02, 1.587022870850947e-01,
    2.065979808917429e-01, 2.123067112458968e-01, 1.712314102542858e-01,
    1.052512386966261e-01, 4.607540000443199e-02, 1.233648660199831e-02,
    1.322542972178784e-03},
   {4.295001061479064e-05, 9.205812398147590e-04, 6.821344197017788e-03,
    2.796255040489091e-02, 7.607183809904966e-02, 1.499986056368707e-01,
    2.241370184428464e-01, 2.584752687983442e-01, 2.293349277361163e-01,
    1.523281087819183e-01, 7.088709168777810e-02, 1.986948913071626e-02,
    2.197844881642222e-03}},
  {// a = 3
   {2.601540947025925e-01, 5.468339215681184e-01, 7.133884534469215e-01,
    7.394215458673388e-01, 6.473175933518743e-01, 4.874953331555133e-01,
    3.158212716990506e-01, 1.737411980856215e-01, 7.899581366652146e-02,
    2.829353227289212e-02, 7.319582997219005e-03, 1.148285284471928e-03,
    6.937390186694232e-05},
   {1.201812460181474e-02, 6.268541649393325e-02, 1.507931911828451e-01,
    2.443408860166679e-01, 3.017760050589875e-01, 2.987711704546474e-01,
    2.415053788486821e-01, 1.591371702342223e-01, 8.382448867815685e-02,
    3.381296713438840e-02, 9.611568848164579e-03, 1.620522373394041e-03,
    1.031100740970801e-04},
   {1.322542972178784e-03, 1.233648660199831e-02, 4.607540000443199e-02,
    1.052512386966261e-01, 1.712314102542858e-01, 2.123067112458968e-01,
    2.065979808917429e-01, 1.587022870850947e-01, 9.484987207187981e-02,
    4.240412564469897e-02, 1.308305096663412e-02, 2.349147984501424e-03,
    1.564122466970863e-04},
   {2.415281909787100e-04, 3.484873369011269e-03, 1.836046147696099e-02,
    5.537471349643075e-02, 1.132067473271513e-01, 1.697100479751122e-01,
    1.935289706144242e-01, 1.697100479751119e-01, 1.132067473271510e-01,
    5.537471349643071e-02, 1.836046147696111e-02, 3.484873369011242e-03,
    2.415281909787145e-04},
   {6.252059281441082e-05, 1.281884255660952e-03, 8.956207670262731e-03,
    3.407904169227087e-02, 8.459163548636887e-02, 1.493001878472489e-01,
    1.953783065712911e-01, 1.923582394121643e-01, 1.413269982499625e-01,
    7.484582724561369e-02, 2.645164081457572e-02, 5.274380504982012e-03,
    3.788439424974829e-04}},
  {// a = 4
   {4.882662541190213e-01, 1.005683466539794e+00, 1.264462345661009e+00,
    1.241523395706928e+00, 1.010970989863907e+00, 6.943966563830739e-01,
    4.015101204430444e-01, 1.923993910880153e-01, 7.408929962728636e-02,
    2.173743508511354e-02, 4.421556577357340e-03, 5.174028875011276e-04,
    2.168601794925228e-05},
   {2.120361296628662e-02, 1.077332484690910e-01, 2.485665142539380e-01,
    3.800960790498376e-01, 4.354347544679585e-01, 3.924556097743016e-01,
    2.828789150684345e-01, 1.623672833574305e-01, 7.250399049992343e-02,
    2.400342141421549e-02, 5.380402912272425e-03, 6.793549303198244e-04,
    3.014616932438513e-05},
   {2.197844881642222e-03, 1.986948913071626e-02, 7.088709168777810e-02,
    1.523281087819183e-01, 2.293349277361163e-01, 2.584752687983442e-01,
    2.241370184428464e-01, 1.499986056368707e-01, 7.607183809904966e-02,
    2.796255040489091e-02, 6.821344197017788e-03, 9.205812398147590e-04,
    4.295001061479064e-05},
   {3.788439424974829e-04, 5.274380504982012e-03, 2.645164081457572e-02,
    7.484582724561369e-02, 1.413269982499625e-01, 1.923582394121643e-01,
    1.953783065712911e-01, 1.493001878472489e-01, 8.459163548636887e-02,
    3.407904169227087e-02, 8.956207670262731e-03, 1.281884255660952e-03,
    6.252059281441082e-05},
   {9.274747547932102e-05, 1.827839107867632e-03, 1.211960626309079e-02,
    4.316636605369080e-02, 9.880604143765884e-02, 1.581799533378842e-01,
    1.843133053470706e-01, 1.581799533378844e-01, 9.880604143765898e-02,
    4.316636605369080e-02, 1.211960626309077e-02, 1.827839107867644e-03,
    9.274747547932266e-05}}};
static double _gaussJacobiWt_14[5][5][14] = {
  {// a = 0
   {3.511946033175177e-02, 8.015808715976037e-02, 1.215185706879029e-01,
    1.572031671581935e-01, 1.855383974779378e-01, 2.051984637212956e-01,
    2.152638534631587e-01, 2.152638534631577e-01, 2.051984637212954e-01,
    1.855383974779379e-01, 1.572031671581937e-01, 1.215185706879025e-01,
    8.015808715976024e-02, 3.511946033175173e-02},
   {1.758854834988620e-03, 1.021640527075066e-02, 2.918593653285032e-02,
    6.012921497571456e-02, 1.016938616285951e-01, 1.497723858359430e-01,
    1.980778180928126e-01, 2.391422360901269e-01, 2.655694025043416e-01,
    2.713266384167318e-01, 2.528521022973164e-01, 2.097838140076677e-01,
    1.451843122217735e-01, 6.530701729038797e-02},
   {2.102092933512020e-04, 2.232794727575034e-03, 1.009427116125995e-02,
    2.979900540226315e-02, 6.730381389709168e-02, 1.255546582805833e-01,
    2.017294682947131e-01, 2.859120823401174e-01, 3.620274580356865e-01,
    4.111193923157733e-01, 4.162069232856134e-01, 3.673181769173702e-01,
    2.651167637596821e-01, 1.220416489555879e-01},
   {4.172050424740590e-05, 6.992940782808716e-04, 4.535933794294162e-03,
    1.793630081767578e-02, 5.153000016154856e-02, 1.174031767230196e-01,
    2.228449471866996e-01, 3.627915647760550e-01, 5.149516227368192e-01,
    6.414563472313936e-01, 6.984046665688880e-01, 6.508470638921978e-01,
    4.875112074531002e-01, 2.290461540757796e-01},
   {1.173639058512370e-05, 2.846438887262163e-04, 2.485900952118036e-03,
    1.256281166489784e-02, 4.430069886476670e-02, 1.199026280873384e-01,
    2.630633931261068e-01, 4.834847111771459e-01, 7.587927790172442e-01,
    1.025672181668925e+00, 1.191094759828622e+00, 1.164961742792316e+00,
    9.018798069579228e-01, 4.315022055832897e-01}},
  {// a = 1
   {6.530701729038797e-02, 1.451843122217735e-01, 2.097838140076677e-01,
    2.528521022973164e-01, 2.713266384167318e-01, 2.655694025043416e-01,
    2.391422360901269e-01, 1.980778180928126e-01, 1.497723858359430e-01,
    1.016938616285951e-01, 6.012921497571456e-02, 2.918593653285032e-02,
    1.021640527075066e-02, 1.758854834988620e-03},
   {3.047858953593590e-03, 1.711338650097897e-02, 4.631282209740326e-02,
    8.847140045241639e-02, 1.355587811983995e-01, 1.762776180037205e-01,
    1.998847994601545e-01, 1.998847994601549e-01, 1.762776180037204e-01,
    1.355587811983991e-01, 8.847140045241658e-02, 4.631282209740335e-02,
    1.711338650097906e-02, 3.047858953593541e-03},
   {3.403087202360611e-04, 3.471711700989961e-03, 1.479157271769134e-02,
    4.032641683989160e-02, 8.227667090507361e-02, 1.352669120293372e-01,
    1.861827100865889e-01, 2.186012826669045e-01, 2.200726823124868e-01,
    1.885218718051658e-01, 1.340953938539698e-01, 7.499376231263508e-02,
    2.905988249720480e-02, 5.332154885158092e-03},
   {6.326269590322779e-05, 1.012767430464015e-03, 6.163825551175200e-03,
    2.243366363111491e-02, 5.808025257876499e-02, 1.164450220527087e-01,
    1.892321595216501e-01, 2.552838807732780e-01, 2.884332111068226e-01,
    2.715893798478555e-01, 2.083823653344777e-01, 1.235445432558051e-01,
    4.992893560070189e-02, 9.406730619278396e-03},
   {1.671115988738263e-05, 3.852214816032570e-04, 3.144749464370408e-03,
    1.458586244466036e-02, 4.625785213424146e-02, 1.100417700576028e-01,
    2.066164379880107e-01, 3.147928014648291e-01, 3.937137487359457e-01,
    4.030686596785491e-01, 3.307677342029942e-01, 2.065581792297196e-01,
    8.666585276148885e-02, 1.671775252943195e-02}},
  {// a = 2
   {1.220416489555879e-01, 2.651167637596821e-01, 3.673181769173702e-01,
    4.162069232856134e-01, 4.111193923157733e-01, 3.620274580356865e-01,
    2.859120823401174e-01, 2.017294682947131e-01, 1.255546582805833e-01,
    6.730381389709168e-02, 2.979900540226315e-02, 1.009427116125995e-02,
    2.232794727575034e-03, 2.102092933512020e-04},
   {5.332154885158092e-03, 2.905988249720480e-02, 7.499376231263508e-02,
    1.340953938539698e-01, 1.885218718051658e-01, 2.200726823124868e-01,
    2.186012826669045e-01, 1.861827100865889e-01, 1.352669120293372e-01,
    8.227667090507361e-02, 4.032641683989160e-02, 1.479157271769134e-02,
    3.471711700989961e-03, 3.403087202360611e-04},
   {5.586064709005593e-04, 5.499532798090235e-03, 2.224031959950351e-02,
    5.654832171301194e-02, 1.055748101407930e-01, 1.555387412347390e-01,
    1.873730013762955e-01, 1.873730013762958e-01, 1.555387412347388e-01,
    1.055748101407924e-01, 5.654832171301170e-02, 2.224031959950363e-02,
    5.499532798090282e-03, 5.586064709005656e-04},
   {9.765465540376725e-05, 1.501166549005689e-03, 8.637420163295084e-03,
    2.922785972294529e-02, 6.908814810661304e-02, 1.239465762335072e-01,
    1.761757163790470e-01, 2.024489568015474e-01, 1.887763460334439e-01,
    1.410830888081298e-01, 8.171734482851201e-02, 3.418487199480662e-02,
    8.853374574732106e-03, 9.281418156773890e-04},
   {2.431288690188338e-05, 5.358029984208312e-04, 4.120999400580611e-03,
    1.772433215611306e-02, 5.122531495852684e-02, 1.089154125117942e-01,
    1.787849820162886e-01, 2.320748308491345e-01, 2.397668405212407e-01,
    1.951394580846807e-01, 1.211678827619336e-01, 5.355397527023554e-02,
    1.445467930873957e-02, 1.558795323029924e-03}},
  {// a = 3
   {2.290461540757796e-01, 4.875112074531002e-01, 6.508470638921978e-01,
    6.984046665688880e-01, 6.414563472313936e-01, 5.149516227368192e-01,
    3.627915647760550e-01, 2.228449471866996e-01, 1.174031767230196e-01,
    5.153000016154856e-02, 1.793630081767578e-02, 4.535933794294162e-03,
    6.992940782808716e-04, 4.172050424740590e-05},
   {9.406730619278396e-03, 4.992893560070189e-02, 1.235445432558051e-01,
    2.083823653344777e-01, 2.715893798478555e-01, 2.884332111068226e-01,
    2.552838807732780e-01, 1.892321595216501e-01, 1.164450220527087e-01,
    5.808025257876499e-02, 2.243366363111491e-02, 6.163825551175200e-03,
    1.012767430464015e-03, 6.326269590322779e-05},
   {9.281418156773890e-04, 8.853374574732106e-03, 3.418487199480662e-02,
    8.171734482851201e-02, 1.410830888081298e-01, 1.887763460334439e-01,
    2.024489568015474e-01, 1.761757163790470e-01, 1.239465762335072e-01,
    6.908814810661304e-02, 2.922785972294529e-02, 8.637420163295084e-03,
    1.501166549005689e-03, 9.765465540376725e-05},
   {1.531264199821700e-04, 2.270365489800732e-03, 1.242758279499570e-02,
    3.942481542267345e-02, 8.599763370516886e-02, 1.399301754013571e-01,
    1.769391579088787e-01, 1.769391579088797e-01, 1.399301754013570e-01,
    8.599763370516889e-02, 3.942481542267379e-02, 1.242758279499558e-02,
    2.270365489800726e-03, 1.531264199821710e-04},
   {3.605040848512942e-05, 7.632313931747922e-04, 5.567043435815090e-03,
    2.239273767352773e-02, 5.961631094357124e-02, 1.148344200669121e-01,
    1.676068890453595e-01, 1.893484779985816e-01, 1.660298118878007e-01,
    1.112668769094685e-01, 5.479020397259165e-02, 1.829532943164775e-02,
    3.494862251538960e-03, 2.434688672395410e-04}},
  {// a = 4
   {4.315022055832897e-01, 9.018798069579228e-01, 1.164961742792316e+00,
    1.191094759828622e+00, 1.025672181668925e+00, 7.587927790172442e-01,
    4.834847111771459e-01, 2.630633931261068e-01, 1.199026280873384e-01,
    4.430069886476670e-02, 1.256281166489784e-02, 2.485900952118036e-03,
    2.846438887262163e-04, 1.173639058512370e-05},
   {1.671775252943195e-02, 8.666585276148885e-02, 2.065581792297196e-01,
    3.307677342029942e-01, 4.030686596785491e-01, 3.937137487359457e-01,
    3.147928014648291e-01, 2.066164379880107e-01, 1.100417700576028e-01,
    4.625785213424146e-02, 1.458586244466036e-02, 3.144749464370408e-03,
    3.852214816032570e-04, 1.671115988738263e-05},
   {1.558795323029924e-03, 1.445467930873957e-02, 5.355397527023554e-02,
    1.211678827619336e-01, 1.951394580846807e-01, 2.397668405212407e-01,
    2.320748308491345e-01, 1.787849820162886e-01, 1.089154125117942e-01,
    5.122531495852684e-02, 1.772433215611306e-02, 4.120999400580611e-03,
    5.358029984208312e-04, 2.431288690188338e-05},
   {2.434688672395410e-04, 3.494862251538960e-03, 1.829532943164775e-02,
    5.479020397259165e-02, 1.112668769094685e-01, 1.660298118878007e-01,
    1.893484779985816e-01, 1.676068890453595e-01, 1.148344200669121e-01,
    5.961631094357124e-02, 2.239273767352773e-02, 5.567043435815090e-03,
    7.632313931747922e-04, 3.605040848512942e-05},
   {5.436270385637171e-05, 1.110219627694651e-03, 7.722246645059216e-03,
    2.925690394797785e-02, 7.239536173538437e-02, 1.277429033427264e-01,
    1.680672083465083e-01, 1.680672083465078e-01, 1.277429033427264e-01,
    7.239536173538448e-02, 2.925690394797775e-02, 7.722246645059281e-03,
    1.110219627694634e-03, 5.436270385637183e-05}}};
static double _gaussJacobiWt_15[5][5][15] = {
  {// a = 0
   {3.075324199611757e-02, 7.036604748810713e-02, 1.071592204671720e-01,
    1.395706779261547e-01, 1.662692058169941e-01, 1.861610000155624e-01,
    1.984314853271120e-01, 2.025782419255613e-01, 1.984314853271113e-01,
    1.861610000155633e-01, 1.662692058169939e-01, 1.395706779261541e-01,
    1.071592204671720e-01, 7.036604748810849e-02, 3.075324199611724e-02},
   {1.361369536551531e-03, 7.944938772580104e-03, 2.286888957888458e-02,
    4.761676142039013e-02, 8.166523709047938e-02, 1.224390783458742e-01,
    1.656029407376909e-01, 2.056494492475466e-01, 2.366967682388525e-01,
    2.533758206460455e-01, 2.516724265943871e-01, 2.295953020277652e-01,
    1.875665597762403e-01, 1.284761794998632e-01, 5.746827848685050e-02},
   {1.450302845560770e-04, 1.551898104511576e-03, 7.092589081872773e-03,
    2.124530388619431e-02, 4.888840088164845e-02, 9.334865987821336e-02,
    1.543473326821964e-01, 2.266124253939308e-01, 2.997910063368096e-01,
    3.599324465649280e-01, 3.923301431552733e-01, 3.850564613482390e-01,
    3.322504612128357e-01, 2.362212060543858e-01, 1.078533018010732e-01},
   {2.585340731604618e-05, 4.378607855880670e-04, 2.881246161389350e-03,
    1.160763344018081e-02, 3.413515901499558e-02, 8.002648876667806e-02,
    1.572570008624858e-01, 2.669941215119746e-01, 3.989282001105054e-01,
    5.297859784496826e-01, 6.268514151355382e-01, 6.563833721915975e-01,
    5.945480330054383e-01, 4.369558233071931e-01, 2.031818138494339e-01},
   {6.577338630276249e-06, 1.617066548368291e-04, 1.437883338565402e-03,
    7.433658353540824e-03, 2.695601717582732e-02, 7.546056362045914e-02,
    1.723819441472571e-01, 3.325139160240520e-01, 5.532046948703171e-01,
    8.034274289207013e-01, 1.022649648177834e+00, 1.134525842127504e+00,
    1.073247356970688e+00, 8.125339613230375e-01, 3.840588009567493e-01}},
  {// a = 1
   {5.746827848685050e-02, 1.284761794998632e-01, 1.875665597762403e-01,
    2.295953020277652e-01, 2.516724265943871e-01, 2.533758206460455e-01,
    2.366967682388525e-01, 2.056494492475466e-01, 1.656029407376909e-01,
    1.224390783458742e-01, 8.166523709047938e-02, 4.761676142039013e-02,
    2.286888957888458e-02, 7.944938772580104e-03, 1.361369536551531e-03},
   {2.381481280370131e-03, 1.348727800770647e-02, 3.700876967991389e-02,
    7.209569246318243e-02, 1.133832831987529e-01, 1.524867201520407e-01,
    1.804925045079649e-01, 1.906618747534698e-01, 1.804925045079654e-01,
    1.524867201520411e-01, 1.133832831987531e-01, 7.209569246318165e-02,
    3.700876967991393e-02, 1.348727800770642e-02, 2.381481280370122e-03},
   {2.380200274799758e-04, 2.457162376870999e-03, 1.065426402280023e-02,
    2.974543346782881e-02, 6.258586116251916e-02, 1.069828834870801e-01,
    1.546300069238103e-01, 1.930634339116912e-01, 2.101876288400313e-01,
    1.994430325754368e-01, 1.631096937049873e-01, 1.119321794891277e-01,
    6.093558148320583e-02, 2.316717283056530e-02, 4.200979029897066e-03},
   {3.989594298513038e-05, 6.485419257040981e-04, 4.032210580019437e-03,
    1.509172541568208e-02, 4.048174155984200e-02, 8.482337899782486e-02,
    1.455790387958571e-01, 2.101625149179988e-01, 2.585749167505400e-01,
    2.717641484363737e-01, 2.417730354393612e-01, 1.775271423023882e-01,
    1.018320141434618e-01, 4.020416618244093e-02, 7.465528609521850e-03},
   {9.564800569512470e-06, 2.246902673979137e-04, 1.881010905989381e-03,
    9.009424597422900e-03, 2.973883046602749e-02, 7.430647278784271e-02,
    1.481537120735755e-01, 2.429913106097891e-01, 3.331096745621285e-01,
    3.833708678793872e-01, 3.676337515813533e-01, 2.867694424478702e-01,
    1.723802709343906e-01, 7.039997426456655e-02, 1.335433515502442e-02}},
  {// a = 2
   {1.078533018010732e-01, 2.362212060543858e-01, 3.322504612128357e-01,
    3.850564613482390e-01, 3.923301431552733e-01, 3.599324465649280e-01,
    2.997910063368096e-01, 2.266124253939308e-01, 1.543473326821964e-01,
    9.334865987821336e-02, 4.888840088164845e-02, 2.124530388619431e-02,
    7.092589081872773e-03, 1.551898104511576e-03, 1.450302845560770e-04},
   {4.200979029897066e-03, 2.316717283056530e-02, 6.093558148320583e-02,
    1.119321794891277e-01, 1.631096937049873e-01, 1.994430325754368e-01,
    2.101876288400313e-01, 1.930634339116912e-01, 1.546300069238103e-01,
    1.069828834870801e-01, 6.258586116251916e-02, 2.974543346782881e-02,
    1.065426402280023e-02, 2.457162376870999e-03, 2.380200274799758e-04},
   {3.954143471301420e-04, 3.953934556033900e-03, 1.636277008696444e-02,
    4.292661168253369e-02, 8.346688866640495e-02, 1.294773718313208e-01,
    1.664368225428811e-01, 1.806270392401284e-01, 1.664368225428809e-01,
    1.294773718313211e-01, 8.346688866640509e-02, 4.292661168253403e-02,
    1.636277008696448e-02, 3.953934556033856e-03, 3.954143471301450e-04},
   {6.254119566947010e-05, 9.802192572269726e-04, 5.794837658762271e-03,
    2.031983282938327e-02, 5.025691543102584e-02, 9.541526248281391e-02,
    1.455101306538528e-01, 1.825492550181576e-01, 1.901778202656092e-01,
    1.640494903571746e-01, 1.152440650674971e-01, 6.357424247420110e-02,
    2.561505601453008e-02, 6.453002679244033e-03, 6.639952815188880e-04},
   {1.417643908543084e-05, 3.197754911068428e-04, 2.537171515594708e-03,
    1.135605645149475e-02, 3.449686520396603e-02, 7.799847056736668e-02,
    1.380901162628800e-01, 1.968003942591436e-01, 2.285497484981823e-01,
    2.161163747057937e-01, 1.639222449468583e-01, 9.628397038686043e-02,
    4.077303017837298e-02, 1.066347790600116e-02, 1.125746234911803e-03}},
  {// a = 3
   {2.031818138494339e-01, 4.369558233071931e-01, 5.945480330054383e-01,
    6.563833721915975e-01, 6.268514151355382e-01, 5.297859784496826e-01,
    3.989282001105054e-01, 2.669941215119746e-01, 1.572570008624858e-01,
    8.002648876667806e-02, 3.413515901499558e-02, 1.160763344018081e-02,
    2.881246161389350e-03, 4.378607855880670e-04, 2.585340731604618e-05},
   {7.465528609521850e-03, 4.020416618244093e-02, 1.018320141434618e-01,
    1.775271423023882e-01, 2.417730354393612e-01, 2.717641484363737e-01,
    2.585749167505400e-01, 2.101625149179988e-01, 1.455790387958571e-01,
    8.482337899782486e-02, 4.048174155984200e-02, 1.509172541568208e-02,
    4.032210580019437e-03, 6.485419257040981e-04, 3.989594298513038e-05},
   {6.639952815188880e-04, 6.453002679244033e-03, 2.561505601453008e-02,
    6.357424247420110e-02, 1.152440650674971e-01, 1.640494903571746e-01,
    1.901778202656092e-01, 1.825492550181576e-01, 1.455101306538528e-01,
    9.541526248281391e-02, 5.025691543102584e-02, 2.031983282938327e-02,
    5.794837658762271e-03, 9.802192572269726e-04, 6.254119566947010e-05},
   {9.941503643760824e-05, 1.508014690540833e-03, 8.522080665722536e-03,
    2.819376328954274e-02, 6.487375121104519e-02, 1.128561049466510e-01,
    1.550768514742840e-01, 1.720257516572654e-01, 1.550768514742839e-01,
    1.128561049466507e-01, 6.487375121104572e-02, 2.819376328954276e-02,
    8.522080665722524e-03, 1.508014690540854e-03, 9.941503643760746e-05},
   {2.136948535903032e-05, 4.647808599472939e-04, 3.514606934469031e-03,
    1.480659425046614e-02, 4.177052276856309e-02, 8.643147469595718e-02,
    1.377808822227968e-01, 1.735940203750788e-01, 1.745073063296745e-01,
    1.393357798854470e-01, 8.660128569035903e-02, 4.015238063907264e-02,
    1.278810166895641e-02, 2.356603322559922e-03, 1.600051570066408e-04}},
  {// a = 4
   {3.840588009567493e-01, 8.125339613230375e-01, 1.073247356970688e+00,
    1.134525842127504e+00, 1.022649648177834e+00, 8.034274289207013e-01,
    5.532046948703171e-01, 3.325139160240520e-01, 1.723819441472571e-01,
    7.546056362045914e-02, 2.695601717582732e-02, 7.433658353540824e-03,
    1.437883338565402e-03, 1.617066548368291e-04, 6.577338630276249e-06},
   {1.335433515502442e-02, 7.039997426456655e-02, 1.723802709343906e-01,
    2.867694424478702e-01, 3.676337515813533e-01, 3.833708678793872e-01,
    3.331096745621285e-01, 2.429913106097891e-01, 1.481537120735755e-01,
    7.430647278784271e-02, 2.973883046602749e-02, 9.009424597422900e-03,
    1.881010905989381e-03, 2.246902673979137e-04, 9.564800569512470e-06},
   {1.125746234911803e-03, 1.066347790600116e-02, 4.077303017837298e-02,
    9.628397038686043e-02, 1.639222449468583e-01, 2.161163747057937e-01,
    2.285497484981823e-01, 1.968003942591436e-01, 1.380901162628800e-01,
    7.799847056736668e-02, 3.449686520396603e-02, 1.135605645149475e-02,
    2.537171515594708e-03, 3.197754911068428e-04, 1.417643908543084e-05},
   {1.600051570066408e-04, 2.356603322559922e-03, 1.278810166895641e-02,
    4.015238063907264e-02, 8.660128569035903e-02, 1.393357798854470e-01,
    1.745073063296745e-01, 1.735940203750788e-01, 1.377808822227968e-01,
    8.643147469595718e-02, 4.177052276856309e-02, 1.480659425046614e-02,
    3.514606934469031e-03, 4.647808599472939e-04, 2.136948535903032e-05},
   {3.270206634932764e-05, 6.882489120970992e-04, 4.983774075775140e-03,
    1.988294796912480e-02, 5.248831687315733e-02, 1.003300875956463e-01,
    1.456699432818424e-01, 1.645463711504280e-01, 1.456699432818425e-01,
    1.003300875956463e-01, 5.248831687315735e-02, 1.988294796912477e-02,
    4.983774075775164e-03, 6.882489120970967e-04, 3.270206634932829e-05}}};
static double _gaussJacobiWt_16[5][5][16] = {
  {// a = 0
   {2.715245941175462e-02, 6.225352393864694e-02, 9.515851168249319e-02,
    1.246289712555337e-01, 1.495959888165765e-01, 1.691565193950026e-01,
    1.826034150449236e-01, 1.894506104550689e-01, 1.894506104550686e-01,
    1.826034150449236e-01, 1.691565193950040e-01, 1.495959888165770e-01,
    1.246289712555335e-01, 9.515851168249274e-02, 6.225352393864816e-02,
    2.715245941175361e-02},
   {1.069974660222133e-03, 6.268753894383217e-03, 1.815692954455441e-02,
    3.813667153866382e-02, 6.615833742254290e-02, 1.006369324258804e-01,
    1.385912663171433e-01, 1.759895287569755e-01, 2.082565513752259e-01,
    2.308755184370723e-01, 2.400034195524547e-01, 2.330169608394235e-01,
    2.089143776158375e-01, 1.685177246297131e-01, 1.144498103605734e-01,
    5.095724262933609e-02},
   {1.022272845575511e-04, 1.100624831804441e-03, 5.075679996550666e-03,
    1.538825540853410e-02, 3.595879081183868e-02, 6.998036396489642e-02,
    1.184302132620137e-01, 1.788574851962384e-01, 2.448963033427010e-01,
    3.067843756094874e-01, 3.529012614071950e-01, 3.720499151789028e-01,
    3.559725877803447e-01, 3.014865974553465e-01, 2.116867401387175e-01,
    9.599524499753551e-02},
   {1.645403553813077e-05, 2.810984663741514e-04, 1.871994950950287e-03,
    7.659488973341010e-03, 2.296383918512497e-02, 5.511761553637654e-02,
    1.114173308007192e-01, 1.956846689333942e-01, 3.045244503288194e-01,
    4.249223695602613e-01, 5.347144569888445e-01, 6.066021950419013e-01,
    6.150504887913217e-01, 5.441179287945612e-01, 3.936061072588884e-01,
    1.814495123535865e-01},
   {3.802981432515828e-06, 9.457232099215046e-05, 8.537009641983972e-04,
    4.498144983852153e-03, 1.669461174469204e-02, 4.805700432818851e-02,
    1.134822881869975e-01, 2.276658705643878e-01, 3.968513160501413e-01,
    6.095544357011915e-01, 8.311227287328088e-01, 1.006869361724458e+00,
    1.075483424598769e+00, 9.894996614284247e-01, 7.352608922220575e-01,
    3.440081834674061e-01}},
  {// a = 1
   {5.095724262933609e-02, 1.144498103605734e-01, 1.685177246297131e-01,
    2.089143776158375e-01, 2.330169608394235e-01, 2.400034195524547e-01,
    2.308755184370723e-01, 2.082565513752259e-01, 1.759895287569755e-01,
    1.385912663171433e-01, 1.006369324258804e-01, 6.615833742254290e-02,
    3.813667153866382e-02, 1.815692954455441e-02, 6.268753894383217e-03,
    1.069974660222133e-03},
   {1.887330784493700e-03, 1.076546289492211e-02, 2.988147148121786e-02,
    5.916001477056534e-02, 9.505028234858227e-02, 1.313788705924051e-01,
    1.609693251940497e-01, 1.775739086004304e-01, 1.775739086004309e-01,
    1.609693251940501e-01, 1.313788705924048e-01, 9.505028234858223e-02,
    5.916001477056535e-02, 2.988147148121778e-02, 1.076546289492213e-02,
    1.887330784493685e-03},
   {1.698025124495790e-04, 1.770386723581758e-03, 7.789441259570089e-03,
    2.218028006185762e-02, 4.786842078109829e-02, 8.447556533337106e-02,
    1.270241564481966e-01, 1.665548894839569e-01, 1.927394176374404e-01,
    1.975899514951430e-01, 1.787303523995938e-01, 1.407322447077076e-01,
    9.376092262241206e-02, 4.991514620138311e-02, 1.867859293367477e-02,
    3.353762731897149e-03},
   {2.578714087921435e-05, 4.246117309935728e-04, 2.687511917009500e-03,
    1.029598800135757e-02, 2.844079742817500e-02, 6.179496814205326e-02,
    1.108719264575604e-01, 1.689921177620562e-01, 2.223098386929797e-01,
    2.540697217750311e-01, 2.517792026852257e-01, 2.137832852465952e-01,
    1.513596728003014e-01, 8.446415338494762e-02, 3.270152672822537e-02,
    5.998890106611426e-03},
   {5.634459894440214e-06, 1.344854147383470e-04, 1.149919705915970e-03,
    5.657890726706088e-03, 1.930803511321534e-02, 5.024082428497778e-02,
    1.052107231881148e-01, 1.831235224275267e-01, 2.699105354464341e-01,
    3.398410737565294e-01, 3.654229722448049e-01, 3.320025624737325e-01,
    2.482721380479175e-01, 1.445495991083272e-01, 5.770987347642392e-02,
    1.079354345807437e-02}},
  {// a = 2
   {9.599524499753551e-02, 2.116867401387175e-01, 3.014865974553465e-01,
    3.559725877803447e-01, 3.720499151789028e-01, 3.529012614071950e-01,
    3.067843756094874e-01, 2.448963033427010e-01, 1.788574851962384e-01,
    1.184302132620137e-01, 6.998036396489642e-02, 3.595879081183868e-02,
    1.538825540853410e-02, 5.075679996550666e-03, 1.100624831804441e-03,
    1.022272845575511e-04},
   {3.353762731897149e-03, 1.867859293367477e-02, 4.991514620138311e-02,
    9.376092262241206e-02, 1.407322447077076e-01, 1.787303523995938e-01,
    1.975899514951430e-01, 1.927394176374404e-01, 1.665548894839569e-01,
    1.270241564481966e-01, 8.447556533337106e-02, 4.786842078109829e-02,
    2.218028006185762e-02, 7.789441259570089e-03, 1.770386723581758e-03,
    1.698025124495790e-04},
   {2.851028111045836e-04, 2.888362384608862e-03, 1.218595250377919e-02,
    3.281371177446366e-02, 6.598717556901483e-02, 1.067925061960959e-01,
    1.447084879899489e-01, 1.676720341043171e-01, 1.676720341043172e-01,
    1.447084879899489e-01, 1.067925061960961e-01, 6.598717556901471e-02,
    3.281371177446393e-02, 1.218595250377930e-02, 2.888362384608850e-03,
    2.851028111045832e-04},
   {4.098202241034733e-05, 6.529039222891601e-04, 3.948680945863501e-03,
    1.426493992620472e-02, 3.663551493758229e-02, 7.288010714004602e-02,
    1.177127346665102e-01, 1.584742824795390e-01, 1.801679222247757e-01,
    1.734582938872888e-01, 1.404128090993128e-01, 9.372756792904854e-02,
    4.964938663070913e-02, 1.938572758402635e-02, 4.771501563692155e-03,
    4.833117073677417e-04},
   {8.490486434111524e-06, 1.953281523148330e-04, 1.590969767457516e-03,
    7.363343945797644e-03, 2.331781850974260e-02, 5.547609273183583e-02,
    1.044924524334554e-01, 1.605871958716448e-01, 2.045897636195508e-01,
    2.171469008161425e-01, 1.909546298420537e-01, 1.366218004277177e-01,
    7.661011465812488e-02, 3.129618082710216e-02, 7.970138959092005e-03,
    8.263979991533265e-04}},
  {// a = 3
   {1.814495123535865e-01, 3.936061072588884e-01, 5.441179287945612e-01,
    6.150504887913217e-01, 6.066021950419013e-01, 5.347144569888445e-01,
    4.249223695602613e-01, 3.045244503288194e-01, 1.956846689333942e-01,
    1.114173308007192e-01, 5.511761553637654e-02, 2.296383918512497e-02,
    7.659488973341010e-03, 1.871994950950287e-03, 2.810984663741514e-04,
    1.645403553813077e-05},
   {5.998890106611426e-03, 3.270152672822537e-02, 8.446415338494762e-02,
    1.513596728003014e-01, 2.137832852465952e-01, 2.517792026852257e-01,
    2.540697217750311e-01, 2.223098386929797e-01, 1.689921177620562e-01,
    1.108719264575604e-01, 6.179496814205326e-02, 2.844079742817500e-02,
    1.029598800135757e-02, 2.687511917009500e-03, 4.246117309935728e-04,
    2.578714087921435e-05},
   {4.833117073677417e-04, 4.771501563692155e-03, 1.938572758402635e-02,
    4.964938663070913e-02, 9.372756792904854e-02, 1.404128090993128e-01,
    1.734582938872888e-01, 1.801679222247757e-01, 1.584742824795390e-01,
    1.177127346665102e-01, 7.288010714004602e-02, 3.663551493758229e-02,
    1.426493992620472e-02, 3.948680945863501e-03, 6.529039222891601e-04,
    4.098202241034733e-05},
   {6.594607515502350e-05, 1.019829862953540e-03, 5.920407682087497e-03,
    2.028924040958996e-02, 4.881461620470607e-02, 8.975304278241378e-02,
    1.320257098490893e-01, 1.592540642768620e-01, 1.592540642768618e-01,
    1.320257098490895e-01, 8.975304278241346e-02, 4.881461620470619e-02,
    2.028924040959005e-02, 5.920407682087568e-03, 1.019829862953536e-03,
    6.594607515502718e-05},
   {1.298916413480863e-05, 2.890544685478188e-04, 2.253540326638734e-03,
    9.871415749385264e-03, 2.923262925357270e-02, 6.419650366769132e-02,
    1.100325101279169e-01, 1.514531497430954e-01, 1.697322409592206e-01,
    1.552077026664362e-01, 1.147351464277535e-01, 6.698174288785233e-02,
    2.952774094946983e-02, 9.036667378732568e-03, 1.615371522285304e-03,
    1.073089929796298e-04}},
  {// a = 4
   {3.440081834674061e-01, 7.352608922220575e-01, 9.894996614284247e-01,
    1.075483424598769e+00, 1.006869361724458e+00, 8.311227287328088e-01,
    6.095544357011915e-01, 3.968513160501413e-01, 2.276658705643878e-01,
    1.134822881869975e-01, 4.805700432818851e-02, 1.669461174469204e-02,
    4.498144983852153e-03, 8.537009641983972e-04, 9.457232099215046e-05,
    3.802981432515828e-06},
   {1.079354345807437e-02, 5.770987347642392e-02, 1.445495991083272e-01,
    2.482721380479175e-01, 3.320025624737325e-01, 3.654229722448049e-01,
    3.398410737565294e-01, 2.699105354464341e-01, 1.831235224275267e-01,
    1.052107231881148e-01, 5.024082428497778e-02, 1.930803511321534e-02,
    5.657890726706088e-03, 1.149919705915970e-03, 1.344854147383470e-04,
    5.634459894440214e-06},
   {8.263979991533265e-04, 7.970138959092005e-03, 3.129618082710216e-02,
    7.661011465812488e-02, 1.366218004277177e-01, 1.909546298420537e-01,
    2.171469008161425e-01, 2.045897636195508e-01, 1.605871958716448e-01,
    1.044924524334554e-01, 5.547609273183583e-02, 2.331781850974260e-02,
    7.363343945797644e-03, 1.590969767457516e-03, 1.953281523148330e-04,
    8.490486434111524e-06},
   {1.073089929796298e-04, 1.615371522285304e-03, 9.036667378732568e-03,
    2.952774094946983e-02, 6.698174288785233e-02, 1.147351464277535e-01,
    1.552077026664362e-01, 1.697322409592206e-01, 1.514531497430954e-01,
    1.100325101279169e-01, 6.419650366769132e-02, 2.923262925357270e-02,
    9.871415749385264e-03, 2.253540326638734e-03, 2.890544685478188e-04,
    1.298916413480863e-05},
   {2.014342068771001e-05, 4.349468538409732e-04, 3.259085486437477e-03,
    1.358290074012528e-02, 3.786126061350023e-02, 7.736410216205108e-02,
    1.218426931452863e-01, 1.519840739272774e-01, 1.519840739272777e-01,
    1.218426931452862e-01, 7.736410216205106e-02, 3.786126061350014e-02,
    1.358290074012529e-02, 3.259085486437511e-03, 4.349468538409689e-04,
    2.014342068770944e-05}}};
static double _gaussJacobiWt_17[5][5][17] = {
  {// a = 0
   {2.414830286854748e-02, 5.545952937398731e-02, 8.503614831717922e-02,
    1.118838471934042e-01, 1.351363684685254e-01, 1.540457610768101e-01,
    1.680041021564505e-01, 1.765627053669921e-01, 1.794464703562071e-01,
    1.765627053669920e-01, 1.680041021564513e-01, 1.540457610768113e-01,
    1.351363684685263e-01, 1.118838471934041e-01, 8.503614831717887e-02,
    5.545952937398716e-02, 2.414830286854753e-02},
   {8.524651568277072e-04, 5.010733757564868e-03, 1.458892193368564e-02,
    3.086568885922368e-02, 5.405478980920327e-02, 8.321311204118144e-02,
    1.162980963508203e-01, 1.503693019484489e-01, 1.819111615965693e-01,
    2.072389677171849e-01, 2.229396716942430e-01, 2.262944455298862e-01,
    2.156317266701110e-01, 1.905674774984742e-01, 1.521029153029695e-01,
    1.025697116808203e-01, 4.549081245278783e-02},
   {7.344643360100710e-05, 7.948522026838238e-04, 3.693392470216972e-03,
    1.131107007164897e-02, 2.677213833455836e-02, 5.293135808289402e-02,
    9.130913790909347e-02, 1.411103146484007e-01, 1.986340488958086e-01,
    2.573085608990289e-01, 3.084419355768195e-01, 3.426032314234782e-01,
    3.513809501807375e-01, 3.291518067765479e-01, 2.744631183653730e-01,
    1.907020961496262e-01, 8.598520824614991e-02},
   {1.072518386566368e-05, 1.845748136500827e-04, 1.241661747105944e-03,
    5.147047016717799e-03, 1.568299803301124e-02, 3.838770877189669e-02,
    7.943907234514626e-02, 1.434568646827850e-01, 2.307394793749237e-01,
    3.349054339255650e-01, 4.420417170175802e-01, 5.321478233319703e-01,
    5.829612491775451e-01, 5.753857970850771e-01, 4.990411553052296e-01,
    3.562103001236256e-01, 1.630163920643000e-01},
   {2.261469412614750e-06, 5.678553100877205e-05, 5.191816769372674e-04,
    2.779782677670493e-03, 1.052067600587753e-02, 3.100088336557466e-02,
    7.525531120080720e-02, 1.559524871316514e-01, 2.823982527589936e-01,
    4.537122510063411e-01, 6.528527480865959e-01, 8.449175462761370e-01,
    9.822496334619499e-01, 1.016352742424321e+00, 9.134366220512035e-01,
    6.680980456421279e-01, 3.098947892333867e-01}},
  {// a = 1
   {4.549081245278783e-02, 1.025697116808203e-01, 1.521029153029695e-01,
    1.905674774984742e-01, 2.156317266701110e-01, 2.262944455298862e-01,
    2.229396716942430e-01, 2.072389677171849e-01, 1.819111615965693e-01,
    1.503693019484489e-01, 1.162980963508203e-01, 8.321311204118144e-02,
    5.405478980920327e-02, 3.086568885922368e-02, 1.458892193368564e-02,
    5.010733757564868e-03, 8.524651568277072e-04},
   {1.514739815459632e-03, 8.692316294131076e-03, 2.436068639363824e-02,
    4.888597833155504e-02, 7.995220547465692e-02, 1.130368323567139e-01,
    1.424624885130020e-01, 1.627604598450957e-01, 1.700019192848272e-01,
    1.627604598450952e-01, 1.424624885130013e-01, 1.130368323567144e-01,
    7.995220547465695e-02, 4.888597833155554e-02, 2.436068639363805e-02,
    8.692316294131038e-03, 1.514739815459635e-03},
   {1.233044634533328e-04, 1.296392811140574e-03, 5.774603058213583e-03,
    1.671747559098046e-02, 3.685209548354167e-02, 6.677766301568872e-02,
    1.037320040118806e-01, 1.415359966428405e-01, 1.719799936538742e-01,
    1.872988928665976e-01, 1.828637284314485e-01, 1.590316882031948e-01,
    1.213448824926961e-01, 7.887150802970438e-02, 4.120817316457946e-02,
    1.521563810625176e-02, 2.709293307248373e-03},
   {1.704155122351367e-05, 2.836791789418342e-04, 1.822811755104407e-03,
    7.121780894954346e-03, 2.016315103614819e-02, 4.515440228850054e-02,
    8.404393997951824e-02, 1.339140400477353e-01, 1.859094690043127e-01,
    2.269615005870788e-01, 2.442284372718092e-01, 2.305539788374319e-01,
    1.882978790989171e-01, 1.293042909913915e-01, 7.050121921816414e-02,
    2.684787285389501e-02, 4.874505404873660e-03},
   {3.406740694092426e-06, 8.242230799538509e-05, 7.175170540563040e-04,
    3.611592575391886e-03, 1.267515200344258e-02, 3.412027839486566e-02,
    7.442351009396078e-02, 1.360137453605255e-01, 2.125809450270678e-01,
    2.874097484686258e-01, 3.374891186887510e-01, 3.430062341880836e-01,
    2.978727394079814e-01, 2.149730401934955e-01, 1.218267835691143e-01,
    4.771039224384056e-02, 8.816707015440529e-03}},
  {// a = 2
   {8.598520824614991e-02, 1.907020961496262e-01, 2.744631183653730e-01,
    3.291518067765479e-01, 3.513809501807375e-01, 3.426032314234782e-01,
    3.084419355768195e-01, 2.573085608990289e-01, 1.986340488958086e-01,
    1.411103146484007e-01, 9.130913790909347e-02, 5.293135808289402e-02,
    2.677213833455836e-02, 1.131107007164897e-02, 3.693392470216972e-03,
    7.948522026838238e-04, 7.344643360100710e-05},
   {2.709293307248373e-03, 1.521563810625176e-02, 4.120817316457946e-02,
    7.887150802970438e-02, 1.213448824926961e-01, 1.590316882031948e-01,
    1.828637284314485e-01, 1.872988928665976e-01, 1.719799936538742e-01,
    1.415359966428405e-01, 1.037320040118806e-01, 6.677766301568872e-02,
    3.685209548354167e-02, 1.671747559098046e-02, 5.774603058213583e-03,
    1.296392811140574e-03, 1.233044634533328e-04},
   {2.090067034827627e-04, 2.141017957655637e-03, 9.181538456807289e-03,
    2.527288528222823e-02, 5.227733398127146e-02, 8.764340394578723e-02,
    1.240430597999046e-01, 1.516117923086600e-01, 1.619065897950735e-01,
    1.516117923086597e-01, 1.240430597999047e-01, 8.764340394578669e-02,
    5.227733398127170e-02, 2.527288528222810e-02, 9.181538456807341e-03,
    2.141017957655655e-03, 2.090067034827575e-04},
   {2.741746351398126e-05, 4.429186278435173e-04, 2.730964161249059e-03,
    1.011754357138828e-02, 2.682070082647672e-02, 5.547954007175986e-02,
    9.397537178712370e-02, 1.340471353459491e-01, 1.635243116845976e-01,
    1.717052876554434e-01, 1.549622335479171e-01, 1.190030993702081e-01,
    7.611527386932622e-02, 3.896656778366746e-02, 1.481557358615418e-02,
    3.575387040721511e-03, 3.573402733269803e-04},
   {5.210369255787608e-06, 1.219003512982789e-04, 1.015320713912196e-03,
    4.834464715692282e-03, 1.585656557912542e-02, 3.937085511771213e-02,
    7.807825098547579e-02, 1.276739708535340e-01, 1.753314519941376e-01,
    2.039595721371063e-01, 2.010239069684333e-01, 1.664126212401902e-01,
    1.133687094883810e-01, 6.112793638187385e-02, 2.422102922342991e-02,
    6.030144692356797e-03, 6.157082357045311e-04}},
  {// a = 3
   {1.630163920643000e-01, 3.562103001236256e-01, 4.990411553052296e-01,
    5.753857970850771e-01, 5.829612491775451e-01, 5.321478233319703e-01,
    4.420417170175802e-01, 3.349054339255650e-01, 2.307394793749237e-01,
    1.434568646827850e-01, 7.943907234514626e-02, 3.838770877189669e-02,
    1.568299803301124e-02, 5.147047016717799e-03, 1.241661747105944e-03,
    1.845748136500827e-04, 1.072518386566368e-05},
   {4.874505404873660e-03, 2.684787285389501e-02, 7.050121921816414e-02,
    1.293042909913915e-01, 1.882978790989171e-01, 2.305539788374319e-01,
    2.442284372718092e-01, 2.269615005870788e-01, 1.859094690043127e-01,
    1.339140400477353e-01, 8.404393997951824e-02, 4.515440228850054e-02,
    2.016315103614819e-02, 7.121780894954346e-03, 1.822811755104407e-03,
    2.836791789418342e-04, 1.704155122351367e-05},
   {3.573402733269803e-04, 3.575387040721511e-03, 1.481557358615418e-02,
    3.896656778366746e-02, 7.611527386932622e-02, 1.190030993702081e-01,
    1.549622335479171e-01, 1.717052876554434e-01, 1.635243116845976e-01,
    1.340471353459491e-01, 9.397537178712370e-02, 5.547954007175986e-02,
    2.682070082647672e-02, 1.011754357138828e-02, 2.730964161249059e-03,
    4.429186278435173e-04, 2.741746351398126e-05},
   {4.460712615943976e-05, 7.013003636904480e-04, 4.165617804861459e-03,
    1.470898188971299e-02, 3.674689770287290e-02, 7.077651083566822e-02,
    1.101810000987092e-01, 1.423843548974512e-01, 1.548671728474618e-01,
    1.423843548974516e-01, 1.101810000987091e-01, 7.077651083566813e-02,
    3.674689770287288e-02, 1.470898188971304e-02, 4.165617804861450e-03,
    7.013003636904514e-04, 4.460712615944224e-05},
   {8.078156583640950e-06, 1.833288272322261e-04, 1.467044310162418e-03,
    6.643131051799167e-03, 2.049793389243312e-02, 4.732591740229600e-02,
    8.617597512125302e-02, 1.275969889954371e-01, 1.562112018380642e-01,
    1.591517437915593e-01, 1.345868931717605e-01, 9.329342759618311e-02,
    5.166702485870460e-02, 2.182338989518186e-02, 6.455906596396846e-03,
    1.124418294497242e-03, 7.331048617018153e-05}},
  {// a = 4
   {3.098947892333867e-01, 6.680980456421279e-01, 9.134366220512035e-01,
    1.016352742424321e+00, 9.822496334619499e-01, 8.449175462761370e-01,
    6.528527480865959e-01, 4.537122510063411e-01, 2.823982527589936e-01,
    1.559524871316514e-01, 7.525531120080720e-02, 3.100088336557466e-02,
    1.052067600587753e-02, 2.779782677670493e-03, 5.191816769372674e-04,
    5.678553100877205e-05, 2.261469412614750e-06},
   {8.816707015440529e-03, 4.771039224384056e-02, 1.218267835691143e-01,
    2.149730401934955e-01, 2.978727394079814e-01, 3.430062341880836e-01,
    3.374891186887510e-01, 2.874097484686258e-01, 2.125809450270678e-01,
    1.360137453605255e-01, 7.442351009396078e-02, 3.412027839486566e-02,
    1.267515200344258e-02, 3.611592575391886e-03, 7.175170540563040e-04,
    8.242230799538509e-05, 3.406740694092426e-06},
   {6.157082357045311e-04, 6.030144692356797e-03, 2.422102922342991e-02,
    6.112793638187385e-02, 1.133687094883810e-01, 1.664126212401902e-01,
    2.010239069684333e-01, 2.039595721371063e-01, 1.753314519941376e-01,
    1.276739708535340e-01, 7.807825098547579e-02, 3.937085511771213e-02,
    1.585656557912542e-02, 4.834464715692282e-03, 1.015320713912196e-03,
    1.219003512982789e-04, 5.210369255787608e-06},
   {7.331048617018153e-05, 1.124418294497242e-03, 6.455906596396846e-03,
    2.182338989518186e-02, 5.166702485870460e-02, 9.329342759618311e-02,
    1.345868931717605e-01, 1.591517437915593e-01, 1.562112018380642e-01,
    1.275969889954371e-01, 8.617597512125302e-02, 4.732591740229600e-02,
    2.049793389243312e-02, 6.643131051799167e-03, 1.467044310162418e-03,
    1.833288272322261e-04, 8.078156583640950e-06},
   {1.267943688429357e-05, 2.798792988735616e-04, 2.159507823450682e-03,
    9.342274356001830e-03, 2.727243969963370e-02, 5.895618575762269e-02,
    9.939377920866957e-02, 1.345962178012885e-01, 1.486724859335633e-01,
    1.345962178012887e-01, 9.939377920866907e-02, 5.895618575762289e-02,
    2.727243969963356e-02, 9.342274356001870e-03, 2.159507823450709e-03,
    2.798792988735582e-04, 1.267943688429400e-05}}};
static double _gaussJacobiWt_18[5][5][18] = {
  {// a = 0
   {2.161601352648338e-02, 4.971454889496964e-02, 7.642573025488929e-02,
    1.009420441062867e-01, 1.225552067114792e-01, 1.406429146706503e-01,
    1.546846751262655e-01, 1.642764837458326e-01, 1.691423829631442e-01,
    1.691423829631429e-01, 1.642764837458318e-01, 1.546846751262635e-01,
    1.406429146706503e-01, 1.225552067114790e-01, 1.009420441062875e-01,
    7.642573025488945e-02, 4.971454889496991e-02, 2.161601352648325e-02},
   {6.874763363928110e-04, 4.052100717204171e-03, 1.184977225773143e-02,
    2.522415552952214e-02, 4.452748038963721e-02, 6.923320192359710e-02,
    9.795036000516714e-02, 1.285392245105141e-01, 1.583166491544315e-01,
    1.843296039609656e-01, 2.036677154254966e-01, 2.137811512112557e-01,
    2.127693385273428e-01, 1.996089076708109e-01, 1.742956282985715e-01,
    1.378844756876899e-01, 9.242540065350746e-02, 4.085735774016225e-02},
   {5.368068899634072e-05, 5.834960693129630e-04, 2.728729629501225e-03,
    8.428402271657531e-03, 2.016577310749002e-02, 4.040199030683767e-02,
    7.081822580075989e-02, 1.115511812291829e-01, 1.606291335709576e-01,
    2.137873949516817e-01, 2.647678096165807e-01, 3.061023573787931e-01,
    3.302693264796611e-01, 3.310174583001593e-01, 3.046010740275800e-01,
    2.506712613738371e-01, 1.726301814335524e-01, 7.745919043012615e-02},
   {7.143047059659526e-06, 1.236979709554158e-04, 8.393136884857152e-04,
    3.517909509275885e-03, 1.086686545597887e-02, 2.704274554020083e-02,
    5.707351931836106e-02, 1.054852772016667e-01, 1.743524688503781e-01,
    2.613202738971239e-01, 3.583325568195404e-01, 4.517347241902343e-01,
    5.240892056307999e-01, 5.575257368344728e-01, 5.379123179479284e-01,
    4.587644597424037e-01, 3.237630567646403e-01, 1.472487275904956e-01},
   {1.379358472387834e-06, 3.492387820617333e-05, 3.228012635247697e-04,
    1.752110766240564e-03, 6.742331822435822e-03, 2.026452402149521e-02,
    5.035088171345147e-02, 1.072160159013254e-01, 2.003842848789916e-01,
    3.340468517487669e-01, 5.019827083103603e-01, 6.842242944023629e-01,
    8.476698268134801e-01, 9.517835944351031e-01, 9.586361961925012e-01,
    8.445483311981076e-01, 6.094355014419863e-01, 2.806034418531839e-01}},
  {// a = 1
   {4.085735774016225e-02, 9.242540065350746e-02, 1.378844756876899e-01,
    1.742956282985715e-01, 1.996089076708109e-01, 2.127693385273428e-01,
    2.137811512112557e-01, 2.036677154254966e-01, 1.843296039609656e-01,
    1.583166491544315e-01, 1.285392245105141e-01, 9.795036000516714e-02,
    6.923320192359710e-02, 4.452748038963721e-02, 2.522415552952214e-02,
    1.184977225773143e-02, 4.052100717204171e-03, 6.874763363928110e-04},
   {1.229581431698275e-03, 7.092065296428100e-03, 2.003881330086018e-02,
    4.067462415626539e-02, 6.752484909660991e-02, 9.728891750906635e-02,
    1.255226249941509e-01, 1.475947503551022e-01, 1.597004405264855e-01,
    1.597004405264850e-01, 1.475947503551025e-01, 1.255226249941507e-01,
    9.728891750906601e-02, 6.752484909660994e-02, 4.067462415626495e-02,
    2.003881330086045e-02, 7.092065296428068e-03, 1.229581431698274e-03},
   {9.098286157647830e-05, 9.634158803041655e-04, 4.336571948371077e-03,
    1.273178786082411e-02, 2.857311891219792e-02, 5.293885672594971e-02,
    8.449607730213654e-02, 1.191430571755908e-01, 1.506517750458153e-01,
    1.722265315616270e-01, 1.785183671601017e-01, 1.674086598707683e-01,
    1.408972238575466e-01, 1.047064397051893e-01, 6.665186226668300e-02,
    3.427417304093411e-02, 1.251227914602443e-02, 2.212153011692748e-03},
   {1.149031268213569e-05, 1.930610326975742e-04, 1.256618860512075e-03,
    4.992380393516446e-03, 1.443254955791392e-02, 3.315555479379857e-02,
    6.363713184991962e-02, 1.052032887042713e-01, 1.526454441285636e-01,
    1.965453123513496e-01, 2.257067133425438e-01, 2.310515549876802e-01,
    2.094284018553430e-01, 1.655309207275169e-01, 1.107644344873579e-01,
    5.921155001315227e-02, 2.223252506518649e-02, 4.001067535993429e-03},
   {2.109107632985097e-06, 5.162402390756201e-05, 4.563660585216808e-04,
    2.342147375753609e-03, 8.418211512379521e-03, 2.332135443300519e-02,
    5.264149614509298e-02, 1.001989938821832e-01, 1.643582058048056e-01,
    2.354279904820576e-01, 2.964699894263590e-01, 3.284848883825424e-01,
    3.184156232276903e-01, 2.661510106586024e-01, 1.863612242329334e-01,
    1.032043344779669e-01, 3.975632546812279e-02, 7.271438633774174e-03}},
  {// a = 2
   {7.745919043012615e-02, 1.726301814335524e-01, 2.506712613738371e-01,
    3.046010740275800e-01, 3.310174583001593e-01, 3.302693264796611e-01,
    3.061023573787931e-01, 2.647678096165807e-01, 2.137873949516817e-01,
    1.606291335709576e-01, 1.115511812291829e-01, 7.081822580075989e-02,
    4.040199030683767e-02, 2.016577310749002e-02, 8.428402271657531e-03,
    2.728729629501225e-03, 5.834960693129630e-04, 5.368068899634072e-05},
   {2.212153011692748e-03, 1.251227914602443e-02, 3.427417304093411e-02,
    6.665186226668300e-02, 1.047064397051893e-01, 1.408972238575466e-01,
    1.674086598707683e-01, 1.785183671601017e-01, 1.722265315616270e-01,
    1.506517750458153e-01, 1.191430571755908e-01, 8.449607730213654e-02,
    5.293885672594971e-02, 2.857311891219792e-02, 1.273178786082411e-02,
    4.336571948371077e-03, 9.634158803041655e-04, 9.098286157647830e-05},
   {1.555411177967525e-04, 1.608493070349398e-03, 6.994604383611504e-03,
    1.961654758676466e-02, 4.155892803186271e-02, 7.177662245875577e-02,
    1.053530580641081e-01, 1.345948346801263e-01, 1.516747039399580e-01,
    1.516747039399586e-01, 1.345948346801259e-01, 1.053530580641087e-01,
    7.177662245875543e-02, 4.155892803186259e-02, 1.961654758676483e-02,
    6.994604383611529e-03, 1.608493070349451e-03, 1.555411177967647e-04},
   {1.869155856882047e-05, 3.055807690569521e-04, 1.915583989637664e-03,
    7.251025645696982e-03, 1.974665671556773e-02, 4.221746248438694e-02,
    7.442585616039420e-02, 1.113920199185810e-01, 1.439907618691804e-01,
    1.621874923914561e-01, 1.595306664007640e-01, 1.364361306942730e-01,
    1.002424802875679e-01, 6.184176158360809e-02, 3.075363614936213e-02,
    1.143059196857848e-02, 2.712286246365422e-03, 2.679818336219699e-04},
   {3.269223337105815e-06, 7.760122479817879e-05, 6.588681960960293e-04,
    3.214414493445375e-03, 1.086335577339085e-02, 2.796797242286062e-02,
    5.792477037326835e-02, 9.975438564992598e-02, 1.457384085664732e-01,
    1.826410146562621e-01, 1.970994660526998e-01, 1.826111949895710e-01,
    1.436673775925216e-01, 9.388752927841161e-02, 4.895950685402934e-02,
    1.889904031163007e-02, 4.614476050999984e-03, 4.649673378976005e-04}},
  {// a = 3
   {1.472487275904956e-01, 3.237630567646403e-01, 4.587644597424037e-01,
    5.379123179479284e-01, 5.575257368344728e-01, 5.240892056307999e-01,
    4.517347241902343e-01, 3.583325568195404e-01, 2.613202738971239e-01,
    1.743524688503781e-01, 1.054852772016667e-01, 5.707351931836106e-02,
    2.704274554020083e-02, 1.086686545597887e-02, 3.517909509275885e-03,
    8.393136884857152e-04, 1.236979709554158e-04, 7.143047059659526e-06},
   {4.001067535993429e-03, 2.223252506518649e-02, 5.921155001315227e-02,
    1.107644344873579e-01, 1.655309207275169e-01, 2.094284018553430e-01,
    2.310515549876802e-01, 2.257067133425438e-01, 1.965453123513496e-01,
    1.526454441285636e-01, 1.052032887042713e-01, 6.363713184991962e-02,
    3.315555479379857e-02, 1.443254955791392e-02, 4.992380393516446e-03,
    1.256618860512075e-03, 1.930610326975742e-04, 1.149031268213569e-05},
   {2.679818336219699e-04, 2.712286246365422e-03, 1.143059196857848e-02,
    3.075363614936213e-02, 6.184176158360809e-02, 1.002424802875679e-01,
    1.364361306942730e-01, 1.595306664007640e-01, 1.621874923914561e-01,
    1.439907618691804e-01, 1.113920199185810e-01, 7.442585616039420e-02,
    4.221746248438694e-02, 1.974665671556773e-02, 7.251025645696982e-03,
    1.915583989637664e-03, 3.055807690569521e-04, 1.869155856882047e-05},
   {3.071494273034652e-05, 4.897953879208422e-04, 2.967141212515172e-03,
    1.074889875869436e-02, 2.772988023715186e-02, 5.555498276083879e-02,
    9.071239675106800e-02, 1.241647024269679e-01, 1.447443446649699e-01,
    1.447443446649698e-01, 1.241647024269679e-01, 9.071239675106800e-02,
    5.555498276083873e-02, 2.772988023715190e-02, 1.074889875869443e-02,
    2.967141212515153e-03, 4.897953879208445e-04, 3.071494273034725e-05},
   {5.130302491305114e-06, 1.184181551834821e-04, 9.691435945273369e-04,
    4.515401925262028e-03, 1.443102107494373e-02, 3.476818380495148e-02,
    6.662943462436244e-02, 1.048715433584174e-01, 1.381327265381891e-01,
    1.536959594348183e-01, 1.447084631974914e-01, 1.146159805453939e-01,
    7.524706156544342e-02, 3.984473529379105e-02, 1.622557930340822e-02,
    4.662006566972243e-03, 7.939877179254163e-04, 5.093728214026404e-05}},
  {// a = 4
   {2.806034418531839e-01, 6.094355014419863e-01, 8.445483311981076e-01,
    9.586361961925012e-01, 9.517835944351031e-01, 8.476698268134801e-01,
    6.842242944023629e-01, 5.019827083103603e-01, 3.340468517487669e-01,
    2.003842848789916e-01, 1.072160159013254e-01, 5.035088171345147e-02,
    2.026452402149521e-02, 6.742331822435822e-03, 1.752110766240564e-03,
    3.228012635247697e-04, 3.492387820617333e-05, 1.379358472387834e-06},
   {7.271438633774174e-03, 3.975632546812279e-02, 1.032043344779669e-01,
    1.863612242329334e-01, 2.661510106586024e-01, 3.184156232276903e-01,
    3.284848883825424e-01, 2.964699894263590e-01, 2.354279904820576e-01,
    1.643582058048056e-01, 1.001989938821832e-01, 5.264149614509298e-02,
    2.332135443300519e-02, 8.418211512379521e-03, 2.342147375753609e-03,
    4.563660585216808e-04, 5.162402390756201e-05, 2.109107632985097e-06},
   {4.649673378976005e-04, 4.614476050999984e-03, 1.889904031163007e-02,
    4.895950685402934e-02, 9.388752927841161e-02, 1.436673775925216e-01,
    1.826111949895710e-01, 1.970994660526998e-01, 1.826410146562621e-01,
    1.457384085664732e-01, 9.975438564992598e-02, 5.792477037326835e-02,
    2.796797242286062e-02, 1.086335577339085e-02, 3.214414493445375e-03,
    6.588681960960293e-04, 7.760122479817879e-05, 3.269223337105815e-06},
   {5.093728214026404e-05, 7.939877179254163e-04, 4.662006566972243e-03,
    1.622557930340822e-02, 3.984473529379105e-02, 7.524706156544342e-02,
    1.146159805453939e-01, 1.447084631974914e-01, 1.536959594348183e-01,
    1.381327265381891e-01, 1.048715433584174e-01, 6.662943462436244e-02,
    3.476818380495148e-02, 1.443102107494373e-02, 4.515401925262028e-03,
    9.691435945273369e-04, 1.184181551834821e-04, 5.130302491305114e-06},
   {8.141436240381040e-06, 1.831710948151471e-04, 1.449550604695897e-03,
    6.475639422004388e-03, 1.966820356071560e-02, 4.461036393740649e-02,
    7.967416056529358e-02, 1.155983644015973e-01, 1.386816113264379e-01,
    1.386816113264371e-01, 1.155983644015979e-01, 7.967416056529328e-02,
    4.461036393740658e-02, 1.966820356071560e-02, 6.475639422004406e-03,
    1.449550604695908e-03, 1.831710948151466e-04, 8.141436240380612e-06}}};
static double _gaussJacobiWt_19[5][5][19] = {
  {// a = 0
   {1.946178822972679e-02, 4.481422676569998e-02, 6.904454273764080e-02,
    9.149002162244989e-02, 1.115666455473345e-01, 1.287539625393360e-01,
    1.426067021736069e-01, 1.527660420658599e-01, 1.589688433939547e-01,
    1.610544498487829e-01, 1.589688433939543e-01, 1.527660420658588e-01,
    1.426067021736070e-01, 1.287539625393369e-01, 1.115666455473330e-01,
    9.149002162245089e-02, 6.904454273764137e-02, 4.481422676569920e-02,
    1.946178822972615e-02},
   {5.605103767134955e-04, 3.311523043695969e-03, 9.720366848173149e-03,
    2.079912531311367e-02, 3.696436771726646e-02, 5.795938844843888e-02,
    8.284669025103120e-02, 1.100722325773918e-01, 1.375958318076299e-01,
    1.630754834873472e-01, 1.840879428645532e-01, 1.983641858748268e-01,
    2.040167465068774e-01, 1.997365529616778e-01, 1.849397126743136e-01,
    1.598494801959666e-01, 1.255051011429315e-01, 8.369860700791859e-02,
    3.689615090013360e-02},
   {3.984561865575305e-05, 4.347411450560393e-04, 2.044246871127711e-03,
    6.360354603588442e-03, 1.535830778153859e-02, 3.111827850042484e-02,
    5.528648862345732e-02, 8.849152503229592e-02, 1.298545225759704e-01,
    1.767245051985921e-01, 2.247328634888243e-01, 2.682005445648802e-01,
    3.008600041627805e-01, 3.167859857190464e-01, 3.113790897780943e-01,
    2.822249375958077e-01, 2.296651982296304e-01, 1.569668507218607e-01,
    7.013837645503440e-02},
   {4.850900010806030e-06, 8.445609644738916e-05, 5.772901537617500e-04,
    2.442703009312268e-03, 7.634373255300905e-03, 1.926809079186000e-02,
    4.134933417543026e-02, 7.793303492969085e-02, 1.317865475900290e-01,
    2.028527195722385e-01, 2.869781892238947e-01, 3.754076925412700e-01,
    4.554122600049595e-01, 5.121377461676451e-01, 5.314043607306927e-01,
    5.028652272171822e-01, 4.227498364192864e-01, 2.954537193248141e-01,
    1.336575678961767e-01},
   {8.609342341304727e-07, 2.195418015541902e-05, 2.048345089081777e-04,
    1.124941845934449e-03, 4.391025905286927e-03, 1.342274300690410e-02,
    3.401889768337303e-02, 7.412588019454035e-02, 1.422769443598799e-01,
    2.445935573098928e-01, 3.809318142807546e-01, 5.414453253908550e-01,
    7.051636855722944e-01, 8.418828934590468e-01, 9.177058730817034e-01,
    9.032372560675493e-01, 7.822309986938917e-01, 5.579521398605582e-01,
    2.552683736642419e-01}},
  {// a = 1
   {3.689615090013360e-02, 8.369860700791859e-02, 1.255051011429315e-01,
    1.598494801959666e-01, 1.849397126743136e-01, 1.997365529616778e-01,
    2.040167465068774e-01, 1.983641858748268e-01, 1.840879428645532e-01,
    1.630754834873472e-01, 1.375958318076299e-01, 1.100722325773918e-01,
    8.284669025103120e-02, 5.795938844843888e-02, 3.696436771726646e-02,
    2.079912531311367e-02, 9.720366848173149e-03, 3.311523043695969e-03,
    5.605103767134955e-04},
   {1.008385312706966e-03, 5.841722290372158e-03, 1.662150932996668e-02,
    3.406810256913539e-02, 5.728024975687648e-02, 8.385841043825301e-02,
    1.103463166152258e-01, 1.329003715750341e-01, 1.480490036130086e-01,
    1.533851903321753e-01, 1.480490036130075e-01, 1.329003715750345e-01,
    1.103463166152252e-01, 8.385841043825290e-02, 5.728024975687628e-02,
    3.406810256913543e-02, 1.662150932996680e-02, 5.841722290372092e-03,
    1.008385312706957e-03},
   {6.811355527608095e-05, 7.256847086317543e-04, 3.295949977701830e-03,
    9.793481062327353e-03, 2.231699982913302e-02, 4.213487754444793e-02,
    6.880889694350813e-02, 9.973189523592281e-02, 1.303406870631796e-01,
    1.550416782880165e-01, 1.686291604730529e-01, 1.677772931837769e-01,
    1.521211910662728e-01, 1.245411430075938e-01, 9.050115647374285e-02,
    5.659385384743003e-02, 2.870867865279573e-02, 1.037880759954857e-02,
    1.823784820975372e-03},
   {7.890029264832080e-06, 1.336371906453365e-04, 8.795281626705755e-04,
    3.544724777971203e-03, 1.043213257085324e-02, 2.449159290065994e-02,
    4.824786095713658e-02, 8.227192747526953e-02, 1.238465975721789e-01,
    1.666064240400921e-01, 2.016599152004384e-01, 2.200916949750041e-01,
    2.160520342090567e-01, 1.892108191920295e-01, 1.454364820381162e-01,
    9.518622519644325e-02, 5.002844810375543e-02, 1.855766005372870e-02,
    3.314405354687945e-03},
   {1.334218092243121e-06, 3.298705701827740e-05, 2.955047853687727e-04,
    1.542148806636644e-03, 5.657369326440370e-03, 1.606234902208807e-02,
    3.732754593228763e-02, 7.353175485492856e-02, 1.255914199301243e-01,
    1.886975631725893e-01, 2.515279400573580e-01, 2.984983991244974e-01,
    3.149282373208025e-01, 2.932415394641560e-01, 2.372371552516054e-01,
    1.618627408070737e-01, 8.787493382556881e-02, 3.337272048401561e-02,
    6.049689892682875e-03}},
  {// a = 2
   {7.013837645503440e-02, 1.569668507218607e-01, 2.296651982296304e-01,
    2.822249375958077e-01, 3.113790897780943e-01, 3.167859857190464e-01,
    3.008600041627805e-01, 2.682005445648802e-01, 2.247328634888243e-01,
    1.767245051985921e-01, 1.298545225759704e-01, 8.849152503229592e-02,
    5.528648862345732e-02, 3.111827850042484e-02, 1.535830778153859e-02,
    6.360354603588442e-03, 2.044246871127711e-03, 4.347411450560393e-04,
    3.984561865575305e-05},
   {1.823784820975372e-03, 1.037880759954857e-02, 2.870867865279573e-02,
    5.659385384743003e-02, 9.050115647374285e-02, 1.245411430075938e-01,
    1.521211910662728e-01, 1.677772931837769e-01, 1.686291604730529e-01,
    1.550416782880165e-01, 1.303406870631796e-01, 9.973189523592281e-02,
    6.880889694350813e-02, 4.213487754444793e-02, 2.231699982913302e-02,
    9.793481062327353e-03, 3.295949977701830e-03, 7.256847086317543e-04,
    6.811355527608095e-05},
   {1.173448388110257e-04, 1.223444566638098e-03, 5.384347319761795e-03,
    1.534480330909799e-02, 3.318049432584984e-02, 5.877516556322710e-02,
    8.896868783349395e-02, 1.179664493379611e-01, 1.390144617318000e-01,
    1.467162690133844e-01, 1.390144617317998e-01, 1.179664493379615e-01,
    8.896868783349424e-02, 5.877516556322719e-02, 3.318049432585000e-02,
    1.534480330909794e-02, 5.384347319761749e-03, 1.223444566638114e-03,
    1.173448388110220e-04},
   {1.296374690332938e-05, 2.141377622987574e-04, 1.361656309718859e-03,
    5.250543995687603e-03, 1.463299593637842e-02, 3.217901779481117e-02,
    5.868590141665852e-02, 9.146679112075290e-02, 1.240901788987191e-01,
    1.480952280899640e-01, 1.561968086406756e-01, 1.454856696779677e-01,
    1.189118019818240e-01, 8.414703822663099e-02, 5.033564678419491e-02,
    2.441608503811752e-02, 8.899487024796105e-03, 2.081125384831356e-03,
    2.035888357357768e-04},
   {2.093360509041031e-06, 5.031761095882681e-05, 4.343704191148428e-04,
    2.164095980749780e-03, 7.504498911413320e-03, 1.992920065532674e-02,
    4.282940652330748e-02, 7.705933482169039e-02, 1.185716060673332e-01,
    1.580365585437519e-01, 1.836117844872129e-01, 1.860740774055974e-01,
    1.636132101405143e-01, 1.232597302543858e-01, 7.773274682926593e-02,
    3.938604033343654e-02, 1.486434065063976e-02, 3.568715316312661e-03,
    3.554907360980722e-04}},
  {// a = 3
   {1.336575678961767e-01, 2.954537193248141e-01, 4.227498364192864e-01,
    5.028652272171822e-01, 5.314043607306927e-01, 5.121377461676451e-01,
    4.554122600049595e-01, 3.754076925412700e-01, 2.869781892238947e-01,
    2.028527195722385e-01, 1.317865475900290e-01, 7.793303492969085e-02,
    4.134933417543026e-02, 1.926809079186000e-02, 7.634373255300905e-03,
    2.442703009312268e-03, 5.772901537617500e-04, 8.445609644738916e-05,
    4.850900010806030e-06},
   {3.314405354687945e-03, 1.855766005372870e-02, 5.002844810375543e-02,
    9.518622519644325e-02, 1.454364820381162e-01, 1.892108191920295e-01,
    2.160520342090567e-01, 2.200916949750041e-01, 2.016599152004384e-01,
    1.666064240400921e-01, 1.238465975721789e-01, 8.227192747526953e-02,
    4.824786095713658e-02, 2.449159290065994e-02, 1.043213257085324e-02,
    3.544724777971203e-03, 8.795281626705755e-04, 1.336371906453365e-04,
    7.890029264832080e-06},
   {2.035888357357768e-04, 2.081125384831356e-03, 8.899487024796105e-03,
    2.441608503811752e-02, 5.033564678419491e-02, 8.414703822663099e-02,
    1.189118019818240e-01, 1.454856696779677e-01, 1.561968086406756e-01,
    1.480952280899640e-01, 1.240901788987191e-01, 9.146679112075290e-02,
    5.868590141665852e-02, 3.217901779481117e-02, 1.463299593637842e-02,
    5.250543995687603e-03, 1.361656309718859e-03, 2.141377622987574e-04,
    1.296374690332938e-05},
   {2.149655149432985e-05, 3.470406137227695e-04, 2.138467175357608e-03,
    7.920083289565880e-03, 2.100439685600973e-02, 4.352450780386551e-02,
    7.401554617101007e-02, 1.063558591688529e-01, 1.313916503865534e-01,
    1.408476182528491e-01, 1.313916503865534e-01, 1.063558591688531e-01,
    7.401554617101044e-02, 4.352450780386571e-02, 2.100439685600972e-02,
    7.920083289565876e-03, 2.138467175357619e-03, 3.470406137227704e-04,
    2.149655149433083e-05},
   {3.321450074956702e-06, 7.780370502869147e-05, 6.492883283212298e-04,
    3.100695450147653e-03, 1.021464267133030e-02, 2.552629379880667e-02,
    5.109991482279012e-02, 8.470337520014772e-02, 1.186345344062564e-01,
    1.420108030482593e-01, 1.459617739757232e-01, 1.286146280844985e-01,
    9.636825757527101e-02, 6.039827807990202e-02, 3.077351632643268e-02,
    1.214252394050649e-02, 3.401896897666733e-03, 5.682215167242046e-04,
    3.594500782696828e-05}},
  {// a = 4
   {2.552683736642419e-01, 5.579521398605582e-01, 7.822309986938917e-01,
    9.032372560675493e-01, 9.177058730817034e-01, 8.418828934590468e-01,
    7.051636855722944e-01, 5.414453253908550e-01, 3.809318142807546e-01,
    2.445935573098928e-01, 1.422769443598799e-01, 7.412588019454035e-02,
    3.401889768337303e-02, 1.342274300690410e-02, 4.391025905286927e-03,
    1.124941845934449e-03, 2.048345089081777e-04, 2.195418015541902e-05,
    8.609342341304727e-07},
   {6.049689892682875e-03, 3.337272048401561e-02, 8.787493382556881e-02,
    1.618627408070737e-01, 2.372371552516054e-01, 2.932415394641560e-01,
    3.149282373208025e-01, 2.984983991244974e-01, 2.515279400573580e-01,
    1.886975631725893e-01, 1.255914199301243e-01, 7.353175485492856e-02,
    3.732754593228763e-02, 1.606234902208807e-02, 5.657369326440370e-03,
    1.542148806636644e-03, 2.955047853687727e-04, 3.298705701827740e-05,
    1.334218092243121e-06},
   {3.554907360980722e-04, 3.568715316312661e-03, 1.486434065063976e-02,
    3.938604033343654e-02, 7.773274682926593e-02, 1.232597302543858e-01,
    1.636132101405143e-01, 1.860740774055974e-01, 1.836117844872129e-01,
    1.580365585437519e-01, 1.185716060673332e-01, 7.705933482169039e-02,
    4.282940652330748e-02, 1.992920065532674e-02, 7.504498911413320e-03,
    2.164095980749780e-03, 4.343704191148428e-04, 5.031761095882681e-05,
    2.093360509041031e-06},
   {3.594500782696828e-05, 5.682215167242046e-04, 3.401896897666733e-03,
    1.214252394050649e-02, 3.077351632643268e-02, 6.039827807990202e-02,
    9.636825757527101e-02, 1.286146280844985e-01, 1.459617739757232e-01,
    1.420108030482593e-01, 1.186345344062564e-01, 8.470337520014772e-02,
    5.109991482279012e-02, 2.552629379880667e-02, 1.021464267133030e-02,
    3.100695450147653e-03, 6.492883283212298e-04, 7.780370502869147e-05,
    3.321450074956702e-06},
   {5.324137185742938e-06, 1.217946961597439e-04, 9.853009259019165e-04,
    4.526097064741301e-03, 1.422614507855207e-02, 3.362941349642161e-02,
    6.310203771805291e-02, 9.708176030106656e-02, 1.248558130316049e-01,
    1.356310397990403e-01, 1.248558130316052e-01, 9.708176030106599e-02,
    6.310203771805288e-02, 3.362941349642171e-02, 1.422614507855212e-02,
    4.526097064741306e-03, 9.853009259019106e-04, 1.217946961597426e-04,
    5.324137185743394e-06}}};
static double _gaussJacobiWt_20[5][5][20] = {
  {// a = 0
   {1.761400713915242e-02, 4.060142980038731e-02, 6.267204833410815e-02,
    8.327674157670452e-02, 1.019301198172405e-01, 1.181945319615191e-01,
    1.316886384491763e-01, 1.420961093183825e-01, 1.491729864726036e-01,
    1.527533871307256e-01, 1.527533871307259e-01, 1.491729864726023e-01,
    1.420961093183812e-01, 1.316886384491764e-01, 1.181945319615192e-01,
    1.019301198172412e-01, 8.327674157670538e-02, 6.267204833410936e-02,
    4.060142980038590e-02, 1.761400713915169e-02},
   {4.615276287027270e-04, 2.732249104343666e-03, 8.045830455856230e-03,
    1.729287645076072e-02, 3.091067172020609e-02, 4.881618450672030e-02,
    7.038826751682419e-02, 9.450118469419572e-02, 1.196069673705157e-01,
    1.438596766154505e-01, 1.652708272666635e-01, 1.818823557654130e-01,
    1.919418464397755e-01, 1.940644202394171e-01, 1.873667674502307e-01,
    1.715611833519132e-01, 1.470009593465910e-01, 1.146729495165212e-01,
    7.613987785480811e-02, 3.348337670509027e-02},
   {2.999376794669490e-05, 3.283128166985746e-04, 1.551106476940114e-03,
    4.856365634138007e-03, 1.181955553577188e-02, 2.417991336725892e-02,
    4.345672644898421e-02, 7.050844862594696e-02, 1.051273540532928e-01,
    1.457640273461495e-01, 1.894583233139678e-01, 2.320192379647163e-01,
    2.684514516278038e-01, 2.935793637761428e-01, 3.027791230153783e-01,
    2.927033324258168e-01, 2.618771545405842e-01, 2.110605154330050e-01,
    1.433100186059095e-01, 6.380634189021206e-02},
   {3.353157815245817e-06, 5.865150039219185e-05, 4.034690749605404e-04,
    1.721235152696699e-03, 5.434032377411945e-03, 1.388178212294715e-02,
    3.021900147777163e-02, 5.791305909034001e-02, 9.984562193439421e-02,
    1.571689542619357e-01, 2.282016241857572e-01, 3.077139757869390e-01,
    3.869187976499687e-01, 4.543425677646190e-01, 4.975364730140931e-01,
    5.053500939332114e-01, 4.703018887241133e-01, 3.904992299906391e-01,
    2.706253022010680e-01, 1.218608865989266e-01},
   {5.487666144509803e-07, 1.408082045731623e-05, 1.324482317181066e-04,
    7.348351356219093e-04, 2.903844678093574e-03, 9.007089025276100e-03,
    2.321995573202859e-02, 5.160210830764782e-02, 1.013151319675854e-01,
    1.787658575111919e-01, 2.868682492789557e-01, 4.221084777884259e-01,
    5.724638958602063e-01, 7.172611206902804e-01, 8.296570542443914e-01,
    8.816546739615281e-01, 8.506582511915869e-01, 7.258617735691842e-01,
    5.125612778000509e-01, 2.332093254391667e-01}},
  {// a = 1
   {3.348337670509027e-02, 7.613987785480811e-02, 1.146729495165212e-01,
    1.470009593465910e-01, 1.715611833519132e-01, 1.873667674502307e-01,
    1.940644202394171e-01, 1.919418464397755e-01, 1.818823557654130e-01,
    1.652708272666635e-01, 1.438596766154505e-01, 1.196069673705157e-01,
    9.450118469419572e-02, 7.038826751682419e-02, 4.881618450672030e-02,
    3.091067172020609e-02, 1.729287645076072e-02, 8.045830455856230e-03,
    2.732249104343666e-03, 4.615276287027270e-04},
   {8.347039028800767e-04, 4.853837985129194e-03, 1.389394537278705e-02,
    2.871680139970984e-02, 4.881143733193006e-02, 7.244187855657948e-02,
    9.693142868622774e-02, 1.191306500788975e-01, 1.359813551393849e-01,
    1.450706282131411e-01, 1.450706282131418e-01, 1.359813551393853e-01,
    1.191306500788962e-01, 9.693142868622770e-02, 7.244187855657933e-02,
    4.881143733193033e-02, 2.871680139970995e-02, 1.389394537278698e-02,
    4.853837985129205e-03, 8.347039028800518e-04},
   {5.166952892188504e-05, 5.534155648984280e-04, 2.533111849839604e-03,
    7.605135695448976e-03, 1.755930125382356e-02, 3.369212673625989e-02,
    5.610557668795496e-02, 8.323880983967474e-02, 1.118469222205676e-01,
    1.375099136203495e-01, 1.555850094352541e-01, 1.623606827860373e-01,
    1.560831512615479e-01, 1.375379398711523e-01, 1.099817259095764e-01,
    7.840239268122247e-02, 4.828401025360043e-02, 2.420748025005280e-02,
    8.678070962343857e-03, 1.516886924807432e-03},
   {5.508816805110130e-06, 9.395785146685461e-05, 6.243491188529550e-04,
    2.547695718598530e-03, 7.614249225118673e-03, 1.821276452255625e-02,
    3.668674985122761e-02, 6.422806943997313e-02, 9.973365570521556e-02,
    1.391716330269610e-01, 1.759232352855731e-01, 2.022362018391584e-01,
    2.114582928769587e-01, 2.003145395556726e-01, 1.703452071881208e-01,
    1.278345091835762e-01, 8.208265565431398e-02, 4.251330311793730e-02,
    1.560475718403892e-02, 2.768664837876082e-03},
   {8.608565193967390e-07, 2.147068799231026e-05, 1.945685263756131e-04,
    1.030224401391309e-03, 3.846832631931801e-03, 1.115544541050236e-02,
    2.658027343122925e-02, 5.391728248057852e-02, 9.529842117037533e-02,
    1.490373520401883e-01, 2.082485745245979e-01, 2.613605315772212e-01,
    2.949905454247750e-01, 2.985079493675207e-01, 2.685308164679017e-01,
    2.112205458232889e-01, 1.409153963594707e-01, 7.519614627891190e-02,
    2.820646294534146e-02, 5.073632927221474e-03}},
  {// a = 2
   {6.380634189021206e-02, 1.433100186059095e-01, 2.110605154330050e-01,
    2.618771545405842e-01, 2.927033324258168e-01, 3.027791230153783e-01,
    2.935793637761428e-01, 2.684514516278038e-01, 2.320192379647163e-01,
    1.894583233139678e-01, 1.457640273461495e-01, 1.051273540532928e-01,
    7.050844862594696e-02, 4.345672644898421e-02, 2.417991336725892e-02,
    1.181955553577188e-02, 4.856365634138007e-03, 1.551106476940114e-03,
    3.283128166985746e-04, 2.999376794669490e-05},
   {1.516886924807432e-03, 8.678070962343857e-03, 2.420748025005280e-02,
    4.828401025360043e-02, 7.840239268122247e-02, 1.099817259095764e-01,
    1.375379398711523e-01, 1.560831512615479e-01, 1.623606827860373e-01,
    1.555850094352541e-01, 1.375099136203495e-01, 1.118469222205676e-01,
    8.323880983967474e-02, 5.610557668795496e-02, 3.369212673625989e-02,
    1.755930125382356e-02, 7.605135695448976e-03, 2.533111849839604e-03,
    5.534155648984280e-04, 5.166952892188504e-05},
   {8.963958416222125e-05, 9.412369504911721e-04, 4.185615578021692e-03,
    1.209524875975838e-02, 2.661909394666631e-02, 4.818878307902000e-02,
    7.489000421795822e-02, 1.024830210115733e-01, 1.254035709001833e-01,
    1.384371193054993e-01, 1.384371193054984e-01, 1.254035709001829e-01,
    1.024830210115731e-01, 7.489000421795759e-02, 4.818878307902041e-02,
    2.661909394666614e-02, 1.209524875975835e-02, 4.185615578021638e-03,
    9.412369504911824e-04, 8.963958416221792e-05},
   {9.133832615751404e-06, 1.522361906087519e-04, 9.801218872845627e-04,
    3.840500991388080e-03, 1.091925932887307e-02, 2.460232879228123e-02,
    4.619153795651842e-02, 7.452202443118797e-02, 1.053180157386830e-01,
    1.319249233685375e-01, 1.473969196516950e-01, 1.471402483256259e-01,
    1.308785801698183e-01, 1.029222538345098e-01, 7.052518894561741e-02,
    4.108130098921402e-02, 1.950262382709381e-02, 6.989146872193697e-03,
    1.613808116970697e-03, 1.565134159496541e-04},
   {1.365672609013792e-06, 3.318802446839218e-05, 2.906728319505188e-04,
    1.474835082245556e-03, 5.229769717038873e-03, 1.426541485584200e-02,
    3.164685708156192e-02, 5.910982645477970e-02, 9.503926627878106e-02,
    1.333954952735661e-01, 1.647626611402603e-01, 1.796362585016358e-01,
    1.725966082984333e-01, 1.451318036180439e-01, 1.053370296604169e-01,
    6.441753335893181e-02, 3.183553435649934e-02, 1.178131560140924e-02,
    2.787299050841663e-03, 2.748841883042782e-04}},
  {// a = 3
   {1.218608865989266e-01, 2.706253022010680e-01, 3.904992299906391e-01,
    4.703018887241133e-01, 5.053500939332114e-01, 4.975364730140931e-01,
    4.543425677646190e-01, 3.869187976499687e-01, 3.077139757869390e-01,
    2.282016241857572e-01, 1.571689542619357e-01, 9.984562193439421e-02,
    5.791305909034001e-02, 3.021900147777163e-02, 1.388178212294715e-02,
    5.434032377411945e-03, 1.721235152696699e-03, 4.034690749605404e-04,
    5.865150039219185e-05, 3.353157815245817e-06},
   {2.768664837876082e-03, 1.560475718403892e-02, 4.251330311793730e-02,
    8.208265565431398e-02, 1.278345091835762e-01, 1.703452071881208e-01,
    2.003145395556726e-01, 2.114582928769587e-01, 2.022362018391584e-01,
    1.759232352855731e-01, 1.391716330269610e-01, 9.973365570521556e-02,
    6.422806943997313e-02, 3.668674985122761e-02, 1.821276452255625e-02,
    7.614249225118673e-03, 2.547695718598530e-03, 6.243491188529550e-04,
    9.395785146685461e-05, 5.508816805110130e-06},
   {1.565134159496541e-04, 1.613808116970697e-03, 6.989146872193697e-03,
    1.950262382709381e-02, 4.108130098921402e-02, 7.052518894561741e-02,
    1.029222538345098e-01, 1.308785801698183e-01, 1.471402483256259e-01,
    1.473969196516950e-01, 1.319249233685375e-01, 1.053180157386830e-01,
    7.452202443118797e-02, 4.619153795651842e-02, 2.460232879228123e-02,
    1.091925932887307e-02, 3.840500991388080e-03, 9.801218872845627e-04,
    1.522361906087519e-04, 9.133832615751404e-06},
   {1.527154101373512e-05, 2.492077839669210e-04, 1.558589765751209e-03,
    5.884470157562622e-03, 1.598407267195838e-02, 3.410053092833960e-02,
    6.005016361458117e-02, 8.994567818901381e-02, 1.167202913055262e-01,
    1.326345811851433e-01, 1.326345811851431e-01, 1.167202913055252e-01,
    8.994567818901364e-02, 6.005016361458185e-02, 3.410053092833917e-02,
    1.598407267195846e-02, 5.884470157562566e-03, 1.558589765751212e-03,
    2.492077839669240e-04, 1.527154101373508e-05},
   {2.188798134953572e-06, 5.193696919466755e-05, 4.408704587341790e-04,
    2.151144965499640e-03, 7.275652327322867e-03, 1.876646076608530e-02,
    3.900661638805282e-02, 6.758896385657921e-02, 9.973580843301608e-02,
    1.269630174622720e-01, 1.403628996744191e-01, 1.349491911479255e-01,
    1.123982508662798e-01, 8.030758988092142e-02, 4.835953681070639e-02,
    2.383149400707292e-02, 9.149112182261167e-03, 2.507478061206504e-03,
    4.117713457583669e-04, 2.572988427133085e-05}},
  {// a = 4
   {2.332093254391667e-01, 5.125612778000509e-01, 7.258617735691842e-01,
    8.506582511915869e-01, 8.816546739615281e-01, 8.296570542443914e-01,
    7.172611206902804e-01, 5.724638958602063e-01, 4.221084777884259e-01,
    2.868682492789557e-01, 1.787658575111919e-01, 1.013151319675854e-01,
    5.160210830764782e-02, 2.321995573202859e-02, 9.007089025276100e-03,
    2.903844678093574e-03, 7.348351356219093e-04, 1.324482317181066e-04,
    1.408082045731623e-05, 5.487666144509803e-07},
   {5.073632927221474e-03, 2.820646294534146e-02, 7.519614627891190e-02,
    1.409153963594707e-01, 2.112205458232889e-01, 2.685308164679017e-01,
    2.985079493675207e-01, 2.949905454247750e-01, 2.613605315772212e-01,
    2.082485745245979e-01, 1.490373520401883e-01, 9.529842117037533e-02,
    5.391728248057852e-02, 2.658027343122925e-02, 1.115544541050236e-02,
    3.846832631931801e-03, 1.030224401391309e-03, 1.945685263756131e-04,
    2.147068799231026e-05, 8.608565193967390e-07},
   {2.748841883042782e-04, 2.787299050841663e-03, 1.178131560140924e-02,
    3.183553435649934e-02, 6.441753335893181e-02, 1.053370296604169e-01,
    1.451318036180439e-01, 1.725966082984333e-01, 1.796362585016358e-01,
    1.647626611402603e-01, 1.333954952735661e-01, 9.503926627878106e-02,
    5.910982645477970e-02, 3.164685708156192e-02, 1.426541485584200e-02,
    5.229769717038873e-03, 1.474835082245556e-03, 2.906728319505188e-04,
    3.318802446839218e-05, 1.365672609013792e-06},
   {2.572988427133085e-05, 4.117713457583669e-04, 2.507478061206504e-03,
    9.149112182261167e-03, 2.383149400707292e-02, 4.835953681070639e-02,
    8.030758988092142e-02, 1.123982508662798e-01, 1.349491911479255e-01,
    1.403628996744191e-01, 1.269630174622720e-01, 9.973580843301608e-02,
    6.758896385657921e-02, 3.900661638805282e-02, 1.876646076608530e-02,
    7.275652327322867e-03, 2.151144965499640e-03, 4.408704587341790e-04,
    5.193696919466755e-05, 2.188798134953572e-06},
   {3.541057356964325e-06, 8.219557979508511e-05, 6.778974578105168e-04,
    3.190765480046624e-03, 1.033284641747933e-02, 2.531842456855826e-02,
    4.957668331918856e-02, 8.020967907936748e-02, 1.094538766469818e-01,
    1.275032967426225e-01, 1.275032967426227e-01, 1.094538766469818e-01,
    8.020967907936748e-02, 4.957668331918842e-02, 2.531842456855835e-02,
    1.033284641747933e-02, 3.190765480046644e-03, 6.778974578105047e-04,
    8.219557979508573e-05, 3.541057356964604e-06}}};

void getGaussJacobiQuadrature(int a, int b, int n, double **pt, double **wt)
{
  *pt = NULL;
  *wt = NULL;
  if(a < 0 || a > 4 || b < 0 || b > 4)
    Msg::Error("Gauss-Jacobi %i %i quadrature not available.", a, b);
  switch(n) {
  case 1:
    *pt = _gaussJacobiPt_1[a][b];
    *wt = _gaussJacobiWt_1[a][b];
    break;
  case 2:
    *pt = _gaussJacobiPt_2[a][b];
    *wt = _gaussJacobiWt_2[a][b];
    break;
  case 3:
    *pt = _gaussJacobiPt_3[a][b];
    *wt = _gaussJacobiWt_3[a][b];
    break;
  case 4:
    *pt = _gaussJacobiPt_4[a][b];
    *wt = _gaussJacobiWt_4[a][b];
    break;
  case 5:
    *pt = _gaussJacobiPt_5[a][b];
    *wt = _gaussJacobiWt_5[a][b];
    break;
  case 6:
    *pt = _gaussJacobiPt_6[a][b];
    *wt = _gaussJacobiWt_6[a][b];
    break;
  case 7:
    *pt = _gaussJacobiPt_7[a][b];
    *wt = _gaussJacobiWt_7[a][b];
    break;
  case 8:
    *pt = _gaussJacobiPt_8[a][b];
    *wt = _gaussJacobiWt_8[a][b];
    break;
  case 9:
    *pt = _gaussJacobiPt_9[a][b];
    *wt = _gaussJacobiWt_9[a][b];
    break;
  case 10:
    *pt = _gaussJacobiPt_10[a][b];
    *wt = _gaussJacobiWt_10[a][b];
    break;
  case 11:
    *pt = _gaussJacobiPt_11[a][b];
    *wt = _gaussJacobiWt_11[a][b];
    break;
  case 12:
    *pt = _gaussJacobiPt_12[a][b];
    *wt = _gaussJacobiWt_12[a][b];
    break;
  case 13:
    *pt = _gaussJacobiPt_13[a][b];
    *wt = _gaussJacobiWt_13[a][b];
    break;
  case 14:
    *pt = _gaussJacobiPt_14[a][b];
    *wt = _gaussJacobiWt_14[a][b];
    break;
  case 15:
    *pt = _gaussJacobiPt_15[a][b];
    *wt = _gaussJacobiWt_15[a][b];
    break;
  case 16:
    *pt = _gaussJacobiPt_16[a][b];
    *wt = _gaussJacobiWt_16[a][b];
    break;
  case 17:
    *pt = _gaussJacobiPt_17[a][b];
    *wt = _gaussJacobiWt_17[a][b];
    break;
  case 18:
    *pt = _gaussJacobiPt_18[a][b];
    *wt = _gaussJacobiWt_18[a][b];
    break;
  case 19:
    *pt = _gaussJacobiPt_19[a][b];
    *wt = _gaussJacobiWt_19[a][b];
    break;
  case 20:
    *pt = _gaussJacobiPt_20[a][b];
    *wt = _gaussJacobiWt_20[a][b];
    break;
  default: Msg::Error("%i-points Gauss-Jacobi quadrature not available.", n);
  }
}
