# Tutorial

1. [Geometry basics, elementary entities, physical groups](./fundamentals.md)
2. [Transformations, extruded geometries, volumes](./geometry/transforms.md)
3. [Extruded meshes, parameters, options](./mesh/extrude.md)
4. [Holes in surfaces, annotations, entity colors](./geometry/holes.md)
5. [Characteristic lengths, macros, loops, holes in volumes](./mesh/mesh-sizes.md)
6. [Transfinite meshes](./mesh/transfinite.md)
7. [Background meshes](./mesh/background.md)
8. [Post-processing and animations](./postpro/intro.md)
9. [Plugins](./postpro/plugins.md)
10. [Mesh size fields](./mesh/size-fields.md)
11. [Unstructured quadrangular meshes](./mesh/quad.md)
12. [Cross-patch meshing with compounds](./mesh/compound.md)
13. [Remeshing an STL file without an underlying CAD model](./mesh/stl.md)
14. [Homology and cohomology computation](./mesh/homology.md)
15. [Embedded points, lines and surfaces](./mesh/embedded.md)
16. [Constructive Solid Geometry, OpenCASCADE geometry kernel](./occ.md)
17. [Anisotropic background mesh](./mesh/anisotropic.md)
18. [Periodic meshes](./mesh/periodic.md)
19. [Thrusections, fillets, pipes, mesh size from curvature](./geometry/occ-demo.md)
20. [STEP import and manipulation, geometry partitioning](./geometry/step.md)
21. [Mesh partitioning](./mesh/partition.md)
