//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armlocks

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/profile/p20200901/internal"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ManagementLocksClient contains the methods for the ManagementLocks group.
// Don't use this type directly, use NewManagementLocksClient() instead.
type ManagementLocksClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewManagementLocksClient creates a new instance of ManagementLocksClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewManagementLocksClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ManagementLocksClient, error) {
	cl, err := arm.NewClient(internal.ModuleName+"/armlocks.ManagementLocksClient", internal.ModuleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ManagementLocksClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdateAtResourceGroupLevel - When you apply a lock at a parent scope, all child resources inherit the same lock.
// To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group to lock.
//   - lockName - The lock name. The lock name can be a maximum of 260 characters. It cannot contain %, &, :, \, ?, /, or any
//     control characters.
//   - parameters - The management lock parameters.
//   - options - ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateAtResourceGroupLevel
//     method.
func (client *ManagementLocksClient) CreateOrUpdateAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions) (ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse, error) {
	req, err := client.createOrUpdateAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateAtResourceGroupLevelHandleResponse(resp)
}

// createOrUpdateAtResourceGroupLevelCreateRequest creates the CreateOrUpdateAtResourceGroupLevel request.
func (client *ManagementLocksClient) createOrUpdateAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateAtResourceGroupLevelHandleResponse handles the CreateOrUpdateAtResourceGroupLevel response.
func (client *ManagementLocksClient) createOrUpdateAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse, error) {
	result := ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtResourceLevel - When you apply a lock at a parent scope, all child resources inherit the same lock. To
// create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group containing the resource to lock.
//   - resourceProviderNamespace - The resource provider namespace of the resource to lock.
//   - parentResourcePath - The parent resource identity.
//   - resourceType - The resource type of the resource to lock.
//   - resourceName - The name of the resource to lock.
//   - lockName - The name of lock. The lock name can be a maximum of 260 characters. It cannot contain %, &, :, \, ?, /, or any
//     control characters.
//   - parameters - Parameters for creating or updating a management lock.
//   - options - ManagementLocksClientCreateOrUpdateAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateAtResourceLevel
//     method.
func (client *ManagementLocksClient) CreateOrUpdateAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceLevelOptions) (ManagementLocksClientCreateOrUpdateAtResourceLevelResponse, error) {
	req, err := client.createOrUpdateAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateAtResourceLevelHandleResponse(resp)
}

// createOrUpdateAtResourceLevelCreateRequest creates the CreateOrUpdateAtResourceLevel request.
func (client *ManagementLocksClient) createOrUpdateAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateAtResourceLevelHandleResponse handles the CreateOrUpdateAtResourceLevel response.
func (client *ManagementLocksClient) createOrUpdateAtResourceLevelHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateAtResourceLevelResponse, error) {
	result := ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateAtResourceLevelResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtSubscriptionLevel - When you apply a lock at a parent scope, all child resources inherit the same lock.
// To create management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - lockName - The name of lock. The lock name can be a maximum of 260 characters. It cannot contain %, &, :, \, ?, /, or any
//     control characters.
//   - parameters - The management lock parameters.
//   - options - ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateAtSubscriptionLevel
//     method.
func (client *ManagementLocksClient) CreateOrUpdateAtSubscriptionLevel(ctx context.Context, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions) (ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse, error) {
	req, err := client.createOrUpdateAtSubscriptionLevelCreateRequest(ctx, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateAtSubscriptionLevelHandleResponse(resp)
}

// createOrUpdateAtSubscriptionLevelCreateRequest creates the CreateOrUpdateAtSubscriptionLevel request.
func (client *ManagementLocksClient) createOrUpdateAtSubscriptionLevelCreateRequest(ctx context.Context, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateAtSubscriptionLevelHandleResponse handles the CreateOrUpdateAtSubscriptionLevel response.
func (client *ManagementLocksClient) createOrUpdateAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse, error) {
	result := ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateByScope - Create or update a management lock by scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - scope - The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions,
//     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for
//     resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
//     for
//     resources.
//   - lockName - The name of lock.
//   - parameters - Create or update management lock parameters.
//   - options - ManagementLocksClientCreateOrUpdateByScopeOptions contains the optional parameters for the ManagementLocksClient.CreateOrUpdateByScope
//     method.
func (client *ManagementLocksClient) CreateOrUpdateByScope(ctx context.Context, scope string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateByScopeOptions) (ManagementLocksClientCreateOrUpdateByScopeResponse, error) {
	req, err := client.createOrUpdateByScopeCreateRequest(ctx, scope, lockName, parameters, options)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateByScopeHandleResponse(resp)
}

// createOrUpdateByScopeCreateRequest creates the CreateOrUpdateByScope request.
func (client *ManagementLocksClient) createOrUpdateByScopeCreateRequest(ctx context.Context, scope string, lockName string, parameters ManagementLockObject, options *ManagementLocksClientCreateOrUpdateByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks/{lockName}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateByScopeHandleResponse handles the CreateOrUpdateByScope response.
func (client *ManagementLocksClient) createOrUpdateByScopeHandleResponse(resp *http.Response) (ManagementLocksClientCreateOrUpdateByScopeResponse, error) {
	result := ManagementLocksClientCreateOrUpdateByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientCreateOrUpdateByScopeResponse{}, err
	}
	return result, nil
}

// DeleteAtResourceGroupLevel - To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group containing the lock.
//   - lockName - The name of lock to delete.
//   - options - ManagementLocksClientDeleteAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.DeleteAtResourceGroupLevel
//     method.
func (client *ManagementLocksClient) DeleteAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientDeleteAtResourceGroupLevelOptions) (ManagementLocksClientDeleteAtResourceGroupLevelResponse, error) {
	req, err := client.deleteAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
	}
	return ManagementLocksClientDeleteAtResourceGroupLevelResponse{}, nil
}

// deleteAtResourceGroupLevelCreateRequest creates the DeleteAtResourceGroupLevel request.
func (client *ManagementLocksClient) deleteAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientDeleteAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// DeleteAtResourceLevel - To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group containing the resource with the lock to delete.
//   - resourceProviderNamespace - The resource provider namespace of the resource with the lock to delete.
//   - parentResourcePath - The parent resource identity.
//   - resourceType - The resource type of the resource with the lock to delete.
//   - resourceName - The name of the resource with the lock to delete.
//   - lockName - The name of the lock to delete.
//   - options - ManagementLocksClientDeleteAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.DeleteAtResourceLevel
//     method.
func (client *ManagementLocksClient) DeleteAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientDeleteAtResourceLevelOptions) (ManagementLocksClientDeleteAtResourceLevelResponse, error) {
	req, err := client.deleteAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteAtResourceLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ManagementLocksClientDeleteAtResourceLevelResponse{}, runtime.NewResponseError(resp)
	}
	return ManagementLocksClientDeleteAtResourceLevelResponse{}, nil
}

// deleteAtResourceLevelCreateRequest creates the DeleteAtResourceLevel request.
func (client *ManagementLocksClient) deleteAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientDeleteAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// DeleteAtSubscriptionLevel - To delete management locks, you must have access to Microsoft.Authorization/* or Microsoft.Authorization/locks/*
// actions. Of the built-in roles, only Owner and User Access Administrator are granted
// those actions.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - lockName - The name of lock to delete.
//   - options - ManagementLocksClientDeleteAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.DeleteAtSubscriptionLevel
//     method.
func (client *ManagementLocksClient) DeleteAtSubscriptionLevel(ctx context.Context, lockName string, options *ManagementLocksClientDeleteAtSubscriptionLevelOptions) (ManagementLocksClientDeleteAtSubscriptionLevelResponse, error) {
	req, err := client.deleteAtSubscriptionLevelCreateRequest(ctx, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
	}
	return ManagementLocksClientDeleteAtSubscriptionLevelResponse{}, nil
}

// deleteAtSubscriptionLevelCreateRequest creates the DeleteAtSubscriptionLevel request.
func (client *ManagementLocksClient) deleteAtSubscriptionLevelCreateRequest(ctx context.Context, lockName string, options *ManagementLocksClientDeleteAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// DeleteByScope - Delete a management lock by scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - scope - The scope for the lock.
//   - lockName - The name of lock.
//   - options - ManagementLocksClientDeleteByScopeOptions contains the optional parameters for the ManagementLocksClient.DeleteByScope
//     method.
func (client *ManagementLocksClient) DeleteByScope(ctx context.Context, scope string, lockName string, options *ManagementLocksClientDeleteByScopeOptions) (ManagementLocksClientDeleteByScopeResponse, error) {
	req, err := client.deleteByScopeCreateRequest(ctx, scope, lockName, options)
	if err != nil {
		return ManagementLocksClientDeleteByScopeResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientDeleteByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return ManagementLocksClientDeleteByScopeResponse{}, runtime.NewResponseError(resp)
	}
	return ManagementLocksClientDeleteByScopeResponse{}, nil
}

// deleteByScopeCreateRequest creates the DeleteByScope request.
func (client *ManagementLocksClient) deleteByScopeCreateRequest(ctx context.Context, scope string, lockName string, options *ManagementLocksClientDeleteByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks/{lockName}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// GetAtResourceGroupLevel - Gets a management lock at the resource group level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the locked resource group.
//   - lockName - The name of the lock to get.
//   - options - ManagementLocksClientGetAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.GetAtResourceGroupLevel
//     method.
func (client *ManagementLocksClient) GetAtResourceGroupLevel(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientGetAtResourceGroupLevelOptions) (ManagementLocksClientGetAtResourceGroupLevelResponse, error) {
	req, err := client.getAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, lockName, options)
	if err != nil {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAtResourceGroupLevelHandleResponse(resp)
}

// getAtResourceGroupLevelCreateRequest creates the GetAtResourceGroupLevel request.
func (client *ManagementLocksClient) getAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, lockName string, options *ManagementLocksClientGetAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceGroupLevelHandleResponse handles the GetAtResourceGroupLevel response.
func (client *ManagementLocksClient) getAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementLocksClientGetAtResourceGroupLevelResponse, error) {
	result := ManagementLocksClientGetAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// GetAtResourceLevel - Get the management lock of a resource or any level below resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group.
//   - resourceProviderNamespace - The namespace of the resource provider.
//   - parentResourcePath - An extra path parameter needed in some services, like SQL Databases.
//   - resourceType - The type of the resource.
//   - resourceName - The name of the resource.
//   - lockName - The name of lock.
//   - options - ManagementLocksClientGetAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.GetAtResourceLevel
//     method.
func (client *ManagementLocksClient) GetAtResourceLevel(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientGetAtResourceLevelOptions) (ManagementLocksClientGetAtResourceLevelResponse, error) {
	req, err := client.getAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, lockName, options)
	if err != nil {
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementLocksClientGetAtResourceLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAtResourceLevelHandleResponse(resp)
}

// getAtResourceLevelCreateRequest creates the GetAtResourceLevel request.
func (client *ManagementLocksClient) getAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, lockName string, options *ManagementLocksClientGetAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtResourceLevelHandleResponse handles the GetAtResourceLevel response.
func (client *ManagementLocksClient) getAtResourceLevelHandleResponse(resp *http.Response) (ManagementLocksClientGetAtResourceLevelResponse, error) {
	result := ManagementLocksClientGetAtResourceLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetAtResourceLevelResponse{}, err
	}
	return result, nil
}

// GetAtSubscriptionLevel - Gets a management lock at the subscription level.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - lockName - The name of the lock to get.
//   - options - ManagementLocksClientGetAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.GetAtSubscriptionLevel
//     method.
func (client *ManagementLocksClient) GetAtSubscriptionLevel(ctx context.Context, lockName string, options *ManagementLocksClientGetAtSubscriptionLevelOptions) (ManagementLocksClientGetAtSubscriptionLevelResponse, error) {
	req, err := client.getAtSubscriptionLevelCreateRequest(ctx, lockName, options)
	if err != nil {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAtSubscriptionLevelHandleResponse(resp)
}

// getAtSubscriptionLevelCreateRequest creates the GetAtSubscriptionLevel request.
func (client *ManagementLocksClient) getAtSubscriptionLevelCreateRequest(ctx context.Context, lockName string, options *ManagementLocksClientGetAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks/{lockName}"
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtSubscriptionLevelHandleResponse handles the GetAtSubscriptionLevel response.
func (client *ManagementLocksClient) getAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementLocksClientGetAtSubscriptionLevelResponse, error) {
	result := ManagementLocksClientGetAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// GetByScope - Get a management lock by scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2016-09-01
//   - scope - The scope for the lock.
//   - lockName - The name of lock.
//   - options - ManagementLocksClientGetByScopeOptions contains the optional parameters for the ManagementLocksClient.GetByScope
//     method.
func (client *ManagementLocksClient) GetByScope(ctx context.Context, scope string, lockName string, options *ManagementLocksClientGetByScopeOptions) (ManagementLocksClientGetByScopeResponse, error) {
	req, err := client.getByScopeCreateRequest(ctx, scope, lockName, options)
	if err != nil {
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	resp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return ManagementLocksClientGetByScopeResponse{}, runtime.NewResponseError(resp)
	}
	return client.getByScopeHandleResponse(resp)
}

// getByScopeCreateRequest creates the GetByScope request.
func (client *ManagementLocksClient) getByScopeCreateRequest(ctx context.Context, scope string, lockName string, options *ManagementLocksClientGetByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks/{lockName}"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	if lockName == "" {
		return nil, errors.New("parameter lockName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{lockName}", url.PathEscape(lockName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getByScopeHandleResponse handles the GetByScope response.
func (client *ManagementLocksClient) getByScopeHandleResponse(resp *http.Response) (ManagementLocksClientGetByScopeResponse, error) {
	result := ManagementLocksClientGetByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockObject); err != nil {
		return ManagementLocksClientGetByScopeResponse{}, err
	}
	return result, nil
}

// NewListAtResourceGroupLevelPager - Gets all the management locks for a resource group.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group containing the locks to get.
//   - options - ManagementLocksClientListAtResourceGroupLevelOptions contains the optional parameters for the ManagementLocksClient.NewListAtResourceGroupLevelPager
//     method.
func (client *ManagementLocksClient) NewListAtResourceGroupLevelPager(resourceGroupName string, options *ManagementLocksClientListAtResourceGroupLevelOptions) *runtime.Pager[ManagementLocksClientListAtResourceGroupLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListAtResourceGroupLevelResponse]{
		More: func(page ManagementLocksClientListAtResourceGroupLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListAtResourceGroupLevelResponse) (ManagementLocksClientListAtResourceGroupLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAtResourceGroupLevelCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementLocksClientListAtResourceGroupLevelResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagementLocksClientListAtResourceGroupLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementLocksClientListAtResourceGroupLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAtResourceGroupLevelHandleResponse(resp)
		},
	})
}

// listAtResourceGroupLevelCreateRequest creates the ListAtResourceGroupLevel request.
func (client *ManagementLocksClient) listAtResourceGroupLevelCreateRequest(ctx context.Context, resourceGroupName string, options *ManagementLocksClientListAtResourceGroupLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/locks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtResourceGroupLevelHandleResponse handles the ListAtResourceGroupLevel response.
func (client *ManagementLocksClient) listAtResourceGroupLevelHandleResponse(resp *http.Response) (ManagementLocksClientListAtResourceGroupLevelResponse, error) {
	result := ManagementLocksClientListAtResourceGroupLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListAtResourceGroupLevelResponse{}, err
	}
	return result, nil
}

// NewListAtResourceLevelPager - Gets all the management locks for a resource or any level below resource.
//
// Generated from API version 2016-09-01
//   - resourceGroupName - The name of the resource group containing the locked resource. The name is case insensitive.
//   - resourceProviderNamespace - The namespace of the resource provider.
//   - parentResourcePath - The parent resource identity.
//   - resourceType - The resource type of the locked resource.
//   - resourceName - The name of the locked resource.
//   - options - ManagementLocksClientListAtResourceLevelOptions contains the optional parameters for the ManagementLocksClient.NewListAtResourceLevelPager
//     method.
func (client *ManagementLocksClient) NewListAtResourceLevelPager(resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *ManagementLocksClientListAtResourceLevelOptions) *runtime.Pager[ManagementLocksClientListAtResourceLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListAtResourceLevelResponse]{
		More: func(page ManagementLocksClientListAtResourceLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListAtResourceLevelResponse) (ManagementLocksClientListAtResourceLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAtResourceLevelCreateRequest(ctx, resourceGroupName, resourceProviderNamespace, parentResourcePath, resourceType, resourceName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementLocksClientListAtResourceLevelResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagementLocksClientListAtResourceLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementLocksClientListAtResourceLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAtResourceLevelHandleResponse(resp)
		},
	})
}

// listAtResourceLevelCreateRequest creates the ListAtResourceLevel request.
func (client *ManagementLocksClient) listAtResourceLevelCreateRequest(ctx context.Context, resourceGroupName string, resourceProviderNamespace string, parentResourcePath string, resourceType string, resourceName string, options *ManagementLocksClientListAtResourceLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if resourceProviderNamespace == "" {
		return nil, errors.New("parameter resourceProviderNamespace cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceProviderNamespace}", url.PathEscape(resourceProviderNamespace))
	urlPath = strings.ReplaceAll(urlPath, "{parentResourcePath}", parentResourcePath)
	urlPath = strings.ReplaceAll(urlPath, "{resourceType}", resourceType)
	if resourceName == "" {
		return nil, errors.New("parameter resourceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceName}", url.PathEscape(resourceName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtResourceLevelHandleResponse handles the ListAtResourceLevel response.
func (client *ManagementLocksClient) listAtResourceLevelHandleResponse(resp *http.Response) (ManagementLocksClientListAtResourceLevelResponse, error) {
	result := ManagementLocksClientListAtResourceLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListAtResourceLevelResponse{}, err
	}
	return result, nil
}

// NewListAtSubscriptionLevelPager - Gets all the management locks for a subscription.
//
// Generated from API version 2016-09-01
//   - options - ManagementLocksClientListAtSubscriptionLevelOptions contains the optional parameters for the ManagementLocksClient.NewListAtSubscriptionLevelPager
//     method.
func (client *ManagementLocksClient) NewListAtSubscriptionLevelPager(options *ManagementLocksClientListAtSubscriptionLevelOptions) *runtime.Pager[ManagementLocksClientListAtSubscriptionLevelResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListAtSubscriptionLevelResponse]{
		More: func(page ManagementLocksClientListAtSubscriptionLevelResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListAtSubscriptionLevelResponse) (ManagementLocksClientListAtSubscriptionLevelResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listAtSubscriptionLevelCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementLocksClientListAtSubscriptionLevelResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagementLocksClientListAtSubscriptionLevelResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementLocksClientListAtSubscriptionLevelResponse{}, runtime.NewResponseError(resp)
			}
			return client.listAtSubscriptionLevelHandleResponse(resp)
		},
	})
}

// listAtSubscriptionLevelCreateRequest creates the ListAtSubscriptionLevel request.
func (client *ManagementLocksClient) listAtSubscriptionLevelCreateRequest(ctx context.Context, options *ManagementLocksClientListAtSubscriptionLevelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/locks"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listAtSubscriptionLevelHandleResponse handles the ListAtSubscriptionLevel response.
func (client *ManagementLocksClient) listAtSubscriptionLevelHandleResponse(resp *http.Response) (ManagementLocksClientListAtSubscriptionLevelResponse, error) {
	result := ManagementLocksClientListAtSubscriptionLevelResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListAtSubscriptionLevelResponse{}, err
	}
	return result, nil
}

// NewListByScopePager - Gets all the management locks for a scope.
//
// Generated from API version 2016-09-01
//   - scope - The scope for the lock. When providing a scope for the assignment, use '/subscriptions/{subscriptionId}' for subscriptions,
//     '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}' for
//     resource groups, and '/subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePathIfPresent}/{resourceType}/{resourceName}'
//     for
//     resources.
//   - options - ManagementLocksClientListByScopeOptions contains the optional parameters for the ManagementLocksClient.NewListByScopePager
//     method.
func (client *ManagementLocksClient) NewListByScopePager(scope string, options *ManagementLocksClientListByScopeOptions) *runtime.Pager[ManagementLocksClientListByScopeResponse] {
	return runtime.NewPager(runtime.PagingHandler[ManagementLocksClientListByScopeResponse]{
		More: func(page ManagementLocksClientListByScopeResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ManagementLocksClientListByScopeResponse) (ManagementLocksClientListByScopeResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByScopeCreateRequest(ctx, scope, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return ManagementLocksClientListByScopeResponse{}, err
			}
			resp, err := client.internal.Pipeline().Do(req)
			if err != nil {
				return ManagementLocksClientListByScopeResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return ManagementLocksClientListByScopeResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByScopeHandleResponse(resp)
		},
	})
}

// listByScopeCreateRequest creates the ListByScope request.
func (client *ManagementLocksClient) listByScopeCreateRequest(ctx context.Context, scope string, options *ManagementLocksClientListByScopeOptions) (*policy.Request, error) {
	urlPath := "/{scope}/providers/Microsoft.Authorization/locks"
	if scope == "" {
		return nil, errors.New("parameter scope cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scope}", url.PathEscape(scope))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	reqQP.Set("api-version", "2016-09-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByScopeHandleResponse handles the ListByScope response.
func (client *ManagementLocksClient) listByScopeHandleResponse(resp *http.Response) (ManagementLocksClientListByScopeResponse, error) {
	result := ManagementLocksClientListByScopeResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ManagementLockListResult); err != nil {
		return ManagementLocksClientListByScopeResponse{}, err
	}
	return result, nil
}
