//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// PlansClient contains the methods for the AppServicePlans group.
// Don't use this type directly, use NewPlansClient() instead.
type PlansClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewPlansClient creates a new instance of PlansClient with the specified values.
//   - subscriptionID - Your Azure subscription ID. This is a GUID-formatted string (e.g. 00000000-0000-0000-0000-000000000000).
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewPlansClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PlansClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &PlansClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Description for Creates or updates an App Service Plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - appServicePlan - Details of the App Service plan.
//   - options - PlansClientBeginCreateOrUpdateOptions contains the optional parameters for the PlansClient.BeginCreateOrUpdate
//     method.
func (client *PlansClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, name string, appServicePlan Plan, options *PlansClientBeginCreateOrUpdateOptions) (*runtime.Poller[PlansClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, name, appServicePlan, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[PlansClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[PlansClientCreateOrUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// CreateOrUpdate - Description for Creates or updates an App Service Plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
func (client *PlansClient) createOrUpdate(ctx context.Context, resourceGroupName string, name string, appServicePlan Plan, options *PlansClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "PlansClient.BeginCreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, name, appServicePlan, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PlansClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, name string, appServicePlan Plan, options *PlansClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, appServicePlan); err != nil {
		return nil, err
	}
	return req, nil
}

// CreateOrUpdateVnetRoute - Description for Create or update a Virtual Network route in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - routeName - Name of the Virtual Network route.
//   - route - Definition of the Virtual Network route.
//   - options - PlansClientCreateOrUpdateVnetRouteOptions contains the optional parameters for the PlansClient.CreateOrUpdateVnetRoute
//     method.
func (client *PlansClient) CreateOrUpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute, options *PlansClientCreateOrUpdateVnetRouteOptions) (PlansClientCreateOrUpdateVnetRouteResponse, error) {
	var err error
	const operationName = "PlansClient.CreateOrUpdateVnetRoute"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateVnetRouteCreateRequest(ctx, resourceGroupName, name, vnetName, routeName, route, options)
	if err != nil {
		return PlansClientCreateOrUpdateVnetRouteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientCreateOrUpdateVnetRouteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientCreateOrUpdateVnetRouteResponse{}, err
	}
	resp, err := client.createOrUpdateVnetRouteHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateVnetRouteCreateRequest creates the CreateOrUpdateVnetRoute request.
func (client *PlansClient) createOrUpdateVnetRouteCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute, options *PlansClientCreateOrUpdateVnetRouteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if routeName == "" {
		return nil, errors.New("parameter routeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{routeName}", url.PathEscape(routeName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, route); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateVnetRouteHandleResponse handles the CreateOrUpdateVnetRoute response.
func (client *PlansClient) createOrUpdateVnetRouteHandleResponse(resp *http.Response) (PlansClientCreateOrUpdateVnetRouteResponse, error) {
	result := PlansClientCreateOrUpdateVnetRouteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetRoute); err != nil {
		return PlansClientCreateOrUpdateVnetRouteResponse{}, err
	}
	return result, nil
}

// Delete - Description for Delete an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientDeleteOptions contains the optional parameters for the PlansClient.Delete method.
func (client *PlansClient) Delete(ctx context.Context, resourceGroupName string, name string, options *PlansClientDeleteOptions) (PlansClientDeleteResponse, error) {
	var err error
	const operationName = "PlansClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientDeleteResponse{}, err
	}
	return PlansClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PlansClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteHybridConnection - Description for Delete a Hybrid Connection in use in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - namespaceName - Name of the Service Bus namespace.
//   - relayName - Name of the Service Bus relay.
//   - options - PlansClientDeleteHybridConnectionOptions contains the optional parameters for the PlansClient.DeleteHybridConnection
//     method.
func (client *PlansClient) DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientDeleteHybridConnectionOptions) (PlansClientDeleteHybridConnectionResponse, error) {
	var err error
	const operationName = "PlansClient.DeleteHybridConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteHybridConnectionCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, options)
	if err != nil {
		return PlansClientDeleteHybridConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientDeleteHybridConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientDeleteHybridConnectionResponse{}, err
	}
	return PlansClientDeleteHybridConnectionResponse{}, nil
}

// deleteHybridConnectionCreateRequest creates the DeleteHybridConnection request.
func (client *PlansClient) deleteHybridConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientDeleteHybridConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteVnetRoute - Description for Delete a Virtual Network route in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - routeName - Name of the Virtual Network route.
//   - options - PlansClientDeleteVnetRouteOptions contains the optional parameters for the PlansClient.DeleteVnetRoute method.
func (client *PlansClient) DeleteVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, options *PlansClientDeleteVnetRouteOptions) (PlansClientDeleteVnetRouteResponse, error) {
	var err error
	const operationName = "PlansClient.DeleteVnetRoute"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteVnetRouteCreateRequest(ctx, resourceGroupName, name, vnetName, routeName, options)
	if err != nil {
		return PlansClientDeleteVnetRouteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientDeleteVnetRouteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientDeleteVnetRouteResponse{}, err
	}
	return PlansClientDeleteVnetRouteResponse{}, nil
}

// deleteVnetRouteCreateRequest creates the DeleteVnetRoute request.
func (client *PlansClient) deleteVnetRouteCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, options *PlansClientDeleteVnetRouteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if routeName == "" {
		return nil, errors.New("parameter routeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{routeName}", url.PathEscape(routeName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Description for Get an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientGetOptions contains the optional parameters for the PlansClient.Get method.
func (client *PlansClient) Get(ctx context.Context, resourceGroupName string, name string, options *PlansClientGetOptions) (PlansClientGetResponse, error) {
	var err error
	const operationName = "PlansClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *PlansClient) getCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PlansClient) getHandleResponse(resp *http.Response) (PlansClientGetResponse, error) {
	result := PlansClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Plan); err != nil {
		return PlansClientGetResponse{}, err
	}
	return result, nil
}

// GetHybridConnection - Description for Retrieve a Hybrid Connection in use in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - namespaceName - Name of the Service Bus namespace.
//   - relayName - Name of the Service Bus relay.
//   - options - PlansClientGetHybridConnectionOptions contains the optional parameters for the PlansClient.GetHybridConnection
//     method.
func (client *PlansClient) GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientGetHybridConnectionOptions) (PlansClientGetHybridConnectionResponse, error) {
	var err error
	const operationName = "PlansClient.GetHybridConnection"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getHybridConnectionCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, options)
	if err != nil {
		return PlansClientGetHybridConnectionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetHybridConnectionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetHybridConnectionResponse{}, err
	}
	resp, err := client.getHybridConnectionHandleResponse(httpResp)
	return resp, err
}

// getHybridConnectionCreateRequest creates the GetHybridConnection request.
func (client *PlansClient) getHybridConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientGetHybridConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHybridConnectionHandleResponse handles the GetHybridConnection response.
func (client *PlansClient) getHybridConnectionHandleResponse(resp *http.Response) (PlansClientGetHybridConnectionResponse, error) {
	result := PlansClientGetHybridConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnection); err != nil {
		return PlansClientGetHybridConnectionResponse{}, err
	}
	return result, nil
}

// GetHybridConnectionPlanLimit - Description for Get the maximum number of Hybrid Connections allowed in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientGetHybridConnectionPlanLimitOptions contains the optional parameters for the PlansClient.GetHybridConnectionPlanLimit
//     method.
func (client *PlansClient) GetHybridConnectionPlanLimit(ctx context.Context, resourceGroupName string, name string, options *PlansClientGetHybridConnectionPlanLimitOptions) (PlansClientGetHybridConnectionPlanLimitResponse, error) {
	var err error
	const operationName = "PlansClient.GetHybridConnectionPlanLimit"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getHybridConnectionPlanLimitCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientGetHybridConnectionPlanLimitResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetHybridConnectionPlanLimitResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetHybridConnectionPlanLimitResponse{}, err
	}
	resp, err := client.getHybridConnectionPlanLimitHandleResponse(httpResp)
	return resp, err
}

// getHybridConnectionPlanLimitCreateRequest creates the GetHybridConnectionPlanLimit request.
func (client *PlansClient) getHybridConnectionPlanLimitCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientGetHybridConnectionPlanLimitOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionPlanLimits/limit"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHybridConnectionPlanLimitHandleResponse handles the GetHybridConnectionPlanLimit response.
func (client *PlansClient) getHybridConnectionPlanLimitHandleResponse(resp *http.Response) (PlansClientGetHybridConnectionPlanLimitResponse, error) {
	result := PlansClientGetHybridConnectionPlanLimitResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnectionLimits); err != nil {
		return PlansClientGetHybridConnectionPlanLimitResponse{}, err
	}
	return result, nil
}

// GetRouteForVnet - Description for Get a Virtual Network route in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - routeName - Name of the Virtual Network route.
//   - options - PlansClientGetRouteForVnetOptions contains the optional parameters for the PlansClient.GetRouteForVnet method.
func (client *PlansClient) GetRouteForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, options *PlansClientGetRouteForVnetOptions) (PlansClientGetRouteForVnetResponse, error) {
	var err error
	const operationName = "PlansClient.GetRouteForVnet"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getRouteForVnetCreateRequest(ctx, resourceGroupName, name, vnetName, routeName, options)
	if err != nil {
		return PlansClientGetRouteForVnetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetRouteForVnetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetRouteForVnetResponse{}, err
	}
	resp, err := client.getRouteForVnetHandleResponse(httpResp)
	return resp, err
}

// getRouteForVnetCreateRequest creates the GetRouteForVnet request.
func (client *PlansClient) getRouteForVnetCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, options *PlansClientGetRouteForVnetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if routeName == "" {
		return nil, errors.New("parameter routeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{routeName}", url.PathEscape(routeName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getRouteForVnetHandleResponse handles the GetRouteForVnet response.
func (client *PlansClient) getRouteForVnetHandleResponse(resp *http.Response) (PlansClientGetRouteForVnetResponse, error) {
	result := PlansClientGetRouteForVnetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetRouteArray); err != nil {
		return PlansClientGetRouteForVnetResponse{}, err
	}
	return result, nil
}

// GetServerFarmSKUs - Description for Gets all selectable SKUs for a given App Service Plan
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of App Service Plan
//   - options - PlansClientGetServerFarmSKUsOptions contains the optional parameters for the PlansClient.GetServerFarmSKUs method.
func (client *PlansClient) GetServerFarmSKUs(ctx context.Context, resourceGroupName string, name string, options *PlansClientGetServerFarmSKUsOptions) (PlansClientGetServerFarmSKUsResponse, error) {
	var err error
	const operationName = "PlansClient.GetServerFarmSKUs"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getServerFarmSKUsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientGetServerFarmSKUsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetServerFarmSKUsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetServerFarmSKUsResponse{}, err
	}
	resp, err := client.getServerFarmSKUsHandleResponse(httpResp)
	return resp, err
}

// getServerFarmSKUsCreateRequest creates the GetServerFarmSKUs request.
func (client *PlansClient) getServerFarmSKUsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientGetServerFarmSKUsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/skus"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getServerFarmSKUsHandleResponse handles the GetServerFarmSKUs response.
func (client *PlansClient) getServerFarmSKUsHandleResponse(resp *http.Response) (PlansClientGetServerFarmSKUsResponse, error) {
	result := PlansClientGetServerFarmSKUsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Interface); err != nil {
		return PlansClientGetServerFarmSKUsResponse{}, err
	}
	return result, nil
}

// GetVnetFromServerFarm - Description for Get a Virtual Network associated with an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - options - PlansClientGetVnetFromServerFarmOptions contains the optional parameters for the PlansClient.GetVnetFromServerFarm
//     method.
func (client *PlansClient) GetVnetFromServerFarm(ctx context.Context, resourceGroupName string, name string, vnetName string, options *PlansClientGetVnetFromServerFarmOptions) (PlansClientGetVnetFromServerFarmResponse, error) {
	var err error
	const operationName = "PlansClient.GetVnetFromServerFarm"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getVnetFromServerFarmCreateRequest(ctx, resourceGroupName, name, vnetName, options)
	if err != nil {
		return PlansClientGetVnetFromServerFarmResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetVnetFromServerFarmResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetVnetFromServerFarmResponse{}, err
	}
	resp, err := client.getVnetFromServerFarmHandleResponse(httpResp)
	return resp, err
}

// getVnetFromServerFarmCreateRequest creates the GetVnetFromServerFarm request.
func (client *PlansClient) getVnetFromServerFarmCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, options *PlansClientGetVnetFromServerFarmOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVnetFromServerFarmHandleResponse handles the GetVnetFromServerFarm response.
func (client *PlansClient) getVnetFromServerFarmHandleResponse(resp *http.Response) (PlansClientGetVnetFromServerFarmResponse, error) {
	result := PlansClientGetVnetFromServerFarmResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetInfoResource); err != nil {
		return PlansClientGetVnetFromServerFarmResponse{}, err
	}
	return result, nil
}

// GetVnetGateway - Description for Get a Virtual Network gateway.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - gatewayName - Name of the gateway. Only the 'primary' gateway is supported.
//   - options - PlansClientGetVnetGatewayOptions contains the optional parameters for the PlansClient.GetVnetGateway method.
func (client *PlansClient) GetVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, options *PlansClientGetVnetGatewayOptions) (PlansClientGetVnetGatewayResponse, error) {
	var err error
	const operationName = "PlansClient.GetVnetGateway"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getVnetGatewayCreateRequest(ctx, resourceGroupName, name, vnetName, gatewayName, options)
	if err != nil {
		return PlansClientGetVnetGatewayResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientGetVnetGatewayResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientGetVnetGatewayResponse{}, err
	}
	resp, err := client.getVnetGatewayHandleResponse(httpResp)
	return resp, err
}

// getVnetGatewayCreateRequest creates the GetVnetGateway request.
func (client *PlansClient) getVnetGatewayCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, options *PlansClientGetVnetGatewayOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if gatewayName == "" {
		return nil, errors.New("parameter gatewayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gatewayName}", url.PathEscape(gatewayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getVnetGatewayHandleResponse handles the GetVnetGateway response.
func (client *PlansClient) getVnetGatewayHandleResponse(resp *http.Response) (PlansClientGetVnetGatewayResponse, error) {
	result := PlansClientGetVnetGatewayResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetGateway); err != nil {
		return PlansClientGetVnetGatewayResponse{}, err
	}
	return result, nil
}

// NewListPager - Description for Get all App Service plans for a subscription.
//
// Generated from API version 2023-01-01
//   - options - PlansClientListOptions contains the optional parameters for the PlansClient.NewListPager method.
func (client *PlansClient) NewListPager(options *PlansClientListOptions) *runtime.Pager[PlansClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[PlansClientListResponse]{
		More: func(page PlansClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PlansClientListResponse) (PlansClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PlansClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return PlansClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *PlansClient) listCreateRequest(ctx context.Context, options *PlansClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Web/serverfarms"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.Detailed != nil {
		reqQP.Set("detailed", strconv.FormatBool(*options.Detailed))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *PlansClient) listHandleResponse(resp *http.Response) (PlansClientListResponse, error) {
	result := PlansClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PlanCollection); err != nil {
		return PlansClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Description for Get all App Service plans in a resource group.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - options - PlansClientListByResourceGroupOptions contains the optional parameters for the PlansClient.NewListByResourceGroupPager
//     method.
func (client *PlansClient) NewListByResourceGroupPager(resourceGroupName string, options *PlansClientListByResourceGroupOptions) *runtime.Pager[PlansClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[PlansClientListByResourceGroupResponse]{
		More: func(page PlansClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PlansClientListByResourceGroupResponse) (PlansClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PlansClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return PlansClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *PlansClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *PlansClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *PlansClient) listByResourceGroupHandleResponse(resp *http.Response) (PlansClientListByResourceGroupResponse, error) {
	result := PlansClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PlanCollection); err != nil {
		return PlansClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// ListCapabilities - Description for List all capabilities of an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientListCapabilitiesOptions contains the optional parameters for the PlansClient.ListCapabilities method.
func (client *PlansClient) ListCapabilities(ctx context.Context, resourceGroupName string, name string, options *PlansClientListCapabilitiesOptions) (PlansClientListCapabilitiesResponse, error) {
	var err error
	const operationName = "PlansClient.ListCapabilities"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listCapabilitiesCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientListCapabilitiesResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientListCapabilitiesResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientListCapabilitiesResponse{}, err
	}
	resp, err := client.listCapabilitiesHandleResponse(httpResp)
	return resp, err
}

// listCapabilitiesCreateRequest creates the ListCapabilities request.
func (client *PlansClient) listCapabilitiesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientListCapabilitiesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/capabilities"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listCapabilitiesHandleResponse handles the ListCapabilities response.
func (client *PlansClient) listCapabilitiesHandleResponse(resp *http.Response) (PlansClientListCapabilitiesResponse, error) {
	result := PlansClientListCapabilitiesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CapabilityArray); err != nil {
		return PlansClientListCapabilitiesResponse{}, err
	}
	return result, nil
}

// ListHybridConnectionKeys - Description for Get the send key name and value of a Hybrid Connection.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - namespaceName - The name of the Service Bus namespace.
//   - relayName - The name of the Service Bus relay.
//   - options - PlansClientListHybridConnectionKeysOptions contains the optional parameters for the PlansClient.ListHybridConnectionKeys
//     method.
func (client *PlansClient) ListHybridConnectionKeys(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientListHybridConnectionKeysOptions) (PlansClientListHybridConnectionKeysResponse, error) {
	var err error
	const operationName = "PlansClient.ListHybridConnectionKeys"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listHybridConnectionKeysCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, options)
	if err != nil {
		return PlansClientListHybridConnectionKeysResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientListHybridConnectionKeysResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientListHybridConnectionKeysResponse{}, err
	}
	resp, err := client.listHybridConnectionKeysHandleResponse(httpResp)
	return resp, err
}

// listHybridConnectionKeysCreateRequest creates the ListHybridConnectionKeys request.
func (client *PlansClient) listHybridConnectionKeysCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientListHybridConnectionKeysOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHybridConnectionKeysHandleResponse handles the ListHybridConnectionKeys response.
func (client *PlansClient) listHybridConnectionKeysHandleResponse(resp *http.Response) (PlansClientListHybridConnectionKeysResponse, error) {
	result := PlansClientListHybridConnectionKeysResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnectionKey); err != nil {
		return PlansClientListHybridConnectionKeysResponse{}, err
	}
	return result, nil
}

// NewListHybridConnectionsPager - Description for Retrieve all Hybrid Connections in use in an App Service plan.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientListHybridConnectionsOptions contains the optional parameters for the PlansClient.NewListHybridConnectionsPager
//     method.
func (client *PlansClient) NewListHybridConnectionsPager(resourceGroupName string, name string, options *PlansClientListHybridConnectionsOptions) *runtime.Pager[PlansClientListHybridConnectionsResponse] {
	return runtime.NewPager(runtime.PagingHandler[PlansClientListHybridConnectionsResponse]{
		More: func(page PlansClientListHybridConnectionsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PlansClientListHybridConnectionsResponse) (PlansClientListHybridConnectionsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PlansClient.NewListHybridConnectionsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listHybridConnectionsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return PlansClientListHybridConnectionsResponse{}, err
			}
			return client.listHybridConnectionsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listHybridConnectionsCreateRequest creates the ListHybridConnections request.
func (client *PlansClient) listHybridConnectionsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientListHybridConnectionsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionRelays"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHybridConnectionsHandleResponse handles the ListHybridConnections response.
func (client *PlansClient) listHybridConnectionsHandleResponse(resp *http.Response) (PlansClientListHybridConnectionsResponse, error) {
	result := PlansClientListHybridConnectionsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.HybridConnectionCollection); err != nil {
		return PlansClientListHybridConnectionsResponse{}, err
	}
	return result, nil
}

// ListRoutesForVnet - Description for Get all routes that are associated with a Virtual Network in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - options - PlansClientListRoutesForVnetOptions contains the optional parameters for the PlansClient.ListRoutesForVnet method.
func (client *PlansClient) ListRoutesForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, options *PlansClientListRoutesForVnetOptions) (PlansClientListRoutesForVnetResponse, error) {
	var err error
	const operationName = "PlansClient.ListRoutesForVnet"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listRoutesForVnetCreateRequest(ctx, resourceGroupName, name, vnetName, options)
	if err != nil {
		return PlansClientListRoutesForVnetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientListRoutesForVnetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientListRoutesForVnetResponse{}, err
	}
	resp, err := client.listRoutesForVnetHandleResponse(httpResp)
	return resp, err
}

// listRoutesForVnetCreateRequest creates the ListRoutesForVnet request.
func (client *PlansClient) listRoutesForVnetCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, options *PlansClientListRoutesForVnetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listRoutesForVnetHandleResponse handles the ListRoutesForVnet response.
func (client *PlansClient) listRoutesForVnetHandleResponse(resp *http.Response) (PlansClientListRoutesForVnetResponse, error) {
	result := PlansClientListRoutesForVnetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetRouteArray); err != nil {
		return PlansClientListRoutesForVnetResponse{}, err
	}
	return result, nil
}

// NewListUsagesPager - Description for Gets server farm usage information
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of App Service Plan
//   - options - PlansClientListUsagesOptions contains the optional parameters for the PlansClient.NewListUsagesPager method.
func (client *PlansClient) NewListUsagesPager(resourceGroupName string, name string, options *PlansClientListUsagesOptions) *runtime.Pager[PlansClientListUsagesResponse] {
	return runtime.NewPager(runtime.PagingHandler[PlansClientListUsagesResponse]{
		More: func(page PlansClientListUsagesResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PlansClientListUsagesResponse) (PlansClientListUsagesResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PlansClient.NewListUsagesPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listUsagesCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return PlansClientListUsagesResponse{}, err
			}
			return client.listUsagesHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listUsagesCreateRequest creates the ListUsages request.
func (client *PlansClient) listUsagesCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientListUsagesOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/usages"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listUsagesHandleResponse handles the ListUsages response.
func (client *PlansClient) listUsagesHandleResponse(resp *http.Response) (PlansClientListUsagesResponse, error) {
	result := PlansClientListUsagesResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.CsmUsageQuotaCollection); err != nil {
		return PlansClientListUsagesResponse{}, err
	}
	return result, nil
}

// ListVnets - Description for Get all Virtual Networks associated with an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientListVnetsOptions contains the optional parameters for the PlansClient.ListVnets method.
func (client *PlansClient) ListVnets(ctx context.Context, resourceGroupName string, name string, options *PlansClientListVnetsOptions) (PlansClientListVnetsResponse, error) {
	var err error
	const operationName = "PlansClient.ListVnets"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listVnetsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientListVnetsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientListVnetsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientListVnetsResponse{}, err
	}
	resp, err := client.listVnetsHandleResponse(httpResp)
	return resp, err
}

// listVnetsCreateRequest creates the ListVnets request.
func (client *PlansClient) listVnetsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientListVnetsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listVnetsHandleResponse handles the ListVnets response.
func (client *PlansClient) listVnetsHandleResponse(resp *http.Response) (PlansClientListVnetsResponse, error) {
	result := PlansClientListVnetsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetInfoResourceArray); err != nil {
		return PlansClientListVnetsResponse{}, err
	}
	return result, nil
}

// NewListWebAppsPager - Description for Get all apps associated with an App Service plan.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientListWebAppsOptions contains the optional parameters for the PlansClient.NewListWebAppsPager method.
func (client *PlansClient) NewListWebAppsPager(resourceGroupName string, name string, options *PlansClientListWebAppsOptions) *runtime.Pager[PlansClientListWebAppsResponse] {
	return runtime.NewPager(runtime.PagingHandler[PlansClientListWebAppsResponse]{
		More: func(page PlansClientListWebAppsResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PlansClientListWebAppsResponse) (PlansClientListWebAppsResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PlansClient.NewListWebAppsPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWebAppsCreateRequest(ctx, resourceGroupName, name, options)
			}, nil)
			if err != nil {
				return PlansClientListWebAppsResponse{}, err
			}
			return client.listWebAppsHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWebAppsCreateRequest creates the ListWebApps request.
func (client *PlansClient) listWebAppsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientListWebAppsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/sites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	if options != nil && options.SkipToken != nil {
		reqQP.Set("$skipToken", *options.SkipToken)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", *options.Top)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	unencodedParams := []string{req.Raw().URL.RawQuery}
	if options != nil && options.Filter != nil {
		unencodedParams = append(unencodedParams, "$filter="+*options.Filter)
	}
	req.Raw().URL.RawQuery = strings.Join(unencodedParams, "&")
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebAppsHandleResponse handles the ListWebApps response.
func (client *PlansClient) listWebAppsHandleResponse(resp *http.Response) (PlansClientListWebAppsResponse, error) {
	result := PlansClientListWebAppsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.WebAppCollection); err != nil {
		return PlansClientListWebAppsResponse{}, err
	}
	return result, nil
}

// NewListWebAppsByHybridConnectionPager - Description for Get all apps that use a Hybrid Connection in an App Service Plan.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - namespaceName - Name of the Hybrid Connection namespace.
//   - relayName - Name of the Hybrid Connection relay.
//   - options - PlansClientListWebAppsByHybridConnectionOptions contains the optional parameters for the PlansClient.NewListWebAppsByHybridConnectionPager
//     method.
func (client *PlansClient) NewListWebAppsByHybridConnectionPager(resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientListWebAppsByHybridConnectionOptions) *runtime.Pager[PlansClientListWebAppsByHybridConnectionResponse] {
	return runtime.NewPager(runtime.PagingHandler[PlansClientListWebAppsByHybridConnectionResponse]{
		More: func(page PlansClientListWebAppsByHybridConnectionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PlansClientListWebAppsByHybridConnectionResponse) (PlansClientListWebAppsByHybridConnectionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "PlansClient.NewListWebAppsByHybridConnectionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listWebAppsByHybridConnectionCreateRequest(ctx, resourceGroupName, name, namespaceName, relayName, options)
			}, nil)
			if err != nil {
				return PlansClientListWebAppsByHybridConnectionResponse{}, err
			}
			return client.listWebAppsByHybridConnectionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listWebAppsByHybridConnectionCreateRequest creates the ListWebAppsByHybridConnection request.
func (client *PlansClient) listWebAppsByHybridConnectionCreateRequest(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, options *PlansClientListWebAppsByHybridConnectionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/sites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if namespaceName == "" {
		return nil, errors.New("parameter namespaceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{namespaceName}", url.PathEscape(namespaceName))
	if relayName == "" {
		return nil, errors.New("parameter relayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{relayName}", url.PathEscape(relayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listWebAppsByHybridConnectionHandleResponse handles the ListWebAppsByHybridConnection response.
func (client *PlansClient) listWebAppsByHybridConnectionHandleResponse(resp *http.Response) (PlansClientListWebAppsByHybridConnectionResponse, error) {
	result := PlansClientListWebAppsByHybridConnectionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ResourceCollection); err != nil {
		return PlansClientListWebAppsByHybridConnectionResponse{}, err
	}
	return result, nil
}

// RebootWorker - Description for Reboot a worker machine in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - workerName - Name of worker machine, which typically starts with RD.
//   - options - PlansClientRebootWorkerOptions contains the optional parameters for the PlansClient.RebootWorker method.
func (client *PlansClient) RebootWorker(ctx context.Context, resourceGroupName string, name string, workerName string, options *PlansClientRebootWorkerOptions) (PlansClientRebootWorkerResponse, error) {
	var err error
	const operationName = "PlansClient.RebootWorker"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.rebootWorkerCreateRequest(ctx, resourceGroupName, name, workerName, options)
	if err != nil {
		return PlansClientRebootWorkerResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientRebootWorkerResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientRebootWorkerResponse{}, err
	}
	return PlansClientRebootWorkerResponse{}, nil
}

// rebootWorkerCreateRequest creates the RebootWorker request.
func (client *PlansClient) rebootWorkerCreateRequest(ctx context.Context, resourceGroupName string, name string, workerName string, options *PlansClientRebootWorkerOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/workers/{workerName}/reboot"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if workerName == "" {
		return nil, errors.New("parameter workerName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{workerName}", url.PathEscape(workerName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// RestartWebApps - Description for Restart all apps in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - options - PlansClientRestartWebAppsOptions contains the optional parameters for the PlansClient.RestartWebApps method.
func (client *PlansClient) RestartWebApps(ctx context.Context, resourceGroupName string, name string, options *PlansClientRestartWebAppsOptions) (PlansClientRestartWebAppsResponse, error) {
	var err error
	const operationName = "PlansClient.RestartWebApps"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.restartWebAppsCreateRequest(ctx, resourceGroupName, name, options)
	if err != nil {
		return PlansClientRestartWebAppsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientRestartWebAppsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientRestartWebAppsResponse{}, err
	}
	return PlansClientRestartWebAppsResponse{}, nil
}

// restartWebAppsCreateRequest creates the RestartWebApps request.
func (client *PlansClient) restartWebAppsCreateRequest(ctx context.Context, resourceGroupName string, name string, options *PlansClientRestartWebAppsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/restartSites"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if options != nil && options.SoftRestart != nil {
		reqQP.Set("softRestart", strconv.FormatBool(*options.SoftRestart))
	}
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Update - Description for Creates or updates an App Service Plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - appServicePlan - Details of the App Service plan.
//   - options - PlansClientUpdateOptions contains the optional parameters for the PlansClient.Update method.
func (client *PlansClient) Update(ctx context.Context, resourceGroupName string, name string, appServicePlan PlanPatchResource, options *PlansClientUpdateOptions) (PlansClientUpdateResponse, error) {
	var err error
	const operationName = "PlansClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, name, appServicePlan, options)
	if err != nil {
		return PlansClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *PlansClient) updateCreateRequest(ctx context.Context, resourceGroupName string, name string, appServicePlan PlanPatchResource, options *PlansClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, appServicePlan); err != nil {
		return nil, err
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *PlansClient) updateHandleResponse(resp *http.Response) (PlansClientUpdateResponse, error) {
	result := PlansClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Plan); err != nil {
		return PlansClientUpdateResponse{}, err
	}
	return result, nil
}

// UpdateVnetGateway - Description for Update a Virtual Network gateway.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - gatewayName - Name of the gateway. Only the 'primary' gateway is supported.
//   - connectionEnvelope - Definition of the gateway.
//   - options - PlansClientUpdateVnetGatewayOptions contains the optional parameters for the PlansClient.UpdateVnetGateway method.
func (client *PlansClient) UpdateVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, options *PlansClientUpdateVnetGatewayOptions) (PlansClientUpdateVnetGatewayResponse, error) {
	var err error
	const operationName = "PlansClient.UpdateVnetGateway"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateVnetGatewayCreateRequest(ctx, resourceGroupName, name, vnetName, gatewayName, connectionEnvelope, options)
	if err != nil {
		return PlansClientUpdateVnetGatewayResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientUpdateVnetGatewayResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientUpdateVnetGatewayResponse{}, err
	}
	resp, err := client.updateVnetGatewayHandleResponse(httpResp)
	return resp, err
}

// updateVnetGatewayCreateRequest creates the UpdateVnetGateway request.
func (client *PlansClient) updateVnetGatewayCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope VnetGateway, options *PlansClientUpdateVnetGatewayOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if gatewayName == "" {
		return nil, errors.New("parameter gatewayName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{gatewayName}", url.PathEscape(gatewayName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, connectionEnvelope); err != nil {
		return nil, err
	}
	return req, nil
}

// updateVnetGatewayHandleResponse handles the UpdateVnetGateway response.
func (client *PlansClient) updateVnetGatewayHandleResponse(resp *http.Response) (PlansClientUpdateVnetGatewayResponse, error) {
	result := PlansClientUpdateVnetGatewayResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetGateway); err != nil {
		return PlansClientUpdateVnetGatewayResponse{}, err
	}
	return result, nil
}

// UpdateVnetRoute - Description for Create or update a Virtual Network route in an App Service plan.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-01-01
//   - resourceGroupName - Name of the resource group to which the resource belongs.
//   - name - Name of the App Service plan.
//   - vnetName - Name of the Virtual Network.
//   - routeName - Name of the Virtual Network route.
//   - route - Definition of the Virtual Network route.
//   - options - PlansClientUpdateVnetRouteOptions contains the optional parameters for the PlansClient.UpdateVnetRoute method.
func (client *PlansClient) UpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute, options *PlansClientUpdateVnetRouteOptions) (PlansClientUpdateVnetRouteResponse, error) {
	var err error
	const operationName = "PlansClient.UpdateVnetRoute"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateVnetRouteCreateRequest(ctx, resourceGroupName, name, vnetName, routeName, route, options)
	if err != nil {
		return PlansClientUpdateVnetRouteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return PlansClientUpdateVnetRouteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return PlansClientUpdateVnetRouteResponse{}, err
	}
	resp, err := client.updateVnetRouteHandleResponse(httpResp)
	return resp, err
}

// updateVnetRouteCreateRequest creates the UpdateVnetRoute request.
func (client *PlansClient) updateVnetRouteCreateRequest(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route VnetRoute, options *PlansClientUpdateVnetRouteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/serverfarms/{name}/virtualNetworkConnections/{vnetName}/routes/{routeName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if name == "" {
		return nil, errors.New("parameter name cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{name}", url.PathEscape(name))
	if vnetName == "" {
		return nil, errors.New("parameter vnetName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{vnetName}", url.PathEscape(vnetName))
	if routeName == "" {
		return nil, errors.New("parameter routeName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{routeName}", url.PathEscape(routeName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, route); err != nil {
		return nil, err
	}
	return req, nil
}

// updateVnetRouteHandleResponse handles the UpdateVnetRoute response.
func (client *PlansClient) updateVnetRouteHandleResponse(resp *http.Response) (PlansClientUpdateVnetRouteResponse, error) {
	result := PlansClientUpdateVnetRouteResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VnetRoute); err != nil {
		return PlansClientUpdateVnetRouteResponse{}, err
	}
	return result, nil
}
