//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// RoleManagementPolicyAssignmentsServer is a fake server for instances of the armauthorization.RoleManagementPolicyAssignmentsClient type.
type RoleManagementPolicyAssignmentsServer struct {
	// Create is the fake for method RoleManagementPolicyAssignmentsClient.Create
	// HTTP status codes to indicate success: http.StatusCreated
	Create func(ctx context.Context, scope string, roleManagementPolicyAssignmentName string, parameters armauthorization.RoleManagementPolicyAssignment, options *armauthorization.RoleManagementPolicyAssignmentsClientCreateOptions) (resp azfake.Responder[armauthorization.RoleManagementPolicyAssignmentsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method RoleManagementPolicyAssignmentsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, scope string, roleManagementPolicyAssignmentName string, options *armauthorization.RoleManagementPolicyAssignmentsClientDeleteOptions) (resp azfake.Responder[armauthorization.RoleManagementPolicyAssignmentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RoleManagementPolicyAssignmentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, scope string, roleManagementPolicyAssignmentName string, options *armauthorization.RoleManagementPolicyAssignmentsClientGetOptions) (resp azfake.Responder[armauthorization.RoleManagementPolicyAssignmentsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListForScopePager is the fake for method RoleManagementPolicyAssignmentsClient.NewListForScopePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForScopePager func(scope string, options *armauthorization.RoleManagementPolicyAssignmentsClientListForScopeOptions) (resp azfake.PagerResponder[armauthorization.RoleManagementPolicyAssignmentsClientListForScopeResponse])
}

// NewRoleManagementPolicyAssignmentsServerTransport creates a new instance of RoleManagementPolicyAssignmentsServerTransport with the provided implementation.
// The returned RoleManagementPolicyAssignmentsServerTransport instance is connected to an instance of armauthorization.RoleManagementPolicyAssignmentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRoleManagementPolicyAssignmentsServerTransport(srv *RoleManagementPolicyAssignmentsServer) *RoleManagementPolicyAssignmentsServerTransport {
	return &RoleManagementPolicyAssignmentsServerTransport{
		srv:                  srv,
		newListForScopePager: newTracker[azfake.PagerResponder[armauthorization.RoleManagementPolicyAssignmentsClientListForScopeResponse]](),
	}
}

// RoleManagementPolicyAssignmentsServerTransport connects instances of armauthorization.RoleManagementPolicyAssignmentsClient to instances of RoleManagementPolicyAssignmentsServer.
// Don't use this type directly, use NewRoleManagementPolicyAssignmentsServerTransport instead.
type RoleManagementPolicyAssignmentsServerTransport struct {
	srv                  *RoleManagementPolicyAssignmentsServer
	newListForScopePager *tracker[azfake.PagerResponder[armauthorization.RoleManagementPolicyAssignmentsClientListForScopeResponse]]
}

// Do implements the policy.Transporter interface for RoleManagementPolicyAssignmentsServerTransport.
func (r *RoleManagementPolicyAssignmentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RoleManagementPolicyAssignmentsClient.Create":
		resp, err = r.dispatchCreate(req)
	case "RoleManagementPolicyAssignmentsClient.Delete":
		resp, err = r.dispatchDelete(req)
	case "RoleManagementPolicyAssignmentsClient.Get":
		resp, err = r.dispatchGet(req)
	case "RoleManagementPolicyAssignmentsClient.NewListForScopePager":
		resp, err = r.dispatchNewListForScopePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RoleManagementPolicyAssignmentsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if r.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicyAssignments/(?P<roleManagementPolicyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armauthorization.RoleManagementPolicyAssignment](req)
	if err != nil {
		return nil, err
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	roleManagementPolicyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleManagementPolicyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Create(req.Context(), scopeParam, roleManagementPolicyAssignmentNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleManagementPolicyAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleManagementPolicyAssignmentsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if r.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicyAssignments/(?P<roleManagementPolicyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	roleManagementPolicyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleManagementPolicyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Delete(req.Context(), scopeParam, roleManagementPolicyAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleManagementPolicyAssignmentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicyAssignments/(?P<roleManagementPolicyAssignmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
	if err != nil {
		return nil, err
	}
	roleManagementPolicyAssignmentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleManagementPolicyAssignmentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), scopeParam, roleManagementPolicyAssignmentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleManagementPolicyAssignment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoleManagementPolicyAssignmentsServerTransport) dispatchNewListForScopePager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListForScopePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForScopePager not implemented")}
	}
	newListForScopePager := r.newListForScopePager.get(req)
	if newListForScopePager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/roleManagementPolicyAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListForScopePager(scopeParam, nil)
		newListForScopePager = &resp
		r.newListForScopePager.add(req, newListForScopePager)
		server.PagerResponderInjectNextLinks(newListForScopePager, req, func(page *armauthorization.RoleManagementPolicyAssignmentsClientListForScopeResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForScopePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListForScopePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForScopePager) {
		r.newListForScopePager.remove(req)
	}
	return resp, nil
}
