//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armavs

import "time"

// Addon - An addon resource
type Addon struct {
	// The properties of an addon resource
	Properties AddonPropertiesClassification

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// AddonArcProperties - The properties of an Arc addon
type AddonArcProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType

	// The VMware vCenter resource ID
	VCenter *string

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonArcProperties.
func (a *AddonArcProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonHcxProperties - The properties of an HCX addon
type AddonHcxProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType

	// REQUIRED; The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
	Offer *string

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonHcxProperties.
func (a *AddonHcxProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonList - A paged list of addons
type AddonList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*Addon
}

// AddonProperties - The properties of an addon
type AddonProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonProperties.
func (a *AddonProperties) GetAddonProperties() *AddonProperties { return a }

// AddonSrmProperties - The properties of a Site Recovery Manager (SRM) addon
type AddonSrmProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType

	// The Site Recovery Manager (SRM) license
	LicenseKey *string

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonSrmProperties.
func (a *AddonSrmProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AddonVrProperties - The properties of a vSphere Replication (VR) addon
type AddonVrProperties struct {
	// REQUIRED; The type of private cloud addon
	AddonType *AddonType

	// REQUIRED; The vSphere Replication Server (VRS) count
	VrsCount *int32

	// READ-ONLY; The state of the addon provisioning
	ProvisioningState *AddonProvisioningState
}

// GetAddonProperties implements the AddonPropertiesClassification interface for type AddonVrProperties.
func (a *AddonVrProperties) GetAddonProperties() *AddonProperties {
	return &AddonProperties{
		AddonType:         a.AddonType,
		ProvisioningState: a.ProvisioningState,
	}
}

// AdminCredentials - Administrative credentials for accessing vCenter and NSX-T
type AdminCredentials struct {
	// READ-ONLY; NSX-T Manager password
	NsxtPassword *string

	// READ-ONLY; NSX-T Manager username
	NsxtUsername *string

	// READ-ONLY; vCenter admin password
	VcenterPassword *string

	// READ-ONLY; vCenter admin username
	VcenterUsername *string
}

// AvailabilityProperties - The properties describing private cloud availability zone distribution
type AvailabilityProperties struct {
	// The secondary availability zone for the private cloud
	SecondaryZone *int32

	// The availability strategy for the private cloud
	Strategy *AvailabilityStrategy

	// The primary availability zone for the private cloud
	Zone *int32
}

// Circuit - An ExpressRoute Circuit
type Circuit struct {
	// READ-ONLY; Identifier of the ExpressRoute Circuit (Microsoft Colo only)
	ExpressRouteID *string

	// READ-ONLY; ExpressRoute Circuit private peering identifier
	ExpressRoutePrivatePeeringID *string

	// READ-ONLY; CIDR of primary subnet
	PrimarySubnet *string

	// READ-ONLY; CIDR of secondary subnet
	SecondarySubnet *string
}

// CloudLink - A cloud link resource
type CloudLink struct {
	// The properties of a cloud link.
	Properties *CloudLinkProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// CloudLinkList - A paged list of cloud links
type CloudLinkList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*CloudLink
}

// CloudLinkProperties - The properties of a cloud link.
type CloudLinkProperties struct {
	// Identifier of the other private cloud participating in the link.
	LinkedCloud *string

	// READ-ONLY; The state of the cloud link.
	Status *CloudLinkStatus
}

// Cluster - A cluster resource
type Cluster struct {
	// REQUIRED; The cluster SKU
	SKU *SKU

	// The properties of a cluster resource
	Properties *ClusterProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ClusterList - A paged list of clusters
type ClusterList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*Cluster
}

// ClusterProperties - The properties of a cluster
type ClusterProperties struct {
	// The cluster size
	ClusterSize *int32

	// The hosts
	Hosts []*string

	// READ-ONLY; The identity
	ClusterID *int32

	// READ-ONLY; The state of the cluster provisioning
	ProvisioningState *ClusterProvisioningState
}

// ClusterUpdate - An update of a cluster resource
type ClusterUpdate struct {
	// The properties of a cluster resource that may be updated
	Properties *ClusterUpdateProperties
}

// ClusterUpdateProperties - The properties of a cluster that may be updated
type ClusterUpdateProperties struct {
	// The cluster size
	ClusterSize *int32

	// The hosts
	Hosts []*string
}

// ClusterZone - Zone and associated hosts info
type ClusterZone struct {
	// READ-ONLY; List of hosts belonging to the availability zone in a cluster
	Hosts []*string

	// READ-ONLY; Availability zone identifier
	Zone *string
}

// ClusterZoneList - List of all zones and associated hosts for a cluster
type ClusterZoneList struct {
	// Zone and associated hosts info
	Zones []*ClusterZone
}

// Datastore - A datastore resource
type Datastore struct {
	// The properties of a datastore resource
	Properties *DatastoreProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// DatastoreList - A paged list of datastores
type DatastoreList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*Datastore
}

// DatastoreProperties - The properties of a datastore
type DatastoreProperties struct {
	// An iSCSI volume
	DiskPoolVolume *DiskPoolVolume

	// An Azure NetApp Files volume
	NetAppVolume *NetAppVolume

	// READ-ONLY; The state of the datastore provisioning
	ProvisioningState *DatastoreProvisioningState

	// READ-ONLY; The operational status of the datastore
	Status *DatastoreStatus
}

// DiskPoolVolume - An iSCSI volume from Microsoft.StoragePool provider
type DiskPoolVolume struct {
	// REQUIRED; Name of the LUN to be used for datastore
	LunName *string

	// REQUIRED; Azure resource ID of the iSCSI target
	TargetID *string

	// Mode that describes whether the LUN has to be mounted as a datastore or attached as a LUN
	MountOption *MountOptionEnum

	// READ-ONLY; Device path
	Path *string
}

// Encryption - The properties of customer managed encryption key
type Encryption struct {
	// The key vault where the encryption key is stored
	KeyVaultProperties *EncryptionKeyVaultProperties

	// Status of customer managed encryption key
	Status *EncryptionState
}

// EncryptionKeyVaultProperties - An Encryption Key
type EncryptionKeyVaultProperties struct {
	// The name of the key.
	KeyName *string

	// The URL of the vault.
	KeyVaultURL *string

	// The version of the key.
	KeyVersion *string

	// READ-ONLY; The auto-detected version of the key if versionType is auto-detected.
	AutoDetectedKeyVersion *string

	// READ-ONLY; The state of key provided
	KeyState *EncryptionKeyStatus

	// READ-ONLY; Property of the key if user provided or auto detected
	VersionType *EncryptionVersionType
}

// Endpoints - Endpoint addresses
type Endpoints struct {
	// READ-ONLY; Endpoint for the HCX Cloud Manager
	HcxCloudManager *string

	// READ-ONLY; Endpoint for the NSX-T Data Center manager
	NsxtManager *string

	// READ-ONLY; Endpoint for Virtual Center Server Appliance
	Vcsa *string
}

// ExpressRouteAuthorization - ExpressRoute Circuit Authorization
type ExpressRouteAuthorization struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The properties of an ExpressRoute Circuit Authorization resource
	Properties *ExpressRouteAuthorizationProperties

	// READ-ONLY; Resource type.
	Type *string
}

// ExpressRouteAuthorizationList - A paged list of ExpressRoute Circuit Authorizations
type ExpressRouteAuthorizationList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*ExpressRouteAuthorization
}

// ExpressRouteAuthorizationProperties - The properties of an ExpressRoute Circuit Authorization resource
type ExpressRouteAuthorizationProperties struct {
	// The ID of the ExpressRoute Circuit
	ExpressRouteID *string

	// READ-ONLY; The ID of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationID *string

	// READ-ONLY; The key of the ExpressRoute Circuit Authorization
	ExpressRouteAuthorizationKey *string

	// READ-ONLY; The state of the ExpressRoute Circuit Authorization provisioning
	ProvisioningState *ExpressRouteAuthorizationProvisioningState
}

// GlobalReachConnection - A global reach connection resource
type GlobalReachConnection struct {
	// The properties of a global reach connection resource
	Properties *GlobalReachConnectionProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// GlobalReachConnectionList - A paged list of global reach connections
type GlobalReachConnectionList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*GlobalReachConnection
}

// GlobalReachConnectionProperties - The properties of a global reach connection
type GlobalReachConnectionProperties struct {
	// Authorization key from the peer express route used for the global reach connection
	AuthorizationKey *string

	// The ID of the Private Cloud's ExpressRoute Circuit that is participating in the global reach connection
	ExpressRouteID *string

	// Identifier of the ExpressRoute Circuit to peer with in the global reach connection
	PeerExpressRouteCircuit *string

	// READ-ONLY; The network used for global reach carved out from the original network block provided for the private cloud
	AddressPrefix *string

	// READ-ONLY; The connection status of the global reach connection
	CircuitConnectionStatus *GlobalReachConnectionStatus

	// READ-ONLY; The state of the ExpressRoute Circuit Authorization provisioning
	ProvisioningState *GlobalReachConnectionProvisioningState
}

// HcxEnterpriseSite - An HCX Enterprise Site resource
type HcxEnterpriseSite struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; The properties of an HCX Enterprise Site resource
	Properties *HcxEnterpriseSiteProperties

	// READ-ONLY; Resource type.
	Type *string
}

// HcxEnterpriseSiteList - A paged list of HCX Enterprise Sites
type HcxEnterpriseSiteList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on a page
	Value []*HcxEnterpriseSite
}

// HcxEnterpriseSiteProperties - The properties of an HCX Enterprise Site
type HcxEnterpriseSiteProperties struct {
	// READ-ONLY; The activation key
	ActivationKey *string

	// READ-ONLY; The status of the HCX Enterprise Site
	Status *HcxEnterpriseSiteStatus
}

// IdentitySource - vCenter Single Sign On Identity Source
type IdentitySource struct {
	// The domain's NetBIOS name
	Alias *string

	// The base distinguished name for groups
	BaseGroupDN *string

	// The base distinguished name for users
	BaseUserDN *string

	// The domain's dns name
	Domain *string

	// The name of the identity source
	Name *string

	// The password of the Active Directory user with a minimum of read-only access to Base DN for users and groups.
	Password *string

	// Primary server URL
	PrimaryServer *string

	// Protect LDAP communication using SSL certificate (LDAPS)
	SSL *SSLEnum

	// Secondary server URL
	SecondaryServer *string

	// The ID of an Active Directory user with a minimum of read-only access to Base DN for users and group
	Username *string
}

// LogSpecification - Specifications of the Log for Azure Monitoring
type LogSpecification struct {
	// Blob duration of the log
	BlobDuration *string

	// Localized friendly display name of the log
	DisplayName *string

	// Name of the log
	Name *string
}

// ManagementCluster - The properties of a management cluster
type ManagementCluster struct {
	// The cluster size
	ClusterSize *int32

	// The hosts
	Hosts []*string

	// READ-ONLY; The identity
	ClusterID *int32

	// READ-ONLY; The state of the cluster provisioning
	ProvisioningState *ClusterProvisioningState
}

// MetricDimension - Specifications of the Dimension of metrics
type MetricDimension struct {
	// Localized friendly display name of the dimension
	DisplayName *string

	// Name of the dimension as it appears in MDM
	InternalName *string

	// Name of the dimension
	Name *string

	// A boolean flag indicating whether this dimension should be included for the shoebox export scenario
	ToBeExportedForShoebox *bool
}

// MetricSpecification - Specifications of the Metrics for Azure Monitoring
type MetricSpecification struct {
	// Only provide one value for this field. Valid values: Average, Minimum, Maximum, Total, Count.
	AggregationType *string

	// Name of the metric category that the metric belongs to. A metric can only belong to a single category.
	Category *string

	// Dimensions of the metric
	Dimensions []*MetricDimension

	// Localized friendly description of the metric
	DisplayDescription *string

	// Localized friendly display name of the metric
	DisplayName *string

	// Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *string

	// Optional. If set to true, then zero will be returned for time duration where no metric is emitted/published.
	FillGapWithZero *bool

	// Name of the metric
	Name *string

	// The name of the MDM account.
	SourceMdmAccount *string

	// The name of the MDM namespace.
	SourceMdmNamespace *string

	// Supported aggregation types
	SupportedAggregationTypes []*string

	// Supported time grain types
	SupportedTimeGrainTypes []*string

	// Unit that makes sense for the metric
	Unit *string
}

// NetAppVolume - An Azure NetApp Files volume from Microsoft.NetApp provider
type NetAppVolume struct {
	// REQUIRED; Azure resource ID of the NetApp volume
	ID *string
}

// Operation - A REST API operation
type Operation struct {
	// Gets or sets a value indicating whether the operation is a data action or not
	IsDataAction *bool

	// Origin of the operation
	Origin *string

	// Properties of the operation
	Properties *OperationProperties

	// READ-ONLY; Contains the localized display information for this operation
	Display *OperationDisplay

	// READ-ONLY; Name of the operation being performed on this object
	Name *string
}

// OperationDisplay - Contains the localized display information for this operation
type OperationDisplay struct {
	// READ-ONLY; Localized friendly description for the operation
	Description *string

	// READ-ONLY; Localized friendly name for the operation
	Operation *string

	// READ-ONLY; Localized friendly form of the resource provider name
	Provider *string

	// READ-ONLY; Localized friendly form of the resource type related to this operation
	Resource *string
}

// OperationList - Pageable list of operations
type OperationList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; List of operations
	Value []*Operation
}

// OperationProperties - Extra Operation properties
type OperationProperties struct {
	// Service specifications of the operation
	ServiceSpecification *ServiceSpecification
}

// PSCredentialExecutionParameter - a powershell credential object
type PSCredentialExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType

	// password for login
	Password *string

	// username for login
	Username *string
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type PSCredentialExecutionParameter.
func (p *PSCredentialExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter {
	return &ScriptExecutionParameter{
		Name: p.Name,
		Type: p.Type,
	}
}

// PlacementPoliciesList - Represents list of placement policies
type PlacementPoliciesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*PlacementPolicy
}

// PlacementPolicy - A vSphere Distributed Resource Scheduler (DRS) placement policy
type PlacementPolicy struct {
	// placement policy properties
	Properties PlacementPolicyPropertiesClassification

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PlacementPolicyProperties - Abstract placement policy properties
type PlacementPolicyProperties struct {
	// REQUIRED; placement policy type
	Type *PlacementPolicyType

	// Display name of the placement policy
	DisplayName *string

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState

	// READ-ONLY; The provisioning state
	ProvisioningState *PlacementPolicyProvisioningState
}

// GetPlacementPolicyProperties implements the PlacementPolicyPropertiesClassification interface for type PlacementPolicyProperties.
func (p *PlacementPolicyProperties) GetPlacementPolicyProperties() *PlacementPolicyProperties {
	return p
}

// PlacementPolicyUpdate - An update of a DRS placement policy resource
type PlacementPolicyUpdate struct {
	// The properties of a placement policy resource that may be updated
	Properties *PlacementPolicyUpdateProperties
}

// PlacementPolicyUpdateProperties - The properties of a placement policy resource that may be updated
type PlacementPolicyUpdateProperties struct {
	// vm-host placement policy affinity strength (should/must)
	AffinityStrength *AffinityStrength

	// placement policy azure hybrid benefit opt-in type
	AzureHybridBenefitType *AzureHybridBenefitType

	// Host members list
	HostMembers []*string

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState

	// Virtual machine members list
	VMMembers []*string
}

// PrivateCloud - A private cloud resource
type PrivateCloud struct {
	// REQUIRED; The private cloud SKU
	SKU *SKU

	// The identity of the private cloud, if configured.
	Identity *PrivateCloudIdentity

	// Resource location
	Location *string

	// The properties of a private cloud resource
	Properties *PrivateCloudProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// PrivateCloudIdentity - Identity for the virtual machine.
type PrivateCloudIdentity struct {
	// The type of identity used for the private cloud. The type 'SystemAssigned' refers to an implicitly created identity. The
	// type 'None' will remove any identities from the Private Cloud.
	Type *ResourceIdentityType

	// READ-ONLY; The principal ID of private cloud identity. This property will only be provided for a system assigned identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID associated with the private cloud. This property will only be provided for a system assigned identity.
	TenantID *string
}

// PrivateCloudList - A paged list of private clouds
type PrivateCloudList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*PrivateCloud
}

// PrivateCloudProperties - The properties of a private cloud resource
type PrivateCloudProperties struct {
	// REQUIRED; The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the
	// CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is
	// between 0 and 22
	NetworkBlock *string

	// Properties describing how the cloud is distributed across availability zones
	Availability *AvailabilityProperties

	// An ExpressRoute Circuit
	Circuit *Circuit

	// Customer managed key encryption, can be enabled or disabled
	Encryption *Encryption

	// Array of additional networks noncontiguous with networkBlock. Networks must be unique and non-overlapping across VNet in
	// your subscription, on-premise, and this privateCloud networkBlock attribute.
	// Make sure the CIDR format conforms to (A.B.C.D/X).
	ExtendedNetworkBlocks []*string

	// vCenter Single Sign On Identity Sources
	IdentitySources []*IdentitySource

	// Connectivity to internet is enabled or disabled
	Internet *InternetEnum

	// The default cluster used for management
	ManagementCluster *ManagementCluster

	// Optionally, set the NSX-T Manager password when the private cloud is created
	NsxtPassword *string

	// A secondary expressRoute circuit from a separate AZ. Only present in a stretched private cloud
	SecondaryCircuit *Circuit

	// Optionally, set the vCenter admin password when the private cloud is created
	VcenterPassword *string

	// READ-ONLY; The endpoints
	Endpoints *Endpoints

	// READ-ONLY; Array of cloud link IDs from other clouds that connect to this one
	ExternalCloudLinks []*string

	// READ-ONLY; Network used to access vCenter Server and NSX-T Manager
	ManagementNetwork *string

	// READ-ONLY; Flag to indicate whether the private cloud has the quota for provisioned NSX Public IP count raised from 64
	// to 1024
	NsxPublicIPQuotaRaised *NsxPublicIPQuotaRaisedEnum

	// READ-ONLY; Thumbprint of the NSX-T Manager SSL certificate
	NsxtCertificateThumbprint *string

	// READ-ONLY; Used for virtual machine cold migration, cloning, and snapshot migration
	ProvisioningNetwork *string

	// READ-ONLY; The provisioning state
	ProvisioningState *PrivateCloudProvisioningState

	// READ-ONLY; Thumbprint of the vCenter Server SSL certificate
	VcenterCertificateThumbprint *string

	// READ-ONLY; Used for live migration of virtual machines
	VmotionNetwork *string
}

// PrivateCloudUpdate - An update to a private cloud resource
type PrivateCloudUpdate struct {
	// The identity of the private cloud, if configured.
	Identity *PrivateCloudIdentity

	// The updatable properties of a private cloud resource
	Properties *PrivateCloudUpdateProperties

	// Resource tags
	Tags map[string]*string
}

// PrivateCloudUpdateProperties - The properties of a private cloud resource that may be updated
type PrivateCloudUpdateProperties struct {
	// Properties describing how the cloud is distributed across availability zones
	Availability *AvailabilityProperties

	// Customer managed key encryption, can be enabled or disabled
	Encryption *Encryption

	// Array of additional networks noncontiguous with networkBlock. Networks must be unique and non-overlapping across VNet in
	// your subscription, on-premise, and this privateCloud networkBlock attribute.
	// Make sure the CIDR format conforms to (A.B.C.D/X).
	ExtendedNetworkBlocks []*string

	// vCenter Single Sign On Identity Sources
	IdentitySources []*IdentitySource

	// Connectivity to internet is enabled or disabled
	Internet *InternetEnum

	// The default cluster used for management
	ManagementCluster *ManagementCluster
}

// Quota - Subscription quotas
type Quota struct {
	// READ-ONLY; Remaining hosts quota by sku type
	HostsRemaining map[string]*int32

	// READ-ONLY; Host quota is active for current subscription
	QuotaEnabled *QuotaEnabled
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU.
	Name *string
}

// ScriptCmdlet - A cmdlet available for script execution
type ScriptCmdlet struct {
	// The properties of a script cmdlet resource
	Properties *ScriptCmdletProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ScriptCmdletProperties - Properties of a pre-canned script
type ScriptCmdletProperties struct {
	// READ-ONLY; Description of the scripts functionality
	Description *string

	// READ-ONLY; Parameters the script will accept
	Parameters []*ScriptParameter

	// READ-ONLY; Recommended time limit for execution
	Timeout *string
}

// ScriptCmdletsList - Pageable list of scripts/cmdlets
type ScriptCmdletsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; List of scripts
	Value []*ScriptCmdlet
}

// ScriptExecution - An instance of a script executed by a user - custom or AVS
type ScriptExecution struct {
	// The properties of a script execution resource
	Properties *ScriptExecutionProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ScriptExecutionParameter - The arguments passed in to the execution
type ScriptExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type ScriptExecutionParameter.
func (s *ScriptExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter { return s }

// ScriptExecutionProperties - Properties of a user-invoked script
type ScriptExecutionProperties struct {
	// REQUIRED; Time limit for execution
	Timeout *string

	// Error message if the script was able to run, but if the script itself had errors or powershell threw an exception
	FailureReason *string

	// Parameters that will be hidden/not visible to ARM, such as passwords and credentials
	HiddenParameters []ScriptExecutionParameterClassification

	// User-defined dictionary.
	NamedOutputs map[string]any

	// Standard output stream from the powershell execution
	Output []*string

	// Parameters the script will accept
	Parameters []ScriptExecutionParameterClassification

	// Time to live for the resource. If not provided, will be available for 60 days
	Retention *string

	// A reference to the script cmdlet resource if user is running a AVS script
	ScriptCmdletID *string

	// READ-ONLY; Standard error output stream from the powershell execution
	Errors []*string

	// READ-ONLY; Time the script execution was finished
	FinishedAt *time.Time

	// READ-ONLY; Standard information out stream from the powershell execution
	Information []*string

	// READ-ONLY; The state of the script execution resource
	ProvisioningState *ScriptExecutionProvisioningState

	// READ-ONLY; Time the script execution was started
	StartedAt *time.Time

	// READ-ONLY; Time the script execution was submitted
	SubmittedAt *time.Time

	// READ-ONLY; Standard warning out stream from the powershell execution
	Warnings []*string
}

// ScriptExecutionsList - Pageable list of script executions
type ScriptExecutionsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; List of scripts
	Value []*ScriptExecution
}

// ScriptPackage - Script Package resources available for execution
type ScriptPackage struct {
	// ScriptPackage resource properties
	Properties *ScriptPackageProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// ScriptPackageProperties - Properties of a Script Package subresource
type ScriptPackageProperties struct {
	// READ-ONLY; Company that created and supports the package
	Company *string

	// READ-ONLY; User friendly description of the package
	Description *string

	// READ-ONLY; Link to support by the package vendor
	URI *string

	// READ-ONLY; Module version
	Version *string
}

// ScriptPackagesList - A list of the available script packages
type ScriptPackagesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; List of script package resources
	Value []*ScriptPackage
}

// ScriptParameter - An parameter that the script will accept
type ScriptParameter struct {
	// The parameter name that the script will expect a parameter value for
	Name *string

	// READ-ONLY; User friendly description of the parameter
	Description *string

	// READ-ONLY; Is this parameter required or optional
	Optional *OptionalParamEnum

	// READ-ONLY; The type of parameter the script is expecting. psCredential is a PSCredentialObject
	Type *ScriptParameterTypes

	// READ-ONLY; Should this parameter be visible to arm and passed in the parameters argument when executing
	Visibility *VisibilityParameterEnum
}

// ScriptSecureStringExecutionParameter - a plain text value execution parameter
type ScriptSecureStringExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType

	// A secure value for the passed parameter, not to be stored in logs
	SecureValue *string
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type ScriptSecureStringExecutionParameter.
func (s *ScriptSecureStringExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter {
	return &ScriptExecutionParameter{
		Name: s.Name,
		Type: s.Type,
	}
}

// ScriptStringExecutionParameter - a plain text value execution parameter
type ScriptStringExecutionParameter struct {
	// REQUIRED; The parameter name
	Name *string

	// REQUIRED; The type of execution parameter
	Type *ScriptExecutionParameterType

	// The value for the passed parameter
	Value *string
}

// GetScriptExecutionParameter implements the ScriptExecutionParameterClassification interface for type ScriptStringExecutionParameter.
func (s *ScriptStringExecutionParameter) GetScriptExecutionParameter() *ScriptExecutionParameter {
	return &ScriptExecutionParameter{
		Name: s.Name,
		Type: s.Type,
	}
}

// ServiceSpecification - Service specification payload
type ServiceSpecification struct {
	// Specifications of the Log for Azure Monitoring
	LogSpecifications []*LogSpecification

	// Specifications of the Metrics for Azure Monitoring
	MetricSpecifications []*MetricSpecification
}

// Trial - Subscription trial availability
type Trial struct {
	// READ-ONLY; Number of trial hosts available
	AvailableHosts *int32

	// READ-ONLY; Trial status
	Status *TrialStatus
}

// VMHostPlacementPolicyProperties - VM-Host placement policy properties
type VMHostPlacementPolicyProperties struct {
	// REQUIRED; placement policy affinity type
	AffinityType *AffinityType

	// REQUIRED; Host members list
	HostMembers []*string

	// REQUIRED; placement policy type
	Type *PlacementPolicyType

	// REQUIRED; Virtual machine members list
	VMMembers []*string

	// vm-host placement policy affinity strength (should/must)
	AffinityStrength *AffinityStrength

	// placement policy azure hybrid benefit opt-in type
	AzureHybridBenefitType *AzureHybridBenefitType

	// Display name of the placement policy
	DisplayName *string

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState

	// READ-ONLY; The provisioning state
	ProvisioningState *PlacementPolicyProvisioningState
}

// GetPlacementPolicyProperties implements the PlacementPolicyPropertiesClassification interface for type VMHostPlacementPolicyProperties.
func (v *VMHostPlacementPolicyProperties) GetPlacementPolicyProperties() *PlacementPolicyProperties {
	return &PlacementPolicyProperties{
		DisplayName:       v.DisplayName,
		ProvisioningState: v.ProvisioningState,
		State:             v.State,
		Type:              v.Type,
	}
}

// VMPlacementPolicyProperties - VM-VM placement policy properties
type VMPlacementPolicyProperties struct {
	// REQUIRED; placement policy affinity type
	AffinityType *AffinityType

	// REQUIRED; placement policy type
	Type *PlacementPolicyType

	// REQUIRED; Virtual machine members list
	VMMembers []*string

	// Display name of the placement policy
	DisplayName *string

	// Whether the placement policy is enabled or disabled
	State *PlacementPolicyState

	// READ-ONLY; The provisioning state
	ProvisioningState *PlacementPolicyProvisioningState
}

// GetPlacementPolicyProperties implements the PlacementPolicyPropertiesClassification interface for type VMPlacementPolicyProperties.
func (v *VMPlacementPolicyProperties) GetPlacementPolicyProperties() *PlacementPolicyProperties {
	return &PlacementPolicyProperties{
		DisplayName:       v.DisplayName,
		ProvisioningState: v.ProvisioningState,
		State:             v.State,
		Type:              v.Type,
	}
}

// VirtualMachine - Virtual Machine
type VirtualMachine struct {
	// Virtual machine properties.
	Properties *VirtualMachineProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// VirtualMachineProperties - Virtual Machine Properties
type VirtualMachineProperties struct {
	// READ-ONLY; Display name of the VM.
	DisplayName *string

	// READ-ONLY; Path to virtual machine's folder starting from datacenter virtual machine folder
	FolderPath *string

	// READ-ONLY; Virtual machine managed object reference id
	MoRefID *string

	// READ-ONLY; Whether VM DRS-driven movement is restricted (enabled) or not (disabled)
	RestrictMovement *VirtualMachineRestrictMovementState
}

// VirtualMachineRestrictMovement - Set VM DRS-driven movement to restricted (enabled) or not (disabled)
type VirtualMachineRestrictMovement struct {
	// Whether VM DRS-driven movement is restricted (enabled) or not (disabled)
	RestrictMovement *VirtualMachineRestrictMovementState
}

// VirtualMachinesList - A list of Virtual Machines
type VirtualMachinesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items to be displayed on the page
	Value []*VirtualMachine
}

// WorkloadNetwork - Workload Network
type WorkloadNetwork struct {
	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkDNSService - NSX DNS Service
type WorkloadNetworkDNSService struct {
	// DNS Service properties
	Properties *WorkloadNetworkDNSServiceProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkDNSServiceProperties - NSX DNS Service Properties
type WorkloadNetworkDNSServiceProperties struct {
	// DNS service IP of the DNS Service.
	DNSServiceIP *string

	// Default DNS zone of the DNS Service.
	DefaultDNSZone *string

	// Display name of the DNS Service.
	DisplayName *string

	// FQDN zones of the DNS Service.
	FqdnZones []*string

	// DNS Service log level.
	LogLevel *DNSServiceLogLevelEnum

	// NSX revision number.
	Revision *int64

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDNSServiceProvisioningState

	// READ-ONLY; DNS Service status.
	Status *DNSServiceStatusEnum
}

// WorkloadNetworkDNSServicesList - A list of NSX DNS Services
type WorkloadNetworkDNSServicesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkDNSService
}

// WorkloadNetworkDNSZone - NSX DNS Zone
type WorkloadNetworkDNSZone struct {
	// DNS Zone properties
	Properties *WorkloadNetworkDNSZoneProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkDNSZoneProperties - NSX DNS Zone Properties
type WorkloadNetworkDNSZoneProperties struct {
	// DNS Server IP array of the DNS Zone.
	DNSServerIPs []*string

	// Number of DNS Services using the DNS zone.
	DNSServices *int64

	// Display name of the DNS Zone.
	DisplayName *string

	// Domain names of the DNS Zone.
	Domain []*string

	// NSX revision number.
	Revision *int64

	// Source IP of the DNS Zone.
	SourceIP *string

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDNSZoneProvisioningState
}

// WorkloadNetworkDNSZonesList - A list of NSX DNS Zones
type WorkloadNetworkDNSZonesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkDNSZone
}

// WorkloadNetworkDhcp - NSX DHCP
type WorkloadNetworkDhcp struct {
	// DHCP properties.
	Properties WorkloadNetworkDhcpEntityClassification

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkDhcpEntity - Base class for WorkloadNetworkDhcpServer and WorkloadNetworkDhcpRelay to inherit from
type WorkloadNetworkDhcpEntity struct {
	// REQUIRED; Type of DHCP: SERVER or RELAY.
	DhcpType *DhcpTypeEnum

	// Display name of the DHCP entity.
	DisplayName *string

	// NSX revision number.
	Revision *int64

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDhcpProvisioningState

	// READ-ONLY; NSX Segments consuming DHCP.
	Segments []*string
}

// GetWorkloadNetworkDhcpEntity implements the WorkloadNetworkDhcpEntityClassification interface for type WorkloadNetworkDhcpEntity.
func (w *WorkloadNetworkDhcpEntity) GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity {
	return w
}

// WorkloadNetworkDhcpList - A list of NSX dhcp entities
type WorkloadNetworkDhcpList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkDhcp
}

// WorkloadNetworkDhcpRelay - NSX DHCP Relay
type WorkloadNetworkDhcpRelay struct {
	// REQUIRED; Type of DHCP: SERVER or RELAY.
	DhcpType *DhcpTypeEnum

	// Display name of the DHCP entity.
	DisplayName *string

	// NSX revision number.
	Revision *int64

	// DHCP Relay Addresses. Max 3.
	ServerAddresses []*string

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDhcpProvisioningState

	// READ-ONLY; NSX Segments consuming DHCP.
	Segments []*string
}

// GetWorkloadNetworkDhcpEntity implements the WorkloadNetworkDhcpEntityClassification interface for type WorkloadNetworkDhcpRelay.
func (w *WorkloadNetworkDhcpRelay) GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity {
	return &WorkloadNetworkDhcpEntity{
		DhcpType:          w.DhcpType,
		DisplayName:       w.DisplayName,
		ProvisioningState: w.ProvisioningState,
		Revision:          w.Revision,
		Segments:          w.Segments,
	}
}

// WorkloadNetworkDhcpServer - NSX DHCP Server
type WorkloadNetworkDhcpServer struct {
	// REQUIRED; Type of DHCP: SERVER or RELAY.
	DhcpType *DhcpTypeEnum

	// Display name of the DHCP entity.
	DisplayName *string

	// DHCP Server Lease Time.
	LeaseTime *int64

	// NSX revision number.
	Revision *int64

	// DHCP Server Address.
	ServerAddress *string

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkDhcpProvisioningState

	// READ-ONLY; NSX Segments consuming DHCP.
	Segments []*string
}

// GetWorkloadNetworkDhcpEntity implements the WorkloadNetworkDhcpEntityClassification interface for type WorkloadNetworkDhcpServer.
func (w *WorkloadNetworkDhcpServer) GetWorkloadNetworkDhcpEntity() *WorkloadNetworkDhcpEntity {
	return &WorkloadNetworkDhcpEntity{
		DhcpType:          w.DhcpType,
		DisplayName:       w.DisplayName,
		ProvisioningState: w.ProvisioningState,
		Revision:          w.Revision,
		Segments:          w.Segments,
	}
}

// WorkloadNetworkGateway - NSX Gateway.
type WorkloadNetworkGateway struct {
	// Gateway properties.
	Properties *WorkloadNetworkGatewayProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkGatewayList - A list of NSX Gateways
type WorkloadNetworkGatewayList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkGateway
}

// WorkloadNetworkGatewayProperties - Properties of a NSX Gateway.
type WorkloadNetworkGatewayProperties struct {
	// Display name of the DHCP entity.
	DisplayName *string

	// READ-ONLY; NSX Gateway Path.
	Path *string
}

// WorkloadNetworkList - A list of workload networks
type WorkloadNetworkList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetwork
}

// WorkloadNetworkPortMirroring - NSX Port Mirroring
type WorkloadNetworkPortMirroring struct {
	// Port Mirroring Properties.
	Properties *WorkloadNetworkPortMirroringProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkPortMirroringList - A list of NSX Port Mirroring
type WorkloadNetworkPortMirroringList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkPortMirroring
}

// WorkloadNetworkPortMirroringProperties - NSX Port Mirroring Properties
type WorkloadNetworkPortMirroringProperties struct {
	// Destination VM Group.
	Destination *string

	// Direction of port mirroring profile.
	Direction *PortMirroringDirectionEnum

	// Display name of the port mirroring profile.
	DisplayName *string

	// NSX revision number.
	Revision *int64

	// Source VM Group.
	Source *string

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkPortMirroringProvisioningState

	// READ-ONLY; Port Mirroring Status.
	Status *PortMirroringStatusEnum
}

// WorkloadNetworkPublicIP - NSX Public IP Block
type WorkloadNetworkPublicIP struct {
	// Public IP Block properties
	Properties *WorkloadNetworkPublicIPProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkPublicIPProperties - NSX Public IP Block Properties
type WorkloadNetworkPublicIPProperties struct {
	// Display name of the Public IP Block.
	DisplayName *string

	// Number of Public IPs requested.
	NumberOfPublicIPs *int64

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkPublicIPProvisioningState

	// READ-ONLY; CIDR Block of the Public IP Block.
	PublicIPBlock *string
}

// WorkloadNetworkPublicIPsList - A list of NSX Public IP Blocks
type WorkloadNetworkPublicIPsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkPublicIP
}

// WorkloadNetworkSegment - NSX Segment
type WorkloadNetworkSegment struct {
	// The properties of a Workload Segment proxy resource.
	Properties *WorkloadNetworkSegmentProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkSegmentPortVif - Ports and any VIF attached to segment.
type WorkloadNetworkSegmentPortVif struct {
	// Name of port or VIF attached to segment.
	PortName *string
}

// WorkloadNetworkSegmentProperties - NSX Segment Properties
type WorkloadNetworkSegmentProperties struct {
	// Gateway which to connect segment to.
	ConnectedGateway *string

	// Display name of the segment.
	DisplayName *string

	// NSX revision number.
	Revision *int64

	// Subnet which to connect segment to.
	Subnet *WorkloadNetworkSegmentSubnet

	// READ-ONLY; Port Vif which segment is associated with.
	PortVif []*WorkloadNetworkSegmentPortVif

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkSegmentProvisioningState

	// READ-ONLY; Segment status.
	Status *SegmentStatusEnum
}

// WorkloadNetworkSegmentSubnet - Subnet configuration for segment
type WorkloadNetworkSegmentSubnet struct {
	// DHCP Range assigned for subnet.
	DhcpRanges []*string

	// Gateway address.
	GatewayAddress *string
}

// WorkloadNetworkSegmentsList - A list of NSX Segments
type WorkloadNetworkSegmentsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkSegment
}

// WorkloadNetworkVMGroup - NSX VM Group
type WorkloadNetworkVMGroup struct {
	// VM Group properties.
	Properties *WorkloadNetworkVMGroupProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkVMGroupProperties - NSX VM Group Properties
type WorkloadNetworkVMGroupProperties struct {
	// Display name of the VM group.
	DisplayName *string

	// Virtual machine members of this group.
	Members []*string

	// NSX revision number.
	Revision *int64

	// READ-ONLY; The provisioning state
	ProvisioningState *WorkloadNetworkVMGroupProvisioningState

	// READ-ONLY; VM Group status.
	Status *VMGroupStatusEnum
}

// WorkloadNetworkVMGroupsList - A list of NSX VM Groups
type WorkloadNetworkVMGroupsList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkVMGroup
}

// WorkloadNetworkVirtualMachine - NSX Virtual Machine
type WorkloadNetworkVirtualMachine struct {
	// Virtual machine properties.
	Properties *WorkloadNetworkVirtualMachineProperties

	// READ-ONLY; Resource ID.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// WorkloadNetworkVirtualMachineProperties - NSX Virtual Machine Properties
type WorkloadNetworkVirtualMachineProperties struct {
	// Display name of the VM.
	DisplayName *string

	// READ-ONLY; Virtual machine type.
	VMType *VMTypeEnum
}

// WorkloadNetworkVirtualMachinesList - A list of NSX Virtual Machines
type WorkloadNetworkVirtualMachinesList struct {
	// READ-ONLY; URL to get the next page if any
	NextLink *string

	// READ-ONLY; The items on the page
	Value []*WorkloadNetworkVirtualMachine
}
