//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/billingbenefits/armbillingbenefits/v2"
	"net/http"
	"net/url"
	"regexp"
)

// SavingsPlanOrderServer is a fake server for instances of the armbillingbenefits.SavingsPlanOrderClient type.
type SavingsPlanOrderServer struct {
	// Elevate is the fake for method SavingsPlanOrderClient.Elevate
	// HTTP status codes to indicate success: http.StatusOK
	Elevate func(ctx context.Context, savingsPlanOrderID string, options *armbillingbenefits.SavingsPlanOrderClientElevateOptions) (resp azfake.Responder[armbillingbenefits.SavingsPlanOrderClientElevateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SavingsPlanOrderClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, savingsPlanOrderID string, options *armbillingbenefits.SavingsPlanOrderClientGetOptions) (resp azfake.Responder[armbillingbenefits.SavingsPlanOrderClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method SavingsPlanOrderClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armbillingbenefits.SavingsPlanOrderClientListOptions) (resp azfake.PagerResponder[armbillingbenefits.SavingsPlanOrderClientListResponse])
}

// NewSavingsPlanOrderServerTransport creates a new instance of SavingsPlanOrderServerTransport with the provided implementation.
// The returned SavingsPlanOrderServerTransport instance is connected to an instance of armbillingbenefits.SavingsPlanOrderClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSavingsPlanOrderServerTransport(srv *SavingsPlanOrderServer) *SavingsPlanOrderServerTransport {
	return &SavingsPlanOrderServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armbillingbenefits.SavingsPlanOrderClientListResponse]](),
	}
}

// SavingsPlanOrderServerTransport connects instances of armbillingbenefits.SavingsPlanOrderClient to instances of SavingsPlanOrderServer.
// Don't use this type directly, use NewSavingsPlanOrderServerTransport instead.
type SavingsPlanOrderServerTransport struct {
	srv          *SavingsPlanOrderServer
	newListPager *tracker[azfake.PagerResponder[armbillingbenefits.SavingsPlanOrderClientListResponse]]
}

// Do implements the policy.Transporter interface for SavingsPlanOrderServerTransport.
func (s *SavingsPlanOrderServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SavingsPlanOrderClient.Elevate":
		resp, err = s.dispatchElevate(req)
	case "SavingsPlanOrderClient.Get":
		resp, err = s.dispatchGet(req)
	case "SavingsPlanOrderClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SavingsPlanOrderServerTransport) dispatchElevate(req *http.Request) (*http.Response, error) {
	if s.srv.Elevate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Elevate not implemented")}
	}
	const regexStr = `/providers/Microsoft\.BillingBenefits/savingsPlanOrders/(?P<savingsPlanOrderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/elevate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	savingsPlanOrderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("savingsPlanOrderId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Elevate(req.Context(), savingsPlanOrderIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoleAssignmentEntity, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SavingsPlanOrderServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.BillingBenefits/savingsPlanOrders/(?P<savingsPlanOrderId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	savingsPlanOrderIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("savingsPlanOrderId")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armbillingbenefits.SavingsPlanOrderClientGetOptions
	if expandParam != nil {
		options = &armbillingbenefits.SavingsPlanOrderClientGetOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := s.srv.Get(req.Context(), savingsPlanOrderIDParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SavingsPlanOrderModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SavingsPlanOrderServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		resp := s.srv.NewListPager(nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armbillingbenefits.SavingsPlanOrderClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
