//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerregistry

import "encoding/json"

func unmarshalRunRequestClassification(rawMsg json.RawMessage) (RunRequestClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b RunRequestClassification
	switch m["type"] {
	case "DockerBuildRequest":
		b = &DockerBuildRequest{}
	case "EncodedTaskRunRequest":
		b = &EncodedTaskRunRequest{}
	case "FileTaskRunRequest":
		b = &FileTaskRunRequest{}
	case "TaskRunRequest":
		b = &TaskRunRequest{}
	default:
		b = &RunRequest{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalTaskStepPropertiesClassification(rawMsg json.RawMessage) (TaskStepPropertiesClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b TaskStepPropertiesClassification
	switch m["type"] {
	case string(StepTypeDocker):
		b = &DockerBuildStep{}
	case string(StepTypeEncodedTask):
		b = &EncodedTaskStep{}
	case string(StepTypeFileTask):
		b = &FileTaskStep{}
	default:
		b = &TaskStepProperties{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}

func unmarshalTaskStepUpdateParametersClassification(rawMsg json.RawMessage) (TaskStepUpdateParametersClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]any
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b TaskStepUpdateParametersClassification
	switch m["type"] {
	case string(StepTypeDocker):
		b = &DockerBuildStepUpdateParameters{}
	case string(StepTypeEncodedTask):
		b = &EncodedTaskStepUpdateParameters{}
	case string(StepTypeFileTask):
		b = &FileTaskStepUpdateParameters{}
	default:
		b = &TaskStepUpdateParameters{}
	}
	if err := json.Unmarshal(rawMsg, b); err != nil {
		return nil, err
	}
	return b, nil
}
