//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// SQLResourcesServer is a fake server for instances of the armcosmos.SQLResourcesClient type.
type SQLResourcesServer struct {
	// BeginCreateUpdateClientEncryptionKey is the fake for method SQLResourcesClient.BeginCreateUpdateClientEncryptionKey
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateClientEncryptionKey func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, clientEncryptionKeyName string, createUpdateClientEncryptionKeyParameters armcosmos.ClientEncryptionKeyCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateClientEncryptionKeyOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateClientEncryptionKeyResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLContainer is the fake for method SQLResourcesClient.BeginCreateUpdateSQLContainer
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLContainer func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, createUpdateSQLContainerParameters armcosmos.SQLContainerCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLContainerOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLContainerResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLDatabase is the fake for method SQLResourcesClient.BeginCreateUpdateSQLDatabase
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateSQLDatabaseParameters armcosmos.SQLDatabaseCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLDatabaseOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLDatabaseResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLRoleAssignment is the fake for method SQLResourcesClient.BeginCreateUpdateSQLRoleAssignment
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLRoleAssignment func(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string, createUpdateSQLRoleAssignmentParameters armcosmos.SQLRoleAssignmentCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLRoleAssignmentOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLRoleAssignmentResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLRoleDefinition is the fake for method SQLResourcesClient.BeginCreateUpdateSQLRoleDefinition
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLRoleDefinition func(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string, createUpdateSQLRoleDefinitionParameters armcosmos.SQLRoleDefinitionCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLRoleDefinitionOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLRoleDefinitionResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLStoredProcedure is the fake for method SQLResourcesClient.BeginCreateUpdateSQLStoredProcedure
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLStoredProcedure func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string, createUpdateSQLStoredProcedureParameters armcosmos.SQLStoredProcedureCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLStoredProcedureOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLStoredProcedureResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLTrigger is the fake for method SQLResourcesClient.BeginCreateUpdateSQLTrigger
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLTrigger func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string, createUpdateSQLTriggerParameters armcosmos.SQLTriggerCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLTriggerOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLTriggerResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateSQLUserDefinedFunction is the fake for method SQLResourcesClient.BeginCreateUpdateSQLUserDefinedFunction
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateSQLUserDefinedFunction func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string, createUpdateSQLUserDefinedFunctionParameters armcosmos.SQLUserDefinedFunctionCreateUpdateParameters, options *armcosmos.SQLResourcesClientBeginCreateUpdateSQLUserDefinedFunctionOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLUserDefinedFunctionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLContainer is the fake for method SQLResourcesClient.BeginDeleteSQLContainer
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLContainer func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLContainerOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLContainerResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLDatabase is the fake for method SQLResourcesClient.BeginDeleteSQLDatabase
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLDatabaseOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLDatabaseResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLRoleAssignment is the fake for method SQLResourcesClient.BeginDeleteSQLRoleAssignment
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLRoleAssignment func(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLRoleAssignmentOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLRoleAssignmentResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLRoleDefinition is the fake for method SQLResourcesClient.BeginDeleteSQLRoleDefinition
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLRoleDefinition func(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLRoleDefinitionOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLRoleDefinitionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLStoredProcedure is the fake for method SQLResourcesClient.BeginDeleteSQLStoredProcedure
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLStoredProcedure func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLStoredProcedureOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLStoredProcedureResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLTrigger is the fake for method SQLResourcesClient.BeginDeleteSQLTrigger
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLTrigger func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLTriggerOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLTriggerResponse], errResp azfake.ErrorResponder)

	// BeginDeleteSQLUserDefinedFunction is the fake for method SQLResourcesClient.BeginDeleteSQLUserDefinedFunction
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteSQLUserDefinedFunction func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string, options *armcosmos.SQLResourcesClientBeginDeleteSQLUserDefinedFunctionOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLUserDefinedFunctionResponse], errResp azfake.ErrorResponder)

	// GetClientEncryptionKey is the fake for method SQLResourcesClient.GetClientEncryptionKey
	// HTTP status codes to indicate success: http.StatusOK
	GetClientEncryptionKey func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, clientEncryptionKeyName string, options *armcosmos.SQLResourcesClientGetClientEncryptionKeyOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetClientEncryptionKeyResponse], errResp azfake.ErrorResponder)

	// GetSQLContainer is the fake for method SQLResourcesClient.GetSQLContainer
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLContainer func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientGetSQLContainerOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLContainerResponse], errResp azfake.ErrorResponder)

	// GetSQLContainerThroughput is the fake for method SQLResourcesClient.GetSQLContainerThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLContainerThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientGetSQLContainerThroughputOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLContainerThroughputResponse], errResp azfake.ErrorResponder)

	// GetSQLDatabase is the fake for method SQLResourcesClient.GetSQLDatabase
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientGetSQLDatabaseOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLDatabaseResponse], errResp azfake.ErrorResponder)

	// GetSQLDatabaseThroughput is the fake for method SQLResourcesClient.GetSQLDatabaseThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLDatabaseThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientGetSQLDatabaseThroughputOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLDatabaseThroughputResponse], errResp azfake.ErrorResponder)

	// GetSQLRoleAssignment is the fake for method SQLResourcesClient.GetSQLRoleAssignment
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLRoleAssignment func(ctx context.Context, roleAssignmentID string, resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientGetSQLRoleAssignmentOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLRoleAssignmentResponse], errResp azfake.ErrorResponder)

	// GetSQLRoleDefinition is the fake for method SQLResourcesClient.GetSQLRoleDefinition
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLRoleDefinition func(ctx context.Context, roleDefinitionID string, resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientGetSQLRoleDefinitionOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLRoleDefinitionResponse], errResp azfake.ErrorResponder)

	// GetSQLStoredProcedure is the fake for method SQLResourcesClient.GetSQLStoredProcedure
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLStoredProcedure func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, storedProcedureName string, options *armcosmos.SQLResourcesClientGetSQLStoredProcedureOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLStoredProcedureResponse], errResp azfake.ErrorResponder)

	// GetSQLTrigger is the fake for method SQLResourcesClient.GetSQLTrigger
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLTrigger func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, triggerName string, options *armcosmos.SQLResourcesClientGetSQLTriggerOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLTriggerResponse], errResp azfake.ErrorResponder)

	// GetSQLUserDefinedFunction is the fake for method SQLResourcesClient.GetSQLUserDefinedFunction
	// HTTP status codes to indicate success: http.StatusOK
	GetSQLUserDefinedFunction func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, userDefinedFunctionName string, options *armcosmos.SQLResourcesClientGetSQLUserDefinedFunctionOptions) (resp azfake.Responder[armcosmos.SQLResourcesClientGetSQLUserDefinedFunctionResponse], errResp azfake.ErrorResponder)

	// NewListClientEncryptionKeysPager is the fake for method SQLResourcesClient.NewListClientEncryptionKeysPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListClientEncryptionKeysPager func(resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientListClientEncryptionKeysOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListClientEncryptionKeysResponse])

	// BeginListSQLContainerPartitionMerge is the fake for method SQLResourcesClient.BeginListSQLContainerPartitionMerge
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListSQLContainerPartitionMerge func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, mergeParameters armcosmos.MergeParameters, options *armcosmos.SQLResourcesClientBeginListSQLContainerPartitionMergeOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientListSQLContainerPartitionMergeResponse], errResp azfake.ErrorResponder)

	// NewListSQLContainersPager is the fake for method SQLResourcesClient.NewListSQLContainersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLContainersPager func(resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientListSQLContainersOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLContainersResponse])

	// NewListSQLDatabasesPager is the fake for method SQLResourcesClient.NewListSQLDatabasesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLDatabasesPager func(resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientListSQLDatabasesOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLDatabasesResponse])

	// NewListSQLRoleAssignmentsPager is the fake for method SQLResourcesClient.NewListSQLRoleAssignmentsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLRoleAssignmentsPager func(resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientListSQLRoleAssignmentsOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLRoleAssignmentsResponse])

	// NewListSQLRoleDefinitionsPager is the fake for method SQLResourcesClient.NewListSQLRoleDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLRoleDefinitionsPager func(resourceGroupName string, accountName string, options *armcosmos.SQLResourcesClientListSQLRoleDefinitionsOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLRoleDefinitionsResponse])

	// NewListSQLStoredProceduresPager is the fake for method SQLResourcesClient.NewListSQLStoredProceduresPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLStoredProceduresPager func(resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientListSQLStoredProceduresOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLStoredProceduresResponse])

	// NewListSQLTriggersPager is the fake for method SQLResourcesClient.NewListSQLTriggersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLTriggersPager func(resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientListSQLTriggersOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLTriggersResponse])

	// NewListSQLUserDefinedFunctionsPager is the fake for method SQLResourcesClient.NewListSQLUserDefinedFunctionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSQLUserDefinedFunctionsPager func(resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientListSQLUserDefinedFunctionsOptions) (resp azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLUserDefinedFunctionsResponse])

	// BeginMigrateSQLContainerToAutoscale is the fake for method SQLResourcesClient.BeginMigrateSQLContainerToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateSQLContainerToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientBeginMigrateSQLContainerToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLContainerToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateSQLContainerToManualThroughput is the fake for method SQLResourcesClient.BeginMigrateSQLContainerToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateSQLContainerToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, options *armcosmos.SQLResourcesClientBeginMigrateSQLContainerToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLContainerToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMigrateSQLDatabaseToAutoscale is the fake for method SQLResourcesClient.BeginMigrateSQLDatabaseToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateSQLDatabaseToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientBeginMigrateSQLDatabaseToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLDatabaseToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateSQLDatabaseToManualThroughput is the fake for method SQLResourcesClient.BeginMigrateSQLDatabaseToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateSQLDatabaseToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.SQLResourcesClientBeginMigrateSQLDatabaseToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLDatabaseToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginRetrieveContinuousBackupInformation is the fake for method SQLResourcesClient.BeginRetrieveContinuousBackupInformation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRetrieveContinuousBackupInformation func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, location armcosmos.ContinuousBackupRestoreLocation, options *armcosmos.SQLResourcesClientBeginRetrieveContinuousBackupInformationOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientRetrieveContinuousBackupInformationResponse], errResp azfake.ErrorResponder)

	// BeginSQLContainerRedistributeThroughput is the fake for method SQLResourcesClient.BeginSQLContainerRedistributeThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSQLContainerRedistributeThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, redistributeThroughputParameters armcosmos.RedistributeThroughputParameters, options *armcosmos.SQLResourcesClientBeginSQLContainerRedistributeThroughputOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientSQLContainerRedistributeThroughputResponse], errResp azfake.ErrorResponder)

	// BeginSQLContainerRetrieveThroughputDistribution is the fake for method SQLResourcesClient.BeginSQLContainerRetrieveThroughputDistribution
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSQLContainerRetrieveThroughputDistribution func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, retrieveThroughputParameters armcosmos.RetrieveThroughputParameters, options *armcosmos.SQLResourcesClientBeginSQLContainerRetrieveThroughputDistributionOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientSQLContainerRetrieveThroughputDistributionResponse], errResp azfake.ErrorResponder)

	// BeginSQLDatabasePartitionMerge is the fake for method SQLResourcesClient.BeginSQLDatabasePartitionMerge
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSQLDatabasePartitionMerge func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, mergeParameters armcosmos.MergeParameters, options *armcosmos.SQLResourcesClientBeginSQLDatabasePartitionMergeOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabasePartitionMergeResponse], errResp azfake.ErrorResponder)

	// BeginSQLDatabaseRedistributeThroughput is the fake for method SQLResourcesClient.BeginSQLDatabaseRedistributeThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSQLDatabaseRedistributeThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, redistributeThroughputParameters armcosmos.RedistributeThroughputParameters, options *armcosmos.SQLResourcesClientBeginSQLDatabaseRedistributeThroughputOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabaseRedistributeThroughputResponse], errResp azfake.ErrorResponder)

	// BeginSQLDatabaseRetrieveThroughputDistribution is the fake for method SQLResourcesClient.BeginSQLDatabaseRetrieveThroughputDistribution
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSQLDatabaseRetrieveThroughputDistribution func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, retrieveThroughputParameters armcosmos.RetrieveThroughputParameters, options *armcosmos.SQLResourcesClientBeginSQLDatabaseRetrieveThroughputDistributionOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabaseRetrieveThroughputDistributionResponse], errResp azfake.ErrorResponder)

	// BeginUpdateSQLContainerThroughput is the fake for method SQLResourcesClient.BeginUpdateSQLContainerThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateSQLContainerThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, containerName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.SQLResourcesClientBeginUpdateSQLContainerThroughputOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientUpdateSQLContainerThroughputResponse], errResp azfake.ErrorResponder)

	// BeginUpdateSQLDatabaseThroughput is the fake for method SQLResourcesClient.BeginUpdateSQLDatabaseThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateSQLDatabaseThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.SQLResourcesClientBeginUpdateSQLDatabaseThroughputOptions) (resp azfake.PollerResponder[armcosmos.SQLResourcesClientUpdateSQLDatabaseThroughputResponse], errResp azfake.ErrorResponder)
}

// NewSQLResourcesServerTransport creates a new instance of SQLResourcesServerTransport with the provided implementation.
// The returned SQLResourcesServerTransport instance is connected to an instance of armcosmos.SQLResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLResourcesServerTransport(srv *SQLResourcesServer) *SQLResourcesServerTransport {
	return &SQLResourcesServerTransport{
		srv:                                             srv,
		beginCreateUpdateClientEncryptionKey:            newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateClientEncryptionKeyResponse]](),
		beginCreateUpdateSQLContainer:                   newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLContainerResponse]](),
		beginCreateUpdateSQLDatabase:                    newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLDatabaseResponse]](),
		beginCreateUpdateSQLRoleAssignment:              newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLRoleAssignmentResponse]](),
		beginCreateUpdateSQLRoleDefinition:              newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLRoleDefinitionResponse]](),
		beginCreateUpdateSQLStoredProcedure:             newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLStoredProcedureResponse]](),
		beginCreateUpdateSQLTrigger:                     newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLTriggerResponse]](),
		beginCreateUpdateSQLUserDefinedFunction:         newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLUserDefinedFunctionResponse]](),
		beginDeleteSQLContainer:                         newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLContainerResponse]](),
		beginDeleteSQLDatabase:                          newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLDatabaseResponse]](),
		beginDeleteSQLRoleAssignment:                    newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLRoleAssignmentResponse]](),
		beginDeleteSQLRoleDefinition:                    newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLRoleDefinitionResponse]](),
		beginDeleteSQLStoredProcedure:                   newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLStoredProcedureResponse]](),
		beginDeleteSQLTrigger:                           newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLTriggerResponse]](),
		beginDeleteSQLUserDefinedFunction:               newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLUserDefinedFunctionResponse]](),
		newListClientEncryptionKeysPager:                newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListClientEncryptionKeysResponse]](),
		beginListSQLContainerPartitionMerge:             newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientListSQLContainerPartitionMergeResponse]](),
		newListSQLContainersPager:                       newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLContainersResponse]](),
		newListSQLDatabasesPager:                        newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLDatabasesResponse]](),
		newListSQLRoleAssignmentsPager:                  newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLRoleAssignmentsResponse]](),
		newListSQLRoleDefinitionsPager:                  newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLRoleDefinitionsResponse]](),
		newListSQLStoredProceduresPager:                 newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLStoredProceduresResponse]](),
		newListSQLTriggersPager:                         newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLTriggersResponse]](),
		newListSQLUserDefinedFunctionsPager:             newTracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLUserDefinedFunctionsResponse]](),
		beginMigrateSQLContainerToAutoscale:             newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLContainerToAutoscaleResponse]](),
		beginMigrateSQLContainerToManualThroughput:      newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLContainerToManualThroughputResponse]](),
		beginMigrateSQLDatabaseToAutoscale:              newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLDatabaseToAutoscaleResponse]](),
		beginMigrateSQLDatabaseToManualThroughput:       newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLDatabaseToManualThroughputResponse]](),
		beginRetrieveContinuousBackupInformation:        newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientRetrieveContinuousBackupInformationResponse]](),
		beginSQLContainerRedistributeThroughput:         newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLContainerRedistributeThroughputResponse]](),
		beginSQLContainerRetrieveThroughputDistribution: newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLContainerRetrieveThroughputDistributionResponse]](),
		beginSQLDatabasePartitionMerge:                  newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabasePartitionMergeResponse]](),
		beginSQLDatabaseRedistributeThroughput:          newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabaseRedistributeThroughputResponse]](),
		beginSQLDatabaseRetrieveThroughputDistribution:  newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabaseRetrieveThroughputDistributionResponse]](),
		beginUpdateSQLContainerThroughput:               newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientUpdateSQLContainerThroughputResponse]](),
		beginUpdateSQLDatabaseThroughput:                newTracker[azfake.PollerResponder[armcosmos.SQLResourcesClientUpdateSQLDatabaseThroughputResponse]](),
	}
}

// SQLResourcesServerTransport connects instances of armcosmos.SQLResourcesClient to instances of SQLResourcesServer.
// Don't use this type directly, use NewSQLResourcesServerTransport instead.
type SQLResourcesServerTransport struct {
	srv                                             *SQLResourcesServer
	beginCreateUpdateClientEncryptionKey            *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateClientEncryptionKeyResponse]]
	beginCreateUpdateSQLContainer                   *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLContainerResponse]]
	beginCreateUpdateSQLDatabase                    *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLDatabaseResponse]]
	beginCreateUpdateSQLRoleAssignment              *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLRoleAssignmentResponse]]
	beginCreateUpdateSQLRoleDefinition              *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLRoleDefinitionResponse]]
	beginCreateUpdateSQLStoredProcedure             *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLStoredProcedureResponse]]
	beginCreateUpdateSQLTrigger                     *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLTriggerResponse]]
	beginCreateUpdateSQLUserDefinedFunction         *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientCreateUpdateSQLUserDefinedFunctionResponse]]
	beginDeleteSQLContainer                         *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLContainerResponse]]
	beginDeleteSQLDatabase                          *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLDatabaseResponse]]
	beginDeleteSQLRoleAssignment                    *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLRoleAssignmentResponse]]
	beginDeleteSQLRoleDefinition                    *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLRoleDefinitionResponse]]
	beginDeleteSQLStoredProcedure                   *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLStoredProcedureResponse]]
	beginDeleteSQLTrigger                           *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLTriggerResponse]]
	beginDeleteSQLUserDefinedFunction               *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientDeleteSQLUserDefinedFunctionResponse]]
	newListClientEncryptionKeysPager                *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListClientEncryptionKeysResponse]]
	beginListSQLContainerPartitionMerge             *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientListSQLContainerPartitionMergeResponse]]
	newListSQLContainersPager                       *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLContainersResponse]]
	newListSQLDatabasesPager                        *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLDatabasesResponse]]
	newListSQLRoleAssignmentsPager                  *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLRoleAssignmentsResponse]]
	newListSQLRoleDefinitionsPager                  *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLRoleDefinitionsResponse]]
	newListSQLStoredProceduresPager                 *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLStoredProceduresResponse]]
	newListSQLTriggersPager                         *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLTriggersResponse]]
	newListSQLUserDefinedFunctionsPager             *tracker[azfake.PagerResponder[armcosmos.SQLResourcesClientListSQLUserDefinedFunctionsResponse]]
	beginMigrateSQLContainerToAutoscale             *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLContainerToAutoscaleResponse]]
	beginMigrateSQLContainerToManualThroughput      *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLContainerToManualThroughputResponse]]
	beginMigrateSQLDatabaseToAutoscale              *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLDatabaseToAutoscaleResponse]]
	beginMigrateSQLDatabaseToManualThroughput       *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientMigrateSQLDatabaseToManualThroughputResponse]]
	beginRetrieveContinuousBackupInformation        *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientRetrieveContinuousBackupInformationResponse]]
	beginSQLContainerRedistributeThroughput         *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLContainerRedistributeThroughputResponse]]
	beginSQLContainerRetrieveThroughputDistribution *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLContainerRetrieveThroughputDistributionResponse]]
	beginSQLDatabasePartitionMerge                  *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabasePartitionMergeResponse]]
	beginSQLDatabaseRedistributeThroughput          *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabaseRedistributeThroughputResponse]]
	beginSQLDatabaseRetrieveThroughputDistribution  *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientSQLDatabaseRetrieveThroughputDistributionResponse]]
	beginUpdateSQLContainerThroughput               *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientUpdateSQLContainerThroughputResponse]]
	beginUpdateSQLDatabaseThroughput                *tracker[azfake.PollerResponder[armcosmos.SQLResourcesClientUpdateSQLDatabaseThroughputResponse]]
}

// Do implements the policy.Transporter interface for SQLResourcesServerTransport.
func (s *SQLResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLResourcesClient.BeginCreateUpdateClientEncryptionKey":
		resp, err = s.dispatchBeginCreateUpdateClientEncryptionKey(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLContainer":
		resp, err = s.dispatchBeginCreateUpdateSQLContainer(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLDatabase":
		resp, err = s.dispatchBeginCreateUpdateSQLDatabase(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLRoleAssignment":
		resp, err = s.dispatchBeginCreateUpdateSQLRoleAssignment(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLRoleDefinition":
		resp, err = s.dispatchBeginCreateUpdateSQLRoleDefinition(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLStoredProcedure":
		resp, err = s.dispatchBeginCreateUpdateSQLStoredProcedure(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLTrigger":
		resp, err = s.dispatchBeginCreateUpdateSQLTrigger(req)
	case "SQLResourcesClient.BeginCreateUpdateSQLUserDefinedFunction":
		resp, err = s.dispatchBeginCreateUpdateSQLUserDefinedFunction(req)
	case "SQLResourcesClient.BeginDeleteSQLContainer":
		resp, err = s.dispatchBeginDeleteSQLContainer(req)
	case "SQLResourcesClient.BeginDeleteSQLDatabase":
		resp, err = s.dispatchBeginDeleteSQLDatabase(req)
	case "SQLResourcesClient.BeginDeleteSQLRoleAssignment":
		resp, err = s.dispatchBeginDeleteSQLRoleAssignment(req)
	case "SQLResourcesClient.BeginDeleteSQLRoleDefinition":
		resp, err = s.dispatchBeginDeleteSQLRoleDefinition(req)
	case "SQLResourcesClient.BeginDeleteSQLStoredProcedure":
		resp, err = s.dispatchBeginDeleteSQLStoredProcedure(req)
	case "SQLResourcesClient.BeginDeleteSQLTrigger":
		resp, err = s.dispatchBeginDeleteSQLTrigger(req)
	case "SQLResourcesClient.BeginDeleteSQLUserDefinedFunction":
		resp, err = s.dispatchBeginDeleteSQLUserDefinedFunction(req)
	case "SQLResourcesClient.GetClientEncryptionKey":
		resp, err = s.dispatchGetClientEncryptionKey(req)
	case "SQLResourcesClient.GetSQLContainer":
		resp, err = s.dispatchGetSQLContainer(req)
	case "SQLResourcesClient.GetSQLContainerThroughput":
		resp, err = s.dispatchGetSQLContainerThroughput(req)
	case "SQLResourcesClient.GetSQLDatabase":
		resp, err = s.dispatchGetSQLDatabase(req)
	case "SQLResourcesClient.GetSQLDatabaseThroughput":
		resp, err = s.dispatchGetSQLDatabaseThroughput(req)
	case "SQLResourcesClient.GetSQLRoleAssignment":
		resp, err = s.dispatchGetSQLRoleAssignment(req)
	case "SQLResourcesClient.GetSQLRoleDefinition":
		resp, err = s.dispatchGetSQLRoleDefinition(req)
	case "SQLResourcesClient.GetSQLStoredProcedure":
		resp, err = s.dispatchGetSQLStoredProcedure(req)
	case "SQLResourcesClient.GetSQLTrigger":
		resp, err = s.dispatchGetSQLTrigger(req)
	case "SQLResourcesClient.GetSQLUserDefinedFunction":
		resp, err = s.dispatchGetSQLUserDefinedFunction(req)
	case "SQLResourcesClient.NewListClientEncryptionKeysPager":
		resp, err = s.dispatchNewListClientEncryptionKeysPager(req)
	case "SQLResourcesClient.BeginListSQLContainerPartitionMerge":
		resp, err = s.dispatchBeginListSQLContainerPartitionMerge(req)
	case "SQLResourcesClient.NewListSQLContainersPager":
		resp, err = s.dispatchNewListSQLContainersPager(req)
	case "SQLResourcesClient.NewListSQLDatabasesPager":
		resp, err = s.dispatchNewListSQLDatabasesPager(req)
	case "SQLResourcesClient.NewListSQLRoleAssignmentsPager":
		resp, err = s.dispatchNewListSQLRoleAssignmentsPager(req)
	case "SQLResourcesClient.NewListSQLRoleDefinitionsPager":
		resp, err = s.dispatchNewListSQLRoleDefinitionsPager(req)
	case "SQLResourcesClient.NewListSQLStoredProceduresPager":
		resp, err = s.dispatchNewListSQLStoredProceduresPager(req)
	case "SQLResourcesClient.NewListSQLTriggersPager":
		resp, err = s.dispatchNewListSQLTriggersPager(req)
	case "SQLResourcesClient.NewListSQLUserDefinedFunctionsPager":
		resp, err = s.dispatchNewListSQLUserDefinedFunctionsPager(req)
	case "SQLResourcesClient.BeginMigrateSQLContainerToAutoscale":
		resp, err = s.dispatchBeginMigrateSQLContainerToAutoscale(req)
	case "SQLResourcesClient.BeginMigrateSQLContainerToManualThroughput":
		resp, err = s.dispatchBeginMigrateSQLContainerToManualThroughput(req)
	case "SQLResourcesClient.BeginMigrateSQLDatabaseToAutoscale":
		resp, err = s.dispatchBeginMigrateSQLDatabaseToAutoscale(req)
	case "SQLResourcesClient.BeginMigrateSQLDatabaseToManualThroughput":
		resp, err = s.dispatchBeginMigrateSQLDatabaseToManualThroughput(req)
	case "SQLResourcesClient.BeginRetrieveContinuousBackupInformation":
		resp, err = s.dispatchBeginRetrieveContinuousBackupInformation(req)
	case "SQLResourcesClient.BeginSQLContainerRedistributeThroughput":
		resp, err = s.dispatchBeginSQLContainerRedistributeThroughput(req)
	case "SQLResourcesClient.BeginSQLContainerRetrieveThroughputDistribution":
		resp, err = s.dispatchBeginSQLContainerRetrieveThroughputDistribution(req)
	case "SQLResourcesClient.BeginSQLDatabasePartitionMerge":
		resp, err = s.dispatchBeginSQLDatabasePartitionMerge(req)
	case "SQLResourcesClient.BeginSQLDatabaseRedistributeThroughput":
		resp, err = s.dispatchBeginSQLDatabaseRedistributeThroughput(req)
	case "SQLResourcesClient.BeginSQLDatabaseRetrieveThroughputDistribution":
		resp, err = s.dispatchBeginSQLDatabaseRetrieveThroughputDistribution(req)
	case "SQLResourcesClient.BeginUpdateSQLContainerThroughput":
		resp, err = s.dispatchBeginUpdateSQLContainerThroughput(req)
	case "SQLResourcesClient.BeginUpdateSQLDatabaseThroughput":
		resp, err = s.dispatchBeginUpdateSQLDatabaseThroughput(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateClientEncryptionKey(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateClientEncryptionKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateClientEncryptionKey not implemented")}
	}
	beginCreateUpdateClientEncryptionKey := s.beginCreateUpdateClientEncryptionKey.get(req)
	if beginCreateUpdateClientEncryptionKey == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clientEncryptionKeys/(?P<clientEncryptionKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ClientEncryptionKeyCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		clientEncryptionKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clientEncryptionKeyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateClientEncryptionKey(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, clientEncryptionKeyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateClientEncryptionKey = &respr
		s.beginCreateUpdateClientEncryptionKey.add(req, beginCreateUpdateClientEncryptionKey)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateClientEncryptionKey, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateClientEncryptionKey.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateClientEncryptionKey) {
		s.beginCreateUpdateClientEncryptionKey.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLContainer(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLContainer == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLContainer not implemented")}
	}
	beginCreateUpdateSQLContainer := s.beginCreateUpdateSQLContainer.get(req)
	if beginCreateUpdateSQLContainer == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLContainerCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLContainer(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLContainer = &respr
		s.beginCreateUpdateSQLContainer.add(req, beginCreateUpdateSQLContainer)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLContainer, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLContainer.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLContainer) {
		s.beginCreateUpdateSQLContainer.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLDatabase(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLDatabase not implemented")}
	}
	beginCreateUpdateSQLDatabase := s.beginCreateUpdateSQLDatabase.get(req)
	if beginCreateUpdateSQLDatabase == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLDatabaseCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLDatabase = &respr
		s.beginCreateUpdateSQLDatabase.add(req, beginCreateUpdateSQLDatabase)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLDatabase, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLDatabase.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLDatabase) {
		s.beginCreateUpdateSQLDatabase.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLRoleAssignment(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLRoleAssignment == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLRoleAssignment not implemented")}
	}
	beginCreateUpdateSQLRoleAssignment := s.beginCreateUpdateSQLRoleAssignment.get(req)
	if beginCreateUpdateSQLRoleAssignment == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleAssignments/(?P<roleAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLRoleAssignmentCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		roleAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleAssignmentId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLRoleAssignment(req.Context(), roleAssignmentIDParam, resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLRoleAssignment = &respr
		s.beginCreateUpdateSQLRoleAssignment.add(req, beginCreateUpdateSQLRoleAssignment)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLRoleAssignment, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLRoleAssignment.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLRoleAssignment) {
		s.beginCreateUpdateSQLRoleAssignment.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLRoleDefinition(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLRoleDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLRoleDefinition not implemented")}
	}
	beginCreateUpdateSQLRoleDefinition := s.beginCreateUpdateSQLRoleDefinition.get(req)
	if beginCreateUpdateSQLRoleDefinition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleDefinitions/(?P<roleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLRoleDefinitionCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		roleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleDefinitionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLRoleDefinition(req.Context(), roleDefinitionIDParam, resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLRoleDefinition = &respr
		s.beginCreateUpdateSQLRoleDefinition.add(req, beginCreateUpdateSQLRoleDefinition)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLRoleDefinition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLRoleDefinition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLRoleDefinition) {
		s.beginCreateUpdateSQLRoleDefinition.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLStoredProcedure(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLStoredProcedure == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLStoredProcedure not implemented")}
	}
	beginCreateUpdateSQLStoredProcedure := s.beginCreateUpdateSQLStoredProcedure.get(req)
	if beginCreateUpdateSQLStoredProcedure == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storedProcedures/(?P<storedProcedureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLStoredProcedureCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		storedProcedureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storedProcedureName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLStoredProcedure(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, storedProcedureNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLStoredProcedure = &respr
		s.beginCreateUpdateSQLStoredProcedure.add(req, beginCreateUpdateSQLStoredProcedure)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLStoredProcedure, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLStoredProcedure.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLStoredProcedure) {
		s.beginCreateUpdateSQLStoredProcedure.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLTrigger(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLTrigger == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLTrigger not implemented")}
	}
	beginCreateUpdateSQLTrigger := s.beginCreateUpdateSQLTrigger.get(req)
	if beginCreateUpdateSQLTrigger == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLTriggerCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLTrigger(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, triggerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLTrigger = &respr
		s.beginCreateUpdateSQLTrigger.add(req, beginCreateUpdateSQLTrigger)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLTrigger, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLTrigger.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLTrigger) {
		s.beginCreateUpdateSQLTrigger.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginCreateUpdateSQLUserDefinedFunction(req *http.Request) (*http.Response, error) {
	if s.srv.BeginCreateUpdateSQLUserDefinedFunction == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateSQLUserDefinedFunction not implemented")}
	}
	beginCreateUpdateSQLUserDefinedFunction := s.beginCreateUpdateSQLUserDefinedFunction.get(req)
	if beginCreateUpdateSQLUserDefinedFunction == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userDefinedFunctions/(?P<userDefinedFunctionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.SQLUserDefinedFunctionCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		userDefinedFunctionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userDefinedFunctionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginCreateUpdateSQLUserDefinedFunction(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, userDefinedFunctionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateSQLUserDefinedFunction = &respr
		s.beginCreateUpdateSQLUserDefinedFunction.add(req, beginCreateUpdateSQLUserDefinedFunction)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateSQLUserDefinedFunction, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginCreateUpdateSQLUserDefinedFunction.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateSQLUserDefinedFunction) {
		s.beginCreateUpdateSQLUserDefinedFunction.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLContainer(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLContainer == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLContainer not implemented")}
	}
	beginDeleteSQLContainer := s.beginDeleteSQLContainer.get(req)
	if beginDeleteSQLContainer == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLContainer(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLContainer = &respr
		s.beginDeleteSQLContainer.add(req, beginDeleteSQLContainer)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLContainer, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLContainer.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLContainer) {
		s.beginDeleteSQLContainer.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLDatabase(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLDatabase not implemented")}
	}
	beginDeleteSQLDatabase := s.beginDeleteSQLDatabase.get(req)
	if beginDeleteSQLDatabase == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLDatabase = &respr
		s.beginDeleteSQLDatabase.add(req, beginDeleteSQLDatabase)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLDatabase, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLDatabase.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLDatabase) {
		s.beginDeleteSQLDatabase.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLRoleAssignment(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLRoleAssignment == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLRoleAssignment not implemented")}
	}
	beginDeleteSQLRoleAssignment := s.beginDeleteSQLRoleAssignment.get(req)
	if beginDeleteSQLRoleAssignment == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleAssignments/(?P<roleAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		roleAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleAssignmentId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLRoleAssignment(req.Context(), roleAssignmentIDParam, resourceGroupNameParam, accountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLRoleAssignment = &respr
		s.beginDeleteSQLRoleAssignment.add(req, beginDeleteSQLRoleAssignment)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLRoleAssignment, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLRoleAssignment.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLRoleAssignment) {
		s.beginDeleteSQLRoleAssignment.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLRoleDefinition(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLRoleDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLRoleDefinition not implemented")}
	}
	beginDeleteSQLRoleDefinition := s.beginDeleteSQLRoleDefinition.get(req)
	if beginDeleteSQLRoleDefinition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleDefinitions/(?P<roleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		roleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleDefinitionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLRoleDefinition(req.Context(), roleDefinitionIDParam, resourceGroupNameParam, accountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLRoleDefinition = &respr
		s.beginDeleteSQLRoleDefinition.add(req, beginDeleteSQLRoleDefinition)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLRoleDefinition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLRoleDefinition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLRoleDefinition) {
		s.beginDeleteSQLRoleDefinition.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLStoredProcedure(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLStoredProcedure == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLStoredProcedure not implemented")}
	}
	beginDeleteSQLStoredProcedure := s.beginDeleteSQLStoredProcedure.get(req)
	if beginDeleteSQLStoredProcedure == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storedProcedures/(?P<storedProcedureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		storedProcedureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storedProcedureName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLStoredProcedure(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, storedProcedureNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLStoredProcedure = &respr
		s.beginDeleteSQLStoredProcedure.add(req, beginDeleteSQLStoredProcedure)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLStoredProcedure, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLStoredProcedure.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLStoredProcedure) {
		s.beginDeleteSQLStoredProcedure.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLTrigger(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLTrigger == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLTrigger not implemented")}
	}
	beginDeleteSQLTrigger := s.beginDeleteSQLTrigger.get(req)
	if beginDeleteSQLTrigger == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLTrigger(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, triggerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLTrigger = &respr
		s.beginDeleteSQLTrigger.add(req, beginDeleteSQLTrigger)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLTrigger, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLTrigger.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLTrigger) {
		s.beginDeleteSQLTrigger.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginDeleteSQLUserDefinedFunction(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDeleteSQLUserDefinedFunction == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteSQLUserDefinedFunction not implemented")}
	}
	beginDeleteSQLUserDefinedFunction := s.beginDeleteSQLUserDefinedFunction.get(req)
	if beginDeleteSQLUserDefinedFunction == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userDefinedFunctions/(?P<userDefinedFunctionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		userDefinedFunctionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userDefinedFunctionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDeleteSQLUserDefinedFunction(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, userDefinedFunctionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteSQLUserDefinedFunction = &respr
		s.beginDeleteSQLUserDefinedFunction.add(req, beginDeleteSQLUserDefinedFunction)
	}

	resp, err := server.PollerResponderNext(beginDeleteSQLUserDefinedFunction, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDeleteSQLUserDefinedFunction.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteSQLUserDefinedFunction) {
		s.beginDeleteSQLUserDefinedFunction.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetClientEncryptionKey(req *http.Request) (*http.Response, error) {
	if s.srv.GetClientEncryptionKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetClientEncryptionKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clientEncryptionKeys/(?P<clientEncryptionKeyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	clientEncryptionKeyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clientEncryptionKeyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetClientEncryptionKey(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, clientEncryptionKeyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ClientEncryptionKeyGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLContainer(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLContainer == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLContainer not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLContainer(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLContainerGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLContainerThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLContainerThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLContainerThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLContainerThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLDatabase(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLDatabase not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLDatabaseGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLDatabaseThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLDatabaseThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLDatabaseThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLDatabaseThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLRoleAssignment(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLRoleAssignment == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLRoleAssignment not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleAssignments/(?P<roleAssignmentId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	roleAssignmentIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleAssignmentId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLRoleAssignment(req.Context(), roleAssignmentIDParam, resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLRoleAssignmentGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLRoleDefinition(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLRoleDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLRoleDefinition not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleDefinitions/(?P<roleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	roleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("roleDefinitionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLRoleDefinition(req.Context(), roleDefinitionIDParam, resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLRoleDefinitionGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLStoredProcedure(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLStoredProcedure == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLStoredProcedure not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storedProcedures/(?P<storedProcedureName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	storedProcedureNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("storedProcedureName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLStoredProcedure(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, storedProcedureNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLStoredProcedureGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLTrigger(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLTrigger == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLTrigger not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers/(?P<triggerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	triggerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("triggerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLTrigger(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, triggerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLTriggerGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchGetSQLUserDefinedFunction(req *http.Request) (*http.Response, error) {
	if s.srv.GetSQLUserDefinedFunction == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSQLUserDefinedFunction not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userDefinedFunctions/(?P<userDefinedFunctionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
	if err != nil {
		return nil, err
	}
	userDefinedFunctionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("userDefinedFunctionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.GetSQLUserDefinedFunction(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, userDefinedFunctionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SQLUserDefinedFunctionGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListClientEncryptionKeysPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListClientEncryptionKeysPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListClientEncryptionKeysPager not implemented")}
	}
	newListClientEncryptionKeysPager := s.newListClientEncryptionKeysPager.get(req)
	if newListClientEncryptionKeysPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/clientEncryptionKeys`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListClientEncryptionKeysPager(resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		newListClientEncryptionKeysPager = &resp
		s.newListClientEncryptionKeysPager.add(req, newListClientEncryptionKeysPager)
	}
	resp, err := server.PagerResponderNext(newListClientEncryptionKeysPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListClientEncryptionKeysPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListClientEncryptionKeysPager) {
		s.newListClientEncryptionKeysPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginListSQLContainerPartitionMerge(req *http.Request) (*http.Response, error) {
	if s.srv.BeginListSQLContainerPartitionMerge == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListSQLContainerPartitionMerge not implemented")}
	}
	beginListSQLContainerPartitionMerge := s.beginListSQLContainerPartitionMerge.get(req)
	if beginListSQLContainerPartitionMerge == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/partitionMerge`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MergeParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginListSQLContainerPartitionMerge(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListSQLContainerPartitionMerge = &respr
		s.beginListSQLContainerPartitionMerge.add(req, beginListSQLContainerPartitionMerge)
	}

	resp, err := server.PollerResponderNext(beginListSQLContainerPartitionMerge, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginListSQLContainerPartitionMerge.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListSQLContainerPartitionMerge) {
		s.beginListSQLContainerPartitionMerge.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLContainersPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLContainersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLContainersPager not implemented")}
	}
	newListSQLContainersPager := s.newListSQLContainersPager.get(req)
	if newListSQLContainersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLContainersPager(resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		newListSQLContainersPager = &resp
		s.newListSQLContainersPager.add(req, newListSQLContainersPager)
	}
	resp, err := server.PagerResponderNext(newListSQLContainersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLContainersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLContainersPager) {
		s.newListSQLContainersPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLDatabasesPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLDatabasesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLDatabasesPager not implemented")}
	}
	newListSQLDatabasesPager := s.newListSQLDatabasesPager.get(req)
	if newListSQLDatabasesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLDatabasesPager(resourceGroupNameParam, accountNameParam, nil)
		newListSQLDatabasesPager = &resp
		s.newListSQLDatabasesPager.add(req, newListSQLDatabasesPager)
	}
	resp, err := server.PagerResponderNext(newListSQLDatabasesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLDatabasesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLDatabasesPager) {
		s.newListSQLDatabasesPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLRoleAssignmentsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLRoleAssignmentsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLRoleAssignmentsPager not implemented")}
	}
	newListSQLRoleAssignmentsPager := s.newListSQLRoleAssignmentsPager.get(req)
	if newListSQLRoleAssignmentsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleAssignments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLRoleAssignmentsPager(resourceGroupNameParam, accountNameParam, nil)
		newListSQLRoleAssignmentsPager = &resp
		s.newListSQLRoleAssignmentsPager.add(req, newListSQLRoleAssignmentsPager)
	}
	resp, err := server.PagerResponderNext(newListSQLRoleAssignmentsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLRoleAssignmentsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLRoleAssignmentsPager) {
		s.newListSQLRoleAssignmentsPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLRoleDefinitionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLRoleDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLRoleDefinitionsPager not implemented")}
	}
	newListSQLRoleDefinitionsPager := s.newListSQLRoleDefinitionsPager.get(req)
	if newListSQLRoleDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlRoleDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLRoleDefinitionsPager(resourceGroupNameParam, accountNameParam, nil)
		newListSQLRoleDefinitionsPager = &resp
		s.newListSQLRoleDefinitionsPager.add(req, newListSQLRoleDefinitionsPager)
	}
	resp, err := server.PagerResponderNext(newListSQLRoleDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLRoleDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLRoleDefinitionsPager) {
		s.newListSQLRoleDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLStoredProceduresPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLStoredProceduresPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLStoredProceduresPager not implemented")}
	}
	newListSQLStoredProceduresPager := s.newListSQLStoredProceduresPager.get(req)
	if newListSQLStoredProceduresPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/storedProcedures`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLStoredProceduresPager(resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
		newListSQLStoredProceduresPager = &resp
		s.newListSQLStoredProceduresPager.add(req, newListSQLStoredProceduresPager)
	}
	resp, err := server.PagerResponderNext(newListSQLStoredProceduresPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLStoredProceduresPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLStoredProceduresPager) {
		s.newListSQLStoredProceduresPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLTriggersPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLTriggersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLTriggersPager not implemented")}
	}
	newListSQLTriggersPager := s.newListSQLTriggersPager.get(req)
	if newListSQLTriggersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/triggers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLTriggersPager(resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
		newListSQLTriggersPager = &resp
		s.newListSQLTriggersPager.add(req, newListSQLTriggersPager)
	}
	resp, err := server.PagerResponderNext(newListSQLTriggersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLTriggersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLTriggersPager) {
		s.newListSQLTriggersPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchNewListSQLUserDefinedFunctionsPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListSQLUserDefinedFunctionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSQLUserDefinedFunctionsPager not implemented")}
	}
	newListSQLUserDefinedFunctionsPager := s.newListSQLUserDefinedFunctionsPager.get(req)
	if newListSQLUserDefinedFunctionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/userDefinedFunctions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListSQLUserDefinedFunctionsPager(resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
		newListSQLUserDefinedFunctionsPager = &resp
		s.newListSQLUserDefinedFunctionsPager.add(req, newListSQLUserDefinedFunctionsPager)
	}
	resp, err := server.PagerResponderNext(newListSQLUserDefinedFunctionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListSQLUserDefinedFunctionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSQLUserDefinedFunctionsPager) {
		s.newListSQLUserDefinedFunctionsPager.remove(req)
	}
	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginMigrateSQLContainerToAutoscale(req *http.Request) (*http.Response, error) {
	if s.srv.BeginMigrateSQLContainerToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateSQLContainerToAutoscale not implemented")}
	}
	beginMigrateSQLContainerToAutoscale := s.beginMigrateSQLContainerToAutoscale.get(req)
	if beginMigrateSQLContainerToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginMigrateSQLContainerToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateSQLContainerToAutoscale = &respr
		s.beginMigrateSQLContainerToAutoscale.add(req, beginMigrateSQLContainerToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateSQLContainerToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginMigrateSQLContainerToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateSQLContainerToAutoscale) {
		s.beginMigrateSQLContainerToAutoscale.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginMigrateSQLContainerToManualThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.BeginMigrateSQLContainerToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateSQLContainerToManualThroughput not implemented")}
	}
	beginMigrateSQLContainerToManualThroughput := s.beginMigrateSQLContainerToManualThroughput.get(req)
	if beginMigrateSQLContainerToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginMigrateSQLContainerToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateSQLContainerToManualThroughput = &respr
		s.beginMigrateSQLContainerToManualThroughput.add(req, beginMigrateSQLContainerToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateSQLContainerToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginMigrateSQLContainerToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateSQLContainerToManualThroughput) {
		s.beginMigrateSQLContainerToManualThroughput.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginMigrateSQLDatabaseToAutoscale(req *http.Request) (*http.Response, error) {
	if s.srv.BeginMigrateSQLDatabaseToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateSQLDatabaseToAutoscale not implemented")}
	}
	beginMigrateSQLDatabaseToAutoscale := s.beginMigrateSQLDatabaseToAutoscale.get(req)
	if beginMigrateSQLDatabaseToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginMigrateSQLDatabaseToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateSQLDatabaseToAutoscale = &respr
		s.beginMigrateSQLDatabaseToAutoscale.add(req, beginMigrateSQLDatabaseToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateSQLDatabaseToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginMigrateSQLDatabaseToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateSQLDatabaseToAutoscale) {
		s.beginMigrateSQLDatabaseToAutoscale.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginMigrateSQLDatabaseToManualThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.BeginMigrateSQLDatabaseToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateSQLDatabaseToManualThroughput not implemented")}
	}
	beginMigrateSQLDatabaseToManualThroughput := s.beginMigrateSQLDatabaseToManualThroughput.get(req)
	if beginMigrateSQLDatabaseToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginMigrateSQLDatabaseToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateSQLDatabaseToManualThroughput = &respr
		s.beginMigrateSQLDatabaseToManualThroughput.add(req, beginMigrateSQLDatabaseToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateSQLDatabaseToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginMigrateSQLDatabaseToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateSQLDatabaseToManualThroughput) {
		s.beginMigrateSQLDatabaseToManualThroughput.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginRetrieveContinuousBackupInformation(req *http.Request) (*http.Response, error) {
	if s.srv.BeginRetrieveContinuousBackupInformation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRetrieveContinuousBackupInformation not implemented")}
	}
	beginRetrieveContinuousBackupInformation := s.beginRetrieveContinuousBackupInformation.get(req)
	if beginRetrieveContinuousBackupInformation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveContinuousBackupInformation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ContinuousBackupRestoreLocation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginRetrieveContinuousBackupInformation(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRetrieveContinuousBackupInformation = &respr
		s.beginRetrieveContinuousBackupInformation.add(req, beginRetrieveContinuousBackupInformation)
	}

	resp, err := server.PollerResponderNext(beginRetrieveContinuousBackupInformation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginRetrieveContinuousBackupInformation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRetrieveContinuousBackupInformation) {
		s.beginRetrieveContinuousBackupInformation.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginSQLContainerRedistributeThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.BeginSQLContainerRedistributeThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSQLContainerRedistributeThroughput not implemented")}
	}
	beginSQLContainerRedistributeThroughput := s.beginSQLContainerRedistributeThroughput.get(req)
	if beginSQLContainerRedistributeThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/redistributeThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RedistributeThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginSQLContainerRedistributeThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSQLContainerRedistributeThroughput = &respr
		s.beginSQLContainerRedistributeThroughput.add(req, beginSQLContainerRedistributeThroughput)
	}

	resp, err := server.PollerResponderNext(beginSQLContainerRedistributeThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginSQLContainerRedistributeThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSQLContainerRedistributeThroughput) {
		s.beginSQLContainerRedistributeThroughput.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginSQLContainerRetrieveThroughputDistribution(req *http.Request) (*http.Response, error) {
	if s.srv.BeginSQLContainerRetrieveThroughputDistribution == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSQLContainerRetrieveThroughputDistribution not implemented")}
	}
	beginSQLContainerRetrieveThroughputDistribution := s.beginSQLContainerRetrieveThroughputDistribution.get(req)
	if beginSQLContainerRetrieveThroughputDistribution == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/retrieveThroughputDistribution`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RetrieveThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginSQLContainerRetrieveThroughputDistribution(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSQLContainerRetrieveThroughputDistribution = &respr
		s.beginSQLContainerRetrieveThroughputDistribution.add(req, beginSQLContainerRetrieveThroughputDistribution)
	}

	resp, err := server.PollerResponderNext(beginSQLContainerRetrieveThroughputDistribution, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginSQLContainerRetrieveThroughputDistribution.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSQLContainerRetrieveThroughputDistribution) {
		s.beginSQLContainerRetrieveThroughputDistribution.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginSQLDatabasePartitionMerge(req *http.Request) (*http.Response, error) {
	if s.srv.BeginSQLDatabasePartitionMerge == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSQLDatabasePartitionMerge not implemented")}
	}
	beginSQLDatabasePartitionMerge := s.beginSQLDatabasePartitionMerge.get(req)
	if beginSQLDatabasePartitionMerge == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/partitionMerge`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MergeParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginSQLDatabasePartitionMerge(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSQLDatabasePartitionMerge = &respr
		s.beginSQLDatabasePartitionMerge.add(req, beginSQLDatabasePartitionMerge)
	}

	resp, err := server.PollerResponderNext(beginSQLDatabasePartitionMerge, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginSQLDatabasePartitionMerge.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSQLDatabasePartitionMerge) {
		s.beginSQLDatabasePartitionMerge.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginSQLDatabaseRedistributeThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.BeginSQLDatabaseRedistributeThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSQLDatabaseRedistributeThroughput not implemented")}
	}
	beginSQLDatabaseRedistributeThroughput := s.beginSQLDatabaseRedistributeThroughput.get(req)
	if beginSQLDatabaseRedistributeThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/redistributeThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RedistributeThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginSQLDatabaseRedistributeThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSQLDatabaseRedistributeThroughput = &respr
		s.beginSQLDatabaseRedistributeThroughput.add(req, beginSQLDatabaseRedistributeThroughput)
	}

	resp, err := server.PollerResponderNext(beginSQLDatabaseRedistributeThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginSQLDatabaseRedistributeThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSQLDatabaseRedistributeThroughput) {
		s.beginSQLDatabaseRedistributeThroughput.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginSQLDatabaseRetrieveThroughputDistribution(req *http.Request) (*http.Response, error) {
	if s.srv.BeginSQLDatabaseRetrieveThroughputDistribution == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSQLDatabaseRetrieveThroughputDistribution not implemented")}
	}
	beginSQLDatabaseRetrieveThroughputDistribution := s.beginSQLDatabaseRetrieveThroughputDistribution.get(req)
	if beginSQLDatabaseRetrieveThroughputDistribution == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/retrieveThroughputDistribution`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RetrieveThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginSQLDatabaseRetrieveThroughputDistribution(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSQLDatabaseRetrieveThroughputDistribution = &respr
		s.beginSQLDatabaseRetrieveThroughputDistribution.add(req, beginSQLDatabaseRetrieveThroughputDistribution)
	}

	resp, err := server.PollerResponderNext(beginSQLDatabaseRetrieveThroughputDistribution, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginSQLDatabaseRetrieveThroughputDistribution.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSQLDatabaseRetrieveThroughputDistribution) {
		s.beginSQLDatabaseRetrieveThroughputDistribution.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginUpdateSQLContainerThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdateSQLContainerThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateSQLContainerThroughput not implemented")}
	}
	beginUpdateSQLContainerThroughput := s.beginUpdateSQLContainerThroughput.get(req)
	if beginUpdateSQLContainerThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/containers/(?P<containerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		containerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("containerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdateSQLContainerThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, containerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateSQLContainerThroughput = &respr
		s.beginUpdateSQLContainerThroughput.add(req, beginUpdateSQLContainerThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateSQLContainerThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdateSQLContainerThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateSQLContainerThroughput) {
		s.beginUpdateSQLContainerThroughput.remove(req)
	}

	return resp, nil
}

func (s *SQLResourcesServerTransport) dispatchBeginUpdateSQLDatabaseThroughput(req *http.Request) (*http.Response, error) {
	if s.srv.BeginUpdateSQLDatabaseThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateSQLDatabaseThroughput not implemented")}
	}
	beginUpdateSQLDatabaseThroughput := s.beginUpdateSQLDatabaseThroughput.get(req)
	if beginUpdateSQLDatabaseThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginUpdateSQLDatabaseThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateSQLDatabaseThroughput = &respr
		s.beginUpdateSQLDatabaseThroughput.add(req, beginUpdateSQLDatabaseThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateSQLDatabaseThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		s.beginUpdateSQLDatabaseThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateSQLDatabaseThroughput) {
		s.beginUpdateSQLDatabaseThroughput.remove(req)
	}

	return resp, nil
}
