//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/costmanagement/armcostmanagement/v2"
	"net/http"
	"net/url"
	"regexp"
)

// BenefitRecommendationsServer is a fake server for instances of the armcostmanagement.BenefitRecommendationsClient type.
type BenefitRecommendationsServer struct {
	// NewListPager is the fake for method BenefitRecommendationsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(billingScope string, options *armcostmanagement.BenefitRecommendationsClientListOptions) (resp azfake.PagerResponder[armcostmanagement.BenefitRecommendationsClientListResponse])
}

// NewBenefitRecommendationsServerTransport creates a new instance of BenefitRecommendationsServerTransport with the provided implementation.
// The returned BenefitRecommendationsServerTransport instance is connected to an instance of armcostmanagement.BenefitRecommendationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBenefitRecommendationsServerTransport(srv *BenefitRecommendationsServer) *BenefitRecommendationsServerTransport {
	return &BenefitRecommendationsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armcostmanagement.BenefitRecommendationsClientListResponse]](),
	}
}

// BenefitRecommendationsServerTransport connects instances of armcostmanagement.BenefitRecommendationsClient to instances of BenefitRecommendationsServer.
// Don't use this type directly, use NewBenefitRecommendationsServerTransport instead.
type BenefitRecommendationsServerTransport struct {
	srv          *BenefitRecommendationsServer
	newListPager *tracker[azfake.PagerResponder[armcostmanagement.BenefitRecommendationsClientListResponse]]
}

// Do implements the policy.Transporter interface for BenefitRecommendationsServerTransport.
func (b *BenefitRecommendationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BenefitRecommendationsClient.NewListPager":
		resp, err = b.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BenefitRecommendationsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := b.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<billingScope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.CostManagement/benefitRecommendations`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		orderbyUnescaped, err := url.QueryUnescape(qp.Get("$orderby"))
		if err != nil {
			return nil, err
		}
		orderbyParam := getOptional(orderbyUnescaped)
		expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
		if err != nil {
			return nil, err
		}
		expandParam := getOptional(expandUnescaped)
		billingScopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingScope")])
		if err != nil {
			return nil, err
		}
		var options *armcostmanagement.BenefitRecommendationsClientListOptions
		if filterParam != nil || orderbyParam != nil || expandParam != nil {
			options = &armcostmanagement.BenefitRecommendationsClientListOptions{
				Filter:  filterParam,
				Orderby: orderbyParam,
				Expand:  expandParam,
			}
		}
		resp := b.srv.NewListPager(billingScopeParam, options)
		newListPager = &resp
		b.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armcostmanagement.BenefitRecommendationsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		b.newListPager.remove(req)
	}
	return resp, nil
}
