//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcostmanagement

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type Alert.
func (a Alert) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", a.ETag)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Alert.
func (a *Alert) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &a.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertProperties.
func (a AlertProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "closeTime", a.CloseTime)
	populate(objectMap, "costEntityId", a.CostEntityID)
	populate(objectMap, "creationTime", a.CreationTime)
	populate(objectMap, "definition", a.Definition)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "details", a.Details)
	populate(objectMap, "modificationTime", a.ModificationTime)
	populate(objectMap, "source", a.Source)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "statusModificationTime", a.StatusModificationTime)
	populate(objectMap, "statusModificationUserName", a.StatusModificationUserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertProperties.
func (a *AlertProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "closeTime":
			err = unpopulate(val, "CloseTime", &a.CloseTime)
			delete(rawMsg, key)
		case "costEntityId":
			err = unpopulate(val, "CostEntityID", &a.CostEntityID)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulate(val, "CreationTime", &a.CreationTime)
			delete(rawMsg, key)
		case "definition":
			err = unpopulate(val, "Definition", &a.Definition)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &a.Details)
			delete(rawMsg, key)
		case "modificationTime":
			err = unpopulate(val, "ModificationTime", &a.ModificationTime)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &a.Source)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "statusModificationTime":
			err = unpopulate(val, "StatusModificationTime", &a.StatusModificationTime)
			delete(rawMsg, key)
		case "statusModificationUserName":
			err = unpopulate(val, "StatusModificationUserName", &a.StatusModificationUserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertPropertiesDefinition.
func (a AlertPropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", a.Category)
	populate(objectMap, "criteria", a.Criteria)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertPropertiesDefinition.
func (a *AlertPropertiesDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &a.Category)
			delete(rawMsg, key)
		case "criteria":
			err = unpopulate(val, "Criteria", &a.Criteria)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertPropertiesDetails.
func (a AlertPropertiesDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", a.Amount)
	populate(objectMap, "companyName", a.CompanyName)
	populate(objectMap, "contactEmails", a.ContactEmails)
	populate(objectMap, "contactGroups", a.ContactGroups)
	populate(objectMap, "contactRoles", a.ContactRoles)
	populate(objectMap, "currentSpend", a.CurrentSpend)
	populate(objectMap, "departmentName", a.DepartmentName)
	populate(objectMap, "enrollmentEndDate", a.EnrollmentEndDate)
	populate(objectMap, "enrollmentNumber", a.EnrollmentNumber)
	populate(objectMap, "enrollmentStartDate", a.EnrollmentStartDate)
	populate(objectMap, "invoicingThreshold", a.InvoicingThreshold)
	populate(objectMap, "meterFilter", a.MeterFilter)
	populate(objectMap, "operator", a.Operator)
	populate(objectMap, "overridingAlert", a.OverridingAlert)
	populate(objectMap, "periodStartDate", a.PeriodStartDate)
	populate(objectMap, "resourceFilter", a.ResourceFilter)
	populate(objectMap, "resourceGroupFilter", a.ResourceGroupFilter)
	populateAny(objectMap, "tagFilter", a.TagFilter)
	populate(objectMap, "threshold", a.Threshold)
	populate(objectMap, "timeGrainType", a.TimeGrainType)
	populate(objectMap, "triggeredBy", a.TriggeredBy)
	populate(objectMap, "unit", a.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertPropertiesDetails.
func (a *AlertPropertiesDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &a.Amount)
			delete(rawMsg, key)
		case "companyName":
			err = unpopulate(val, "CompanyName", &a.CompanyName)
			delete(rawMsg, key)
		case "contactEmails":
			err = unpopulate(val, "ContactEmails", &a.ContactEmails)
			delete(rawMsg, key)
		case "contactGroups":
			err = unpopulate(val, "ContactGroups", &a.ContactGroups)
			delete(rawMsg, key)
		case "contactRoles":
			err = unpopulate(val, "ContactRoles", &a.ContactRoles)
			delete(rawMsg, key)
		case "currentSpend":
			err = unpopulate(val, "CurrentSpend", &a.CurrentSpend)
			delete(rawMsg, key)
		case "departmentName":
			err = unpopulate(val, "DepartmentName", &a.DepartmentName)
			delete(rawMsg, key)
		case "enrollmentEndDate":
			err = unpopulate(val, "EnrollmentEndDate", &a.EnrollmentEndDate)
			delete(rawMsg, key)
		case "enrollmentNumber":
			err = unpopulate(val, "EnrollmentNumber", &a.EnrollmentNumber)
			delete(rawMsg, key)
		case "enrollmentStartDate":
			err = unpopulate(val, "EnrollmentStartDate", &a.EnrollmentStartDate)
			delete(rawMsg, key)
		case "invoicingThreshold":
			err = unpopulate(val, "InvoicingThreshold", &a.InvoicingThreshold)
			delete(rawMsg, key)
		case "meterFilter":
			err = unpopulate(val, "MeterFilter", &a.MeterFilter)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &a.Operator)
			delete(rawMsg, key)
		case "overridingAlert":
			err = unpopulate(val, "OverridingAlert", &a.OverridingAlert)
			delete(rawMsg, key)
		case "periodStartDate":
			err = unpopulate(val, "PeriodStartDate", &a.PeriodStartDate)
			delete(rawMsg, key)
		case "resourceFilter":
			err = unpopulate(val, "ResourceFilter", &a.ResourceFilter)
			delete(rawMsg, key)
		case "resourceGroupFilter":
			err = unpopulate(val, "ResourceGroupFilter", &a.ResourceGroupFilter)
			delete(rawMsg, key)
		case "tagFilter":
			err = unpopulate(val, "TagFilter", &a.TagFilter)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, "Threshold", &a.Threshold)
			delete(rawMsg, key)
		case "timeGrainType":
			err = unpopulate(val, "TimeGrainType", &a.TimeGrainType)
			delete(rawMsg, key)
		case "triggeredBy":
			err = unpopulate(val, "TriggeredBy", &a.TriggeredBy)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &a.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AlertsResult.
func (a AlertsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AlertsResult.
func (a *AlertsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllSavingsBenefitDetails.
func (a AllSavingsBenefitDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "averageUtilizationPercentage", a.AverageUtilizationPercentage)
	populate(objectMap, "benefitCost", a.BenefitCost)
	populate(objectMap, "commitmentAmount", a.CommitmentAmount)
	populate(objectMap, "coveragePercentage", a.CoveragePercentage)
	populate(objectMap, "overageCost", a.OverageCost)
	populate(objectMap, "savingsAmount", a.SavingsAmount)
	populate(objectMap, "savingsPercentage", a.SavingsPercentage)
	populate(objectMap, "totalCost", a.TotalCost)
	populate(objectMap, "wastageCost", a.WastageCost)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllSavingsBenefitDetails.
func (a *AllSavingsBenefitDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "averageUtilizationPercentage":
			err = unpopulate(val, "AverageUtilizationPercentage", &a.AverageUtilizationPercentage)
			delete(rawMsg, key)
		case "benefitCost":
			err = unpopulate(val, "BenefitCost", &a.BenefitCost)
			delete(rawMsg, key)
		case "commitmentAmount":
			err = unpopulate(val, "CommitmentAmount", &a.CommitmentAmount)
			delete(rawMsg, key)
		case "coveragePercentage":
			err = unpopulate(val, "CoveragePercentage", &a.CoveragePercentage)
			delete(rawMsg, key)
		case "overageCost":
			err = unpopulate(val, "OverageCost", &a.OverageCost)
			delete(rawMsg, key)
		case "savingsAmount":
			err = unpopulate(val, "SavingsAmount", &a.SavingsAmount)
			delete(rawMsg, key)
		case "savingsPercentage":
			err = unpopulate(val, "SavingsPercentage", &a.SavingsPercentage)
			delete(rawMsg, key)
		case "totalCost":
			err = unpopulate(val, "TotalCost", &a.TotalCost)
			delete(rawMsg, key)
		case "wastageCost":
			err = unpopulate(val, "WastageCost", &a.WastageCost)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AllSavingsList.
func (a AllSavingsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AllSavingsList.
func (a *AllSavingsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BenefitRecommendationModel.
func (b BenefitRecommendationModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BenefitRecommendationModel.
func (b *BenefitRecommendationModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			b.Properties, err = unmarshalBenefitRecommendationPropertiesClassification(val)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BenefitRecommendationProperties.
func (b BenefitRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allRecommendationDetails", b.AllRecommendationDetails)
	populate(objectMap, "armSkuName", b.ArmSKUName)
	populate(objectMap, "commitmentGranularity", b.CommitmentGranularity)
	populate(objectMap, "costWithoutBenefit", b.CostWithoutBenefit)
	populate(objectMap, "currencyCode", b.CurrencyCode)
	populateDateTimeRFC3339(objectMap, "firstConsumptionDate", b.FirstConsumptionDate)
	populateDateTimeRFC3339(objectMap, "lastConsumptionDate", b.LastConsumptionDate)
	populate(objectMap, "lookBackPeriod", b.LookBackPeriod)
	populate(objectMap, "recommendationDetails", b.RecommendationDetails)
	objectMap["scope"] = b.Scope
	populate(objectMap, "term", b.Term)
	populate(objectMap, "totalHours", b.TotalHours)
	populate(objectMap, "usage", b.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BenefitRecommendationProperties.
func (b *BenefitRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allRecommendationDetails":
			err = unpopulate(val, "AllRecommendationDetails", &b.AllRecommendationDetails)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &b.ArmSKUName)
			delete(rawMsg, key)
		case "commitmentGranularity":
			err = unpopulate(val, "CommitmentGranularity", &b.CommitmentGranularity)
			delete(rawMsg, key)
		case "costWithoutBenefit":
			err = unpopulate(val, "CostWithoutBenefit", &b.CostWithoutBenefit)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &b.CurrencyCode)
			delete(rawMsg, key)
		case "firstConsumptionDate":
			err = unpopulateDateTimeRFC3339(val, "FirstConsumptionDate", &b.FirstConsumptionDate)
			delete(rawMsg, key)
		case "lastConsumptionDate":
			err = unpopulateDateTimeRFC3339(val, "LastConsumptionDate", &b.LastConsumptionDate)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &b.LookBackPeriod)
			delete(rawMsg, key)
		case "recommendationDetails":
			err = unpopulate(val, "RecommendationDetails", &b.RecommendationDetails)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &b.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &b.Term)
			delete(rawMsg, key)
		case "totalHours":
			err = unpopulate(val, "TotalHours", &b.TotalHours)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &b.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BenefitRecommendationsListResult.
func (b BenefitRecommendationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BenefitRecommendationsListResult.
func (b *BenefitRecommendationsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BenefitUtilizationSummariesListResult.
func (b BenefitUtilizationSummariesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BenefitUtilizationSummariesListResult.
func (b *BenefitUtilizationSummariesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			b.Value, err = unmarshalBenefitUtilizationSummaryClassificationArray(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BenefitUtilizationSummary.
func (b BenefitUtilizationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	objectMap["kind"] = b.Kind
	populate(objectMap, "name", b.Name)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BenefitUtilizationSummary.
func (b *BenefitUtilizationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BlobInfo.
func (b BlobInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobLink", b.BlobLink)
	populate(objectMap, "byteCount", b.ByteCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BlobInfo.
func (b *BlobInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobLink":
			err = unpopulate(val, "BlobLink", &b.BlobLink)
			delete(rawMsg, key)
		case "byteCount":
			err = unpopulate(val, "ByteCount", &b.ByteCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityRequest.
func (c CheckNameAvailabilityRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityRequest.
func (c *CheckNameAvailabilityRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResponse.
func (c CheckNameAvailabilityResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResponse.
func (c *CheckNameAvailabilityResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommonExportProperties.
func (c CommonExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "definition", c.Definition)
	populate(objectMap, "deliveryInfo", c.DeliveryInfo)
	populate(objectMap, "format", c.Format)
	populateDateTimeRFC3339(objectMap, "nextRunTimeEstimate", c.NextRunTimeEstimate)
	populate(objectMap, "partitionData", c.PartitionData)
	populate(objectMap, "runHistory", c.RunHistory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommonExportProperties.
func (c *CommonExportProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &c.Definition)
			delete(rawMsg, key)
		case "deliveryInfo":
			err = unpopulate(val, "DeliveryInfo", &c.DeliveryInfo)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &c.Format)
			delete(rawMsg, key)
		case "nextRunTimeEstimate":
			err = unpopulateDateTimeRFC3339(val, "NextRunTimeEstimate", &c.NextRunTimeEstimate)
			delete(rawMsg, key)
		case "partitionData":
			err = unpopulate(val, "PartitionData", &c.PartitionData)
			delete(rawMsg, key)
		case "runHistory":
			err = unpopulate(val, "RunHistory", &c.RunHistory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CostDetailsOperationResults.
func (c CostDetailsOperationResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "manifest", c.Manifest)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "type", c.Type)
	populateDateTimeRFC3339(objectMap, "validTill", c.ValidTill)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CostDetailsOperationResults.
func (c *CostDetailsOperationResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "manifest":
			err = unpopulate(val, "Manifest", &c.Manifest)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		case "validTill":
			err = unpopulateDateTimeRFC3339(val, "ValidTill", &c.ValidTill)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CostDetailsTimePeriod.
func (c CostDetailsTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end", c.End)
	populate(objectMap, "start", c.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CostDetailsTimePeriod.
func (c *CostDetailsTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulate(val, "End", &c.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &c.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Dimension.
func (d Dimension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", d.ETag)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "sku", d.SKU)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Dimension.
func (d *Dimension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &d.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &d.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DimensionProperties.
func (d DimensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", d.Category)
	populate(objectMap, "data", d.Data)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "filterEnabled", d.FilterEnabled)
	populate(objectMap, "groupingEnabled", d.GroupingEnabled)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "total", d.Total)
	populateDateTimeRFC3339(objectMap, "usageEnd", d.UsageEnd)
	populateDateTimeRFC3339(objectMap, "usageStart", d.UsageStart)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DimensionProperties.
func (d *DimensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &d.Category)
			delete(rawMsg, key)
		case "data":
			err = unpopulate(val, "Data", &d.Data)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "filterEnabled":
			err = unpopulate(val, "FilterEnabled", &d.FilterEnabled)
			delete(rawMsg, key)
		case "groupingEnabled":
			err = unpopulate(val, "GroupingEnabled", &d.GroupingEnabled)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "total":
			err = unpopulate(val, "Total", &d.Total)
			delete(rawMsg, key)
		case "usageEnd":
			err = unpopulateDateTimeRFC3339(val, "UsageEnd", &d.UsageEnd)
			delete(rawMsg, key)
		case "usageStart":
			err = unpopulateDateTimeRFC3339(val, "UsageStart", &d.UsageStart)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DimensionsListResult.
func (d DimensionsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DimensionsListResult.
func (d *DimensionsListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DismissAlertPayload.
func (d DismissAlertPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DismissAlertPayload.
func (d *DismissAlertPayload) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DownloadURL.
func (d DownloadURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "downloadUrl", d.DownloadURL)
	populateDateTimeRFC3339(objectMap, "expiryTime", d.ExpiryTime)
	populateDateTimeRFC3339(objectMap, "validTill", d.ValidTill)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURL.
func (d *DownloadURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "downloadUrl":
			err = unpopulate(val, "DownloadURL", &d.DownloadURL)
			delete(rawMsg, key)
		case "expiryTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryTime", &d.ExpiryTime)
			delete(rawMsg, key)
		case "validTill":
			err = unpopulateDateTimeRFC3339(val, "ValidTill", &d.ValidTill)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Export.
func (e Export) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", e.ETag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Export.
func (e *Export) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &e.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDataset.
func (e ExportDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "configuration", e.Configuration)
	populate(objectMap, "granularity", e.Granularity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDataset.
func (e *ExportDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "configuration":
			err = unpopulate(val, "Configuration", &e.Configuration)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &e.Granularity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDatasetConfiguration.
func (e ExportDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", e.Columns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDatasetConfiguration.
func (e *ExportDatasetConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &e.Columns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDefinition.
func (e ExportDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSet", e.DataSet)
	populate(objectMap, "timePeriod", e.TimePeriod)
	populate(objectMap, "timeframe", e.Timeframe)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDefinition.
func (e *ExportDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSet":
			err = unpopulate(val, "DataSet", &e.DataSet)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &e.TimePeriod)
			delete(rawMsg, key)
		case "timeframe":
			err = unpopulate(val, "Timeframe", &e.Timeframe)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDeliveryDestination.
func (e ExportDeliveryDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "container", e.Container)
	populate(objectMap, "resourceId", e.ResourceID)
	populate(objectMap, "rootFolderPath", e.RootFolderPath)
	populate(objectMap, "sasToken", e.SasToken)
	populate(objectMap, "storageAccount", e.StorageAccount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDeliveryDestination.
func (e *ExportDeliveryDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "container":
			err = unpopulate(val, "Container", &e.Container)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &e.ResourceID)
			delete(rawMsg, key)
		case "rootFolderPath":
			err = unpopulate(val, "RootFolderPath", &e.RootFolderPath)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &e.SasToken)
			delete(rawMsg, key)
		case "storageAccount":
			err = unpopulate(val, "StorageAccount", &e.StorageAccount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportDeliveryInfo.
func (e ExportDeliveryInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destination", e.Destination)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportDeliveryInfo.
func (e *ExportDeliveryInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destination":
			err = unpopulate(val, "Destination", &e.Destination)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportExecutionListResult.
func (e ExportExecutionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportExecutionListResult.
func (e *ExportExecutionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportListResult.
func (e ExportListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportListResult.
func (e *ExportListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportProperties.
func (e ExportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "definition", e.Definition)
	populate(objectMap, "deliveryInfo", e.DeliveryInfo)
	populate(objectMap, "format", e.Format)
	populateDateTimeRFC3339(objectMap, "nextRunTimeEstimate", e.NextRunTimeEstimate)
	populate(objectMap, "partitionData", e.PartitionData)
	populate(objectMap, "runHistory", e.RunHistory)
	populate(objectMap, "schedule", e.Schedule)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportProperties.
func (e *ExportProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "definition":
			err = unpopulate(val, "Definition", &e.Definition)
			delete(rawMsg, key)
		case "deliveryInfo":
			err = unpopulate(val, "DeliveryInfo", &e.DeliveryInfo)
			delete(rawMsg, key)
		case "format":
			err = unpopulate(val, "Format", &e.Format)
			delete(rawMsg, key)
		case "nextRunTimeEstimate":
			err = unpopulateDateTimeRFC3339(val, "NextRunTimeEstimate", &e.NextRunTimeEstimate)
			delete(rawMsg, key)
		case "partitionData":
			err = unpopulate(val, "PartitionData", &e.PartitionData)
			delete(rawMsg, key)
		case "runHistory":
			err = unpopulate(val, "RunHistory", &e.RunHistory)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &e.Schedule)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportRecurrencePeriod.
func (e ExportRecurrencePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "from", e.From)
	populateDateTimeRFC3339(objectMap, "to", e.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportRecurrencePeriod.
func (e *ExportRecurrencePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateDateTimeRFC3339(val, "From", &e.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateDateTimeRFC3339(val, "To", &e.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportRun.
func (e ExportRun) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", e.ETag)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportRun.
func (e *ExportRun) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &e.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportRunProperties.
func (e ExportRunProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "executionType", e.ExecutionType)
	populate(objectMap, "fileName", e.FileName)
	populateDateTimeRFC3339(objectMap, "processingEndTime", e.ProcessingEndTime)
	populateDateTimeRFC3339(objectMap, "processingStartTime", e.ProcessingStartTime)
	populate(objectMap, "runSettings", e.RunSettings)
	populate(objectMap, "status", e.Status)
	populate(objectMap, "submittedBy", e.SubmittedBy)
	populateDateTimeRFC3339(objectMap, "submittedTime", e.SubmittedTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportRunProperties.
func (e *ExportRunProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "executionType":
			err = unpopulate(val, "ExecutionType", &e.ExecutionType)
			delete(rawMsg, key)
		case "fileName":
			err = unpopulate(val, "FileName", &e.FileName)
			delete(rawMsg, key)
		case "processingEndTime":
			err = unpopulateDateTimeRFC3339(val, "ProcessingEndTime", &e.ProcessingEndTime)
			delete(rawMsg, key)
		case "processingStartTime":
			err = unpopulateDateTimeRFC3339(val, "ProcessingStartTime", &e.ProcessingStartTime)
			delete(rawMsg, key)
		case "runSettings":
			err = unpopulate(val, "RunSettings", &e.RunSettings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		case "submittedBy":
			err = unpopulate(val, "SubmittedBy", &e.SubmittedBy)
			delete(rawMsg, key)
		case "submittedTime":
			err = unpopulateDateTimeRFC3339(val, "SubmittedTime", &e.SubmittedTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportSchedule.
func (e ExportSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recurrence", e.Recurrence)
	populate(objectMap, "recurrencePeriod", e.RecurrencePeriod)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportSchedule.
func (e *ExportSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recurrence":
			err = unpopulate(val, "Recurrence", &e.Recurrence)
			delete(rawMsg, key)
		case "recurrencePeriod":
			err = unpopulate(val, "RecurrencePeriod", &e.RecurrencePeriod)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportTimePeriod.
func (e ExportTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "from", e.From)
	populateDateTimeRFC3339(objectMap, "to", e.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportTimePeriod.
func (e *ExportTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateDateTimeRFC3339(val, "From", &e.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateDateTimeRFC3339(val, "To", &e.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FileDestination.
func (f FileDestination) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fileFormats", f.FileFormats)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FileDestination.
func (f *FileDestination) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileFormats":
			err = unpopulate(val, "FileFormats", &f.FileFormats)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastAggregation.
func (f ForecastAggregation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", f.Function)
	populate(objectMap, "name", f.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastAggregation.
func (f *ForecastAggregation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &f.Function)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastColumn.
func (f ForecastColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastColumn.
func (f *ForecastColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastComparisonExpression.
func (f ForecastComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "operator", f.Operator)
	populate(objectMap, "values", f.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastComparisonExpression.
func (f *ForecastComparisonExpression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &f.Operator)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &f.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastDataset.
func (f ForecastDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregation", f.Aggregation)
	populate(objectMap, "configuration", f.Configuration)
	populate(objectMap, "filter", f.Filter)
	populate(objectMap, "granularity", f.Granularity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastDataset.
func (f *ForecastDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregation":
			err = unpopulate(val, "Aggregation", &f.Aggregation)
			delete(rawMsg, key)
		case "configuration":
			err = unpopulate(val, "Configuration", &f.Configuration)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &f.Filter)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &f.Granularity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastDatasetConfiguration.
func (f ForecastDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", f.Columns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastDatasetConfiguration.
func (f *ForecastDatasetConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &f.Columns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastDefinition.
func (f ForecastDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", f.Dataset)
	populate(objectMap, "includeActualCost", f.IncludeActualCost)
	populate(objectMap, "includeFreshPartialCost", f.IncludeFreshPartialCost)
	populate(objectMap, "timePeriod", f.TimePeriod)
	populate(objectMap, "timeframe", f.Timeframe)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastDefinition.
func (f *ForecastDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &f.Dataset)
			delete(rawMsg, key)
		case "includeActualCost":
			err = unpopulate(val, "IncludeActualCost", &f.IncludeActualCost)
			delete(rawMsg, key)
		case "includeFreshPartialCost":
			err = unpopulate(val, "IncludeFreshPartialCost", &f.IncludeFreshPartialCost)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &f.TimePeriod)
			delete(rawMsg, key)
		case "timeframe":
			err = unpopulate(val, "Timeframe", &f.Timeframe)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastFilter.
func (f ForecastFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "and", f.And)
	populate(objectMap, "dimensions", f.Dimensions)
	populate(objectMap, "or", f.Or)
	populate(objectMap, "tags", f.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastFilter.
func (f *ForecastFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "and":
			err = unpopulate(val, "And", &f.And)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &f.Dimensions)
			delete(rawMsg, key)
		case "or":
			err = unpopulate(val, "Or", &f.Or)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastProperties.
func (f ForecastProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", f.Columns)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "rows", f.Rows)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastProperties.
func (f *ForecastProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &f.Columns)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "rows":
			err = unpopulate(val, "Rows", &f.Rows)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastResult.
func (f ForecastResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", f.ETag)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "sku", f.SKU)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastResult.
func (f *ForecastResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &f.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &f.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastTimePeriod.
func (f ForecastTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "from", f.From)
	populateDateTimeRFC3339(objectMap, "to", f.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastTimePeriod.
func (f *ForecastTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateDateTimeRFC3339(val, "From", &f.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateDateTimeRFC3339(val, "To", &f.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateCostDetailsReportRequestDefinition.
func (g GenerateCostDetailsReportRequestDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingPeriod", g.BillingPeriod)
	populate(objectMap, "invoiceId", g.InvoiceID)
	populate(objectMap, "metric", g.Metric)
	populate(objectMap, "timePeriod", g.TimePeriod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateCostDetailsReportRequestDefinition.
func (g *GenerateCostDetailsReportRequestDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingPeriod":
			err = unpopulate(val, "BillingPeriod", &g.BillingPeriod)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &g.InvoiceID)
			delete(rawMsg, key)
		case "metric":
			err = unpopulate(val, "Metric", &g.Metric)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &g.TimePeriod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateDetailedCostReportDefinition.
func (g GenerateDetailedCostReportDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingPeriod", g.BillingPeriod)
	populate(objectMap, "customerId", g.CustomerID)
	populate(objectMap, "invoiceId", g.InvoiceID)
	populate(objectMap, "metric", g.Metric)
	populate(objectMap, "timePeriod", g.TimePeriod)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateDetailedCostReportDefinition.
func (g *GenerateDetailedCostReportDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingPeriod":
			err = unpopulate(val, "BillingPeriod", &g.BillingPeriod)
			delete(rawMsg, key)
		case "customerId":
			err = unpopulate(val, "CustomerID", &g.CustomerID)
			delete(rawMsg, key)
		case "invoiceId":
			err = unpopulate(val, "InvoiceID", &g.InvoiceID)
			delete(rawMsg, key)
		case "metric":
			err = unpopulate(val, "Metric", &g.Metric)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &g.TimePeriod)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateDetailedCostReportOperationResult.
func (g GenerateDetailedCostReportOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateDetailedCostReportOperationResult.
func (g *GenerateDetailedCostReportOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateDetailedCostReportOperationStatuses.
func (g GenerateDetailedCostReportOperationStatuses) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", g.EndTime)
	populate(objectMap, "error", g.Error)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "startTime", g.StartTime)
	populate(objectMap, "status", g.Status)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateDetailedCostReportOperationStatuses.
func (g *GenerateDetailedCostReportOperationStatuses) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &g.EndTime)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &g.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &g.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &g.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateDetailedCostReportTimePeriod.
func (g GenerateDetailedCostReportTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "end", g.End)
	populate(objectMap, "start", g.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateDetailedCostReportTimePeriod.
func (g *GenerateDetailedCostReportTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulate(val, "End", &g.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulate(val, "Start", &g.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncludedQuantityUtilizationSummary.
func (i IncludedQuantityUtilizationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", i.ID)
	objectMap["kind"] = BenefitKindIncludedQuantity
	populate(objectMap, "name", i.Name)
	populate(objectMap, "properties", i.Properties)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncludedQuantityUtilizationSummary.
func (i *IncludedQuantityUtilizationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &i.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &i.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &i.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &i.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IncludedQuantityUtilizationSummaryProperties.
func (i IncludedQuantityUtilizationSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "armSkuName", i.ArmSKUName)
	populate(objectMap, "benefitId", i.BenefitID)
	populate(objectMap, "benefitOrderId", i.BenefitOrderID)
	populate(objectMap, "benefitType", i.BenefitType)
	populateDateTimeRFC3339(objectMap, "usageDate", i.UsageDate)
	populate(objectMap, "utilizationPercentage", i.UtilizationPercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IncludedQuantityUtilizationSummaryProperties.
func (i *IncludedQuantityUtilizationSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &i.ArmSKUName)
			delete(rawMsg, key)
		case "benefitId":
			err = unpopulate(val, "BenefitID", &i.BenefitID)
			delete(rawMsg, key)
		case "benefitOrderId":
			err = unpopulate(val, "BenefitOrderID", &i.BenefitOrderID)
			delete(rawMsg, key)
		case "benefitType":
			err = unpopulate(val, "BenefitType", &i.BenefitType)
			delete(rawMsg, key)
		case "usageDate":
			err = unpopulateDateTimeRFC3339(val, "UsageDate", &i.UsageDate)
			delete(rawMsg, key)
		case "utilizationPercentage":
			err = unpopulate(val, "UtilizationPercentage", &i.UtilizationPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KpiProperties.
func (k KpiProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", k.Enabled)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KpiProperties.
func (k *KpiProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &k.Enabled)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationProperties.
func (n NotificationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "language", n.Language)
	populate(objectMap, "message", n.Message)
	populate(objectMap, "regionalFormat", n.RegionalFormat)
	populate(objectMap, "subject", n.Subject)
	populate(objectMap, "to", n.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationProperties.
func (n *NotificationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "language":
			err = unpopulate(val, "Language", &n.Language)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &n.Message)
			delete(rawMsg, key)
		case "regionalFormat":
			err = unpopulate(val, "RegionalFormat", &n.RegionalFormat)
			delete(rawMsg, key)
		case "subject":
			err = unpopulate(val, "Subject", &n.Subject)
			delete(rawMsg, key)
		case "to":
			err = unpopulate(val, "To", &n.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationForCostManagement.
func (o OperationForCostManagement) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationForCostManagement.
func (o *OperationForCostManagement) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatus.
func (o OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PivotProperties.
func (p PivotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PivotProperties.
func (p *PivotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryAggregation.
func (q QueryAggregation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", q.Function)
	populate(objectMap, "name", q.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryAggregation.
func (q *QueryAggregation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &q.Function)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryColumn.
func (q QueryColumn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryColumn.
func (q *QueryColumn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryComparisonExpression.
func (q QueryComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "operator", q.Operator)
	populate(objectMap, "values", q.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryComparisonExpression.
func (q *QueryComparisonExpression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &q.Operator)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &q.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryDataset.
func (q QueryDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregation", q.Aggregation)
	populate(objectMap, "configuration", q.Configuration)
	populate(objectMap, "filter", q.Filter)
	populate(objectMap, "granularity", q.Granularity)
	populate(objectMap, "grouping", q.Grouping)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryDataset.
func (q *QueryDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregation":
			err = unpopulate(val, "Aggregation", &q.Aggregation)
			delete(rawMsg, key)
		case "configuration":
			err = unpopulate(val, "Configuration", &q.Configuration)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &q.Filter)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &q.Granularity)
			delete(rawMsg, key)
		case "grouping":
			err = unpopulate(val, "Grouping", &q.Grouping)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryDatasetConfiguration.
func (q QueryDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", q.Columns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryDatasetConfiguration.
func (q *QueryDatasetConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &q.Columns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryDefinition.
func (q QueryDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataset", q.Dataset)
	populate(objectMap, "timePeriod", q.TimePeriod)
	populate(objectMap, "timeframe", q.Timeframe)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryDefinition.
func (q *QueryDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataset":
			err = unpopulate(val, "Dataset", &q.Dataset)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &q.TimePeriod)
			delete(rawMsg, key)
		case "timeframe":
			err = unpopulate(val, "Timeframe", &q.Timeframe)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryFilter.
func (q QueryFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "and", q.And)
	populate(objectMap, "dimensions", q.Dimensions)
	populate(objectMap, "or", q.Or)
	populate(objectMap, "tags", q.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryFilter.
func (q *QueryFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "and":
			err = unpopulate(val, "And", &q.And)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &q.Dimensions)
			delete(rawMsg, key)
		case "or":
			err = unpopulate(val, "Or", &q.Or)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &q.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryGrouping.
func (q QueryGrouping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryGrouping.
func (q *QueryGrouping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryProperties.
func (q QueryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", q.Columns)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "rows", q.Rows)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryProperties.
func (q *QueryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &q.Columns)
			delete(rawMsg, key)
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "rows":
			err = unpopulate(val, "Rows", &q.Rows)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryResult.
func (q QueryResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", q.ETag)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "location", q.Location)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.Properties)
	populate(objectMap, "sku", q.SKU)
	populate(objectMap, "tags", q.Tags)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryResult.
func (q *QueryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &q.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &q.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &q.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &q.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryTimePeriod.
func (q QueryTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "from", q.From)
	populateDateTimeRFC3339(objectMap, "to", q.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryTimePeriod.
func (q *QueryTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateDateTimeRFC3339(val, "From", &q.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateDateTimeRFC3339(val, "To", &q.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecommendationUsageDetails.
func (r RecommendationUsageDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "charges", r.Charges)
	populate(objectMap, "usageGrain", r.UsageGrain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecommendationUsageDetails.
func (r *RecommendationUsageDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "charges":
			err = unpopulate(val, "Charges", &r.Charges)
			delete(rawMsg, key)
		case "usageGrain":
			err = unpopulate(val, "UsageGrain", &r.UsageGrain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigAggregation.
func (r ReportConfigAggregation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "function", r.Function)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigAggregation.
func (r *ReportConfigAggregation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "function":
			err = unpopulate(val, "Function", &r.Function)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigComparisonExpression.
func (r ReportConfigComparisonExpression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "operator", r.Operator)
	populate(objectMap, "values", r.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigComparisonExpression.
func (r *ReportConfigComparisonExpression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "operator":
			err = unpopulate(val, "Operator", &r.Operator)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &r.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigDataset.
func (r ReportConfigDataset) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregation", r.Aggregation)
	populate(objectMap, "configuration", r.Configuration)
	populate(objectMap, "filter", r.Filter)
	populate(objectMap, "granularity", r.Granularity)
	populate(objectMap, "grouping", r.Grouping)
	populate(objectMap, "sorting", r.Sorting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigDataset.
func (r *ReportConfigDataset) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregation":
			err = unpopulate(val, "Aggregation", &r.Aggregation)
			delete(rawMsg, key)
		case "configuration":
			err = unpopulate(val, "Configuration", &r.Configuration)
			delete(rawMsg, key)
		case "filter":
			err = unpopulate(val, "Filter", &r.Filter)
			delete(rawMsg, key)
		case "granularity":
			err = unpopulate(val, "Granularity", &r.Granularity)
			delete(rawMsg, key)
		case "grouping":
			err = unpopulate(val, "Grouping", &r.Grouping)
			delete(rawMsg, key)
		case "sorting":
			err = unpopulate(val, "Sorting", &r.Sorting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigDatasetConfiguration.
func (r ReportConfigDatasetConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "columns", r.Columns)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigDatasetConfiguration.
func (r *ReportConfigDatasetConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "columns":
			err = unpopulate(val, "Columns", &r.Columns)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigDefinition.
func (r ReportConfigDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataSet", r.DataSet)
	populate(objectMap, "includeMonetaryCommitment", r.IncludeMonetaryCommitment)
	populate(objectMap, "timePeriod", r.TimePeriod)
	populate(objectMap, "timeframe", r.Timeframe)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigDefinition.
func (r *ReportConfigDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataSet":
			err = unpopulate(val, "DataSet", &r.DataSet)
			delete(rawMsg, key)
		case "includeMonetaryCommitment":
			err = unpopulate(val, "IncludeMonetaryCommitment", &r.IncludeMonetaryCommitment)
			delete(rawMsg, key)
		case "timePeriod":
			err = unpopulate(val, "TimePeriod", &r.TimePeriod)
			delete(rawMsg, key)
		case "timeframe":
			err = unpopulate(val, "Timeframe", &r.Timeframe)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigFilter.
func (r ReportConfigFilter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "and", r.And)
	populate(objectMap, "dimensions", r.Dimensions)
	populate(objectMap, "or", r.Or)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigFilter.
func (r *ReportConfigFilter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "and":
			err = unpopulate(val, "And", &r.And)
			delete(rawMsg, key)
		case "dimensions":
			err = unpopulate(val, "Dimensions", &r.Dimensions)
			delete(rawMsg, key)
		case "or":
			err = unpopulate(val, "Or", &r.Or)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigGrouping.
func (r ReportConfigGrouping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigGrouping.
func (r *ReportConfigGrouping) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigSorting.
func (r ReportConfigSorting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "direction", r.Direction)
	populate(objectMap, "name", r.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigSorting.
func (r *ReportConfigSorting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "direction":
			err = unpopulate(val, "Direction", &r.Direction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportConfigTimePeriod.
func (r ReportConfigTimePeriod) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "from", r.From)
	populateDateTimeRFC3339(objectMap, "to", r.To)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportConfigTimePeriod.
func (r *ReportConfigTimePeriod) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "from":
			err = unpopulateDateTimeRFC3339(val, "From", &r.From)
			delete(rawMsg, key)
		case "to":
			err = unpopulateDateTimeRFC3339(val, "To", &r.To)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportManifest.
func (r ReportManifest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobCount", r.BlobCount)
	populate(objectMap, "blobs", r.Blobs)
	populate(objectMap, "byteCount", r.ByteCount)
	populate(objectMap, "compressData", r.CompressData)
	populate(objectMap, "dataFormat", r.DataFormat)
	populate(objectMap, "manifestVersion", r.ManifestVersion)
	populate(objectMap, "requestContext", r.RequestContext)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportManifest.
func (r *ReportManifest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobCount":
			err = unpopulate(val, "BlobCount", &r.BlobCount)
			delete(rawMsg, key)
		case "blobs":
			err = unpopulate(val, "Blobs", &r.Blobs)
			delete(rawMsg, key)
		case "byteCount":
			err = unpopulate(val, "ByteCount", &r.ByteCount)
			delete(rawMsg, key)
		case "compressData":
			err = unpopulate(val, "CompressData", &r.CompressData)
			delete(rawMsg, key)
		case "dataFormat":
			err = unpopulate(val, "DataFormat", &r.DataFormat)
			delete(rawMsg, key)
		case "manifestVersion":
			err = unpopulate(val, "ManifestVersion", &r.ManifestVersion)
			delete(rawMsg, key)
		case "requestContext":
			err = unpopulate(val, "RequestContext", &r.RequestContext)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReportURL.
func (r ReportURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reportUrl", r.ReportURL)
	populateDateTimeRFC3339(objectMap, "validUntil", r.ValidUntil)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReportURL.
func (r *ReportURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reportUrl":
			err = unpopulate(val, "ReportURL", &r.ReportURL)
			delete(rawMsg, key)
		case "validUntil":
			err = unpopulateDateTimeRFC3339(val, "ValidUntil", &r.ValidUntil)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestContext.
func (r RequestContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "requestBody", r.RequestBody)
	populate(objectMap, "requestScope", r.RequestScope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestContext.
func (r *RequestContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "requestBody":
			err = unpopulate(val, "RequestBody", &r.RequestBody)
			delete(rawMsg, key)
		case "requestScope":
			err = unpopulate(val, "RequestScope", &r.RequestScope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanUtilizationSummary.
func (s SavingsPlanUtilizationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	objectMap["kind"] = BenefitKindSavingsPlan
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanUtilizationSummary.
func (s *SavingsPlanUtilizationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanUtilizationSummaryProperties.
func (s SavingsPlanUtilizationSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "armSkuName", s.ArmSKUName)
	populate(objectMap, "avgUtilizationPercentage", s.AvgUtilizationPercentage)
	populate(objectMap, "benefitId", s.BenefitID)
	populate(objectMap, "benefitOrderId", s.BenefitOrderID)
	populate(objectMap, "benefitType", s.BenefitType)
	populate(objectMap, "maxUtilizationPercentage", s.MaxUtilizationPercentage)
	populate(objectMap, "minUtilizationPercentage", s.MinUtilizationPercentage)
	populateDateTimeRFC3339(objectMap, "usageDate", s.UsageDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanUtilizationSummaryProperties.
func (s *SavingsPlanUtilizationSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &s.ArmSKUName)
			delete(rawMsg, key)
		case "avgUtilizationPercentage":
			err = unpopulate(val, "AvgUtilizationPercentage", &s.AvgUtilizationPercentage)
			delete(rawMsg, key)
		case "benefitId":
			err = unpopulate(val, "BenefitID", &s.BenefitID)
			delete(rawMsg, key)
		case "benefitOrderId":
			err = unpopulate(val, "BenefitOrderID", &s.BenefitOrderID)
			delete(rawMsg, key)
		case "benefitType":
			err = unpopulate(val, "BenefitType", &s.BenefitType)
			delete(rawMsg, key)
		case "maxUtilizationPercentage":
			err = unpopulate(val, "MaxUtilizationPercentage", &s.MaxUtilizationPercentage)
			delete(rawMsg, key)
		case "minUtilizationPercentage":
			err = unpopulate(val, "MinUtilizationPercentage", &s.MinUtilizationPercentage)
			delete(rawMsg, key)
		case "usageDate":
			err = unpopulateDateTimeRFC3339(val, "UsageDate", &s.UsageDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleProperties.
func (s ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfMonth", s.DayOfMonth)
	populate(objectMap, "daysOfWeek", s.DaysOfWeek)
	populateDateTimeRFC3339(objectMap, "endDate", s.EndDate)
	populate(objectMap, "frequency", s.Frequency)
	populate(objectMap, "hourOfDay", s.HourOfDay)
	populateDateTimeRFC3339(objectMap, "startDate", s.StartDate)
	populate(objectMap, "weeksOfMonth", s.WeeksOfMonth)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleProperties.
func (s *ScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfMonth":
			err = unpopulate(val, "DayOfMonth", &s.DayOfMonth)
			delete(rawMsg, key)
		case "daysOfWeek":
			err = unpopulate(val, "DaysOfWeek", &s.DaysOfWeek)
			delete(rawMsg, key)
		case "endDate":
			err = unpopulateDateTimeRFC3339(val, "EndDate", &s.EndDate)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &s.Frequency)
			delete(rawMsg, key)
		case "hourOfDay":
			err = unpopulate(val, "HourOfDay", &s.HourOfDay)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateTimeRFC3339(val, "StartDate", &s.StartDate)
			delete(rawMsg, key)
		case "weeksOfMonth":
			err = unpopulate(val, "WeeksOfMonth", &s.WeeksOfMonth)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledAction.
func (s ScheduledAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", s.ETag)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledAction.
func (s *ScheduledAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &s.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledActionListResult.
func (s ScheduledActionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledActionListResult.
func (s *ScheduledActionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduledActionProperties.
func (s ScheduledActionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "fileDestination", s.FileDestination)
	populate(objectMap, "notification", s.Notification)
	populate(objectMap, "notificationEmail", s.NotificationEmail)
	populate(objectMap, "schedule", s.Schedule)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "viewId", s.ViewID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduledActionProperties.
func (s *ScheduledActionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "fileDestination":
			err = unpopulate(val, "FileDestination", &s.FileDestination)
			delete(rawMsg, key)
		case "notification":
			err = unpopulate(val, "Notification", &s.Notification)
			delete(rawMsg, key)
		case "notificationEmail":
			err = unpopulate(val, "NotificationEmail", &s.NotificationEmail)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &s.Schedule)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "viewId":
			err = unpopulate(val, "ViewID", &s.ViewID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedScopeBenefitRecommendationProperties.
func (s SharedScopeBenefitRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allRecommendationDetails", s.AllRecommendationDetails)
	populate(objectMap, "armSkuName", s.ArmSKUName)
	populate(objectMap, "commitmentGranularity", s.CommitmentGranularity)
	populate(objectMap, "costWithoutBenefit", s.CostWithoutBenefit)
	populate(objectMap, "currencyCode", s.CurrencyCode)
	populateDateTimeRFC3339(objectMap, "firstConsumptionDate", s.FirstConsumptionDate)
	populateDateTimeRFC3339(objectMap, "lastConsumptionDate", s.LastConsumptionDate)
	populate(objectMap, "lookBackPeriod", s.LookBackPeriod)
	populate(objectMap, "recommendationDetails", s.RecommendationDetails)
	objectMap["scope"] = ScopeShared
	populate(objectMap, "term", s.Term)
	populate(objectMap, "totalHours", s.TotalHours)
	populate(objectMap, "usage", s.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedScopeBenefitRecommendationProperties.
func (s *SharedScopeBenefitRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allRecommendationDetails":
			err = unpopulate(val, "AllRecommendationDetails", &s.AllRecommendationDetails)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &s.ArmSKUName)
			delete(rawMsg, key)
		case "commitmentGranularity":
			err = unpopulate(val, "CommitmentGranularity", &s.CommitmentGranularity)
			delete(rawMsg, key)
		case "costWithoutBenefit":
			err = unpopulate(val, "CostWithoutBenefit", &s.CostWithoutBenefit)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &s.CurrencyCode)
			delete(rawMsg, key)
		case "firstConsumptionDate":
			err = unpopulateDateTimeRFC3339(val, "FirstConsumptionDate", &s.FirstConsumptionDate)
			delete(rawMsg, key)
		case "lastConsumptionDate":
			err = unpopulateDateTimeRFC3339(val, "LastConsumptionDate", &s.LastConsumptionDate)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &s.LookBackPeriod)
			delete(rawMsg, key)
		case "recommendationDetails":
			err = unpopulate(val, "RecommendationDetails", &s.RecommendationDetails)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &s.Term)
			delete(rawMsg, key)
		case "totalHours":
			err = unpopulate(val, "TotalHours", &s.TotalHours)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &s.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingleScopeBenefitRecommendationProperties.
func (s SingleScopeBenefitRecommendationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allRecommendationDetails", s.AllRecommendationDetails)
	populate(objectMap, "armSkuName", s.ArmSKUName)
	populate(objectMap, "commitmentGranularity", s.CommitmentGranularity)
	populate(objectMap, "costWithoutBenefit", s.CostWithoutBenefit)
	populate(objectMap, "currencyCode", s.CurrencyCode)
	populateDateTimeRFC3339(objectMap, "firstConsumptionDate", s.FirstConsumptionDate)
	populateDateTimeRFC3339(objectMap, "lastConsumptionDate", s.LastConsumptionDate)
	populate(objectMap, "lookBackPeriod", s.LookBackPeriod)
	populate(objectMap, "recommendationDetails", s.RecommendationDetails)
	populate(objectMap, "resourceGroup", s.ResourceGroup)
	objectMap["scope"] = ScopeSingle
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	populate(objectMap, "term", s.Term)
	populate(objectMap, "totalHours", s.TotalHours)
	populate(objectMap, "usage", s.Usage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingleScopeBenefitRecommendationProperties.
func (s *SingleScopeBenefitRecommendationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allRecommendationDetails":
			err = unpopulate(val, "AllRecommendationDetails", &s.AllRecommendationDetails)
			delete(rawMsg, key)
		case "armSkuName":
			err = unpopulate(val, "ArmSKUName", &s.ArmSKUName)
			delete(rawMsg, key)
		case "commitmentGranularity":
			err = unpopulate(val, "CommitmentGranularity", &s.CommitmentGranularity)
			delete(rawMsg, key)
		case "costWithoutBenefit":
			err = unpopulate(val, "CostWithoutBenefit", &s.CostWithoutBenefit)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &s.CurrencyCode)
			delete(rawMsg, key)
		case "firstConsumptionDate":
			err = unpopulateDateTimeRFC3339(val, "FirstConsumptionDate", &s.FirstConsumptionDate)
			delete(rawMsg, key)
		case "lastConsumptionDate":
			err = unpopulateDateTimeRFC3339(val, "LastConsumptionDate", &s.LastConsumptionDate)
			delete(rawMsg, key)
		case "lookBackPeriod":
			err = unpopulate(val, "LookBackPeriod", &s.LookBackPeriod)
			delete(rawMsg, key)
		case "recommendationDetails":
			err = unpopulate(val, "RecommendationDetails", &s.RecommendationDetails)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &s.ResourceGroup)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &s.Term)
			delete(rawMsg, key)
		case "totalHours":
			err = unpopulate(val, "TotalHours", &s.TotalHours)
			delete(rawMsg, key)
		case "usage":
			err = unpopulate(val, "Usage", &s.Usage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Status.
func (s Status) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Status.
func (s *Status) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type View.
func (v View) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eTag", v.ETag)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type View.
func (v *View) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eTag":
			err = unpopulate(val, "ETag", &v.ETag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ViewListResult.
func (v ViewListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ViewListResult.
func (v *ViewListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ViewProperties.
func (v ViewProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accumulated", v.Accumulated)
	populate(objectMap, "chart", v.Chart)
	populateDateTimeRFC3339(objectMap, "createdOn", v.CreatedOn)
	populate(objectMap, "currency", v.Currency)
	populate(objectMap, "dateRange", v.DateRange)
	populate(objectMap, "displayName", v.DisplayName)
	populate(objectMap, "kpis", v.Kpis)
	populate(objectMap, "metric", v.Metric)
	populateDateTimeRFC3339(objectMap, "modifiedOn", v.ModifiedOn)
	populate(objectMap, "pivots", v.Pivots)
	populate(objectMap, "query", v.Query)
	populate(objectMap, "scope", v.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ViewProperties.
func (v *ViewProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accumulated":
			err = unpopulate(val, "Accumulated", &v.Accumulated)
			delete(rawMsg, key)
		case "chart":
			err = unpopulate(val, "Chart", &v.Chart)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &v.CreatedOn)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &v.Currency)
			delete(rawMsg, key)
		case "dateRange":
			err = unpopulate(val, "DateRange", &v.DateRange)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &v.DisplayName)
			delete(rawMsg, key)
		case "kpis":
			err = unpopulate(val, "Kpis", &v.Kpis)
			delete(rawMsg, key)
		case "metric":
			err = unpopulate(val, "Metric", &v.Metric)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &v.ModifiedOn)
			delete(rawMsg, key)
		case "pivots":
			err = unpopulate(val, "Pivots", &v.Pivots)
			delete(rawMsg, key)
		case "query":
			err = unpopulate(val, "Query", &v.Query)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &v.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
