//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armdesktopvirtualization.ClientFactory type.
type ServerFactory struct {
	ApplicationGroupsServer            ApplicationGroupsServer
	ApplicationsServer                 ApplicationsServer
	DesktopsServer                     DesktopsServer
	HostPoolsServer                    HostPoolsServer
	MSIXPackagesServer                 MSIXPackagesServer
	MsixImagesServer                   MsixImagesServer
	OperationsServer                   OperationsServer
	PrivateEndpointConnectionsServer   PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer         PrivateLinkResourcesServer
	ScalingPlanPersonalSchedulesServer ScalingPlanPersonalSchedulesServer
	ScalingPlanPooledSchedulesServer   ScalingPlanPooledSchedulesServer
	ScalingPlansServer                 ScalingPlansServer
	SessionHostsServer                 SessionHostsServer
	StartMenuItemsServer               StartMenuItemsServer
	UserSessionsServer                 UserSessionsServer
	WorkspacesServer                   WorkspacesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armdesktopvirtualization.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armdesktopvirtualization.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                  *ServerFactory
	trMu                                 sync.Mutex
	trApplicationGroupsServer            *ApplicationGroupsServerTransport
	trApplicationsServer                 *ApplicationsServerTransport
	trDesktopsServer                     *DesktopsServerTransport
	trHostPoolsServer                    *HostPoolsServerTransport
	trMSIXPackagesServer                 *MSIXPackagesServerTransport
	trMsixImagesServer                   *MsixImagesServerTransport
	trOperationsServer                   *OperationsServerTransport
	trPrivateEndpointConnectionsServer   *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer         *PrivateLinkResourcesServerTransport
	trScalingPlanPersonalSchedulesServer *ScalingPlanPersonalSchedulesServerTransport
	trScalingPlanPooledSchedulesServer   *ScalingPlanPooledSchedulesServerTransport
	trScalingPlansServer                 *ScalingPlansServerTransport
	trSessionHostsServer                 *SessionHostsServerTransport
	trStartMenuItemsServer               *StartMenuItemsServerTransport
	trUserSessionsServer                 *UserSessionsServerTransport
	trWorkspacesServer                   *WorkspacesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "ApplicationGroupsClient":
		initServer(s, &s.trApplicationGroupsServer, func() *ApplicationGroupsServerTransport {
			return NewApplicationGroupsServerTransport(&s.srv.ApplicationGroupsServer)
		})
		resp, err = s.trApplicationGroupsServer.Do(req)
	case "ApplicationsClient":
		initServer(s, &s.trApplicationsServer, func() *ApplicationsServerTransport { return NewApplicationsServerTransport(&s.srv.ApplicationsServer) })
		resp, err = s.trApplicationsServer.Do(req)
	case "DesktopsClient":
		initServer(s, &s.trDesktopsServer, func() *DesktopsServerTransport { return NewDesktopsServerTransport(&s.srv.DesktopsServer) })
		resp, err = s.trDesktopsServer.Do(req)
	case "HostPoolsClient":
		initServer(s, &s.trHostPoolsServer, func() *HostPoolsServerTransport { return NewHostPoolsServerTransport(&s.srv.HostPoolsServer) })
		resp, err = s.trHostPoolsServer.Do(req)
	case "MSIXPackagesClient":
		initServer(s, &s.trMSIXPackagesServer, func() *MSIXPackagesServerTransport { return NewMSIXPackagesServerTransport(&s.srv.MSIXPackagesServer) })
		resp, err = s.trMSIXPackagesServer.Do(req)
	case "MsixImagesClient":
		initServer(s, &s.trMsixImagesServer, func() *MsixImagesServerTransport { return NewMsixImagesServerTransport(&s.srv.MsixImagesServer) })
		resp, err = s.trMsixImagesServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "ScalingPlanPersonalSchedulesClient":
		initServer(s, &s.trScalingPlanPersonalSchedulesServer, func() *ScalingPlanPersonalSchedulesServerTransport {
			return NewScalingPlanPersonalSchedulesServerTransport(&s.srv.ScalingPlanPersonalSchedulesServer)
		})
		resp, err = s.trScalingPlanPersonalSchedulesServer.Do(req)
	case "ScalingPlanPooledSchedulesClient":
		initServer(s, &s.trScalingPlanPooledSchedulesServer, func() *ScalingPlanPooledSchedulesServerTransport {
			return NewScalingPlanPooledSchedulesServerTransport(&s.srv.ScalingPlanPooledSchedulesServer)
		})
		resp, err = s.trScalingPlanPooledSchedulesServer.Do(req)
	case "ScalingPlansClient":
		initServer(s, &s.trScalingPlansServer, func() *ScalingPlansServerTransport { return NewScalingPlansServerTransport(&s.srv.ScalingPlansServer) })
		resp, err = s.trScalingPlansServer.Do(req)
	case "SessionHostsClient":
		initServer(s, &s.trSessionHostsServer, func() *SessionHostsServerTransport { return NewSessionHostsServerTransport(&s.srv.SessionHostsServer) })
		resp, err = s.trSessionHostsServer.Do(req)
	case "StartMenuItemsClient":
		initServer(s, &s.trStartMenuItemsServer, func() *StartMenuItemsServerTransport {
			return NewStartMenuItemsServerTransport(&s.srv.StartMenuItemsServer)
		})
		resp, err = s.trStartMenuItemsServer.Do(req)
	case "UserSessionsClient":
		initServer(s, &s.trUserSessionsServer, func() *UserSessionsServerTransport { return NewUserSessionsServerTransport(&s.srv.UserSessionsServer) })
		resp, err = s.trUserSessionsServer.Do(req)
	case "WorkspacesClient":
		initServer(s, &s.trWorkspacesServer, func() *WorkspacesServerTransport { return NewWorkspacesServerTransport(&s.srv.WorkspacesServer) })
		resp, err = s.trWorkspacesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
