//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdevtestlabs

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type ApplicableSchedule.
func (a ApplicableSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicableSchedule.
func (a *ApplicableSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicableScheduleFragment.
func (a ApplicableScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicableScheduleFragment.
func (a *ApplicableScheduleFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplicableScheduleProperties.
func (a ApplicableScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "labVmsShutdown", a.LabVMsShutdown)
	populate(objectMap, "labVmsStartup", a.LabVMsStartup)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplicableScheduleProperties.
func (a *ApplicableScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "labVmsShutdown":
			err = unpopulate(val, "LabVMsShutdown", &a.LabVMsShutdown)
			delete(rawMsg, key)
		case "labVmsStartup":
			err = unpopulate(val, "LabVMsStartup", &a.LabVMsStartup)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ApplyArtifactsRequest.
func (a ApplyArtifactsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifacts", a.Artifacts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ApplyArtifactsRequest.
func (a *ApplyArtifactsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifacts":
			err = unpopulate(val, "Artifacts", &a.Artifacts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplate.
func (a ArmTemplate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplate.
func (a *ArmTemplate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateInfo.
func (a ArmTemplateInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "parameters", a.Parameters)
	populateAny(objectMap, "template", a.Template)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateInfo.
func (a *ArmTemplateInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "template":
			err = unpopulate(val, "Template", &a.Template)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateList.
func (a ArmTemplateList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateList.
func (a *ArmTemplateList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateParameterProperties.
func (a ArmTemplateParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateParameterProperties.
func (a *ArmTemplateParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArmTemplateProperties.
func (a ArmTemplateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "contents", a.Contents)
	populateDateTimeRFC3339(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "icon", a.Icon)
	populate(objectMap, "parametersValueFilesInfo", a.ParametersValueFilesInfo)
	populate(objectMap, "publisher", a.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArmTemplateProperties.
func (a *ArmTemplateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contents":
			err = unpopulate(val, "Contents", &a.Contents)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &a.Icon)
			delete(rawMsg, key)
		case "parametersValueFilesInfo":
			err = unpopulate(val, "ParametersValueFilesInfo", &a.ParametersValueFilesInfo)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &a.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Artifact.
func (a Artifact) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Artifact.
func (a *Artifact) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactDeploymentStatusProperties.
func (a ArtifactDeploymentStatusProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactsApplied", a.ArtifactsApplied)
	populate(objectMap, "deploymentStatus", a.DeploymentStatus)
	populate(objectMap, "totalArtifacts", a.TotalArtifacts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactDeploymentStatusProperties.
func (a *ArtifactDeploymentStatusProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactsApplied":
			err = unpopulate(val, "ArtifactsApplied", &a.ArtifactsApplied)
			delete(rawMsg, key)
		case "deploymentStatus":
			err = unpopulate(val, "DeploymentStatus", &a.DeploymentStatus)
			delete(rawMsg, key)
		case "totalArtifacts":
			err = unpopulate(val, "TotalArtifacts", &a.TotalArtifacts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactInstallProperties.
func (a ArtifactInstallProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "artifactId", a.ArtifactID)
	populate(objectMap, "artifactTitle", a.ArtifactTitle)
	populate(objectMap, "deploymentStatusMessage", a.DeploymentStatusMessage)
	populateDateTimeRFC3339(objectMap, "installTime", a.InstallTime)
	populate(objectMap, "parameters", a.Parameters)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "vmExtensionStatusMessage", a.VMExtensionStatusMessage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactInstallProperties.
func (a *ArtifactInstallProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "artifactId":
			err = unpopulate(val, "ArtifactID", &a.ArtifactID)
			delete(rawMsg, key)
		case "artifactTitle":
			err = unpopulate(val, "ArtifactTitle", &a.ArtifactTitle)
			delete(rawMsg, key)
		case "deploymentStatusMessage":
			err = unpopulate(val, "DeploymentStatusMessage", &a.DeploymentStatusMessage)
			delete(rawMsg, key)
		case "installTime":
			err = unpopulateDateTimeRFC3339(val, "InstallTime", &a.InstallTime)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "vmExtensionStatusMessage":
			err = unpopulate(val, "VMExtensionStatusMessage", &a.VMExtensionStatusMessage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactList.
func (a ArtifactList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactList.
func (a *ArtifactList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactParameterProperties.
func (a ArtifactParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactParameterProperties.
func (a *ArtifactParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactProperties.
func (a ArtifactProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "filePath", a.FilePath)
	populate(objectMap, "icon", a.Icon)
	populateAny(objectMap, "parameters", a.Parameters)
	populate(objectMap, "publisher", a.Publisher)
	populate(objectMap, "targetOsType", a.TargetOsType)
	populate(objectMap, "title", a.Title)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactProperties.
func (a *ArtifactProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "filePath":
			err = unpopulate(val, "FilePath", &a.FilePath)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &a.Icon)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &a.Parameters)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &a.Publisher)
			delete(rawMsg, key)
		case "targetOsType":
			err = unpopulate(val, "TargetOsType", &a.TargetOsType)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &a.Title)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSource.
func (a ArtifactSource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSource.
func (a *ArtifactSource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceFragment.
func (a ArtifactSourceFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourceFragment.
func (a *ArtifactSourceFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceList.
func (a ArtifactSourceList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourceList.
func (a *ArtifactSourceList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ArtifactSourceProperties.
func (a ArtifactSourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "armTemplateFolderPath", a.ArmTemplateFolderPath)
	populate(objectMap, "branchRef", a.BranchRef)
	populateDateTimeRFC3339(objectMap, "createdDate", a.CreatedDate)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "folderPath", a.FolderPath)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "securityToken", a.SecurityToken)
	populate(objectMap, "sourceType", a.SourceType)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "uri", a.URI)
	populate(objectMap, "uniqueIdentifier", a.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ArtifactSourceProperties.
func (a *ArtifactSourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "armTemplateFolderPath":
			err = unpopulate(val, "ArmTemplateFolderPath", &a.ArmTemplateFolderPath)
			delete(rawMsg, key)
		case "branchRef":
			err = unpopulate(val, "BranchRef", &a.BranchRef)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &a.CreatedDate)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "folderPath":
			err = unpopulate(val, "FolderPath", &a.FolderPath)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "securityToken":
			err = unpopulate(val, "SecurityToken", &a.SecurityToken)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &a.SourceType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &a.URI)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &a.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachDiskProperties.
func (a AttachDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "leasedByLabVmId", a.LeasedByLabVMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachDiskProperties.
func (a *AttachDiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "leasedByLabVmId":
			err = unpopulate(val, "LeasedByLabVMID", &a.LeasedByLabVMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AttachNewDataDiskOptions.
func (a AttachNewDataDiskOptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskName", a.DiskName)
	populate(objectMap, "diskSizeGiB", a.DiskSizeGiB)
	populate(objectMap, "diskType", a.DiskType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AttachNewDataDiskOptions.
func (a *AttachNewDataDiskOptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskName":
			err = unpopulate(val, "DiskName", &a.DiskName)
			delete(rawMsg, key)
		case "diskSizeGiB":
			err = unpopulate(val, "DiskSizeGiB", &a.DiskSizeGiB)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &a.DiskType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BulkCreationParameters.
func (b BulkCreationParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceCount", b.InstanceCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BulkCreationParameters.
func (b *BulkCreationParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &b.InstanceCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeDataDisk.
func (c ComputeDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskSizeGiB", c.DiskSizeGiB)
	populate(objectMap, "diskUri", c.DiskURI)
	populate(objectMap, "managedDiskId", c.ManagedDiskID)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeDataDisk.
func (c *ComputeDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskSizeGiB":
			err = unpopulate(val, "DiskSizeGiB", &c.DiskSizeGiB)
			delete(rawMsg, key)
		case "diskUri":
			err = unpopulate(val, "DiskURI", &c.DiskURI)
			delete(rawMsg, key)
		case "managedDiskId":
			err = unpopulate(val, "ManagedDiskID", &c.ManagedDiskID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeVMInstanceViewStatus.
func (c ComputeVMInstanceViewStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", c.Code)
	populate(objectMap, "displayStatus", c.DisplayStatus)
	populate(objectMap, "message", c.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeVMInstanceViewStatus.
func (c *ComputeVMInstanceViewStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &c.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &c.DisplayStatus)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeVMProperties.
func (c ComputeVMProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataDiskIds", c.DataDiskIDs)
	populate(objectMap, "dataDisks", c.DataDisks)
	populate(objectMap, "networkInterfaceId", c.NetworkInterfaceID)
	populate(objectMap, "osDiskId", c.OSDiskID)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "statuses", c.Statuses)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeVMProperties.
func (c *ComputeVMProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataDiskIds":
			err = unpopulate(val, "DataDiskIDs", &c.DataDiskIDs)
			delete(rawMsg, key)
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &c.DataDisks)
			delete(rawMsg, key)
		case "networkInterfaceId":
			err = unpopulate(val, "NetworkInterfaceID", &c.NetworkInterfaceID)
			delete(rawMsg, key)
		case "osDiskId":
			err = unpopulate(val, "OSDiskID", &c.OSDiskID)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &c.Statuses)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &c.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CostThresholdProperties.
func (c CostThresholdProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayOnChart", c.DisplayOnChart)
	populate(objectMap, "notificationSent", c.NotificationSent)
	populate(objectMap, "percentageThreshold", c.PercentageThreshold)
	populate(objectMap, "sendNotificationWhenExceeded", c.SendNotificationWhenExceeded)
	populate(objectMap, "thresholdId", c.ThresholdID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CostThresholdProperties.
func (c *CostThresholdProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayOnChart":
			err = unpopulate(val, "DisplayOnChart", &c.DisplayOnChart)
			delete(rawMsg, key)
		case "notificationSent":
			err = unpopulate(val, "NotificationSent", &c.NotificationSent)
			delete(rawMsg, key)
		case "percentageThreshold":
			err = unpopulate(val, "PercentageThreshold", &c.PercentageThreshold)
			delete(rawMsg, key)
		case "sendNotificationWhenExceeded":
			err = unpopulate(val, "SendNotificationWhenExceeded", &c.SendNotificationWhenExceeded)
			delete(rawMsg, key)
		case "thresholdId":
			err = unpopulate(val, "ThresholdID", &c.ThresholdID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImage.
func (c CustomImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImage.
func (c *CustomImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImageFragment.
func (c CustomImageFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImageFragment.
func (c *CustomImageFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImageList.
func (c CustomImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImageList.
func (c *CustomImageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImageProperties.
func (c CustomImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "author", c.Author)
	populateDateTimeRFC3339(objectMap, "creationDate", c.CreationDate)
	populate(objectMap, "customImagePlan", c.CustomImagePlan)
	populate(objectMap, "dataDiskStorageInfo", c.DataDiskStorageInfo)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isPlanAuthorized", c.IsPlanAuthorized)
	populate(objectMap, "managedImageId", c.ManagedImageID)
	populate(objectMap, "managedSnapshotId", c.ManagedSnapshotID)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", c.UniqueIdentifier)
	populate(objectMap, "vm", c.VM)
	populate(objectMap, "vhd", c.Vhd)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImageProperties.
func (c *CustomImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &c.Author)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &c.CreationDate)
			delete(rawMsg, key)
		case "customImagePlan":
			err = unpopulate(val, "CustomImagePlan", &c.CustomImagePlan)
			delete(rawMsg, key)
		case "dataDiskStorageInfo":
			err = unpopulate(val, "DataDiskStorageInfo", &c.DataDiskStorageInfo)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isPlanAuthorized":
			err = unpopulate(val, "IsPlanAuthorized", &c.IsPlanAuthorized)
			delete(rawMsg, key)
		case "managedImageId":
			err = unpopulate(val, "ManagedImageID", &c.ManagedImageID)
			delete(rawMsg, key)
		case "managedSnapshotId":
			err = unpopulate(val, "ManagedSnapshotID", &c.ManagedSnapshotID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &c.UniqueIdentifier)
			delete(rawMsg, key)
		case "vm":
			err = unpopulate(val, "VM", &c.VM)
			delete(rawMsg, key)
		case "vhd":
			err = unpopulate(val, "Vhd", &c.Vhd)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImagePropertiesCustom.
func (c CustomImagePropertiesCustom) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "imageName", c.ImageName)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "sysPrep", c.SysPrep)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImagePropertiesCustom.
func (c *CustomImagePropertiesCustom) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "imageName":
			err = unpopulate(val, "ImageName", &c.ImageName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "sysPrep":
			err = unpopulate(val, "SysPrep", &c.SysPrep)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImagePropertiesFromPlan.
func (c CustomImagePropertiesFromPlan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "offer", c.Offer)
	populate(objectMap, "publisher", c.Publisher)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImagePropertiesFromPlan.
func (c *CustomImagePropertiesFromPlan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "offer":
			err = unpopulate(val, "Offer", &c.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &c.Publisher)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomImagePropertiesFromVM.
func (c CustomImagePropertiesFromVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linuxOsInfo", c.LinuxOsInfo)
	populate(objectMap, "sourceVmId", c.SourceVMID)
	populate(objectMap, "windowsOsInfo", c.WindowsOsInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomImagePropertiesFromVM.
func (c *CustomImagePropertiesFromVM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxOsInfo":
			err = unpopulate(val, "LinuxOsInfo", &c.LinuxOsInfo)
			delete(rawMsg, key)
		case "sourceVmId":
			err = unpopulate(val, "SourceVMID", &c.SourceVMID)
			delete(rawMsg, key)
		case "windowsOsInfo":
			err = unpopulate(val, "WindowsOsInfo", &c.WindowsOsInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDiskProperties.
func (d DataDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "attachNewDataDiskOptions", d.AttachNewDataDiskOptions)
	populate(objectMap, "existingLabDiskId", d.ExistingLabDiskID)
	populate(objectMap, "hostCaching", d.HostCaching)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDiskProperties.
func (d *DataDiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "attachNewDataDiskOptions":
			err = unpopulate(val, "AttachNewDataDiskOptions", &d.AttachNewDataDiskOptions)
			delete(rawMsg, key)
		case "existingLabDiskId":
			err = unpopulate(val, "ExistingLabDiskID", &d.ExistingLabDiskID)
			delete(rawMsg, key)
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &d.HostCaching)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataDiskStorageTypeInfo.
func (d DataDiskStorageTypeInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "lun", d.Lun)
	populate(objectMap, "storageType", d.StorageType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataDiskStorageTypeInfo.
func (d *DataDiskStorageTypeInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lun":
			err = unpopulate(val, "Lun", &d.Lun)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &d.StorageType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DayDetails.
func (d DayDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "time", d.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DayDetails.
func (d *DayDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "time":
			err = unpopulate(val, "Time", &d.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetachDataDiskProperties.
func (d DetachDataDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "existingLabDiskId", d.ExistingLabDiskID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetachDataDiskProperties.
func (d *DetachDataDiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "existingLabDiskId":
			err = unpopulate(val, "ExistingLabDiskID", &d.ExistingLabDiskID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DetachDiskProperties.
func (d DetachDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "leasedByLabVmId", d.LeasedByLabVMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DetachDiskProperties.
func (d *DetachDiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "leasedByLabVmId":
			err = unpopulate(val, "LeasedByLabVMID", &d.LeasedByLabVMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Disk.
func (d Disk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Disk.
func (d *Disk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskFragment.
func (d DiskFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskFragment.
func (d *DiskFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskList.
func (d DiskList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskList.
func (d *DiskList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiskProperties.
func (d DiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", d.CreatedDate)
	populate(objectMap, "diskBlobName", d.DiskBlobName)
	populate(objectMap, "diskSizeGiB", d.DiskSizeGiB)
	populate(objectMap, "diskType", d.DiskType)
	populate(objectMap, "diskUri", d.DiskURI)
	populate(objectMap, "hostCaching", d.HostCaching)
	populate(objectMap, "leasedByLabVmId", d.LeasedByLabVMID)
	populate(objectMap, "managedDiskId", d.ManagedDiskID)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "storageAccountId", d.StorageAccountID)
	populate(objectMap, "uniqueIdentifier", d.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiskProperties.
func (d *DiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &d.CreatedDate)
			delete(rawMsg, key)
		case "diskBlobName":
			err = unpopulate(val, "DiskBlobName", &d.DiskBlobName)
			delete(rawMsg, key)
		case "diskSizeGiB":
			err = unpopulate(val, "DiskSizeGiB", &d.DiskSizeGiB)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &d.DiskType)
			delete(rawMsg, key)
		case "diskUri":
			err = unpopulate(val, "DiskURI", &d.DiskURI)
			delete(rawMsg, key)
		case "hostCaching":
			err = unpopulate(val, "HostCaching", &d.HostCaching)
			delete(rawMsg, key)
		case "leasedByLabVmId":
			err = unpopulate(val, "LeasedByLabVMID", &d.LeasedByLabVMID)
			delete(rawMsg, key)
		case "managedDiskId":
			err = unpopulate(val, "ManagedDiskID", &d.ManagedDiskID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &d.StorageAccountID)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &d.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DtlEnvironment.
func (d DtlEnvironment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DtlEnvironment.
func (d *DtlEnvironment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DtlEnvironmentFragment.
func (d DtlEnvironmentFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DtlEnvironmentFragment.
func (d *DtlEnvironmentFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DtlEnvironmentList.
func (d DtlEnvironmentList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DtlEnvironmentList.
func (d *DtlEnvironmentList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentDeploymentProperties.
func (e EnvironmentDeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "armTemplateId", e.ArmTemplateID)
	populate(objectMap, "parameters", e.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentDeploymentProperties.
func (e *EnvironmentDeploymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "armTemplateId":
			err = unpopulate(val, "ArmTemplateID", &e.ArmTemplateID)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &e.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentProperties.
func (e EnvironmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "armTemplateDisplayName", e.ArmTemplateDisplayName)
	populate(objectMap, "createdByUser", e.CreatedByUser)
	populate(objectMap, "deploymentProperties", e.DeploymentProperties)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "resourceGroupId", e.ResourceGroupID)
	populate(objectMap, "uniqueIdentifier", e.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentProperties.
func (e *EnvironmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "armTemplateDisplayName":
			err = unpopulate(val, "ArmTemplateDisplayName", &e.ArmTemplateDisplayName)
			delete(rawMsg, key)
		case "createdByUser":
			err = unpopulate(val, "CreatedByUser", &e.CreatedByUser)
			delete(rawMsg, key)
		case "deploymentProperties":
			err = unpopulate(val, "DeploymentProperties", &e.DeploymentProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &e.ResourceGroupID)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &e.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EvaluatePoliciesProperties.
func (e EvaluatePoliciesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "factData", e.FactData)
	populate(objectMap, "factName", e.FactName)
	populate(objectMap, "userObjectId", e.UserObjectID)
	populate(objectMap, "valueOffset", e.ValueOffset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EvaluatePoliciesProperties.
func (e *EvaluatePoliciesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "factData":
			err = unpopulate(val, "FactData", &e.FactData)
			delete(rawMsg, key)
		case "factName":
			err = unpopulate(val, "FactName", &e.FactName)
			delete(rawMsg, key)
		case "userObjectId":
			err = unpopulate(val, "UserObjectID", &e.UserObjectID)
			delete(rawMsg, key)
		case "valueOffset":
			err = unpopulate(val, "ValueOffset", &e.ValueOffset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EvaluatePoliciesRequest.
func (e EvaluatePoliciesRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policies", e.Policies)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EvaluatePoliciesRequest.
func (e *EvaluatePoliciesRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policies":
			err = unpopulate(val, "Policies", &e.Policies)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EvaluatePoliciesResponse.
func (e EvaluatePoliciesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "results", e.Results)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EvaluatePoliciesResponse.
func (e *EvaluatePoliciesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "results":
			err = unpopulate(val, "Results", &e.Results)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Event.
func (e Event) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventName", e.EventName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Event.
func (e *Event) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventName":
			err = unpopulate(val, "EventName", &e.EventName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExportResourceUsageParameters.
func (e ExportResourceUsageParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobStorageAbsoluteSasUri", e.BlobStorageAbsoluteSasURI)
	populateDateTimeRFC3339(objectMap, "usageStartDate", e.UsageStartDate)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExportResourceUsageParameters.
func (e *ExportResourceUsageParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobStorageAbsoluteSasUri":
			err = unpopulate(val, "BlobStorageAbsoluteSasURI", &e.BlobStorageAbsoluteSasURI)
			delete(rawMsg, key)
		case "usageStartDate":
			err = unpopulateDateTimeRFC3339(val, "UsageStartDate", &e.UsageStartDate)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalSubnet.
func (e ExternalSubnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalSubnet.
func (e *ExternalSubnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Formula.
func (f Formula) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Formula.
func (f *Formula) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FormulaFragment.
func (f FormulaFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", f.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormulaFragment.
func (f *FormulaFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FormulaList.
func (f FormulaList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormulaList.
func (f *FormulaList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FormulaProperties.
func (f FormulaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "author", f.Author)
	populateDateTimeRFC3339(objectMap, "creationDate", f.CreationDate)
	populate(objectMap, "description", f.Description)
	populate(objectMap, "formulaContent", f.FormulaContent)
	populate(objectMap, "osType", f.OSType)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", f.UniqueIdentifier)
	populate(objectMap, "vm", f.VM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormulaProperties.
func (f *FormulaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &f.Author)
			delete(rawMsg, key)
		case "creationDate":
			err = unpopulateDateTimeRFC3339(val, "CreationDate", &f.CreationDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &f.Description)
			delete(rawMsg, key)
		case "formulaContent":
			err = unpopulate(val, "FormulaContent", &f.FormulaContent)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &f.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &f.UniqueIdentifier)
			delete(rawMsg, key)
		case "vm":
			err = unpopulate(val, "VM", &f.VM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FormulaPropertiesFromVM.
func (f FormulaPropertiesFromVM) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "labVmId", f.LabVMID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FormulaPropertiesFromVM.
func (f *FormulaPropertiesFromVM) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "labVmId":
			err = unpopulate(val, "LabVMID", &f.LabVMID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImage.
func (g GalleryImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImage.
func (g *GalleryImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &g.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &g.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &g.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageList.
func (g GalleryImageList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", g.NextLink)
	populate(objectMap, "value", g.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageList.
func (g *GalleryImageList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &g.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &g.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageProperties.
func (g GalleryImageProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "author", g.Author)
	populateDateTimeRFC3339(objectMap, "createdDate", g.CreatedDate)
	populate(objectMap, "description", g.Description)
	populate(objectMap, "enabled", g.Enabled)
	populate(objectMap, "icon", g.Icon)
	populate(objectMap, "imageReference", g.ImageReference)
	populate(objectMap, "isPlanAuthorized", g.IsPlanAuthorized)
	populate(objectMap, "planId", g.PlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageProperties.
func (g *GalleryImageProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "author":
			err = unpopulate(val, "Author", &g.Author)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &g.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &g.Description)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &g.Enabled)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &g.Icon)
			delete(rawMsg, key)
		case "imageReference":
			err = unpopulate(val, "ImageReference", &g.ImageReference)
			delete(rawMsg, key)
		case "isPlanAuthorized":
			err = unpopulate(val, "IsPlanAuthorized", &g.IsPlanAuthorized)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &g.PlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GalleryImageReference.
func (g GalleryImageReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osType", g.OSType)
	populate(objectMap, "offer", g.Offer)
	populate(objectMap, "publisher", g.Publisher)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "version", g.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GalleryImageReference.
func (g *GalleryImageReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osType":
			err = unpopulate(val, "OSType", &g.OSType)
			delete(rawMsg, key)
		case "offer":
			err = unpopulate(val, "Offer", &g.Offer)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &g.Publisher)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &g.SKU)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &g.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateArmTemplateRequest.
func (g GenerateArmTemplateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fileUploadOptions", g.FileUploadOptions)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "parameters", g.Parameters)
	populate(objectMap, "virtualMachineName", g.VirtualMachineName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateArmTemplateRequest.
func (g *GenerateArmTemplateRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileUploadOptions":
			err = unpopulate(val, "FileUploadOptions", &g.FileUploadOptions)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &g.Location)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &g.Parameters)
			delete(rawMsg, key)
		case "virtualMachineName":
			err = unpopulate(val, "VirtualMachineName", &g.VirtualMachineName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateUploadURIParameter.
func (g GenerateUploadURIParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobName", g.BlobName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateUploadURIParameter.
func (g *GenerateUploadURIParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobName":
			err = unpopulate(val, "BlobName", &g.BlobName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GenerateUploadURIResponse.
func (g GenerateUploadURIResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "uploadUri", g.UploadURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenerateUploadURIResponse.
func (g *GenerateUploadURIResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "uploadUri":
			err = unpopulate(val, "UploadURI", &g.UploadURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HourDetails.
func (h HourDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "minute", h.Minute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HourDetails.
func (h *HourDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "minute":
			err = unpopulate(val, "Minute", &h.Minute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityProperties.
func (i IdentityProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientSecretUrl", i.ClientSecretURL)
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityProperties.
func (i *IdentityProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientSecretUrl":
			err = unpopulate(val, "ClientSecretURL", &i.ClientSecretURL)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImportLabVirtualMachineRequest.
func (i ImportLabVirtualMachineRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationVirtualMachineName", i.DestinationVirtualMachineName)
	populate(objectMap, "sourceVirtualMachineResourceId", i.SourceVirtualMachineResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImportLabVirtualMachineRequest.
func (i *ImportLabVirtualMachineRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationVirtualMachineName":
			err = unpopulate(val, "DestinationVirtualMachineName", &i.DestinationVirtualMachineName)
			delete(rawMsg, key)
		case "sourceVirtualMachineResourceId":
			err = unpopulate(val, "SourceVirtualMachineResourceID", &i.SourceVirtualMachineResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InboundNatRule.
func (i InboundNatRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPort", i.BackendPort)
	populate(objectMap, "frontendPort", i.FrontendPort)
	populate(objectMap, "transportProtocol", i.TransportProtocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InboundNatRule.
func (i *InboundNatRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPort":
			err = unpopulate(val, "BackendPort", &i.BackendPort)
			delete(rawMsg, key)
		case "frontendPort":
			err = unpopulate(val, "FrontendPort", &i.FrontendPort)
			delete(rawMsg, key)
		case "transportProtocol":
			err = unpopulate(val, "TransportProtocol", &i.TransportProtocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Lab.
func (l Lab) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Lab.
func (l *Lab) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabAnnouncementProperties.
func (l LabAnnouncementProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", l.Enabled)
	populateDateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "expired", l.Expired)
	populate(objectMap, "markdown", l.Markdown)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "title", l.Title)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabAnnouncementProperties.
func (l *LabAnnouncementProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &l.Enabled)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "expired":
			err = unpopulate(val, "Expired", &l.Expired)
			delete(rawMsg, key)
		case "markdown":
			err = unpopulate(val, "Markdown", &l.Markdown)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "title":
			err = unpopulate(val, "Title", &l.Title)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabCost.
func (l LabCost) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabCost.
func (l *LabCost) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabCostDetailsProperties.
func (l LabCostDetailsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cost", l.Cost)
	populate(objectMap, "costType", l.CostType)
	populateDateTimeRFC3339(objectMap, "date", l.Date)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabCostDetailsProperties.
func (l *LabCostDetailsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cost":
			err = unpopulate(val, "Cost", &l.Cost)
			delete(rawMsg, key)
		case "costType":
			err = unpopulate(val, "CostType", &l.CostType)
			delete(rawMsg, key)
		case "date":
			err = unpopulateDateTimeRFC3339(val, "Date", &l.Date)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabCostProperties.
func (l LabCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "currencyCode", l.CurrencyCode)
	populateDateTimeRFC3339(objectMap, "endDateTime", l.EndDateTime)
	populate(objectMap, "labCostDetails", l.LabCostDetails)
	populate(objectMap, "labCostSummary", l.LabCostSummary)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "resourceCosts", l.ResourceCosts)
	populateDateTimeRFC3339(objectMap, "startDateTime", l.StartDateTime)
	populate(objectMap, "targetCost", l.TargetCost)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabCostProperties.
func (l *LabCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &l.CurrencyCode)
			delete(rawMsg, key)
		case "endDateTime":
			err = unpopulateDateTimeRFC3339(val, "EndDateTime", &l.EndDateTime)
			delete(rawMsg, key)
		case "labCostDetails":
			err = unpopulate(val, "LabCostDetails", &l.LabCostDetails)
			delete(rawMsg, key)
		case "labCostSummary":
			err = unpopulate(val, "LabCostSummary", &l.LabCostSummary)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "resourceCosts":
			err = unpopulate(val, "ResourceCosts", &l.ResourceCosts)
			delete(rawMsg, key)
		case "startDateTime":
			err = unpopulateDateTimeRFC3339(val, "StartDateTime", &l.StartDateTime)
			delete(rawMsg, key)
		case "targetCost":
			err = unpopulate(val, "TargetCost", &l.TargetCost)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabCostSummaryProperties.
func (l LabCostSummaryProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "estimatedLabCost", l.EstimatedLabCost)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabCostSummaryProperties.
func (l *LabCostSummaryProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "estimatedLabCost":
			err = unpopulate(val, "EstimatedLabCost", &l.EstimatedLabCost)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabFragment.
func (l LabFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabFragment.
func (l *LabFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabList.
func (l LabList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabList.
func (l *LabList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabProperties.
func (l LabProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "announcement", l.Announcement)
	populate(objectMap, "artifactsStorageAccount", l.ArtifactsStorageAccount)
	populateDateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "defaultPremiumStorageAccount", l.DefaultPremiumStorageAccount)
	populate(objectMap, "defaultStorageAccount", l.DefaultStorageAccount)
	populate(objectMap, "environmentPermission", l.EnvironmentPermission)
	populate(objectMap, "extendedProperties", l.ExtendedProperties)
	populate(objectMap, "labStorageType", l.LabStorageType)
	populate(objectMap, "loadBalancerId", l.LoadBalancerID)
	populate(objectMap, "mandatoryArtifactsResourceIdsLinux", l.MandatoryArtifactsResourceIDsLinux)
	populate(objectMap, "mandatoryArtifactsResourceIdsWindows", l.MandatoryArtifactsResourceIDsWindows)
	populate(objectMap, "networkSecurityGroupId", l.NetworkSecurityGroupID)
	populate(objectMap, "premiumDataDiskStorageAccount", l.PremiumDataDiskStorageAccount)
	populate(objectMap, "premiumDataDisks", l.PremiumDataDisks)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "publicIpId", l.PublicIPID)
	populate(objectMap, "support", l.Support)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	populate(objectMap, "vmCreationResourceGroup", l.VMCreationResourceGroup)
	populate(objectMap, "vaultName", l.VaultName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabProperties.
func (l *LabProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "announcement":
			err = unpopulate(val, "Announcement", &l.Announcement)
			delete(rawMsg, key)
		case "artifactsStorageAccount":
			err = unpopulate(val, "ArtifactsStorageAccount", &l.ArtifactsStorageAccount)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "defaultPremiumStorageAccount":
			err = unpopulate(val, "DefaultPremiumStorageAccount", &l.DefaultPremiumStorageAccount)
			delete(rawMsg, key)
		case "defaultStorageAccount":
			err = unpopulate(val, "DefaultStorageAccount", &l.DefaultStorageAccount)
			delete(rawMsg, key)
		case "environmentPermission":
			err = unpopulate(val, "EnvironmentPermission", &l.EnvironmentPermission)
			delete(rawMsg, key)
		case "extendedProperties":
			err = unpopulate(val, "ExtendedProperties", &l.ExtendedProperties)
			delete(rawMsg, key)
		case "labStorageType":
			err = unpopulate(val, "LabStorageType", &l.LabStorageType)
			delete(rawMsg, key)
		case "loadBalancerId":
			err = unpopulate(val, "LoadBalancerID", &l.LoadBalancerID)
			delete(rawMsg, key)
		case "mandatoryArtifactsResourceIdsLinux":
			err = unpopulate(val, "MandatoryArtifactsResourceIDsLinux", &l.MandatoryArtifactsResourceIDsLinux)
			delete(rawMsg, key)
		case "mandatoryArtifactsResourceIdsWindows":
			err = unpopulate(val, "MandatoryArtifactsResourceIDsWindows", &l.MandatoryArtifactsResourceIDsWindows)
			delete(rawMsg, key)
		case "networkSecurityGroupId":
			err = unpopulate(val, "NetworkSecurityGroupID", &l.NetworkSecurityGroupID)
			delete(rawMsg, key)
		case "premiumDataDiskStorageAccount":
			err = unpopulate(val, "PremiumDataDiskStorageAccount", &l.PremiumDataDiskStorageAccount)
			delete(rawMsg, key)
		case "premiumDataDisks":
			err = unpopulate(val, "PremiumDataDisks", &l.PremiumDataDisks)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "publicIpId":
			err = unpopulate(val, "PublicIPID", &l.PublicIPID)
			delete(rawMsg, key)
		case "support":
			err = unpopulate(val, "Support", &l.Support)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		case "vmCreationResourceGroup":
			err = unpopulate(val, "VMCreationResourceGroup", &l.VMCreationResourceGroup)
			delete(rawMsg, key)
		case "vaultName":
			err = unpopulate(val, "VaultName", &l.VaultName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabResourceCostProperties.
func (l LabResourceCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "externalResourceId", l.ExternalResourceID)
	populate(objectMap, "resourceCost", l.ResourceCost)
	populate(objectMap, "resourceId", l.ResourceID)
	populate(objectMap, "resourceOwner", l.ResourceOwner)
	populate(objectMap, "resourcePricingTier", l.ResourcePricingTier)
	populate(objectMap, "resourceStatus", l.ResourceStatus)
	populate(objectMap, "resourceType", l.ResourceType)
	populate(objectMap, "resourceUId", l.ResourceUID)
	populate(objectMap, "resourcename", l.Resourcename)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabResourceCostProperties.
func (l *LabResourceCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "externalResourceId":
			err = unpopulate(val, "ExternalResourceID", &l.ExternalResourceID)
			delete(rawMsg, key)
		case "resourceCost":
			err = unpopulate(val, "ResourceCost", &l.ResourceCost)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		case "resourceOwner":
			err = unpopulate(val, "ResourceOwner", &l.ResourceOwner)
			delete(rawMsg, key)
		case "resourcePricingTier":
			err = unpopulate(val, "ResourcePricingTier", &l.ResourcePricingTier)
			delete(rawMsg, key)
		case "resourceStatus":
			err = unpopulate(val, "ResourceStatus", &l.ResourceStatus)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &l.ResourceType)
			delete(rawMsg, key)
		case "resourceUId":
			err = unpopulate(val, "ResourceUID", &l.ResourceUID)
			delete(rawMsg, key)
		case "resourcename":
			err = unpopulate(val, "Resourcename", &l.Resourcename)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabSupportProperties.
func (l LabSupportProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", l.Enabled)
	populate(objectMap, "markdown", l.Markdown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabSupportProperties.
func (l *LabSupportProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &l.Enabled)
			delete(rawMsg, key)
		case "markdown":
			err = unpopulate(val, "Markdown", &l.Markdown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVhd.
func (l LabVhd) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVhd.
func (l *LabVhd) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVhdList.
func (l LabVhdList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVhdList.
func (l *LabVhdList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachine.
func (l LabVirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	populate(objectMap, "type", l.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachine.
func (l *LabVirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &l.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineCreationParameter.
func (l LabVirtualMachineCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", l.Location)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineCreationParameter.
func (l *LabVirtualMachineCreationParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &l.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineCreationParameterProperties.
func (l LabVirtualMachineCreationParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowClaim", l.AllowClaim)
	populate(objectMap, "artifacts", l.Artifacts)
	populate(objectMap, "bulkCreationParameters", l.BulkCreationParameters)
	populateDateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "customImageId", l.CustomImageID)
	populate(objectMap, "dataDiskParameters", l.DataDiskParameters)
	populate(objectMap, "disallowPublicIpAddress", l.DisallowPublicIPAddress)
	populate(objectMap, "environmentId", l.EnvironmentID)
	populateDateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "galleryImageReference", l.GalleryImageReference)
	populate(objectMap, "isAuthenticationWithSshKey", l.IsAuthenticationWithSSHKey)
	populate(objectMap, "labSubnetName", l.LabSubnetName)
	populate(objectMap, "labVirtualNetworkId", l.LabVirtualNetworkID)
	populate(objectMap, "networkInterface", l.NetworkInterface)
	populate(objectMap, "notes", l.Notes)
	populate(objectMap, "ownerObjectId", l.OwnerObjectID)
	populate(objectMap, "ownerUserPrincipalName", l.OwnerUserPrincipalName)
	populate(objectMap, "password", l.Password)
	populate(objectMap, "planId", l.PlanID)
	populate(objectMap, "sshKey", l.SSHKey)
	populate(objectMap, "scheduleParameters", l.ScheduleParameters)
	populate(objectMap, "size", l.Size)
	populate(objectMap, "storageType", l.StorageType)
	populate(objectMap, "userName", l.UserName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineCreationParameterProperties.
func (l *LabVirtualMachineCreationParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowClaim":
			err = unpopulate(val, "AllowClaim", &l.AllowClaim)
			delete(rawMsg, key)
		case "artifacts":
			err = unpopulate(val, "Artifacts", &l.Artifacts)
			delete(rawMsg, key)
		case "bulkCreationParameters":
			err = unpopulate(val, "BulkCreationParameters", &l.BulkCreationParameters)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "customImageId":
			err = unpopulate(val, "CustomImageID", &l.CustomImageID)
			delete(rawMsg, key)
		case "dataDiskParameters":
			err = unpopulate(val, "DataDiskParameters", &l.DataDiskParameters)
			delete(rawMsg, key)
		case "disallowPublicIpAddress":
			err = unpopulate(val, "DisallowPublicIPAddress", &l.DisallowPublicIPAddress)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &l.EnvironmentID)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "galleryImageReference":
			err = unpopulate(val, "GalleryImageReference", &l.GalleryImageReference)
			delete(rawMsg, key)
		case "isAuthenticationWithSshKey":
			err = unpopulate(val, "IsAuthenticationWithSSHKey", &l.IsAuthenticationWithSSHKey)
			delete(rawMsg, key)
		case "labSubnetName":
			err = unpopulate(val, "LabSubnetName", &l.LabSubnetName)
			delete(rawMsg, key)
		case "labVirtualNetworkId":
			err = unpopulate(val, "LabVirtualNetworkID", &l.LabVirtualNetworkID)
			delete(rawMsg, key)
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &l.NetworkInterface)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &l.Notes)
			delete(rawMsg, key)
		case "ownerObjectId":
			err = unpopulate(val, "OwnerObjectID", &l.OwnerObjectID)
			delete(rawMsg, key)
		case "ownerUserPrincipalName":
			err = unpopulate(val, "OwnerUserPrincipalName", &l.OwnerUserPrincipalName)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &l.Password)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &l.PlanID)
			delete(rawMsg, key)
		case "sshKey":
			err = unpopulate(val, "SSHKey", &l.SSHKey)
			delete(rawMsg, key)
		case "scheduleParameters":
			err = unpopulate(val, "ScheduleParameters", &l.ScheduleParameters)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &l.Size)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &l.StorageType)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &l.UserName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineFragment.
func (l LabVirtualMachineFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", l.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineFragment.
func (l *LabVirtualMachineFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &l.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineList.
func (l LabVirtualMachineList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineList.
func (l *LabVirtualMachineList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LabVirtualMachineProperties.
func (l LabVirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowClaim", l.AllowClaim)
	populate(objectMap, "applicableSchedule", l.ApplicableSchedule)
	populate(objectMap, "artifactDeploymentStatus", l.ArtifactDeploymentStatus)
	populate(objectMap, "artifacts", l.Artifacts)
	populate(objectMap, "computeId", l.ComputeID)
	populate(objectMap, "computeVm", l.ComputeVM)
	populate(objectMap, "createdByUser", l.CreatedByUser)
	populate(objectMap, "createdByUserId", l.CreatedByUserID)
	populateDateTimeRFC3339(objectMap, "createdDate", l.CreatedDate)
	populate(objectMap, "customImageId", l.CustomImageID)
	populate(objectMap, "dataDiskParameters", l.DataDiskParameters)
	populate(objectMap, "disallowPublicIpAddress", l.DisallowPublicIPAddress)
	populate(objectMap, "environmentId", l.EnvironmentID)
	populateDateTimeRFC3339(objectMap, "expirationDate", l.ExpirationDate)
	populate(objectMap, "fqdn", l.Fqdn)
	populate(objectMap, "galleryImageReference", l.GalleryImageReference)
	populate(objectMap, "isAuthenticationWithSshKey", l.IsAuthenticationWithSSHKey)
	populate(objectMap, "labSubnetName", l.LabSubnetName)
	populate(objectMap, "labVirtualNetworkId", l.LabVirtualNetworkID)
	populate(objectMap, "lastKnownPowerState", l.LastKnownPowerState)
	populate(objectMap, "networkInterface", l.NetworkInterface)
	populate(objectMap, "notes", l.Notes)
	populate(objectMap, "osType", l.OSType)
	populate(objectMap, "ownerObjectId", l.OwnerObjectID)
	populate(objectMap, "ownerUserPrincipalName", l.OwnerUserPrincipalName)
	populate(objectMap, "password", l.Password)
	populate(objectMap, "planId", l.PlanID)
	populate(objectMap, "provisioningState", l.ProvisioningState)
	populate(objectMap, "sshKey", l.SSHKey)
	populate(objectMap, "scheduleParameters", l.ScheduleParameters)
	populate(objectMap, "size", l.Size)
	populate(objectMap, "storageType", l.StorageType)
	populate(objectMap, "uniqueIdentifier", l.UniqueIdentifier)
	populate(objectMap, "userName", l.UserName)
	populate(objectMap, "virtualMachineCreationSource", l.VirtualMachineCreationSource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LabVirtualMachineProperties.
func (l *LabVirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowClaim":
			err = unpopulate(val, "AllowClaim", &l.AllowClaim)
			delete(rawMsg, key)
		case "applicableSchedule":
			err = unpopulate(val, "ApplicableSchedule", &l.ApplicableSchedule)
			delete(rawMsg, key)
		case "artifactDeploymentStatus":
			err = unpopulate(val, "ArtifactDeploymentStatus", &l.ArtifactDeploymentStatus)
			delete(rawMsg, key)
		case "artifacts":
			err = unpopulate(val, "Artifacts", &l.Artifacts)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &l.ComputeID)
			delete(rawMsg, key)
		case "computeVm":
			err = unpopulate(val, "ComputeVM", &l.ComputeVM)
			delete(rawMsg, key)
		case "createdByUser":
			err = unpopulate(val, "CreatedByUser", &l.CreatedByUser)
			delete(rawMsg, key)
		case "createdByUserId":
			err = unpopulate(val, "CreatedByUserID", &l.CreatedByUserID)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &l.CreatedDate)
			delete(rawMsg, key)
		case "customImageId":
			err = unpopulate(val, "CustomImageID", &l.CustomImageID)
			delete(rawMsg, key)
		case "dataDiskParameters":
			err = unpopulate(val, "DataDiskParameters", &l.DataDiskParameters)
			delete(rawMsg, key)
		case "disallowPublicIpAddress":
			err = unpopulate(val, "DisallowPublicIPAddress", &l.DisallowPublicIPAddress)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &l.EnvironmentID)
			delete(rawMsg, key)
		case "expirationDate":
			err = unpopulateDateTimeRFC3339(val, "ExpirationDate", &l.ExpirationDate)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &l.Fqdn)
			delete(rawMsg, key)
		case "galleryImageReference":
			err = unpopulate(val, "GalleryImageReference", &l.GalleryImageReference)
			delete(rawMsg, key)
		case "isAuthenticationWithSshKey":
			err = unpopulate(val, "IsAuthenticationWithSSHKey", &l.IsAuthenticationWithSSHKey)
			delete(rawMsg, key)
		case "labSubnetName":
			err = unpopulate(val, "LabSubnetName", &l.LabSubnetName)
			delete(rawMsg, key)
		case "labVirtualNetworkId":
			err = unpopulate(val, "LabVirtualNetworkID", &l.LabVirtualNetworkID)
			delete(rawMsg, key)
		case "lastKnownPowerState":
			err = unpopulate(val, "LastKnownPowerState", &l.LastKnownPowerState)
			delete(rawMsg, key)
		case "networkInterface":
			err = unpopulate(val, "NetworkInterface", &l.NetworkInterface)
			delete(rawMsg, key)
		case "notes":
			err = unpopulate(val, "Notes", &l.Notes)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &l.OSType)
			delete(rawMsg, key)
		case "ownerObjectId":
			err = unpopulate(val, "OwnerObjectID", &l.OwnerObjectID)
			delete(rawMsg, key)
		case "ownerUserPrincipalName":
			err = unpopulate(val, "OwnerUserPrincipalName", &l.OwnerUserPrincipalName)
			delete(rawMsg, key)
		case "password":
			err = unpopulate(val, "Password", &l.Password)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &l.PlanID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &l.ProvisioningState)
			delete(rawMsg, key)
		case "sshKey":
			err = unpopulate(val, "SSHKey", &l.SSHKey)
			delete(rawMsg, key)
		case "scheduleParameters":
			err = unpopulate(val, "ScheduleParameters", &l.ScheduleParameters)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &l.Size)
			delete(rawMsg, key)
		case "storageType":
			err = unpopulate(val, "StorageType", &l.StorageType)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &l.UniqueIdentifier)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &l.UserName)
			delete(rawMsg, key)
		case "virtualMachineCreationSource":
			err = unpopulate(val, "VirtualMachineCreationSource", &l.VirtualMachineCreationSource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxOsInfo.
func (l LinuxOsInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "linuxOsState", l.LinuxOsState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxOsInfo.
func (l *LinuxOsInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "linuxOsState":
			err = unpopulate(val, "LinuxOsState", &l.LinuxOsState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkInterfaceProperties.
func (n NetworkInterfaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsName", n.DNSName)
	populate(objectMap, "privateIpAddress", n.PrivateIPAddress)
	populate(objectMap, "publicIpAddress", n.PublicIPAddress)
	populate(objectMap, "publicIpAddressId", n.PublicIPAddressID)
	populate(objectMap, "rdpAuthority", n.RdpAuthority)
	populate(objectMap, "sshAuthority", n.SSHAuthority)
	populate(objectMap, "sharedPublicIpAddressConfiguration", n.SharedPublicIPAddressConfiguration)
	populate(objectMap, "subnetId", n.SubnetID)
	populate(objectMap, "virtualNetworkId", n.VirtualNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkInterfaceProperties.
func (n *NetworkInterfaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsName":
			err = unpopulate(val, "DNSName", &n.DNSName)
			delete(rawMsg, key)
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &n.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &n.PublicIPAddress)
			delete(rawMsg, key)
		case "publicIpAddressId":
			err = unpopulate(val, "PublicIPAddressID", &n.PublicIPAddressID)
			delete(rawMsg, key)
		case "rdpAuthority":
			err = unpopulate(val, "RdpAuthority", &n.RdpAuthority)
			delete(rawMsg, key)
		case "sshAuthority":
			err = unpopulate(val, "SSHAuthority", &n.SSHAuthority)
			delete(rawMsg, key)
		case "sharedPublicIpAddressConfiguration":
			err = unpopulate(val, "SharedPublicIPAddressConfiguration", &n.SharedPublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &n.SubnetID)
			delete(rawMsg, key)
		case "virtualNetworkId":
			err = unpopulate(val, "VirtualNetworkID", &n.VirtualNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannel.
func (n NotificationChannel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", n.ID)
	populate(objectMap, "location", n.Location)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "properties", n.Properties)
	populate(objectMap, "tags", n.Tags)
	populate(objectMap, "type", n.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationChannel.
func (n *NotificationChannel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &n.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &n.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &n.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &n.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannelFragment.
func (n NotificationChannelFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", n.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationChannelFragment.
func (n *NotificationChannelFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &n.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannelList.
func (n NotificationChannelList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", n.NextLink)
	populate(objectMap, "value", n.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationChannelList.
func (n *NotificationChannelList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &n.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationChannelProperties.
func (n NotificationChannelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", n.CreatedDate)
	populate(objectMap, "description", n.Description)
	populate(objectMap, "emailRecipient", n.EmailRecipient)
	populate(objectMap, "events", n.Events)
	populate(objectMap, "notificationLocale", n.NotificationLocale)
	populate(objectMap, "provisioningState", n.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", n.UniqueIdentifier)
	populate(objectMap, "webHookUrl", n.WebHookURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationChannelProperties.
func (n *NotificationChannelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &n.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &n.Description)
			delete(rawMsg, key)
		case "emailRecipient":
			err = unpopulate(val, "EmailRecipient", &n.EmailRecipient)
			delete(rawMsg, key)
		case "events":
			err = unpopulate(val, "Events", &n.Events)
			delete(rawMsg, key)
		case "notificationLocale":
			err = unpopulate(val, "NotificationLocale", &n.NotificationLocale)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &n.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &n.UniqueIdentifier)
			delete(rawMsg, key)
		case "webHookUrl":
			err = unpopulate(val, "WebHookURL", &n.WebHookURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationSettings.
func (n NotificationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "emailRecipient", n.EmailRecipient)
	populate(objectMap, "notificationLocale", n.NotificationLocale)
	populate(objectMap, "status", n.Status)
	populate(objectMap, "timeInMinutes", n.TimeInMinutes)
	populate(objectMap, "webhookUrl", n.WebhookURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationSettings.
func (n *NotificationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "emailRecipient":
			err = unpopulate(val, "EmailRecipient", &n.EmailRecipient)
			delete(rawMsg, key)
		case "notificationLocale":
			err = unpopulate(val, "NotificationLocale", &n.NotificationLocale)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &n.Status)
			delete(rawMsg, key)
		case "timeInMinutes":
			err = unpopulate(val, "TimeInMinutes", &n.TimeInMinutes)
			delete(rawMsg, key)
		case "webhookUrl":
			err = unpopulate(val, "WebhookURL", &n.WebhookURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotifyParameters.
func (n NotifyParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventName", n.EventName)
	populate(objectMap, "jsonPayload", n.JSONPayload)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotifyParameters.
func (n *NotifyParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventName":
			err = unpopulate(val, "EventName", &n.EventName)
			delete(rawMsg, key)
		case "jsonPayload":
			err = unpopulate(val, "JSONPayload", &n.JSONPayload)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationError.
func (o OperationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "message", o.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationError.
func (o *OperationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &o.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetadata.
func (o OperationMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetadata.
func (o *OperationMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationMetadataDisplay.
func (o OperationMetadataDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationMetadataDisplay.
func (o *OperationMetadataDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResult.
func (o OperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "status", o.Status)
	populate(objectMap, "statusCode", o.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResult.
func (o *OperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &o.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParameterInfo.
func (p ParameterInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParameterInfo.
func (p *ParameterInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ParametersValueFileInfo.
func (p ParametersValueFileInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fileName", p.FileName)
	populateAny(objectMap, "parametersValueInfo", p.ParametersValueInfo)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ParametersValueFileInfo.
func (p *ParametersValueFileInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fileName":
			err = unpopulate(val, "FileName", &p.FileName)
			delete(rawMsg, key)
		case "parametersValueInfo":
			err = unpopulate(val, "ParametersValueInfo", &p.ParametersValueInfo)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PercentageCostThresholdProperties.
func (p PercentageCostThresholdProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "thresholdValue", p.ThresholdValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PercentageCostThresholdProperties.
func (p *PercentageCostThresholdProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "thresholdValue":
			err = unpopulate(val, "ThresholdValue", &p.ThresholdValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Policy.
func (p Policy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Policy.
func (p *Policy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyFragment.
func (p PolicyFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyFragment.
func (p *PolicyFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyList.
func (p PolicyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyList.
func (p *PolicyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyProperties.
func (p PolicyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", p.CreatedDate)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "evaluatorType", p.EvaluatorType)
	populate(objectMap, "factData", p.FactData)
	populate(objectMap, "factName", p.FactName)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "threshold", p.Threshold)
	populate(objectMap, "uniqueIdentifier", p.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyProperties.
func (p *PolicyProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &p.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "evaluatorType":
			err = unpopulate(val, "EvaluatorType", &p.EvaluatorType)
			delete(rawMsg, key)
		case "factData":
			err = unpopulate(val, "FactData", &p.FactData)
			delete(rawMsg, key)
		case "factName":
			err = unpopulate(val, "FactName", &p.FactName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "threshold":
			err = unpopulate(val, "Threshold", &p.Threshold)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &p.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicySetResult.
func (p PolicySetResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hasError", p.HasError)
	populate(objectMap, "policyViolations", p.PolicyViolations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicySetResult.
func (p *PolicySetResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hasError":
			err = unpopulate(val, "HasError", &p.HasError)
			delete(rawMsg, key)
		case "policyViolations":
			err = unpopulate(val, "PolicyViolations", &p.PolicyViolations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyViolation.
func (p PolicyViolation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", p.Code)
	populate(objectMap, "message", p.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyViolation.
func (p *PolicyViolation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Port.
func (p Port) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "backendPort", p.BackendPort)
	populate(objectMap, "transportProtocol", p.TransportProtocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Port.
func (p *Port) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "backendPort":
			err = unpopulate(val, "BackendPort", &p.BackendPort)
			delete(rawMsg, key)
		case "transportProtocol":
			err = unpopulate(val, "TransportProtocol", &p.TransportProtocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProviderOperationResult.
func (p ProviderOperationResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProviderOperationResult.
func (p *ProviderOperationResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RdpConnection.
func (r RdpConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contents", r.Contents)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RdpConnection.
func (r *RdpConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contents":
			err = unpopulate(val, "Contents", &r.Contents)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResizeLabVirtualMachineProperties.
func (r ResizeLabVirtualMachineProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "size", r.Size)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResizeLabVirtualMachineProperties.
func (r *ResizeLabVirtualMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "size":
			err = unpopulate(val, "Size", &r.Size)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RetargetScheduleProperties.
func (r RetargetScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentResourceId", r.CurrentResourceID)
	populate(objectMap, "targetResourceId", r.TargetResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RetargetScheduleProperties.
func (r *RetargetScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentResourceId":
			err = unpopulate(val, "CurrentResourceID", &r.CurrentResourceID)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &r.TargetResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Schedule.
func (s *Schedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleCreationParameter.
func (s ScheduleCreationParameter) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleCreationParameter.
func (s *ScheduleCreationParameter) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleCreationParameterProperties.
func (s ScheduleCreationParameterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dailyRecurrence", s.DailyRecurrence)
	populate(objectMap, "hourlyRecurrence", s.HourlyRecurrence)
	populate(objectMap, "notificationSettings", s.NotificationSettings)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "targetResourceId", s.TargetResourceID)
	populate(objectMap, "taskType", s.TaskType)
	populate(objectMap, "timeZoneId", s.TimeZoneID)
	populate(objectMap, "weeklyRecurrence", s.WeeklyRecurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleCreationParameterProperties.
func (s *ScheduleCreationParameterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dailyRecurrence":
			err = unpopulate(val, "DailyRecurrence", &s.DailyRecurrence)
			delete(rawMsg, key)
		case "hourlyRecurrence":
			err = unpopulate(val, "HourlyRecurrence", &s.HourlyRecurrence)
			delete(rawMsg, key)
		case "notificationSettings":
			err = unpopulate(val, "NotificationSettings", &s.NotificationSettings)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &s.TargetResourceID)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &s.TaskType)
			delete(rawMsg, key)
		case "timeZoneId":
			err = unpopulate(val, "TimeZoneID", &s.TimeZoneID)
			delete(rawMsg, key)
		case "weeklyRecurrence":
			err = unpopulate(val, "WeeklyRecurrence", &s.WeeklyRecurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleFragment.
func (s ScheduleFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleFragment.
func (s *ScheduleFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleList.
func (s ScheduleList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleList.
func (s *ScheduleList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleProperties.
func (s ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", s.CreatedDate)
	populate(objectMap, "dailyRecurrence", s.DailyRecurrence)
	populate(objectMap, "hourlyRecurrence", s.HourlyRecurrence)
	populate(objectMap, "notificationSettings", s.NotificationSettings)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "targetResourceId", s.TargetResourceID)
	populate(objectMap, "taskType", s.TaskType)
	populate(objectMap, "timeZoneId", s.TimeZoneID)
	populate(objectMap, "uniqueIdentifier", s.UniqueIdentifier)
	populate(objectMap, "weeklyRecurrence", s.WeeklyRecurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleProperties.
func (s *ScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &s.CreatedDate)
			delete(rawMsg, key)
		case "dailyRecurrence":
			err = unpopulate(val, "DailyRecurrence", &s.DailyRecurrence)
			delete(rawMsg, key)
		case "hourlyRecurrence":
			err = unpopulate(val, "HourlyRecurrence", &s.HourlyRecurrence)
			delete(rawMsg, key)
		case "notificationSettings":
			err = unpopulate(val, "NotificationSettings", &s.NotificationSettings)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "targetResourceId":
			err = unpopulate(val, "TargetResourceID", &s.TargetResourceID)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &s.TaskType)
			delete(rawMsg, key)
		case "timeZoneId":
			err = unpopulate(val, "TimeZoneID", &s.TimeZoneID)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &s.UniqueIdentifier)
			delete(rawMsg, key)
		case "weeklyRecurrence":
			err = unpopulate(val, "WeeklyRecurrence", &s.WeeklyRecurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Secret.
func (s Secret) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Secret.
func (s *Secret) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretFragment.
func (s SecretFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretFragment.
func (s *SecretFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretList.
func (s SecretList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretList.
func (s *SecretList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SecretProperties.
func (s SecretProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", s.UniqueIdentifier)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SecretProperties.
func (s *SecretProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &s.UniqueIdentifier)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceFabric.
func (s ServiceFabric) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceFabric.
func (s *ServiceFabric) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceFabricFragment.
func (s ServiceFabricFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceFabricFragment.
func (s *ServiceFabricFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceFabricList.
func (s ServiceFabricList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceFabricList.
func (s *ServiceFabricList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceFabricProperties.
func (s ServiceFabricProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicableSchedule", s.ApplicableSchedule)
	populate(objectMap, "environmentId", s.EnvironmentID)
	populate(objectMap, "externalServiceFabricId", s.ExternalServiceFabricID)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "uniqueIdentifier", s.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceFabricProperties.
func (s *ServiceFabricProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicableSchedule":
			err = unpopulate(val, "ApplicableSchedule", &s.ApplicableSchedule)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &s.EnvironmentID)
			delete(rawMsg, key)
		case "externalServiceFabricId":
			err = unpopulate(val, "ExternalServiceFabricID", &s.ExternalServiceFabricID)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &s.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceRunner.
func (s ServiceRunner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceRunner.
func (s *ServiceRunner) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &s.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceRunnerList.
func (s ServiceRunnerList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceRunnerList.
func (s *ServiceRunnerList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedPublicIPAddressConfiguration.
func (s SharedPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "inboundNatRules", s.InboundNatRules)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedPublicIPAddressConfiguration.
func (s *SharedPublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "inboundNatRules":
			err = unpopulate(val, "InboundNatRules", &s.InboundNatRules)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ShutdownNotificationContent.
func (s ShutdownNotificationContent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayUrl120", s.DelayUrl120)
	populate(objectMap, "delayUrl60", s.DelayUrl60)
	populate(objectMap, "eventType", s.EventType)
	populate(objectMap, "guid", s.GUID)
	populate(objectMap, "labName", s.LabName)
	populate(objectMap, "minutesUntilShutdown", s.MinutesUntilShutdown)
	populate(objectMap, "owner", s.Owner)
	populate(objectMap, "resourceGroupName", s.ResourceGroupName)
	populate(objectMap, "skipUrl", s.SkipURL)
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	populate(objectMap, "text", s.Text)
	populate(objectMap, "vmName", s.VMName)
	populate(objectMap, "vmUrl", s.VMURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ShutdownNotificationContent.
func (s *ShutdownNotificationContent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayUrl120":
			err = unpopulate(val, "DelayUrl120", &s.DelayUrl120)
			delete(rawMsg, key)
		case "delayUrl60":
			err = unpopulate(val, "DelayUrl60", &s.DelayUrl60)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &s.EventType)
			delete(rawMsg, key)
		case "guid":
			err = unpopulate(val, "GUID", &s.GUID)
			delete(rawMsg, key)
		case "labName":
			err = unpopulate(val, "LabName", &s.LabName)
			delete(rawMsg, key)
		case "minutesUntilShutdown":
			err = unpopulate(val, "MinutesUntilShutdown", &s.MinutesUntilShutdown)
			delete(rawMsg, key)
		case "owner":
			err = unpopulate(val, "Owner", &s.Owner)
			delete(rawMsg, key)
		case "resourceGroupName":
			err = unpopulate(val, "ResourceGroupName", &s.ResourceGroupName)
			delete(rawMsg, key)
		case "skipUrl":
			err = unpopulate(val, "SkipURL", &s.SkipURL)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		case "text":
			err = unpopulate(val, "Text", &s.Text)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &s.VMName)
			delete(rawMsg, key)
		case "vmUrl":
			err = unpopulate(val, "VMURL", &s.VMURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Subnet.
func (s Subnet) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowPublicIp", s.AllowPublicIP)
	populate(objectMap, "labSubnetName", s.LabSubnetName)
	populate(objectMap, "resourceId", s.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Subnet.
func (s *Subnet) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowPublicIp":
			err = unpopulate(val, "AllowPublicIP", &s.AllowPublicIP)
			delete(rawMsg, key)
		case "labSubnetName":
			err = unpopulate(val, "LabSubnetName", &s.LabSubnetName)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetOverride.
func (s SubnetOverride) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "labSubnetName", s.LabSubnetName)
	populate(objectMap, "resourceId", s.ResourceID)
	populate(objectMap, "sharedPublicIpAddressConfiguration", s.SharedPublicIPAddressConfiguration)
	populate(objectMap, "useInVmCreationPermission", s.UseInVMCreationPermission)
	populate(objectMap, "usePublicIpAddressPermission", s.UsePublicIPAddressPermission)
	populate(objectMap, "virtualNetworkPoolName", s.VirtualNetworkPoolName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetOverride.
func (s *SubnetOverride) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "labSubnetName":
			err = unpopulate(val, "LabSubnetName", &s.LabSubnetName)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		case "sharedPublicIpAddressConfiguration":
			err = unpopulate(val, "SharedPublicIPAddressConfiguration", &s.SharedPublicIPAddressConfiguration)
			delete(rawMsg, key)
		case "useInVmCreationPermission":
			err = unpopulate(val, "UseInVMCreationPermission", &s.UseInVMCreationPermission)
			delete(rawMsg, key)
		case "usePublicIpAddressPermission":
			err = unpopulate(val, "UsePublicIPAddressPermission", &s.UsePublicIPAddressPermission)
			delete(rawMsg, key)
		case "virtualNetworkPoolName":
			err = unpopulate(val, "VirtualNetworkPoolName", &s.VirtualNetworkPoolName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubnetSharedPublicIPAddressConfiguration.
func (s SubnetSharedPublicIPAddressConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedPorts", s.AllowedPorts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubnetSharedPublicIPAddressConfiguration.
func (s *SubnetSharedPublicIPAddressConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedPorts":
			err = unpopulate(val, "AllowedPorts", &s.AllowedPorts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetCostProperties.
func (t TargetCostProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "costThresholds", t.CostThresholds)
	populateDateTimeRFC3339(objectMap, "cycleEndDateTime", t.CycleEndDateTime)
	populateDateTimeRFC3339(objectMap, "cycleStartDateTime", t.CycleStartDateTime)
	populate(objectMap, "cycleType", t.CycleType)
	populate(objectMap, "status", t.Status)
	populate(objectMap, "target", t.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetCostProperties.
func (t *TargetCostProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "costThresholds":
			err = unpopulate(val, "CostThresholds", &t.CostThresholds)
			delete(rawMsg, key)
		case "cycleEndDateTime":
			err = unpopulateDateTimeRFC3339(val, "CycleEndDateTime", &t.CycleEndDateTime)
			delete(rawMsg, key)
		case "cycleStartDateTime":
			err = unpopulateDateTimeRFC3339(val, "CycleStartDateTime", &t.CycleStartDateTime)
			delete(rawMsg, key)
		case "cycleType":
			err = unpopulate(val, "CycleType", &t.CycleType)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &t.Status)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &t.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateResource.
func (u UpdateResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateResource.
func (u *UpdateResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type User.
func (u User) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "location", u.Location)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	populate(objectMap, "type", u.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type User.
func (u *User) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &u.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserFragment.
func (u UserFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserFragment.
func (u *UserFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserIdentity.
func (u UserIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appId", u.AppID)
	populate(objectMap, "objectId", u.ObjectID)
	populate(objectMap, "principalId", u.PrincipalID)
	populate(objectMap, "principalName", u.PrincipalName)
	populate(objectMap, "tenantId", u.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserIdentity.
func (u *UserIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appId":
			err = unpopulate(val, "AppID", &u.AppID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &u.ObjectID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		case "principalName":
			err = unpopulate(val, "PrincipalName", &u.PrincipalName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &u.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserList.
func (u UserList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserList.
func (u *UserList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserProperties.
func (u UserProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdDate", u.CreatedDate)
	populate(objectMap, "identity", u.Identity)
	populate(objectMap, "provisioningState", u.ProvisioningState)
	populate(objectMap, "secretStore", u.SecretStore)
	populate(objectMap, "uniqueIdentifier", u.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserProperties.
func (u *UserProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &u.CreatedDate)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &u.Identity)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &u.ProvisioningState)
			delete(rawMsg, key)
		case "secretStore":
			err = unpopulate(val, "SecretStore", &u.SecretStore)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &u.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserSecretStore.
func (u UserSecretStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyVaultId", u.KeyVaultID)
	populate(objectMap, "keyVaultUri", u.KeyVaultURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserSecretStore.
func (u *UserSecretStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &u.KeyVaultID)
			delete(rawMsg, key)
		case "keyVaultUri":
			err = unpopulate(val, "KeyVaultURI", &u.KeyVaultURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetwork.
func (v VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetwork.
func (v *VirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkFragment.
func (v VirtualNetworkFragment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkFragment.
func (v *VirtualNetworkFragment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkList.
func (v VirtualNetworkList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkList.
func (v *VirtualNetworkList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProperties.
func (v VirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedSubnets", v.AllowedSubnets)
	populateDateTimeRFC3339(objectMap, "createdDate", v.CreatedDate)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "externalProviderResourceId", v.ExternalProviderResourceID)
	populate(objectMap, "externalSubnets", v.ExternalSubnets)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "subnetOverrides", v.SubnetOverrides)
	populate(objectMap, "uniqueIdentifier", v.UniqueIdentifier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProperties.
func (v *VirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedSubnets":
			err = unpopulate(val, "AllowedSubnets", &v.AllowedSubnets)
			delete(rawMsg, key)
		case "createdDate":
			err = unpopulateDateTimeRFC3339(val, "CreatedDate", &v.CreatedDate)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "externalProviderResourceId":
			err = unpopulate(val, "ExternalProviderResourceID", &v.ExternalProviderResourceID)
			delete(rawMsg, key)
		case "externalSubnets":
			err = unpopulate(val, "ExternalSubnets", &v.ExternalSubnets)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "subnetOverrides":
			err = unpopulate(val, "SubnetOverrides", &v.SubnetOverrides)
			delete(rawMsg, key)
		case "uniqueIdentifier":
			err = unpopulate(val, "UniqueIdentifier", &v.UniqueIdentifier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WeekDetails.
func (w WeekDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "time", w.Time)
	populate(objectMap, "weekdays", w.Weekdays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WeekDetails.
func (w *WeekDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "time":
			err = unpopulate(val, "Time", &w.Time)
			delete(rawMsg, key)
		case "weekdays":
			err = unpopulate(val, "Weekdays", &w.Weekdays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsOsInfo.
func (w WindowsOsInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "windowsOsState", w.WindowsOsState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsOsInfo.
func (w *WindowsOsInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "windowsOsState":
			err = unpopulate(val, "WindowsOsState", &w.WindowsOsState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
