//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/education/armeducation"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// JoinRequestsServer is a fake server for instances of the armeducation.JoinRequestsClient type.
type JoinRequestsServer struct {
	// Approve is the fake for method JoinRequestsClient.Approve
	// HTTP status codes to indicate success: http.StatusOK
	Approve func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *armeducation.JoinRequestsClientApproveOptions) (resp azfake.Responder[armeducation.JoinRequestsClientApproveResponse], errResp azfake.ErrorResponder)

	// Deny is the fake for method JoinRequestsClient.Deny
	// HTTP status codes to indicate success: http.StatusOK
	Deny func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *armeducation.JoinRequestsClientDenyOptions) (resp azfake.Responder[armeducation.JoinRequestsClientDenyResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method JoinRequestsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, billingAccountName string, billingProfileName string, invoiceSectionName string, joinRequestName string, options *armeducation.JoinRequestsClientGetOptions) (resp azfake.Responder[armeducation.JoinRequestsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method JoinRequestsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(billingAccountName string, billingProfileName string, invoiceSectionName string, options *armeducation.JoinRequestsClientListOptions) (resp azfake.PagerResponder[armeducation.JoinRequestsClientListResponse])
}

// NewJoinRequestsServerTransport creates a new instance of JoinRequestsServerTransport with the provided implementation.
// The returned JoinRequestsServerTransport instance is connected to an instance of armeducation.JoinRequestsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewJoinRequestsServerTransport(srv *JoinRequestsServer) *JoinRequestsServerTransport {
	return &JoinRequestsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armeducation.JoinRequestsClientListResponse]](),
	}
}

// JoinRequestsServerTransport connects instances of armeducation.JoinRequestsClient to instances of JoinRequestsServer.
// Don't use this type directly, use NewJoinRequestsServerTransport instead.
type JoinRequestsServerTransport struct {
	srv          *JoinRequestsServer
	newListPager *tracker[azfake.PagerResponder[armeducation.JoinRequestsClientListResponse]]
}

// Do implements the policy.Transporter interface for JoinRequestsServerTransport.
func (j *JoinRequestsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "JoinRequestsClient.Approve":
		resp, err = j.dispatchApprove(req)
	case "JoinRequestsClient.Deny":
		resp, err = j.dispatchDeny(req)
	case "JoinRequestsClient.Get":
		resp, err = j.dispatchGet(req)
	case "JoinRequestsClient.NewListPager":
		resp, err = j.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (j *JoinRequestsServerTransport) dispatchApprove(req *http.Request) (*http.Response, error) {
	if j.srv.Approve == nil {
		return nil, &nonRetriableError{errors.New("fake for method Approve not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default/joinRequests/(?P<joinRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/approve`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	joinRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("joinRequestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Approve(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, joinRequestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JoinRequestsServerTransport) dispatchDeny(req *http.Request) (*http.Response, error) {
	if j.srv.Deny == nil {
		return nil, &nonRetriableError{errors.New("fake for method Deny not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default/joinRequests/(?P<joinRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deny`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	joinRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("joinRequestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Deny(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, joinRequestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JoinRequestsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if j.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default/joinRequests/(?P<joinRequestName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
	if err != nil {
		return nil, err
	}
	billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
	if err != nil {
		return nil, err
	}
	invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
	if err != nil {
		return nil, err
	}
	joinRequestNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("joinRequestName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := j.srv.Get(req.Context(), billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, joinRequestNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).JoinRequestDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (j *JoinRequestsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if j.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := j.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/providers/Microsoft\.Billing/billingAccounts/(?P<billingAccountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/billingProfiles/(?P<billingProfileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/invoiceSections/(?P<invoiceSectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Education/labs/default/joinRequests`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		billingAccountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingAccountName")])
		if err != nil {
			return nil, err
		}
		billingProfileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("billingProfileName")])
		if err != nil {
			return nil, err
		}
		invoiceSectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("invoiceSectionName")])
		if err != nil {
			return nil, err
		}
		includeDeniedUnescaped, err := url.QueryUnescape(qp.Get("includeDenied"))
		if err != nil {
			return nil, err
		}
		includeDeniedParam, err := parseOptional(includeDeniedUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armeducation.JoinRequestsClientListOptions
		if includeDeniedParam != nil {
			options = &armeducation.JoinRequestsClientListOptions{
				IncludeDenied: includeDeniedParam,
			}
		}
		resp := j.srv.NewListPager(billingAccountNameParam, billingProfileNameParam, invoiceSectionNameParam, options)
		newListPager = &resp
		j.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armeducation.JoinRequestsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		j.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		j.newListPager.remove(req)
	}
	return resp, nil
}
