//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewCaCertificatesClient creates a new instance of CaCertificatesClient.
func (c *ClientFactory) NewCaCertificatesClient() *CaCertificatesClient {
	return &CaCertificatesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewChannelsClient creates a new instance of ChannelsClient.
func (c *ClientFactory) NewChannelsClient() *ChannelsClient {
	return &ChannelsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClientGroupsClient creates a new instance of ClientGroupsClient.
func (c *ClientFactory) NewClientGroupsClient() *ClientGroupsClient {
	return &ClientGroupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewClientsClient creates a new instance of ClientsClient.
func (c *ClientFactory) NewClientsClient() *ClientsClient {
	return &ClientsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDomainEventSubscriptionsClient creates a new instance of DomainEventSubscriptionsClient.
func (c *ClientFactory) NewDomainEventSubscriptionsClient() *DomainEventSubscriptionsClient {
	return &DomainEventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDomainTopicEventSubscriptionsClient creates a new instance of DomainTopicEventSubscriptionsClient.
func (c *ClientFactory) NewDomainTopicEventSubscriptionsClient() *DomainTopicEventSubscriptionsClient {
	return &DomainTopicEventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDomainTopicsClient creates a new instance of DomainTopicsClient.
func (c *ClientFactory) NewDomainTopicsClient() *DomainTopicsClient {
	return &DomainTopicsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewDomainsClient creates a new instance of DomainsClient.
func (c *ClientFactory) NewDomainsClient() *DomainsClient {
	return &DomainsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewEventSubscriptionsClient creates a new instance of EventSubscriptionsClient.
func (c *ClientFactory) NewEventSubscriptionsClient() *EventSubscriptionsClient {
	return &EventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewExtensionTopicsClient creates a new instance of ExtensionTopicsClient.
func (c *ClientFactory) NewExtensionTopicsClient() *ExtensionTopicsClient {
	return &ExtensionTopicsClient{
		internal: c.internal,
	}
}

// NewNamespaceTopicEventSubscriptionsClient creates a new instance of NamespaceTopicEventSubscriptionsClient.
func (c *ClientFactory) NewNamespaceTopicEventSubscriptionsClient() *NamespaceTopicEventSubscriptionsClient {
	return &NamespaceTopicEventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewNamespaceTopicsClient creates a new instance of NamespaceTopicsClient.
func (c *ClientFactory) NewNamespaceTopicsClient() *NamespaceTopicsClient {
	return &NamespaceTopicsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewNamespacesClient creates a new instance of NamespacesClient.
func (c *ClientFactory) NewNamespacesClient() *NamespacesClient {
	return &NamespacesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewNetworkSecurityPerimeterConfigurationsClient creates a new instance of NetworkSecurityPerimeterConfigurationsClient.
func (c *ClientFactory) NewNetworkSecurityPerimeterConfigurationsClient() *NetworkSecurityPerimeterConfigurationsClient {
	return &NetworkSecurityPerimeterConfigurationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewPartnerConfigurationsClient creates a new instance of PartnerConfigurationsClient.
func (c *ClientFactory) NewPartnerConfigurationsClient() *PartnerConfigurationsClient {
	return &PartnerConfigurationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPartnerDestinationsClient creates a new instance of PartnerDestinationsClient.
func (c *ClientFactory) NewPartnerDestinationsClient() *PartnerDestinationsClient {
	return &PartnerDestinationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPartnerNamespacesClient creates a new instance of PartnerNamespacesClient.
func (c *ClientFactory) NewPartnerNamespacesClient() *PartnerNamespacesClient {
	return &PartnerNamespacesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPartnerRegistrationsClient creates a new instance of PartnerRegistrationsClient.
func (c *ClientFactory) NewPartnerRegistrationsClient() *PartnerRegistrationsClient {
	return &PartnerRegistrationsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPartnerTopicEventSubscriptionsClient creates a new instance of PartnerTopicEventSubscriptionsClient.
func (c *ClientFactory) NewPartnerTopicEventSubscriptionsClient() *PartnerTopicEventSubscriptionsClient {
	return &PartnerTopicEventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPartnerTopicsClient creates a new instance of PartnerTopicsClient.
func (c *ClientFactory) NewPartnerTopicsClient() *PartnerTopicsClient {
	return &PartnerTopicsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPermissionBindingsClient creates a new instance of PermissionBindingsClient.
func (c *ClientFactory) NewPermissionBindingsClient() *PermissionBindingsClient {
	return &PermissionBindingsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	return &PrivateEndpointConnectionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	return &PrivateLinkResourcesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSystemTopicEventSubscriptionsClient creates a new instance of SystemTopicEventSubscriptionsClient.
func (c *ClientFactory) NewSystemTopicEventSubscriptionsClient() *SystemTopicEventSubscriptionsClient {
	return &SystemTopicEventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSystemTopicsClient creates a new instance of SystemTopicsClient.
func (c *ClientFactory) NewSystemTopicsClient() *SystemTopicsClient {
	return &SystemTopicsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTopicEventSubscriptionsClient creates a new instance of TopicEventSubscriptionsClient.
func (c *ClientFactory) NewTopicEventSubscriptionsClient() *TopicEventSubscriptionsClient {
	return &TopicEventSubscriptionsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTopicSpacesClient creates a new instance of TopicSpacesClient.
func (c *ClientFactory) NewTopicSpacesClient() *TopicSpacesClient {
	return &TopicSpacesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewTopicTypesClient creates a new instance of TopicTypesClient.
func (c *ClientFactory) NewTopicTypesClient() *TopicTypesClient {
	return &TopicTypesClient{
		internal: c.internal,
	}
}

// NewTopicsClient creates a new instance of TopicsClient.
func (c *ClientFactory) NewTopicsClient() *TopicsClient {
	return &TopicsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewVerifiedPartnersClient creates a new instance of VerifiedPartnersClient.
func (c *ClientFactory) NewVerifiedPartnersClient() *VerifiedPartnersClient {
	return &VerifiedPartnersClient{
		internal: c.internal,
	}
}
