//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventhub

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Subscription credentials that uniquely identify a Microsoft Azure subscription. The subscription ID forms
//     part of the URI for every service call.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewApplicationGroupClient creates a new instance of ApplicationGroupClient.
func (c *ClientFactory) NewApplicationGroupClient() *ApplicationGroupClient {
	subClient, _ := NewApplicationGroupClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewClustersClient creates a new instance of ClustersClient.
func (c *ClientFactory) NewClustersClient() *ClustersClient {
	subClient, _ := NewClustersClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConfigurationClient creates a new instance of ConfigurationClient.
func (c *ClientFactory) NewConfigurationClient() *ConfigurationClient {
	subClient, _ := NewConfigurationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewConsumerGroupsClient creates a new instance of ConsumerGroupsClient.
func (c *ClientFactory) NewConsumerGroupsClient() *ConsumerGroupsClient {
	subClient, _ := NewConsumerGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewDisasterRecoveryConfigsClient creates a new instance of DisasterRecoveryConfigsClient.
func (c *ClientFactory) NewDisasterRecoveryConfigsClient() *DisasterRecoveryConfigsClient {
	subClient, _ := NewDisasterRecoveryConfigsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewEventHubsClient creates a new instance of EventHubsClient.
func (c *ClientFactory) NewEventHubsClient() *EventHubsClient {
	subClient, _ := NewEventHubsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNamespacesClient creates a new instance of NamespacesClient.
func (c *ClientFactory) NewNamespacesClient() *NamespacesClient {
	subClient, _ := NewNamespacesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkSecurityPerimeterConfigurationClient creates a new instance of NetworkSecurityPerimeterConfigurationClient.
func (c *ClientFactory) NewNetworkSecurityPerimeterConfigurationClient() *NetworkSecurityPerimeterConfigurationClient {
	subClient, _ := NewNetworkSecurityPerimeterConfigurationClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewNetworkSecurityPerimeterConfigurationsClient creates a new instance of NetworkSecurityPerimeterConfigurationsClient.
func (c *ClientFactory) NewNetworkSecurityPerimeterConfigurationsClient() *NetworkSecurityPerimeterConfigurationsClient {
	subClient, _ := NewNetworkSecurityPerimeterConfigurationsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionsClient creates a new instance of PrivateEndpointConnectionsClient.
func (c *ClientFactory) NewPrivateEndpointConnectionsClient() *PrivateEndpointConnectionsClient {
	subClient, _ := NewPrivateEndpointConnectionsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourcesClient creates a new instance of PrivateLinkResourcesClient.
func (c *ClientFactory) NewPrivateLinkResourcesClient() *PrivateLinkResourcesClient {
	subClient, _ := NewPrivateLinkResourcesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewSchemaRegistryClient creates a new instance of SchemaRegistryClient.
func (c *ClientFactory) NewSchemaRegistryClient() *SchemaRegistryClient {
	subClient, _ := NewSchemaRegistryClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
