//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

import "time"

// ArmResourceDefinitionResourceElementTemplate - The arm template RE.
type ArmResourceDefinitionResourceElementTemplate struct {
	// Artifact profile properties.
	ArtifactProfile *NSDArtifactProfile

	// Name and value pairs that define the parameter values. It can be a well formed escaped JSON string.
	ParameterValues *string

	// The template type.
	TemplateType *TemplateType
}

// ArmResourceDefinitionResourceElementTemplateDetails - The arm resource definition resource element template details.
type ArmResourceDefinitionResourceElementTemplateDetails struct {
	// REQUIRED; The resource element template type.
	ResourceElementType *Type

	// The resource element template type.
	Configuration *ArmResourceDefinitionResourceElementTemplate

	// The depends on profile.
	DependsOnProfile *DependsOnProfile

	// Name of the resource element template.
	Name *string
}

// GetResourceElementTemplate implements the ResourceElementTemplateClassification interface for type ArmResourceDefinitionResourceElementTemplateDetails.
func (a *ArmResourceDefinitionResourceElementTemplateDetails) GetResourceElementTemplate() *ResourceElementTemplate {
	return &ResourceElementTemplate{
		DependsOnProfile:    a.DependsOnProfile,
		Name:                a.Name,
		ResourceElementType: a.ResourceElementType,
	}
}

// ArmTemplateArtifactProfile - Template artifact profile.
type ArmTemplateArtifactProfile struct {
	// Template name.
	TemplateName *string

	// Template version.
	TemplateVersion *string
}

// ArmTemplateMappingRuleProfile - Template mapping rule profile
type ArmTemplateMappingRuleProfile struct {
	// List of template parameters.
	TemplateParameters *string
}

// ArtifactAccessCredential - The artifact manifest credential definition.
type ArtifactAccessCredential struct {
	// REQUIRED; The credential type.
	CredentialType *CredentialType
}

// GetArtifactAccessCredential implements the ArtifactAccessCredentialClassification interface for type ArtifactAccessCredential.
func (a *ArtifactAccessCredential) GetArtifactAccessCredential() *ArtifactAccessCredential { return a }

// ArtifactChangeState - The artifact updating request payload.
type ArtifactChangeState struct {
	// Artifact update state properties.
	Properties *ArtifactChangeStateProperties
}

// ArtifactChangeStateProperties - The artifact update state properties.
type ArtifactChangeStateProperties struct {
	// The artifact state
	ArtifactState *ArtifactState
}

// ArtifactManifest - Artifact manifest properties.
type ArtifactManifest struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Artifact manifest properties.
	Properties *ArtifactManifestPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ArtifactManifestListResult - A list of artifact manifests.
type ArtifactManifestListResult struct {
	// A list of artifact manifests.
	Value []*ArtifactManifest

	// READ-ONLY; The URI to get the next set of results.
	NextLink *string
}

// ArtifactManifestPropertiesFormat - Artifact manifest properties.
type ArtifactManifestPropertiesFormat struct {
	// The artifacts list.
	Artifacts []*ManifestArtifactFormat

	// READ-ONLY; The artifact manifest state.
	ArtifactManifestState *ArtifactManifestState

	// READ-ONLY; The provisioning state of the ArtifactManifest resource.
	ProvisioningState *ProvisioningState
}

// ArtifactManifestUpdateState - The artifact manifest updating request payload. Only the 'Uploaded' state is allowed for
// updates. Other states are used for internal state transitioning.
type ArtifactManifestUpdateState struct {
	// The artifact manifest state.
	ArtifactManifestState *ArtifactManifestState
}

// ArtifactStore - Artifact store properties.
type ArtifactStore struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// ArtifactStores properties.
	Properties *ArtifactStorePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ArtifactStoreListResult - A list of artifact stores.
type ArtifactStoreListResult struct {
	// A list of artifact stores.
	Value []*ArtifactStore

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ArtifactStorePropertiesFormat - Artifact store properties.
type ArtifactStorePropertiesFormat struct {
	ManagedResourceGroupConfiguration *ArtifactStorePropertiesFormatManagedResourceGroupConfiguration

	// The replication strategy.
	ReplicationStrategy *ArtifactReplicationStrategy

	// The artifact store type.
	StoreType *ArtifactStoreType

	// READ-ONLY; The provisioning state of the application groups resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The created storage resource id
	StorageResourceID *string
}

type ArtifactStorePropertiesFormatManagedResourceGroupConfiguration struct {
	// The managed resource group location.
	Location *string

	// The managed resource group name.
	Name *string
}

// AzureArcK8SClusterNFVIDetails - The AzureArcK8sCluster NFVI detail.
type AzureArcK8SClusterNFVIDetails struct {
	// REQUIRED; The NFVI type.
	NfviType *NFVIType

	// The reference to the custom location.
	CustomLocationReference *ReferencedResource

	// Name of the nfvi.
	Name *string
}

// GetNFVIs implements the NFVIsClassification interface for type AzureArcK8SClusterNFVIDetails.
func (a *AzureArcK8SClusterNFVIDetails) GetNFVIs() *NFVIs {
	return &NFVIs{
		Name:     a.Name,
		NfviType: a.NfviType,
	}
}

// AzureArcKubernetesArtifactProfile - Azure arc kubernetes artifact profile properties.
type AzureArcKubernetesArtifactProfile struct {
	// The reference to artifact store.
	ArtifactStore *ReferencedResource

	// Helm artifact profile.
	HelmArtifactProfile *HelmArtifactProfile
}

// AzureArcKubernetesDeployMappingRuleProfile - Azure arc kubernetes deploy mapping rule profile.
type AzureArcKubernetesDeployMappingRuleProfile struct {
	// The application enablement.
	ApplicationEnablement *ApplicationEnablement

	// The helm mapping rule profile.
	HelmMappingRuleProfile *HelmMappingRuleProfile
}

// AzureArcKubernetesHelmApplication - Azure arc kubernetes helm application configurations.
type AzureArcKubernetesHelmApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureArcKubernetesArtifactType

	// Azure arc kubernetes artifact profile.
	ArtifactProfile *AzureArcKubernetesArtifactProfile

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// Deploy mapping rule profile.
	DeployParametersMappingRuleProfile *AzureArcKubernetesDeployMappingRuleProfile

	// The name of the network function application.
	Name *string
}

// GetAzureArcKubernetesNetworkFunctionApplication implements the AzureArcKubernetesNetworkFunctionApplicationClassification
// interface for type AzureArcKubernetesHelmApplication.
func (a *AzureArcKubernetesHelmApplication) GetAzureArcKubernetesNetworkFunctionApplication() *AzureArcKubernetesNetworkFunctionApplication {
	return &AzureArcKubernetesNetworkFunctionApplication{
		ArtifactType:     a.ArtifactType,
		DependsOnProfile: a.DependsOnProfile,
		Name:             a.Name,
	}
}

// AzureArcKubernetesNetworkFunctionApplication - Azure arc kubernetes network function application definition.
type AzureArcKubernetesNetworkFunctionApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureArcKubernetesArtifactType

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// The name of the network function application.
	Name *string
}

// GetAzureArcKubernetesNetworkFunctionApplication implements the AzureArcKubernetesNetworkFunctionApplicationClassification
// interface for type AzureArcKubernetesNetworkFunctionApplication.
func (a *AzureArcKubernetesNetworkFunctionApplication) GetAzureArcKubernetesNetworkFunctionApplication() *AzureArcKubernetesNetworkFunctionApplication {
	return a
}

// AzureArcKubernetesNetworkFunctionTemplate - Azure Arc kubernetes network function template.
type AzureArcKubernetesNetworkFunctionTemplate struct {
	// REQUIRED; The network function type.
	NfviType *ContainerizedNetworkFunctionNFVIType

	// Network function applications.
	NetworkFunctionApplications []AzureArcKubernetesNetworkFunctionApplicationClassification
}

// GetContainerizedNetworkFunctionTemplate implements the ContainerizedNetworkFunctionTemplateClassification interface for
// type AzureArcKubernetesNetworkFunctionTemplate.
func (a *AzureArcKubernetesNetworkFunctionTemplate) GetContainerizedNetworkFunctionTemplate() *ContainerizedNetworkFunctionTemplate {
	return &ContainerizedNetworkFunctionTemplate{
		NfviType: a.NfviType,
	}
}

// AzureContainerRegistryScopedTokenCredential - The azure container registry scoped token credential definition.
type AzureContainerRegistryScopedTokenCredential struct {
	// REQUIRED; The credential type.
	CredentialType *CredentialType

	// The Acr server url
	AcrServerURL *string

	// The credential value.
	AcrToken *string

	// The UTC time when credential will expire.
	Expiry *time.Time

	// The repositories that could be accessed using the current credential.
	Repositories []*string

	// The username of the credential.
	Username *string
}

// GetArtifactAccessCredential implements the ArtifactAccessCredentialClassification interface for type AzureContainerRegistryScopedTokenCredential.
func (a *AzureContainerRegistryScopedTokenCredential) GetArtifactAccessCredential() *ArtifactAccessCredential {
	return &ArtifactAccessCredential{
		CredentialType: a.CredentialType,
	}
}

// AzureCoreArmTemplateArtifactProfile - Azure template artifact profile properties.
type AzureCoreArmTemplateArtifactProfile struct {
	// The reference to artifact store.
	ArtifactStore *ReferencedResource

	// Template artifact profile.
	TemplateArtifactProfile *ArmTemplateArtifactProfile
}

// AzureCoreArmTemplateDeployMappingRuleProfile - Azure template deploy mapping rule profile.
type AzureCoreArmTemplateDeployMappingRuleProfile struct {
	// The application enablement.
	ApplicationEnablement *ApplicationEnablement

	// The template mapping rule profile.
	TemplateMappingRuleProfile *ArmTemplateMappingRuleProfile
}

// AzureCoreNFVIDetails - The Azure Core NFVI detail.
type AzureCoreNFVIDetails struct {
	// REQUIRED; The NFVI type.
	NfviType *NFVIType

	// Location of the Azure core.
	Location *string

	// Name of the nfvi.
	Name *string
}

// GetNFVIs implements the NFVIsClassification interface for type AzureCoreNFVIDetails.
func (a *AzureCoreNFVIDetails) GetNFVIs() *NFVIs {
	return &NFVIs{
		Name:     a.Name,
		NfviType: a.NfviType,
	}
}

// AzureCoreNetworkFunctionApplication - Azure virtual network function application definition.
type AzureCoreNetworkFunctionApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureCoreArtifactType

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// The name of the network function application.
	Name *string
}

// GetAzureCoreNetworkFunctionApplication implements the AzureCoreNetworkFunctionApplicationClassification interface for type
// AzureCoreNetworkFunctionApplication.
func (a *AzureCoreNetworkFunctionApplication) GetAzureCoreNetworkFunctionApplication() *AzureCoreNetworkFunctionApplication {
	return a
}

// AzureCoreNetworkFunctionArmTemplateApplication - Azure core network function Template application definition.
type AzureCoreNetworkFunctionArmTemplateApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureCoreArtifactType

	// Azure template artifact profile.
	ArtifactProfile *AzureCoreArmTemplateArtifactProfile

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// Deploy mapping rule profile.
	DeployParametersMappingRuleProfile *AzureCoreArmTemplateDeployMappingRuleProfile

	// The name of the network function application.
	Name *string
}

// GetAzureCoreNetworkFunctionApplication implements the AzureCoreNetworkFunctionApplicationClassification interface for type
// AzureCoreNetworkFunctionArmTemplateApplication.
func (a *AzureCoreNetworkFunctionArmTemplateApplication) GetAzureCoreNetworkFunctionApplication() *AzureCoreNetworkFunctionApplication {
	return &AzureCoreNetworkFunctionApplication{
		ArtifactType:     a.ArtifactType,
		DependsOnProfile: a.DependsOnProfile,
		Name:             a.Name,
	}
}

// AzureCoreNetworkFunctionTemplate - Azure virtual network function template.
type AzureCoreNetworkFunctionTemplate struct {
	// REQUIRED; The network function type.
	NfviType *VirtualNetworkFunctionNFVIType

	// Network function applications.
	NetworkFunctionApplications []AzureCoreNetworkFunctionApplicationClassification
}

// GetVirtualNetworkFunctionTemplate implements the VirtualNetworkFunctionTemplateClassification interface for type AzureCoreNetworkFunctionTemplate.
func (a *AzureCoreNetworkFunctionTemplate) GetVirtualNetworkFunctionTemplate() *VirtualNetworkFunctionTemplate {
	return &VirtualNetworkFunctionTemplate{
		NfviType: a.NfviType,
	}
}

// AzureCoreNetworkFunctionVhdApplication - Azure core network function vhd application definition.
type AzureCoreNetworkFunctionVhdApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureCoreArtifactType

	// Azure vhd image artifact profile.
	ArtifactProfile *AzureCoreVhdImageArtifactProfile

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// Deploy mapping rule profile.
	DeployParametersMappingRuleProfile *AzureCoreVhdImageDeployMappingRuleProfile

	// The name of the network function application.
	Name *string
}

// GetAzureCoreNetworkFunctionApplication implements the AzureCoreNetworkFunctionApplicationClassification interface for type
// AzureCoreNetworkFunctionVhdApplication.
func (a *AzureCoreNetworkFunctionVhdApplication) GetAzureCoreNetworkFunctionApplication() *AzureCoreNetworkFunctionApplication {
	return &AzureCoreNetworkFunctionApplication{
		ArtifactType:     a.ArtifactType,
		DependsOnProfile: a.DependsOnProfile,
		Name:             a.Name,
	}
}

// AzureCoreVhdImageArtifactProfile - Azure vhd artifact profile properties.
type AzureCoreVhdImageArtifactProfile struct {
	// The reference to artifact store.
	ArtifactStore *ReferencedResource

	// Vhd artifact profile.
	VhdArtifactProfile *VhdImageArtifactProfile
}

// AzureCoreVhdImageDeployMappingRuleProfile - Azure vhd deploy mapping rule profile.
type AzureCoreVhdImageDeployMappingRuleProfile struct {
	// The application enablement.
	ApplicationEnablement *ApplicationEnablement

	// The vhd mapping rule profile.
	VhdImageMappingRuleProfile *VhdImageMappingRuleProfile
}

// AzureOperatorNexusArmTemplateArtifactProfile - Azure Operator Distributed Services vhd artifact profile properties.
type AzureOperatorNexusArmTemplateArtifactProfile struct {
	// The reference to artifact store.
	ArtifactStore *ReferencedResource

	// Template artifact profile.
	TemplateArtifactProfile *ArmTemplateArtifactProfile
}

// AzureOperatorNexusArmTemplateDeployMappingRuleProfile - Azure Operator Distributed Services template deploy mapping rule
// profile.
type AzureOperatorNexusArmTemplateDeployMappingRuleProfile struct {
	// The application enablement.
	ApplicationEnablement *ApplicationEnablement

	// The template mapping rule profile.
	TemplateMappingRuleProfile *ArmTemplateMappingRuleProfile
}

// AzureOperatorNexusClusterNFVIDetails - The AzureOperatorNexusCluster NFVI detail.
type AzureOperatorNexusClusterNFVIDetails struct {
	// REQUIRED; The NFVI type.
	NfviType *NFVIType

	// The reference to the custom location.
	CustomLocationReference *ReferencedResource

	// Name of the nfvi.
	Name *string
}

// GetNFVIs implements the NFVIsClassification interface for type AzureOperatorNexusClusterNFVIDetails.
func (a *AzureOperatorNexusClusterNFVIDetails) GetNFVIs() *NFVIs {
	return &NFVIs{
		Name:     a.Name,
		NfviType: a.NfviType,
	}
}

// AzureOperatorNexusImageArtifactProfile - Azure Operator Distributed Services image artifact profile properties.
type AzureOperatorNexusImageArtifactProfile struct {
	// The reference to artifact store.
	ArtifactStore *ReferencedResource

	// Image artifact profile.
	ImageArtifactProfile *ImageArtifactProfile
}

// AzureOperatorNexusImageDeployMappingRuleProfile - Azure Operator Distributed Services image deploy mapping rule profile.
type AzureOperatorNexusImageDeployMappingRuleProfile struct {
	// The application enablement.
	ApplicationEnablement *ApplicationEnablement

	// The vhd mapping rule profile.
	ImageMappingRuleProfile *ImageMappingRuleProfile
}

// AzureOperatorNexusNetworkFunctionApplication - Azure Operator Distributed Services network function application definition.
type AzureOperatorNexusNetworkFunctionApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureOperatorNexusArtifactType

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// The name of the network function application.
	Name *string
}

// GetAzureOperatorNexusNetworkFunctionApplication implements the AzureOperatorNexusNetworkFunctionApplicationClassification
// interface for type AzureOperatorNexusNetworkFunctionApplication.
func (a *AzureOperatorNexusNetworkFunctionApplication) GetAzureOperatorNexusNetworkFunctionApplication() *AzureOperatorNexusNetworkFunctionApplication {
	return a
}

// AzureOperatorNexusNetworkFunctionArmTemplateApplication - Azure Operator Distributed Services network function Template
// application definition.
type AzureOperatorNexusNetworkFunctionArmTemplateApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureOperatorNexusArtifactType

	// Azure Operator Distributed Services Template artifact profile.
	ArtifactProfile *AzureOperatorNexusArmTemplateArtifactProfile

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// Deploy mapping rule profile.
	DeployParametersMappingRuleProfile *AzureOperatorNexusArmTemplateDeployMappingRuleProfile

	// The name of the network function application.
	Name *string
}

// GetAzureOperatorNexusNetworkFunctionApplication implements the AzureOperatorNexusNetworkFunctionApplicationClassification
// interface for type AzureOperatorNexusNetworkFunctionArmTemplateApplication.
func (a *AzureOperatorNexusNetworkFunctionArmTemplateApplication) GetAzureOperatorNexusNetworkFunctionApplication() *AzureOperatorNexusNetworkFunctionApplication {
	return &AzureOperatorNexusNetworkFunctionApplication{
		ArtifactType:     a.ArtifactType,
		DependsOnProfile: a.DependsOnProfile,
		Name:             a.Name,
	}
}

// AzureOperatorNexusNetworkFunctionImageApplication - Azure Operator Distributed Services network function image application
// definition.
type AzureOperatorNexusNetworkFunctionImageApplication struct {
	// REQUIRED; The artifact type.
	ArtifactType *AzureOperatorNexusArtifactType

	// Azure Operator Distributed Services image artifact profile.
	ArtifactProfile *AzureOperatorNexusImageArtifactProfile

	// Depends on profile definition.
	DependsOnProfile *DependsOnProfile

	// Deploy mapping rule profile.
	DeployParametersMappingRuleProfile *AzureOperatorNexusImageDeployMappingRuleProfile

	// The name of the network function application.
	Name *string
}

// GetAzureOperatorNexusNetworkFunctionApplication implements the AzureOperatorNexusNetworkFunctionApplicationClassification
// interface for type AzureOperatorNexusNetworkFunctionImageApplication.
func (a *AzureOperatorNexusNetworkFunctionImageApplication) GetAzureOperatorNexusNetworkFunctionApplication() *AzureOperatorNexusNetworkFunctionApplication {
	return &AzureOperatorNexusNetworkFunctionApplication{
		ArtifactType:     a.ArtifactType,
		DependsOnProfile: a.DependsOnProfile,
		Name:             a.Name,
	}
}

// AzureOperatorNexusNetworkFunctionTemplate - Azure Operator Distributed Services network function template.
type AzureOperatorNexusNetworkFunctionTemplate struct {
	// REQUIRED; The network function type.
	NfviType *VirtualNetworkFunctionNFVIType

	// Network function applications.
	NetworkFunctionApplications []AzureOperatorNexusNetworkFunctionApplicationClassification
}

// GetVirtualNetworkFunctionTemplate implements the VirtualNetworkFunctionTemplateClassification interface for type AzureOperatorNexusNetworkFunctionTemplate.
func (a *AzureOperatorNexusNetworkFunctionTemplate) GetVirtualNetworkFunctionTemplate() *VirtualNetworkFunctionTemplate {
	return &VirtualNetworkFunctionTemplate{
		NfviType: a.NfviType,
	}
}

// AzureStorageAccountContainerCredential - The azure storage account container credential definition.
type AzureStorageAccountContainerCredential struct {
	// The storage account container name
	ContainerName *string

	// The storage account container sas uri
	ContainerSasURI *string
}

// AzureStorageAccountCredential - The azure storage account credential definition.
type AzureStorageAccountCredential struct {
	// REQUIRED; The credential type.
	CredentialType *CredentialType

	// The containers that could be accessed using the current credential.
	ContainerCredentials []*AzureStorageAccountContainerCredential

	// The UTC time when credential will expire.
	Expiry *time.Time

	// The storage account Id
	StorageAccountID *string
}

// GetArtifactAccessCredential implements the ArtifactAccessCredentialClassification interface for type AzureStorageAccountCredential.
func (a *AzureStorageAccountCredential) GetArtifactAccessCredential() *ArtifactAccessCredential {
	return &ArtifactAccessCredential{
		CredentialType: a.CredentialType,
	}
}

// Component - The component sub resource.
type Component struct {
	// The component properties.
	Properties *ComponentProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ComponentListResult - Response for list component API service call.
type ComponentListResult struct {
	// A list of component resources in a networkFunction.
	Value []*Component

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ComponentProperties - The component properties of the network function.
type ComponentProperties struct {
	// READ-ONLY; The JSON-serialized deployment profile of the component resource.
	DeploymentProfile *string

	// READ-ONLY; The deployment status of the component resource.
	DeploymentStatus *DeploymentStatusProperties

	// READ-ONLY; The provisioning state of the component resource.
	ProvisioningState *ProvisioningState
}

// ConfigurationGroupSchema - Configuration group schema resource.
type ConfigurationGroupSchema struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Configuration group schema properties.
	Properties *ConfigurationGroupSchemaPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConfigurationGroupSchemaListResult - A list of configuration group schema resources.
type ConfigurationGroupSchemaListResult struct {
	// A list of configuration group schema.
	Value []*ConfigurationGroupSchema

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ConfigurationGroupSchemaPropertiesFormat - Configuration group schema properties.
type ConfigurationGroupSchemaPropertiesFormat struct {
	// Description of what schema can contain.
	Description *string

	// Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
	SchemaDefinition *string

	// READ-ONLY; The provisioning state of the Configuration group schema resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The configuration group schema version state.
	VersionState *VersionState
}

// ConfigurationGroupSchemaVersionUpdateState - Publisher configuration group schema update request definition.
type ConfigurationGroupSchemaVersionUpdateState struct {
	// The configuration group schema state.
	VersionState *VersionState
}

// ConfigurationGroupValue - Hybrid configuration group value resource.
type ConfigurationGroupValue struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Hybrid configuration group value properties.
	Properties ConfigurationGroupValuePropertiesFormatClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ConfigurationGroupValueListResult - Response for hybrid configurationGroups API service call.
type ConfigurationGroupValueListResult struct {
	// A list of hybrid configurationGroups.
	Value []*ConfigurationGroupValue

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// ConfigurationGroupValuePropertiesFormat - Hybrid configuration group value properties.
type ConfigurationGroupValuePropertiesFormat struct {
	// REQUIRED; The value which indicates if configuration values are secrets
	ConfigurationType *ConfigurationGroupValueConfigurationType

	// The configuration group schema resource reference.
	ConfigurationGroupSchemaResourceReference DeploymentResourceIDReferenceClassification

	// READ-ONLY; The configuration group schema name.
	ConfigurationGroupSchemaName *string

	// READ-ONLY; The location of the configuration group schema offering.
	ConfigurationGroupSchemaOfferingLocation *string

	// READ-ONLY; The provisioning state of the site resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the configuration group schema.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// GetConfigurationGroupValuePropertiesFormat implements the ConfigurationGroupValuePropertiesFormatClassification interface
// for type ConfigurationGroupValuePropertiesFormat.
func (c *ConfigurationGroupValuePropertiesFormat) GetConfigurationGroupValuePropertiesFormat() *ConfigurationGroupValuePropertiesFormat {
	return c
}

// ConfigurationValueWithSecrets - The ConfigurationValue with secrets.
type ConfigurationValueWithSecrets struct {
	// REQUIRED; The value which indicates if configuration values are secrets
	ConfigurationType *ConfigurationGroupValueConfigurationType

	// The configuration group schema resource reference.
	ConfigurationGroupSchemaResourceReference DeploymentResourceIDReferenceClassification

	// Name and value pairs that define the configuration value secrets. It can be a well formed escaped JSON string.
	SecretConfigurationValue *string

	// READ-ONLY; The configuration group schema name.
	ConfigurationGroupSchemaName *string

	// READ-ONLY; The location of the configuration group schema offering.
	ConfigurationGroupSchemaOfferingLocation *string

	// READ-ONLY; The provisioning state of the site resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the configuration group schema.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// GetConfigurationGroupValuePropertiesFormat implements the ConfigurationGroupValuePropertiesFormatClassification interface
// for type ConfigurationValueWithSecrets.
func (c *ConfigurationValueWithSecrets) GetConfigurationGroupValuePropertiesFormat() *ConfigurationGroupValuePropertiesFormat {
	return &ConfigurationGroupValuePropertiesFormat{
		ConfigurationGroupSchemaName:              c.ConfigurationGroupSchemaName,
		ConfigurationGroupSchemaOfferingLocation:  c.ConfigurationGroupSchemaOfferingLocation,
		ConfigurationGroupSchemaResourceReference: c.ConfigurationGroupSchemaResourceReference,
		ConfigurationType:                         c.ConfigurationType,
		ProvisioningState:                         c.ProvisioningState,
		PublisherName:                             c.PublisherName,
		PublisherScope:                            c.PublisherScope,
	}
}

// ConfigurationValueWithoutSecrets - The ConfigurationValue with no secrets.
type ConfigurationValueWithoutSecrets struct {
	// REQUIRED; The value which indicates if configuration values are secrets
	ConfigurationType *ConfigurationGroupValueConfigurationType

	// The configuration group schema resource reference.
	ConfigurationGroupSchemaResourceReference DeploymentResourceIDReferenceClassification

	// Name and value pairs that define the configuration value. It can be a well formed escaped JSON string.
	ConfigurationValue *string

	// READ-ONLY; The configuration group schema name.
	ConfigurationGroupSchemaName *string

	// READ-ONLY; The location of the configuration group schema offering.
	ConfigurationGroupSchemaOfferingLocation *string

	// READ-ONLY; The provisioning state of the site resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the configuration group schema.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// GetConfigurationGroupValuePropertiesFormat implements the ConfigurationGroupValuePropertiesFormatClassification interface
// for type ConfigurationValueWithoutSecrets.
func (c *ConfigurationValueWithoutSecrets) GetConfigurationGroupValuePropertiesFormat() *ConfigurationGroupValuePropertiesFormat {
	return &ConfigurationGroupValuePropertiesFormat{
		ConfigurationGroupSchemaName:              c.ConfigurationGroupSchemaName,
		ConfigurationGroupSchemaOfferingLocation:  c.ConfigurationGroupSchemaOfferingLocation,
		ConfigurationGroupSchemaResourceReference: c.ConfigurationGroupSchemaResourceReference,
		ConfigurationType:                         c.ConfigurationType,
		ProvisioningState:                         c.ProvisioningState,
		PublisherName:                             c.PublisherName,
		PublisherScope:                            c.PublisherScope,
	}
}

// ContainerizedNetworkFunctionDefinitionVersion - Containerized network function network function definition version properties.
type ContainerizedNetworkFunctionDefinitionVersion struct {
	// REQUIRED; The network function type.
	NetworkFunctionType *NetworkFunctionType

	// The deployment parameters of the network function definition version.
	DeployParameters *string

	// The network function definition version description.
	Description *string

	// Containerized network function template.
	NetworkFunctionTemplate ContainerizedNetworkFunctionTemplateClassification

	// READ-ONLY; The provisioning state of the network function definition version resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The network function definition version state.
	VersionState *VersionState
}

// GetNetworkFunctionDefinitionVersionPropertiesFormat implements the NetworkFunctionDefinitionVersionPropertiesFormatClassification
// interface for type ContainerizedNetworkFunctionDefinitionVersion.
func (c *ContainerizedNetworkFunctionDefinitionVersion) GetNetworkFunctionDefinitionVersionPropertiesFormat() *NetworkFunctionDefinitionVersionPropertiesFormat {
	return &NetworkFunctionDefinitionVersionPropertiesFormat{
		DeployParameters:    c.DeployParameters,
		Description:         c.Description,
		NetworkFunctionType: c.NetworkFunctionType,
		ProvisioningState:   c.ProvisioningState,
		VersionState:        c.VersionState,
	}
}

// ContainerizedNetworkFunctionTemplate - Containerized network function template.
type ContainerizedNetworkFunctionTemplate struct {
	// REQUIRED; The network function type.
	NfviType *ContainerizedNetworkFunctionNFVIType
}

// GetContainerizedNetworkFunctionTemplate implements the ContainerizedNetworkFunctionTemplateClassification interface for
// type ContainerizedNetworkFunctionTemplate.
func (c *ContainerizedNetworkFunctionTemplate) GetContainerizedNetworkFunctionTemplate() *ContainerizedNetworkFunctionTemplate {
	return c
}

// DaemonSet - Helm DaemonSet status properties.
type DaemonSet struct {
	// Number of available pods.
	Available *int32

	// Creation Time of daemonSet.
	CreationTime *time.Time

	// Current number of pods
	Current *int32

	// Desired number of pods
	Desired *int32

	// The name of the daemonSet.
	Name *string

	// The namespace of the daemonSet.
	Namespace *string

	// Number of Ready pods
	Ready *int32

	// Number of upto date pods
	UpToDate *int32
}

// DependsOnProfile - Depends on profile definition.
type DependsOnProfile struct {
	// Application installation operation dependency.
	InstallDependsOn []*string

	// Application deletion operation dependency.
	UninstallDependsOn []*string

	// Application update operation dependency.
	UpdateDependsOn []*string
}

// Deployment - Helm Deployment status properties.
type Deployment struct {
	// Number of available pods.
	Available *int32

	// Creation Time of deployment.
	CreationTime *time.Time

	// Desired number of pods
	Desired *int32

	// The name of the deployment.
	Name *string

	// The namespace of the deployment.
	Namespace *string

	// Number of ready pods.
	Ready *int32

	// Number of upto date pods.
	UpToDate *int32
}

// DeploymentResourceIDReference - The azure resource reference which is used for deployment.
type DeploymentResourceIDReference struct {
	// REQUIRED; The resource reference arm id type.
	IDType *IDType
}

// GetDeploymentResourceIDReference implements the DeploymentResourceIDReferenceClassification interface for type DeploymentResourceIDReference.
func (d *DeploymentResourceIDReference) GetDeploymentResourceIDReference() *DeploymentResourceIDReference {
	return d
}

// DeploymentStatusProperties - The deployment status properties of the network function component.
type DeploymentStatusProperties struct {
	// The next expected update of deployment status.
	NextExpectedUpdateAt *time.Time

	// The resource related to the component resource.
	Resources *Resources

	// The status of the component resource.
	Status *Status
}

// ExecuteRequestParameters - Payload for execute request post call.
type ExecuteRequestParameters struct {
	// REQUIRED; The request metadata.
	RequestMetadata *RequestMetadata

	// REQUIRED; The endpoint of service to call.
	ServiceEndpoint *string
}

// HelmArtifactProfile - Helm artifact profile.
type HelmArtifactProfile struct {
	// Helm package name.
	HelmPackageName *string

	// Helm package version range.
	HelmPackageVersionRange *string

	// The image pull secrets values path list.
	ImagePullSecretsValuesPaths []*string

	// The registry values path list.
	RegistryValuesPaths []*string
}

// HelmInstallOptions - The helm deployment install options
type HelmInstallOptions struct {
	// The helm deployment atomic options
	Atomic *string

	// The helm deployment timeout options
	Timeout *string

	// The helm deployment wait options
	Wait *string
}

// HelmMappingRuleProfile - Helm mapping rule profile
type HelmMappingRuleProfile struct {
	// Helm package version.
	HelmPackageVersion *string

	// The helm deployment options
	Options *HelmMappingRuleProfileOptions

	// Helm release name.
	ReleaseName *string

	// Helm release namespace.
	ReleaseNamespace *string

	// Helm release values.
	Values *string
}

// HelmMappingRuleProfileOptions - The helm deployment options
type HelmMappingRuleProfileOptions struct {
	// The helm deployment install options
	InstallOptions *HelmInstallOptions

	// The helm deployment upgrade options
	UpgradeOptions *HelmUpgradeOptions
}

// HelmUpgradeOptions - The helm deployment install options
type HelmUpgradeOptions struct {
	// The helm deployment atomic options
	Atomic *string

	// The helm deployment timeout options
	Timeout *string

	// The helm deployment wait options
	Wait *string
}

// ImageArtifactProfile - Image artifact profile.
type ImageArtifactProfile struct {
	// Image name.
	ImageName *string

	// Image version.
	ImageVersion *string
}

// ImageMappingRuleProfile - Image mapping rule profile
type ImageMappingRuleProfile struct {
	// List of values.
	UserConfiguration *string
}

// ManagedResourceGroupConfiguration - Managed resource group configuration.
type ManagedResourceGroupConfiguration struct {
	// Managed resource group location.
	Location *string

	// Managed resource group name.
	Name *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// ManifestArtifactFormat - Manifest artifact properties.
type ManifestArtifactFormat struct {
	// The artifact name
	ArtifactName *string

	// The artifact type.
	ArtifactType *ArtifactType

	// The artifact version.
	ArtifactVersion *string
}

// NFVIs - The NFVI object.
type NFVIs struct {
	// REQUIRED; The NFVI type.
	NfviType *NFVIType

	// Name of the nfvi.
	Name *string
}

// GetNFVIs implements the NFVIsClassification interface for type NFVIs.
func (n *NFVIs) GetNFVIs() *NFVIs { return n }

// NSDArtifactProfile - Artifact profile properties.
type NSDArtifactProfile struct {
	// Artifact name.
	ArtifactName *string

	// The artifact store resource id
	ArtifactStoreReference *ReferencedResource

	// Artifact version.
	ArtifactVersion *string
}

// NetworkFunction - Network function resource response.
type NetworkFunction struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// The managed identity of the network function.
	Identity *ManagedServiceIdentity

	// Network function properties.
	Properties NetworkFunctionPropertiesFormatClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkFunctionDefinitionGroup - Network function definition group resource.
type NetworkFunctionDefinitionGroup struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Network function definition group properties.
	Properties *NetworkFunctionDefinitionGroupPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkFunctionDefinitionGroupListResult - A list of network function definition group resources.
type NetworkFunctionDefinitionGroupListResult struct {
	// A list of network function definition group.
	Value []*NetworkFunctionDefinitionGroup

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// NetworkFunctionDefinitionGroupPropertiesFormat - Network function definition group properties.
type NetworkFunctionDefinitionGroupPropertiesFormat struct {
	// The network function definition group description.
	Description *string

	// READ-ONLY; The provisioning state of the network function definition groups resource.
	ProvisioningState *ProvisioningState
}

// NetworkFunctionDefinitionResourceElementTemplateDetails - The network function definition resource element template details.
type NetworkFunctionDefinitionResourceElementTemplateDetails struct {
	// REQUIRED; The resource element template type.
	ResourceElementType *Type

	// The resource element template type.
	Configuration *ArmResourceDefinitionResourceElementTemplate

	// The depends on profile.
	DependsOnProfile *DependsOnProfile

	// Name of the resource element template.
	Name *string
}

// GetResourceElementTemplate implements the ResourceElementTemplateClassification interface for type NetworkFunctionDefinitionResourceElementTemplateDetails.
func (n *NetworkFunctionDefinitionResourceElementTemplateDetails) GetResourceElementTemplate() *ResourceElementTemplate {
	return &ResourceElementTemplate{
		DependsOnProfile:    n.DependsOnProfile,
		Name:                n.Name,
		ResourceElementType: n.ResourceElementType,
	}
}

// NetworkFunctionDefinitionVersion - Network function definition version.
type NetworkFunctionDefinitionVersion struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Network function definition version properties.
	Properties NetworkFunctionDefinitionVersionPropertiesFormatClassification

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkFunctionDefinitionVersionListResult - A list of network function definition versions.
type NetworkFunctionDefinitionVersionListResult struct {
	// A list of network function definition versions.
	Value []*NetworkFunctionDefinitionVersion

	// READ-ONLY; The URI to get the next set of results.
	NextLink *string
}

// NetworkFunctionDefinitionVersionPropertiesFormat - Network function definition version properties.
type NetworkFunctionDefinitionVersionPropertiesFormat struct {
	// REQUIRED; The network function type.
	NetworkFunctionType *NetworkFunctionType

	// The deployment parameters of the network function definition version.
	DeployParameters *string

	// The network function definition version description.
	Description *string

	// READ-ONLY; The provisioning state of the network function definition version resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The network function definition version state.
	VersionState *VersionState
}

// GetNetworkFunctionDefinitionVersionPropertiesFormat implements the NetworkFunctionDefinitionVersionPropertiesFormatClassification
// interface for type NetworkFunctionDefinitionVersionPropertiesFormat.
func (n *NetworkFunctionDefinitionVersionPropertiesFormat) GetNetworkFunctionDefinitionVersionPropertiesFormat() *NetworkFunctionDefinitionVersionPropertiesFormat {
	return n
}

// NetworkFunctionDefinitionVersionUpdateState - Publisher network function definition version update request definition.
type NetworkFunctionDefinitionVersionUpdateState struct {
	// The network function definition version state. Only the 'Active' and 'Deprecated' states are allowed for updates. Other
	// states are used for internal state transitioning.
	VersionState *VersionState
}

// NetworkFunctionListResult - Response for network function API service call.
type NetworkFunctionListResult struct {
	// A list of network function resources in a subscription or resource group.
	Value []*NetworkFunction

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// NetworkFunctionPropertiesFormat - Network function properties.
type NetworkFunctionPropertiesFormat struct {
	// REQUIRED; The value which indicates if NF values are secrets
	ConfigurationType *NetworkFunctionConfigurationType

	// Indicates if software updates are allowed during deployment.
	AllowSoftwareUpdate *bool

	// The network function definition version resource reference.
	NetworkFunctionDefinitionVersionResourceReference DeploymentResourceIDReferenceClassification

	// The nfviId for the network function.
	NfviID *string

	// The nfvi type for the network function.
	NfviType *NFVIType

	// The role configuration override values from the user.
	RoleOverrideValues []*string

	// READ-ONLY; The network function definition group name for the network function.
	NetworkFunctionDefinitionGroupName *string

	// READ-ONLY; The location of the network function definition offering.
	NetworkFunctionDefinitionOfferingLocation *string

	// READ-ONLY; The network function definition version for the network function.
	NetworkFunctionDefinitionVersion *string

	// READ-ONLY; The provisioning state of the network function resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the network function.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// GetNetworkFunctionPropertiesFormat implements the NetworkFunctionPropertiesFormatClassification interface for type NetworkFunctionPropertiesFormat.
func (n *NetworkFunctionPropertiesFormat) GetNetworkFunctionPropertiesFormat() *NetworkFunctionPropertiesFormat {
	return n
}

// NetworkFunctionValueWithSecrets - NetworkFunction with secrets.
type NetworkFunctionValueWithSecrets struct {
	// REQUIRED; The value which indicates if NF values are secrets
	ConfigurationType *NetworkFunctionConfigurationType

	// Indicates if software updates are allowed during deployment.
	AllowSoftwareUpdate *bool

	// The network function definition version resource reference.
	NetworkFunctionDefinitionVersionResourceReference DeploymentResourceIDReferenceClassification

	// The nfviId for the network function.
	NfviID *string

	// The nfvi type for the network function.
	NfviType *NFVIType

	// The role configuration override values from the user.
	RoleOverrideValues []*string

	// The JSON-serialized secret deployment values from the user. This contains secrets like passwords,keys etc
	SecretDeploymentValues *string

	// READ-ONLY; The network function definition group name for the network function.
	NetworkFunctionDefinitionGroupName *string

	// READ-ONLY; The location of the network function definition offering.
	NetworkFunctionDefinitionOfferingLocation *string

	// READ-ONLY; The network function definition version for the network function.
	NetworkFunctionDefinitionVersion *string

	// READ-ONLY; The provisioning state of the network function resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the network function.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// GetNetworkFunctionPropertiesFormat implements the NetworkFunctionPropertiesFormatClassification interface for type NetworkFunctionValueWithSecrets.
func (n *NetworkFunctionValueWithSecrets) GetNetworkFunctionPropertiesFormat() *NetworkFunctionPropertiesFormat {
	return &NetworkFunctionPropertiesFormat{
		AllowSoftwareUpdate:                               n.AllowSoftwareUpdate,
		ConfigurationType:                                 n.ConfigurationType,
		NetworkFunctionDefinitionGroupName:                n.NetworkFunctionDefinitionGroupName,
		NetworkFunctionDefinitionOfferingLocation:         n.NetworkFunctionDefinitionOfferingLocation,
		NetworkFunctionDefinitionVersion:                  n.NetworkFunctionDefinitionVersion,
		NetworkFunctionDefinitionVersionResourceReference: n.NetworkFunctionDefinitionVersionResourceReference,
		NfviID:             n.NfviID,
		NfviType:           n.NfviType,
		ProvisioningState:  n.ProvisioningState,
		PublisherName:      n.PublisherName,
		PublisherScope:     n.PublisherScope,
		RoleOverrideValues: n.RoleOverrideValues,
	}
}

// NetworkFunctionValueWithoutSecrets - NetworkFunction with no secrets.
type NetworkFunctionValueWithoutSecrets struct {
	// REQUIRED; The value which indicates if NF values are secrets
	ConfigurationType *NetworkFunctionConfigurationType

	// Indicates if software updates are allowed during deployment.
	AllowSoftwareUpdate *bool

	// The JSON-serialized deployment values from the user.
	DeploymentValues *string

	// The network function definition version resource reference.
	NetworkFunctionDefinitionVersionResourceReference DeploymentResourceIDReferenceClassification

	// The nfviId for the network function.
	NfviID *string

	// The nfvi type for the network function.
	NfviType *NFVIType

	// The role configuration override values from the user.
	RoleOverrideValues []*string

	// READ-ONLY; The network function definition group name for the network function.
	NetworkFunctionDefinitionGroupName *string

	// READ-ONLY; The location of the network function definition offering.
	NetworkFunctionDefinitionOfferingLocation *string

	// READ-ONLY; The network function definition version for the network function.
	NetworkFunctionDefinitionVersion *string

	// READ-ONLY; The provisioning state of the network function resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the network function.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// GetNetworkFunctionPropertiesFormat implements the NetworkFunctionPropertiesFormatClassification interface for type NetworkFunctionValueWithoutSecrets.
func (n *NetworkFunctionValueWithoutSecrets) GetNetworkFunctionPropertiesFormat() *NetworkFunctionPropertiesFormat {
	return &NetworkFunctionPropertiesFormat{
		AllowSoftwareUpdate:                               n.AllowSoftwareUpdate,
		ConfigurationType:                                 n.ConfigurationType,
		NetworkFunctionDefinitionGroupName:                n.NetworkFunctionDefinitionGroupName,
		NetworkFunctionDefinitionOfferingLocation:         n.NetworkFunctionDefinitionOfferingLocation,
		NetworkFunctionDefinitionVersion:                  n.NetworkFunctionDefinitionVersion,
		NetworkFunctionDefinitionVersionResourceReference: n.NetworkFunctionDefinitionVersionResourceReference,
		NfviID:             n.NfviID,
		NfviType:           n.NfviType,
		ProvisioningState:  n.ProvisioningState,
		PublisherName:      n.PublisherName,
		PublisherScope:     n.PublisherScope,
		RoleOverrideValues: n.RoleOverrideValues,
	}
}

// NetworkServiceDesignGroup - network service design group resource.
type NetworkServiceDesignGroup struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// network service design group properties.
	Properties *NetworkServiceDesignGroupPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkServiceDesignGroupListResult - A list of network service design group resources.
type NetworkServiceDesignGroupListResult struct {
	// A list of network service design group.
	Value []*NetworkServiceDesignGroup

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// NetworkServiceDesignGroupPropertiesFormat - network service design group properties.
type NetworkServiceDesignGroupPropertiesFormat struct {
	// The network service design group description.
	Description *string

	// READ-ONLY; The provisioning state of the network service design groups resource.
	ProvisioningState *ProvisioningState
}

// NetworkServiceDesignVersion - network service design version.
type NetworkServiceDesignVersion struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// network service design version properties.
	Properties *NetworkServiceDesignVersionPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// NetworkServiceDesignVersionListResult - A list of network service design versions.
type NetworkServiceDesignVersionListResult struct {
	// A list of network service design versions.
	Value []*NetworkServiceDesignVersion

	// READ-ONLY; The URI to get the next set of results.
	NextLink *string
}

// NetworkServiceDesignVersionPropertiesFormat - network service design version properties.
type NetworkServiceDesignVersionPropertiesFormat struct {
	// The configuration schemas to used to define the values.
	ConfigurationGroupSchemaReferences map[string]*ReferencedResource

	// The network service design version description.
	Description *string

	// The nfvis from the site.
	NfvisFromSite map[string]*NfviDetails

	// List of resource element template
	ResourceElementTemplates []ResourceElementTemplateClassification

	// READ-ONLY; The provisioning state of the network service design version resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The network service design version state.
	VersionState *VersionState
}

// NetworkServiceDesignVersionUpdateState - Publisher network service design version update request definition.
type NetworkServiceDesignVersionUpdateState struct {
	// The network service design version state.
	VersionState *VersionState
}

// NfviDetails - The nfvi details.
type NfviDetails struct {
	// The nfvi name.
	Name *string

	// The nfvi type.
	Type *string
}

// OpenDeploymentResourceReference - Non secret deployment resource id reference.
type OpenDeploymentResourceReference struct {
	// REQUIRED; The resource reference arm id type.
	IDType *IDType

	// Resource ID.
	ID *string
}

// GetDeploymentResourceIDReference implements the DeploymentResourceIDReferenceClassification interface for type OpenDeploymentResourceReference.
func (o *OpenDeploymentResourceReference) GetDeploymentResourceIDReference() *DeploymentResourceIDReference {
	return &DeploymentResourceIDReference{
		IDType: o.IDType,
	}
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// Pod - Helm Pod status properties.
type Pod struct {
	// Creation Time of Pod.
	CreationTime *time.Time

	// Desired number of containers
	Desired *int32

	// Last 5 Pod events.
	Events []*PodEvent

	// The name of the Pod.
	Name *string

	// The namespace of the Pod.
	Namespace *string

	// Number of ready containers.
	Ready *int32

	// The status of a pod.
	Status *PodStatus
}

// PodEvent - Pod Event properties.
type PodEvent struct {
	// Event Last seen.
	LastSeenTime *time.Time

	// Event message.
	Message *string

	// Event reason.
	Reason *string

	// The type of pod event.
	Type *PodEventType
}

// ProxyArtifactListOverview - The proxy artifact overview.
type ProxyArtifactListOverview struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProxyArtifactOverviewListResult - The proxy artifact list result.
type ProxyArtifactOverviewListResult struct {
	// A list of available proxy artifacts.
	Value []*ProxyArtifactListOverview

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

type ProxyArtifactOverviewPropertiesValue struct {
	// The artifact state
	ArtifactState *ArtifactState

	// The artifact type.
	ArtifactType *ArtifactType

	// The artifact version.
	ArtifactVersion *string
}

// ProxyArtifactVersionsListOverview - The proxy artifact overview.
type ProxyArtifactVersionsListOverview struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Proxy Artifact overview properties.
	Properties *ProxyArtifactOverviewPropertiesValue

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ProxyArtifactVersionsOverviewListResult - The proxy artifact list result.
type ProxyArtifactVersionsOverviewListResult struct {
	// A list of available proxy artifacts.
	Value []*ProxyArtifactVersionsListOverview

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// Publisher - publisher resource.
type Publisher struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The managed identity of the publisher, if configured.
	Identity *ManagedServiceIdentity

	// Publisher properties.
	Properties *PublisherPropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PublisherListResult - A list of publishers.
type PublisherListResult struct {
	// A list of publishers.
	Value []*Publisher

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PublisherPropertiesFormat - publisher properties.
type PublisherPropertiesFormat struct {
	// The publisher scope.
	Scope *PublisherScope

	// READ-ONLY; The provisioning state of the publisher resource.
	ProvisioningState *ProvisioningState
}

// ReferencedResource - Reference to another resource.
type ReferencedResource struct {
	// Resource ID.
	ID *string
}

// ReplicaSet - Helm ReplicaSet status properties.
type ReplicaSet struct {
	// Creation Time of replicaSet.
	CreationTime *time.Time

	// Number of current pods.
	Current *int32

	// Desired number of pods
	Desired *int32

	// The name of the replicaSet.
	Name *string

	// The namespace of the replicaSet.
	Namespace *string

	// Number of ready pods.
	Ready *int32
}

// RequestMetadata - Request metadata of execute request post call payload.
type RequestMetadata struct {
	// REQUIRED; The http method of the request.
	HTTPMethod *HTTPMethod

	// REQUIRED; The relative path of the request.
	RelativePath *string

	// REQUIRED; The serialized body of the request.
	SerializedBody *string

	// The api version of the request.
	APIVersion *string
}

// ResourceElementTemplate - The resource element template object.
type ResourceElementTemplate struct {
	// REQUIRED; The resource element template type.
	ResourceElementType *Type

	// The depends on profile.
	DependsOnProfile *DependsOnProfile

	// Name of the resource element template.
	Name *string
}

// GetResourceElementTemplate implements the ResourceElementTemplateClassification interface for type ResourceElementTemplate.
func (r *ResourceElementTemplate) GetResourceElementTemplate() *ResourceElementTemplate { return r }

// Resources - The resources of the network function component.
type Resources struct {
	// Daemonsets related to component resource.
	DaemonSets []*DaemonSet

	// Deployments that are related to component resource.
	Deployments []*Deployment

	// Pods related to component resource.
	Pods []*Pod

	// Replica sets related to component resource.
	ReplicaSets []*ReplicaSet

	// Stateful sets related to component resource.
	StatefulSets []*StatefulSet
}

// SKU - Sku, to be associated with a SiteNetworkService.
type SKU struct {
	// REQUIRED; Name of this Sku
	Name *SKUName

	// READ-ONLY; The SKU tier based on the SKU name.
	Tier *SKUTier
}

// SecretDeploymentResourceReference - Secret deployment resource id reference.
type SecretDeploymentResourceReference struct {
	// REQUIRED; The resource reference arm id type.
	IDType *IDType

	// Resource ID.
	ID *string
}

// GetDeploymentResourceIDReference implements the DeploymentResourceIDReferenceClassification interface for type SecretDeploymentResourceReference.
func (s *SecretDeploymentResourceReference) GetDeploymentResourceIDReference() *DeploymentResourceIDReference {
	return &DeploymentResourceIDReference{
		IDType: s.IDType,
	}
}

// Site resource.
type Site struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Site properties.
	Properties *SitePropertiesFormat

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SiteListResult - Response for sites API service call.
type SiteListResult struct {
	// A list of sites in a resource group.
	Value []*Site

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SiteNetworkService - Site network service resource.
type SiteNetworkService struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The managed identity of the Site network service, if configured.
	Identity *ManagedServiceIdentity

	// Site network service properties.
	Properties *SiteNetworkServicePropertiesFormat

	// Sku of the site network service.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SiteNetworkServiceListResult - Response for site network services API service call.
type SiteNetworkServiceListResult struct {
	// A list of site network services in a resource group.
	Value []*SiteNetworkService

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// SiteNetworkServicePropertiesFormat - Site network service properties.
type SiteNetworkServicePropertiesFormat struct {
	// The goal state of the site network service resource. This has references to the configuration group value objects that
	// describe the desired state of the site network service.
	DesiredStateConfigurationGroupValueReferences map[string]*ReferencedResource

	// Managed resource group configuration.
	ManagedResourceGroupConfiguration *ManagedResourceGroupConfiguration

	// The network service design version resource reference.
	NetworkServiceDesignVersionResourceReference DeploymentResourceIDReferenceClassification

	// The site details
	SiteReference *ReferencedResource

	// READ-ONLY; The last state of the site network service resource.
	LastStateConfigurationGroupValueReferences map[string]*ReferencedResource

	// READ-ONLY; The network service design version for the site network service.
	LastStateNetworkServiceDesignVersionName *string

	// READ-ONLY; The network service design group name for the site network service.
	NetworkServiceDesignGroupName *string

	// READ-ONLY; The network service design version for the site network service.
	NetworkServiceDesignVersionName *string

	// READ-ONLY; The location of the network service design offering.
	NetworkServiceDesignVersionOfferingLocation *string

	// READ-ONLY; The provisioning state of the site network service resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The publisher name for the site network service.
	PublisherName *string

	// READ-ONLY; The scope of the publisher.
	PublisherScope *PublisherScope
}

// SitePropertiesFormat - Site properties.
type SitePropertiesFormat struct {
	// List of NFVIs
	Nfvis []NFVIsClassification

	// READ-ONLY; The provisioning state of the site resource. TODO: Confirm if this is needed.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The list of site network services on the site.
	SiteNetworkServiceReferences []*ReferencedResource
}

// StatefulSet - Helm StatefulSet status properties.
type StatefulSet struct {
	// Creation Time of statefulset.
	CreationTime *time.Time

	// Desired number of pods
	Desired *int32

	// The name of the statefulset.
	Name *string

	// The namespace of the statefulset.
	Namespace *string

	// Number of ready pods.
	Ready *int32
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TagsObject - Tags object for patch operations.
type TagsObject struct {
	// Resource tags.
	Tags map[string]*string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// VhdImageArtifactProfile - Vhd artifact profile.
type VhdImageArtifactProfile struct {
	// Vhd name.
	VhdName *string

	// Vhd version.
	VhdVersion *string
}

// VhdImageMappingRuleProfile - Vhd mapping rule profile
type VhdImageMappingRuleProfile struct {
	// List of values.
	UserConfiguration *string
}

// VirtualNetworkFunctionDefinitionVersion - Virtual network function network function definition version properties.
type VirtualNetworkFunctionDefinitionVersion struct {
	// REQUIRED; The network function type.
	NetworkFunctionType *NetworkFunctionType

	// The deployment parameters of the network function definition version.
	DeployParameters *string

	// The network function definition version description.
	Description *string

	// Virtual network function template.
	NetworkFunctionTemplate VirtualNetworkFunctionTemplateClassification

	// READ-ONLY; The provisioning state of the network function definition version resource.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The network function definition version state.
	VersionState *VersionState
}

// GetNetworkFunctionDefinitionVersionPropertiesFormat implements the NetworkFunctionDefinitionVersionPropertiesFormatClassification
// interface for type VirtualNetworkFunctionDefinitionVersion.
func (v *VirtualNetworkFunctionDefinitionVersion) GetNetworkFunctionDefinitionVersionPropertiesFormat() *NetworkFunctionDefinitionVersionPropertiesFormat {
	return &NetworkFunctionDefinitionVersionPropertiesFormat{
		DeployParameters:    v.DeployParameters,
		Description:         v.Description,
		NetworkFunctionType: v.NetworkFunctionType,
		ProvisioningState:   v.ProvisioningState,
		VersionState:        v.VersionState,
	}
}

// VirtualNetworkFunctionTemplate - Virtual network function template.
type VirtualNetworkFunctionTemplate struct {
	// REQUIRED; The network function type.
	NfviType *VirtualNetworkFunctionNFVIType
}

// GetVirtualNetworkFunctionTemplate implements the VirtualNetworkFunctionTemplateClassification interface for type VirtualNetworkFunctionTemplate.
func (v *VirtualNetworkFunctionTemplate) GetVirtualNetworkFunctionTemplate() *VirtualNetworkFunctionTemplate {
	return v
}
