//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/kusto/armkusto/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseServer is a fake server for instances of the armkusto.DatabaseClient type.
type DatabaseServer struct {
	// InviteFollower is the fake for method DatabaseClient.InviteFollower
	// HTTP status codes to indicate success: http.StatusOK
	InviteFollower func(ctx context.Context, resourceGroupName string, clusterName string, databaseName string, parameters armkusto.DatabaseInviteFollowerRequest, options *armkusto.DatabaseClientInviteFollowerOptions) (resp azfake.Responder[armkusto.DatabaseClientInviteFollowerResponse], errResp azfake.ErrorResponder)
}

// NewDatabaseServerTransport creates a new instance of DatabaseServerTransport with the provided implementation.
// The returned DatabaseServerTransport instance is connected to an instance of armkusto.DatabaseClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseServerTransport(srv *DatabaseServer) *DatabaseServerTransport {
	return &DatabaseServerTransport{srv: srv}
}

// DatabaseServerTransport connects instances of armkusto.DatabaseClient to instances of DatabaseServer.
// Don't use this type directly, use NewDatabaseServerTransport instead.
type DatabaseServerTransport struct {
	srv *DatabaseServer
}

// Do implements the policy.Transporter interface for DatabaseServerTransport.
func (d *DatabaseServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseClient.InviteFollower":
		resp, err = d.dispatchInviteFollower(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseServerTransport) dispatchInviteFollower(req *http.Request) (*http.Response, error) {
	if d.srv.InviteFollower == nil {
		return nil, &nonRetriableError{errors.New("fake for method InviteFollower not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Kusto/clusters/(?P<clusterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inviteFollower`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armkusto.DatabaseInviteFollowerRequest](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	clusterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("clusterName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.InviteFollower(req.Context(), resourceGroupNameParam, clusterNameParam, databaseNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseInviteFollowerResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
