//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armm365securityandcompliance

import "time"

// ErrorDetails - Error details.
type ErrorDetails struct {
	// Object containing error details.
	Error *ErrorDetailsInternal
}

// ErrorDetailsInternal - Error details.
type ErrorDetailsInternal struct {
	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The target of the particular error.
	Target *string
}

// Operation - Service REST API operation.
type Operation struct {
	// READ-ONLY; The information displayed about the operation.
	Display *OperationDisplay

	// READ-ONLY; Indicates whether the operation is a data action
	IsDataAction *bool

	// READ-ONLY; Operation name: {provider}/{resource}/{read | write | action | delete}
	Name *string

	// READ-ONLY; Default value is 'user,system'.
	Origin *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Friendly description for the operation,
	Description *string

	// READ-ONLY; Name of the operation
	Operation *string

	// READ-ONLY; Service provider: Microsoft.M365SecurityAndCompliance
	Provider *string

	// READ-ONLY; Resource Type: Services
	Resource *string
}

// OperationListResult - A list of service operations. It contains a list of operations and a URL link to get the next set
// of results.
type OperationListResult struct {
	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string

	// READ-ONLY; A list of service operations supported by the Microsoft.M365SecurityAndCompliance resource provider.
	Value []*Operation
}

// OperationResultsDescription - The properties indicating the operation result of an operation on a service.
type OperationResultsDescription struct {
	// Additional properties of the operation result.
	Properties any

	// READ-ONLY; The ID of the operation returned.
	ID *string

	// READ-ONLY; The name of the operation result.
	Name *string

	// READ-ONLY; The time that the operation was started.
	StartTime *string

	// READ-ONLY; The status of the operation being performed.
	Status *OperationResultStatus
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource

	// READ-ONLY; The URL to get the next set of results.
	NextLink *string
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// PrivateLinkServicesForEDMUploadDescription - The description of the service.
type PrivateLinkServicesForEDMUploadDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The common properties of a service.
	Properties *ServicesProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServicesForEDMUploadDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForEDMUploadDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForEDMUploadDescription

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string
}

// PrivateLinkServicesForM365ComplianceCenterDescription - The description of the service.
type PrivateLinkServicesForM365ComplianceCenterDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The common properties of a service.
	Properties *ServicesProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServicesForM365ComplianceCenterDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForM365ComplianceCenterDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForM365ComplianceCenterDescription

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string
}

// PrivateLinkServicesForM365SecurityCenterDescription - The description of the service.
type PrivateLinkServicesForM365SecurityCenterDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The common properties of a service.
	Properties *ServicesProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServicesForM365SecurityCenterDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForM365SecurityCenterDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForM365SecurityCenterDescription

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string
}

// PrivateLinkServicesForMIPPolicySyncDescription - The description of the service.
type PrivateLinkServicesForMIPPolicySyncDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The common properties of a service.
	Properties *ServicesProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServicesForMIPPolicySyncDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForMIPPolicySyncDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForMIPPolicySyncDescription

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string
}

// PrivateLinkServicesForO365ManagementActivityAPIDescription - The description of the service.
type PrivateLinkServicesForO365ManagementActivityAPIDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The common properties of a service.
	Properties *ServicesProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServicesForO365ManagementActivityAPIDescriptionListResult - A list of service description objects with a next
// link.
type PrivateLinkServicesForO365ManagementActivityAPIDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForO365ManagementActivityAPIDescription

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string
}

// PrivateLinkServicesForSCCPowershellDescription - The description of the service.
type PrivateLinkServicesForSCCPowershellDescription struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The common properties of a service.
	Properties *ServicesProperties

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// PrivateLinkServicesForSCCPowershellDescriptionListResult - A list of service description objects with a next link.
type PrivateLinkServicesForSCCPowershellDescriptionListResult struct {
	// A list of service description objects.
	Value []*PrivateLinkServicesForSCCPowershellDescription

	// READ-ONLY; The link used to get the next page of service description objects.
	NextLink *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ServiceAccessPolicyEntry - An access policy entry.
type ServiceAccessPolicyEntry struct {
	// REQUIRED; An Azure AD object ID (User or Apps) that is allowed access to the FHIR service.
	ObjectID *string
}

// ServiceAuthenticationConfigurationInfo - Authentication configuration information
type ServiceAuthenticationConfigurationInfo struct {
	// The audience url for the service
	Audience *string

	// The authority url for the service
	Authority *string

	// If the SMART on FHIR proxy is enabled
	SmartProxyEnabled *bool
}

// ServiceCorsConfigurationInfo - The settings for the CORS configuration of the service instance.
type ServiceCorsConfigurationInfo struct {
	// If credentials are allowed via CORS.
	AllowCredentials *bool

	// The headers to be allowed via CORS.
	Headers []*string

	// The max age to be allowed via CORS.
	MaxAge *int64

	// The methods to be allowed via CORS.
	Methods []*string

	// The origins to be allowed via CORS.
	Origins []*string
}

// ServiceCosmosDbConfigurationInfo - The settings for the Cosmos DB database backing the service.
type ServiceCosmosDbConfigurationInfo struct {
	// The URI of the customer-managed key for the backing database.
	KeyVaultKeyURI *string

	// The provisioned throughput for the backing database.
	OfferThroughput *int64
}

// ServiceExportConfigurationInfo - Export operation configuration information
type ServiceExportConfigurationInfo struct {
	// The name of the default export storage account.
	StorageAccountName *string
}

// ServicesPatchDescription - The description of the service.
type ServicesPatchDescription struct {
	// The properties for updating a service instance.
	Properties *ServicesPropertiesUpdateParameters

	// Instance tags
	Tags map[string]*string
}

// ServicesProperties - The properties of a service instance.
type ServicesProperties struct {
	// The access policies of the service instance.
	AccessPolicies []*ServiceAccessPolicyEntry

	// The authentication configuration for the service instance.
	AuthenticationConfiguration *ServiceAuthenticationConfigurationInfo

	// The settings for the CORS configuration of the service instance.
	CorsConfiguration *ServiceCorsConfigurationInfo

	// The settings for the Cosmos DB database backing the service.
	CosmosDbConfiguration *ServiceCosmosDbConfigurationInfo

	// The settings for the export operation of the service instance.
	ExportConfiguration *ServiceExportConfigurationInfo

	// The list of private endpoint connections that are set up for this resource.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess

	// READ-ONLY; The provisioning state.
	ProvisioningState *ProvisioningState
}

// ServicesPropertiesUpdateParameters - The properties for updating a service instance.
type ServicesPropertiesUpdateParameters struct {
	// Control permission for data plane traffic coming from public networks while private endpoint is enabled.
	PublicNetworkAccess *PublicNetworkAccess
}

// ServicesResource - The common properties of a service.
type ServicesResource struct {
	// REQUIRED; The kind of the service.
	Kind *Kind

	// REQUIRED; The resource location.
	Location *string

	// An etag associated with the resource, used for optimistic concurrency when editing it.
	Etag *string

	// Setting indicating whether the service has a managed identity associated with it.
	Identity *ServicesResourceIdentity

	// The resource tags.
	Tags map[string]*string

	// READ-ONLY; The resource identifier.
	ID *string

	// READ-ONLY; The resource name.
	Name *string

	// READ-ONLY; Required property for system data
	SystemData *SystemData

	// READ-ONLY; The resource type.
	Type *string
}

// ServicesResourceIdentity - Setting indicating whether the service has a managed identity associated with it.
type ServicesResourceIdentity struct {
	// Type of identity being specified, currently SystemAssigned and None are allowed.
	Type *ManagedServiceIdentityType

	// READ-ONLY; The principal ID of the resource identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the resource.
	TenantID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}
