//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armmachinelearning.ClientFactory type.
type ServerFactory struct {
	BatchDeploymentsServer           BatchDeploymentsServer
	BatchEndpointsServer             BatchEndpointsServer
	CodeContainersServer             CodeContainersServer
	CodeVersionsServer               CodeVersionsServer
	ComponentContainersServer        ComponentContainersServer
	ComponentVersionsServer          ComponentVersionsServer
	ComputeServer                    ComputeServer
	DataContainersServer             DataContainersServer
	DataVersionsServer               DataVersionsServer
	DatastoresServer                 DatastoresServer
	EnvironmentContainersServer      EnvironmentContainersServer
	EnvironmentVersionsServer        EnvironmentVersionsServer
	JobsServer                       JobsServer
	ModelContainersServer            ModelContainersServer
	ModelVersionsServer              ModelVersionsServer
	OnlineDeploymentsServer          OnlineDeploymentsServer
	OnlineEndpointsServer            OnlineEndpointsServer
	OperationsServer                 OperationsServer
	PrivateEndpointConnectionsServer PrivateEndpointConnectionsServer
	PrivateLinkResourcesServer       PrivateLinkResourcesServer
	QuotasServer                     QuotasServer
	SchedulesServer                  SchedulesServer
	UsagesServer                     UsagesServer
	VirtualMachineSizesServer        VirtualMachineSizesServer
	WorkspaceConnectionsServer       WorkspaceConnectionsServer
	WorkspaceFeaturesServer          WorkspaceFeaturesServer
	WorkspacesServer                 WorkspacesServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armmachinelearning.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armmachinelearning.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                                *ServerFactory
	trMu                               sync.Mutex
	trBatchDeploymentsServer           *BatchDeploymentsServerTransport
	trBatchEndpointsServer             *BatchEndpointsServerTransport
	trCodeContainersServer             *CodeContainersServerTransport
	trCodeVersionsServer               *CodeVersionsServerTransport
	trComponentContainersServer        *ComponentContainersServerTransport
	trComponentVersionsServer          *ComponentVersionsServerTransport
	trComputeServer                    *ComputeServerTransport
	trDataContainersServer             *DataContainersServerTransport
	trDataVersionsServer               *DataVersionsServerTransport
	trDatastoresServer                 *DatastoresServerTransport
	trEnvironmentContainersServer      *EnvironmentContainersServerTransport
	trEnvironmentVersionsServer        *EnvironmentVersionsServerTransport
	trJobsServer                       *JobsServerTransport
	trModelContainersServer            *ModelContainersServerTransport
	trModelVersionsServer              *ModelVersionsServerTransport
	trOnlineDeploymentsServer          *OnlineDeploymentsServerTransport
	trOnlineEndpointsServer            *OnlineEndpointsServerTransport
	trOperationsServer                 *OperationsServerTransport
	trPrivateEndpointConnectionsServer *PrivateEndpointConnectionsServerTransport
	trPrivateLinkResourcesServer       *PrivateLinkResourcesServerTransport
	trQuotasServer                     *QuotasServerTransport
	trSchedulesServer                  *SchedulesServerTransport
	trUsagesServer                     *UsagesServerTransport
	trVirtualMachineSizesServer        *VirtualMachineSizesServerTransport
	trWorkspaceConnectionsServer       *WorkspaceConnectionsServerTransport
	trWorkspaceFeaturesServer          *WorkspaceFeaturesServerTransport
	trWorkspacesServer                 *WorkspacesServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "BatchDeploymentsClient":
		initServer(s, &s.trBatchDeploymentsServer, func() *BatchDeploymentsServerTransport {
			return NewBatchDeploymentsServerTransport(&s.srv.BatchDeploymentsServer)
		})
		resp, err = s.trBatchDeploymentsServer.Do(req)
	case "BatchEndpointsClient":
		initServer(s, &s.trBatchEndpointsServer, func() *BatchEndpointsServerTransport {
			return NewBatchEndpointsServerTransport(&s.srv.BatchEndpointsServer)
		})
		resp, err = s.trBatchEndpointsServer.Do(req)
	case "CodeContainersClient":
		initServer(s, &s.trCodeContainersServer, func() *CodeContainersServerTransport {
			return NewCodeContainersServerTransport(&s.srv.CodeContainersServer)
		})
		resp, err = s.trCodeContainersServer.Do(req)
	case "CodeVersionsClient":
		initServer(s, &s.trCodeVersionsServer, func() *CodeVersionsServerTransport { return NewCodeVersionsServerTransport(&s.srv.CodeVersionsServer) })
		resp, err = s.trCodeVersionsServer.Do(req)
	case "ComponentContainersClient":
		initServer(s, &s.trComponentContainersServer, func() *ComponentContainersServerTransport {
			return NewComponentContainersServerTransport(&s.srv.ComponentContainersServer)
		})
		resp, err = s.trComponentContainersServer.Do(req)
	case "ComponentVersionsClient":
		initServer(s, &s.trComponentVersionsServer, func() *ComponentVersionsServerTransport {
			return NewComponentVersionsServerTransport(&s.srv.ComponentVersionsServer)
		})
		resp, err = s.trComponentVersionsServer.Do(req)
	case "ComputeClient":
		initServer(s, &s.trComputeServer, func() *ComputeServerTransport { return NewComputeServerTransport(&s.srv.ComputeServer) })
		resp, err = s.trComputeServer.Do(req)
	case "DataContainersClient":
		initServer(s, &s.trDataContainersServer, func() *DataContainersServerTransport {
			return NewDataContainersServerTransport(&s.srv.DataContainersServer)
		})
		resp, err = s.trDataContainersServer.Do(req)
	case "DataVersionsClient":
		initServer(s, &s.trDataVersionsServer, func() *DataVersionsServerTransport { return NewDataVersionsServerTransport(&s.srv.DataVersionsServer) })
		resp, err = s.trDataVersionsServer.Do(req)
	case "DatastoresClient":
		initServer(s, &s.trDatastoresServer, func() *DatastoresServerTransport { return NewDatastoresServerTransport(&s.srv.DatastoresServer) })
		resp, err = s.trDatastoresServer.Do(req)
	case "EnvironmentContainersClient":
		initServer(s, &s.trEnvironmentContainersServer, func() *EnvironmentContainersServerTransport {
			return NewEnvironmentContainersServerTransport(&s.srv.EnvironmentContainersServer)
		})
		resp, err = s.trEnvironmentContainersServer.Do(req)
	case "EnvironmentVersionsClient":
		initServer(s, &s.trEnvironmentVersionsServer, func() *EnvironmentVersionsServerTransport {
			return NewEnvironmentVersionsServerTransport(&s.srv.EnvironmentVersionsServer)
		})
		resp, err = s.trEnvironmentVersionsServer.Do(req)
	case "JobsClient":
		initServer(s, &s.trJobsServer, func() *JobsServerTransport { return NewJobsServerTransport(&s.srv.JobsServer) })
		resp, err = s.trJobsServer.Do(req)
	case "ModelContainersClient":
		initServer(s, &s.trModelContainersServer, func() *ModelContainersServerTransport {
			return NewModelContainersServerTransport(&s.srv.ModelContainersServer)
		})
		resp, err = s.trModelContainersServer.Do(req)
	case "ModelVersionsClient":
		initServer(s, &s.trModelVersionsServer, func() *ModelVersionsServerTransport {
			return NewModelVersionsServerTransport(&s.srv.ModelVersionsServer)
		})
		resp, err = s.trModelVersionsServer.Do(req)
	case "OnlineDeploymentsClient":
		initServer(s, &s.trOnlineDeploymentsServer, func() *OnlineDeploymentsServerTransport {
			return NewOnlineDeploymentsServerTransport(&s.srv.OnlineDeploymentsServer)
		})
		resp, err = s.trOnlineDeploymentsServer.Do(req)
	case "OnlineEndpointsClient":
		initServer(s, &s.trOnlineEndpointsServer, func() *OnlineEndpointsServerTransport {
			return NewOnlineEndpointsServerTransport(&s.srv.OnlineEndpointsServer)
		})
		resp, err = s.trOnlineEndpointsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "PrivateEndpointConnectionsClient":
		initServer(s, &s.trPrivateEndpointConnectionsServer, func() *PrivateEndpointConnectionsServerTransport {
			return NewPrivateEndpointConnectionsServerTransport(&s.srv.PrivateEndpointConnectionsServer)
		})
		resp, err = s.trPrivateEndpointConnectionsServer.Do(req)
	case "PrivateLinkResourcesClient":
		initServer(s, &s.trPrivateLinkResourcesServer, func() *PrivateLinkResourcesServerTransport {
			return NewPrivateLinkResourcesServerTransport(&s.srv.PrivateLinkResourcesServer)
		})
		resp, err = s.trPrivateLinkResourcesServer.Do(req)
	case "QuotasClient":
		initServer(s, &s.trQuotasServer, func() *QuotasServerTransport { return NewQuotasServerTransport(&s.srv.QuotasServer) })
		resp, err = s.trQuotasServer.Do(req)
	case "SchedulesClient":
		initServer(s, &s.trSchedulesServer, func() *SchedulesServerTransport { return NewSchedulesServerTransport(&s.srv.SchedulesServer) })
		resp, err = s.trSchedulesServer.Do(req)
	case "UsagesClient":
		initServer(s, &s.trUsagesServer, func() *UsagesServerTransport { return NewUsagesServerTransport(&s.srv.UsagesServer) })
		resp, err = s.trUsagesServer.Do(req)
	case "VirtualMachineSizesClient":
		initServer(s, &s.trVirtualMachineSizesServer, func() *VirtualMachineSizesServerTransport {
			return NewVirtualMachineSizesServerTransport(&s.srv.VirtualMachineSizesServer)
		})
		resp, err = s.trVirtualMachineSizesServer.Do(req)
	case "WorkspaceConnectionsClient":
		initServer(s, &s.trWorkspaceConnectionsServer, func() *WorkspaceConnectionsServerTransport {
			return NewWorkspaceConnectionsServerTransport(&s.srv.WorkspaceConnectionsServer)
		})
		resp, err = s.trWorkspaceConnectionsServer.Do(req)
	case "WorkspaceFeaturesClient":
		initServer(s, &s.trWorkspaceFeaturesServer, func() *WorkspaceFeaturesServerTransport {
			return NewWorkspaceFeaturesServerTransport(&s.srv.WorkspaceFeaturesServer)
		})
		resp, err = s.trWorkspaceFeaturesServer.Do(req)
	case "WorkspacesClient":
		initServer(s, &s.trWorkspacesServer, func() *WorkspacesServerTransport { return NewWorkspacesServerTransport(&s.srv.WorkspacesServer) })
		resp, err = s.trWorkspacesServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
