//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmachinelearning

import "time"

// AKS - A Machine Learning compute based on AKS.
type AKS struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// AKS properties
	Properties *AKSSchemaProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type AKS.
func (a *AKS) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    a.ComputeLocation,
		ComputeType:        a.ComputeType,
		CreatedOn:          a.CreatedOn,
		Description:        a.Description,
		DisableLocalAuth:   a.DisableLocalAuth,
		IsAttachedCompute:  a.IsAttachedCompute,
		ModifiedOn:         a.ModifiedOn,
		ProvisioningErrors: a.ProvisioningErrors,
		ProvisioningState:  a.ProvisioningState,
		ResourceID:         a.ResourceID,
	}
}

type AKSSchema struct {
	// AKS properties
	Properties *AKSSchemaProperties
}

// AKSSchemaProperties - AKS properties
type AKSSchemaProperties struct {
	// Number of agents
	AgentCount *int32

	// Agent virtual machine size
	AgentVMSize *string

	// AKS networking configuration for vnet
	AksNetworkingConfiguration *AksNetworkingConfiguration

	// Cluster full qualified domain name
	ClusterFqdn *string

	// Intended usage of the cluster
	ClusterPurpose *ClusterPurpose

	// Load Balancer Subnet
	LoadBalancerSubnet *string

	// Load Balancer Type
	LoadBalancerType *LoadBalancerType

	// SSL configuration
	SSLConfiguration *SSLConfiguration

	// READ-ONLY; System services
	SystemServices []*SystemService
}

// AccountKeyDatastoreCredentials - Account key datastore credentials configuration.
type AccountKeyDatastoreCredentials struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	CredentialsType *CredentialsType

	// REQUIRED; [Required] Storage account secrets.
	Secrets *AccountKeyDatastoreSecrets
}

// GetDatastoreCredentials implements the DatastoreCredentialsClassification interface for type AccountKeyDatastoreCredentials.
func (a *AccountKeyDatastoreCredentials) GetDatastoreCredentials() *DatastoreCredentials {
	return &DatastoreCredentials{
		CredentialsType: a.CredentialsType,
	}
}

// AccountKeyDatastoreSecrets - Datastore account key secrets.
type AccountKeyDatastoreSecrets struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	SecretsType *SecretsType

	// Storage account key.
	Key *string
}

// GetDatastoreSecrets implements the DatastoreSecretsClassification interface for type AccountKeyDatastoreSecrets.
func (a *AccountKeyDatastoreSecrets) GetDatastoreSecrets() *DatastoreSecrets {
	return &DatastoreSecrets{
		SecretsType: a.SecretsType,
	}
}

// AksComputeSecrets - Secrets related to a Machine Learning compute based on AKS.
type AksComputeSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string

	// Image registry pull secret.
	ImagePullSecretName *string

	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type AksComputeSecrets.
func (a *AksComputeSecrets) GetComputeSecrets() *ComputeSecrets {
	return &ComputeSecrets{
		ComputeType: a.ComputeType,
	}
}

// AksComputeSecretsProperties - Properties of AksComputeSecrets
type AksComputeSecretsProperties struct {
	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string

	// Image registry pull secret.
	ImagePullSecretName *string

	// Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string
}

// AksNetworkingConfiguration - Advance configuration for AKS networking
type AksNetworkingConfiguration struct {
	// An IP address assigned to the Kubernetes DNS service. It must be within the Kubernetes service address range specified
	// in serviceCidr.
	DNSServiceIP *string

	// A CIDR notation IP range assigned to the Docker bridge network. It must not overlap with any Subnet IP ranges or the Kubernetes
	// service address range.
	DockerBridgeCidr *string

	// A CIDR notation IP range from which to assign service cluster IPs. It must not overlap with any Subnet IP ranges.
	ServiceCidr *string

	// Virtual network subnet resource ID the compute nodes belong to
	SubnetID *string
}

// AmlCompute - An Azure Machine Learning compute.
type AmlCompute struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// Properties of AmlCompute
	Properties *AmlComputeProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type AmlCompute.
func (a *AmlCompute) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    a.ComputeLocation,
		ComputeType:        a.ComputeType,
		CreatedOn:          a.CreatedOn,
		Description:        a.Description,
		DisableLocalAuth:   a.DisableLocalAuth,
		IsAttachedCompute:  a.IsAttachedCompute,
		ModifiedOn:         a.ModifiedOn,
		ProvisioningErrors: a.ProvisioningErrors,
		ProvisioningState:  a.ProvisioningState,
		ResourceID:         a.ResourceID,
	}
}

// AmlComputeNodeInformation - Compute node information related to a AmlCompute.
type AmlComputeNodeInformation struct {
	// READ-ONLY; ID of the compute node.
	NodeID *string

	// READ-ONLY; State of the compute node. Values are idle, running, preparing, unusable, leaving and preempted.
	NodeState *NodeState

	// READ-ONLY; SSH port number of the node.
	Port *int32

	// READ-ONLY; Private IP address of the compute node.
	PrivateIPAddress *string

	// READ-ONLY; Public IP address of the compute node.
	PublicIPAddress *string

	// READ-ONLY; ID of the Experiment running on the node, if any else null.
	RunID *string
}

// AmlComputeNodesInformation - Result of AmlCompute Nodes
type AmlComputeNodesInformation struct {
	// READ-ONLY; The continuation token.
	NextLink *string

	// READ-ONLY; The collection of returned AmlCompute nodes details.
	Nodes []*AmlComputeNodeInformation
}

// AmlComputeProperties - AML Compute properties
type AmlComputeProperties struct {
	// Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that
	// the compute nodes will have public IPs provisioned. false - Indicates that the
	// compute nodes will have a private endpoint and no public IPs.
	EnableNodePublicIP *bool

	// Network is isolated or not
	IsolatedNetwork *bool

	// Compute OS Type
	OSType *OsType

	// A property bag containing additional properties.
	PropertyBag any

	// State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on all nodes
	// of the cluster. Enabled - Indicates that the public ssh port is open on all
	// nodes of the cluster. NotSpecified - Indicates that the public ssh port is closed on all nodes of the cluster if VNet is
	// defined, else is open all public nodes. It can be default only during cluster
	// creation time, after creation it will be either enabled or disabled.
	RemoteLoginPortPublicAccess *RemoteLoginPortPublicAccess

	// Scale settings for AML Compute
	ScaleSettings *ScaleSettings

	// Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID

	// Credentials for an administrator user account that will be created on each compute node.
	UserAccountCredentials *UserAccountCredentials

	// Virtual Machine priority
	VMPriority *VMPriority

	// Virtual Machine Size
	VMSize *string

	// Virtual Machine image for AML Compute - windows only
	VirtualMachineImage *VirtualMachineImage

	// READ-ONLY; Allocation state of the compute. Possible values are: steady - Indicates that the compute is not resizing. There
	// are no changes to the number of compute nodes in the compute in progress. A compute
	// enters this state when it is created and when no operations are being performed on the compute to change the number of
	// compute nodes. resizing - Indicates that the compute is resizing; that is,
	// compute nodes are being added to or removed from the compute.
	AllocationState *AllocationState

	// READ-ONLY; The time at which the compute entered its current allocation state.
	AllocationStateTransitionTime *time.Time

	// READ-ONLY; The number of compute nodes currently assigned to the compute.
	CurrentNodeCount *int32

	// READ-ONLY; Collection of errors encountered by various compute nodes during node setup.
	Errors []*ErrorResponse

	// READ-ONLY; Counts of various node states on the compute.
	NodeStateCounts *NodeStateCounts

	// READ-ONLY; The target number of compute nodes for the compute. If the allocationState is resizing, this property denotes
	// the target node count for the ongoing resize operation. If the allocationState is steady,
	// this property denotes the target node count for the previous resize operation.
	TargetNodeCount *int32
}

// AmlComputeSchema - Properties(top level) of AmlCompute
type AmlComputeSchema struct {
	// Properties of AmlCompute
	Properties *AmlComputeProperties
}

// AmlOperation - Azure Machine Learning workspace REST API operation
type AmlOperation struct {
	// Display name of operation
	Display *AmlOperationDisplay

	// Indicates whether the operation applies to data-plane
	IsDataAction *bool

	// Operation name: {provider}/{resource}/{operation}
	Name *string
}

// AmlOperationDisplay - Display name of operation
type AmlOperationDisplay struct {
	// The description for the operation.
	Description *string

	// The operation that users can perform.
	Operation *string

	// The resource provider name: Microsoft.MachineLearningExperimentation
	Provider *string

	// The resource on which the operation is performed.
	Resource *string
}

// AmlOperationListResult - An array of operations supported by the resource provider.
type AmlOperationListResult struct {
	// List of AML workspace operations supported by the AML workspace resource provider.
	Value []*AmlOperation
}

// AmlToken - AML Token identity configuration.
type AmlToken struct {
	// REQUIRED; [Required] Specifies the type of identity framework.
	IdentityType *IdentityConfigurationType
}

// GetIdentityConfiguration implements the IdentityConfigurationClassification interface for type AmlToken.
func (a *AmlToken) GetIdentityConfiguration() *IdentityConfiguration {
	return &IdentityConfiguration{
		IdentityType: a.IdentityType,
	}
}

// AmlUserFeature - Features enabled for a workspace
type AmlUserFeature struct {
	// Describes the feature for user experience
	Description *string

	// Specifies the feature name
	DisplayName *string

	// Specifies the feature ID
	ID *string
}

type AssetBase struct {
	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

type AssetContainer struct {
	// The asset description text.
	Description *string

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; The latest version inside this container.
	LatestVersion *string

	// READ-ONLY; The next auto incremental version
	NextVersion *string
}

// AssetJobInput - Asset input type.
type AssetJobInput struct {
	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// AssetJobOutput - Asset output type.
type AssetJobOutput struct {
	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// AssetReferenceBase - Base definition for asset references.
type AssetReferenceBase struct {
	// REQUIRED; [Required] Specifies the type of asset reference.
	ReferenceType *ReferenceType
}

// GetAssetReferenceBase implements the AssetReferenceBaseClassification interface for type AssetReferenceBase.
func (a *AssetReferenceBase) GetAssetReferenceBase() *AssetReferenceBase { return a }

// AssignedUser - A user that can be assigned to a compute instance.
type AssignedUser struct {
	// REQUIRED; User’s AAD Object Id.
	ObjectID *string

	// REQUIRED; User’s AAD Tenant Id.
	TenantID *string
}

// AutoForecastHorizon - Forecast horizon determined automatically by system.
type AutoForecastHorizon struct {
	// REQUIRED; [Required] Set forecast horizon value selection mode.
	Mode *ForecastHorizonMode
}

// GetForecastHorizon implements the ForecastHorizonClassification interface for type AutoForecastHorizon.
func (a *AutoForecastHorizon) GetForecastHorizon() *ForecastHorizon {
	return &ForecastHorizon{
		Mode: a.Mode,
	}
}

// AutoMLJob class. Use this class for executing AutoML tasks like Classification/Regression etc. See TaskType enum for all
// the tasks supported.
type AutoMLJob struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobType *JobType

	// REQUIRED; [Required] This represents scenario which can be one of Tables/NLP/Image
	TaskDetails AutoMLVerticalClassification

	// ARM resource ID of the component resource.
	ComponentID *string

	// ARM resource ID of the compute resource.
	ComputeID *string

	// The asset description text.
	Description *string

	// Display name of job.
	DisplayName *string

	// The ARM resource ID of the Environment specification for the job. This is optional value to provide, if not provided, AutoML
	// will default this to Production AutoML curated environment version when
	// running the job.
	EnvironmentID *string

	// Environment variables included in the job.
	EnvironmentVariables map[string]*string

	// The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
	ExperimentName *string

	// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null. Defaults to AmlToken
	// if null.
	Identity IdentityConfigurationClassification

	// Is the asset archived?
	IsArchived *bool

	// Mapping of output data bindings used in the job.
	Outputs map[string]JobOutputClassification

	// The asset property dictionary.
	Properties map[string]*string

	// Compute Resource configuration for the job.
	Resources *JobResourceConfiguration

	// List of JobEndpoints. For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
	Services map[string]*JobService

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Status of the job.
	Status *JobStatus
}

// GetJobBaseProperties implements the JobBasePropertiesClassification interface for type AutoMLJob.
func (a *AutoMLJob) GetJobBaseProperties() *JobBaseProperties {
	return &JobBaseProperties{
		ComponentID:    a.ComponentID,
		ComputeID:      a.ComputeID,
		Description:    a.Description,
		DisplayName:    a.DisplayName,
		ExperimentName: a.ExperimentName,
		Identity:       a.Identity,
		IsArchived:     a.IsArchived,
		JobType:        a.JobType,
		Properties:     a.Properties,
		Services:       a.Services,
		Status:         a.Status,
		Tags:           a.Tags,
	}
}

// AutoMLVertical - AutoML vertical class. Base class for AutoML verticals - TableVertical/ImageVertical/NLPVertical
type AutoMLVertical struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type AutoMLVertical.
func (a *AutoMLVertical) GetAutoMLVertical() *AutoMLVertical { return a }

// AutoNCrossValidations - N-Cross validations determined automatically.
type AutoNCrossValidations struct {
	// REQUIRED; [Required] Mode for determining N-Cross validations.
	Mode *NCrossValidationsMode
}

// GetNCrossValidations implements the NCrossValidationsClassification interface for type AutoNCrossValidations.
func (a *AutoNCrossValidations) GetNCrossValidations() *NCrossValidations {
	return &NCrossValidations{
		Mode: a.Mode,
	}
}

// AutoPauseProperties - Auto pause properties
type AutoPauseProperties struct {
	DelayInMinutes *int32
	Enabled        *bool
}

// AutoScaleProperties - Auto scale properties
type AutoScaleProperties struct {
	Enabled      *bool
	MaxNodeCount *int32
	MinNodeCount *int32
}

type AutoSeasonality struct {
	// REQUIRED; [Required] Seasonality mode.
	Mode *SeasonalityMode
}

// GetSeasonality implements the SeasonalityClassification interface for type AutoSeasonality.
func (a *AutoSeasonality) GetSeasonality() *Seasonality {
	return &Seasonality{
		Mode: a.Mode,
	}
}

type AutoTargetLags struct {
	// REQUIRED; [Required] Set target lags mode - Auto/Custom
	Mode *TargetLagsMode
}

// GetTargetLags implements the TargetLagsClassification interface for type AutoTargetLags.
func (a *AutoTargetLags) GetTargetLags() *TargetLags {
	return &TargetLags{
		Mode: a.Mode,
	}
}

// AutoTargetRollingWindowSize - Target lags rolling window determined automatically.
type AutoTargetRollingWindowSize struct {
	// REQUIRED; [Required] TargetRollingWindowSiz detection mode.
	Mode *TargetRollingWindowSizeMode
}

// GetTargetRollingWindowSize implements the TargetRollingWindowSizeClassification interface for type AutoTargetRollingWindowSize.
func (a *AutoTargetRollingWindowSize) GetTargetRollingWindowSize() *TargetRollingWindowSize {
	return &TargetRollingWindowSize{
		Mode: a.Mode,
	}
}

// AzureBlobDatastore - Azure Blob datastore configuration.
type AzureBlobDatastore struct {
	// REQUIRED; [Required] Account credentials.
	Credentials DatastoreCredentialsClassification

	// REQUIRED; [Required] Storage type backing the datastore.
	DatastoreType *DatastoreType

	// Storage account name.
	AccountName *string

	// Storage account container name.
	ContainerName *string

	// The asset description text.
	Description *string

	// Azure cloud endpoint for the storage account.
	Endpoint *string

	// The asset property dictionary.
	Properties map[string]*string

	// Protocol used to communicate with the storage account.
	Protocol *string

	// Indicates which identity to use to authenticate service data access to customer's storage.
	ServiceDataAccessAuthIdentity *ServiceDataAccessAuthIdentity

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Readonly property to indicate if datastore is the workspace default datastore
	IsDefault *bool
}

// GetDatastoreProperties implements the DatastorePropertiesClassification interface for type AzureBlobDatastore.
func (a *AzureBlobDatastore) GetDatastoreProperties() *DatastoreProperties {
	return &DatastoreProperties{
		Credentials:   a.Credentials,
		DatastoreType: a.DatastoreType,
		Description:   a.Description,
		IsDefault:     a.IsDefault,
		Properties:    a.Properties,
		Tags:          a.Tags,
	}
}

// AzureDataLakeGen1Datastore - Azure Data Lake Gen1 datastore configuration.
type AzureDataLakeGen1Datastore struct {
	// REQUIRED; [Required] Account credentials.
	Credentials DatastoreCredentialsClassification

	// REQUIRED; [Required] Storage type backing the datastore.
	DatastoreType *DatastoreType

	// REQUIRED; [Required] Azure Data Lake store name.
	StoreName *string

	// The asset description text.
	Description *string

	// The asset property dictionary.
	Properties map[string]*string

	// Indicates which identity to use to authenticate service data access to customer's storage.
	ServiceDataAccessAuthIdentity *ServiceDataAccessAuthIdentity

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Readonly property to indicate if datastore is the workspace default datastore
	IsDefault *bool
}

// GetDatastoreProperties implements the DatastorePropertiesClassification interface for type AzureDataLakeGen1Datastore.
func (a *AzureDataLakeGen1Datastore) GetDatastoreProperties() *DatastoreProperties {
	return &DatastoreProperties{
		Credentials:   a.Credentials,
		DatastoreType: a.DatastoreType,
		Description:   a.Description,
		IsDefault:     a.IsDefault,
		Properties:    a.Properties,
		Tags:          a.Tags,
	}
}

// AzureDataLakeGen2Datastore - Azure Data Lake Gen2 datastore configuration.
type AzureDataLakeGen2Datastore struct {
	// REQUIRED; [Required] Storage account name.
	AccountName *string

	// REQUIRED; [Required] Account credentials.
	Credentials DatastoreCredentialsClassification

	// REQUIRED; [Required] Storage type backing the datastore.
	DatastoreType *DatastoreType

	// REQUIRED; [Required] The name of the Data Lake Gen2 filesystem.
	Filesystem *string

	// The asset description text.
	Description *string

	// Azure cloud endpoint for the storage account.
	Endpoint *string

	// The asset property dictionary.
	Properties map[string]*string

	// Protocol used to communicate with the storage account.
	Protocol *string

	// Indicates which identity to use to authenticate service data access to customer's storage.
	ServiceDataAccessAuthIdentity *ServiceDataAccessAuthIdentity

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Readonly property to indicate if datastore is the workspace default datastore
	IsDefault *bool
}

// GetDatastoreProperties implements the DatastorePropertiesClassification interface for type AzureDataLakeGen2Datastore.
func (a *AzureDataLakeGen2Datastore) GetDatastoreProperties() *DatastoreProperties {
	return &DatastoreProperties{
		Credentials:   a.Credentials,
		DatastoreType: a.DatastoreType,
		Description:   a.Description,
		IsDefault:     a.IsDefault,
		Properties:    a.Properties,
		Tags:          a.Tags,
	}
}

// AzureFileDatastore - Azure File datastore configuration.
type AzureFileDatastore struct {
	// REQUIRED; [Required] Storage account name.
	AccountName *string

	// REQUIRED; [Required] Account credentials.
	Credentials DatastoreCredentialsClassification

	// REQUIRED; [Required] Storage type backing the datastore.
	DatastoreType *DatastoreType

	// REQUIRED; [Required] The name of the Azure file share that the datastore points to.
	FileShareName *string

	// The asset description text.
	Description *string

	// Azure cloud endpoint for the storage account.
	Endpoint *string

	// The asset property dictionary.
	Properties map[string]*string

	// Protocol used to communicate with the storage account.
	Protocol *string

	// Indicates which identity to use to authenticate service data access to customer's storage.
	ServiceDataAccessAuthIdentity *ServiceDataAccessAuthIdentity

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Readonly property to indicate if datastore is the workspace default datastore
	IsDefault *bool
}

// GetDatastoreProperties implements the DatastorePropertiesClassification interface for type AzureFileDatastore.
func (a *AzureFileDatastore) GetDatastoreProperties() *DatastoreProperties {
	return &DatastoreProperties{
		Credentials:   a.Credentials,
		DatastoreType: a.DatastoreType,
		Description:   a.Description,
		IsDefault:     a.IsDefault,
		Properties:    a.Properties,
		Tags:          a.Tags,
	}
}

// BanditPolicy - Defines an early termination policy based on slack criteria, and a frequency and delay interval for evaluation
type BanditPolicy struct {
	// REQUIRED; [Required] Name of policy configuration
	PolicyType *EarlyTerminationPolicyType

	// Number of intervals by which to delay the first evaluation.
	DelayEvaluation *int32

	// Interval (number of runs) between policy evaluations.
	EvaluationInterval *int32

	// Absolute distance allowed from the best performing run.
	SlackAmount *float32

	// Ratio of the allowed distance from the best performing run.
	SlackFactor *float32
}

// GetEarlyTerminationPolicy implements the EarlyTerminationPolicyClassification interface for type BanditPolicy.
func (b *BanditPolicy) GetEarlyTerminationPolicy() *EarlyTerminationPolicy {
	return &EarlyTerminationPolicy{
		DelayEvaluation:    b.DelayEvaluation,
		EvaluationInterval: b.EvaluationInterval,
		PolicyType:         b.PolicyType,
	}
}

type BatchDeployment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *BatchDeploymentProperties

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
	Kind *string

	// Sku details required for ARM contract for Autoscaling.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BatchDeploymentProperties - Batch inference settings per deployment.
type BatchDeploymentProperties struct {
	// Code configuration for the endpoint deployment.
	CodeConfiguration *CodeConfiguration

	// Compute target for batch inference operation.
	Compute *string

	// Description of the endpoint deployment.
	Description *string

	// ARM resource ID or AssetId of the environment specification for the endpoint deployment.
	EnvironmentID *string

	// Environment variables configuration for the deployment.
	EnvironmentVariables map[string]*string

	// Error threshold, if the error count for the entire input goes above this value, the batch inference will be aborted. Range
	// is [-1, int.MaxValue]. For FileDataset, this value is the count of file
	// failures. For TabularDataset, this value is the count of record failures. If set to -1 (the lower bound), all failures
	// during batch inference will be ignored.
	ErrorThreshold *int32

	// Logging level for batch inference operation.
	LoggingLevel *BatchLoggingLevel

	// Indicates maximum number of parallelism per instance.
	MaxConcurrencyPerInstance *int32

	// Size of the mini-batch passed to each batch invocation. For FileDataset, this is the number of files per mini-batch. For
	// TabularDataset, this is the size of the records in bytes, per mini-batch.
	MiniBatchSize *int64

	// Reference to the model asset for the endpoint deployment.
	Model AssetReferenceBaseClassification

	// Indicates how the output will be organized.
	OutputAction *BatchOutputAction

	// Customized output file name for append_row output action.
	OutputFileName *string

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// Indicates compute configuration for the job. If not provided, will default to the defaults defined in ResourceConfiguration.
	Resources *DeploymentResourceConfiguration

	// Retry Settings for the batch inference operation. If not provided, will default to the defaults defined in BatchRetrySettings.
	RetrySettings *BatchRetrySettings

	// READ-ONLY; Provisioning state for the endpoint deployment.
	ProvisioningState *DeploymentProvisioningState
}

// BatchDeploymentTrackedResourceArmPaginatedResult - A paginated list of BatchDeployment entities.
type BatchDeploymentTrackedResourceArmPaginatedResult struct {
	// The link to the next page of BatchDeployment objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type BatchDeployment.
	Value []*BatchDeployment
}

type BatchEndpoint struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *BatchEndpointProperties

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
	Kind *string

	// Sku details required for ARM contract for Autoscaling.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BatchEndpointDefaults - Batch endpoint default values
type BatchEndpointDefaults struct {
	// Name of the deployment that will be default for the endpoint. This deployment will end up getting 100% traffic when the
	// endpoint scoring URL is invoked.
	DeploymentName *string
}

// BatchEndpointProperties - Batch endpoint configuration.
type BatchEndpointProperties struct {
	// REQUIRED; [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication.
	// 'Key' doesn't expire but 'AMLToken' does.
	AuthMode *EndpointAuthMode

	// Default values for Batch Endpoint
	Defaults *BatchEndpointDefaults

	// Description of the inference endpoint.
	Description *string

	// EndpointAuthKeys to set initially on an Endpoint. This property will always be returned as null. AuthKey values must be
	// retrieved using the ListKeys API.
	Keys *EndpointAuthKeys

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// READ-ONLY; Provisioning state for the endpoint.
	ProvisioningState *EndpointProvisioningState

	// READ-ONLY; Endpoint URI.
	ScoringURI *string

	// READ-ONLY; Endpoint Swagger URI.
	SwaggerURI *string
}

// BatchEndpointTrackedResourceArmPaginatedResult - A paginated list of BatchEndpoint entities.
type BatchEndpointTrackedResourceArmPaginatedResult struct {
	// The link to the next page of BatchEndpoint objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type BatchEndpoint.
	Value []*BatchEndpoint
}

// BatchRetrySettings - Retry settings for a batch inference operation.
type BatchRetrySettings struct {
	// Maximum retry count for a mini-batch
	MaxRetries *int32

	// Invocation timeout for a mini-batch, in ISO 8601 format.
	Timeout *string
}

// BayesianSamplingAlgorithm - Defines a Sampling Algorithm that generates values based on previous values
type BayesianSamplingAlgorithm struct {
	// REQUIRED; [Required] The algorithm used for generating hyperparameter values, along with configuration properties
	SamplingAlgorithmType *SamplingAlgorithmType
}

// GetSamplingAlgorithm implements the SamplingAlgorithmClassification interface for type BayesianSamplingAlgorithm.
func (b *BayesianSamplingAlgorithm) GetSamplingAlgorithm() *SamplingAlgorithm {
	return &SamplingAlgorithm{
		SamplingAlgorithmType: b.SamplingAlgorithmType,
	}
}

// BuildContext - Configuration settings for Docker build context
type BuildContext struct {
	// REQUIRED; [Required] URI of the Docker build context used to build the image. Supports blob URIs on environment creation
	// and may return blob or Git URIs.
	ContextURI *string

	// Path to the Dockerfile in the build context.
	DockerfilePath *string
}

// CertificateDatastoreCredentials - Certificate datastore credentials configuration.
type CertificateDatastoreCredentials struct {
	// REQUIRED; [Required] Service principal client ID.
	ClientID *string

	// REQUIRED; [Required] Credential type used to authentication with storage.
	CredentialsType *CredentialsType

	// REQUIRED; [Required] Service principal secrets.
	Secrets *CertificateDatastoreSecrets

	// REQUIRED; [Required] ID of the tenant to which the service principal belongs.
	TenantID *string

	// REQUIRED; [Required] Thumbprint of the certificate used for authentication.
	Thumbprint *string

	// Authority URL used for authentication.
	AuthorityURL *string

	// Resource the service principal has access to.
	ResourceURL *string
}

// GetDatastoreCredentials implements the DatastoreCredentialsClassification interface for type CertificateDatastoreCredentials.
func (c *CertificateDatastoreCredentials) GetDatastoreCredentials() *DatastoreCredentials {
	return &DatastoreCredentials{
		CredentialsType: c.CredentialsType,
	}
}

// CertificateDatastoreSecrets - Datastore certificate secrets.
type CertificateDatastoreSecrets struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	SecretsType *SecretsType

	// Service principal certificate.
	Certificate *string
}

// GetDatastoreSecrets implements the DatastoreSecretsClassification interface for type CertificateDatastoreSecrets.
func (c *CertificateDatastoreSecrets) GetDatastoreSecrets() *DatastoreSecrets {
	return &DatastoreSecrets{
		SecretsType: c.SecretsType,
	}
}

// Classification task in AutoML Table vertical.
type Classification struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Columns to use for CVSplit data.
	CvSplitColumnNames []*string

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *TableVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *TableVerticalLimitSettings

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Number of cross validation folds to be applied on training dataset when validation dataset is not provided.
	NCrossValidations NCrossValidationsClassification

	// Positive label for binary metrics calculation.
	PositiveLabel *string

	// Primary metric for the task.
	PrimaryMetric *ClassificationPrimaryMetrics

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Test data input.
	TestData *MLTableJobInput

	// The fraction of test dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied when
	// validation dataset is not provided.
	TestDataSize *float64

	// Inputs for training phase for an AutoML Job.
	TrainingSettings *ClassificationTrainingSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64

	// The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to
	// be weighted up or down.
	WeightColumnName *string
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type Classification.
func (c *Classification) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     c.LogVerbosity,
		TargetColumnName: c.TargetColumnName,
		TaskType:         c.TaskType,
		TrainingData:     c.TrainingData,
	}
}

// ClassificationTrainingSettings - Classification Training related configuration.
type ClassificationTrainingSettings struct {
	// Allowed models for classification task.
	AllowedTrainingAlgorithms []*ClassificationModels

	// Blocked models for classification task.
	BlockedTrainingAlgorithms []*ClassificationModels

	// Enable recommendation of DNN models.
	EnableDnnTraining *bool

	// Flag to turn on explainability on best model.
	EnableModelExplainability *bool

	// Flag for enabling onnx compatible models.
	EnableOnnxCompatibleModels *bool

	// Enable stack ensemble run.
	EnableStackEnsemble *bool

	// Enable voting ensemble run.
	EnableVoteEnsemble *bool

	// During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
	// Configure this parameter with a higher value than 300 secs, if more time
	// is needed.
	EnsembleModelDownloadTimeout *string

	// Stack ensemble settings for stack ensemble run.
	StackEnsembleSettings *StackEnsembleSettings
}

// ClusterUpdateParameters - AmlCompute update parameters.
type ClusterUpdateParameters struct {
	// The properties of the amlCompute.
	Properties *ClusterUpdateProperties
}

// ClusterUpdateProperties - The properties of a amlCompute that need to be updated.
type ClusterUpdateProperties struct {
	// Properties of ClusterUpdate
	Properties *ScaleSettingsInformation
}

// CodeConfiguration - Configuration for a scoring code asset.
type CodeConfiguration struct {
	// REQUIRED; [Required] The script to execute on startup. eg. "score.py"
	ScoringScript *string

	// ARM resource ID of the code asset.
	CodeID *string
}

// CodeContainer - Azure Resource Manager resource envelope.
type CodeContainer struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *CodeContainerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CodeContainerProperties - Container for code asset versions.
type CodeContainerProperties struct {
	// The asset description text.
	Description *string

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; The latest version inside this container.
	LatestVersion *string

	// READ-ONLY; The next auto incremental version
	NextVersion *string
}

// CodeContainerResourceArmPaginatedResult - A paginated list of CodeContainer entities.
type CodeContainerResourceArmPaginatedResult struct {
	// The link to the next page of CodeContainer objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type CodeContainer.
	Value []*CodeContainer
}

// CodeVersion - Azure Resource Manager resource envelope.
type CodeVersion struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *CodeVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CodeVersionProperties - Code asset version details.
type CodeVersionProperties struct {
	// Uri where code is located
	CodeURI *string

	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// CodeVersionResourceArmPaginatedResult - A paginated list of CodeVersion entities.
type CodeVersionResourceArmPaginatedResult struct {
	// The link to the next page of CodeVersion objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type CodeVersion.
	Value []*CodeVersion
}

// ColumnTransformer - Column transformer parameters.
type ColumnTransformer struct {
	// Fields to apply transformer logic on.
	Fields []*string

	// Different properties to be passed to transformer. Input expected is dictionary of key,value pairs in JSON format.
	Parameters any
}

// CommandJob - Command job definition.
type CommandJob struct {
	// REQUIRED; [Required] The command to execute on startup of the job. eg. "python train.py"
	Command *string

	// REQUIRED; [Required] The ARM resource ID of the Environment specification for the job.
	EnvironmentID *string

	// REQUIRED; [Required] Specifies the type of job.
	JobType *JobType

	// ARM resource ID of the code asset.
	CodeID *string

	// ARM resource ID of the component resource.
	ComponentID *string

	// ARM resource ID of the compute resource.
	ComputeID *string

	// The asset description text.
	Description *string

	// Display name of job.
	DisplayName *string

	// Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
	Distribution DistributionConfigurationClassification

	// Environment variables included in the job.
	EnvironmentVariables map[string]*string

	// The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
	ExperimentName *string

	// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null. Defaults to AmlToken
	// if null.
	Identity IdentityConfigurationClassification

	// Mapping of input data bindings used in the job.
	Inputs map[string]JobInputClassification

	// Is the asset archived?
	IsArchived *bool

	// Command Job limit.
	Limits *CommandJobLimits

	// Mapping of output data bindings used in the job.
	Outputs map[string]JobOutputClassification

	// The asset property dictionary.
	Properties map[string]*string

	// Compute Resource configuration for the job.
	Resources *JobResourceConfiguration

	// List of JobEndpoints. For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
	Services map[string]*JobService

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Input parameters.
	Parameters any

	// READ-ONLY; Status of the job.
	Status *JobStatus
}

// GetJobBaseProperties implements the JobBasePropertiesClassification interface for type CommandJob.
func (c *CommandJob) GetJobBaseProperties() *JobBaseProperties {
	return &JobBaseProperties{
		ComponentID:    c.ComponentID,
		ComputeID:      c.ComputeID,
		Description:    c.Description,
		DisplayName:    c.DisplayName,
		ExperimentName: c.ExperimentName,
		Identity:       c.Identity,
		IsArchived:     c.IsArchived,
		JobType:        c.JobType,
		Properties:     c.Properties,
		Services:       c.Services,
		Status:         c.Status,
		Tags:           c.Tags,
	}
}

// CommandJobLimits - Command Job limit class.
type CommandJobLimits struct {
	// REQUIRED; [Required] JobLimit type.
	JobLimitsType *JobLimitsType

	// The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as
	// low as Seconds.
	Timeout *string
}

// GetJobLimits implements the JobLimitsClassification interface for type CommandJobLimits.
func (c *CommandJobLimits) GetJobLimits() *JobLimits {
	return &JobLimits{
		JobLimitsType: c.JobLimitsType,
		Timeout:       c.Timeout,
	}
}

// ComponentContainer - Azure Resource Manager resource envelope.
type ComponentContainer struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *ComponentContainerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ComponentContainerProperties - Component container definition.
type ComponentContainerProperties struct {
	// The asset description text.
	Description *string

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; The latest version inside this container.
	LatestVersion *string

	// READ-ONLY; The next auto incremental version
	NextVersion *string
}

// ComponentContainerResourceArmPaginatedResult - A paginated list of ComponentContainer entities.
type ComponentContainerResourceArmPaginatedResult struct {
	// The link to the next page of ComponentContainer objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type ComponentContainer.
	Value []*ComponentContainer
}

// ComponentVersion - Azure Resource Manager resource envelope.
type ComponentVersion struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *ComponentVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ComponentVersionProperties - Definition of a component version: defines resources that span component types.
type ComponentVersionProperties struct {
	// Defines Component definition details.
	ComponentSpec any

	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// ComponentVersionResourceArmPaginatedResult - A paginated list of ComponentVersion entities.
type ComponentVersionResourceArmPaginatedResult struct {
	// The link to the next page of ComponentVersion objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type ComponentVersion.
	Value []*ComponentVersion
}

// Compute - Machine Learning compute object.
type Compute struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type Compute.
func (c *Compute) GetCompute() *Compute { return c }

// ComputeInstance - An Azure Machine Learning compute instance.
type ComputeInstance struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// Properties of ComputeInstance
	Properties *ComputeInstanceProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type ComputeInstance.
func (c *ComputeInstance) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    c.ComputeLocation,
		ComputeType:        c.ComputeType,
		CreatedOn:          c.CreatedOn,
		Description:        c.Description,
		DisableLocalAuth:   c.DisableLocalAuth,
		IsAttachedCompute:  c.IsAttachedCompute,
		ModifiedOn:         c.ModifiedOn,
		ProvisioningErrors: c.ProvisioningErrors,
		ProvisioningState:  c.ProvisioningState,
		ResourceID:         c.ResourceID,
	}
}

// ComputeInstanceApplication - Defines an Aml Instance application and its connectivity endpoint URI.
type ComputeInstanceApplication struct {
	// Name of the ComputeInstance application.
	DisplayName *string

	// Application' endpoint URI.
	EndpointURI *string
}

// ComputeInstanceConnectivityEndpoints - Defines all connectivity endpoints and properties for an ComputeInstance.
type ComputeInstanceConnectivityEndpoints struct {
	// READ-ONLY; Private IP Address of this ComputeInstance (local to the VNET in which the compute instance is deployed).
	PrivateIPAddress *string

	// READ-ONLY; Public IP Address of this ComputeInstance.
	PublicIPAddress *string
}

// ComputeInstanceContainer - Defines an Aml Instance container.
type ComputeInstanceContainer struct {
	// Auto save settings.
	Autosave *Autosave

	// Environment information of this container.
	Environment *ComputeInstanceEnvironmentInfo

	// Information of GPU.
	Gpu *string

	// Name of the ComputeInstance container.
	Name *string

	// network of this container.
	Network *Network

	// READ-ONLY; services of this containers.
	Services []any
}

// ComputeInstanceCreatedBy - Describes information on user who created this ComputeInstance.
type ComputeInstanceCreatedBy struct {
	// READ-ONLY; Uniquely identifies the user within his/her organization.
	UserID *string

	// READ-ONLY; Name of the user.
	UserName *string

	// READ-ONLY; Uniquely identifies user' Azure Active Directory organization.
	UserOrgID *string
}

// ComputeInstanceDataDisk - Defines an Aml Instance DataDisk.
type ComputeInstanceDataDisk struct {
	// Caching type of Data Disk.
	Caching *Caching

	// The initial disk size in gigabytes.
	DiskSizeGB *int32

	// The lun is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct lun.
	Lun *int32

	// type of this storage account.
	StorageAccountType *StorageAccountType
}

// ComputeInstanceDataMount - Defines an Aml Instance DataMount.
type ComputeInstanceDataMount struct {
	// who this data mount created by.
	CreatedBy *string

	// Error of this data mount.
	Error *string

	// Mount Action.
	MountAction *MountAction

	// name of the ComputeInstance data mount.
	MountName *string

	// Path of this data mount.
	MountPath *string

	// Mount state.
	MountState *MountState

	// The time when the disk mounted.
	MountedOn *time.Time

	// Source of the ComputeInstance data mount.
	Source *string

	// Data source type.
	SourceType *SourceType
}

// ComputeInstanceEnvironmentInfo - Environment information
type ComputeInstanceEnvironmentInfo struct {
	// name of environment.
	Name *string

	// version of environment.
	Version *string
}

// ComputeInstanceLastOperation - The last operation on ComputeInstance.
type ComputeInstanceLastOperation struct {
	// Name of the last operation.
	OperationName *OperationName

	// Operation status.
	OperationStatus *OperationStatus

	// Time of the last operation.
	OperationTime *time.Time

	// Trigger of operation.
	OperationTrigger *OperationTrigger
}

// ComputeInstanceProperties - Compute Instance properties
type ComputeInstanceProperties struct {
	// Policy for sharing applications on this compute instance among users of parent workspace. If Personal, only the creator
	// can access applications on this compute instance. When Shared, any workspace
	// user can access applications on this instance depending on his/her assigned role.
	ApplicationSharingPolicy *ApplicationSharingPolicy

	// The Compute Instance Authorization type. Available values are personal (default).
	ComputeInstanceAuthorizationType *ComputeInstanceAuthorizationType

	// Enable or disable node public IP address provisioning. Possible values are: Possible values are: true - Indicates that
	// the compute nodes will have public IPs provisioned. false - Indicates that the
	// compute nodes will have a private endpoint and no public IPs.
	EnableNodePublicIP *bool

	// Settings for a personal compute instance.
	PersonalComputeInstanceSettings *PersonalComputeInstanceSettings

	// Specifies policy and settings for SSH access.
	SSHSettings *ComputeInstanceSSHSettings

	// Details of customized scripts to execute for setting up the cluster.
	SetupScripts *SetupScripts

	// Virtual network subnet resource ID the compute nodes belong to.
	Subnet *ResourceID

	// Virtual Machine Size
	VMSize *string

	// READ-ONLY; Describes available applications and their endpoints on this ComputeInstance.
	Applications []*ComputeInstanceApplication

	// READ-ONLY; Describes all connectivity endpoints available for this ComputeInstance.
	ConnectivityEndpoints *ComputeInstanceConnectivityEndpoints

	// READ-ONLY; Describes informations of containers on this ComputeInstance.
	Containers []*ComputeInstanceContainer

	// READ-ONLY; Describes information on user who created this ComputeInstance.
	CreatedBy *ComputeInstanceCreatedBy

	// READ-ONLY; Describes informations of dataDisks on this ComputeInstance.
	DataDisks []*ComputeInstanceDataDisk

	// READ-ONLY; Describes informations of dataMounts on this ComputeInstance.
	DataMounts []*ComputeInstanceDataMount

	// READ-ONLY; Collection of errors encountered on this ComputeInstance.
	Errors []*ErrorResponse

	// READ-ONLY; The last operation on ComputeInstance.
	LastOperation *ComputeInstanceLastOperation

	// READ-ONLY; The list of schedules to be applied on the computes.
	Schedules *ComputeSchedules

	// READ-ONLY; The current state of this ComputeInstance.
	State *ComputeInstanceState

	// READ-ONLY; ComputeInstance version.
	Versions *ComputeInstanceVersion
}

// ComputeInstanceSSHSettings - Specifies policy and settings for SSH access.
type ComputeInstanceSSHSettings struct {
	// Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t rsa -b 2048" to generate your SSH key pairs.
	AdminPublicKey *string

	// State of the public SSH port. Possible values are: Disabled - Indicates that the public ssh port is closed on this instance.
	// Enabled - Indicates that the public ssh port is open and accessible
	// according to the VNet/subnet policy if applicable.
	SSHPublicAccess *SSHPublicAccess

	// READ-ONLY; Describes the admin user name.
	AdminUserName *string

	// READ-ONLY; Describes the port for connecting through SSH.
	SSHPort *int32
}

// ComputeInstanceSchema - Properties(top level) of ComputeInstance
type ComputeInstanceSchema struct {
	// Properties of ComputeInstance
	Properties *ComputeInstanceProperties
}

// ComputeInstanceVersion - Version of computeInstance.
type ComputeInstanceVersion struct {
	// Runtime of compute instance.
	Runtime *string
}

// ComputeResource - Machine Learning compute object wrapped into ARM resource envelope.
type ComputeResource struct {
	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Specifies the location of the resource.
	Location *string

	// Compute properties
	Properties ComputeClassification

	// The sku of the workspace.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ComputeResourceSchema struct {
	// Compute properties
	Properties ComputeClassification
}

// ComputeSchedules - The list of schedules to be applied on the computes
type ComputeSchedules struct {
	// The list of compute start stop schedules to be applied.
	ComputeStartStop []*ComputeStartStopSchedule
}

// ComputeSecrets - Secrets related to a Machine Learning compute. Might differ for every type of compute.
type ComputeSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type ComputeSecrets.
func (c *ComputeSecrets) GetComputeSecrets() *ComputeSecrets { return c }

// ComputeStartStopSchedule - Compute start stop schedule properties
type ComputeStartStopSchedule struct {
	// [Required] The compute power action.
	Action *ComputePowerAction

	// Required if triggerType is Cron.
	Cron *CronTrigger

	// Required if triggerType is Recurrence.
	Recurrence *RecurrenceTrigger

	// [Deprecated] Not used any more.
	Schedule *ScheduleBase

	// Is the schedule enabled or disabled?
	Status *ScheduleStatus

	// [Required] The schedule trigger type.
	TriggerType *TriggerType

	// READ-ONLY; A system assigned id for the schedule.
	ID *string

	// READ-ONLY; The current deployment state of schedule.
	ProvisioningStatus *ProvisioningStatus
}

// ContainerResourceRequirements - Resource requirements for each container instance within an online deployment.
type ContainerResourceRequirements struct {
	// Container resource limit info:
	ContainerResourceLimits *ContainerResourceSettings

	// Container resource request info:
	ContainerResourceRequests *ContainerResourceSettings
}

type ContainerResourceSettings struct {
	// Number of vCPUs request/limit for container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	CPU *string

	// Number of Nvidia GPU cards request/limit for container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	Gpu *string

	// Memory size request/limit for container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
	Memory *string
}

type CosmosDbSettings struct {
	// The throughput of the collections in cosmosdb database
	CollectionsThroughput *int32
}

type CronTrigger struct {
	// REQUIRED; [Required] Specifies cron expression of schedule. The expression should follow NCronTab format.
	Expression *string

	// REQUIRED; [Required]
	TriggerType *TriggerType

	// Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601. Recommented
	// format would be "2022-06-01T00:00:01" If not present, the schedule will
	// run indefinitely
	EndTime *string

	// Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
	StartTime *string

	// Specifies time zone in which the schedule runs. TimeZone should follow Windows time zone format. Refer:
	// https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
	TimeZone *string
}

// GetTriggerBase implements the TriggerBaseClassification interface for type CronTrigger.
func (c *CronTrigger) GetTriggerBase() *TriggerBase {
	return &TriggerBase{
		EndTime:     c.EndTime,
		StartTime:   c.StartTime,
		TimeZone:    c.TimeZone,
		TriggerType: c.TriggerType,
	}
}

// CustomForecastHorizon - The desired maximum forecast horizon in units of time-series frequency.
type CustomForecastHorizon struct {
	// REQUIRED; [Required] Set forecast horizon value selection mode.
	Mode *ForecastHorizonMode

	// REQUIRED; [Required] Forecast horizon value.
	Value *int32
}

// GetForecastHorizon implements the ForecastHorizonClassification interface for type CustomForecastHorizon.
func (c *CustomForecastHorizon) GetForecastHorizon() *ForecastHorizon {
	return &ForecastHorizon{
		Mode: c.Mode,
	}
}

type CustomModelJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Description for the input.
	Description *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// GetJobInput implements the JobInputClassification interface for type CustomModelJobInput.
func (c *CustomModelJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  c.Description,
		JobInputType: c.JobInputType,
	}
}

type CustomModelJobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string

	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// GetJobOutput implements the JobOutputClassification interface for type CustomModelJobOutput.
func (c *CustomModelJobOutput) GetJobOutput() *JobOutput {
	return &JobOutput{
		Description:   c.Description,
		JobOutputType: c.JobOutputType,
	}
}

// CustomNCrossValidations - N-Cross validations are specified by user.
type CustomNCrossValidations struct {
	// REQUIRED; [Required] Mode for determining N-Cross validations.
	Mode *NCrossValidationsMode

	// REQUIRED; [Required] N-Cross validations value.
	Value *int32
}

// GetNCrossValidations implements the NCrossValidationsClassification interface for type CustomNCrossValidations.
func (c *CustomNCrossValidations) GetNCrossValidations() *NCrossValidations {
	return &NCrossValidations{
		Mode: c.Mode,
	}
}

type CustomSeasonality struct {
	// REQUIRED; [Required] Seasonality mode.
	Mode *SeasonalityMode

	// REQUIRED; [Required] Seasonality value.
	Value *int32
}

// GetSeasonality implements the SeasonalityClassification interface for type CustomSeasonality.
func (c *CustomSeasonality) GetSeasonality() *Seasonality {
	return &Seasonality{
		Mode: c.Mode,
	}
}

type CustomTargetLags struct {
	// REQUIRED; [Required] Set target lags mode - Auto/Custom
	Mode *TargetLagsMode

	// REQUIRED; [Required] Set target lags values.
	Values []*int32
}

// GetTargetLags implements the TargetLagsClassification interface for type CustomTargetLags.
func (c *CustomTargetLags) GetTargetLags() *TargetLags {
	return &TargetLags{
		Mode: c.Mode,
	}
}

type CustomTargetRollingWindowSize struct {
	// REQUIRED; [Required] TargetRollingWindowSiz detection mode.
	Mode *TargetRollingWindowSizeMode

	// REQUIRED; [Required] TargetRollingWindowSize value.
	Value *int32
}

// GetTargetRollingWindowSize implements the TargetRollingWindowSizeClassification interface for type CustomTargetRollingWindowSize.
func (c *CustomTargetRollingWindowSize) GetTargetRollingWindowSize() *TargetRollingWindowSize {
	return &TargetRollingWindowSize{
		Mode: c.Mode,
	}
}

// DataContainer - Azure Resource Manager resource envelope.
type DataContainer struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *DataContainerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataContainerProperties - Container for data asset versions.
type DataContainerProperties struct {
	// REQUIRED; [Required] Specifies the type of data.
	DataType *DataType

	// The asset description text.
	Description *string

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; The latest version inside this container.
	LatestVersion *string

	// READ-ONLY; The next auto incremental version
	NextVersion *string
}

// DataContainerResourceArmPaginatedResult - A paginated list of DataContainer entities.
type DataContainerResourceArmPaginatedResult struct {
	// The link to the next page of DataContainer objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type DataContainer.
	Value []*DataContainer
}

// DataFactory - A DataFactory compute.
type DataFactory struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type DataFactory.
func (d *DataFactory) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    d.ComputeLocation,
		ComputeType:        d.ComputeType,
		CreatedOn:          d.CreatedOn,
		Description:        d.Description,
		DisableLocalAuth:   d.DisableLocalAuth,
		IsAttachedCompute:  d.IsAttachedCompute,
		ModifiedOn:         d.ModifiedOn,
		ProvisioningErrors: d.ProvisioningErrors,
		ProvisioningState:  d.ProvisioningState,
		ResourceID:         d.ResourceID,
	}
}

// DataLakeAnalytics - A DataLakeAnalytics compute.
type DataLakeAnalytics struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool
	Properties       *DataLakeAnalyticsSchemaProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type DataLakeAnalytics.
func (d *DataLakeAnalytics) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    d.ComputeLocation,
		ComputeType:        d.ComputeType,
		CreatedOn:          d.CreatedOn,
		Description:        d.Description,
		DisableLocalAuth:   d.DisableLocalAuth,
		IsAttachedCompute:  d.IsAttachedCompute,
		ModifiedOn:         d.ModifiedOn,
		ProvisioningErrors: d.ProvisioningErrors,
		ProvisioningState:  d.ProvisioningState,
		ResourceID:         d.ResourceID,
	}
}

type DataLakeAnalyticsSchema struct {
	Properties *DataLakeAnalyticsSchemaProperties
}

type DataLakeAnalyticsSchemaProperties struct {
	// DataLake Store Account Name
	DataLakeStoreAccountName *string
}

// DataPathAssetReference - Reference to an asset via its path in a datastore.
type DataPathAssetReference struct {
	// REQUIRED; [Required] Specifies the type of asset reference.
	ReferenceType *ReferenceType

	// ARM resource ID of the datastore where the asset is located.
	DatastoreID *string

	// The path of the file/directory in the datastore.
	Path *string
}

// GetAssetReferenceBase implements the AssetReferenceBaseClassification interface for type DataPathAssetReference.
func (d *DataPathAssetReference) GetAssetReferenceBase() *AssetReferenceBase {
	return &AssetReferenceBase{
		ReferenceType: d.ReferenceType,
	}
}

// DataVersionBase - Azure Resource Manager resource envelope.
type DataVersionBase struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties DataVersionBasePropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DataVersionBaseProperties - Data version base definition
type DataVersionBaseProperties struct {
	// REQUIRED; [Required] Specifies the type of data.
	DataType *DataType

	// REQUIRED; [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
	DataURI *string

	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// GetDataVersionBaseProperties implements the DataVersionBasePropertiesClassification interface for type DataVersionBaseProperties.
func (d *DataVersionBaseProperties) GetDataVersionBaseProperties() *DataVersionBaseProperties {
	return d
}

// DataVersionBaseResourceArmPaginatedResult - A paginated list of DataVersionBase entities.
type DataVersionBaseResourceArmPaginatedResult struct {
	// The link to the next page of DataVersionBase objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type DataVersionBase.
	Value []*DataVersionBase
}

// Databricks - A DataFactory compute.
type Databricks struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// Properties of Databricks
	Properties *DatabricksProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type Databricks.
func (d *Databricks) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    d.ComputeLocation,
		ComputeType:        d.ComputeType,
		CreatedOn:          d.CreatedOn,
		Description:        d.Description,
		DisableLocalAuth:   d.DisableLocalAuth,
		IsAttachedCompute:  d.IsAttachedCompute,
		ModifiedOn:         d.ModifiedOn,
		ProvisioningErrors: d.ProvisioningErrors,
		ProvisioningState:  d.ProvisioningState,
		ResourceID:         d.ResourceID,
	}
}

// DatabricksComputeSecrets - Secrets related to a Machine Learning compute based on Databricks.
type DatabricksComputeSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// access token for databricks account.
	DatabricksAccessToken *string
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type DatabricksComputeSecrets.
func (d *DatabricksComputeSecrets) GetComputeSecrets() *ComputeSecrets {
	return &ComputeSecrets{
		ComputeType: d.ComputeType,
	}
}

// DatabricksComputeSecretsProperties - Properties of Databricks Compute Secrets
type DatabricksComputeSecretsProperties struct {
	// access token for databricks account.
	DatabricksAccessToken *string
}

// DatabricksProperties - Properties of Databricks
type DatabricksProperties struct {
	// Databricks access token
	DatabricksAccessToken *string

	// Workspace Url
	WorkspaceURL *string
}

type DatabricksSchema struct {
	// Properties of Databricks
	Properties *DatabricksProperties
}

// Datastore - Azure Resource Manager resource envelope.
type Datastore struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties DatastorePropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// DatastoreCredentials - Base definition for datastore credentials.
type DatastoreCredentials struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	CredentialsType *CredentialsType
}

// GetDatastoreCredentials implements the DatastoreCredentialsClassification interface for type DatastoreCredentials.
func (d *DatastoreCredentials) GetDatastoreCredentials() *DatastoreCredentials { return d }

// DatastoreProperties - Base definition for datastore contents configuration.
type DatastoreProperties struct {
	// REQUIRED; [Required] Account credentials.
	Credentials DatastoreCredentialsClassification

	// REQUIRED; [Required] Storage type backing the datastore.
	DatastoreType *DatastoreType

	// The asset description text.
	Description *string

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Readonly property to indicate if datastore is the workspace default datastore
	IsDefault *bool
}

// GetDatastoreProperties implements the DatastorePropertiesClassification interface for type DatastoreProperties.
func (d *DatastoreProperties) GetDatastoreProperties() *DatastoreProperties { return d }

// DatastoreResourceArmPaginatedResult - A paginated list of Datastore entities.
type DatastoreResourceArmPaginatedResult struct {
	// The link to the next page of Datastore objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type Datastore.
	Value []*Datastore
}

// DatastoreSecrets - Base definition for datastore secrets.
type DatastoreSecrets struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	SecretsType *SecretsType
}

// GetDatastoreSecrets implements the DatastoreSecretsClassification interface for type DatastoreSecrets.
func (d *DatastoreSecrets) GetDatastoreSecrets() *DatastoreSecrets { return d }

type DefaultScaleSettings struct {
	// REQUIRED; [Required] Type of deployment scaling algorithm
	ScaleType *ScaleType
}

// GetOnlineScaleSettings implements the OnlineScaleSettingsClassification interface for type DefaultScaleSettings.
func (d *DefaultScaleSettings) GetOnlineScaleSettings() *OnlineScaleSettings {
	return &OnlineScaleSettings{
		ScaleType: d.ScaleType,
	}
}

type DeploymentLogs struct {
	// The retrieved online deployment logs.
	Content *string
}

type DeploymentLogsRequest struct {
	// The type of container to retrieve logs from.
	ContainerType *ContainerType

	// The maximum number of lines to tail.
	Tail *int32
}

type DeploymentResourceConfiguration struct {
	// Optional number of instances or nodes used by the compute target.
	InstanceCount *int32

	// Optional type of VM used as supported by the compute target.
	InstanceType *string

	// Additional properties bag.
	Properties map[string]any
}

type DiagnoseRequestProperties struct {
	// Setting for diagnosing dependent application insights
	ApplicationInsights map[string]any

	// Setting for diagnosing dependent container registry
	ContainerRegistry map[string]any

	// Setting for diagnosing dns resolution
	DNSResolution map[string]any

	// Setting for diagnosing dependent key vault
	KeyVault map[string]any

	// Setting for diagnosing network security group
	Nsg map[string]any

	// Setting for diagnosing unclassified category of problems
	Others map[string]any

	// Setting for diagnosing resource lock
	ResourceLock map[string]any

	// Setting for diagnosing dependent storage account
	StorageAccount map[string]any

	// Setting for diagnosing user defined routing
	Udr map[string]any
}

type DiagnoseResponseResult struct {
	Value *DiagnoseResponseResultValue
}

type DiagnoseResponseResultValue struct {
	ApplicationInsightsResults []*DiagnoseResult
	ContainerRegistryResults   []*DiagnoseResult
	DNSResolutionResults       []*DiagnoseResult
	KeyVaultResults            []*DiagnoseResult
	NetworkSecurityRuleResults []*DiagnoseResult
	OtherResults               []*DiagnoseResult
	ResourceLockResults        []*DiagnoseResult
	StorageAccountResults      []*DiagnoseResult
	UserDefinedRouteResults    []*DiagnoseResult
}

// DiagnoseResult - Result of Diagnose
type DiagnoseResult struct {
	// READ-ONLY; Code for workspace setup error
	Code *string

	// READ-ONLY; Level of workspace setup error
	Level *DiagnoseResultLevel

	// READ-ONLY; Message of workspace setup error
	Message *string
}

// DiagnoseWorkspaceParameters - Parameters to diagnose a workspace
type DiagnoseWorkspaceParameters struct {
	// Value of Parameters
	Value *DiagnoseRequestProperties
}

// DistributionConfiguration - Base definition for job distribution configuration.
type DistributionConfiguration struct {
	// REQUIRED; [Required] Specifies the type of distribution framework.
	DistributionType *DistributionType
}

// GetDistributionConfiguration implements the DistributionConfigurationClassification interface for type DistributionConfiguration.
func (d *DistributionConfiguration) GetDistributionConfiguration() *DistributionConfiguration {
	return d
}

// EarlyTerminationPolicy - Early termination policies enable canceling poor-performing runs before they complete
type EarlyTerminationPolicy struct {
	// REQUIRED; [Required] Name of policy configuration
	PolicyType *EarlyTerminationPolicyType

	// Number of intervals by which to delay the first evaluation.
	DelayEvaluation *int32

	// Interval (number of runs) between policy evaluations.
	EvaluationInterval *int32
}

// GetEarlyTerminationPolicy implements the EarlyTerminationPolicyClassification interface for type EarlyTerminationPolicy.
func (e *EarlyTerminationPolicy) GetEarlyTerminationPolicy() *EarlyTerminationPolicy { return e }

type EncryptionKeyVaultProperties struct {
	// REQUIRED; Key vault uri to access the encryption key.
	KeyIdentifier *string

	// REQUIRED; The ArmId of the keyVault where the customer owned encryption key is present.
	KeyVaultArmID *string

	// For future use - The client id of the identity which will be used to access key vault.
	IdentityClientID *string
}

type EncryptionProperty struct {
	// REQUIRED; Customer Key vault properties.
	KeyVaultProperties *EncryptionKeyVaultProperties

	// REQUIRED; Indicates whether or not the encryption is enabled for the workspace.
	Status *EncryptionStatus

	// The identity that will be used to access the key vault for encryption at rest.
	Identity *IdentityForCmk
}

// EndpointAuthKeys - Keys for endpoint authentication.
type EndpointAuthKeys struct {
	// The primary key.
	PrimaryKey *string

	// The secondary key.
	SecondaryKey *string
}

// EndpointAuthToken - Service Token
type EndpointAuthToken struct {
	// Access token for endpoint authentication.
	AccessToken *string

	// Access token expiry time (UTC).
	ExpiryTimeUTC *int64

	// Refresh access token after time (UTC).
	RefreshAfterTimeUTC *int64

	// Access token type.
	TokenType *string
}

// EndpointDeploymentPropertiesBase - Base definition for endpoint deployment.
type EndpointDeploymentPropertiesBase struct {
	// Code configuration for the endpoint deployment.
	CodeConfiguration *CodeConfiguration

	// Description of the endpoint deployment.
	Description *string

	// ARM resource ID or AssetId of the environment specification for the endpoint deployment.
	EnvironmentID *string

	// Environment variables configuration for the deployment.
	EnvironmentVariables map[string]*string

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string
}

// EndpointPropertiesBase - Inference Endpoint base definition
type EndpointPropertiesBase struct {
	// REQUIRED; [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication.
	// 'Key' doesn't expire but 'AMLToken' does.
	AuthMode *EndpointAuthMode

	// Description of the inference endpoint.
	Description *string

	// EndpointAuthKeys to set initially on an Endpoint. This property will always be returned as null. AuthKey values must be
	// retrieved using the ListKeys API.
	Keys *EndpointAuthKeys

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// READ-ONLY; Endpoint URI.
	ScoringURI *string

	// READ-ONLY; Endpoint Swagger URI.
	SwaggerURI *string
}

type EndpointScheduleAction struct {
	// REQUIRED; [Required] Specifies the action type of the schedule
	ActionType *ScheduleActionType

	// REQUIRED; [Required] Defines Schedule action definition details.
	EndpointInvocationDefinition any
}

// GetScheduleActionBase implements the ScheduleActionBaseClassification interface for type EndpointScheduleAction.
func (e *EndpointScheduleAction) GetScheduleActionBase() *ScheduleActionBase {
	return &ScheduleActionBase{
		ActionType: e.ActionType,
	}
}

// EnvironmentContainer - Azure Resource Manager resource envelope.
type EnvironmentContainer struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *EnvironmentContainerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EnvironmentContainerProperties - Container for environment specification versions.
type EnvironmentContainerProperties struct {
	// The asset description text.
	Description *string

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; The latest version inside this container.
	LatestVersion *string

	// READ-ONLY; The next auto incremental version
	NextVersion *string
}

// EnvironmentContainerResourceArmPaginatedResult - A paginated list of EnvironmentContainer entities.
type EnvironmentContainerResourceArmPaginatedResult struct {
	// The link to the next page of EnvironmentContainer objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type EnvironmentContainer.
	Value []*EnvironmentContainer
}

// EnvironmentVersion - Azure Resource Manager resource envelope.
type EnvironmentVersion struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *EnvironmentVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// EnvironmentVersionProperties - Environment version details.
type EnvironmentVersionProperties struct {
	// Defines if image needs to be rebuilt based on base image changes.
	AutoRebuild *AutoRebuildSetting

	// Configuration settings for Docker build context.
	Build *BuildContext

	// Standard configuration file used by Conda that lets you install any kind of package, including Python, R, and C/C++ packages.
	CondaFile *string

	// The asset description text.
	Description *string

	// Name of the image that will be used for the environment.
	Image *string

	// Defines configuration specific to inference.
	InferenceConfig *InferenceContainerProperties

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The OS type of the environment.
	OSType *OperatingSystemType

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Environment type is either user managed or curated by the Azure ML service
	EnvironmentType *EnvironmentType
}

// EnvironmentVersionResourceArmPaginatedResult - A paginated list of EnvironmentVersion entities.
type EnvironmentVersionResourceArmPaginatedResult struct {
	// The link to the next page of EnvironmentVersion objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type EnvironmentVersion.
	Value []*EnvironmentVersion
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// EstimatedVMPrice - The estimated price info for using a VM of a particular OS type, tier, etc.
type EstimatedVMPrice struct {
	// REQUIRED; Operating system type used by the VM.
	OSType *VMPriceOSType

	// REQUIRED; The price charged for using the VM.
	RetailPrice *float64

	// REQUIRED; The type of the VM.
	VMTier *VMTier
}

// EstimatedVMPrices - The estimated price info for using a VM.
type EstimatedVMPrices struct {
	// REQUIRED; Three lettered code specifying the currency of the VM price. Example: USD
	BillingCurrency *BillingCurrency

	// REQUIRED; The unit of time measurement for the specified VM price. Example: OneHour
	UnitOfMeasure *UnitOfMeasure

	// REQUIRED; The list of estimated prices for using a VM of a particular OS type, tier, etc.
	Values []*EstimatedVMPrice
}

type ExternalFQDNResponse struct {
	Value []*FQDNEndpoints
}

type FQDNEndpoint struct {
	DomainName      *string
	EndpointDetails []*FQDNEndpointDetail
}

type FQDNEndpointDetail struct {
	Port *int32
}

type FQDNEndpoints struct {
	Properties *FQDNEndpointsProperties
}

type FQDNEndpointsProperties struct {
	Category  *string
	Endpoints []*FQDNEndpoint
}

// FeaturizationSettings - Featurization Configuration.
type FeaturizationSettings struct {
	// Dataset language, useful for the text data.
	DatasetLanguage *string
}

type FlavorData struct {
	// Model flavor-specific data.
	Data map[string]*string
}

// ForecastHorizon - The desired maximum forecast horizon in units of time-series frequency.
type ForecastHorizon struct {
	// REQUIRED; [Required] Set forecast horizon value selection mode.
	Mode *ForecastHorizonMode
}

// GetForecastHorizon implements the ForecastHorizonClassification interface for type ForecastHorizon.
func (f *ForecastHorizon) GetForecastHorizon() *ForecastHorizon { return f }

// Forecasting task in AutoML Table vertical.
type Forecasting struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Columns to use for CVSplit data.
	CvSplitColumnNames []*string

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *TableVerticalFeaturizationSettings

	// Forecasting task specific inputs.
	ForecastingSettings *ForecastingSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *TableVerticalLimitSettings

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Number of cross validation folds to be applied on training dataset when validation dataset is not provided.
	NCrossValidations NCrossValidationsClassification

	// Primary metric for forecasting task.
	PrimaryMetric *ForecastingPrimaryMetrics

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Test data input.
	TestData *MLTableJobInput

	// The fraction of test dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied when
	// validation dataset is not provided.
	TestDataSize *float64

	// Inputs for training phase for an AutoML Job.
	TrainingSettings *ForecastingTrainingSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64

	// The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to
	// be weighted up or down.
	WeightColumnName *string
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type Forecasting.
func (f *Forecasting) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     f.LogVerbosity,
		TargetColumnName: f.TargetColumnName,
		TaskType:         f.TaskType,
		TrainingData:     f.TrainingData,
	}
}

// ForecastingSettings - Forecasting specific parameters.
type ForecastingSettings struct {
	// Country or region for holidays for forecasting tasks. These should be ISO 3166 two-letter country/region codes, for example
	// 'US' or 'GB'.
	CountryOrRegionForHolidays *string

	// Number of periods between the origin time of one CV fold and the next fold. For example, if CVStepSize = 3 for daily data,
	// the origin time for each fold will be three days apart.
	CvStepSize *int32

	// Flag for generating lags for the numeric features with 'auto' or null.
	FeatureLags *FeatureLags

	// The desired maximum forecast horizon in units of time-series frequency.
	ForecastHorizon ForecastHorizonClassification

	// When forecasting, this parameter represents the period with which the forecast is desired, for example daily, weekly, yearly,
	// etc. The forecast frequency is dataset frequency by default.
	Frequency *string

	// Set time series seasonality as an integer multiple of the series frequency. If seasonality is set to 'auto', it will be
	// inferred.
	Seasonality SeasonalityClassification

	// The parameter defining how if AutoML should handle short time series.
	ShortSeriesHandlingConfig *ShortSeriesHandlingConfiguration

	// The function to be used to aggregate the time series target column to conform to a user specified frequency. If the TargetAggregateFunction
	// is set i.e. not 'None', but the freq parameter is not set,
	// the error is raised. The possible target aggregation functions are: "sum", "max", "min" and "mean".
	TargetAggregateFunction *TargetAggregationFunction

	// The number of past periods to lag from the target column.
	TargetLags TargetLagsClassification

	// The number of past periods used to create a rolling window average of the target column.
	TargetRollingWindowSize TargetRollingWindowSizeClassification

	// The name of the time column. This parameter is required when forecasting to specify the datetime column in the input data
	// used for building the time series and inferring its frequency.
	TimeColumnName *string

	// The names of columns used to group a timeseries. It can be used to create multiple series. If grain is not defined, the
	// data set is assumed to be one time-series. This parameter is used with task type
	// forecasting.
	TimeSeriesIDColumnNames []*string

	// Configure STL Decomposition of the time-series target column.
	UseStl *UseStl
}

// ForecastingTrainingSettings - Forecasting Training related configuration.
type ForecastingTrainingSettings struct {
	// Allowed models for forecasting task.
	AllowedTrainingAlgorithms []*ForecastingModels

	// Blocked models for forecasting task.
	BlockedTrainingAlgorithms []*ForecastingModels

	// Enable recommendation of DNN models.
	EnableDnnTraining *bool

	// Flag to turn on explainability on best model.
	EnableModelExplainability *bool

	// Flag for enabling onnx compatible models.
	EnableOnnxCompatibleModels *bool

	// Enable stack ensemble run.
	EnableStackEnsemble *bool

	// Enable voting ensemble run.
	EnableVoteEnsemble *bool

	// During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
	// Configure this parameter with a higher value than 300 secs, if more time
	// is needed.
	EnsembleModelDownloadTimeout *string

	// Stack ensemble settings for stack ensemble run.
	StackEnsembleSettings *StackEnsembleSettings
}

// GridSamplingAlgorithm - Defines a Sampling Algorithm that exhaustively generates every value combination in the space
type GridSamplingAlgorithm struct {
	// REQUIRED; [Required] The algorithm used for generating hyperparameter values, along with configuration properties
	SamplingAlgorithmType *SamplingAlgorithmType
}

// GetSamplingAlgorithm implements the SamplingAlgorithmClassification interface for type GridSamplingAlgorithm.
func (g *GridSamplingAlgorithm) GetSamplingAlgorithm() *SamplingAlgorithm {
	return &SamplingAlgorithm{
		SamplingAlgorithmType: g.SamplingAlgorithmType,
	}
}

// HDInsight - A HDInsight compute.
type HDInsight struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// HDInsight compute properties
	Properties *HDInsightProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type HDInsight.
func (h *HDInsight) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    h.ComputeLocation,
		ComputeType:        h.ComputeType,
		CreatedOn:          h.CreatedOn,
		Description:        h.Description,
		DisableLocalAuth:   h.DisableLocalAuth,
		IsAttachedCompute:  h.IsAttachedCompute,
		ModifiedOn:         h.ModifiedOn,
		ProvisioningErrors: h.ProvisioningErrors,
		ProvisioningState:  h.ProvisioningState,
		ResourceID:         h.ResourceID,
	}
}

// HDInsightProperties - HDInsight compute properties
type HDInsightProperties struct {
	// Public IP address of the master node of the cluster.
	Address *string

	// Admin credentials for master node of the cluster
	AdministratorAccount *VirtualMachineSSHCredentials

	// Port open for ssh connections on the master node of the cluster.
	SSHPort *int32
}

type HDInsightSchema struct {
	// HDInsight compute properties
	Properties *HDInsightProperties
}

// IDAssetReference - Reference to an asset via its ARM resource ID.
type IDAssetReference struct {
	// REQUIRED; [Required] ARM resource ID of the asset.
	AssetID *string

	// REQUIRED; [Required] Specifies the type of asset reference.
	ReferenceType *ReferenceType
}

// GetAssetReferenceBase implements the AssetReferenceBaseClassification interface for type IDAssetReference.
func (i *IDAssetReference) GetAssetReferenceBase() *AssetReferenceBase {
	return &AssetReferenceBase{
		ReferenceType: i.ReferenceType,
	}
}

// IdentityConfiguration - Base definition for identity configuration.
type IdentityConfiguration struct {
	// REQUIRED; [Required] Specifies the type of identity framework.
	IdentityType *IdentityConfigurationType
}

// GetIdentityConfiguration implements the IdentityConfigurationClassification interface for type IdentityConfiguration.
func (i *IdentityConfiguration) GetIdentityConfiguration() *IdentityConfiguration { return i }

// IdentityForCmk - Identity that will be used to access key vault for encryption at rest
type IdentityForCmk struct {
	// The ArmId of the user assigned identity that will be used to access the customer managed key vault
	UserAssignedIdentity *string
}

// ImageClassification - Image Classification. Multi-class image classification is used when an image is classified with only
// a single label from a set of classes - e.g. each image is classified as either an image of a 'cat'
// or a 'dog' or a 'duck'.
type ImageClassification struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Settings used for training the model.
	ModelSettings *ImageModelSettingsClassification

	// Primary metric to optimize for this task.
	PrimaryMetric *ClassificationPrimaryMetrics

	// Search space for sampling different combinations of models and their hyperparameters.
	SearchSpace []*ImageModelDistributionSettingsClassification

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type ImageClassification.
func (i *ImageClassification) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     i.LogVerbosity,
		TargetColumnName: i.TargetColumnName,
		TaskType:         i.TaskType,
		TrainingData:     i.TrainingData,
	}
}

type ImageClassificationBase struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// Settings used for training the model.
	ModelSettings *ImageModelSettingsClassification

	// Search space for sampling different combinations of models and their hyperparameters.
	SearchSpace []*ImageModelDistributionSettingsClassification

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

// ImageClassificationMultilabel - Image Classification Multilabel. Multi-label image classification is used when an image
// could have one or more labels from a set of labels - e.g. an image could be labeled with both 'cat' and 'dog'.
type ImageClassificationMultilabel struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Settings used for training the model.
	ModelSettings *ImageModelSettingsClassification

	// Primary metric to optimize for this task.
	PrimaryMetric *ClassificationMultilabelPrimaryMetrics

	// Search space for sampling different combinations of models and their hyperparameters.
	SearchSpace []*ImageModelDistributionSettingsClassification

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type ImageClassificationMultilabel.
func (i *ImageClassificationMultilabel) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     i.LogVerbosity,
		TargetColumnName: i.TargetColumnName,
		TaskType:         i.TaskType,
		TrainingData:     i.TrainingData,
	}
}

// ImageInstanceSegmentation - Image Instance Segmentation. Instance segmentation is used to identify objects in an image
// at the pixel level, drawing a polygon around each object in the image.
type ImageInstanceSegmentation struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Settings used for training the model.
	ModelSettings *ImageModelSettingsObjectDetection

	// Primary metric to optimize for this task.
	PrimaryMetric *InstanceSegmentationPrimaryMetrics

	// Search space for sampling different combinations of models and their hyperparameters.
	SearchSpace []*ImageModelDistributionSettingsObjectDetection

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type ImageInstanceSegmentation.
func (i *ImageInstanceSegmentation) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     i.LogVerbosity,
		TargetColumnName: i.TargetColumnName,
		TaskType:         i.TaskType,
		TrainingData:     i.TrainingData,
	}
}

// ImageLimitSettings - Limit settings for the AutoML job.
type ImageLimitSettings struct {
	// Maximum number of concurrent AutoML iterations.
	MaxConcurrentTrials *int32

	// Maximum number of AutoML iterations.
	MaxTrials *int32

	// AutoML job timeout.
	Timeout *string
}

// ImageModelDistributionSettings - Distribution expressions to sweep over values of model settings.Some examples are:ModelName
// = "choice('seresnext', 'resnest50')"; LearningRate = "uniform(0.001, 0.01)"; LayersToFreeze = "choice(0,
// 2)";All distributions can be specified as distribution_name(min, max) or choice(val1, val2, …, valn) where distribution
// name can be: uniform, quniform, loguniform, etc For more details on how to
// compose distribution expressions please check the documentation: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
// For more information on the available settings
// please visit the official documentation: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
type ImageModelDistributionSettings struct {
	// Enable AMSGrad when optimizer is 'adam' or 'adamw'.
	AmsGradient *string

	// Settings for using Augmentations.
	Augmentations *string

	// Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta1 *string

	// Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta2 *string

	// Whether to use distributer training.
	Distributed *string

	// Enable early stopping logic during training.
	EarlyStopping *string

	// Minimum number of epochs or validation evaluations to wait before primary metric improvement is tracked for early stopping.
	// Must be a positive integer.
	EarlyStoppingDelay *string

	// Minimum number of epochs or validation evaluations with no primary metric improvement before the run is stopped. Must be
	// a positive integer.
	EarlyStoppingPatience *string

	// Enable normalization when exporting ONNX model.
	EnableOnnxNormalization *string

	// Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
	EvaluationFrequency *string

	// Gradient accumulation means running a configured number of "GradAccumulationStep" steps without updating the model weights
	// while accumulating the gradients of those steps, and then using the
	// accumulated gradients to compute the weight updates. Must be a positive integer.
	GradientAccumulationStep *string

	// Number of layers to freeze for the model. Must be a positive integer. For instance, passing 2 as value for 'seresnext'
	// means freezing layer0 and layer1. For a full list of models supported and details
	// on layer freeze, please see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	LayersToFreeze *string

	// Initial learning rate. Must be a float in the range [0, 1].
	LearningRate *string

	// Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
	LearningRateScheduler *string

	// Name of the model to use for training. For more information on the available models please visit the official documentation:
	// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	ModelName *string

	// Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
	Momentum *string

	// Enable nesterov when optimizer is 'sgd'.
	Nesterov *string

	// Number of training epochs. Must be a positive integer.
	NumberOfEpochs *string

	// Number of data loader workers. Must be a non-negative integer.
	NumberOfWorkers *string

	// Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
	Optimizer *string

	// Random seed to be used when using deterministic training.
	RandomSeed *string

	// Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
	StepLRGamma *string

	// Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
	StepLRStepSize *string

	// Training batch size. Must be a positive integer.
	TrainingBatchSize *string

	// Validation batch size. Must be a positive integer.
	ValidationBatchSize *string

	// Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
	WarmupCosineLRCycles *string

	// Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
	WarmupCosineLRWarmupEpochs *string

	// Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
	WeightDecay *string
}

// ImageModelDistributionSettingsClassification - Distribution expressions to sweep over values of model settings.Some examples
// are:ModelName = "choice('seresnext', 'resnest50')"; LearningRate = "uniform(0.001, 0.01)"; LayersToFreeze = "choice(0,
// 2)";For more details on how to compose distribution expressions please check the documentation: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
// For more information
// on the available settings please visit the official documentation: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
type ImageModelDistributionSettingsClassification struct {
	// Enable AMSGrad when optimizer is 'adam' or 'adamw'.
	AmsGradient *string

	// Settings for using Augmentations.
	Augmentations *string

	// Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta1 *string

	// Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta2 *string

	// Whether to use distributer training.
	Distributed *string

	// Enable early stopping logic during training.
	EarlyStopping *string

	// Minimum number of epochs or validation evaluations to wait before primary metric improvement is tracked for early stopping.
	// Must be a positive integer.
	EarlyStoppingDelay *string

	// Minimum number of epochs or validation evaluations with no primary metric improvement before the run is stopped. Must be
	// a positive integer.
	EarlyStoppingPatience *string

	// Enable normalization when exporting ONNX model.
	EnableOnnxNormalization *string

	// Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
	EvaluationFrequency *string

	// Gradient accumulation means running a configured number of "GradAccumulationStep" steps without updating the model weights
	// while accumulating the gradients of those steps, and then using the
	// accumulated gradients to compute the weight updates. Must be a positive integer.
	GradientAccumulationStep *string

	// Number of layers to freeze for the model. Must be a positive integer. For instance, passing 2 as value for 'seresnext'
	// means freezing layer0 and layer1. For a full list of models supported and details
	// on layer freeze, please see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	LayersToFreeze *string

	// Initial learning rate. Must be a float in the range [0, 1].
	LearningRate *string

	// Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
	LearningRateScheduler *string

	// Name of the model to use for training. For more information on the available models please visit the official documentation:
	// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	ModelName *string

	// Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
	Momentum *string

	// Enable nesterov when optimizer is 'sgd'.
	Nesterov *string

	// Number of training epochs. Must be a positive integer.
	NumberOfEpochs *string

	// Number of data loader workers. Must be a non-negative integer.
	NumberOfWorkers *string

	// Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
	Optimizer *string

	// Random seed to be used when using deterministic training.
	RandomSeed *string

	// Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
	StepLRGamma *string

	// Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
	StepLRStepSize *string

	// Training batch size. Must be a positive integer.
	TrainingBatchSize *string

	// Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
	TrainingCropSize *string

	// Validation batch size. Must be a positive integer.
	ValidationBatchSize *string

	// Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
	ValidationCropSize *string

	// Image size to which to resize before cropping for validation dataset. Must be a positive integer.
	ValidationResizeSize *string

	// Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
	WarmupCosineLRCycles *string

	// Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
	WarmupCosineLRWarmupEpochs *string

	// Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
	WeightDecay *string

	// Weighted loss. The accepted values are 0 for no weighted loss. 1 for weighted loss with sqrt.(classweights). 2 for weighted
	// loss with classweights. Must be 0 or 1 or 2.
	WeightedLoss *string
}

// ImageModelDistributionSettingsObjectDetection - Distribution expressions to sweep over values of model settings.Some examples
// are:ModelName = "choice('seresnext', 'resnest50')"; LearningRate = "uniform(0.001, 0.01)"; LayersToFreeze = "choice(0,
// 2)";For more details on how to compose distribution expressions please check the documentation: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-tune-hyperparameters
// For more information
// on the available settings please visit the official documentation: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
type ImageModelDistributionSettingsObjectDetection struct {
	// Enable AMSGrad when optimizer is 'adam' or 'adamw'.
	AmsGradient *string

	// Settings for using Augmentations.
	Augmentations *string

	// Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta1 *string

	// Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta2 *string

	// Maximum number of detections per image, for all classes. Must be a positive integer. Note: This settings is not supported
	// for the 'yolov5' algorithm.
	BoxDetectionsPerImage *string

	// During inference, only return proposals with a classification score greater than BoxScoreThreshold. Must be a float in
	// the range[0, 1].
	BoxScoreThreshold *string

	// Whether to use distributer training.
	Distributed *string

	// Enable early stopping logic during training.
	EarlyStopping *string

	// Minimum number of epochs or validation evaluations to wait before primary metric improvement is tracked for early stopping.
	// Must be a positive integer.
	EarlyStoppingDelay *string

	// Minimum number of epochs or validation evaluations with no primary metric improvement before the run is stopped. Must be
	// a positive integer.
	EarlyStoppingPatience *string

	// Enable normalization when exporting ONNX model.
	EnableOnnxNormalization *string

	// Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
	EvaluationFrequency *string

	// Gradient accumulation means running a configured number of "GradAccumulationStep" steps without updating the model weights
	// while accumulating the gradients of those steps, and then using the
	// accumulated gradients to compute the weight updates. Must be a positive integer.
	GradientAccumulationStep *string

	// Image size for train and validation. Must be a positive integer. Note: The training run may get into CUDA OOM if the size
	// is too big. Note: This settings is only supported for the 'yolov5' algorithm.
	ImageSize *string

	// Number of layers to freeze for the model. Must be a positive integer. For instance, passing 2 as value for 'seresnext'
	// means freezing layer0 and layer1. For a full list of models supported and details
	// on layer freeze, please see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	LayersToFreeze *string

	// Initial learning rate. Must be a float in the range [0, 1].
	LearningRate *string

	// Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
	LearningRateScheduler *string

	// Maximum size of the image to be rescaled before feeding it to the backbone. Must be a positive integer. Note: training
	// run may get into CUDA OOM if the size is too big. Note: This settings is not
	// supported for the 'yolov5' algorithm.
	MaxSize *string

	// Minimum size of the image to be rescaled before feeding it to the backbone. Must be a positive integer. Note: training
	// run may get into CUDA OOM if the size is too big. Note: This settings is not
	// supported for the 'yolov5' algorithm.
	MinSize *string

	// Name of the model to use for training. For more information on the available models please visit the official documentation:
	// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	ModelName *string

	// Model size. Must be 'small', 'medium', 'large', or 'xlarge'. Note: training run may get into CUDA OOM if the model size
	// is too big. Note: This settings is only supported for the 'yolov5' algorithm.
	ModelSize *string

	// Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
	Momentum *string

	// Enable multi-scale image by varying image size by +/- 50%. Note: training run may get into CUDA OOM if no sufficient GPU
	// memory. Note: This settings is only supported for the 'yolov5' algorithm.
	MultiScale *string

	// Enable nesterov when optimizer is 'sgd'.
	Nesterov *string

	// IOU threshold used during inference in NMS post processing. Must be float in the range [0, 1].
	NmsIouThreshold *string

	// Number of training epochs. Must be a positive integer.
	NumberOfEpochs *string

	// Number of data loader workers. Must be a non-negative integer.
	NumberOfWorkers *string

	// Type of optimizer. Must be either 'sgd', 'adam', or 'adamw'.
	Optimizer *string

	// Random seed to be used when using deterministic training.
	RandomSeed *string

	// Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
	StepLRGamma *string

	// Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
	StepLRStepSize *string

	// The grid size to use for tiling each image. Note: TileGridSize must not be None to enable small object detection logic.
	// A string containing two integers in mxn format. Note: This settings is not
	// supported for the 'yolov5' algorithm.
	TileGridSize *string

	// Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1). Note: This settings is not supported
	// for the 'yolov5' algorithm.
	TileOverlapRatio *string

	// The IOU threshold to use to perform NMS while merging predictions from tiles and image. Used in validation/ inference.
	// Must be float in the range [0, 1]. Note: This settings is not supported for the
	// 'yolov5' algorithm. NMS: Non-maximum suppression
	TilePredictionsNmsThreshold *string

	// Training batch size. Must be a positive integer.
	TrainingBatchSize *string

	// Validation batch size. Must be a positive integer.
	ValidationBatchSize *string

	// IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
	ValidationIouThreshold *string

	// Metric computation method to use for validation metrics. Must be 'none', 'coco', 'voc', or 'coco_voc'.
	ValidationMetricType *string

	// Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
	WarmupCosineLRCycles *string

	// Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
	WarmupCosineLRWarmupEpochs *string

	// Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
	WeightDecay *string
}

// ImageModelSettings - Settings used for training the model. For more information on the available settings please visit
// the official documentation:
// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
type ImageModelSettings struct {
	// Settings for advanced scenarios.
	AdvancedSettings *string

	// Enable AMSGrad when optimizer is 'adam' or 'adamw'.
	AmsGradient *bool

	// Settings for using Augmentations.
	Augmentations *string

	// Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta1 *float32

	// Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta2 *float32

	// Frequency to store model checkpoints. Must be a positive integer.
	CheckpointFrequency *int32

	// The pretrained checkpoint model for incremental training.
	CheckpointModel *MLFlowModelJobInput

	// The id of a previous run that has a pretrained checkpoint for incremental training.
	CheckpointRunID *string

	// Whether to use distributed training.
	Distributed *bool

	// Enable early stopping logic during training.
	EarlyStopping *bool

	// Minimum number of epochs or validation evaluations to wait before primary metric improvement is tracked for early stopping.
	// Must be a positive integer.
	EarlyStoppingDelay *int32

	// Minimum number of epochs or validation evaluations with no primary metric improvement before the run is stopped. Must be
	// a positive integer.
	EarlyStoppingPatience *int32

	// Enable normalization when exporting ONNX model.
	EnableOnnxNormalization *bool

	// Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
	EvaluationFrequency *int32

	// Gradient accumulation means running a configured number of "GradAccumulationStep" steps without updating the model weights
	// while accumulating the gradients of those steps, and then using the
	// accumulated gradients to compute the weight updates. Must be a positive integer.
	GradientAccumulationStep *int32

	// Number of layers to freeze for the model. Must be a positive integer. For instance, passing 2 as value for 'seresnext'
	// means freezing layer0 and layer1. For a full list of models supported and details
	// on layer freeze, please see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	LayersToFreeze *int32

	// Initial learning rate. Must be a float in the range [0, 1].
	LearningRate *float32

	// Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
	LearningRateScheduler *LearningRateScheduler

	// Name of the model to use for training. For more information on the available models please visit the official documentation:
	// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	ModelName *string

	// Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
	Momentum *float32

	// Enable nesterov when optimizer is 'sgd'.
	Nesterov *bool

	// Number of training epochs. Must be a positive integer.
	NumberOfEpochs *int32

	// Number of data loader workers. Must be a non-negative integer.
	NumberOfWorkers *int32

	// Type of optimizer.
	Optimizer *StochasticOptimizer

	// Random seed to be used when using deterministic training.
	RandomSeed *int32

	// Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
	StepLRGamma *float32

	// Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
	StepLRStepSize *int32

	// Training batch size. Must be a positive integer.
	TrainingBatchSize *int32

	// Validation batch size. Must be a positive integer.
	ValidationBatchSize *int32

	// Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
	WarmupCosineLRCycles *float32

	// Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
	WarmupCosineLRWarmupEpochs *int32

	// Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
	WeightDecay *float32
}

// ImageModelSettingsClassification - Settings used for training the model. For more information on the available settings
// please visit the official documentation:
// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
type ImageModelSettingsClassification struct {
	// Settings for advanced scenarios.
	AdvancedSettings *string

	// Enable AMSGrad when optimizer is 'adam' or 'adamw'.
	AmsGradient *bool

	// Settings for using Augmentations.
	Augmentations *string

	// Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta1 *float32

	// Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta2 *float32

	// Frequency to store model checkpoints. Must be a positive integer.
	CheckpointFrequency *int32

	// The pretrained checkpoint model for incremental training.
	CheckpointModel *MLFlowModelJobInput

	// The id of a previous run that has a pretrained checkpoint for incremental training.
	CheckpointRunID *string

	// Whether to use distributed training.
	Distributed *bool

	// Enable early stopping logic during training.
	EarlyStopping *bool

	// Minimum number of epochs or validation evaluations to wait before primary metric improvement is tracked for early stopping.
	// Must be a positive integer.
	EarlyStoppingDelay *int32

	// Minimum number of epochs or validation evaluations with no primary metric improvement before the run is stopped. Must be
	// a positive integer.
	EarlyStoppingPatience *int32

	// Enable normalization when exporting ONNX model.
	EnableOnnxNormalization *bool

	// Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
	EvaluationFrequency *int32

	// Gradient accumulation means running a configured number of "GradAccumulationStep" steps without updating the model weights
	// while accumulating the gradients of those steps, and then using the
	// accumulated gradients to compute the weight updates. Must be a positive integer.
	GradientAccumulationStep *int32

	// Number of layers to freeze for the model. Must be a positive integer. For instance, passing 2 as value for 'seresnext'
	// means freezing layer0 and layer1. For a full list of models supported and details
	// on layer freeze, please see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	LayersToFreeze *int32

	// Initial learning rate. Must be a float in the range [0, 1].
	LearningRate *float32

	// Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
	LearningRateScheduler *LearningRateScheduler

	// Name of the model to use for training. For more information on the available models please visit the official documentation:
	// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	ModelName *string

	// Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
	Momentum *float32

	// Enable nesterov when optimizer is 'sgd'.
	Nesterov *bool

	// Number of training epochs. Must be a positive integer.
	NumberOfEpochs *int32

	// Number of data loader workers. Must be a non-negative integer.
	NumberOfWorkers *int32

	// Type of optimizer.
	Optimizer *StochasticOptimizer

	// Random seed to be used when using deterministic training.
	RandomSeed *int32

	// Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
	StepLRGamma *float32

	// Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
	StepLRStepSize *int32

	// Training batch size. Must be a positive integer.
	TrainingBatchSize *int32

	// Image crop size that is input to the neural network for the training dataset. Must be a positive integer.
	TrainingCropSize *int32

	// Validation batch size. Must be a positive integer.
	ValidationBatchSize *int32

	// Image crop size that is input to the neural network for the validation dataset. Must be a positive integer.
	ValidationCropSize *int32

	// Image size to which to resize before cropping for validation dataset. Must be a positive integer.
	ValidationResizeSize *int32

	// Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
	WarmupCosineLRCycles *float32

	// Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
	WarmupCosineLRWarmupEpochs *int32

	// Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
	WeightDecay *float32

	// Weighted loss. The accepted values are 0 for no weighted loss. 1 for weighted loss with sqrt.(classweights). 2 for weighted
	// loss with classweights. Must be 0 or 1 or 2.
	WeightedLoss *int32
}

// ImageModelSettingsObjectDetection - Settings used for training the model. For more information on the available settings
// please visit the official documentation:
// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
type ImageModelSettingsObjectDetection struct {
	// Settings for advanced scenarios.
	AdvancedSettings *string

	// Enable AMSGrad when optimizer is 'adam' or 'adamw'.
	AmsGradient *bool

	// Settings for using Augmentations.
	Augmentations *string

	// Value of 'beta1' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta1 *float32

	// Value of 'beta2' when optimizer is 'adam' or 'adamw'. Must be a float in the range [0, 1].
	Beta2 *float32

	// Maximum number of detections per image, for all classes. Must be a positive integer. Note: This settings is not supported
	// for the 'yolov5' algorithm.
	BoxDetectionsPerImage *int32

	// During inference, only return proposals with a classification score greater than BoxScoreThreshold. Must be a float in
	// the range[0, 1].
	BoxScoreThreshold *float32

	// Frequency to store model checkpoints. Must be a positive integer.
	CheckpointFrequency *int32

	// The pretrained checkpoint model for incremental training.
	CheckpointModel *MLFlowModelJobInput

	// The id of a previous run that has a pretrained checkpoint for incremental training.
	CheckpointRunID *string

	// Whether to use distributed training.
	Distributed *bool

	// Enable early stopping logic during training.
	EarlyStopping *bool

	// Minimum number of epochs or validation evaluations to wait before primary metric improvement is tracked for early stopping.
	// Must be a positive integer.
	EarlyStoppingDelay *int32

	// Minimum number of epochs or validation evaluations with no primary metric improvement before the run is stopped. Must be
	// a positive integer.
	EarlyStoppingPatience *int32

	// Enable normalization when exporting ONNX model.
	EnableOnnxNormalization *bool

	// Frequency to evaluate validation dataset to get metric scores. Must be a positive integer.
	EvaluationFrequency *int32

	// Gradient accumulation means running a configured number of "GradAccumulationStep" steps without updating the model weights
	// while accumulating the gradients of those steps, and then using the
	// accumulated gradients to compute the weight updates. Must be a positive integer.
	GradientAccumulationStep *int32

	// Image size for train and validation. Must be a positive integer. Note: The training run may get into CUDA OOM if the size
	// is too big. Note: This settings is only supported for the 'yolov5' algorithm.
	ImageSize *int32

	// Number of layers to freeze for the model. Must be a positive integer. For instance, passing 2 as value for 'seresnext'
	// means freezing layer0 and layer1. For a full list of models supported and details
	// on layer freeze, please see: https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	LayersToFreeze *int32

	// Initial learning rate. Must be a float in the range [0, 1].
	LearningRate *float32

	// Type of learning rate scheduler. Must be 'warmup_cosine' or 'step'.
	LearningRateScheduler *LearningRateScheduler

	// Maximum size of the image to be rescaled before feeding it to the backbone. Must be a positive integer. Note: training
	// run may get into CUDA OOM if the size is too big. Note: This settings is not
	// supported for the 'yolov5' algorithm.
	MaxSize *int32

	// Minimum size of the image to be rescaled before feeding it to the backbone. Must be a positive integer. Note: training
	// run may get into CUDA OOM if the size is too big. Note: This settings is not
	// supported for the 'yolov5' algorithm.
	MinSize *int32

	// Name of the model to use for training. For more information on the available models please visit the official documentation:
	// https://docs.microsoft.com/en-us/azure/machine-learning/how-to-auto-train-image-models.
	ModelName *string

	// Model size. Must be 'small', 'medium', 'large', or 'xlarge'. Note: training run may get into CUDA OOM if the model size
	// is too big. Note: This settings is only supported for the 'yolov5' algorithm.
	ModelSize *ModelSize

	// Value of momentum when optimizer is 'sgd'. Must be a float in the range [0, 1].
	Momentum *float32

	// Enable multi-scale image by varying image size by +/- 50%. Note: training run may get into CUDA OOM if no sufficient GPU
	// memory. Note: This settings is only supported for the 'yolov5' algorithm.
	MultiScale *bool

	// Enable nesterov when optimizer is 'sgd'.
	Nesterov *bool

	// IOU threshold used during inference in NMS post processing. Must be a float in the range [0, 1].
	NmsIouThreshold *float32

	// Number of training epochs. Must be a positive integer.
	NumberOfEpochs *int32

	// Number of data loader workers. Must be a non-negative integer.
	NumberOfWorkers *int32

	// Type of optimizer.
	Optimizer *StochasticOptimizer

	// Random seed to be used when using deterministic training.
	RandomSeed *int32

	// Value of gamma when learning rate scheduler is 'step'. Must be a float in the range [0, 1].
	StepLRGamma *float32

	// Value of step size when learning rate scheduler is 'step'. Must be a positive integer.
	StepLRStepSize *int32

	// The grid size to use for tiling each image. Note: TileGridSize must not be None to enable small object detection logic.
	// A string containing two integers in mxn format. Note: This settings is not
	// supported for the 'yolov5' algorithm.
	TileGridSize *string

	// Overlap ratio between adjacent tiles in each dimension. Must be float in the range [0, 1). Note: This settings is not supported
	// for the 'yolov5' algorithm.
	TileOverlapRatio *float32

	// The IOU threshold to use to perform NMS while merging predictions from tiles and image. Used in validation/ inference.
	// Must be float in the range [0, 1]. Note: This settings is not supported for the
	// 'yolov5' algorithm.
	TilePredictionsNmsThreshold *float32

	// Training batch size. Must be a positive integer.
	TrainingBatchSize *int32

	// Validation batch size. Must be a positive integer.
	ValidationBatchSize *int32

	// IOU threshold to use when computing validation metric. Must be float in the range [0, 1].
	ValidationIouThreshold *float32

	// Metric computation method to use for validation metrics.
	ValidationMetricType *ValidationMetricType

	// Value of cosine cycle when learning rate scheduler is 'warmup_cosine'. Must be a float in the range [0, 1].
	WarmupCosineLRCycles *float32

	// Value of warmup epochs when learning rate scheduler is 'warmup_cosine'. Must be a positive integer.
	WarmupCosineLRWarmupEpochs *int32

	// Value of weight decay when optimizer is 'sgd', 'adam', or 'adamw'. Must be a float in the range[0, 1].
	WeightDecay *float32
}

// ImageObjectDetection - Image Object Detection. Object detection is used to identify objects in an image and locate each
// object with a bounding box e.g. locate all dogs and cats in an image and draw a bounding box around
// each.
type ImageObjectDetection struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Settings used for training the model.
	ModelSettings *ImageModelSettingsObjectDetection

	// Primary metric to optimize for this task.
	PrimaryMetric *ObjectDetectionPrimaryMetrics

	// Search space for sampling different combinations of models and their hyperparameters.
	SearchSpace []*ImageModelDistributionSettingsObjectDetection

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type ImageObjectDetection.
func (i *ImageObjectDetection) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     i.LogVerbosity,
		TargetColumnName: i.TargetColumnName,
		TaskType:         i.TaskType,
		TrainingData:     i.TrainingData,
	}
}

type ImageObjectDetectionBase struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// Settings used for training the model.
	ModelSettings *ImageModelSettingsObjectDetection

	// Search space for sampling different combinations of models and their hyperparameters.
	SearchSpace []*ImageModelDistributionSettingsObjectDetection

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

// ImageSweepSettings - Model sweeping and hyperparameter sweeping related settings.
type ImageSweepSettings struct {
	// REQUIRED; [Required] Type of the hyperparameter sampling algorithms.
	SamplingAlgorithm *SamplingAlgorithmType

	// Type of early termination policy.
	EarlyTermination EarlyTerminationPolicyClassification
}

// ImageVertical - Abstract class for AutoML tasks that train image (computer vision) models - such as Image Classification
// / Image Classification Multilabel / Image Object Detection / Image Instance Segmentation.
type ImageVertical struct {
	// REQUIRED; [Required] Limit settings for the AutoML job.
	LimitSettings *ImageLimitSettings

	// Model sweeping and hyperparameter sweeping related settings.
	SweepSettings *ImageSweepSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64
}

type InferenceContainerProperties struct {
	// The route to check the liveness of the inference server container.
	LivenessRoute *Route

	// The route to check the readiness of the inference server container.
	ReadinessRoute *Route

	// The port to send the scoring requests to, within the inference server container.
	ScoringRoute *Route
}

// InstanceTypeSchema - Instance type schema.
type InstanceTypeSchema struct {
	// Node Selector
	NodeSelector map[string]*string

	// Resource requests/limits for this instance type
	Resources *InstanceTypeSchemaResources
}

// InstanceTypeSchemaResources - Resource requests/limits for this instance type
type InstanceTypeSchemaResources struct {
	// Resource limits for this instance type
	Limits map[string]*string

	// Resource requests for this instance type
	Requests map[string]*string
}

// JobBase - Azure Resource Manager resource envelope.
type JobBase struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties JobBasePropertiesClassification

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JobBaseProperties - Base definition for a job.
type JobBaseProperties struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobType *JobType

	// ARM resource ID of the component resource.
	ComponentID *string

	// ARM resource ID of the compute resource.
	ComputeID *string

	// The asset description text.
	Description *string

	// Display name of job.
	DisplayName *string

	// The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
	ExperimentName *string

	// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null. Defaults to AmlToken
	// if null.
	Identity IdentityConfigurationClassification

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// List of JobEndpoints. For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
	Services map[string]*JobService

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Status of the job.
	Status *JobStatus
}

// GetJobBaseProperties implements the JobBasePropertiesClassification interface for type JobBaseProperties.
func (j *JobBaseProperties) GetJobBaseProperties() *JobBaseProperties { return j }

// JobBaseResourceArmPaginatedResult - A paginated list of JobBase entities.
type JobBaseResourceArmPaginatedResult struct {
	// The link to the next page of JobBase objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type JobBase.
	Value []*JobBase
}

// JobInput - Command job definition.
type JobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// Description for the input.
	Description *string
}

// GetJobInput implements the JobInputClassification interface for type JobInput.
func (j *JobInput) GetJobInput() *JobInput { return j }

type JobLimits struct {
	// REQUIRED; [Required] JobLimit type.
	JobLimitsType *JobLimitsType

	// The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as
	// low as Seconds.
	Timeout *string
}

// GetJobLimits implements the JobLimitsClassification interface for type JobLimits.
func (j *JobLimits) GetJobLimits() *JobLimits { return j }

// JobOutput - Job output definition container information on where to find job output/logs.
type JobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string
}

// GetJobOutput implements the JobOutputClassification interface for type JobOutput.
func (j *JobOutput) GetJobOutput() *JobOutput { return j }

type JobResourceConfiguration struct {
	// Extra arguments to pass to the Docker run command. This would override any parameters that have already been set by the
	// system, or in this section. This parameter is only supported for Azure ML
	// compute types.
	DockerArgs *string

	// Optional number of instances or nodes used by the compute target.
	InstanceCount *int32

	// Optional type of VM used as supported by the compute target.
	InstanceType *string

	// Additional properties bag.
	Properties map[string]any

	// Size of the docker container's shared memory block. This should be in the format of (number)(unit) where number as to be
	// greater than 0 and the unit can be one of b(bytes), k(kilobytes), m(megabytes),
	// or g(gigabytes).
	ShmSize *string
}

type JobScheduleAction struct {
	// REQUIRED; [Required] Specifies the action type of the schedule
	ActionType *ScheduleActionType

	// REQUIRED; [Required] Defines Schedule action definition details.
	JobDefinition JobBasePropertiesClassification
}

// GetScheduleActionBase implements the ScheduleActionBaseClassification interface for type JobScheduleAction.
func (j *JobScheduleAction) GetScheduleActionBase() *ScheduleActionBase {
	return &ScheduleActionBase{
		ActionType: j.ActionType,
	}
}

// JobService - Job endpoint definition
type JobService struct {
	// Url for endpoint.
	Endpoint *string

	// Endpoint type.
	JobServiceType *string

	// Port for endpoint.
	Port *int32

	// Additional properties to set on the endpoint.
	Properties map[string]*string

	// READ-ONLY; Any error in the service.
	ErrorMessage *string

	// READ-ONLY; Status of endpoint.
	Status *string
}

// Kubernetes - A Machine Learning compute based on Kubernetes Compute.
type Kubernetes struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool

	// Properties of Kubernetes
	Properties *KubernetesProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type Kubernetes.
func (k *Kubernetes) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    k.ComputeLocation,
		ComputeType:        k.ComputeType,
		CreatedOn:          k.CreatedOn,
		Description:        k.Description,
		DisableLocalAuth:   k.DisableLocalAuth,
		IsAttachedCompute:  k.IsAttachedCompute,
		ModifiedOn:         k.ModifiedOn,
		ProvisioningErrors: k.ProvisioningErrors,
		ProvisioningState:  k.ProvisioningState,
		ResourceID:         k.ResourceID,
	}
}

// KubernetesOnlineDeployment - Properties specific to a KubernetesOnlineDeployment.
type KubernetesOnlineDeployment struct {
	// REQUIRED; [Required] The compute type of the endpoint.
	EndpointComputeType *EndpointComputeType

	// If true, enables Application Insights logging.
	AppInsightsEnabled *bool

	// Code configuration for the endpoint deployment.
	CodeConfiguration *CodeConfiguration

	// The resource requirements for the container (cpu and memory).
	ContainerResourceRequirements *ContainerResourceRequirements

	// Description of the endpoint deployment.
	Description *string

	// If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
	EgressPublicNetworkAccess *EgressPublicNetworkAccessType

	// ARM resource ID or AssetId of the environment specification for the endpoint deployment.
	EnvironmentID *string

	// Environment variables configuration for the deployment.
	EnvironmentVariables map[string]*string

	// Compute instance type.
	InstanceType *string

	// Liveness probe monitors the health of the container regularly.
	LivenessProbe *ProbeSettings

	// The URI path to the model.
	Model *string

	// The path to mount the model in custom container.
	ModelMountPath *string

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness
	// probe.
	ReadinessProbe *ProbeSettings

	// Request settings for the deployment.
	RequestSettings *OnlineRequestSettings

	// Scale settings for the deployment. If it is null or not provided, it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
	// and to DefaultScaleSettings for ManagedOnlineDeployment.
	ScaleSettings OnlineScaleSettingsClassification

	// READ-ONLY; Provisioning state for the endpoint deployment.
	ProvisioningState *DeploymentProvisioningState
}

// GetOnlineDeploymentProperties implements the OnlineDeploymentPropertiesClassification interface for type KubernetesOnlineDeployment.
func (k *KubernetesOnlineDeployment) GetOnlineDeploymentProperties() *OnlineDeploymentProperties {
	return &OnlineDeploymentProperties{
		AppInsightsEnabled:        k.AppInsightsEnabled,
		CodeConfiguration:         k.CodeConfiguration,
		Description:               k.Description,
		EgressPublicNetworkAccess: k.EgressPublicNetworkAccess,
		EndpointComputeType:       k.EndpointComputeType,
		EnvironmentID:             k.EnvironmentID,
		EnvironmentVariables:      k.EnvironmentVariables,
		InstanceType:              k.InstanceType,
		LivenessProbe:             k.LivenessProbe,
		Model:                     k.Model,
		ModelMountPath:            k.ModelMountPath,
		Properties:                k.Properties,
		ProvisioningState:         k.ProvisioningState,
		ReadinessProbe:            k.ReadinessProbe,
		RequestSettings:           k.RequestSettings,
		ScaleSettings:             k.ScaleSettings,
	}
}

// KubernetesProperties - Kubernetes properties
type KubernetesProperties struct {
	// Default instance type
	DefaultInstanceType *string

	// Extension instance release train.
	ExtensionInstanceReleaseTrain *string

	// Extension principal-id.
	ExtensionPrincipalID *string

	// Instance Type Schema
	InstanceTypes map[string]*InstanceTypeSchema

	// Compute namespace
	Namespace *string

	// Relay connection string.
	RelayConnectionString *string

	// ServiceBus connection string.
	ServiceBusConnectionString *string

	// VC name.
	VcName *string
}

// KubernetesSchema - Kubernetes Compute Schema
type KubernetesSchema struct {
	// Properties of Kubernetes
	Properties *KubernetesProperties
}

// ListAmlUserFeatureResult - The List Aml user feature operation response.
type ListAmlUserFeatureResult struct {
	// READ-ONLY; The URI to fetch the next page of AML user features information. Call ListNext() with this to fetch the next
	// page of AML user features information.
	NextLink *string

	// READ-ONLY; The list of AML user facing features.
	Value []*AmlUserFeature
}

type ListNotebookKeysResult struct {
	// READ-ONLY
	PrimaryAccessKey *string

	// READ-ONLY
	SecondaryAccessKey *string
}

type ListStorageAccountKeysResult struct {
	// READ-ONLY
	UserStorageKey *string
}

// ListUsagesResult - The List Usages operation response.
type ListUsagesResult struct {
	// READ-ONLY; The URI to fetch the next page of AML resource usage information. Call ListNext() with this to fetch the next
	// page of AML resource usage information.
	NextLink *string

	// READ-ONLY; The list of AML resource usages.
	Value []*Usage
}

type ListWorkspaceKeysResult struct {
	// READ-ONLY
	AppInsightsInstrumentationKey *string

	// READ-ONLY
	ContainerRegistryCredentials *RegistryListCredentialsResult

	// READ-ONLY
	NotebookAccessKeys *ListNotebookKeysResult

	// READ-ONLY
	UserStorageKey *string

	// READ-ONLY
	UserStorageResourceID *string
}

// ListWorkspaceQuotas - The List WorkspaceQuotasByVMFamily operation response.
type ListWorkspaceQuotas struct {
	// READ-ONLY; The URI to fetch the next page of workspace quota information by VM Family. Call ListNext() with this to fetch
	// the next page of Workspace Quota information.
	NextLink *string

	// READ-ONLY; The list of Workspace Quotas by VM Family
	Value []*ResourceQuota
}

// LiteralJobInput - Literal input type.
type LiteralJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Literal value for the input.
	Value *string

	// Description for the input.
	Description *string
}

// GetJobInput implements the JobInputClassification interface for type LiteralJobInput.
func (l *LiteralJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  l.Description,
		JobInputType: l.JobInputType,
	}
}

type MLFlowModelJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Description for the input.
	Description *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// GetJobInput implements the JobInputClassification interface for type MLFlowModelJobInput.
func (m *MLFlowModelJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  m.Description,
		JobInputType: m.JobInputType,
	}
}

type MLFlowModelJobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string

	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// GetJobOutput implements the JobOutputClassification interface for type MLFlowModelJobOutput.
func (m *MLFlowModelJobOutput) GetJobOutput() *JobOutput {
	return &JobOutput{
		Description:   m.Description,
		JobOutputType: m.JobOutputType,
	}
}

// MLTableData - MLTable data definition
type MLTableData struct {
	// REQUIRED; [Required] Specifies the type of data.
	DataType *DataType

	// REQUIRED; [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
	DataURI *string

	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Uris referenced in the MLTable definition (required for lineage)
	ReferencedUris []*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// GetDataVersionBaseProperties implements the DataVersionBasePropertiesClassification interface for type MLTableData.
func (m *MLTableData) GetDataVersionBaseProperties() *DataVersionBaseProperties {
	return &DataVersionBaseProperties{
		DataType:    m.DataType,
		DataURI:     m.DataURI,
		Description: m.Description,
		IsAnonymous: m.IsAnonymous,
		IsArchived:  m.IsArchived,
		Properties:  m.Properties,
		Tags:        m.Tags,
	}
}

type MLTableJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Description for the input.
	Description *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// GetJobInput implements the JobInputClassification interface for type MLTableJobInput.
func (m *MLTableJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  m.Description,
		JobInputType: m.JobInputType,
	}
}

type MLTableJobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string

	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// GetJobOutput implements the JobOutputClassification interface for type MLTableJobOutput.
func (m *MLTableJobOutput) GetJobOutput() *JobOutput {
	return &JobOutput{
		Description:   m.Description,
		JobOutputType: m.JobOutputType,
	}
}

// ManagedIdentity - Managed identity configuration.
type ManagedIdentity struct {
	// REQUIRED; [Required] Specifies the type of identity framework.
	IdentityType *IdentityConfigurationType

	// Specifies a user-assigned identity by client ID. For system-assigned, do not set this field.
	ClientID *string

	// Specifies a user-assigned identity by object ID. For system-assigned, do not set this field.
	ObjectID *string

	// Specifies a user-assigned identity by ARM resource ID. For system-assigned, do not set this field.
	ResourceID *string
}

// GetIdentityConfiguration implements the IdentityConfigurationClassification interface for type ManagedIdentity.
func (m *ManagedIdentity) GetIdentityConfiguration() *IdentityConfiguration {
	return &IdentityConfiguration{
		IdentityType: m.IdentityType,
	}
}

type ManagedIdentityAuthTypeWorkspaceConnectionProperties struct {
	// REQUIRED; Authentication type of the connection target
	AuthType *ConnectionAuthType

	// Category of the connection
	Category    *ConnectionCategory
	Credentials *WorkspaceConnectionManagedIdentity
	Target      *string

	// Value details of the workspace connection.
	Value *string

	// format for the workspace connection value
	ValueFormat *ValueFormat
}

// GetWorkspaceConnectionPropertiesV2 implements the WorkspaceConnectionPropertiesV2Classification interface for type ManagedIdentityAuthTypeWorkspaceConnectionProperties.
func (m *ManagedIdentityAuthTypeWorkspaceConnectionProperties) GetWorkspaceConnectionPropertiesV2() *WorkspaceConnectionPropertiesV2 {
	return &WorkspaceConnectionPropertiesV2{
		AuthType:    m.AuthType,
		Category:    m.Category,
		Target:      m.Target,
		Value:       m.Value,
		ValueFormat: m.ValueFormat,
	}
}

// ManagedOnlineDeployment - Properties specific to a ManagedOnlineDeployment.
type ManagedOnlineDeployment struct {
	// REQUIRED; [Required] The compute type of the endpoint.
	EndpointComputeType *EndpointComputeType

	// If true, enables Application Insights logging.
	AppInsightsEnabled *bool

	// Code configuration for the endpoint deployment.
	CodeConfiguration *CodeConfiguration

	// Description of the endpoint deployment.
	Description *string

	// If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
	EgressPublicNetworkAccess *EgressPublicNetworkAccessType

	// ARM resource ID or AssetId of the environment specification for the endpoint deployment.
	EnvironmentID *string

	// Environment variables configuration for the deployment.
	EnvironmentVariables map[string]*string

	// Compute instance type.
	InstanceType *string

	// Liveness probe monitors the health of the container regularly.
	LivenessProbe *ProbeSettings

	// The URI path to the model.
	Model *string

	// The path to mount the model in custom container.
	ModelMountPath *string

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness
	// probe.
	ReadinessProbe *ProbeSettings

	// Request settings for the deployment.
	RequestSettings *OnlineRequestSettings

	// Scale settings for the deployment. If it is null or not provided, it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
	// and to DefaultScaleSettings for ManagedOnlineDeployment.
	ScaleSettings OnlineScaleSettingsClassification

	// READ-ONLY; Provisioning state for the endpoint deployment.
	ProvisioningState *DeploymentProvisioningState
}

// GetOnlineDeploymentProperties implements the OnlineDeploymentPropertiesClassification interface for type ManagedOnlineDeployment.
func (m *ManagedOnlineDeployment) GetOnlineDeploymentProperties() *OnlineDeploymentProperties {
	return &OnlineDeploymentProperties{
		AppInsightsEnabled:        m.AppInsightsEnabled,
		CodeConfiguration:         m.CodeConfiguration,
		Description:               m.Description,
		EgressPublicNetworkAccess: m.EgressPublicNetworkAccess,
		EndpointComputeType:       m.EndpointComputeType,
		EnvironmentID:             m.EnvironmentID,
		EnvironmentVariables:      m.EnvironmentVariables,
		InstanceType:              m.InstanceType,
		LivenessProbe:             m.LivenessProbe,
		Model:                     m.Model,
		ModelMountPath:            m.ModelMountPath,
		Properties:                m.Properties,
		ProvisioningState:         m.ProvisioningState,
		ReadinessProbe:            m.ReadinessProbe,
		RequestSettings:           m.RequestSettings,
		ScaleSettings:             m.ScaleSettings,
	}
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MedianStoppingPolicy - Defines an early termination policy based on running averages of the primary metric of all runs
type MedianStoppingPolicy struct {
	// REQUIRED; [Required] Name of policy configuration
	PolicyType *EarlyTerminationPolicyType

	// Number of intervals by which to delay the first evaluation.
	DelayEvaluation *int32

	// Interval (number of runs) between policy evaluations.
	EvaluationInterval *int32
}

// GetEarlyTerminationPolicy implements the EarlyTerminationPolicyClassification interface for type MedianStoppingPolicy.
func (m *MedianStoppingPolicy) GetEarlyTerminationPolicy() *EarlyTerminationPolicy {
	return &EarlyTerminationPolicy{
		DelayEvaluation:    m.DelayEvaluation,
		EvaluationInterval: m.EvaluationInterval,
		PolicyType:         m.PolicyType,
	}
}

// ModelContainer - Azure Resource Manager resource envelope.
type ModelContainer struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *ModelContainerProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ModelContainerProperties struct {
	// The asset description text.
	Description *string

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; The latest version inside this container.
	LatestVersion *string

	// READ-ONLY; The next auto incremental version
	NextVersion *string
}

// ModelContainerResourceArmPaginatedResult - A paginated list of ModelContainer entities.
type ModelContainerResourceArmPaginatedResult struct {
	// The link to the next page of ModelContainer objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type ModelContainer.
	Value []*ModelContainer
}

// ModelVersion - Azure Resource Manager resource envelope.
type ModelVersion struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *ModelVersionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ModelVersionProperties - Model asset version details.
type ModelVersionProperties struct {
	// The asset description text.
	Description *string

	// Mapping of model flavors to their properties.
	Flavors map[string]*FlavorData

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// Name of the training job which produced this model
	JobName *string

	// The storage format for this entity. Used for NCD.
	ModelType *string

	// The URI path to the model contents.
	ModelURI *string

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// ModelVersionResourceArmPaginatedResult - A paginated list of ModelVersion entities.
type ModelVersionResourceArmPaginatedResult struct {
	// The link to the next page of ModelVersion objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type ModelVersion.
	Value []*ModelVersion
}

// Mpi - MPI distribution configuration.
type Mpi struct {
	// REQUIRED; [Required] Specifies the type of distribution framework.
	DistributionType *DistributionType

	// Number of processes per MPI node.
	ProcessCountPerInstance *int32
}

// GetDistributionConfiguration implements the DistributionConfigurationClassification interface for type Mpi.
func (m *Mpi) GetDistributionConfiguration() *DistributionConfiguration {
	return &DistributionConfiguration{
		DistributionType: m.DistributionType,
	}
}

// NCrossValidations - N-Cross validations value.
type NCrossValidations struct {
	// REQUIRED; [Required] Mode for determining N-Cross validations.
	Mode *NCrossValidationsMode
}

// GetNCrossValidations implements the NCrossValidationsClassification interface for type NCrossValidations.
func (n *NCrossValidations) GetNCrossValidations() *NCrossValidations { return n }

// NlpVertical - Abstract class for NLP related AutoML tasks. NLP - Natural Language Processing.
type NlpVertical struct {
	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *NlpVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *NlpVerticalLimitSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput
}

type NlpVerticalFeaturizationSettings struct {
	// Dataset language, useful for the text data.
	DatasetLanguage *string
}

// NlpVerticalLimitSettings - Job execution constraints.
type NlpVerticalLimitSettings struct {
	// Maximum Concurrent AutoML iterations.
	MaxConcurrentTrials *int32

	// Number of AutoML iterations.
	MaxTrials *int32

	// AutoML job timeout.
	Timeout *string
}

// NodeStateCounts - Counts of various compute node states on the amlCompute.
type NodeStateCounts struct {
	// READ-ONLY; Number of compute nodes in idle state.
	IdleNodeCount *int32

	// READ-ONLY; Number of compute nodes which are leaving the amlCompute.
	LeavingNodeCount *int32

	// READ-ONLY; Number of compute nodes which are in preempted state.
	PreemptedNodeCount *int32

	// READ-ONLY; Number of compute nodes which are being prepared.
	PreparingNodeCount *int32

	// READ-ONLY; Number of compute nodes which are running jobs.
	RunningNodeCount *int32

	// READ-ONLY; Number of compute nodes which are in unusable state.
	UnusableNodeCount *int32
}

type NoneAuthTypeWorkspaceConnectionProperties struct {
	// REQUIRED; Authentication type of the connection target
	AuthType *ConnectionAuthType

	// Category of the connection
	Category *ConnectionCategory
	Target   *string

	// Value details of the workspace connection.
	Value *string

	// format for the workspace connection value
	ValueFormat *ValueFormat
}

// GetWorkspaceConnectionPropertiesV2 implements the WorkspaceConnectionPropertiesV2Classification interface for type NoneAuthTypeWorkspaceConnectionProperties.
func (n *NoneAuthTypeWorkspaceConnectionProperties) GetWorkspaceConnectionPropertiesV2() *WorkspaceConnectionPropertiesV2 {
	return &WorkspaceConnectionPropertiesV2{
		AuthType:    n.AuthType,
		Category:    n.Category,
		Target:      n.Target,
		Value:       n.Value,
		ValueFormat: n.ValueFormat,
	}
}

// NoneDatastoreCredentials - Empty/none datastore credentials.
type NoneDatastoreCredentials struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	CredentialsType *CredentialsType
}

// GetDatastoreCredentials implements the DatastoreCredentialsClassification interface for type NoneDatastoreCredentials.
func (n *NoneDatastoreCredentials) GetDatastoreCredentials() *DatastoreCredentials {
	return &DatastoreCredentials{
		CredentialsType: n.CredentialsType,
	}
}

type NotebookAccessTokenResult struct {
	// READ-ONLY
	AccessToken *string

	// READ-ONLY
	ExpiresIn *int32

	// READ-ONLY
	HostName *string

	// READ-ONLY
	NotebookResourceID *string

	// READ-ONLY
	PublicDNS *string

	// READ-ONLY
	RefreshToken *string

	// READ-ONLY
	Scope *string

	// READ-ONLY
	TokenType *string
}

type NotebookPreparationError struct {
	ErrorMessage *string
	StatusCode   *int32
}

type NotebookResourceInfo struct {
	Fqdn *string

	// The error that occurs when preparing notebook.
	NotebookPreparationError *NotebookPreparationError

	// the data plane resourceId that used to initialize notebook component
	ResourceID *string
}

// Objective - Optimization objective.
type Objective struct {
	// REQUIRED; [Required] Defines supported metric goals for hyperparameter tuning
	Goal *Goal

	// REQUIRED; [Required] Name of the metric to optimize.
	PrimaryMetric *string
}

type OnlineDeployment struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; [Required] Additional attributes of the entity.
	Properties OnlineDeploymentPropertiesClassification

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
	Kind *string

	// Sku details required for ARM contract for Autoscaling.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type OnlineDeploymentProperties struct {
	// REQUIRED; [Required] The compute type of the endpoint.
	EndpointComputeType *EndpointComputeType

	// If true, enables Application Insights logging.
	AppInsightsEnabled *bool

	// Code configuration for the endpoint deployment.
	CodeConfiguration *CodeConfiguration

	// Description of the endpoint deployment.
	Description *string

	// If Enabled, allow egress public network access. If Disabled, this will create secure egress. Default: Enabled.
	EgressPublicNetworkAccess *EgressPublicNetworkAccessType

	// ARM resource ID or AssetId of the environment specification for the endpoint deployment.
	EnvironmentID *string

	// Environment variables configuration for the deployment.
	EnvironmentVariables map[string]*string

	// Compute instance type.
	InstanceType *string

	// Liveness probe monitors the health of the container regularly.
	LivenessProbe *ProbeSettings

	// The URI path to the model.
	Model *string

	// The path to mount the model in custom container.
	ModelMountPath *string

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// Readiness probe validates if the container is ready to serve traffic. The properties and defaults are the same as liveness
	// probe.
	ReadinessProbe *ProbeSettings

	// Request settings for the deployment.
	RequestSettings *OnlineRequestSettings

	// Scale settings for the deployment. If it is null or not provided, it defaults to TargetUtilizationScaleSettings for KubernetesOnlineDeployment
	// and to DefaultScaleSettings for ManagedOnlineDeployment.
	ScaleSettings OnlineScaleSettingsClassification

	// READ-ONLY; Provisioning state for the endpoint deployment.
	ProvisioningState *DeploymentProvisioningState
}

// GetOnlineDeploymentProperties implements the OnlineDeploymentPropertiesClassification interface for type OnlineDeploymentProperties.
func (o *OnlineDeploymentProperties) GetOnlineDeploymentProperties() *OnlineDeploymentProperties {
	return o
}

// OnlineDeploymentTrackedResourceArmPaginatedResult - A paginated list of OnlineDeployment entities.
type OnlineDeploymentTrackedResourceArmPaginatedResult struct {
	// The link to the next page of OnlineDeployment objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type OnlineDeployment.
	Value []*OnlineDeployment
}

type OnlineEndpoint struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *OnlineEndpointProperties

	// Managed service identity (system assigned and/or user assigned identities)
	Identity *ManagedServiceIdentity

	// Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type.
	Kind *string

	// Sku details required for ARM contract for Autoscaling.
	SKU *SKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// OnlineEndpointProperties - Online endpoint configuration
type OnlineEndpointProperties struct {
	// REQUIRED; [Required] Use 'Key' for key based authentication and 'AMLToken' for Azure Machine Learning token-based authentication.
	// 'Key' doesn't expire but 'AMLToken' does.
	AuthMode *EndpointAuthMode

	// ARM resource ID of the compute if it exists. optional
	Compute *string

	// Description of the inference endpoint.
	Description *string

	// EndpointAuthKeys to set initially on an Endpoint. This property will always be returned as null. AuthKey values must be
	// retrieved using the ListKeys API.
	Keys *EndpointAuthKeys

	// Property dictionary. Properties can be added, but not removed or altered.
	Properties map[string]*string

	// Set to "Enabled" for endpoints that should allow public access when Private Link is enabled.
	PublicNetworkAccess *PublicNetworkAccessType

	// Percentage of traffic from endpoint to divert to each deployment. Traffic values need to sum to 100.
	Traffic map[string]*int32

	// READ-ONLY; Provisioning state for the endpoint.
	ProvisioningState *EndpointProvisioningState

	// READ-ONLY; Endpoint URI.
	ScoringURI *string

	// READ-ONLY; Endpoint Swagger URI.
	SwaggerURI *string
}

// OnlineEndpointTrackedResourceArmPaginatedResult - A paginated list of OnlineEndpoint entities.
type OnlineEndpointTrackedResourceArmPaginatedResult struct {
	// The link to the next page of OnlineEndpoint objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type OnlineEndpoint.
	Value []*OnlineEndpoint
}

// OnlineRequestSettings - Online deployment scoring requests configuration.
type OnlineRequestSettings struct {
	// The number of maximum concurrent requests per node allowed per deployment. Defaults to 1.
	MaxConcurrentRequestsPerInstance *int32

	// The maximum amount of time a request will stay in the queue in ISO 8601 format. Defaults to 500ms.
	MaxQueueWait *string

	// The scoring timeout in ISO 8601 format. Defaults to 5000ms.
	RequestTimeout *string
}

// OnlineScaleSettings - Online deployment scaling configuration.
type OnlineScaleSettings struct {
	// REQUIRED; [Required] Type of deployment scaling algorithm
	ScaleType *ScaleType
}

// GetOnlineScaleSettings implements the OnlineScaleSettingsClassification interface for type OnlineScaleSettings.
func (o *OnlineScaleSettings) GetOnlineScaleSettings() *OnlineScaleSettings { return o }

// OutputPathAssetReference - Reference to an asset via its path in a job output.
type OutputPathAssetReference struct {
	// REQUIRED; [Required] Specifies the type of asset reference.
	ReferenceType *ReferenceType

	// ARM resource ID of the job.
	JobID *string

	// The path of the file/directory in the job output.
	Path *string
}

// GetAssetReferenceBase implements the AssetReferenceBaseClassification interface for type OutputPathAssetReference.
func (o *OutputPathAssetReference) GetAssetReferenceBase() *AssetReferenceBase {
	return &AssetReferenceBase{
		ReferenceType: o.ReferenceType,
	}
}

type PATAuthTypeWorkspaceConnectionProperties struct {
	// REQUIRED; Authentication type of the connection target
	AuthType *ConnectionAuthType

	// Category of the connection
	Category    *ConnectionCategory
	Credentials *WorkspaceConnectionPersonalAccessToken
	Target      *string

	// Value details of the workspace connection.
	Value *string

	// format for the workspace connection value
	ValueFormat *ValueFormat
}

// GetWorkspaceConnectionPropertiesV2 implements the WorkspaceConnectionPropertiesV2Classification interface for type PATAuthTypeWorkspaceConnectionProperties.
func (p *PATAuthTypeWorkspaceConnectionProperties) GetWorkspaceConnectionPropertiesV2() *WorkspaceConnectionPropertiesV2 {
	return &WorkspaceConnectionPropertiesV2{
		AuthType:    p.AuthType,
		Category:    p.Category,
		Target:      p.Target,
		Value:       p.Value,
		ValueFormat: p.ValueFormat,
	}
}

// PaginatedComputeResourcesList - Paginated list of Machine Learning compute objects wrapped in ARM resource envelope.
type PaginatedComputeResourcesList struct {
	// A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string

	// An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value []*ComputeResource
}

// PartialBatchDeployment - Mutable batch inference settings per deployment.
type PartialBatchDeployment struct {
	// Description of the endpoint deployment.
	Description *string
}

// PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties - Strictly used in update requests.
type PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties struct {
	// Additional attributes of the entity.
	Properties *PartialBatchDeployment

	// Resource tags.
	Tags map[string]*string
}

// PartialManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type PartialManagedServiceIdentity struct {
	// Managed service identity (system assigned and/or user assigned identities)
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]any
}

// PartialMinimalTrackedResource - Strictly used in update requests.
type PartialMinimalTrackedResource struct {
	// Resource tags.
	Tags map[string]*string
}

// PartialMinimalTrackedResourceWithIdentity - Strictly used in update requests.
type PartialMinimalTrackedResourceWithIdentity struct {
	// Managed service identity (system assigned and/or user assigned identities)
	Identity *PartialManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string
}

// PartialMinimalTrackedResourceWithSKU - Strictly used in update requests.
type PartialMinimalTrackedResourceWithSKU struct {
	// Sku details required for ARM contract for Autoscaling.
	SKU *PartialSKU

	// Resource tags.
	Tags map[string]*string
}

// PartialSKU - Common SKU definition.
type PartialSKU struct {
	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The name of the SKU. Ex - P3. It is typically a letter+number code.
	Name *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

type Password struct {
	// READ-ONLY
	Name *string

	// READ-ONLY
	Value *string
}

// PersonalComputeInstanceSettings - Settings for a personal compute instance.
type PersonalComputeInstanceSettings struct {
	// A user explicitly assigned to a personal compute instance.
	AssignedUser *AssignedUser
}

// PipelineJob - Pipeline Job definition: defines generic to MFE attributes.
type PipelineJob struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobType *JobType

	// ARM resource ID of the component resource.
	ComponentID *string

	// ARM resource ID of the compute resource.
	ComputeID *string

	// The asset description text.
	Description *string

	// Display name of job.
	DisplayName *string

	// The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
	ExperimentName *string

	// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null. Defaults to AmlToken
	// if null.
	Identity IdentityConfigurationClassification

	// Inputs for the pipeline job.
	Inputs map[string]JobInputClassification

	// Is the asset archived?
	IsArchived *bool

	// Jobs construct the Pipeline Job.
	Jobs map[string]any

	// Outputs for the pipeline job
	Outputs map[string]JobOutputClassification

	// The asset property dictionary.
	Properties map[string]*string

	// List of JobEndpoints. For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
	Services map[string]*JobService

	// Pipeline settings, for things like ContinueRunOnStepFailure etc.
	Settings any

	// ARM resource ID of source job.
	SourceJobID *string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Status of the job.
	Status *JobStatus
}

// GetJobBaseProperties implements the JobBasePropertiesClassification interface for type PipelineJob.
func (p *PipelineJob) GetJobBaseProperties() *JobBaseProperties {
	return &JobBaseProperties{
		ComponentID:    p.ComponentID,
		ComputeID:      p.ComputeID,
		Description:    p.Description,
		DisplayName:    p.DisplayName,
		ExperimentName: p.ExperimentName,
		Identity:       p.Identity,
		IsArchived:     p.IsArchived,
		JobType:        p.JobType,
		Properties:     p.Properties,
		Services:       p.Services,
		Status:         p.Status,
		Tags:           p.Tags,
	}
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string

	// READ-ONLY; The ARM identifier for Subnet resource that private endpoint links to
	SubnetArmID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Specifies the location of the resource.
	Location *string

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// The sku of the workspace.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified workspace
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Specifies the location of the resource.
	Location *string

	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// The sku of the workspace.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// ProbeSettings - Deployment container liveness/readiness probe configuration.
type ProbeSettings struct {
	// The number of failures to allow before returning an unhealthy status.
	FailureThreshold *int32

	// The delay before the first probe in ISO 8601 format.
	InitialDelay *string

	// The length of time between probes in ISO 8601 format.
	Period *string

	// The number of successful probes before returning a healthy status.
	SuccessThreshold *int32

	// The probe timeout in ISO 8601 format.
	Timeout *string
}

// PyTorch distribution configuration.
type PyTorch struct {
	// REQUIRED; [Required] Specifies the type of distribution framework.
	DistributionType *DistributionType

	// Number of processes per node.
	ProcessCountPerInstance *int32
}

// GetDistributionConfiguration implements the DistributionConfigurationClassification interface for type PyTorch.
func (p *PyTorch) GetDistributionConfiguration() *DistributionConfiguration {
	return &DistributionConfiguration{
		DistributionType: p.DistributionType,
	}
}

// QuotaBaseProperties - The properties for Quota update or retrieval.
type QuotaBaseProperties struct {
	// Specifies the resource ID.
	ID *string

	// The maximum permitted quota of the resource.
	Limit *int64

	// Specifies the resource type.
	Type *string

	// An enum describing the unit of quota measurement.
	Unit *QuotaUnit
}

// QuotaUpdateParameters - Quota update parameters.
type QuotaUpdateParameters struct {
	// Region of workspace quota to be updated.
	Location *string

	// The list for update quota.
	Value []*QuotaBaseProperties
}

// RandomSamplingAlgorithm - Defines a Sampling Algorithm that generates values randomly
type RandomSamplingAlgorithm struct {
	// REQUIRED; [Required] The algorithm used for generating hyperparameter values, along with configuration properties
	SamplingAlgorithmType *SamplingAlgorithmType

	// The specific type of random algorithm
	Rule *RandomSamplingAlgorithmRule

	// An optional integer to use as the seed for random number generation
	Seed *int32
}

// GetSamplingAlgorithm implements the SamplingAlgorithmClassification interface for type RandomSamplingAlgorithm.
func (r *RandomSamplingAlgorithm) GetSamplingAlgorithm() *SamplingAlgorithm {
	return &SamplingAlgorithm{
		SamplingAlgorithmType: r.SamplingAlgorithmType,
	}
}

type RecurrenceSchedule struct {
	// REQUIRED; [Required] List of hours for the schedule.
	Hours []*int32

	// REQUIRED; [Required] List of minutes for the schedule.
	Minutes []*int32

	// List of month days for the schedule
	MonthDays []*int32

	// List of days for the schedule.
	WeekDays []*WeekDay
}

type RecurrenceTrigger struct {
	// REQUIRED; [Required] The frequency to trigger schedule.
	Frequency *RecurrenceFrequency

	// REQUIRED; [Required] Specifies schedule interval in conjunction with frequency
	Interval *int32

	// REQUIRED; [Required]
	TriggerType *TriggerType

	// Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601. Recommented
	// format would be "2022-06-01T00:00:01" If not present, the schedule will
	// run indefinitely
	EndTime *string

	// The recurrence schedule.
	Schedule *RecurrenceSchedule

	// Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
	StartTime *string

	// Specifies time zone in which the schedule runs. TimeZone should follow Windows time zone format. Refer:
	// https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
	TimeZone *string
}

// GetTriggerBase implements the TriggerBaseClassification interface for type RecurrenceTrigger.
func (r *RecurrenceTrigger) GetTriggerBase() *TriggerBase {
	return &TriggerBase{
		EndTime:     r.EndTime,
		StartTime:   r.StartTime,
		TimeZone:    r.TimeZone,
		TriggerType: r.TriggerType,
	}
}

type RegenerateEndpointKeysRequest struct {
	// REQUIRED; [Required] Specification for which type of key to generate. Primary or Secondary.
	KeyType *KeyType

	// The value the key is set to.
	KeyValue *string
}

type RegistryListCredentialsResult struct {
	Passwords []*Password

	// READ-ONLY
	Location *string

	// READ-ONLY
	Username *string
}

// Regression task in AutoML Table vertical.
type Regression struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Columns to use for CVSplit data.
	CvSplitColumnNames []*string

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *TableVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *TableVerticalLimitSettings

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Number of cross validation folds to be applied on training dataset when validation dataset is not provided.
	NCrossValidations NCrossValidationsClassification

	// Primary metric for regression task.
	PrimaryMetric *RegressionPrimaryMetrics

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Test data input.
	TestData *MLTableJobInput

	// The fraction of test dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied when
	// validation dataset is not provided.
	TestDataSize *float64

	// Inputs for training phase for an AutoML Job.
	TrainingSettings *RegressionTrainingSettings

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64

	// The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to
	// be weighted up or down.
	WeightColumnName *string
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type Regression.
func (r *Regression) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     r.LogVerbosity,
		TargetColumnName: r.TargetColumnName,
		TaskType:         r.TaskType,
		TrainingData:     r.TrainingData,
	}
}

// RegressionTrainingSettings - Regression Training related configuration.
type RegressionTrainingSettings struct {
	// Allowed models for regression task.
	AllowedTrainingAlgorithms []*RegressionModels

	// Blocked models for regression task.
	BlockedTrainingAlgorithms []*RegressionModels

	// Enable recommendation of DNN models.
	EnableDnnTraining *bool

	// Flag to turn on explainability on best model.
	EnableModelExplainability *bool

	// Flag for enabling onnx compatible models.
	EnableOnnxCompatibleModels *bool

	// Enable stack ensemble run.
	EnableStackEnsemble *bool

	// Enable voting ensemble run.
	EnableVoteEnsemble *bool

	// During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
	// Configure this parameter with a higher value than 300 secs, if more time
	// is needed.
	EnsembleModelDownloadTimeout *string

	// Stack ensemble settings for stack ensemble run.
	StackEnsembleSettings *StackEnsembleSettings
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ResourceBase struct {
	// The asset description text.
	Description *string

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

type ResourceConfiguration struct {
	// Optional number of instances or nodes used by the compute target.
	InstanceCount *int32

	// Optional type of VM used as supported by the compute target.
	InstanceType *string

	// Additional properties bag.
	Properties map[string]any
}

// ResourceID - Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.
type ResourceID struct {
	// REQUIRED; The ID of the resource
	ID *string
}

// ResourceName - The Resource Name.
type ResourceName struct {
	// READ-ONLY; The localized name of the resource.
	LocalizedValue *string

	// READ-ONLY; The name of the resource.
	Value *string
}

// ResourceQuota - The quota assigned to a resource.
type ResourceQuota struct {
	// READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; The maximum permitted quota of the resource.
	Limit *int64

	// READ-ONLY; Name of the resource.
	Name *ResourceName

	// READ-ONLY; Specifies the resource type.
	Type *string

	// READ-ONLY; An enum describing the unit of quota measurement.
	Unit *QuotaUnit
}

type Route struct {
	// REQUIRED; [Required] The path for the route.
	Path *string

	// REQUIRED; [Required] The port for the route.
	Port *int32
}

type SASAuthTypeWorkspaceConnectionProperties struct {
	// REQUIRED; Authentication type of the connection target
	AuthType *ConnectionAuthType

	// Category of the connection
	Category    *ConnectionCategory
	Credentials *WorkspaceConnectionSharedAccessSignature
	Target      *string

	// Value details of the workspace connection.
	Value *string

	// format for the workspace connection value
	ValueFormat *ValueFormat
}

// GetWorkspaceConnectionPropertiesV2 implements the WorkspaceConnectionPropertiesV2Classification interface for type SASAuthTypeWorkspaceConnectionProperties.
func (s *SASAuthTypeWorkspaceConnectionProperties) GetWorkspaceConnectionPropertiesV2() *WorkspaceConnectionPropertiesV2 {
	return &WorkspaceConnectionPropertiesV2{
		AuthType:    s.AuthType,
		Category:    s.Category,
		Target:      s.Target,
		Value:       s.Value,
		ValueFormat: s.ValueFormat,
	}
}

// SKU - The resource model definition representing SKU
type SKU struct {
	// REQUIRED; The name of the SKU. Ex - P3. It is typically a letter+number code
	Name *string

	// If the SKU supports scale out/in then the capacity integer should be included. If scale out/in is not possible for the
	// resource this may be omitted.
	Capacity *int32

	// If the service has different generations of hardware, for the same SKU, then that can be captured here.
	Family *string

	// The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
	Size *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// SKUCapacity - SKU capacity information
type SKUCapacity struct {
	// Gets or sets the default capacity.
	Default *int32

	// Gets or sets the maximum.
	Maximum *int32

	// Gets or sets the minimum.
	Minimum *int32

	// Gets or sets the type of the scale.
	ScaleType *SKUScaleType
}

// SKUResource - Fulfills ARM Contract requirement to list all available SKUS for a resource.
type SKUResource struct {
	// Gets or sets the Sku Capacity.
	Capacity *SKUCapacity

	// Gets or sets the Sku.
	SKU *SKUSetting

	// READ-ONLY; The resource type name.
	ResourceType *string
}

// SKUResourceArmPaginatedResult - A paginated list of SkuResource entities.
type SKUResourceArmPaginatedResult struct {
	// The link to the next page of SkuResource objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type SkuResource.
	Value []*SKUResource
}

// SKUSetting - SkuSetting fulfills the need for stripped down SKU info in ARM contract.
type SKUSetting struct {
	// REQUIRED; [Required] The name of the SKU. Ex - P3. It is typically a letter+number code.
	Name *string

	// This field is required to be implemented by the Resource Provider if the service has more than one tier, but is not required
	// on a PUT.
	Tier *SKUTier
}

// SSLConfiguration - The ssl configuration for scoring
type SSLConfiguration struct {
	// Cert data
	Cert *string

	// CNAME of the cert
	Cname *string

	// Key data
	Key *string

	// Leaf domain label of public endpoint
	LeafDomainLabel *string

	// Indicates whether to overwrite existing domain label.
	OverwriteExistingDomain *bool

	// Enable or disable ssl for scoring
	Status *SSLConfigStatus
}

// SamplingAlgorithm - The Sampling Algorithm used to generate hyperparameter values, along with properties to configure the
// algorithm
type SamplingAlgorithm struct {
	// REQUIRED; [Required] The algorithm used for generating hyperparameter values, along with configuration properties
	SamplingAlgorithmType *SamplingAlgorithmType
}

// GetSamplingAlgorithm implements the SamplingAlgorithmClassification interface for type SamplingAlgorithm.
func (s *SamplingAlgorithm) GetSamplingAlgorithm() *SamplingAlgorithm { return s }

// SasDatastoreCredentials - SAS datastore credentials configuration.
type SasDatastoreCredentials struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	CredentialsType *CredentialsType

	// REQUIRED; [Required] Storage container secrets.
	Secrets *SasDatastoreSecrets
}

// GetDatastoreCredentials implements the DatastoreCredentialsClassification interface for type SasDatastoreCredentials.
func (s *SasDatastoreCredentials) GetDatastoreCredentials() *DatastoreCredentials {
	return &DatastoreCredentials{
		CredentialsType: s.CredentialsType,
	}
}

// SasDatastoreSecrets - Datastore SAS secrets.
type SasDatastoreSecrets struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	SecretsType *SecretsType

	// Storage container SAS token.
	SasToken *string
}

// GetDatastoreSecrets implements the DatastoreSecretsClassification interface for type SasDatastoreSecrets.
func (s *SasDatastoreSecrets) GetDatastoreSecrets() *DatastoreSecrets {
	return &DatastoreSecrets{
		SecretsType: s.SecretsType,
	}
}

// ScaleSettings - scale settings for AML Compute
type ScaleSettings struct {
	// REQUIRED; Max number of nodes to use
	MaxNodeCount *int32

	// Min number of nodes to use
	MinNodeCount *int32

	// Node Idle Time before scaling down amlCompute. This string needs to be in the RFC Format.
	NodeIdleTimeBeforeScaleDown *string
}

// ScaleSettingsInformation - Desired scale settings for the amlCompute.
type ScaleSettingsInformation struct {
	// scale settings for AML Compute
	ScaleSettings *ScaleSettings
}

// Schedule - Azure Resource Manager resource envelope.
type Schedule struct {
	// REQUIRED; [Required] Additional attributes of the entity.
	Properties *ScheduleProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ScheduleActionBase struct {
	// REQUIRED; [Required] Specifies the action type of the schedule
	ActionType *ScheduleActionType
}

// GetScheduleActionBase implements the ScheduleActionBaseClassification interface for type ScheduleActionBase.
func (s *ScheduleActionBase) GetScheduleActionBase() *ScheduleActionBase { return s }

type ScheduleBase struct {
	// A system assigned id for the schedule.
	ID *string

	// The current deployment state of schedule.
	ProvisioningStatus *ScheduleProvisioningState

	// Is the schedule enabled or disabled?
	Status *ScheduleStatus
}

// ScheduleProperties - Base definition of a schedule
type ScheduleProperties struct {
	// REQUIRED; [Required] Specifies the action of the schedule
	Action ScheduleActionBaseClassification

	// REQUIRED; [Required] Specifies the trigger details
	Trigger TriggerBaseClassification

	// The asset description text.
	Description *string

	// Display name of schedule.
	DisplayName *string

	// Is the schedule enabled?
	IsEnabled *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Provisioning state for the schedule.
	ProvisioningState *ScheduleProvisioningStatus
}

// ScheduleResourceArmPaginatedResult - A paginated list of Schedule entities.
type ScheduleResourceArmPaginatedResult struct {
	// The link to the next page of Schedule objects. If null, there are no additional pages.
	NextLink *string

	// An array of objects of type Schedule.
	Value []*Schedule
}

// ScriptReference - Script reference
type ScriptReference struct {
	// Optional command line arguments passed to the script to run.
	ScriptArguments *string

	// The location of scripts in the mounted volume.
	ScriptData *string

	// The storage source of the script: workspace.
	ScriptSource *string

	// Optional time period passed to timeout command.
	Timeout *string
}

// ScriptsToExecute - Customized setup scripts
type ScriptsToExecute struct {
	// Script that's run only once during provision of the compute.
	CreationScript *ScriptReference

	// Script that's run every time the machine starts.
	StartupScript *ScriptReference
}

// Seasonality - Forecasting seasonality.
type Seasonality struct {
	// REQUIRED; [Required] Seasonality mode.
	Mode *SeasonalityMode
}

// GetSeasonality implements the SeasonalityClassification interface for type Seasonality.
func (s *Seasonality) GetSeasonality() *Seasonality { return s }

type ServiceManagedResourcesSettings struct {
	// The settings for the service managed cosmosdb account.
	CosmosDb *CosmosDbSettings
}

// ServicePrincipalDatastoreCredentials - Service Principal datastore credentials configuration.
type ServicePrincipalDatastoreCredentials struct {
	// REQUIRED; [Required] Service principal client ID.
	ClientID *string

	// REQUIRED; [Required] Credential type used to authentication with storage.
	CredentialsType *CredentialsType

	// REQUIRED; [Required] Service principal secrets.
	Secrets *ServicePrincipalDatastoreSecrets

	// REQUIRED; [Required] ID of the tenant to which the service principal belongs.
	TenantID *string

	// Authority URL used for authentication.
	AuthorityURL *string

	// Resource the service principal has access to.
	ResourceURL *string
}

// GetDatastoreCredentials implements the DatastoreCredentialsClassification interface for type ServicePrincipalDatastoreCredentials.
func (s *ServicePrincipalDatastoreCredentials) GetDatastoreCredentials() *DatastoreCredentials {
	return &DatastoreCredentials{
		CredentialsType: s.CredentialsType,
	}
}

// ServicePrincipalDatastoreSecrets - Datastore Service Principal secrets.
type ServicePrincipalDatastoreSecrets struct {
	// REQUIRED; [Required] Credential type used to authentication with storage.
	SecretsType *SecretsType

	// Service principal secret.
	ClientSecret *string
}

// GetDatastoreSecrets implements the DatastoreSecretsClassification interface for type ServicePrincipalDatastoreSecrets.
func (s *ServicePrincipalDatastoreSecrets) GetDatastoreSecrets() *DatastoreSecrets {
	return &DatastoreSecrets{
		SecretsType: s.SecretsType,
	}
}

// SetupScripts - Details of customized scripts to execute for setting up the cluster.
type SetupScripts struct {
	// Customized setup scripts
	Scripts *ScriptsToExecute
}

type SharedPrivateLinkResource struct {
	// Unique name of the private link.
	Name *string

	// Resource properties.
	Properties *SharedPrivateLinkResourceProperty
}

// SharedPrivateLinkResourceProperty - Properties of a shared private link resource.
type SharedPrivateLinkResourceProperty struct {
	// The private link resource group id.
	GroupID *string

	// The resource id that private link links to.
	PrivateLinkResourceID *string

	// Request message.
	RequestMessage *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// StackEnsembleSettings - Advances setting to customize StackEnsemble run.
type StackEnsembleSettings struct {
	// Optional parameters to pass to the initializer of the meta-learner.
	StackMetaLearnerKWargs any

	// Specifies the proportion of the training set (when choosing train and validation type of training) to be reserved for training
	// the meta-learner. Default value is 0.2.
	StackMetaLearnerTrainPercentage *float64

	// The meta-learner is a model trained on the output of the individual heterogeneous models.
	StackMetaLearnerType *StackMetaLearnerType
}

// SweepJob - Sweep job definition.
type SweepJob struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobType *JobType

	// REQUIRED; [Required] Optimization objective.
	Objective *Objective

	// REQUIRED; [Required] The hyperparameter sampling algorithm
	SamplingAlgorithm SamplingAlgorithmClassification

	// REQUIRED; [Required] A dictionary containing each parameter and its distribution. The dictionary key is the name of the
	// parameter
	SearchSpace any

	// REQUIRED; [Required] Trial component definition.
	Trial *TrialComponent

	// ARM resource ID of the component resource.
	ComponentID *string

	// ARM resource ID of the compute resource.
	ComputeID *string

	// The asset description text.
	Description *string

	// Display name of job.
	DisplayName *string

	// Early termination policies enable canceling poor-performing runs before they complete
	EarlyTermination EarlyTerminationPolicyClassification

	// The name of the experiment the job belongs to. If not set, the job is placed in the "Default" experiment.
	ExperimentName *string

	// Identity configuration. If set, this should be one of AmlToken, ManagedIdentity, UserIdentity or null. Defaults to AmlToken
	// if null.
	Identity IdentityConfigurationClassification

	// Mapping of input data bindings used in the job.
	Inputs map[string]JobInputClassification

	// Is the asset archived?
	IsArchived *bool

	// Sweep Job limit.
	Limits *SweepJobLimits

	// Mapping of output data bindings used in the job.
	Outputs map[string]JobOutputClassification

	// The asset property dictionary.
	Properties map[string]*string

	// List of JobEndpoints. For local jobs, a job endpoint will have an endpoint value of FileStreamObject.
	Services map[string]*JobService

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string

	// READ-ONLY; Status of the job.
	Status *JobStatus
}

// GetJobBaseProperties implements the JobBasePropertiesClassification interface for type SweepJob.
func (s *SweepJob) GetJobBaseProperties() *JobBaseProperties {
	return &JobBaseProperties{
		ComponentID:    s.ComponentID,
		ComputeID:      s.ComputeID,
		Description:    s.Description,
		DisplayName:    s.DisplayName,
		ExperimentName: s.ExperimentName,
		Identity:       s.Identity,
		IsArchived:     s.IsArchived,
		JobType:        s.JobType,
		Properties:     s.Properties,
		Services:       s.Services,
		Status:         s.Status,
		Tags:           s.Tags,
	}
}

// SweepJobLimits - Sweep Job limit class.
type SweepJobLimits struct {
	// REQUIRED; [Required] JobLimit type.
	JobLimitsType *JobLimitsType

	// Sweep Job max concurrent trials.
	MaxConcurrentTrials *int32

	// Sweep Job max total trials.
	MaxTotalTrials *int32

	// The max run duration in ISO 8601 format, after which the job will be cancelled. Only supports duration with precision as
	// low as Seconds.
	Timeout *string

	// Sweep Job Trial timeout value.
	TrialTimeout *string
}

// GetJobLimits implements the JobLimitsClassification interface for type SweepJobLimits.
func (s *SweepJobLimits) GetJobLimits() *JobLimits {
	return &JobLimits{
		JobLimitsType: s.JobLimitsType,
		Timeout:       s.Timeout,
	}
}

// SynapseSpark - A SynapseSpark compute.
type SynapseSpark struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool
	Properties       *SynapseSparkProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type SynapseSpark.
func (s *SynapseSpark) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    s.ComputeLocation,
		ComputeType:        s.ComputeType,
		CreatedOn:          s.CreatedOn,
		Description:        s.Description,
		DisableLocalAuth:   s.DisableLocalAuth,
		IsAttachedCompute:  s.IsAttachedCompute,
		ModifiedOn:         s.ModifiedOn,
		ProvisioningErrors: s.ProvisioningErrors,
		ProvisioningState:  s.ProvisioningState,
		ResourceID:         s.ResourceID,
	}
}

type SynapseSparkProperties struct {
	// Auto pause properties.
	AutoPauseProperties *AutoPauseProperties

	// Auto scale properties.
	AutoScaleProperties *AutoScaleProperties

	// The number of compute nodes currently assigned to the compute.
	NodeCount *int32

	// Node size.
	NodeSize *string

	// Node size family.
	NodeSizeFamily *string

	// Pool name.
	PoolName *string

	// Name of the resource group in which workspace is located.
	ResourceGroup *string

	// Spark version.
	SparkVersion *string

	// Azure subscription identifier.
	SubscriptionID *string

	// Name of Azure Machine Learning workspace.
	WorkspaceName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// SystemService - A system service running on a compute.
type SystemService struct {
	// READ-ONLY; Public IP address
	PublicIPAddress *string

	// READ-ONLY; The type of this system service.
	SystemServiceType *string

	// READ-ONLY; The version for this type.
	Version *string
}

// TableVertical - Abstract class for AutoML tasks that use table dataset as input - such as Classification/Regression/Forecasting.
type TableVertical struct {
	// Columns to use for CVSplit data.
	CvSplitColumnNames []*string

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *TableVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *TableVerticalLimitSettings

	// Number of cross validation folds to be applied on training dataset when validation dataset is not provided.
	NCrossValidations NCrossValidationsClassification

	// Test data input.
	TestData *MLTableJobInput

	// The fraction of test dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied when
	// validation dataset is not provided.
	TestDataSize *float64

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// The fraction of training dataset that needs to be set aside for validation purpose. Values between (0.0 , 1.0) Applied
	// when validation dataset is not provided.
	ValidationDataSize *float64

	// The name of the sample weight column. Automated ML supports a weighted column as an input, causing rows in the data to
	// be weighted up or down.
	WeightColumnName *string
}

// TableVerticalFeaturizationSettings - Featurization Configuration.
type TableVerticalFeaturizationSettings struct {
	// These transformers shall not be used in featurization.
	BlockedTransformers []*BlockedTransformers

	// Dictionary of column name and its type (int, float, string, datetime etc).
	ColumnNameAndTypes map[string]*string

	// Dataset language, useful for the text data.
	DatasetLanguage *string

	// Determines whether to use Dnn based featurizers for data featurization.
	EnableDnnFeaturization *bool

	// Featurization mode - User can keep the default 'Auto' mode and AutoML will take care of necessary transformation of the
	// data in featurization phase. If 'Off' is selected then no featurization is done.
	// If 'Custom' is selected then user can specify additional inputs to customize how featurization is done.
	Mode *FeaturizationMode

	// User can specify additional transformers to be used along with the columns to which it would be applied and parameters
	// for the transformer constructor.
	TransformerParams map[string][]*ColumnTransformer
}

// TableVerticalLimitSettings - Job execution constraints.
type TableVerticalLimitSettings struct {
	// Enable early termination, determines whether or not if AutoMLJob will terminate early if there is no score improvement
	// in last 20 iterations.
	EnableEarlyTermination *bool

	// Exit score for the AutoML job.
	ExitScore *float64

	// Maximum Concurrent iterations.
	MaxConcurrentTrials *int32

	// Max cores per iteration.
	MaxCoresPerTrial *int32

	// Number of iterations.
	MaxTrials *int32

	// AutoML job timeout.
	Timeout *string

	// Iteration timeout.
	TrialTimeout *string
}

// TargetLags - The number of past periods to lag from the target column.
type TargetLags struct {
	// REQUIRED; [Required] Set target lags mode - Auto/Custom
	Mode *TargetLagsMode
}

// GetTargetLags implements the TargetLagsClassification interface for type TargetLags.
func (t *TargetLags) GetTargetLags() *TargetLags { return t }

// TargetRollingWindowSize - Forecasting target rolling window size.
type TargetRollingWindowSize struct {
	// REQUIRED; [Required] TargetRollingWindowSiz detection mode.
	Mode *TargetRollingWindowSizeMode
}

// GetTargetRollingWindowSize implements the TargetRollingWindowSizeClassification interface for type TargetRollingWindowSize.
func (t *TargetRollingWindowSize) GetTargetRollingWindowSize() *TargetRollingWindowSize { return t }

type TargetUtilizationScaleSettings struct {
	// REQUIRED; [Required] Type of deployment scaling algorithm
	ScaleType *ScaleType

	// The maximum number of instances that the deployment can scale to. The quota will be reserved for max_instances.
	MaxInstances *int32

	// The minimum number of instances to always be present.
	MinInstances *int32

	// The polling interval in ISO 8691 format. Only supports duration with precision as low as Seconds.
	PollingInterval *string

	// Target CPU usage for the autoscaler.
	TargetUtilizationPercentage *int32
}

// GetOnlineScaleSettings implements the OnlineScaleSettingsClassification interface for type TargetUtilizationScaleSettings.
func (t *TargetUtilizationScaleSettings) GetOnlineScaleSettings() *OnlineScaleSettings {
	return &OnlineScaleSettings{
		ScaleType: t.ScaleType,
	}
}

// TensorFlow distribution configuration.
type TensorFlow struct {
	// REQUIRED; [Required] Specifies the type of distribution framework.
	DistributionType *DistributionType

	// Number of parameter server tasks.
	ParameterServerCount *int32

	// Number of workers. If not specified, will default to the instance count.
	WorkerCount *int32
}

// GetDistributionConfiguration implements the DistributionConfigurationClassification interface for type TensorFlow.
func (t *TensorFlow) GetDistributionConfiguration() *DistributionConfiguration {
	return &DistributionConfiguration{
		DistributionType: t.DistributionType,
	}
}

// TextClassification - Text Classification task in AutoML NLP vertical. NLP - Natural Language Processing.
type TextClassification struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *NlpVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *NlpVerticalLimitSettings

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Primary metric for Text-Classification task.
	PrimaryMetric *ClassificationPrimaryMetrics

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type TextClassification.
func (t *TextClassification) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     t.LogVerbosity,
		TargetColumnName: t.TargetColumnName,
		TaskType:         t.TaskType,
		TrainingData:     t.TrainingData,
	}
}

// TextClassificationMultilabel - Text Classification Multilabel task in AutoML NLP vertical. NLP - Natural Language Processing.
type TextClassificationMultilabel struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *NlpVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *NlpVerticalLimitSettings

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// READ-ONLY; Primary metric for Text-Classification-Multilabel task. Currently only Accuracy is supported as primary metric,
	// hence user need not set it explicitly.
	PrimaryMetric *ClassificationMultilabelPrimaryMetrics
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type TextClassificationMultilabel.
func (t *TextClassificationMultilabel) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     t.LogVerbosity,
		TargetColumnName: t.TargetColumnName,
		TaskType:         t.TaskType,
		TrainingData:     t.TrainingData,
	}
}

// TextNer - Text-NER task in AutoML NLP vertical. NER - Named Entity Recognition. NLP - Natural Language Processing.
type TextNer struct {
	// REQUIRED; [Required] Task type for AutoMLJob.
	TaskType *TaskType

	// REQUIRED; [Required] Training data input.
	TrainingData *MLTableJobInput

	// Featurization inputs needed for AutoML job.
	FeaturizationSettings *NlpVerticalFeaturizationSettings

	// Execution constraints for AutoMLJob.
	LimitSettings *NlpVerticalLimitSettings

	// Log verbosity for the job.
	LogVerbosity *LogVerbosity

	// Target column name: This is prediction values column. Also known as label column name in context of classification tasks.
	TargetColumnName *string

	// Validation data inputs.
	ValidationData *MLTableJobInput

	// READ-ONLY; Primary metric for Text-NER task. Only 'Accuracy' is supported for Text-NER, so user need not set this explicitly.
	PrimaryMetric *ClassificationPrimaryMetrics
}

// GetAutoMLVertical implements the AutoMLVerticalClassification interface for type TextNer.
func (t *TextNer) GetAutoMLVertical() *AutoMLVertical {
	return &AutoMLVertical{
		LogVerbosity:     t.LogVerbosity,
		TargetColumnName: t.TargetColumnName,
		TaskType:         t.TaskType,
		TrainingData:     t.TrainingData,
	}
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TrainingSettings - Training related configuration.
type TrainingSettings struct {
	// Enable recommendation of DNN models.
	EnableDnnTraining *bool

	// Flag to turn on explainability on best model.
	EnableModelExplainability *bool

	// Flag for enabling onnx compatible models.
	EnableOnnxCompatibleModels *bool

	// Enable stack ensemble run.
	EnableStackEnsemble *bool

	// Enable voting ensemble run.
	EnableVoteEnsemble *bool

	// During VotingEnsemble and StackEnsemble model generation, multiple fitted models from the previous child runs are downloaded.
	// Configure this parameter with a higher value than 300 secs, if more time
	// is needed.
	EnsembleModelDownloadTimeout *string

	// Stack ensemble settings for stack ensemble run.
	StackEnsembleSettings *StackEnsembleSettings
}

// TrialComponent - Trial component definition.
type TrialComponent struct {
	// REQUIRED; [Required] The command to execute on startup of the job. eg. "python train.py"
	Command *string

	// REQUIRED; [Required] The ARM resource ID of the Environment specification for the job.
	EnvironmentID *string

	// ARM resource ID of the code asset.
	CodeID *string

	// Distribution configuration of the job. If set, this should be one of Mpi, Tensorflow, PyTorch, or null.
	Distribution DistributionConfigurationClassification

	// Environment variables included in the job.
	EnvironmentVariables map[string]*string

	// Compute Resource configuration for the job.
	Resources *JobResourceConfiguration
}

type TriggerBase struct {
	// REQUIRED; [Required]
	TriggerType *TriggerType

	// Specifies end time of schedule in ISO 8601, but without a UTC offset. Refer https://en.wikipedia.org/wiki/ISO_8601. Recommented
	// format would be "2022-06-01T00:00:01" If not present, the schedule will
	// run indefinitely
	EndTime *string

	// Specifies start time of schedule in ISO 8601 format, but without a UTC offset.
	StartTime *string

	// Specifies time zone in which the schedule runs. TimeZone should follow Windows time zone format. Refer:
	// https://docs.microsoft.com/en-us/windows-hardware/manufacture/desktop/default-time-zones?view=windows-11
	TimeZone *string
}

// GetTriggerBase implements the TriggerBaseClassification interface for type TriggerBase.
func (t *TriggerBase) GetTriggerBase() *TriggerBase { return t }

type TritonModelJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Description for the input.
	Description *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// GetJobInput implements the JobInputClassification interface for type TritonModelJobInput.
func (t *TritonModelJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  t.Description,
		JobInputType: t.JobInputType,
	}
}

type TritonModelJobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string

	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// GetJobOutput implements the JobOutputClassification interface for type TritonModelJobOutput.
func (t *TritonModelJobOutput) GetJobOutput() *JobOutput {
	return &JobOutput{
		Description:   t.Description,
		JobOutputType: t.JobOutputType,
	}
}

// TruncationSelectionPolicy - Defines an early termination policy that cancels a given percentage of runs at each evaluation
// interval.
type TruncationSelectionPolicy struct {
	// REQUIRED; [Required] Name of policy configuration
	PolicyType *EarlyTerminationPolicyType

	// Number of intervals by which to delay the first evaluation.
	DelayEvaluation *int32

	// Interval (number of runs) between policy evaluations.
	EvaluationInterval *int32

	// The percentage of runs to cancel at each evaluation interval.
	TruncationPercentage *int32
}

// GetEarlyTerminationPolicy implements the EarlyTerminationPolicyClassification interface for type TruncationSelectionPolicy.
func (t *TruncationSelectionPolicy) GetEarlyTerminationPolicy() *EarlyTerminationPolicy {
	return &EarlyTerminationPolicy{
		DelayEvaluation:    t.DelayEvaluation,
		EvaluationInterval: t.EvaluationInterval,
		PolicyType:         t.PolicyType,
	}
}

// URIFileDataVersion - uri-file data version entity
type URIFileDataVersion struct {
	// REQUIRED; [Required] Specifies the type of data.
	DataType *DataType

	// REQUIRED; [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
	DataURI *string

	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// GetDataVersionBaseProperties implements the DataVersionBasePropertiesClassification interface for type URIFileDataVersion.
func (u *URIFileDataVersion) GetDataVersionBaseProperties() *DataVersionBaseProperties {
	return &DataVersionBaseProperties{
		DataType:    u.DataType,
		DataURI:     u.DataURI,
		Description: u.Description,
		IsAnonymous: u.IsAnonymous,
		IsArchived:  u.IsArchived,
		Properties:  u.Properties,
		Tags:        u.Tags,
	}
}

type URIFileJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Description for the input.
	Description *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// GetJobInput implements the JobInputClassification interface for type URIFileJobInput.
func (u *URIFileJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  u.Description,
		JobInputType: u.JobInputType,
	}
}

type URIFileJobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string

	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// GetJobOutput implements the JobOutputClassification interface for type URIFileJobOutput.
func (u *URIFileJobOutput) GetJobOutput() *JobOutput {
	return &JobOutput{
		Description:   u.Description,
		JobOutputType: u.JobOutputType,
	}
}

// URIFolderDataVersion - uri-folder data version entity
type URIFolderDataVersion struct {
	// REQUIRED; [Required] Specifies the type of data.
	DataType *DataType

	// REQUIRED; [Required] Uri of the data. Usage/meaning depends on Microsoft.MachineLearning.ManagementFrontEnd.Contracts.V20221001.Assets.DataVersionBase.DataType
	DataURI *string

	// The asset description text.
	Description *string

	// If the name version are system generated (anonymous registration).
	IsAnonymous *bool

	// Is the asset archived?
	IsArchived *bool

	// The asset property dictionary.
	Properties map[string]*string

	// Tag dictionary. Tags can be added, removed, and updated.
	Tags map[string]*string
}

// GetDataVersionBaseProperties implements the DataVersionBasePropertiesClassification interface for type URIFolderDataVersion.
func (u *URIFolderDataVersion) GetDataVersionBaseProperties() *DataVersionBaseProperties {
	return &DataVersionBaseProperties{
		DataType:    u.DataType,
		DataURI:     u.DataURI,
		Description: u.Description,
		IsAnonymous: u.IsAnonymous,
		IsArchived:  u.IsArchived,
		Properties:  u.Properties,
		Tags:        u.Tags,
	}
}

type URIFolderJobInput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobInputType *JobInputType

	// REQUIRED; [Required] Input Asset URI.
	URI *string

	// Description for the input.
	Description *string

	// Input Asset Delivery Mode.
	Mode *InputDeliveryMode
}

// GetJobInput implements the JobInputClassification interface for type URIFolderJobInput.
func (u *URIFolderJobInput) GetJobInput() *JobInput {
	return &JobInput{
		Description:  u.Description,
		JobInputType: u.JobInputType,
	}
}

type URIFolderJobOutput struct {
	// REQUIRED; [Required] Specifies the type of job.
	JobOutputType *JobOutputType

	// Description for the output.
	Description *string

	// Output Asset Delivery Mode.
	Mode *OutputDeliveryMode

	// Output Asset URI.
	URI *string
}

// GetJobOutput implements the JobOutputClassification interface for type URIFolderJobOutput.
func (u *URIFolderJobOutput) GetJobOutput() *JobOutput {
	return &JobOutput{
		Description:   u.Description,
		JobOutputType: u.JobOutputType,
	}
}

// UpdateWorkspaceQuotas - The properties for update Quota response.
type UpdateWorkspaceQuotas struct {
	// The maximum permitted quota of the resource.
	Limit *int64

	// Status of update workspace quota.
	Status *Status

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; Specifies the resource type.
	Type *string

	// READ-ONLY; An enum describing the unit of quota measurement.
	Unit *QuotaUnit
}

// UpdateWorkspaceQuotasResult - The result of update workspace quota.
type UpdateWorkspaceQuotasResult struct {
	// READ-ONLY; The URI to fetch the next page of workspace quota update result. Call ListNext() with this to fetch the next
	// page of Workspace Quota update result.
	NextLink *string

	// READ-ONLY; The list of workspace quota update result.
	Value []*UpdateWorkspaceQuotas
}

// Usage - Describes AML Resource Usage.
type Usage struct {
	// READ-ONLY; Region of the AML workspace in the id.
	AmlWorkspaceLocation *string

	// READ-ONLY; The current usage of the resource.
	CurrentValue *int64

	// READ-ONLY; Specifies the resource ID.
	ID *string

	// READ-ONLY; The maximum permitted usage of the resource.
	Limit *int64

	// READ-ONLY; The name of the type of usage.
	Name *UsageName

	// READ-ONLY; Specifies the resource type.
	Type *string

	// READ-ONLY; An enum describing the unit of usage measurement.
	Unit *UsageUnit
}

// UsageName - The Usage Names.
type UsageName struct {
	// READ-ONLY; The localized name of the resource.
	LocalizedValue *string

	// READ-ONLY; The name of the resource.
	Value *string
}

// UserAccountCredentials - Settings for user account that gets created on each on the nodes of a compute.
type UserAccountCredentials struct {
	// REQUIRED; Name of the administrator user account which can be used to SSH to nodes.
	AdminUserName *string

	// Password of the administrator user account.
	AdminUserPassword *string

	// SSH public key of the administrator user account.
	AdminUserSSHPublicKey *string
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// UserIdentity - User identity configuration.
type UserIdentity struct {
	// REQUIRED; [Required] Specifies the type of identity framework.
	IdentityType *IdentityConfigurationType
}

// GetIdentityConfiguration implements the IdentityConfigurationClassification interface for type UserIdentity.
func (u *UserIdentity) GetIdentityConfiguration() *IdentityConfiguration {
	return &IdentityConfiguration{
		IdentityType: u.IdentityType,
	}
}

type UsernamePasswordAuthTypeWorkspaceConnectionProperties struct {
	// REQUIRED; Authentication type of the connection target
	AuthType *ConnectionAuthType

	// Category of the connection
	Category    *ConnectionCategory
	Credentials *WorkspaceConnectionUsernamePassword
	Target      *string

	// Value details of the workspace connection.
	Value *string

	// format for the workspace connection value
	ValueFormat *ValueFormat
}

// GetWorkspaceConnectionPropertiesV2 implements the WorkspaceConnectionPropertiesV2Classification interface for type UsernamePasswordAuthTypeWorkspaceConnectionProperties.
func (u *UsernamePasswordAuthTypeWorkspaceConnectionProperties) GetWorkspaceConnectionPropertiesV2() *WorkspaceConnectionPropertiesV2 {
	return &WorkspaceConnectionPropertiesV2{
		AuthType:    u.AuthType,
		Category:    u.Category,
		Target:      u.Target,
		Value:       u.Value,
		ValueFormat: u.ValueFormat,
	}
}

// VirtualMachine - A Machine Learning compute based on Azure Virtual Machines.
type VirtualMachine struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Location for the underlying compute
	ComputeLocation *string

	// The description of the Machine Learning compute.
	Description *string

	// Opt-out of local authentication and ensure customers can use only MSI and AAD exclusively for authentication.
	DisableLocalAuth *bool
	Properties       *VirtualMachineSchemaProperties

	// ARM resource id of the underlying compute
	ResourceID *string

	// READ-ONLY; The time at which the compute was created.
	CreatedOn *time.Time

	// READ-ONLY; Indicating whether the compute was provisioned by user and brought from outside if true, or machine learning
	// service provisioned it if false.
	IsAttachedCompute *bool

	// READ-ONLY; The time at which the compute was last modified.
	ModifiedOn *time.Time

	// READ-ONLY; Errors during provisioning
	ProvisioningErrors []*ErrorResponse

	// READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed.
	ProvisioningState *ProvisioningState
}

// GetCompute implements the ComputeClassification interface for type VirtualMachine.
func (v *VirtualMachine) GetCompute() *Compute {
	return &Compute{
		ComputeLocation:    v.ComputeLocation,
		ComputeType:        v.ComputeType,
		CreatedOn:          v.CreatedOn,
		Description:        v.Description,
		DisableLocalAuth:   v.DisableLocalAuth,
		IsAttachedCompute:  v.IsAttachedCompute,
		ModifiedOn:         v.ModifiedOn,
		ProvisioningErrors: v.ProvisioningErrors,
		ProvisioningState:  v.ProvisioningState,
		ResourceID:         v.ResourceID,
	}
}

// VirtualMachineImage - Virtual Machine image for Windows AML Compute
type VirtualMachineImage struct {
	// REQUIRED; Virtual Machine image path
	ID *string
}

// VirtualMachineSSHCredentials - Admin credentials for virtual machine
type VirtualMachineSSHCredentials struct {
	// Password of admin account
	Password *string

	// Private key data
	PrivateKeyData *string

	// Public key data
	PublicKeyData *string

	// Username of admin account
	Username *string
}

type VirtualMachineSchema struct {
	Properties *VirtualMachineSchemaProperties
}

type VirtualMachineSchemaProperties struct {
	// Public IP address of the virtual machine.
	Address *string

	// Admin credentials for virtual machine
	AdministratorAccount *VirtualMachineSSHCredentials

	// Indicates whether this compute will be used for running notebooks.
	IsNotebookInstanceCompute *bool

	// Notebook server port open for ssh connections.
	NotebookServerPort *int32

	// Port open for ssh connections.
	SSHPort *int32

	// Virtual Machine size
	VirtualMachineSize *string
}

// VirtualMachineSecrets - Secrets related to a Machine Learning compute based on AKS.
type VirtualMachineSecrets struct {
	// REQUIRED; The type of compute
	ComputeType *ComputeType

	// Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials
}

// GetComputeSecrets implements the ComputeSecretsClassification interface for type VirtualMachineSecrets.
func (v *VirtualMachineSecrets) GetComputeSecrets() *ComputeSecrets {
	return &ComputeSecrets{
		ComputeType: v.ComputeType,
	}
}

type VirtualMachineSecretsSchema struct {
	// Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials
}

// VirtualMachineSize - Describes the properties of a VM size.
type VirtualMachineSize struct {
	// The estimated price information for using a VM.
	EstimatedVMPrices *EstimatedVMPrices

	// Specifies the compute types supported by the virtual machine size.
	SupportedComputeTypes []*string

	// READ-ONLY; The family name of the virtual machine size.
	Family *string

	// READ-ONLY; The number of gPUs supported by the virtual machine size.
	Gpus *int32

	// READ-ONLY; Specifies if the virtual machine size supports low priority VMs.
	LowPriorityCapable *bool

	// READ-ONLY; The resource volume size, in MB, allowed by the virtual machine size.
	MaxResourceVolumeMB *int32

	// READ-ONLY; The amount of memory, in GB, supported by the virtual machine size.
	MemoryGB *float64

	// READ-ONLY; The name of the virtual machine size.
	Name *string

	// READ-ONLY; The OS VHD disk size, in MB, allowed by the virtual machine size.
	OSVhdSizeMB *int32

	// READ-ONLY; Specifies if the virtual machine size supports premium IO.
	PremiumIO *bool

	// READ-ONLY; The number of vCPUs supported by the virtual machine size.
	VCPUs *int32
}

// VirtualMachineSizeListResult - The List Virtual Machine size operation response.
type VirtualMachineSizeListResult struct {
	// The list of virtual machine sizes supported by AmlCompute.
	Value []*VirtualMachineSize
}

// Workspace - An object that represents a machine learning workspace.
type Workspace struct {
	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// Specifies the location of the resource.
	Location *string

	// The properties of the machine learning workspace.
	Properties *WorkspaceProperties

	// The sku of the workspace.
	SKU *SKU

	// Contains resource tags defined as key/value pairs.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type WorkspaceConnectionManagedIdentity struct {
	ClientID   *string
	ResourceID *string
}

type WorkspaceConnectionPersonalAccessToken struct {
	Pat *string
}

type WorkspaceConnectionPropertiesV2 struct {
	// REQUIRED; Authentication type of the connection target
	AuthType *ConnectionAuthType

	// Category of the connection
	Category *ConnectionCategory
	Target   *string

	// Value details of the workspace connection.
	Value *string

	// format for the workspace connection value
	ValueFormat *ValueFormat
}

// GetWorkspaceConnectionPropertiesV2 implements the WorkspaceConnectionPropertiesV2Classification interface for type WorkspaceConnectionPropertiesV2.
func (w *WorkspaceConnectionPropertiesV2) GetWorkspaceConnectionPropertiesV2() *WorkspaceConnectionPropertiesV2 {
	return w
}

type WorkspaceConnectionPropertiesV2BasicResource struct {
	// REQUIRED
	Properties WorkspaceConnectionPropertiesV2Classification

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult struct {
	Value []*WorkspaceConnectionPropertiesV2BasicResource

	// READ-ONLY
	NextLink *string
}

type WorkspaceConnectionSharedAccessSignature struct {
	Sas *string
}

type WorkspaceConnectionUsernamePassword struct {
	Password *string
	Username *string
}

// WorkspaceListResult - The result of a request to list machine learning workspaces.
type WorkspaceListResult struct {
	// The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string

	// The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request
	// the next list of machine learning workspaces.
	Value []*Workspace
}

// WorkspaceProperties - The properties of a machine learning workspace.
type WorkspaceProperties struct {
	// The flag to indicate whether to allow public access when behind VNet.
	AllowPublicAccessWhenBehindVnet *bool

	// ARM id of the application insights associated with this workspace.
	ApplicationInsights *string

	// ARM id of the container registry associated with this workspace.
	ContainerRegistry *string

	// The description of this workspace.
	Description *string

	// Url for the discovery service to identify regional endpoints for machine learning experimentation services
	DiscoveryURL *string

	// The encryption settings of Azure ML workspace.
	Encryption *EncryptionProperty

	// The friendly name for this workspace. This name in mutable
	FriendlyName *string

	// The flag to signal HBI data in the workspace and reduce diagnostic data collected by the service
	HbiWorkspace *bool

	// The compute name for image build
	ImageBuildCompute *string

	// ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
	KeyVault *string

	// The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string

	// Whether requests from Public Network are allowed.
	PublicNetworkAccess *PublicNetworkAccess

	// The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings

	// The list of shared private link resources in this workspace.
	SharedPrivateLinkResources []*SharedPrivateLinkResource

	// ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
	StorageAccount *string

	// Enabling v1legacymode may prevent you from using features provided by the v2 API.
	V1LegacyMode *bool

	// READ-ONLY; The URI associated with this workspace that machine learning flow must point at to set up tracking.
	MlFlowTrackingURI *string

	// READ-ONLY; The notebook info of Azure ML workspace.
	NotebookInfo *NotebookResourceInfo

	// READ-ONLY; The list of private endpoint connections in the workspace.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Count of private connections in the workspace
	PrivateLinkCount *int32

	// READ-ONLY; The current deployment state of workspace resource. The provisioningState is to indicate states for resource
	// provisioning.
	ProvisioningState *ProvisioningState

	// READ-ONLY; The name of the managed resource group created by workspace RP in customer subscription if the workspace is
	// CMK workspace
	ServiceProvisionedResourceGroup *string

	// READ-ONLY; If the storage associated with the workspace has hierarchical namespace(HNS) enabled.
	StorageHnsEnabled *bool

	// READ-ONLY; The tenant id associated with this workspace.
	TenantID *string

	// READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string
}

// WorkspacePropertiesUpdateParameters - The parameters for updating the properties of a machine learning workspace.
type WorkspacePropertiesUpdateParameters struct {
	// ARM id of the application insights associated with this workspace.
	ApplicationInsights *string

	// ARM id of the container registry associated with this workspace.
	ContainerRegistry *string

	// The description of this workspace.
	Description *string

	// The friendly name for this workspace.
	FriendlyName *string

	// The compute name for image build
	ImageBuildCompute *string

	// The user assigned identity resource id that represents the workspace identity.
	PrimaryUserAssignedIdentity *string

	// Whether requests from Public Network are allowed.
	PublicNetworkAccess *PublicNetworkAccess

	// The service managed resource settings.
	ServiceManagedResourcesSettings *ServiceManagedResourcesSettings
}

// WorkspaceUpdateParameters - The parameters for updating a machine learning workspace.
type WorkspaceUpdateParameters struct {
	// The identity of the resource.
	Identity *ManagedServiceIdentity

	// The properties that the machine learning workspace will be updated with.
	Properties *WorkspacePropertiesUpdateParameters

	// The sku of the workspace.
	SKU *SKU

	// The resource tags for the machine learning workspace.
	Tags map[string]*string
}
