//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmachinelearning

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AKS.
func (a AKS) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", a.ComputeLocation)
	objectMap["computeType"] = ComputeTypeAKS
	populateDateTimeRFC3339(objectMap, "createdOn", a.CreatedOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", a.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", a.ModifiedOn)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "provisioningErrors", a.ProvisioningErrors)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceId", a.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AKS.
func (a *AKS) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &a.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &a.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &a.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &a.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &a.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &a.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AKSSchema.
func (a AKSSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AKSSchema.
func (a *AKSSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AKSSchemaProperties.
func (a AKSSchemaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentCount", a.AgentCount)
	populate(objectMap, "agentVmSize", a.AgentVMSize)
	populate(objectMap, "aksNetworkingConfiguration", a.AksNetworkingConfiguration)
	populate(objectMap, "clusterFqdn", a.ClusterFqdn)
	populate(objectMap, "clusterPurpose", a.ClusterPurpose)
	populate(objectMap, "loadBalancerSubnet", a.LoadBalancerSubnet)
	populate(objectMap, "loadBalancerType", a.LoadBalancerType)
	populate(objectMap, "sslConfiguration", a.SSLConfiguration)
	populate(objectMap, "systemServices", a.SystemServices)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AKSSchemaProperties.
func (a *AKSSchemaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentCount":
			err = unpopulate(val, "AgentCount", &a.AgentCount)
			delete(rawMsg, key)
		case "agentVmSize":
			err = unpopulate(val, "AgentVMSize", &a.AgentVMSize)
			delete(rawMsg, key)
		case "aksNetworkingConfiguration":
			err = unpopulate(val, "AksNetworkingConfiguration", &a.AksNetworkingConfiguration)
			delete(rawMsg, key)
		case "clusterFqdn":
			err = unpopulate(val, "ClusterFqdn", &a.ClusterFqdn)
			delete(rawMsg, key)
		case "clusterPurpose":
			err = unpopulate(val, "ClusterPurpose", &a.ClusterPurpose)
			delete(rawMsg, key)
		case "loadBalancerSubnet":
			err = unpopulate(val, "LoadBalancerSubnet", &a.LoadBalancerSubnet)
			delete(rawMsg, key)
		case "loadBalancerType":
			err = unpopulate(val, "LoadBalancerType", &a.LoadBalancerType)
			delete(rawMsg, key)
		case "sslConfiguration":
			err = unpopulate(val, "SSLConfiguration", &a.SSLConfiguration)
			delete(rawMsg, key)
		case "systemServices":
			err = unpopulate(val, "SystemServices", &a.SystemServices)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountKeyDatastoreCredentials.
func (a AccountKeyDatastoreCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["credentialsType"] = CredentialsTypeAccountKey
	populate(objectMap, "secrets", a.Secrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountKeyDatastoreCredentials.
func (a *AccountKeyDatastoreCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentialsType":
			err = unpopulate(val, "CredentialsType", &a.CredentialsType)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &a.Secrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccountKeyDatastoreSecrets.
func (a AccountKeyDatastoreSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "key", a.Key)
	objectMap["secretsType"] = SecretsTypeAccountKey
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccountKeyDatastoreSecrets.
func (a *AccountKeyDatastoreSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "key":
			err = unpopulate(val, "Key", &a.Key)
			delete(rawMsg, key)
		case "secretsType":
			err = unpopulate(val, "SecretsType", &a.SecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AksComputeSecrets.
func (a AksComputeSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminKubeConfig", a.AdminKubeConfig)
	objectMap["computeType"] = ComputeTypeAKS
	populate(objectMap, "imagePullSecretName", a.ImagePullSecretName)
	populate(objectMap, "userKubeConfig", a.UserKubeConfig)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AksComputeSecrets.
func (a *AksComputeSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminKubeConfig":
			err = unpopulate(val, "AdminKubeConfig", &a.AdminKubeConfig)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &a.ComputeType)
			delete(rawMsg, key)
		case "imagePullSecretName":
			err = unpopulate(val, "ImagePullSecretName", &a.ImagePullSecretName)
			delete(rawMsg, key)
		case "userKubeConfig":
			err = unpopulate(val, "UserKubeConfig", &a.UserKubeConfig)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AksComputeSecretsProperties.
func (a AksComputeSecretsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminKubeConfig", a.AdminKubeConfig)
	populate(objectMap, "imagePullSecretName", a.ImagePullSecretName)
	populate(objectMap, "userKubeConfig", a.UserKubeConfig)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AksComputeSecretsProperties.
func (a *AksComputeSecretsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminKubeConfig":
			err = unpopulate(val, "AdminKubeConfig", &a.AdminKubeConfig)
			delete(rawMsg, key)
		case "imagePullSecretName":
			err = unpopulate(val, "ImagePullSecretName", &a.ImagePullSecretName)
			delete(rawMsg, key)
		case "userKubeConfig":
			err = unpopulate(val, "UserKubeConfig", &a.UserKubeConfig)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AksNetworkingConfiguration.
func (a AksNetworkingConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServiceIP", a.DNSServiceIP)
	populate(objectMap, "dockerBridgeCidr", a.DockerBridgeCidr)
	populate(objectMap, "serviceCidr", a.ServiceCidr)
	populate(objectMap, "subnetId", a.SubnetID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AksNetworkingConfiguration.
func (a *AksNetworkingConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServiceIP":
			err = unpopulate(val, "DNSServiceIP", &a.DNSServiceIP)
			delete(rawMsg, key)
		case "dockerBridgeCidr":
			err = unpopulate(val, "DockerBridgeCidr", &a.DockerBridgeCidr)
			delete(rawMsg, key)
		case "serviceCidr":
			err = unpopulate(val, "ServiceCidr", &a.ServiceCidr)
			delete(rawMsg, key)
		case "subnetId":
			err = unpopulate(val, "SubnetID", &a.SubnetID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlCompute.
func (a AmlCompute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", a.ComputeLocation)
	objectMap["computeType"] = ComputeTypeAmlCompute
	populateDateTimeRFC3339(objectMap, "createdOn", a.CreatedOn)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "disableLocalAuth", a.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", a.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", a.ModifiedOn)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "provisioningErrors", a.ProvisioningErrors)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "resourceId", a.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlCompute.
func (a *AmlCompute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &a.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &a.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &a.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &a.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &a.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &a.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &a.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &a.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlComputeNodeInformation.
func (a AmlComputeNodeInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodeId", a.NodeID)
	populate(objectMap, "nodeState", a.NodeState)
	populate(objectMap, "port", a.Port)
	populate(objectMap, "privateIpAddress", a.PrivateIPAddress)
	populate(objectMap, "publicIpAddress", a.PublicIPAddress)
	populate(objectMap, "runId", a.RunID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlComputeNodeInformation.
func (a *AmlComputeNodeInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodeId":
			err = unpopulate(val, "NodeID", &a.NodeID)
			delete(rawMsg, key)
		case "nodeState":
			err = unpopulate(val, "NodeState", &a.NodeState)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &a.Port)
			delete(rawMsg, key)
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &a.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &a.PublicIPAddress)
			delete(rawMsg, key)
		case "runId":
			err = unpopulate(val, "RunID", &a.RunID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlComputeNodesInformation.
func (a AmlComputeNodesInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "nodes", a.Nodes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlComputeNodesInformation.
func (a *AmlComputeNodesInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "nodes":
			err = unpopulate(val, "Nodes", &a.Nodes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlComputeProperties.
func (a AmlComputeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocationState", a.AllocationState)
	populateDateTimeRFC3339(objectMap, "allocationStateTransitionTime", a.AllocationStateTransitionTime)
	populate(objectMap, "currentNodeCount", a.CurrentNodeCount)
	populate(objectMap, "enableNodePublicIp", a.EnableNodePublicIP)
	populate(objectMap, "errors", a.Errors)
	populate(objectMap, "isolatedNetwork", a.IsolatedNetwork)
	populate(objectMap, "nodeStateCounts", a.NodeStateCounts)
	populate(objectMap, "osType", a.OSType)
	populateAny(objectMap, "propertyBag", a.PropertyBag)
	populate(objectMap, "remoteLoginPortPublicAccess", a.RemoteLoginPortPublicAccess)
	populate(objectMap, "scaleSettings", a.ScaleSettings)
	populate(objectMap, "subnet", a.Subnet)
	populate(objectMap, "targetNodeCount", a.TargetNodeCount)
	populate(objectMap, "userAccountCredentials", a.UserAccountCredentials)
	populate(objectMap, "vmPriority", a.VMPriority)
	populate(objectMap, "vmSize", a.VMSize)
	populate(objectMap, "virtualMachineImage", a.VirtualMachineImage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlComputeProperties.
func (a *AmlComputeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocationState":
			err = unpopulate(val, "AllocationState", &a.AllocationState)
			delete(rawMsg, key)
		case "allocationStateTransitionTime":
			err = unpopulateDateTimeRFC3339(val, "AllocationStateTransitionTime", &a.AllocationStateTransitionTime)
			delete(rawMsg, key)
		case "currentNodeCount":
			err = unpopulate(val, "CurrentNodeCount", &a.CurrentNodeCount)
			delete(rawMsg, key)
		case "enableNodePublicIp":
			err = unpopulate(val, "EnableNodePublicIP", &a.EnableNodePublicIP)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &a.Errors)
			delete(rawMsg, key)
		case "isolatedNetwork":
			err = unpopulate(val, "IsolatedNetwork", &a.IsolatedNetwork)
			delete(rawMsg, key)
		case "nodeStateCounts":
			err = unpopulate(val, "NodeStateCounts", &a.NodeStateCounts)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "propertyBag":
			err = unpopulate(val, "PropertyBag", &a.PropertyBag)
			delete(rawMsg, key)
		case "remoteLoginPortPublicAccess":
			err = unpopulate(val, "RemoteLoginPortPublicAccess", &a.RemoteLoginPortPublicAccess)
			delete(rawMsg, key)
		case "scaleSettings":
			err = unpopulate(val, "ScaleSettings", &a.ScaleSettings)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &a.Subnet)
			delete(rawMsg, key)
		case "targetNodeCount":
			err = unpopulate(val, "TargetNodeCount", &a.TargetNodeCount)
			delete(rawMsg, key)
		case "userAccountCredentials":
			err = unpopulate(val, "UserAccountCredentials", &a.UserAccountCredentials)
			delete(rawMsg, key)
		case "vmPriority":
			err = unpopulate(val, "VMPriority", &a.VMPriority)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		case "virtualMachineImage":
			err = unpopulate(val, "VirtualMachineImage", &a.VirtualMachineImage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlComputeSchema.
func (a AmlComputeSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlComputeSchema.
func (a *AmlComputeSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlOperation.
func (a AmlOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", a.Display)
	populate(objectMap, "isDataAction", a.IsDataAction)
	populate(objectMap, "name", a.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlOperation.
func (a *AmlOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &a.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &a.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlOperationDisplay.
func (a AmlOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "operation", a.Operation)
	populate(objectMap, "provider", a.Provider)
	populate(objectMap, "resource", a.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlOperationDisplay.
func (a *AmlOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &a.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &a.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &a.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlOperationListResult.
func (a AmlOperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlOperationListResult.
func (a *AmlOperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlToken.
func (a AmlToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["identityType"] = IdentityConfigurationTypeAMLToken
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlToken.
func (a *AmlToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityType":
			err = unpopulate(val, "IdentityType", &a.IdentityType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AmlUserFeature.
func (a AmlUserFeature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "id", a.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AmlUserFeature.
func (a *AmlUserFeature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetBase.
func (a AssetBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isAnonymous", a.IsAnonymous)
	populate(objectMap, "isArchived", a.IsArchived)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetBase.
func (a *AssetBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &a.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &a.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetContainer.
func (a AssetContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isArchived", a.IsArchived)
	populate(objectMap, "latestVersion", a.LatestVersion)
	populate(objectMap, "nextVersion", a.NextVersion)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetContainer.
func (a *AssetContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &a.IsArchived)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &a.LatestVersion)
			delete(rawMsg, key)
		case "nextVersion":
			err = unpopulate(val, "NextVersion", &a.NextVersion)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetJobInput.
func (a AssetJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mode", a.Mode)
	populate(objectMap, "uri", a.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetJobInput.
func (a *AssetJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &a.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetJobOutput.
func (a AssetJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mode", a.Mode)
	populate(objectMap, "uri", a.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetJobOutput.
func (a *AssetJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &a.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssetReferenceBase.
func (a AssetReferenceBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["referenceType"] = a.ReferenceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssetReferenceBase.
func (a *AssetReferenceBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "referenceType":
			err = unpopulate(val, "ReferenceType", &a.ReferenceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssignedUser.
func (a AssignedUser) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "objectId", a.ObjectID)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssignedUser.
func (a *AssignedUser) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "objectId":
			err = unpopulate(val, "ObjectID", &a.ObjectID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoForecastHorizon.
func (a AutoForecastHorizon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = ForecastHorizonModeAuto
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoForecastHorizon.
func (a *AutoForecastHorizon) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoMLJob.
func (a AutoMLJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", a.ComponentID)
	populate(objectMap, "computeId", a.ComputeID)
	populate(objectMap, "description", a.Description)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "environmentId", a.EnvironmentID)
	populate(objectMap, "environmentVariables", a.EnvironmentVariables)
	populate(objectMap, "experimentName", a.ExperimentName)
	populate(objectMap, "identity", a.Identity)
	populate(objectMap, "isArchived", a.IsArchived)
	objectMap["jobType"] = JobTypeAutoML
	populate(objectMap, "outputs", a.Outputs)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "resources", a.Resources)
	populate(objectMap, "services", a.Services)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "taskDetails", a.TaskDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoMLJob.
func (a *AutoMLJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &a.ComponentID)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &a.ComputeID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &a.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &a.EnvironmentVariables)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &a.ExperimentName)
			delete(rawMsg, key)
		case "identity":
			a.Identity, err = unmarshalIdentityConfigurationClassification(val)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &a.IsArchived)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &a.JobType)
			delete(rawMsg, key)
		case "outputs":
			a.Outputs, err = unmarshalJobOutputClassificationMap(val)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &a.Resources)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &a.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "taskDetails":
			a.TaskDetails, err = unmarshalAutoMLVerticalClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoMLVertical.
func (a AutoMLVertical) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logVerbosity", a.LogVerbosity)
	populate(objectMap, "targetColumnName", a.TargetColumnName)
	objectMap["taskType"] = a.TaskType
	populate(objectMap, "trainingData", a.TrainingData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoMLVertical.
func (a *AutoMLVertical) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &a.LogVerbosity)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &a.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &a.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &a.TrainingData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoNCrossValidations.
func (a AutoNCrossValidations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = NCrossValidationsModeAuto
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoNCrossValidations.
func (a *AutoNCrossValidations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoPauseProperties.
func (a AutoPauseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayInMinutes", a.DelayInMinutes)
	populate(objectMap, "enabled", a.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoPauseProperties.
func (a *AutoPauseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayInMinutes":
			err = unpopulate(val, "DelayInMinutes", &a.DelayInMinutes)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoScaleProperties.
func (a AutoScaleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "maxNodeCount", a.MaxNodeCount)
	populate(objectMap, "minNodeCount", a.MinNodeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoScaleProperties.
func (a *AutoScaleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "maxNodeCount":
			err = unpopulate(val, "MaxNodeCount", &a.MaxNodeCount)
			delete(rawMsg, key)
		case "minNodeCount":
			err = unpopulate(val, "MinNodeCount", &a.MinNodeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoSeasonality.
func (a AutoSeasonality) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = SeasonalityModeAuto
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoSeasonality.
func (a *AutoSeasonality) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoTargetLags.
func (a AutoTargetLags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = TargetLagsModeAuto
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoTargetLags.
func (a *AutoTargetLags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AutoTargetRollingWindowSize.
func (a AutoTargetRollingWindowSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = TargetRollingWindowSizeModeAuto
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AutoTargetRollingWindowSize.
func (a *AutoTargetRollingWindowSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &a.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobDatastore.
func (a AzureBlobDatastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "credentials", a.Credentials)
	objectMap["datastoreType"] = DatastoreTypeAzureBlob
	populate(objectMap, "description", a.Description)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "isDefault", a.IsDefault)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "serviceDataAccessAuthIdentity", a.ServiceDataAccessAuthIdentity)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobDatastore.
func (a *AzureBlobDatastore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "credentials":
			a.Credentials, err = unmarshalDatastoreCredentialsClassification(val)
			delete(rawMsg, key)
		case "datastoreType":
			err = unpopulate(val, "DatastoreType", &a.DatastoreType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &a.IsDefault)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "serviceDataAccessAuthIdentity":
			err = unpopulate(val, "ServiceDataAccessAuthIdentity", &a.ServiceDataAccessAuthIdentity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeGen1Datastore.
func (a AzureDataLakeGen1Datastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", a.Credentials)
	objectMap["datastoreType"] = DatastoreTypeAzureDataLakeGen1
	populate(objectMap, "description", a.Description)
	populate(objectMap, "isDefault", a.IsDefault)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "serviceDataAccessAuthIdentity", a.ServiceDataAccessAuthIdentity)
	populate(objectMap, "storeName", a.StoreName)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeGen1Datastore.
func (a *AzureDataLakeGen1Datastore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			a.Credentials, err = unmarshalDatastoreCredentialsClassification(val)
			delete(rawMsg, key)
		case "datastoreType":
			err = unpopulate(val, "DatastoreType", &a.DatastoreType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &a.IsDefault)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "serviceDataAccessAuthIdentity":
			err = unpopulate(val, "ServiceDataAccessAuthIdentity", &a.ServiceDataAccessAuthIdentity)
			delete(rawMsg, key)
		case "storeName":
			err = unpopulate(val, "StoreName", &a.StoreName)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureDataLakeGen2Datastore.
func (a AzureDataLakeGen2Datastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "credentials", a.Credentials)
	objectMap["datastoreType"] = DatastoreTypeAzureDataLakeGen2
	populate(objectMap, "description", a.Description)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "filesystem", a.Filesystem)
	populate(objectMap, "isDefault", a.IsDefault)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "serviceDataAccessAuthIdentity", a.ServiceDataAccessAuthIdentity)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureDataLakeGen2Datastore.
func (a *AzureDataLakeGen2Datastore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "credentials":
			a.Credentials, err = unmarshalDatastoreCredentialsClassification(val)
			delete(rawMsg, key)
		case "datastoreType":
			err = unpopulate(val, "DatastoreType", &a.DatastoreType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "filesystem":
			err = unpopulate(val, "Filesystem", &a.Filesystem)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &a.IsDefault)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "serviceDataAccessAuthIdentity":
			err = unpopulate(val, "ServiceDataAccessAuthIdentity", &a.ServiceDataAccessAuthIdentity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureFileDatastore.
func (a AzureFileDatastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountName", a.AccountName)
	populate(objectMap, "credentials", a.Credentials)
	objectMap["datastoreType"] = DatastoreTypeAzureFile
	populate(objectMap, "description", a.Description)
	populate(objectMap, "endpoint", a.Endpoint)
	populate(objectMap, "fileShareName", a.FileShareName)
	populate(objectMap, "isDefault", a.IsDefault)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "protocol", a.Protocol)
	populate(objectMap, "serviceDataAccessAuthIdentity", a.ServiceDataAccessAuthIdentity)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureFileDatastore.
func (a *AzureFileDatastore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountName":
			err = unpopulate(val, "AccountName", &a.AccountName)
			delete(rawMsg, key)
		case "credentials":
			a.Credentials, err = unmarshalDatastoreCredentialsClassification(val)
			delete(rawMsg, key)
		case "datastoreType":
			err = unpopulate(val, "DatastoreType", &a.DatastoreType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "endpoint":
			err = unpopulate(val, "Endpoint", &a.Endpoint)
			delete(rawMsg, key)
		case "fileShareName":
			err = unpopulate(val, "FileShareName", &a.FileShareName)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &a.IsDefault)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &a.Protocol)
			delete(rawMsg, key)
		case "serviceDataAccessAuthIdentity":
			err = unpopulate(val, "ServiceDataAccessAuthIdentity", &a.ServiceDataAccessAuthIdentity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BanditPolicy.
func (b BanditPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayEvaluation", b.DelayEvaluation)
	populate(objectMap, "evaluationInterval", b.EvaluationInterval)
	objectMap["policyType"] = EarlyTerminationPolicyTypeBandit
	populate(objectMap, "slackAmount", b.SlackAmount)
	populate(objectMap, "slackFactor", b.SlackFactor)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BanditPolicy.
func (b *BanditPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayEvaluation":
			err = unpopulate(val, "DelayEvaluation", &b.DelayEvaluation)
			delete(rawMsg, key)
		case "evaluationInterval":
			err = unpopulate(val, "EvaluationInterval", &b.EvaluationInterval)
			delete(rawMsg, key)
		case "policyType":
			err = unpopulate(val, "PolicyType", &b.PolicyType)
			delete(rawMsg, key)
		case "slackAmount":
			err = unpopulate(val, "SlackAmount", &b.SlackAmount)
			delete(rawMsg, key)
		case "slackFactor":
			err = unpopulate(val, "SlackFactor", &b.SlackFactor)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchDeployment.
func (b BatchDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "identity", b.Identity)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchDeployment.
func (b *BatchDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &b.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchDeploymentProperties.
func (b BatchDeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeConfiguration", b.CodeConfiguration)
	populate(objectMap, "compute", b.Compute)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "environmentId", b.EnvironmentID)
	populate(objectMap, "environmentVariables", b.EnvironmentVariables)
	populate(objectMap, "errorThreshold", b.ErrorThreshold)
	populate(objectMap, "loggingLevel", b.LoggingLevel)
	populate(objectMap, "maxConcurrencyPerInstance", b.MaxConcurrencyPerInstance)
	populate(objectMap, "miniBatchSize", b.MiniBatchSize)
	populate(objectMap, "model", b.Model)
	populate(objectMap, "outputAction", b.OutputAction)
	populate(objectMap, "outputFileName", b.OutputFileName)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "resources", b.Resources)
	populate(objectMap, "retrySettings", b.RetrySettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchDeploymentProperties.
func (b *BatchDeploymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeConfiguration":
			err = unpopulate(val, "CodeConfiguration", &b.CodeConfiguration)
			delete(rawMsg, key)
		case "compute":
			err = unpopulate(val, "Compute", &b.Compute)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &b.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &b.EnvironmentVariables)
			delete(rawMsg, key)
		case "errorThreshold":
			err = unpopulate(val, "ErrorThreshold", &b.ErrorThreshold)
			delete(rawMsg, key)
		case "loggingLevel":
			err = unpopulate(val, "LoggingLevel", &b.LoggingLevel)
			delete(rawMsg, key)
		case "maxConcurrencyPerInstance":
			err = unpopulate(val, "MaxConcurrencyPerInstance", &b.MaxConcurrencyPerInstance)
			delete(rawMsg, key)
		case "miniBatchSize":
			err = unpopulate(val, "MiniBatchSize", &b.MiniBatchSize)
			delete(rawMsg, key)
		case "model":
			b.Model, err = unmarshalAssetReferenceBaseClassification(val)
			delete(rawMsg, key)
		case "outputAction":
			err = unpopulate(val, "OutputAction", &b.OutputAction)
			delete(rawMsg, key)
		case "outputFileName":
			err = unpopulate(val, "OutputFileName", &b.OutputFileName)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &b.Resources)
			delete(rawMsg, key)
		case "retrySettings":
			err = unpopulate(val, "RetrySettings", &b.RetrySettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchDeploymentTrackedResourceArmPaginatedResult.
func (b BatchDeploymentTrackedResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchDeploymentTrackedResourceArmPaginatedResult.
func (b *BatchDeploymentTrackedResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchEndpoint.
func (b BatchEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", b.ID)
	populate(objectMap, "identity", b.Identity)
	populate(objectMap, "kind", b.Kind)
	populate(objectMap, "location", b.Location)
	populate(objectMap, "name", b.Name)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "sku", b.SKU)
	populate(objectMap, "systemData", b.SystemData)
	populate(objectMap, "tags", b.Tags)
	populate(objectMap, "type", b.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchEndpoint.
func (b *BatchEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &b.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &b.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &b.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &b.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &b.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &b.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &b.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &b.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &b.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchEndpointDefaults.
func (b BatchEndpointDefaults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "deploymentName", b.DeploymentName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchEndpointDefaults.
func (b *BatchEndpointDefaults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "deploymentName":
			err = unpopulate(val, "DeploymentName", &b.DeploymentName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchEndpointProperties.
func (b BatchEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authMode", b.AuthMode)
	populate(objectMap, "defaults", b.Defaults)
	populate(objectMap, "description", b.Description)
	populate(objectMap, "keys", b.Keys)
	populate(objectMap, "properties", b.Properties)
	populate(objectMap, "provisioningState", b.ProvisioningState)
	populate(objectMap, "scoringUri", b.ScoringURI)
	populate(objectMap, "swaggerUri", b.SwaggerURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchEndpointProperties.
func (b *BatchEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authMode":
			err = unpopulate(val, "AuthMode", &b.AuthMode)
			delete(rawMsg, key)
		case "defaults":
			err = unpopulate(val, "Defaults", &b.Defaults)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &b.Description)
			delete(rawMsg, key)
		case "keys":
			err = unpopulate(val, "Keys", &b.Keys)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &b.ProvisioningState)
			delete(rawMsg, key)
		case "scoringUri":
			err = unpopulate(val, "ScoringURI", &b.ScoringURI)
			delete(rawMsg, key)
		case "swaggerUri":
			err = unpopulate(val, "SwaggerURI", &b.SwaggerURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchEndpointTrackedResourceArmPaginatedResult.
func (b BatchEndpointTrackedResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", b.NextLink)
	populate(objectMap, "value", b.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchEndpointTrackedResourceArmPaginatedResult.
func (b *BatchEndpointTrackedResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &b.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &b.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BatchRetrySettings.
func (b BatchRetrySettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxRetries", b.MaxRetries)
	populate(objectMap, "timeout", b.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BatchRetrySettings.
func (b *BatchRetrySettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxRetries":
			err = unpopulate(val, "MaxRetries", &b.MaxRetries)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &b.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BayesianSamplingAlgorithm.
func (b BayesianSamplingAlgorithm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["samplingAlgorithmType"] = SamplingAlgorithmTypeBayesian
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BayesianSamplingAlgorithm.
func (b *BayesianSamplingAlgorithm) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "samplingAlgorithmType":
			err = unpopulate(val, "SamplingAlgorithmType", &b.SamplingAlgorithmType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BuildContext.
func (b BuildContext) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "contextUri", b.ContextURI)
	populate(objectMap, "dockerfilePath", b.DockerfilePath)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BuildContext.
func (b *BuildContext) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "contextUri":
			err = unpopulate(val, "ContextURI", &b.ContextURI)
			delete(rawMsg, key)
		case "dockerfilePath":
			err = unpopulate(val, "DockerfilePath", &b.DockerfilePath)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateDatastoreCredentials.
func (c CertificateDatastoreCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorityUrl", c.AuthorityURL)
	populate(objectMap, "clientId", c.ClientID)
	objectMap["credentialsType"] = CredentialsTypeCertificate
	populate(objectMap, "resourceUrl", c.ResourceURL)
	populate(objectMap, "secrets", c.Secrets)
	populate(objectMap, "tenantId", c.TenantID)
	populate(objectMap, "thumbprint", c.Thumbprint)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateDatastoreCredentials.
func (c *CertificateDatastoreCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorityUrl":
			err = unpopulate(val, "AuthorityURL", &c.AuthorityURL)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &c.ClientID)
			delete(rawMsg, key)
		case "credentialsType":
			err = unpopulate(val, "CredentialsType", &c.CredentialsType)
			delete(rawMsg, key)
		case "resourceUrl":
			err = unpopulate(val, "ResourceURL", &c.ResourceURL)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &c.Secrets)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &c.TenantID)
			delete(rawMsg, key)
		case "thumbprint":
			err = unpopulate(val, "Thumbprint", &c.Thumbprint)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CertificateDatastoreSecrets.
func (c CertificateDatastoreSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificate", c.Certificate)
	objectMap["secretsType"] = SecretsTypeCertificate
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CertificateDatastoreSecrets.
func (c *CertificateDatastoreSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificate":
			err = unpopulate(val, "Certificate", &c.Certificate)
			delete(rawMsg, key)
		case "secretsType":
			err = unpopulate(val, "SecretsType", &c.SecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Classification.
func (c Classification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cvSplitColumnNames", c.CvSplitColumnNames)
	populate(objectMap, "featurizationSettings", c.FeaturizationSettings)
	populate(objectMap, "limitSettings", c.LimitSettings)
	populate(objectMap, "logVerbosity", c.LogVerbosity)
	populate(objectMap, "nCrossValidations", c.NCrossValidations)
	populate(objectMap, "positiveLabel", c.PositiveLabel)
	populate(objectMap, "primaryMetric", c.PrimaryMetric)
	populate(objectMap, "targetColumnName", c.TargetColumnName)
	objectMap["taskType"] = TaskTypeClassification
	populate(objectMap, "testData", c.TestData)
	populate(objectMap, "testDataSize", c.TestDataSize)
	populate(objectMap, "trainingData", c.TrainingData)
	populate(objectMap, "trainingSettings", c.TrainingSettings)
	populate(objectMap, "validationData", c.ValidationData)
	populate(objectMap, "validationDataSize", c.ValidationDataSize)
	populate(objectMap, "weightColumnName", c.WeightColumnName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Classification.
func (c *Classification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cvSplitColumnNames":
			err = unpopulate(val, "CvSplitColumnNames", &c.CvSplitColumnNames)
			delete(rawMsg, key)
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &c.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &c.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &c.LogVerbosity)
			delete(rawMsg, key)
		case "nCrossValidations":
			c.NCrossValidations, err = unmarshalNCrossValidationsClassification(val)
			delete(rawMsg, key)
		case "positiveLabel":
			err = unpopulate(val, "PositiveLabel", &c.PositiveLabel)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &c.PrimaryMetric)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &c.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &c.TaskType)
			delete(rawMsg, key)
		case "testData":
			err = unpopulate(val, "TestData", &c.TestData)
			delete(rawMsg, key)
		case "testDataSize":
			err = unpopulate(val, "TestDataSize", &c.TestDataSize)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &c.TrainingData)
			delete(rawMsg, key)
		case "trainingSettings":
			err = unpopulate(val, "TrainingSettings", &c.TrainingSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &c.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &c.ValidationDataSize)
			delete(rawMsg, key)
		case "weightColumnName":
			err = unpopulate(val, "WeightColumnName", &c.WeightColumnName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClassificationTrainingSettings.
func (c ClassificationTrainingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTrainingAlgorithms", c.AllowedTrainingAlgorithms)
	populate(objectMap, "blockedTrainingAlgorithms", c.BlockedTrainingAlgorithms)
	populate(objectMap, "enableDnnTraining", c.EnableDnnTraining)
	populate(objectMap, "enableModelExplainability", c.EnableModelExplainability)
	populate(objectMap, "enableOnnxCompatibleModels", c.EnableOnnxCompatibleModels)
	populate(objectMap, "enableStackEnsemble", c.EnableStackEnsemble)
	populate(objectMap, "enableVoteEnsemble", c.EnableVoteEnsemble)
	populate(objectMap, "ensembleModelDownloadTimeout", c.EnsembleModelDownloadTimeout)
	populate(objectMap, "stackEnsembleSettings", c.StackEnsembleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClassificationTrainingSettings.
func (c *ClassificationTrainingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTrainingAlgorithms":
			err = unpopulate(val, "AllowedTrainingAlgorithms", &c.AllowedTrainingAlgorithms)
			delete(rawMsg, key)
		case "blockedTrainingAlgorithms":
			err = unpopulate(val, "BlockedTrainingAlgorithms", &c.BlockedTrainingAlgorithms)
			delete(rawMsg, key)
		case "enableDnnTraining":
			err = unpopulate(val, "EnableDnnTraining", &c.EnableDnnTraining)
			delete(rawMsg, key)
		case "enableModelExplainability":
			err = unpopulate(val, "EnableModelExplainability", &c.EnableModelExplainability)
			delete(rawMsg, key)
		case "enableOnnxCompatibleModels":
			err = unpopulate(val, "EnableOnnxCompatibleModels", &c.EnableOnnxCompatibleModels)
			delete(rawMsg, key)
		case "enableStackEnsemble":
			err = unpopulate(val, "EnableStackEnsemble", &c.EnableStackEnsemble)
			delete(rawMsg, key)
		case "enableVoteEnsemble":
			err = unpopulate(val, "EnableVoteEnsemble", &c.EnableVoteEnsemble)
			delete(rawMsg, key)
		case "ensembleModelDownloadTimeout":
			err = unpopulate(val, "EnsembleModelDownloadTimeout", &c.EnsembleModelDownloadTimeout)
			delete(rawMsg, key)
		case "stackEnsembleSettings":
			err = unpopulate(val, "StackEnsembleSettings", &c.StackEnsembleSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpdateParameters.
func (c ClusterUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpdateParameters.
func (c *ClusterUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpdateProperties.
func (c ClusterUpdateProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpdateProperties.
func (c *ClusterUpdateProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeConfiguration.
func (c CodeConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeId", c.CodeID)
	populate(objectMap, "scoringScript", c.ScoringScript)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeConfiguration.
func (c *CodeConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeId":
			err = unpopulate(val, "CodeID", &c.CodeID)
			delete(rawMsg, key)
		case "scoringScript":
			err = unpopulate(val, "ScoringScript", &c.ScoringScript)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeContainer.
func (c CodeContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeContainer.
func (c *CodeContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeContainerProperties.
func (c CodeContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isArchived", c.IsArchived)
	populate(objectMap, "latestVersion", c.LatestVersion)
	populate(objectMap, "nextVersion", c.NextVersion)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeContainerProperties.
func (c *CodeContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &c.IsArchived)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &c.LatestVersion)
			delete(rawMsg, key)
		case "nextVersion":
			err = unpopulate(val, "NextVersion", &c.NextVersion)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeContainerResourceArmPaginatedResult.
func (c CodeContainerResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeContainerResourceArmPaginatedResult.
func (c *CodeContainerResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeVersion.
func (c CodeVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeVersion.
func (c *CodeVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeVersionProperties.
func (c CodeVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeUri", c.CodeURI)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isAnonymous", c.IsAnonymous)
	populate(objectMap, "isArchived", c.IsArchived)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeVersionProperties.
func (c *CodeVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeUri":
			err = unpopulate(val, "CodeURI", &c.CodeURI)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &c.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &c.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CodeVersionResourceArmPaginatedResult.
func (c CodeVersionResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CodeVersionResourceArmPaginatedResult.
func (c *CodeVersionResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ColumnTransformer.
func (c ColumnTransformer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fields", c.Fields)
	populateAny(objectMap, "parameters", c.Parameters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ColumnTransformer.
func (c *ColumnTransformer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fields":
			err = unpopulate(val, "Fields", &c.Fields)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommandJob.
func (c CommandJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeId", c.CodeID)
	populate(objectMap, "command", c.Command)
	populate(objectMap, "componentId", c.ComponentID)
	populate(objectMap, "computeId", c.ComputeID)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "distribution", c.Distribution)
	populate(objectMap, "environmentId", c.EnvironmentID)
	populate(objectMap, "environmentVariables", c.EnvironmentVariables)
	populate(objectMap, "experimentName", c.ExperimentName)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "inputs", c.Inputs)
	populate(objectMap, "isArchived", c.IsArchived)
	objectMap["jobType"] = JobTypeCommand
	populate(objectMap, "limits", c.Limits)
	populate(objectMap, "outputs", c.Outputs)
	populateAny(objectMap, "parameters", c.Parameters)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "resources", c.Resources)
	populate(objectMap, "services", c.Services)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommandJob.
func (c *CommandJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeId":
			err = unpopulate(val, "CodeID", &c.CodeID)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &c.Command)
			delete(rawMsg, key)
		case "componentId":
			err = unpopulate(val, "ComponentID", &c.ComponentID)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &c.ComputeID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "distribution":
			c.Distribution, err = unmarshalDistributionConfigurationClassification(val)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &c.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &c.EnvironmentVariables)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &c.ExperimentName)
			delete(rawMsg, key)
		case "identity":
			c.Identity, err = unmarshalIdentityConfigurationClassification(val)
			delete(rawMsg, key)
		case "inputs":
			c.Inputs, err = unmarshalJobInputClassificationMap(val)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &c.IsArchived)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &c.JobType)
			delete(rawMsg, key)
		case "limits":
			err = unpopulate(val, "Limits", &c.Limits)
			delete(rawMsg, key)
		case "outputs":
			c.Outputs, err = unmarshalJobOutputClassificationMap(val)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, "Parameters", &c.Parameters)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &c.Resources)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &c.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommandJobLimits.
func (c CommandJobLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["jobLimitsType"] = JobLimitsTypeCommand
	populate(objectMap, "timeout", c.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommandJobLimits.
func (c *CommandJobLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobLimitsType":
			err = unpopulate(val, "JobLimitsType", &c.JobLimitsType)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &c.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentContainer.
func (c ComponentContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentContainer.
func (c *ComponentContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentContainerProperties.
func (c ComponentContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isArchived", c.IsArchived)
	populate(objectMap, "latestVersion", c.LatestVersion)
	populate(objectMap, "nextVersion", c.NextVersion)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentContainerProperties.
func (c *ComponentContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &c.IsArchived)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &c.LatestVersion)
			delete(rawMsg, key)
		case "nextVersion":
			err = unpopulate(val, "NextVersion", &c.NextVersion)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentContainerResourceArmPaginatedResult.
func (c ComponentContainerResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentContainerResourceArmPaginatedResult.
func (c *ComponentContainerResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentVersion.
func (c ComponentVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentVersion.
func (c *ComponentVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentVersionProperties.
func (c ComponentVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "componentSpec", c.ComponentSpec)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "isAnonymous", c.IsAnonymous)
	populate(objectMap, "isArchived", c.IsArchived)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "tags", c.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentVersionProperties.
func (c *ComponentVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentSpec":
			err = unpopulate(val, "ComponentSpec", &c.ComponentSpec)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &c.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &c.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComponentVersionResourceArmPaginatedResult.
func (c ComponentVersionResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComponentVersionResourceArmPaginatedResult.
func (c *ComponentVersionResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Compute.
func (c Compute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", c.ComputeLocation)
	objectMap["computeType"] = c.ComputeType
	populateDateTimeRFC3339(objectMap, "createdOn", c.CreatedOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "disableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", c.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", c.ModifiedOn)
	populate(objectMap, "provisioningErrors", c.ProvisioningErrors)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Compute.
func (c *Compute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &c.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &c.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &c.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &c.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &c.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &c.ModifiedOn)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &c.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstance.
func (c ComputeInstance) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", c.ComputeLocation)
	objectMap["computeType"] = ComputeTypeComputeInstance
	populateDateTimeRFC3339(objectMap, "createdOn", c.CreatedOn)
	populate(objectMap, "description", c.Description)
	populate(objectMap, "disableLocalAuth", c.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", c.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", c.ModifiedOn)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "provisioningErrors", c.ProvisioningErrors)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "resourceId", c.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstance.
func (c *ComputeInstance) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &c.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &c.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &c.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &c.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &c.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &c.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &c.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &c.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceApplication.
func (c ComputeInstanceApplication) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", c.DisplayName)
	populate(objectMap, "endpointUri", c.EndpointURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceApplication.
func (c *ComputeInstanceApplication) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &c.DisplayName)
			delete(rawMsg, key)
		case "endpointUri":
			err = unpopulate(val, "EndpointURI", &c.EndpointURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceConnectivityEndpoints.
func (c ComputeInstanceConnectivityEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateIpAddress", c.PrivateIPAddress)
	populate(objectMap, "publicIpAddress", c.PublicIPAddress)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceConnectivityEndpoints.
func (c *ComputeInstanceConnectivityEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateIpAddress":
			err = unpopulate(val, "PrivateIPAddress", &c.PrivateIPAddress)
			delete(rawMsg, key)
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &c.PublicIPAddress)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceContainer.
func (c ComputeInstanceContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autosave", c.Autosave)
	populate(objectMap, "environment", c.Environment)
	populate(objectMap, "gpu", c.Gpu)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "network", c.Network)
	populate(objectMap, "services", c.Services)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceContainer.
func (c *ComputeInstanceContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autosave":
			err = unpopulate(val, "Autosave", &c.Autosave)
			delete(rawMsg, key)
		case "environment":
			err = unpopulate(val, "Environment", &c.Environment)
			delete(rawMsg, key)
		case "gpu":
			err = unpopulate(val, "Gpu", &c.Gpu)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "network":
			err = unpopulate(val, "Network", &c.Network)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &c.Services)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceCreatedBy.
func (c ComputeInstanceCreatedBy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userId", c.UserID)
	populate(objectMap, "userName", c.UserName)
	populate(objectMap, "userOrgId", c.UserOrgID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceCreatedBy.
func (c *ComputeInstanceCreatedBy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userId":
			err = unpopulate(val, "UserID", &c.UserID)
			delete(rawMsg, key)
		case "userName":
			err = unpopulate(val, "UserName", &c.UserName)
			delete(rawMsg, key)
		case "userOrgId":
			err = unpopulate(val, "UserOrgID", &c.UserOrgID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceDataDisk.
func (c ComputeInstanceDataDisk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "caching", c.Caching)
	populate(objectMap, "diskSizeGB", c.DiskSizeGB)
	populate(objectMap, "lun", c.Lun)
	populate(objectMap, "storageAccountType", c.StorageAccountType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceDataDisk.
func (c *ComputeInstanceDataDisk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "caching":
			err = unpopulate(val, "Caching", &c.Caching)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &c.DiskSizeGB)
			delete(rawMsg, key)
		case "lun":
			err = unpopulate(val, "Lun", &c.Lun)
			delete(rawMsg, key)
		case "storageAccountType":
			err = unpopulate(val, "StorageAccountType", &c.StorageAccountType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceDataMount.
func (c ComputeInstanceDataMount) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdBy", c.CreatedBy)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "mountAction", c.MountAction)
	populate(objectMap, "mountName", c.MountName)
	populate(objectMap, "mountPath", c.MountPath)
	populate(objectMap, "mountState", c.MountState)
	populateDateTimeRFC3339(objectMap, "mountedOn", c.MountedOn)
	populate(objectMap, "source", c.Source)
	populate(objectMap, "sourceType", c.SourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceDataMount.
func (c *ComputeInstanceDataMount) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &c.CreatedBy)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "mountAction":
			err = unpopulate(val, "MountAction", &c.MountAction)
			delete(rawMsg, key)
		case "mountName":
			err = unpopulate(val, "MountName", &c.MountName)
			delete(rawMsg, key)
		case "mountPath":
			err = unpopulate(val, "MountPath", &c.MountPath)
			delete(rawMsg, key)
		case "mountState":
			err = unpopulate(val, "MountState", &c.MountState)
			delete(rawMsg, key)
		case "mountedOn":
			err = unpopulateDateTimeRFC3339(val, "MountedOn", &c.MountedOn)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &c.Source)
			delete(rawMsg, key)
		case "sourceType":
			err = unpopulate(val, "SourceType", &c.SourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceEnvironmentInfo.
func (c ComputeInstanceEnvironmentInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceEnvironmentInfo.
func (c *ComputeInstanceEnvironmentInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceLastOperation.
func (c ComputeInstanceLastOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationName", c.OperationName)
	populate(objectMap, "operationStatus", c.OperationStatus)
	populateDateTimeRFC3339(objectMap, "operationTime", c.OperationTime)
	populate(objectMap, "operationTrigger", c.OperationTrigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceLastOperation.
func (c *ComputeInstanceLastOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationName":
			err = unpopulate(val, "OperationName", &c.OperationName)
			delete(rawMsg, key)
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &c.OperationStatus)
			delete(rawMsg, key)
		case "operationTime":
			err = unpopulateDateTimeRFC3339(val, "OperationTime", &c.OperationTime)
			delete(rawMsg, key)
		case "operationTrigger":
			err = unpopulate(val, "OperationTrigger", &c.OperationTrigger)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceProperties.
func (c ComputeInstanceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationSharingPolicy", c.ApplicationSharingPolicy)
	populate(objectMap, "applications", c.Applications)
	populate(objectMap, "computeInstanceAuthorizationType", c.ComputeInstanceAuthorizationType)
	populate(objectMap, "connectivityEndpoints", c.ConnectivityEndpoints)
	populate(objectMap, "containers", c.Containers)
	populate(objectMap, "createdBy", c.CreatedBy)
	populate(objectMap, "dataDisks", c.DataDisks)
	populate(objectMap, "dataMounts", c.DataMounts)
	populate(objectMap, "enableNodePublicIp", c.EnableNodePublicIP)
	populate(objectMap, "errors", c.Errors)
	populate(objectMap, "lastOperation", c.LastOperation)
	populate(objectMap, "personalComputeInstanceSettings", c.PersonalComputeInstanceSettings)
	populate(objectMap, "sshSettings", c.SSHSettings)
	populate(objectMap, "schedules", c.Schedules)
	populate(objectMap, "setupScripts", c.SetupScripts)
	populate(objectMap, "state", c.State)
	populate(objectMap, "subnet", c.Subnet)
	populate(objectMap, "vmSize", c.VMSize)
	populate(objectMap, "versions", c.Versions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceProperties.
func (c *ComputeInstanceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationSharingPolicy":
			err = unpopulate(val, "ApplicationSharingPolicy", &c.ApplicationSharingPolicy)
			delete(rawMsg, key)
		case "applications":
			err = unpopulate(val, "Applications", &c.Applications)
			delete(rawMsg, key)
		case "computeInstanceAuthorizationType":
			err = unpopulate(val, "ComputeInstanceAuthorizationType", &c.ComputeInstanceAuthorizationType)
			delete(rawMsg, key)
		case "connectivityEndpoints":
			err = unpopulate(val, "ConnectivityEndpoints", &c.ConnectivityEndpoints)
			delete(rawMsg, key)
		case "containers":
			err = unpopulate(val, "Containers", &c.Containers)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &c.CreatedBy)
			delete(rawMsg, key)
		case "dataDisks":
			err = unpopulate(val, "DataDisks", &c.DataDisks)
			delete(rawMsg, key)
		case "dataMounts":
			err = unpopulate(val, "DataMounts", &c.DataMounts)
			delete(rawMsg, key)
		case "enableNodePublicIp":
			err = unpopulate(val, "EnableNodePublicIP", &c.EnableNodePublicIP)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &c.Errors)
			delete(rawMsg, key)
		case "lastOperation":
			err = unpopulate(val, "LastOperation", &c.LastOperation)
			delete(rawMsg, key)
		case "personalComputeInstanceSettings":
			err = unpopulate(val, "PersonalComputeInstanceSettings", &c.PersonalComputeInstanceSettings)
			delete(rawMsg, key)
		case "sshSettings":
			err = unpopulate(val, "SSHSettings", &c.SSHSettings)
			delete(rawMsg, key)
		case "schedules":
			err = unpopulate(val, "Schedules", &c.Schedules)
			delete(rawMsg, key)
		case "setupScripts":
			err = unpopulate(val, "SetupScripts", &c.SetupScripts)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &c.State)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &c.Subnet)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &c.VMSize)
			delete(rawMsg, key)
		case "versions":
			err = unpopulate(val, "Versions", &c.Versions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceSSHSettings.
func (c ComputeInstanceSSHSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPublicKey", c.AdminPublicKey)
	populate(objectMap, "adminUserName", c.AdminUserName)
	populate(objectMap, "sshPort", c.SSHPort)
	populate(objectMap, "sshPublicAccess", c.SSHPublicAccess)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceSSHSettings.
func (c *ComputeInstanceSSHSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPublicKey":
			err = unpopulate(val, "AdminPublicKey", &c.AdminPublicKey)
			delete(rawMsg, key)
		case "adminUserName":
			err = unpopulate(val, "AdminUserName", &c.AdminUserName)
			delete(rawMsg, key)
		case "sshPort":
			err = unpopulate(val, "SSHPort", &c.SSHPort)
			delete(rawMsg, key)
		case "sshPublicAccess":
			err = unpopulate(val, "SSHPublicAccess", &c.SSHPublicAccess)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceSchema.
func (c ComputeInstanceSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceSchema.
func (c *ComputeInstanceSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeInstanceVersion.
func (c ComputeInstanceVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "runtime", c.Runtime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeInstanceVersion.
func (c *ComputeInstanceVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "runtime":
			err = unpopulate(val, "Runtime", &c.Runtime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeResource.
func (c ComputeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "identity", c.Identity)
	populate(objectMap, "location", c.Location)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "sku", c.SKU)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "tags", c.Tags)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeResource.
func (c *ComputeResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &c.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &c.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			c.Properties, err = unmarshalComputeClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &c.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &c.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeResourceSchema.
func (c ComputeResourceSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeResourceSchema.
func (c *ComputeResourceSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			c.Properties, err = unmarshalComputeClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeSchedules.
func (c ComputeSchedules) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeStartStop", c.ComputeStartStop)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeSchedules.
func (c *ComputeSchedules) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeStartStop":
			err = unpopulate(val, "ComputeStartStop", &c.ComputeStartStop)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeSecrets.
func (c ComputeSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["computeType"] = c.ComputeType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeSecrets.
func (c *ComputeSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeType":
			err = unpopulate(val, "ComputeType", &c.ComputeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComputeStartStopSchedule.
func (c ComputeStartStopSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", c.Action)
	populate(objectMap, "cron", c.Cron)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "provisioningStatus", c.ProvisioningStatus)
	populate(objectMap, "recurrence", c.Recurrence)
	populate(objectMap, "schedule", c.Schedule)
	populate(objectMap, "status", c.Status)
	populate(objectMap, "triggerType", c.TriggerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComputeStartStopSchedule.
func (c *ComputeStartStopSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &c.Action)
			delete(rawMsg, key)
		case "cron":
			err = unpopulate(val, "Cron", &c.Cron)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &c.ProvisioningStatus)
			delete(rawMsg, key)
		case "recurrence":
			err = unpopulate(val, "Recurrence", &c.Recurrence)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &c.Schedule)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &c.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerResourceRequirements.
func (c ContainerResourceRequirements) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerResourceLimits", c.ContainerResourceLimits)
	populate(objectMap, "containerResourceRequests", c.ContainerResourceRequests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerResourceRequirements.
func (c *ContainerResourceRequirements) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerResourceLimits":
			err = unpopulate(val, "ContainerResourceLimits", &c.ContainerResourceLimits)
			delete(rawMsg, key)
		case "containerResourceRequests":
			err = unpopulate(val, "ContainerResourceRequests", &c.ContainerResourceRequests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ContainerResourceSettings.
func (c ContainerResourceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cpu", c.CPU)
	populate(objectMap, "gpu", c.Gpu)
	populate(objectMap, "memory", c.Memory)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ContainerResourceSettings.
func (c *ContainerResourceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cpu":
			err = unpopulate(val, "CPU", &c.CPU)
			delete(rawMsg, key)
		case "gpu":
			err = unpopulate(val, "Gpu", &c.Gpu)
			delete(rawMsg, key)
		case "memory":
			err = unpopulate(val, "Memory", &c.Memory)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CosmosDbSettings.
func (c CosmosDbSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "collectionsThroughput", c.CollectionsThroughput)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CosmosDbSettings.
func (c *CosmosDbSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionsThroughput":
			err = unpopulate(val, "CollectionsThroughput", &c.CollectionsThroughput)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CronTrigger.
func (c CronTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", c.EndTime)
	populate(objectMap, "expression", c.Expression)
	populate(objectMap, "startTime", c.StartTime)
	populate(objectMap, "timeZone", c.TimeZone)
	objectMap["triggerType"] = TriggerTypeCron
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CronTrigger.
func (c *CronTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &c.EndTime)
			delete(rawMsg, key)
		case "expression":
			err = unpopulate(val, "Expression", &c.Expression)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &c.StartTime)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &c.TimeZone)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &c.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomForecastHorizon.
func (c CustomForecastHorizon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = ForecastHorizonModeCustom
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomForecastHorizon.
func (c *CustomForecastHorizon) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomModelJobInput.
func (c CustomModelJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	objectMap["jobInputType"] = JobInputTypeCustomModel
	populate(objectMap, "mode", c.Mode)
	populate(objectMap, "uri", c.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomModelJobInput.
func (c *CustomModelJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &c.JobInputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &c.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomModelJobOutput.
func (c CustomModelJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", c.Description)
	objectMap["jobOutputType"] = JobOutputTypeCustomModel
	populate(objectMap, "mode", c.Mode)
	populate(objectMap, "uri", c.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomModelJobOutput.
func (c *CustomModelJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &c.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &c.JobOutputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &c.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomNCrossValidations.
func (c CustomNCrossValidations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = NCrossValidationsModeCustom
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomNCrossValidations.
func (c *CustomNCrossValidations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomSeasonality.
func (c CustomSeasonality) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = SeasonalityModeCustom
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomSeasonality.
func (c *CustomSeasonality) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomTargetLags.
func (c CustomTargetLags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = TargetLagsModeCustom
	populate(objectMap, "values", c.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomTargetLags.
func (c *CustomTargetLags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &c.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CustomTargetRollingWindowSize.
func (c CustomTargetRollingWindowSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = TargetRollingWindowSizeModeCustom
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CustomTargetRollingWindowSize.
func (c *CustomTargetRollingWindowSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &c.Mode)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataContainer.
func (d DataContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataContainer.
func (d *DataContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataContainerProperties.
func (d DataContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataType", d.DataType)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "isArchived", d.IsArchived)
	populate(objectMap, "latestVersion", d.LatestVersion)
	populate(objectMap, "nextVersion", d.NextVersion)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataContainerProperties.
func (d *DataContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &d.DataType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &d.IsArchived)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &d.LatestVersion)
			delete(rawMsg, key)
		case "nextVersion":
			err = unpopulate(val, "NextVersion", &d.NextVersion)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataContainerResourceArmPaginatedResult.
func (d DataContainerResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataContainerResourceArmPaginatedResult.
func (d *DataContainerResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataFactory.
func (d DataFactory) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", d.ComputeLocation)
	objectMap["computeType"] = ComputeTypeDataFactory
	populateDateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", d.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", d.ModifiedOn)
	populate(objectMap, "provisioningErrors", d.ProvisioningErrors)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataFactory.
func (d *DataFactory) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &d.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &d.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &d.ModifiedOn)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &d.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeAnalytics.
func (d DataLakeAnalytics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", d.ComputeLocation)
	objectMap["computeType"] = ComputeTypeDataLakeAnalytics
	populateDateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", d.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", d.ModifiedOn)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningErrors", d.ProvisioningErrors)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeAnalytics.
func (d *DataLakeAnalytics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &d.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &d.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &d.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &d.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeAnalyticsSchema.
func (d DataLakeAnalyticsSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeAnalyticsSchema.
func (d *DataLakeAnalyticsSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataLakeAnalyticsSchemaProperties.
func (d DataLakeAnalyticsSchemaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dataLakeStoreAccountName", d.DataLakeStoreAccountName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataLakeAnalyticsSchemaProperties.
func (d *DataLakeAnalyticsSchemaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataLakeStoreAccountName":
			err = unpopulate(val, "DataLakeStoreAccountName", &d.DataLakeStoreAccountName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataPathAssetReference.
func (d DataPathAssetReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datastoreId", d.DatastoreID)
	populate(objectMap, "path", d.Path)
	objectMap["referenceType"] = ReferenceTypeDataPath
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataPathAssetReference.
func (d *DataPathAssetReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datastoreId":
			err = unpopulate(val, "DatastoreID", &d.DatastoreID)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &d.Path)
			delete(rawMsg, key)
		case "referenceType":
			err = unpopulate(val, "ReferenceType", &d.ReferenceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataVersionBase.
func (d DataVersionBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataVersionBase.
func (d *DataVersionBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDataVersionBasePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataVersionBaseProperties.
func (d DataVersionBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataType"] = d.DataType
	populate(objectMap, "dataUri", d.DataURI)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "isAnonymous", d.IsAnonymous)
	populate(objectMap, "isArchived", d.IsArchived)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataVersionBaseProperties.
func (d *DataVersionBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &d.DataType)
			delete(rawMsg, key)
		case "dataUri":
			err = unpopulate(val, "DataURI", &d.DataURI)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &d.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &d.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DataVersionBaseResourceArmPaginatedResult.
func (d DataVersionBaseResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DataVersionBaseResourceArmPaginatedResult.
func (d *DataVersionBaseResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Databricks.
func (d Databricks) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", d.ComputeLocation)
	objectMap["computeType"] = ComputeTypeDatabricks
	populateDateTimeRFC3339(objectMap, "createdOn", d.CreatedOn)
	populate(objectMap, "description", d.Description)
	populate(objectMap, "disableLocalAuth", d.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", d.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", d.ModifiedOn)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "provisioningErrors", d.ProvisioningErrors)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceId", d.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Databricks.
func (d *Databricks) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &d.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &d.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &d.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &d.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &d.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &d.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksComputeSecrets.
func (d DatabricksComputeSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["computeType"] = ComputeTypeDatabricks
	populate(objectMap, "databricksAccessToken", d.DatabricksAccessToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksComputeSecrets.
func (d *DatabricksComputeSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeType":
			err = unpopulate(val, "ComputeType", &d.ComputeType)
			delete(rawMsg, key)
		case "databricksAccessToken":
			err = unpopulate(val, "DatabricksAccessToken", &d.DatabricksAccessToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksComputeSecretsProperties.
func (d DatabricksComputeSecretsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "databricksAccessToken", d.DatabricksAccessToken)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksComputeSecretsProperties.
func (d *DatabricksComputeSecretsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databricksAccessToken":
			err = unpopulate(val, "DatabricksAccessToken", &d.DatabricksAccessToken)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksProperties.
func (d DatabricksProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "databricksAccessToken", d.DatabricksAccessToken)
	populate(objectMap, "workspaceUrl", d.WorkspaceURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksProperties.
func (d *DatabricksProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "databricksAccessToken":
			err = unpopulate(val, "DatabricksAccessToken", &d.DatabricksAccessToken)
			delete(rawMsg, key)
		case "workspaceUrl":
			err = unpopulate(val, "WorkspaceURL", &d.WorkspaceURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatabricksSchema.
func (d DatabricksSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatabricksSchema.
func (d *DatabricksSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Datastore.
func (d Datastore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Datastore.
func (d *Datastore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			d.Properties, err = unmarshalDatastorePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoreCredentials.
func (d DatastoreCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["credentialsType"] = d.CredentialsType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoreCredentials.
func (d *DatastoreCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentialsType":
			err = unpopulate(val, "CredentialsType", &d.CredentialsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoreProperties.
func (d DatastoreProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "credentials", d.Credentials)
	objectMap["datastoreType"] = d.DatastoreType
	populate(objectMap, "description", d.Description)
	populate(objectMap, "isDefault", d.IsDefault)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoreProperties.
func (d *DatastoreProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentials":
			d.Credentials, err = unmarshalDatastoreCredentialsClassification(val)
			delete(rawMsg, key)
		case "datastoreType":
			err = unpopulate(val, "DatastoreType", &d.DatastoreType)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &d.Description)
			delete(rawMsg, key)
		case "isDefault":
			err = unpopulate(val, "IsDefault", &d.IsDefault)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &d.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoreResourceArmPaginatedResult.
func (d DatastoreResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoreResourceArmPaginatedResult.
func (d *DatastoreResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DatastoreSecrets.
func (d DatastoreSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["secretsType"] = d.SecretsType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DatastoreSecrets.
func (d *DatastoreSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "secretsType":
			err = unpopulate(val, "SecretsType", &d.SecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DefaultScaleSettings.
func (d DefaultScaleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["scaleType"] = ScaleTypeDefault
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DefaultScaleSettings.
func (d *DefaultScaleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scaleType":
			err = unpopulate(val, "ScaleType", &d.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentLogs.
func (d DeploymentLogs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "content", d.Content)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentLogs.
func (d *DeploymentLogs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "content":
			err = unpopulate(val, "Content", &d.Content)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentLogsRequest.
func (d DeploymentLogsRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "containerType", d.ContainerType)
	populate(objectMap, "tail", d.Tail)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentLogsRequest.
func (d *DeploymentLogsRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "containerType":
			err = unpopulate(val, "ContainerType", &d.ContainerType)
			delete(rawMsg, key)
		case "tail":
			err = unpopulate(val, "Tail", &d.Tail)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentResourceConfiguration.
func (d DeploymentResourceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceCount", d.InstanceCount)
	populate(objectMap, "instanceType", d.InstanceType)
	populate(objectMap, "properties", d.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentResourceConfiguration.
func (d *DeploymentResourceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &d.InstanceCount)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &d.InstanceType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnoseRequestProperties.
func (d DiagnoseRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationInsights", d.ApplicationInsights)
	populate(objectMap, "containerRegistry", d.ContainerRegistry)
	populate(objectMap, "dnsResolution", d.DNSResolution)
	populate(objectMap, "keyVault", d.KeyVault)
	populate(objectMap, "nsg", d.Nsg)
	populate(objectMap, "others", d.Others)
	populate(objectMap, "resourceLock", d.ResourceLock)
	populate(objectMap, "storageAccount", d.StorageAccount)
	populate(objectMap, "udr", d.Udr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnoseRequestProperties.
func (d *DiagnoseRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationInsights":
			err = unpopulate(val, "ApplicationInsights", &d.ApplicationInsights)
			delete(rawMsg, key)
		case "containerRegistry":
			err = unpopulate(val, "ContainerRegistry", &d.ContainerRegistry)
			delete(rawMsg, key)
		case "dnsResolution":
			err = unpopulate(val, "DNSResolution", &d.DNSResolution)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &d.KeyVault)
			delete(rawMsg, key)
		case "nsg":
			err = unpopulate(val, "Nsg", &d.Nsg)
			delete(rawMsg, key)
		case "others":
			err = unpopulate(val, "Others", &d.Others)
			delete(rawMsg, key)
		case "resourceLock":
			err = unpopulate(val, "ResourceLock", &d.ResourceLock)
			delete(rawMsg, key)
		case "storageAccount":
			err = unpopulate(val, "StorageAccount", &d.StorageAccount)
			delete(rawMsg, key)
		case "udr":
			err = unpopulate(val, "Udr", &d.Udr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnoseResponseResult.
func (d DiagnoseResponseResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnoseResponseResult.
func (d *DiagnoseResponseResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnoseResponseResultValue.
func (d DiagnoseResponseResultValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationInsightsResults", d.ApplicationInsightsResults)
	populate(objectMap, "containerRegistryResults", d.ContainerRegistryResults)
	populate(objectMap, "dnsResolutionResults", d.DNSResolutionResults)
	populate(objectMap, "keyVaultResults", d.KeyVaultResults)
	populate(objectMap, "networkSecurityRuleResults", d.NetworkSecurityRuleResults)
	populate(objectMap, "otherResults", d.OtherResults)
	populate(objectMap, "resourceLockResults", d.ResourceLockResults)
	populate(objectMap, "storageAccountResults", d.StorageAccountResults)
	populate(objectMap, "userDefinedRouteResults", d.UserDefinedRouteResults)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnoseResponseResultValue.
func (d *DiagnoseResponseResultValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationInsightsResults":
			err = unpopulate(val, "ApplicationInsightsResults", &d.ApplicationInsightsResults)
			delete(rawMsg, key)
		case "containerRegistryResults":
			err = unpopulate(val, "ContainerRegistryResults", &d.ContainerRegistryResults)
			delete(rawMsg, key)
		case "dnsResolutionResults":
			err = unpopulate(val, "DNSResolutionResults", &d.DNSResolutionResults)
			delete(rawMsg, key)
		case "keyVaultResults":
			err = unpopulate(val, "KeyVaultResults", &d.KeyVaultResults)
			delete(rawMsg, key)
		case "networkSecurityRuleResults":
			err = unpopulate(val, "NetworkSecurityRuleResults", &d.NetworkSecurityRuleResults)
			delete(rawMsg, key)
		case "otherResults":
			err = unpopulate(val, "OtherResults", &d.OtherResults)
			delete(rawMsg, key)
		case "resourceLockResults":
			err = unpopulate(val, "ResourceLockResults", &d.ResourceLockResults)
			delete(rawMsg, key)
		case "storageAccountResults":
			err = unpopulate(val, "StorageAccountResults", &d.StorageAccountResults)
			delete(rawMsg, key)
		case "userDefinedRouteResults":
			err = unpopulate(val, "UserDefinedRouteResults", &d.UserDefinedRouteResults)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnoseResult.
func (d DiagnoseResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", d.Code)
	populate(objectMap, "level", d.Level)
	populate(objectMap, "message", d.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnoseResult.
func (d *DiagnoseResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &d.Code)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &d.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &d.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DiagnoseWorkspaceParameters.
func (d DiagnoseWorkspaceParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DiagnoseWorkspaceParameters.
func (d *DiagnoseWorkspaceParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DistributionConfiguration.
func (d DistributionConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["distributionType"] = d.DistributionType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DistributionConfiguration.
func (d *DistributionConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributionType":
			err = unpopulate(val, "DistributionType", &d.DistributionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EarlyTerminationPolicy.
func (e EarlyTerminationPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayEvaluation", e.DelayEvaluation)
	populate(objectMap, "evaluationInterval", e.EvaluationInterval)
	objectMap["policyType"] = e.PolicyType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EarlyTerminationPolicy.
func (e *EarlyTerminationPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayEvaluation":
			err = unpopulate(val, "DelayEvaluation", &e.DelayEvaluation)
			delete(rawMsg, key)
		case "evaluationInterval":
			err = unpopulate(val, "EvaluationInterval", &e.EvaluationInterval)
			delete(rawMsg, key)
		case "policyType":
			err = unpopulate(val, "PolicyType", &e.PolicyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionKeyVaultProperties.
func (e EncryptionKeyVaultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identityClientId", e.IdentityClientID)
	populate(objectMap, "keyIdentifier", e.KeyIdentifier)
	populate(objectMap, "keyVaultArmId", e.KeyVaultArmID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionKeyVaultProperties.
func (e *EncryptionKeyVaultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityClientId":
			err = unpopulate(val, "IdentityClientID", &e.IdentityClientID)
			delete(rawMsg, key)
		case "keyIdentifier":
			err = unpopulate(val, "KeyIdentifier", &e.KeyIdentifier)
			delete(rawMsg, key)
		case "keyVaultArmId":
			err = unpopulate(val, "KeyVaultArmID", &e.KeyVaultArmID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EncryptionProperty.
func (e EncryptionProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", e.Identity)
	populate(objectMap, "keyVaultProperties", e.KeyVaultProperties)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EncryptionProperty.
func (e *EncryptionProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &e.Identity)
			delete(rawMsg, key)
		case "keyVaultProperties":
			err = unpopulate(val, "KeyVaultProperties", &e.KeyVaultProperties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointAuthKeys.
func (e EndpointAuthKeys) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryKey", e.PrimaryKey)
	populate(objectMap, "secondaryKey", e.SecondaryKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointAuthKeys.
func (e *EndpointAuthKeys) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryKey":
			err = unpopulate(val, "PrimaryKey", &e.PrimaryKey)
			delete(rawMsg, key)
		case "secondaryKey":
			err = unpopulate(val, "SecondaryKey", &e.SecondaryKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointAuthToken.
func (e EndpointAuthToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", e.AccessToken)
	populate(objectMap, "expiryTimeUtc", e.ExpiryTimeUTC)
	populate(objectMap, "refreshAfterTimeUtc", e.RefreshAfterTimeUTC)
	populate(objectMap, "tokenType", e.TokenType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointAuthToken.
func (e *EndpointAuthToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &e.AccessToken)
			delete(rawMsg, key)
		case "expiryTimeUtc":
			err = unpopulate(val, "ExpiryTimeUTC", &e.ExpiryTimeUTC)
			delete(rawMsg, key)
		case "refreshAfterTimeUtc":
			err = unpopulate(val, "RefreshAfterTimeUTC", &e.RefreshAfterTimeUTC)
			delete(rawMsg, key)
		case "tokenType":
			err = unpopulate(val, "TokenType", &e.TokenType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDeploymentPropertiesBase.
func (e EndpointDeploymentPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeConfiguration", e.CodeConfiguration)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "environmentId", e.EnvironmentID)
	populate(objectMap, "environmentVariables", e.EnvironmentVariables)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDeploymentPropertiesBase.
func (e *EndpointDeploymentPropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeConfiguration":
			err = unpopulate(val, "CodeConfiguration", &e.CodeConfiguration)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &e.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &e.EnvironmentVariables)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointPropertiesBase.
func (e EndpointPropertiesBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authMode", e.AuthMode)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "keys", e.Keys)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "scoringUri", e.ScoringURI)
	populate(objectMap, "swaggerUri", e.SwaggerURI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointPropertiesBase.
func (e *EndpointPropertiesBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authMode":
			err = unpopulate(val, "AuthMode", &e.AuthMode)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "keys":
			err = unpopulate(val, "Keys", &e.Keys)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "scoringUri":
			err = unpopulate(val, "ScoringURI", &e.ScoringURI)
			delete(rawMsg, key)
		case "swaggerUri":
			err = unpopulate(val, "SwaggerURI", &e.SwaggerURI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointScheduleAction.
func (e EndpointScheduleAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["actionType"] = ScheduleActionTypeInvokeBatchEndpoint
	populateAny(objectMap, "endpointInvocationDefinition", e.EndpointInvocationDefinition)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointScheduleAction.
func (e *EndpointScheduleAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &e.ActionType)
			delete(rawMsg, key)
		case "endpointInvocationDefinition":
			err = unpopulate(val, "EndpointInvocationDefinition", &e.EndpointInvocationDefinition)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentContainer.
func (e EnvironmentContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentContainer.
func (e *EnvironmentContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentContainerProperties.
func (e EnvironmentContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "isArchived", e.IsArchived)
	populate(objectMap, "latestVersion", e.LatestVersion)
	populate(objectMap, "nextVersion", e.NextVersion)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentContainerProperties.
func (e *EnvironmentContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &e.IsArchived)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &e.LatestVersion)
			delete(rawMsg, key)
		case "nextVersion":
			err = unpopulate(val, "NextVersion", &e.NextVersion)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentContainerResourceArmPaginatedResult.
func (e EnvironmentContainerResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentContainerResourceArmPaginatedResult.
func (e *EnvironmentContainerResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVersion.
func (e EnvironmentVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVersion.
func (e *EnvironmentVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVersionProperties.
func (e EnvironmentVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoRebuild", e.AutoRebuild)
	populate(objectMap, "build", e.Build)
	populate(objectMap, "condaFile", e.CondaFile)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "environmentType", e.EnvironmentType)
	populate(objectMap, "image", e.Image)
	populate(objectMap, "inferenceConfig", e.InferenceConfig)
	populate(objectMap, "isAnonymous", e.IsAnonymous)
	populate(objectMap, "isArchived", e.IsArchived)
	populate(objectMap, "osType", e.OSType)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "tags", e.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVersionProperties.
func (e *EnvironmentVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoRebuild":
			err = unpopulate(val, "AutoRebuild", &e.AutoRebuild)
			delete(rawMsg, key)
		case "build":
			err = unpopulate(val, "Build", &e.Build)
			delete(rawMsg, key)
		case "condaFile":
			err = unpopulate(val, "CondaFile", &e.CondaFile)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "environmentType":
			err = unpopulate(val, "EnvironmentType", &e.EnvironmentType)
			delete(rawMsg, key)
		case "image":
			err = unpopulate(val, "Image", &e.Image)
			delete(rawMsg, key)
		case "inferenceConfig":
			err = unpopulate(val, "InferenceConfig", &e.InferenceConfig)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &e.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &e.IsArchived)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &e.OSType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &e.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EnvironmentVersionResourceArmPaginatedResult.
func (e EnvironmentVersionResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentVersionResourceArmPaginatedResult.
func (e *EnvironmentVersionResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EstimatedVMPrice.
func (e EstimatedVMPrice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osType", e.OSType)
	populate(objectMap, "retailPrice", e.RetailPrice)
	populate(objectMap, "vmTier", e.VMTier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EstimatedVMPrice.
func (e *EstimatedVMPrice) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osType":
			err = unpopulate(val, "OSType", &e.OSType)
			delete(rawMsg, key)
		case "retailPrice":
			err = unpopulate(val, "RetailPrice", &e.RetailPrice)
			delete(rawMsg, key)
		case "vmTier":
			err = unpopulate(val, "VMTier", &e.VMTier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EstimatedVMPrices.
func (e EstimatedVMPrices) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrency", e.BillingCurrency)
	populate(objectMap, "unitOfMeasure", e.UnitOfMeasure)
	populate(objectMap, "values", e.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EstimatedVMPrices.
func (e *EstimatedVMPrices) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrency":
			err = unpopulate(val, "BillingCurrency", &e.BillingCurrency)
			delete(rawMsg, key)
		case "unitOfMeasure":
			err = unpopulate(val, "UnitOfMeasure", &e.UnitOfMeasure)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &e.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExternalFQDNResponse.
func (e ExternalFQDNResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExternalFQDNResponse.
func (e *ExternalFQDNResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FQDNEndpoint.
func (f FQDNEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", f.DomainName)
	populate(objectMap, "endpointDetails", f.EndpointDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FQDNEndpoint.
func (f *FQDNEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &f.DomainName)
			delete(rawMsg, key)
		case "endpointDetails":
			err = unpopulate(val, "EndpointDetails", &f.EndpointDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FQDNEndpointDetail.
func (f FQDNEndpointDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "port", f.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FQDNEndpointDetail.
func (f *FQDNEndpointDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "port":
			err = unpopulate(val, "Port", &f.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FQDNEndpoints.
func (f FQDNEndpoints) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", f.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FQDNEndpoints.
func (f *FQDNEndpoints) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FQDNEndpointsProperties.
func (f FQDNEndpointsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", f.Category)
	populate(objectMap, "endpoints", f.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FQDNEndpointsProperties.
func (f *FQDNEndpointsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &f.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &f.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FeaturizationSettings.
func (f FeaturizationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasetLanguage", f.DatasetLanguage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FeaturizationSettings.
func (f *FeaturizationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasetLanguage":
			err = unpopulate(val, "DatasetLanguage", &f.DatasetLanguage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FlavorData.
func (f FlavorData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "data", f.Data)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FlavorData.
func (f *FlavorData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "data":
			err = unpopulate(val, "Data", &f.Data)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastHorizon.
func (f ForecastHorizon) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = f.Mode
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastHorizon.
func (f *ForecastHorizon) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &f.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Forecasting.
func (f Forecasting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cvSplitColumnNames", f.CvSplitColumnNames)
	populate(objectMap, "featurizationSettings", f.FeaturizationSettings)
	populate(objectMap, "forecastingSettings", f.ForecastingSettings)
	populate(objectMap, "limitSettings", f.LimitSettings)
	populate(objectMap, "logVerbosity", f.LogVerbosity)
	populate(objectMap, "nCrossValidations", f.NCrossValidations)
	populate(objectMap, "primaryMetric", f.PrimaryMetric)
	populate(objectMap, "targetColumnName", f.TargetColumnName)
	objectMap["taskType"] = TaskTypeForecasting
	populate(objectMap, "testData", f.TestData)
	populate(objectMap, "testDataSize", f.TestDataSize)
	populate(objectMap, "trainingData", f.TrainingData)
	populate(objectMap, "trainingSettings", f.TrainingSettings)
	populate(objectMap, "validationData", f.ValidationData)
	populate(objectMap, "validationDataSize", f.ValidationDataSize)
	populate(objectMap, "weightColumnName", f.WeightColumnName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Forecasting.
func (f *Forecasting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cvSplitColumnNames":
			err = unpopulate(val, "CvSplitColumnNames", &f.CvSplitColumnNames)
			delete(rawMsg, key)
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &f.FeaturizationSettings)
			delete(rawMsg, key)
		case "forecastingSettings":
			err = unpopulate(val, "ForecastingSettings", &f.ForecastingSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &f.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &f.LogVerbosity)
			delete(rawMsg, key)
		case "nCrossValidations":
			f.NCrossValidations, err = unmarshalNCrossValidationsClassification(val)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &f.PrimaryMetric)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &f.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &f.TaskType)
			delete(rawMsg, key)
		case "testData":
			err = unpopulate(val, "TestData", &f.TestData)
			delete(rawMsg, key)
		case "testDataSize":
			err = unpopulate(val, "TestDataSize", &f.TestDataSize)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &f.TrainingData)
			delete(rawMsg, key)
		case "trainingSettings":
			err = unpopulate(val, "TrainingSettings", &f.TrainingSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &f.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &f.ValidationDataSize)
			delete(rawMsg, key)
		case "weightColumnName":
			err = unpopulate(val, "WeightColumnName", &f.WeightColumnName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastingSettings.
func (f ForecastingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "countryOrRegionForHolidays", f.CountryOrRegionForHolidays)
	populate(objectMap, "cvStepSize", f.CvStepSize)
	populate(objectMap, "featureLags", f.FeatureLags)
	populate(objectMap, "forecastHorizon", f.ForecastHorizon)
	populate(objectMap, "frequency", f.Frequency)
	populate(objectMap, "seasonality", f.Seasonality)
	populate(objectMap, "shortSeriesHandlingConfig", f.ShortSeriesHandlingConfig)
	populate(objectMap, "targetAggregateFunction", f.TargetAggregateFunction)
	populate(objectMap, "targetLags", f.TargetLags)
	populate(objectMap, "targetRollingWindowSize", f.TargetRollingWindowSize)
	populate(objectMap, "timeColumnName", f.TimeColumnName)
	populate(objectMap, "timeSeriesIdColumnNames", f.TimeSeriesIDColumnNames)
	populate(objectMap, "useStl", f.UseStl)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastingSettings.
func (f *ForecastingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "countryOrRegionForHolidays":
			err = unpopulate(val, "CountryOrRegionForHolidays", &f.CountryOrRegionForHolidays)
			delete(rawMsg, key)
		case "cvStepSize":
			err = unpopulate(val, "CvStepSize", &f.CvStepSize)
			delete(rawMsg, key)
		case "featureLags":
			err = unpopulate(val, "FeatureLags", &f.FeatureLags)
			delete(rawMsg, key)
		case "forecastHorizon":
			f.ForecastHorizon, err = unmarshalForecastHorizonClassification(val)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &f.Frequency)
			delete(rawMsg, key)
		case "seasonality":
			f.Seasonality, err = unmarshalSeasonalityClassification(val)
			delete(rawMsg, key)
		case "shortSeriesHandlingConfig":
			err = unpopulate(val, "ShortSeriesHandlingConfig", &f.ShortSeriesHandlingConfig)
			delete(rawMsg, key)
		case "targetAggregateFunction":
			err = unpopulate(val, "TargetAggregateFunction", &f.TargetAggregateFunction)
			delete(rawMsg, key)
		case "targetLags":
			f.TargetLags, err = unmarshalTargetLagsClassification(val)
			delete(rawMsg, key)
		case "targetRollingWindowSize":
			f.TargetRollingWindowSize, err = unmarshalTargetRollingWindowSizeClassification(val)
			delete(rawMsg, key)
		case "timeColumnName":
			err = unpopulate(val, "TimeColumnName", &f.TimeColumnName)
			delete(rawMsg, key)
		case "timeSeriesIdColumnNames":
			err = unpopulate(val, "TimeSeriesIDColumnNames", &f.TimeSeriesIDColumnNames)
			delete(rawMsg, key)
		case "useStl":
			err = unpopulate(val, "UseStl", &f.UseStl)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ForecastingTrainingSettings.
func (f ForecastingTrainingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTrainingAlgorithms", f.AllowedTrainingAlgorithms)
	populate(objectMap, "blockedTrainingAlgorithms", f.BlockedTrainingAlgorithms)
	populate(objectMap, "enableDnnTraining", f.EnableDnnTraining)
	populate(objectMap, "enableModelExplainability", f.EnableModelExplainability)
	populate(objectMap, "enableOnnxCompatibleModels", f.EnableOnnxCompatibleModels)
	populate(objectMap, "enableStackEnsemble", f.EnableStackEnsemble)
	populate(objectMap, "enableVoteEnsemble", f.EnableVoteEnsemble)
	populate(objectMap, "ensembleModelDownloadTimeout", f.EnsembleModelDownloadTimeout)
	populate(objectMap, "stackEnsembleSettings", f.StackEnsembleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ForecastingTrainingSettings.
func (f *ForecastingTrainingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTrainingAlgorithms":
			err = unpopulate(val, "AllowedTrainingAlgorithms", &f.AllowedTrainingAlgorithms)
			delete(rawMsg, key)
		case "blockedTrainingAlgorithms":
			err = unpopulate(val, "BlockedTrainingAlgorithms", &f.BlockedTrainingAlgorithms)
			delete(rawMsg, key)
		case "enableDnnTraining":
			err = unpopulate(val, "EnableDnnTraining", &f.EnableDnnTraining)
			delete(rawMsg, key)
		case "enableModelExplainability":
			err = unpopulate(val, "EnableModelExplainability", &f.EnableModelExplainability)
			delete(rawMsg, key)
		case "enableOnnxCompatibleModels":
			err = unpopulate(val, "EnableOnnxCompatibleModels", &f.EnableOnnxCompatibleModels)
			delete(rawMsg, key)
		case "enableStackEnsemble":
			err = unpopulate(val, "EnableStackEnsemble", &f.EnableStackEnsemble)
			delete(rawMsg, key)
		case "enableVoteEnsemble":
			err = unpopulate(val, "EnableVoteEnsemble", &f.EnableVoteEnsemble)
			delete(rawMsg, key)
		case "ensembleModelDownloadTimeout":
			err = unpopulate(val, "EnsembleModelDownloadTimeout", &f.EnsembleModelDownloadTimeout)
			delete(rawMsg, key)
		case "stackEnsembleSettings":
			err = unpopulate(val, "StackEnsembleSettings", &f.StackEnsembleSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GridSamplingAlgorithm.
func (g GridSamplingAlgorithm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["samplingAlgorithmType"] = SamplingAlgorithmTypeGrid
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GridSamplingAlgorithm.
func (g *GridSamplingAlgorithm) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "samplingAlgorithmType":
			err = unpopulate(val, "SamplingAlgorithmType", &g.SamplingAlgorithmType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsight.
func (h HDInsight) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", h.ComputeLocation)
	objectMap["computeType"] = ComputeTypeHDInsight
	populateDateTimeRFC3339(objectMap, "createdOn", h.CreatedOn)
	populate(objectMap, "description", h.Description)
	populate(objectMap, "disableLocalAuth", h.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", h.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", h.ModifiedOn)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "provisioningErrors", h.ProvisioningErrors)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "resourceId", h.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsight.
func (h *HDInsight) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &h.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &h.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &h.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &h.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &h.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &h.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &h.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &h.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &h.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightProperties.
func (h HDInsightProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", h.Address)
	populate(objectMap, "administratorAccount", h.AdministratorAccount)
	populate(objectMap, "sshPort", h.SSHPort)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightProperties.
func (h *HDInsightProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &h.Address)
			delete(rawMsg, key)
		case "administratorAccount":
			err = unpopulate(val, "AdministratorAccount", &h.AdministratorAccount)
			delete(rawMsg, key)
		case "sshPort":
			err = unpopulate(val, "SSHPort", &h.SSHPort)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HDInsightSchema.
func (h HDInsightSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", h.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HDInsightSchema.
func (h *HDInsightSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IDAssetReference.
func (i IDAssetReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assetId", i.AssetID)
	objectMap["referenceType"] = ReferenceTypeID
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IDAssetReference.
func (i *IDAssetReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assetId":
			err = unpopulate(val, "AssetID", &i.AssetID)
			delete(rawMsg, key)
		case "referenceType":
			err = unpopulate(val, "ReferenceType", &i.ReferenceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityConfiguration.
func (i IdentityConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["identityType"] = i.IdentityType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityConfiguration.
func (i *IdentityConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityType":
			err = unpopulate(val, "IdentityType", &i.IdentityType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityForCmk.
func (i IdentityForCmk) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userAssignedIdentity", i.UserAssignedIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityForCmk.
func (i *IdentityForCmk) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userAssignedIdentity":
			err = unpopulate(val, "UserAssignedIdentity", &i.UserAssignedIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageClassification.
func (i ImageClassification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "logVerbosity", i.LogVerbosity)
	populate(objectMap, "modelSettings", i.ModelSettings)
	populate(objectMap, "primaryMetric", i.PrimaryMetric)
	populate(objectMap, "searchSpace", i.SearchSpace)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "targetColumnName", i.TargetColumnName)
	objectMap["taskType"] = TaskTypeImageClassification
	populate(objectMap, "trainingData", i.TrainingData)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageClassification.
func (i *ImageClassification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &i.LogVerbosity)
			delete(rawMsg, key)
		case "modelSettings":
			err = unpopulate(val, "ModelSettings", &i.ModelSettings)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &i.PrimaryMetric)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &i.SearchSpace)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &i.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &i.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &i.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageClassificationBase.
func (i ImageClassificationBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "modelSettings", i.ModelSettings)
	populate(objectMap, "searchSpace", i.SearchSpace)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageClassificationBase.
func (i *ImageClassificationBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "modelSettings":
			err = unpopulate(val, "ModelSettings", &i.ModelSettings)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &i.SearchSpace)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageClassificationMultilabel.
func (i ImageClassificationMultilabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "logVerbosity", i.LogVerbosity)
	populate(objectMap, "modelSettings", i.ModelSettings)
	populate(objectMap, "primaryMetric", i.PrimaryMetric)
	populate(objectMap, "searchSpace", i.SearchSpace)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "targetColumnName", i.TargetColumnName)
	objectMap["taskType"] = TaskTypeImageClassificationMultilabel
	populate(objectMap, "trainingData", i.TrainingData)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageClassificationMultilabel.
func (i *ImageClassificationMultilabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &i.LogVerbosity)
			delete(rawMsg, key)
		case "modelSettings":
			err = unpopulate(val, "ModelSettings", &i.ModelSettings)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &i.PrimaryMetric)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &i.SearchSpace)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &i.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &i.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &i.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageInstanceSegmentation.
func (i ImageInstanceSegmentation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "logVerbosity", i.LogVerbosity)
	populate(objectMap, "modelSettings", i.ModelSettings)
	populate(objectMap, "primaryMetric", i.PrimaryMetric)
	populate(objectMap, "searchSpace", i.SearchSpace)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "targetColumnName", i.TargetColumnName)
	objectMap["taskType"] = TaskTypeImageInstanceSegmentation
	populate(objectMap, "trainingData", i.TrainingData)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageInstanceSegmentation.
func (i *ImageInstanceSegmentation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &i.LogVerbosity)
			delete(rawMsg, key)
		case "modelSettings":
			err = unpopulate(val, "ModelSettings", &i.ModelSettings)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &i.PrimaryMetric)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &i.SearchSpace)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &i.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &i.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &i.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageLimitSettings.
func (i ImageLimitSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxConcurrentTrials", i.MaxConcurrentTrials)
	populate(objectMap, "maxTrials", i.MaxTrials)
	populate(objectMap, "timeout", i.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageLimitSettings.
func (i *ImageLimitSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxConcurrentTrials":
			err = unpopulate(val, "MaxConcurrentTrials", &i.MaxConcurrentTrials)
			delete(rawMsg, key)
		case "maxTrials":
			err = unpopulate(val, "MaxTrials", &i.MaxTrials)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &i.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageModelDistributionSettings.
func (i ImageModelDistributionSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amsGradient", i.AmsGradient)
	populate(objectMap, "augmentations", i.Augmentations)
	populate(objectMap, "beta1", i.Beta1)
	populate(objectMap, "beta2", i.Beta2)
	populate(objectMap, "distributed", i.Distributed)
	populate(objectMap, "earlyStopping", i.EarlyStopping)
	populate(objectMap, "earlyStoppingDelay", i.EarlyStoppingDelay)
	populate(objectMap, "earlyStoppingPatience", i.EarlyStoppingPatience)
	populate(objectMap, "enableOnnxNormalization", i.EnableOnnxNormalization)
	populate(objectMap, "evaluationFrequency", i.EvaluationFrequency)
	populate(objectMap, "gradientAccumulationStep", i.GradientAccumulationStep)
	populate(objectMap, "layersToFreeze", i.LayersToFreeze)
	populate(objectMap, "learningRate", i.LearningRate)
	populate(objectMap, "learningRateScheduler", i.LearningRateScheduler)
	populate(objectMap, "modelName", i.ModelName)
	populate(objectMap, "momentum", i.Momentum)
	populate(objectMap, "nesterov", i.Nesterov)
	populate(objectMap, "numberOfEpochs", i.NumberOfEpochs)
	populate(objectMap, "numberOfWorkers", i.NumberOfWorkers)
	populate(objectMap, "optimizer", i.Optimizer)
	populate(objectMap, "randomSeed", i.RandomSeed)
	populate(objectMap, "stepLRGamma", i.StepLRGamma)
	populate(objectMap, "stepLRStepSize", i.StepLRStepSize)
	populate(objectMap, "trainingBatchSize", i.TrainingBatchSize)
	populate(objectMap, "validationBatchSize", i.ValidationBatchSize)
	populate(objectMap, "warmupCosineLRCycles", i.WarmupCosineLRCycles)
	populate(objectMap, "warmupCosineLRWarmupEpochs", i.WarmupCosineLRWarmupEpochs)
	populate(objectMap, "weightDecay", i.WeightDecay)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageModelDistributionSettings.
func (i *ImageModelDistributionSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amsGradient":
			err = unpopulate(val, "AmsGradient", &i.AmsGradient)
			delete(rawMsg, key)
		case "augmentations":
			err = unpopulate(val, "Augmentations", &i.Augmentations)
			delete(rawMsg, key)
		case "beta1":
			err = unpopulate(val, "Beta1", &i.Beta1)
			delete(rawMsg, key)
		case "beta2":
			err = unpopulate(val, "Beta2", &i.Beta2)
			delete(rawMsg, key)
		case "distributed":
			err = unpopulate(val, "Distributed", &i.Distributed)
			delete(rawMsg, key)
		case "earlyStopping":
			err = unpopulate(val, "EarlyStopping", &i.EarlyStopping)
			delete(rawMsg, key)
		case "earlyStoppingDelay":
			err = unpopulate(val, "EarlyStoppingDelay", &i.EarlyStoppingDelay)
			delete(rawMsg, key)
		case "earlyStoppingPatience":
			err = unpopulate(val, "EarlyStoppingPatience", &i.EarlyStoppingPatience)
			delete(rawMsg, key)
		case "enableOnnxNormalization":
			err = unpopulate(val, "EnableOnnxNormalization", &i.EnableOnnxNormalization)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, "EvaluationFrequency", &i.EvaluationFrequency)
			delete(rawMsg, key)
		case "gradientAccumulationStep":
			err = unpopulate(val, "GradientAccumulationStep", &i.GradientAccumulationStep)
			delete(rawMsg, key)
		case "layersToFreeze":
			err = unpopulate(val, "LayersToFreeze", &i.LayersToFreeze)
			delete(rawMsg, key)
		case "learningRate":
			err = unpopulate(val, "LearningRate", &i.LearningRate)
			delete(rawMsg, key)
		case "learningRateScheduler":
			err = unpopulate(val, "LearningRateScheduler", &i.LearningRateScheduler)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &i.ModelName)
			delete(rawMsg, key)
		case "momentum":
			err = unpopulate(val, "Momentum", &i.Momentum)
			delete(rawMsg, key)
		case "nesterov":
			err = unpopulate(val, "Nesterov", &i.Nesterov)
			delete(rawMsg, key)
		case "numberOfEpochs":
			err = unpopulate(val, "NumberOfEpochs", &i.NumberOfEpochs)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &i.NumberOfWorkers)
			delete(rawMsg, key)
		case "optimizer":
			err = unpopulate(val, "Optimizer", &i.Optimizer)
			delete(rawMsg, key)
		case "randomSeed":
			err = unpopulate(val, "RandomSeed", &i.RandomSeed)
			delete(rawMsg, key)
		case "stepLRGamma":
			err = unpopulate(val, "StepLRGamma", &i.StepLRGamma)
			delete(rawMsg, key)
		case "stepLRStepSize":
			err = unpopulate(val, "StepLRStepSize", &i.StepLRStepSize)
			delete(rawMsg, key)
		case "trainingBatchSize":
			err = unpopulate(val, "TrainingBatchSize", &i.TrainingBatchSize)
			delete(rawMsg, key)
		case "validationBatchSize":
			err = unpopulate(val, "ValidationBatchSize", &i.ValidationBatchSize)
			delete(rawMsg, key)
		case "warmupCosineLRCycles":
			err = unpopulate(val, "WarmupCosineLRCycles", &i.WarmupCosineLRCycles)
			delete(rawMsg, key)
		case "warmupCosineLRWarmupEpochs":
			err = unpopulate(val, "WarmupCosineLRWarmupEpochs", &i.WarmupCosineLRWarmupEpochs)
			delete(rawMsg, key)
		case "weightDecay":
			err = unpopulate(val, "WeightDecay", &i.WeightDecay)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageModelDistributionSettingsClassification.
func (i ImageModelDistributionSettingsClassification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amsGradient", i.AmsGradient)
	populate(objectMap, "augmentations", i.Augmentations)
	populate(objectMap, "beta1", i.Beta1)
	populate(objectMap, "beta2", i.Beta2)
	populate(objectMap, "distributed", i.Distributed)
	populate(objectMap, "earlyStopping", i.EarlyStopping)
	populate(objectMap, "earlyStoppingDelay", i.EarlyStoppingDelay)
	populate(objectMap, "earlyStoppingPatience", i.EarlyStoppingPatience)
	populate(objectMap, "enableOnnxNormalization", i.EnableOnnxNormalization)
	populate(objectMap, "evaluationFrequency", i.EvaluationFrequency)
	populate(objectMap, "gradientAccumulationStep", i.GradientAccumulationStep)
	populate(objectMap, "layersToFreeze", i.LayersToFreeze)
	populate(objectMap, "learningRate", i.LearningRate)
	populate(objectMap, "learningRateScheduler", i.LearningRateScheduler)
	populate(objectMap, "modelName", i.ModelName)
	populate(objectMap, "momentum", i.Momentum)
	populate(objectMap, "nesterov", i.Nesterov)
	populate(objectMap, "numberOfEpochs", i.NumberOfEpochs)
	populate(objectMap, "numberOfWorkers", i.NumberOfWorkers)
	populate(objectMap, "optimizer", i.Optimizer)
	populate(objectMap, "randomSeed", i.RandomSeed)
	populate(objectMap, "stepLRGamma", i.StepLRGamma)
	populate(objectMap, "stepLRStepSize", i.StepLRStepSize)
	populate(objectMap, "trainingBatchSize", i.TrainingBatchSize)
	populate(objectMap, "trainingCropSize", i.TrainingCropSize)
	populate(objectMap, "validationBatchSize", i.ValidationBatchSize)
	populate(objectMap, "validationCropSize", i.ValidationCropSize)
	populate(objectMap, "validationResizeSize", i.ValidationResizeSize)
	populate(objectMap, "warmupCosineLRCycles", i.WarmupCosineLRCycles)
	populate(objectMap, "warmupCosineLRWarmupEpochs", i.WarmupCosineLRWarmupEpochs)
	populate(objectMap, "weightDecay", i.WeightDecay)
	populate(objectMap, "weightedLoss", i.WeightedLoss)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageModelDistributionSettingsClassification.
func (i *ImageModelDistributionSettingsClassification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amsGradient":
			err = unpopulate(val, "AmsGradient", &i.AmsGradient)
			delete(rawMsg, key)
		case "augmentations":
			err = unpopulate(val, "Augmentations", &i.Augmentations)
			delete(rawMsg, key)
		case "beta1":
			err = unpopulate(val, "Beta1", &i.Beta1)
			delete(rawMsg, key)
		case "beta2":
			err = unpopulate(val, "Beta2", &i.Beta2)
			delete(rawMsg, key)
		case "distributed":
			err = unpopulate(val, "Distributed", &i.Distributed)
			delete(rawMsg, key)
		case "earlyStopping":
			err = unpopulate(val, "EarlyStopping", &i.EarlyStopping)
			delete(rawMsg, key)
		case "earlyStoppingDelay":
			err = unpopulate(val, "EarlyStoppingDelay", &i.EarlyStoppingDelay)
			delete(rawMsg, key)
		case "earlyStoppingPatience":
			err = unpopulate(val, "EarlyStoppingPatience", &i.EarlyStoppingPatience)
			delete(rawMsg, key)
		case "enableOnnxNormalization":
			err = unpopulate(val, "EnableOnnxNormalization", &i.EnableOnnxNormalization)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, "EvaluationFrequency", &i.EvaluationFrequency)
			delete(rawMsg, key)
		case "gradientAccumulationStep":
			err = unpopulate(val, "GradientAccumulationStep", &i.GradientAccumulationStep)
			delete(rawMsg, key)
		case "layersToFreeze":
			err = unpopulate(val, "LayersToFreeze", &i.LayersToFreeze)
			delete(rawMsg, key)
		case "learningRate":
			err = unpopulate(val, "LearningRate", &i.LearningRate)
			delete(rawMsg, key)
		case "learningRateScheduler":
			err = unpopulate(val, "LearningRateScheduler", &i.LearningRateScheduler)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &i.ModelName)
			delete(rawMsg, key)
		case "momentum":
			err = unpopulate(val, "Momentum", &i.Momentum)
			delete(rawMsg, key)
		case "nesterov":
			err = unpopulate(val, "Nesterov", &i.Nesterov)
			delete(rawMsg, key)
		case "numberOfEpochs":
			err = unpopulate(val, "NumberOfEpochs", &i.NumberOfEpochs)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &i.NumberOfWorkers)
			delete(rawMsg, key)
		case "optimizer":
			err = unpopulate(val, "Optimizer", &i.Optimizer)
			delete(rawMsg, key)
		case "randomSeed":
			err = unpopulate(val, "RandomSeed", &i.RandomSeed)
			delete(rawMsg, key)
		case "stepLRGamma":
			err = unpopulate(val, "StepLRGamma", &i.StepLRGamma)
			delete(rawMsg, key)
		case "stepLRStepSize":
			err = unpopulate(val, "StepLRStepSize", &i.StepLRStepSize)
			delete(rawMsg, key)
		case "trainingBatchSize":
			err = unpopulate(val, "TrainingBatchSize", &i.TrainingBatchSize)
			delete(rawMsg, key)
		case "trainingCropSize":
			err = unpopulate(val, "TrainingCropSize", &i.TrainingCropSize)
			delete(rawMsg, key)
		case "validationBatchSize":
			err = unpopulate(val, "ValidationBatchSize", &i.ValidationBatchSize)
			delete(rawMsg, key)
		case "validationCropSize":
			err = unpopulate(val, "ValidationCropSize", &i.ValidationCropSize)
			delete(rawMsg, key)
		case "validationResizeSize":
			err = unpopulate(val, "ValidationResizeSize", &i.ValidationResizeSize)
			delete(rawMsg, key)
		case "warmupCosineLRCycles":
			err = unpopulate(val, "WarmupCosineLRCycles", &i.WarmupCosineLRCycles)
			delete(rawMsg, key)
		case "warmupCosineLRWarmupEpochs":
			err = unpopulate(val, "WarmupCosineLRWarmupEpochs", &i.WarmupCosineLRWarmupEpochs)
			delete(rawMsg, key)
		case "weightDecay":
			err = unpopulate(val, "WeightDecay", &i.WeightDecay)
			delete(rawMsg, key)
		case "weightedLoss":
			err = unpopulate(val, "WeightedLoss", &i.WeightedLoss)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageModelDistributionSettingsObjectDetection.
func (i ImageModelDistributionSettingsObjectDetection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amsGradient", i.AmsGradient)
	populate(objectMap, "augmentations", i.Augmentations)
	populate(objectMap, "beta1", i.Beta1)
	populate(objectMap, "beta2", i.Beta2)
	populate(objectMap, "boxDetectionsPerImage", i.BoxDetectionsPerImage)
	populate(objectMap, "boxScoreThreshold", i.BoxScoreThreshold)
	populate(objectMap, "distributed", i.Distributed)
	populate(objectMap, "earlyStopping", i.EarlyStopping)
	populate(objectMap, "earlyStoppingDelay", i.EarlyStoppingDelay)
	populate(objectMap, "earlyStoppingPatience", i.EarlyStoppingPatience)
	populate(objectMap, "enableOnnxNormalization", i.EnableOnnxNormalization)
	populate(objectMap, "evaluationFrequency", i.EvaluationFrequency)
	populate(objectMap, "gradientAccumulationStep", i.GradientAccumulationStep)
	populate(objectMap, "imageSize", i.ImageSize)
	populate(objectMap, "layersToFreeze", i.LayersToFreeze)
	populate(objectMap, "learningRate", i.LearningRate)
	populate(objectMap, "learningRateScheduler", i.LearningRateScheduler)
	populate(objectMap, "maxSize", i.MaxSize)
	populate(objectMap, "minSize", i.MinSize)
	populate(objectMap, "modelName", i.ModelName)
	populate(objectMap, "modelSize", i.ModelSize)
	populate(objectMap, "momentum", i.Momentum)
	populate(objectMap, "multiScale", i.MultiScale)
	populate(objectMap, "nesterov", i.Nesterov)
	populate(objectMap, "nmsIouThreshold", i.NmsIouThreshold)
	populate(objectMap, "numberOfEpochs", i.NumberOfEpochs)
	populate(objectMap, "numberOfWorkers", i.NumberOfWorkers)
	populate(objectMap, "optimizer", i.Optimizer)
	populate(objectMap, "randomSeed", i.RandomSeed)
	populate(objectMap, "stepLRGamma", i.StepLRGamma)
	populate(objectMap, "stepLRStepSize", i.StepLRStepSize)
	populate(objectMap, "tileGridSize", i.TileGridSize)
	populate(objectMap, "tileOverlapRatio", i.TileOverlapRatio)
	populate(objectMap, "tilePredictionsNmsThreshold", i.TilePredictionsNmsThreshold)
	populate(objectMap, "trainingBatchSize", i.TrainingBatchSize)
	populate(objectMap, "validationBatchSize", i.ValidationBatchSize)
	populate(objectMap, "validationIouThreshold", i.ValidationIouThreshold)
	populate(objectMap, "validationMetricType", i.ValidationMetricType)
	populate(objectMap, "warmupCosineLRCycles", i.WarmupCosineLRCycles)
	populate(objectMap, "warmupCosineLRWarmupEpochs", i.WarmupCosineLRWarmupEpochs)
	populate(objectMap, "weightDecay", i.WeightDecay)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageModelDistributionSettingsObjectDetection.
func (i *ImageModelDistributionSettingsObjectDetection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amsGradient":
			err = unpopulate(val, "AmsGradient", &i.AmsGradient)
			delete(rawMsg, key)
		case "augmentations":
			err = unpopulate(val, "Augmentations", &i.Augmentations)
			delete(rawMsg, key)
		case "beta1":
			err = unpopulate(val, "Beta1", &i.Beta1)
			delete(rawMsg, key)
		case "beta2":
			err = unpopulate(val, "Beta2", &i.Beta2)
			delete(rawMsg, key)
		case "boxDetectionsPerImage":
			err = unpopulate(val, "BoxDetectionsPerImage", &i.BoxDetectionsPerImage)
			delete(rawMsg, key)
		case "boxScoreThreshold":
			err = unpopulate(val, "BoxScoreThreshold", &i.BoxScoreThreshold)
			delete(rawMsg, key)
		case "distributed":
			err = unpopulate(val, "Distributed", &i.Distributed)
			delete(rawMsg, key)
		case "earlyStopping":
			err = unpopulate(val, "EarlyStopping", &i.EarlyStopping)
			delete(rawMsg, key)
		case "earlyStoppingDelay":
			err = unpopulate(val, "EarlyStoppingDelay", &i.EarlyStoppingDelay)
			delete(rawMsg, key)
		case "earlyStoppingPatience":
			err = unpopulate(val, "EarlyStoppingPatience", &i.EarlyStoppingPatience)
			delete(rawMsg, key)
		case "enableOnnxNormalization":
			err = unpopulate(val, "EnableOnnxNormalization", &i.EnableOnnxNormalization)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, "EvaluationFrequency", &i.EvaluationFrequency)
			delete(rawMsg, key)
		case "gradientAccumulationStep":
			err = unpopulate(val, "GradientAccumulationStep", &i.GradientAccumulationStep)
			delete(rawMsg, key)
		case "imageSize":
			err = unpopulate(val, "ImageSize", &i.ImageSize)
			delete(rawMsg, key)
		case "layersToFreeze":
			err = unpopulate(val, "LayersToFreeze", &i.LayersToFreeze)
			delete(rawMsg, key)
		case "learningRate":
			err = unpopulate(val, "LearningRate", &i.LearningRate)
			delete(rawMsg, key)
		case "learningRateScheduler":
			err = unpopulate(val, "LearningRateScheduler", &i.LearningRateScheduler)
			delete(rawMsg, key)
		case "maxSize":
			err = unpopulate(val, "MaxSize", &i.MaxSize)
			delete(rawMsg, key)
		case "minSize":
			err = unpopulate(val, "MinSize", &i.MinSize)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &i.ModelName)
			delete(rawMsg, key)
		case "modelSize":
			err = unpopulate(val, "ModelSize", &i.ModelSize)
			delete(rawMsg, key)
		case "momentum":
			err = unpopulate(val, "Momentum", &i.Momentum)
			delete(rawMsg, key)
		case "multiScale":
			err = unpopulate(val, "MultiScale", &i.MultiScale)
			delete(rawMsg, key)
		case "nesterov":
			err = unpopulate(val, "Nesterov", &i.Nesterov)
			delete(rawMsg, key)
		case "nmsIouThreshold":
			err = unpopulate(val, "NmsIouThreshold", &i.NmsIouThreshold)
			delete(rawMsg, key)
		case "numberOfEpochs":
			err = unpopulate(val, "NumberOfEpochs", &i.NumberOfEpochs)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &i.NumberOfWorkers)
			delete(rawMsg, key)
		case "optimizer":
			err = unpopulate(val, "Optimizer", &i.Optimizer)
			delete(rawMsg, key)
		case "randomSeed":
			err = unpopulate(val, "RandomSeed", &i.RandomSeed)
			delete(rawMsg, key)
		case "stepLRGamma":
			err = unpopulate(val, "StepLRGamma", &i.StepLRGamma)
			delete(rawMsg, key)
		case "stepLRStepSize":
			err = unpopulate(val, "StepLRStepSize", &i.StepLRStepSize)
			delete(rawMsg, key)
		case "tileGridSize":
			err = unpopulate(val, "TileGridSize", &i.TileGridSize)
			delete(rawMsg, key)
		case "tileOverlapRatio":
			err = unpopulate(val, "TileOverlapRatio", &i.TileOverlapRatio)
			delete(rawMsg, key)
		case "tilePredictionsNmsThreshold":
			err = unpopulate(val, "TilePredictionsNmsThreshold", &i.TilePredictionsNmsThreshold)
			delete(rawMsg, key)
		case "trainingBatchSize":
			err = unpopulate(val, "TrainingBatchSize", &i.TrainingBatchSize)
			delete(rawMsg, key)
		case "validationBatchSize":
			err = unpopulate(val, "ValidationBatchSize", &i.ValidationBatchSize)
			delete(rawMsg, key)
		case "validationIouThreshold":
			err = unpopulate(val, "ValidationIouThreshold", &i.ValidationIouThreshold)
			delete(rawMsg, key)
		case "validationMetricType":
			err = unpopulate(val, "ValidationMetricType", &i.ValidationMetricType)
			delete(rawMsg, key)
		case "warmupCosineLRCycles":
			err = unpopulate(val, "WarmupCosineLRCycles", &i.WarmupCosineLRCycles)
			delete(rawMsg, key)
		case "warmupCosineLRWarmupEpochs":
			err = unpopulate(val, "WarmupCosineLRWarmupEpochs", &i.WarmupCosineLRWarmupEpochs)
			delete(rawMsg, key)
		case "weightDecay":
			err = unpopulate(val, "WeightDecay", &i.WeightDecay)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageModelSettings.
func (i ImageModelSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "advancedSettings", i.AdvancedSettings)
	populate(objectMap, "amsGradient", i.AmsGradient)
	populate(objectMap, "augmentations", i.Augmentations)
	populate(objectMap, "beta1", i.Beta1)
	populate(objectMap, "beta2", i.Beta2)
	populate(objectMap, "checkpointFrequency", i.CheckpointFrequency)
	populate(objectMap, "checkpointModel", i.CheckpointModel)
	populate(objectMap, "checkpointRunId", i.CheckpointRunID)
	populate(objectMap, "distributed", i.Distributed)
	populate(objectMap, "earlyStopping", i.EarlyStopping)
	populate(objectMap, "earlyStoppingDelay", i.EarlyStoppingDelay)
	populate(objectMap, "earlyStoppingPatience", i.EarlyStoppingPatience)
	populate(objectMap, "enableOnnxNormalization", i.EnableOnnxNormalization)
	populate(objectMap, "evaluationFrequency", i.EvaluationFrequency)
	populate(objectMap, "gradientAccumulationStep", i.GradientAccumulationStep)
	populate(objectMap, "layersToFreeze", i.LayersToFreeze)
	populate(objectMap, "learningRate", i.LearningRate)
	populate(objectMap, "learningRateScheduler", i.LearningRateScheduler)
	populate(objectMap, "modelName", i.ModelName)
	populate(objectMap, "momentum", i.Momentum)
	populate(objectMap, "nesterov", i.Nesterov)
	populate(objectMap, "numberOfEpochs", i.NumberOfEpochs)
	populate(objectMap, "numberOfWorkers", i.NumberOfWorkers)
	populate(objectMap, "optimizer", i.Optimizer)
	populate(objectMap, "randomSeed", i.RandomSeed)
	populate(objectMap, "stepLRGamma", i.StepLRGamma)
	populate(objectMap, "stepLRStepSize", i.StepLRStepSize)
	populate(objectMap, "trainingBatchSize", i.TrainingBatchSize)
	populate(objectMap, "validationBatchSize", i.ValidationBatchSize)
	populate(objectMap, "warmupCosineLRCycles", i.WarmupCosineLRCycles)
	populate(objectMap, "warmupCosineLRWarmupEpochs", i.WarmupCosineLRWarmupEpochs)
	populate(objectMap, "weightDecay", i.WeightDecay)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageModelSettings.
func (i *ImageModelSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSettings":
			err = unpopulate(val, "AdvancedSettings", &i.AdvancedSettings)
			delete(rawMsg, key)
		case "amsGradient":
			err = unpopulate(val, "AmsGradient", &i.AmsGradient)
			delete(rawMsg, key)
		case "augmentations":
			err = unpopulate(val, "Augmentations", &i.Augmentations)
			delete(rawMsg, key)
		case "beta1":
			err = unpopulate(val, "Beta1", &i.Beta1)
			delete(rawMsg, key)
		case "beta2":
			err = unpopulate(val, "Beta2", &i.Beta2)
			delete(rawMsg, key)
		case "checkpointFrequency":
			err = unpopulate(val, "CheckpointFrequency", &i.CheckpointFrequency)
			delete(rawMsg, key)
		case "checkpointModel":
			err = unpopulate(val, "CheckpointModel", &i.CheckpointModel)
			delete(rawMsg, key)
		case "checkpointRunId":
			err = unpopulate(val, "CheckpointRunID", &i.CheckpointRunID)
			delete(rawMsg, key)
		case "distributed":
			err = unpopulate(val, "Distributed", &i.Distributed)
			delete(rawMsg, key)
		case "earlyStopping":
			err = unpopulate(val, "EarlyStopping", &i.EarlyStopping)
			delete(rawMsg, key)
		case "earlyStoppingDelay":
			err = unpopulate(val, "EarlyStoppingDelay", &i.EarlyStoppingDelay)
			delete(rawMsg, key)
		case "earlyStoppingPatience":
			err = unpopulate(val, "EarlyStoppingPatience", &i.EarlyStoppingPatience)
			delete(rawMsg, key)
		case "enableOnnxNormalization":
			err = unpopulate(val, "EnableOnnxNormalization", &i.EnableOnnxNormalization)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, "EvaluationFrequency", &i.EvaluationFrequency)
			delete(rawMsg, key)
		case "gradientAccumulationStep":
			err = unpopulate(val, "GradientAccumulationStep", &i.GradientAccumulationStep)
			delete(rawMsg, key)
		case "layersToFreeze":
			err = unpopulate(val, "LayersToFreeze", &i.LayersToFreeze)
			delete(rawMsg, key)
		case "learningRate":
			err = unpopulate(val, "LearningRate", &i.LearningRate)
			delete(rawMsg, key)
		case "learningRateScheduler":
			err = unpopulate(val, "LearningRateScheduler", &i.LearningRateScheduler)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &i.ModelName)
			delete(rawMsg, key)
		case "momentum":
			err = unpopulate(val, "Momentum", &i.Momentum)
			delete(rawMsg, key)
		case "nesterov":
			err = unpopulate(val, "Nesterov", &i.Nesterov)
			delete(rawMsg, key)
		case "numberOfEpochs":
			err = unpopulate(val, "NumberOfEpochs", &i.NumberOfEpochs)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &i.NumberOfWorkers)
			delete(rawMsg, key)
		case "optimizer":
			err = unpopulate(val, "Optimizer", &i.Optimizer)
			delete(rawMsg, key)
		case "randomSeed":
			err = unpopulate(val, "RandomSeed", &i.RandomSeed)
			delete(rawMsg, key)
		case "stepLRGamma":
			err = unpopulate(val, "StepLRGamma", &i.StepLRGamma)
			delete(rawMsg, key)
		case "stepLRStepSize":
			err = unpopulate(val, "StepLRStepSize", &i.StepLRStepSize)
			delete(rawMsg, key)
		case "trainingBatchSize":
			err = unpopulate(val, "TrainingBatchSize", &i.TrainingBatchSize)
			delete(rawMsg, key)
		case "validationBatchSize":
			err = unpopulate(val, "ValidationBatchSize", &i.ValidationBatchSize)
			delete(rawMsg, key)
		case "warmupCosineLRCycles":
			err = unpopulate(val, "WarmupCosineLRCycles", &i.WarmupCosineLRCycles)
			delete(rawMsg, key)
		case "warmupCosineLRWarmupEpochs":
			err = unpopulate(val, "WarmupCosineLRWarmupEpochs", &i.WarmupCosineLRWarmupEpochs)
			delete(rawMsg, key)
		case "weightDecay":
			err = unpopulate(val, "WeightDecay", &i.WeightDecay)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageModelSettingsClassification.
func (i ImageModelSettingsClassification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "advancedSettings", i.AdvancedSettings)
	populate(objectMap, "amsGradient", i.AmsGradient)
	populate(objectMap, "augmentations", i.Augmentations)
	populate(objectMap, "beta1", i.Beta1)
	populate(objectMap, "beta2", i.Beta2)
	populate(objectMap, "checkpointFrequency", i.CheckpointFrequency)
	populate(objectMap, "checkpointModel", i.CheckpointModel)
	populate(objectMap, "checkpointRunId", i.CheckpointRunID)
	populate(objectMap, "distributed", i.Distributed)
	populate(objectMap, "earlyStopping", i.EarlyStopping)
	populate(objectMap, "earlyStoppingDelay", i.EarlyStoppingDelay)
	populate(objectMap, "earlyStoppingPatience", i.EarlyStoppingPatience)
	populate(objectMap, "enableOnnxNormalization", i.EnableOnnxNormalization)
	populate(objectMap, "evaluationFrequency", i.EvaluationFrequency)
	populate(objectMap, "gradientAccumulationStep", i.GradientAccumulationStep)
	populate(objectMap, "layersToFreeze", i.LayersToFreeze)
	populate(objectMap, "learningRate", i.LearningRate)
	populate(objectMap, "learningRateScheduler", i.LearningRateScheduler)
	populate(objectMap, "modelName", i.ModelName)
	populate(objectMap, "momentum", i.Momentum)
	populate(objectMap, "nesterov", i.Nesterov)
	populate(objectMap, "numberOfEpochs", i.NumberOfEpochs)
	populate(objectMap, "numberOfWorkers", i.NumberOfWorkers)
	populate(objectMap, "optimizer", i.Optimizer)
	populate(objectMap, "randomSeed", i.RandomSeed)
	populate(objectMap, "stepLRGamma", i.StepLRGamma)
	populate(objectMap, "stepLRStepSize", i.StepLRStepSize)
	populate(objectMap, "trainingBatchSize", i.TrainingBatchSize)
	populate(objectMap, "trainingCropSize", i.TrainingCropSize)
	populate(objectMap, "validationBatchSize", i.ValidationBatchSize)
	populate(objectMap, "validationCropSize", i.ValidationCropSize)
	populate(objectMap, "validationResizeSize", i.ValidationResizeSize)
	populate(objectMap, "warmupCosineLRCycles", i.WarmupCosineLRCycles)
	populate(objectMap, "warmupCosineLRWarmupEpochs", i.WarmupCosineLRWarmupEpochs)
	populate(objectMap, "weightDecay", i.WeightDecay)
	populate(objectMap, "weightedLoss", i.WeightedLoss)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageModelSettingsClassification.
func (i *ImageModelSettingsClassification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSettings":
			err = unpopulate(val, "AdvancedSettings", &i.AdvancedSettings)
			delete(rawMsg, key)
		case "amsGradient":
			err = unpopulate(val, "AmsGradient", &i.AmsGradient)
			delete(rawMsg, key)
		case "augmentations":
			err = unpopulate(val, "Augmentations", &i.Augmentations)
			delete(rawMsg, key)
		case "beta1":
			err = unpopulate(val, "Beta1", &i.Beta1)
			delete(rawMsg, key)
		case "beta2":
			err = unpopulate(val, "Beta2", &i.Beta2)
			delete(rawMsg, key)
		case "checkpointFrequency":
			err = unpopulate(val, "CheckpointFrequency", &i.CheckpointFrequency)
			delete(rawMsg, key)
		case "checkpointModel":
			err = unpopulate(val, "CheckpointModel", &i.CheckpointModel)
			delete(rawMsg, key)
		case "checkpointRunId":
			err = unpopulate(val, "CheckpointRunID", &i.CheckpointRunID)
			delete(rawMsg, key)
		case "distributed":
			err = unpopulate(val, "Distributed", &i.Distributed)
			delete(rawMsg, key)
		case "earlyStopping":
			err = unpopulate(val, "EarlyStopping", &i.EarlyStopping)
			delete(rawMsg, key)
		case "earlyStoppingDelay":
			err = unpopulate(val, "EarlyStoppingDelay", &i.EarlyStoppingDelay)
			delete(rawMsg, key)
		case "earlyStoppingPatience":
			err = unpopulate(val, "EarlyStoppingPatience", &i.EarlyStoppingPatience)
			delete(rawMsg, key)
		case "enableOnnxNormalization":
			err = unpopulate(val, "EnableOnnxNormalization", &i.EnableOnnxNormalization)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, "EvaluationFrequency", &i.EvaluationFrequency)
			delete(rawMsg, key)
		case "gradientAccumulationStep":
			err = unpopulate(val, "GradientAccumulationStep", &i.GradientAccumulationStep)
			delete(rawMsg, key)
		case "layersToFreeze":
			err = unpopulate(val, "LayersToFreeze", &i.LayersToFreeze)
			delete(rawMsg, key)
		case "learningRate":
			err = unpopulate(val, "LearningRate", &i.LearningRate)
			delete(rawMsg, key)
		case "learningRateScheduler":
			err = unpopulate(val, "LearningRateScheduler", &i.LearningRateScheduler)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &i.ModelName)
			delete(rawMsg, key)
		case "momentum":
			err = unpopulate(val, "Momentum", &i.Momentum)
			delete(rawMsg, key)
		case "nesterov":
			err = unpopulate(val, "Nesterov", &i.Nesterov)
			delete(rawMsg, key)
		case "numberOfEpochs":
			err = unpopulate(val, "NumberOfEpochs", &i.NumberOfEpochs)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &i.NumberOfWorkers)
			delete(rawMsg, key)
		case "optimizer":
			err = unpopulate(val, "Optimizer", &i.Optimizer)
			delete(rawMsg, key)
		case "randomSeed":
			err = unpopulate(val, "RandomSeed", &i.RandomSeed)
			delete(rawMsg, key)
		case "stepLRGamma":
			err = unpopulate(val, "StepLRGamma", &i.StepLRGamma)
			delete(rawMsg, key)
		case "stepLRStepSize":
			err = unpopulate(val, "StepLRStepSize", &i.StepLRStepSize)
			delete(rawMsg, key)
		case "trainingBatchSize":
			err = unpopulate(val, "TrainingBatchSize", &i.TrainingBatchSize)
			delete(rawMsg, key)
		case "trainingCropSize":
			err = unpopulate(val, "TrainingCropSize", &i.TrainingCropSize)
			delete(rawMsg, key)
		case "validationBatchSize":
			err = unpopulate(val, "ValidationBatchSize", &i.ValidationBatchSize)
			delete(rawMsg, key)
		case "validationCropSize":
			err = unpopulate(val, "ValidationCropSize", &i.ValidationCropSize)
			delete(rawMsg, key)
		case "validationResizeSize":
			err = unpopulate(val, "ValidationResizeSize", &i.ValidationResizeSize)
			delete(rawMsg, key)
		case "warmupCosineLRCycles":
			err = unpopulate(val, "WarmupCosineLRCycles", &i.WarmupCosineLRCycles)
			delete(rawMsg, key)
		case "warmupCosineLRWarmupEpochs":
			err = unpopulate(val, "WarmupCosineLRWarmupEpochs", &i.WarmupCosineLRWarmupEpochs)
			delete(rawMsg, key)
		case "weightDecay":
			err = unpopulate(val, "WeightDecay", &i.WeightDecay)
			delete(rawMsg, key)
		case "weightedLoss":
			err = unpopulate(val, "WeightedLoss", &i.WeightedLoss)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageModelSettingsObjectDetection.
func (i ImageModelSettingsObjectDetection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "advancedSettings", i.AdvancedSettings)
	populate(objectMap, "amsGradient", i.AmsGradient)
	populate(objectMap, "augmentations", i.Augmentations)
	populate(objectMap, "beta1", i.Beta1)
	populate(objectMap, "beta2", i.Beta2)
	populate(objectMap, "boxDetectionsPerImage", i.BoxDetectionsPerImage)
	populate(objectMap, "boxScoreThreshold", i.BoxScoreThreshold)
	populate(objectMap, "checkpointFrequency", i.CheckpointFrequency)
	populate(objectMap, "checkpointModel", i.CheckpointModel)
	populate(objectMap, "checkpointRunId", i.CheckpointRunID)
	populate(objectMap, "distributed", i.Distributed)
	populate(objectMap, "earlyStopping", i.EarlyStopping)
	populate(objectMap, "earlyStoppingDelay", i.EarlyStoppingDelay)
	populate(objectMap, "earlyStoppingPatience", i.EarlyStoppingPatience)
	populate(objectMap, "enableOnnxNormalization", i.EnableOnnxNormalization)
	populate(objectMap, "evaluationFrequency", i.EvaluationFrequency)
	populate(objectMap, "gradientAccumulationStep", i.GradientAccumulationStep)
	populate(objectMap, "imageSize", i.ImageSize)
	populate(objectMap, "layersToFreeze", i.LayersToFreeze)
	populate(objectMap, "learningRate", i.LearningRate)
	populate(objectMap, "learningRateScheduler", i.LearningRateScheduler)
	populate(objectMap, "maxSize", i.MaxSize)
	populate(objectMap, "minSize", i.MinSize)
	populate(objectMap, "modelName", i.ModelName)
	populate(objectMap, "modelSize", i.ModelSize)
	populate(objectMap, "momentum", i.Momentum)
	populate(objectMap, "multiScale", i.MultiScale)
	populate(objectMap, "nesterov", i.Nesterov)
	populate(objectMap, "nmsIouThreshold", i.NmsIouThreshold)
	populate(objectMap, "numberOfEpochs", i.NumberOfEpochs)
	populate(objectMap, "numberOfWorkers", i.NumberOfWorkers)
	populate(objectMap, "optimizer", i.Optimizer)
	populate(objectMap, "randomSeed", i.RandomSeed)
	populate(objectMap, "stepLRGamma", i.StepLRGamma)
	populate(objectMap, "stepLRStepSize", i.StepLRStepSize)
	populate(objectMap, "tileGridSize", i.TileGridSize)
	populate(objectMap, "tileOverlapRatio", i.TileOverlapRatio)
	populate(objectMap, "tilePredictionsNmsThreshold", i.TilePredictionsNmsThreshold)
	populate(objectMap, "trainingBatchSize", i.TrainingBatchSize)
	populate(objectMap, "validationBatchSize", i.ValidationBatchSize)
	populate(objectMap, "validationIouThreshold", i.ValidationIouThreshold)
	populate(objectMap, "validationMetricType", i.ValidationMetricType)
	populate(objectMap, "warmupCosineLRCycles", i.WarmupCosineLRCycles)
	populate(objectMap, "warmupCosineLRWarmupEpochs", i.WarmupCosineLRWarmupEpochs)
	populate(objectMap, "weightDecay", i.WeightDecay)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageModelSettingsObjectDetection.
func (i *ImageModelSettingsObjectDetection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "advancedSettings":
			err = unpopulate(val, "AdvancedSettings", &i.AdvancedSettings)
			delete(rawMsg, key)
		case "amsGradient":
			err = unpopulate(val, "AmsGradient", &i.AmsGradient)
			delete(rawMsg, key)
		case "augmentations":
			err = unpopulate(val, "Augmentations", &i.Augmentations)
			delete(rawMsg, key)
		case "beta1":
			err = unpopulate(val, "Beta1", &i.Beta1)
			delete(rawMsg, key)
		case "beta2":
			err = unpopulate(val, "Beta2", &i.Beta2)
			delete(rawMsg, key)
		case "boxDetectionsPerImage":
			err = unpopulate(val, "BoxDetectionsPerImage", &i.BoxDetectionsPerImage)
			delete(rawMsg, key)
		case "boxScoreThreshold":
			err = unpopulate(val, "BoxScoreThreshold", &i.BoxScoreThreshold)
			delete(rawMsg, key)
		case "checkpointFrequency":
			err = unpopulate(val, "CheckpointFrequency", &i.CheckpointFrequency)
			delete(rawMsg, key)
		case "checkpointModel":
			err = unpopulate(val, "CheckpointModel", &i.CheckpointModel)
			delete(rawMsg, key)
		case "checkpointRunId":
			err = unpopulate(val, "CheckpointRunID", &i.CheckpointRunID)
			delete(rawMsg, key)
		case "distributed":
			err = unpopulate(val, "Distributed", &i.Distributed)
			delete(rawMsg, key)
		case "earlyStopping":
			err = unpopulate(val, "EarlyStopping", &i.EarlyStopping)
			delete(rawMsg, key)
		case "earlyStoppingDelay":
			err = unpopulate(val, "EarlyStoppingDelay", &i.EarlyStoppingDelay)
			delete(rawMsg, key)
		case "earlyStoppingPatience":
			err = unpopulate(val, "EarlyStoppingPatience", &i.EarlyStoppingPatience)
			delete(rawMsg, key)
		case "enableOnnxNormalization":
			err = unpopulate(val, "EnableOnnxNormalization", &i.EnableOnnxNormalization)
			delete(rawMsg, key)
		case "evaluationFrequency":
			err = unpopulate(val, "EvaluationFrequency", &i.EvaluationFrequency)
			delete(rawMsg, key)
		case "gradientAccumulationStep":
			err = unpopulate(val, "GradientAccumulationStep", &i.GradientAccumulationStep)
			delete(rawMsg, key)
		case "imageSize":
			err = unpopulate(val, "ImageSize", &i.ImageSize)
			delete(rawMsg, key)
		case "layersToFreeze":
			err = unpopulate(val, "LayersToFreeze", &i.LayersToFreeze)
			delete(rawMsg, key)
		case "learningRate":
			err = unpopulate(val, "LearningRate", &i.LearningRate)
			delete(rawMsg, key)
		case "learningRateScheduler":
			err = unpopulate(val, "LearningRateScheduler", &i.LearningRateScheduler)
			delete(rawMsg, key)
		case "maxSize":
			err = unpopulate(val, "MaxSize", &i.MaxSize)
			delete(rawMsg, key)
		case "minSize":
			err = unpopulate(val, "MinSize", &i.MinSize)
			delete(rawMsg, key)
		case "modelName":
			err = unpopulate(val, "ModelName", &i.ModelName)
			delete(rawMsg, key)
		case "modelSize":
			err = unpopulate(val, "ModelSize", &i.ModelSize)
			delete(rawMsg, key)
		case "momentum":
			err = unpopulate(val, "Momentum", &i.Momentum)
			delete(rawMsg, key)
		case "multiScale":
			err = unpopulate(val, "MultiScale", &i.MultiScale)
			delete(rawMsg, key)
		case "nesterov":
			err = unpopulate(val, "Nesterov", &i.Nesterov)
			delete(rawMsg, key)
		case "nmsIouThreshold":
			err = unpopulate(val, "NmsIouThreshold", &i.NmsIouThreshold)
			delete(rawMsg, key)
		case "numberOfEpochs":
			err = unpopulate(val, "NumberOfEpochs", &i.NumberOfEpochs)
			delete(rawMsg, key)
		case "numberOfWorkers":
			err = unpopulate(val, "NumberOfWorkers", &i.NumberOfWorkers)
			delete(rawMsg, key)
		case "optimizer":
			err = unpopulate(val, "Optimizer", &i.Optimizer)
			delete(rawMsg, key)
		case "randomSeed":
			err = unpopulate(val, "RandomSeed", &i.RandomSeed)
			delete(rawMsg, key)
		case "stepLRGamma":
			err = unpopulate(val, "StepLRGamma", &i.StepLRGamma)
			delete(rawMsg, key)
		case "stepLRStepSize":
			err = unpopulate(val, "StepLRStepSize", &i.StepLRStepSize)
			delete(rawMsg, key)
		case "tileGridSize":
			err = unpopulate(val, "TileGridSize", &i.TileGridSize)
			delete(rawMsg, key)
		case "tileOverlapRatio":
			err = unpopulate(val, "TileOverlapRatio", &i.TileOverlapRatio)
			delete(rawMsg, key)
		case "tilePredictionsNmsThreshold":
			err = unpopulate(val, "TilePredictionsNmsThreshold", &i.TilePredictionsNmsThreshold)
			delete(rawMsg, key)
		case "trainingBatchSize":
			err = unpopulate(val, "TrainingBatchSize", &i.TrainingBatchSize)
			delete(rawMsg, key)
		case "validationBatchSize":
			err = unpopulate(val, "ValidationBatchSize", &i.ValidationBatchSize)
			delete(rawMsg, key)
		case "validationIouThreshold":
			err = unpopulate(val, "ValidationIouThreshold", &i.ValidationIouThreshold)
			delete(rawMsg, key)
		case "validationMetricType":
			err = unpopulate(val, "ValidationMetricType", &i.ValidationMetricType)
			delete(rawMsg, key)
		case "warmupCosineLRCycles":
			err = unpopulate(val, "WarmupCosineLRCycles", &i.WarmupCosineLRCycles)
			delete(rawMsg, key)
		case "warmupCosineLRWarmupEpochs":
			err = unpopulate(val, "WarmupCosineLRWarmupEpochs", &i.WarmupCosineLRWarmupEpochs)
			delete(rawMsg, key)
		case "weightDecay":
			err = unpopulate(val, "WeightDecay", &i.WeightDecay)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageObjectDetection.
func (i ImageObjectDetection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "logVerbosity", i.LogVerbosity)
	populate(objectMap, "modelSettings", i.ModelSettings)
	populate(objectMap, "primaryMetric", i.PrimaryMetric)
	populate(objectMap, "searchSpace", i.SearchSpace)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "targetColumnName", i.TargetColumnName)
	objectMap["taskType"] = TaskTypeImageObjectDetection
	populate(objectMap, "trainingData", i.TrainingData)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageObjectDetection.
func (i *ImageObjectDetection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &i.LogVerbosity)
			delete(rawMsg, key)
		case "modelSettings":
			err = unpopulate(val, "ModelSettings", &i.ModelSettings)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &i.PrimaryMetric)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &i.SearchSpace)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &i.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &i.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &i.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageObjectDetectionBase.
func (i ImageObjectDetectionBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "modelSettings", i.ModelSettings)
	populate(objectMap, "searchSpace", i.SearchSpace)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageObjectDetectionBase.
func (i *ImageObjectDetectionBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "modelSettings":
			err = unpopulate(val, "ModelSettings", &i.ModelSettings)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &i.SearchSpace)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageSweepSettings.
func (i ImageSweepSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "earlyTermination", i.EarlyTermination)
	populate(objectMap, "samplingAlgorithm", i.SamplingAlgorithm)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageSweepSettings.
func (i *ImageSweepSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "earlyTermination":
			i.EarlyTermination, err = unmarshalEarlyTerminationPolicyClassification(val)
			delete(rawMsg, key)
		case "samplingAlgorithm":
			err = unpopulate(val, "SamplingAlgorithm", &i.SamplingAlgorithm)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ImageVertical.
func (i ImageVertical) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limitSettings", i.LimitSettings)
	populate(objectMap, "sweepSettings", i.SweepSettings)
	populate(objectMap, "validationData", i.ValidationData)
	populate(objectMap, "validationDataSize", i.ValidationDataSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ImageVertical.
func (i *ImageVertical) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &i.LimitSettings)
			delete(rawMsg, key)
		case "sweepSettings":
			err = unpopulate(val, "SweepSettings", &i.SweepSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &i.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &i.ValidationDataSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InferenceContainerProperties.
func (i InferenceContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "livenessRoute", i.LivenessRoute)
	populate(objectMap, "readinessRoute", i.ReadinessRoute)
	populate(objectMap, "scoringRoute", i.ScoringRoute)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InferenceContainerProperties.
func (i *InferenceContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "livenessRoute":
			err = unpopulate(val, "LivenessRoute", &i.LivenessRoute)
			delete(rawMsg, key)
		case "readinessRoute":
			err = unpopulate(val, "ReadinessRoute", &i.ReadinessRoute)
			delete(rawMsg, key)
		case "scoringRoute":
			err = unpopulate(val, "ScoringRoute", &i.ScoringRoute)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstanceTypeSchema.
func (i InstanceTypeSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodeSelector", i.NodeSelector)
	populate(objectMap, "resources", i.Resources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceTypeSchema.
func (i *InstanceTypeSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodeSelector":
			err = unpopulate(val, "NodeSelector", &i.NodeSelector)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &i.Resources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InstanceTypeSchemaResources.
func (i InstanceTypeSchemaResources) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limits", i.Limits)
	populate(objectMap, "requests", i.Requests)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InstanceTypeSchemaResources.
func (i *InstanceTypeSchemaResources) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limits":
			err = unpopulate(val, "Limits", &i.Limits)
			delete(rawMsg, key)
		case "requests":
			err = unpopulate(val, "Requests", &i.Requests)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobBase.
func (j JobBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", j.ID)
	populate(objectMap, "name", j.Name)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "systemData", j.SystemData)
	populate(objectMap, "type", j.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobBase.
func (j *JobBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &j.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &j.Name)
			delete(rawMsg, key)
		case "properties":
			j.Properties, err = unmarshalJobBasePropertiesClassification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &j.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &j.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobBaseProperties.
func (j JobBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", j.ComponentID)
	populate(objectMap, "computeId", j.ComputeID)
	populate(objectMap, "description", j.Description)
	populate(objectMap, "displayName", j.DisplayName)
	populate(objectMap, "experimentName", j.ExperimentName)
	populate(objectMap, "identity", j.Identity)
	populate(objectMap, "isArchived", j.IsArchived)
	objectMap["jobType"] = j.JobType
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "services", j.Services)
	populate(objectMap, "status", j.Status)
	populate(objectMap, "tags", j.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobBaseProperties.
func (j *JobBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &j.ComponentID)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &j.ComputeID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &j.DisplayName)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &j.ExperimentName)
			delete(rawMsg, key)
		case "identity":
			j.Identity, err = unmarshalIdentityConfigurationClassification(val)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &j.IsArchived)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &j.JobType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &j.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &j.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobBaseResourceArmPaginatedResult.
func (j JobBaseResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", j.NextLink)
	populate(objectMap, "value", j.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobBaseResourceArmPaginatedResult.
func (j *JobBaseResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &j.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &j.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobInput.
func (j JobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", j.Description)
	objectMap["jobInputType"] = j.JobInputType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobInput.
func (j *JobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &j.JobInputType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobLimits.
func (j JobLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["jobLimitsType"] = j.JobLimitsType
	populate(objectMap, "timeout", j.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobLimits.
func (j *JobLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobLimitsType":
			err = unpopulate(val, "JobLimitsType", &j.JobLimitsType)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &j.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobOutput.
func (j JobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", j.Description)
	objectMap["jobOutputType"] = j.JobOutputType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobOutput.
func (j *JobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &j.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &j.JobOutputType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobResourceConfiguration.
func (j JobResourceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dockerArgs", j.DockerArgs)
	populate(objectMap, "instanceCount", j.InstanceCount)
	populate(objectMap, "instanceType", j.InstanceType)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "shmSize", j.ShmSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobResourceConfiguration.
func (j *JobResourceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dockerArgs":
			err = unpopulate(val, "DockerArgs", &j.DockerArgs)
			delete(rawMsg, key)
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &j.InstanceCount)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &j.InstanceType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "shmSize":
			err = unpopulate(val, "ShmSize", &j.ShmSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobScheduleAction.
func (j JobScheduleAction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["actionType"] = ScheduleActionTypeCreateJob
	populate(objectMap, "jobDefinition", j.JobDefinition)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobScheduleAction.
func (j *JobScheduleAction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &j.ActionType)
			delete(rawMsg, key)
		case "jobDefinition":
			j.JobDefinition, err = unmarshalJobBasePropertiesClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type JobService.
func (j JobService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endpoint", j.Endpoint)
	populate(objectMap, "errorMessage", j.ErrorMessage)
	populate(objectMap, "jobServiceType", j.JobServiceType)
	populate(objectMap, "port", j.Port)
	populate(objectMap, "properties", j.Properties)
	populate(objectMap, "status", j.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type JobService.
func (j *JobService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", j, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endpoint":
			err = unpopulate(val, "Endpoint", &j.Endpoint)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &j.ErrorMessage)
			delete(rawMsg, key)
		case "jobServiceType":
			err = unpopulate(val, "JobServiceType", &j.JobServiceType)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &j.Port)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &j.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &j.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", j, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Kubernetes.
func (k Kubernetes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", k.ComputeLocation)
	objectMap["computeType"] = ComputeTypeKubernetes
	populateDateTimeRFC3339(objectMap, "createdOn", k.CreatedOn)
	populate(objectMap, "description", k.Description)
	populate(objectMap, "disableLocalAuth", k.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", k.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", k.ModifiedOn)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "provisioningErrors", k.ProvisioningErrors)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "resourceId", k.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Kubernetes.
func (k *Kubernetes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &k.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &k.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &k.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &k.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &k.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &k.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &k.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &k.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &k.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesOnlineDeployment.
func (k KubernetesOnlineDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsEnabled", k.AppInsightsEnabled)
	populate(objectMap, "codeConfiguration", k.CodeConfiguration)
	populate(objectMap, "containerResourceRequirements", k.ContainerResourceRequirements)
	populate(objectMap, "description", k.Description)
	populate(objectMap, "egressPublicNetworkAccess", k.EgressPublicNetworkAccess)
	objectMap["endpointComputeType"] = EndpointComputeTypeKubernetes
	populate(objectMap, "environmentId", k.EnvironmentID)
	populate(objectMap, "environmentVariables", k.EnvironmentVariables)
	populate(objectMap, "instanceType", k.InstanceType)
	populate(objectMap, "livenessProbe", k.LivenessProbe)
	populate(objectMap, "model", k.Model)
	populate(objectMap, "modelMountPath", k.ModelMountPath)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "readinessProbe", k.ReadinessProbe)
	populate(objectMap, "requestSettings", k.RequestSettings)
	populate(objectMap, "scaleSettings", k.ScaleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesOnlineDeployment.
func (k *KubernetesOnlineDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsEnabled":
			err = unpopulate(val, "AppInsightsEnabled", &k.AppInsightsEnabled)
			delete(rawMsg, key)
		case "codeConfiguration":
			err = unpopulate(val, "CodeConfiguration", &k.CodeConfiguration)
			delete(rawMsg, key)
		case "containerResourceRequirements":
			err = unpopulate(val, "ContainerResourceRequirements", &k.ContainerResourceRequirements)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &k.Description)
			delete(rawMsg, key)
		case "egressPublicNetworkAccess":
			err = unpopulate(val, "EgressPublicNetworkAccess", &k.EgressPublicNetworkAccess)
			delete(rawMsg, key)
		case "endpointComputeType":
			err = unpopulate(val, "EndpointComputeType", &k.EndpointComputeType)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &k.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &k.EnvironmentVariables)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &k.InstanceType)
			delete(rawMsg, key)
		case "livenessProbe":
			err = unpopulate(val, "LivenessProbe", &k.LivenessProbe)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &k.Model)
			delete(rawMsg, key)
		case "modelMountPath":
			err = unpopulate(val, "ModelMountPath", &k.ModelMountPath)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "readinessProbe":
			err = unpopulate(val, "ReadinessProbe", &k.ReadinessProbe)
			delete(rawMsg, key)
		case "requestSettings":
			err = unpopulate(val, "RequestSettings", &k.RequestSettings)
			delete(rawMsg, key)
		case "scaleSettings":
			k.ScaleSettings, err = unmarshalOnlineScaleSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesProperties.
func (k KubernetesProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "defaultInstanceType", k.DefaultInstanceType)
	populate(objectMap, "extensionInstanceReleaseTrain", k.ExtensionInstanceReleaseTrain)
	populate(objectMap, "extensionPrincipalId", k.ExtensionPrincipalID)
	populate(objectMap, "instanceTypes", k.InstanceTypes)
	populate(objectMap, "namespace", k.Namespace)
	populate(objectMap, "relayConnectionString", k.RelayConnectionString)
	populate(objectMap, "serviceBusConnectionString", k.ServiceBusConnectionString)
	populate(objectMap, "vcName", k.VcName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesProperties.
func (k *KubernetesProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "defaultInstanceType":
			err = unpopulate(val, "DefaultInstanceType", &k.DefaultInstanceType)
			delete(rawMsg, key)
		case "extensionInstanceReleaseTrain":
			err = unpopulate(val, "ExtensionInstanceReleaseTrain", &k.ExtensionInstanceReleaseTrain)
			delete(rawMsg, key)
		case "extensionPrincipalId":
			err = unpopulate(val, "ExtensionPrincipalID", &k.ExtensionPrincipalID)
			delete(rawMsg, key)
		case "instanceTypes":
			err = unpopulate(val, "InstanceTypes", &k.InstanceTypes)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &k.Namespace)
			delete(rawMsg, key)
		case "relayConnectionString":
			err = unpopulate(val, "RelayConnectionString", &k.RelayConnectionString)
			delete(rawMsg, key)
		case "serviceBusConnectionString":
			err = unpopulate(val, "ServiceBusConnectionString", &k.ServiceBusConnectionString)
			delete(rawMsg, key)
		case "vcName":
			err = unpopulate(val, "VcName", &k.VcName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesSchema.
func (k KubernetesSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", k.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesSchema.
func (k *KubernetesSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListAmlUserFeatureResult.
func (l ListAmlUserFeatureResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListAmlUserFeatureResult.
func (l *ListAmlUserFeatureResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListNotebookKeysResult.
func (l ListNotebookKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "primaryAccessKey", l.PrimaryAccessKey)
	populate(objectMap, "secondaryAccessKey", l.SecondaryAccessKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListNotebookKeysResult.
func (l *ListNotebookKeysResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "primaryAccessKey":
			err = unpopulate(val, "PrimaryAccessKey", &l.PrimaryAccessKey)
			delete(rawMsg, key)
		case "secondaryAccessKey":
			err = unpopulate(val, "SecondaryAccessKey", &l.SecondaryAccessKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListStorageAccountKeysResult.
func (l ListStorageAccountKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "userStorageKey", l.UserStorageKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListStorageAccountKeysResult.
func (l *ListStorageAccountKeysResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "userStorageKey":
			err = unpopulate(val, "UserStorageKey", &l.UserStorageKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListUsagesResult.
func (l ListUsagesResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListUsagesResult.
func (l *ListUsagesResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListWorkspaceKeysResult.
func (l ListWorkspaceKeysResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsInstrumentationKey", l.AppInsightsInstrumentationKey)
	populate(objectMap, "containerRegistryCredentials", l.ContainerRegistryCredentials)
	populate(objectMap, "notebookAccessKeys", l.NotebookAccessKeys)
	populate(objectMap, "userStorageKey", l.UserStorageKey)
	populate(objectMap, "userStorageResourceId", l.UserStorageResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListWorkspaceKeysResult.
func (l *ListWorkspaceKeysResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsInstrumentationKey":
			err = unpopulate(val, "AppInsightsInstrumentationKey", &l.AppInsightsInstrumentationKey)
			delete(rawMsg, key)
		case "containerRegistryCredentials":
			err = unpopulate(val, "ContainerRegistryCredentials", &l.ContainerRegistryCredentials)
			delete(rawMsg, key)
		case "notebookAccessKeys":
			err = unpopulate(val, "NotebookAccessKeys", &l.NotebookAccessKeys)
			delete(rawMsg, key)
		case "userStorageKey":
			err = unpopulate(val, "UserStorageKey", &l.UserStorageKey)
			delete(rawMsg, key)
		case "userStorageResourceId":
			err = unpopulate(val, "UserStorageResourceID", &l.UserStorageResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListWorkspaceQuotas.
func (l ListWorkspaceQuotas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListWorkspaceQuotas.
func (l *ListWorkspaceQuotas) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LiteralJobInput.
func (l LiteralJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", l.Description)
	objectMap["jobInputType"] = JobInputTypeLiteral
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LiteralJobInput.
func (l *LiteralJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &l.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &l.JobInputType)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MLFlowModelJobInput.
func (m MLFlowModelJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	objectMap["jobInputType"] = JobInputTypeMlflowModel
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "uri", m.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MLFlowModelJobInput.
func (m *MLFlowModelJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &m.JobInputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &m.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MLFlowModelJobOutput.
func (m MLFlowModelJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	objectMap["jobOutputType"] = JobOutputTypeMlflowModel
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "uri", m.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MLFlowModelJobOutput.
func (m *MLFlowModelJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &m.JobOutputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &m.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MLTableData.
func (m MLTableData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataType"] = DataTypeMltable
	populate(objectMap, "dataUri", m.DataURI)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "isAnonymous", m.IsAnonymous)
	populate(objectMap, "isArchived", m.IsArchived)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "referencedUris", m.ReferencedUris)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MLTableData.
func (m *MLTableData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &m.DataType)
			delete(rawMsg, key)
		case "dataUri":
			err = unpopulate(val, "DataURI", &m.DataURI)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &m.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &m.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "referencedUris":
			err = unpopulate(val, "ReferencedUris", &m.ReferencedUris)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MLTableJobInput.
func (m MLTableJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	objectMap["jobInputType"] = JobInputTypeMltable
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "uri", m.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MLTableJobInput.
func (m *MLTableJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &m.JobInputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &m.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MLTableJobOutput.
func (m MLTableJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	objectMap["jobOutputType"] = JobOutputTypeMltable
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "uri", m.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MLTableJobOutput.
func (m *MLTableJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &m.JobOutputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &m.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentity.
func (m ManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	objectMap["identityType"] = IdentityConfigurationTypeManaged
	populate(objectMap, "objectId", m.ObjectID)
	populate(objectMap, "resourceId", m.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentity.
func (m *ManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		case "identityType":
			err = unpopulate(val, "IdentityType", &m.IdentityType)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &m.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentityAuthTypeWorkspaceConnectionProperties.
func (m ManagedIdentityAuthTypeWorkspaceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authType"] = ConnectionAuthTypeManagedIdentity
	populate(objectMap, "category", m.Category)
	populate(objectMap, "credentials", m.Credentials)
	populate(objectMap, "target", m.Target)
	populate(objectMap, "value", m.Value)
	populate(objectMap, "valueFormat", m.ValueFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentityAuthTypeWorkspaceConnectionProperties.
func (m *ManagedIdentityAuthTypeWorkspaceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &m.AuthType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &m.Category)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &m.Credentials)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &m.Target)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		case "valueFormat":
			err = unpopulate(val, "ValueFormat", &m.ValueFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedOnlineDeployment.
func (m ManagedOnlineDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsEnabled", m.AppInsightsEnabled)
	populate(objectMap, "codeConfiguration", m.CodeConfiguration)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "egressPublicNetworkAccess", m.EgressPublicNetworkAccess)
	objectMap["endpointComputeType"] = EndpointComputeTypeManaged
	populate(objectMap, "environmentId", m.EnvironmentID)
	populate(objectMap, "environmentVariables", m.EnvironmentVariables)
	populate(objectMap, "instanceType", m.InstanceType)
	populate(objectMap, "livenessProbe", m.LivenessProbe)
	populate(objectMap, "model", m.Model)
	populate(objectMap, "modelMountPath", m.ModelMountPath)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "readinessProbe", m.ReadinessProbe)
	populate(objectMap, "requestSettings", m.RequestSettings)
	populate(objectMap, "scaleSettings", m.ScaleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedOnlineDeployment.
func (m *ManagedOnlineDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsEnabled":
			err = unpopulate(val, "AppInsightsEnabled", &m.AppInsightsEnabled)
			delete(rawMsg, key)
		case "codeConfiguration":
			err = unpopulate(val, "CodeConfiguration", &m.CodeConfiguration)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "egressPublicNetworkAccess":
			err = unpopulate(val, "EgressPublicNetworkAccess", &m.EgressPublicNetworkAccess)
			delete(rawMsg, key)
		case "endpointComputeType":
			err = unpopulate(val, "EndpointComputeType", &m.EndpointComputeType)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &m.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &m.EnvironmentVariables)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &m.InstanceType)
			delete(rawMsg, key)
		case "livenessProbe":
			err = unpopulate(val, "LivenessProbe", &m.LivenessProbe)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &m.Model)
			delete(rawMsg, key)
		case "modelMountPath":
			err = unpopulate(val, "ModelMountPath", &m.ModelMountPath)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "readinessProbe":
			err = unpopulate(val, "ReadinessProbe", &m.ReadinessProbe)
			delete(rawMsg, key)
		case "requestSettings":
			err = unpopulate(val, "RequestSettings", &m.RequestSettings)
			delete(rawMsg, key)
		case "scaleSettings":
			m.ScaleSettings, err = unmarshalOnlineScaleSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentity.
func (m ManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentity.
func (m *ManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MedianStoppingPolicy.
func (m MedianStoppingPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayEvaluation", m.DelayEvaluation)
	populate(objectMap, "evaluationInterval", m.EvaluationInterval)
	objectMap["policyType"] = EarlyTerminationPolicyTypeMedianStopping
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MedianStoppingPolicy.
func (m *MedianStoppingPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayEvaluation":
			err = unpopulate(val, "DelayEvaluation", &m.DelayEvaluation)
			delete(rawMsg, key)
		case "evaluationInterval":
			err = unpopulate(val, "EvaluationInterval", &m.EvaluationInterval)
			delete(rawMsg, key)
		case "policyType":
			err = unpopulate(val, "PolicyType", &m.PolicyType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModelContainer.
func (m ModelContainer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModelContainer.
func (m *ModelContainer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModelContainerProperties.
func (m ModelContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "isArchived", m.IsArchived)
	populate(objectMap, "latestVersion", m.LatestVersion)
	populate(objectMap, "nextVersion", m.NextVersion)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModelContainerProperties.
func (m *ModelContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &m.IsArchived)
			delete(rawMsg, key)
		case "latestVersion":
			err = unpopulate(val, "LatestVersion", &m.LatestVersion)
			delete(rawMsg, key)
		case "nextVersion":
			err = unpopulate(val, "NextVersion", &m.NextVersion)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModelContainerResourceArmPaginatedResult.
func (m ModelContainerResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModelContainerResourceArmPaginatedResult.
func (m *ModelContainerResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModelVersion.
func (m ModelVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModelVersion.
func (m *ModelVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModelVersionProperties.
func (m ModelVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", m.Description)
	populate(objectMap, "flavors", m.Flavors)
	populate(objectMap, "isAnonymous", m.IsAnonymous)
	populate(objectMap, "isArchived", m.IsArchived)
	populate(objectMap, "jobName", m.JobName)
	populate(objectMap, "modelType", m.ModelType)
	populate(objectMap, "modelUri", m.ModelURI)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "tags", m.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModelVersionProperties.
func (m *ModelVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "flavors":
			err = unpopulate(val, "Flavors", &m.Flavors)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &m.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &m.IsArchived)
			delete(rawMsg, key)
		case "jobName":
			err = unpopulate(val, "JobName", &m.JobName)
			delete(rawMsg, key)
		case "modelType":
			err = unpopulate(val, "ModelType", &m.ModelType)
			delete(rawMsg, key)
		case "modelUri":
			err = unpopulate(val, "ModelURI", &m.ModelURI)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ModelVersionResourceArmPaginatedResult.
func (m ModelVersionResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ModelVersionResourceArmPaginatedResult.
func (m *ModelVersionResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Mpi.
func (m Mpi) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["distributionType"] = DistributionTypeMpi
	populate(objectMap, "processCountPerInstance", m.ProcessCountPerInstance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Mpi.
func (m *Mpi) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributionType":
			err = unpopulate(val, "DistributionType", &m.DistributionType)
			delete(rawMsg, key)
		case "processCountPerInstance":
			err = unpopulate(val, "ProcessCountPerInstance", &m.ProcessCountPerInstance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NCrossValidations.
func (n NCrossValidations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = n.Mode
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NCrossValidations.
func (n *NCrossValidations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &n.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NlpVertical.
func (n NlpVertical) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featurizationSettings", n.FeaturizationSettings)
	populate(objectMap, "limitSettings", n.LimitSettings)
	populate(objectMap, "validationData", n.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NlpVertical.
func (n *NlpVertical) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &n.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &n.LimitSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &n.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NlpVerticalFeaturizationSettings.
func (n NlpVerticalFeaturizationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "datasetLanguage", n.DatasetLanguage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NlpVerticalFeaturizationSettings.
func (n *NlpVerticalFeaturizationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "datasetLanguage":
			err = unpopulate(val, "DatasetLanguage", &n.DatasetLanguage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NlpVerticalLimitSettings.
func (n NlpVerticalLimitSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxConcurrentTrials", n.MaxConcurrentTrials)
	populate(objectMap, "maxTrials", n.MaxTrials)
	populate(objectMap, "timeout", n.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NlpVerticalLimitSettings.
func (n *NlpVerticalLimitSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxConcurrentTrials":
			err = unpopulate(val, "MaxConcurrentTrials", &n.MaxConcurrentTrials)
			delete(rawMsg, key)
		case "maxTrials":
			err = unpopulate(val, "MaxTrials", &n.MaxTrials)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &n.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NodeStateCounts.
func (n NodeStateCounts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "idleNodeCount", n.IdleNodeCount)
	populate(objectMap, "leavingNodeCount", n.LeavingNodeCount)
	populate(objectMap, "preemptedNodeCount", n.PreemptedNodeCount)
	populate(objectMap, "preparingNodeCount", n.PreparingNodeCount)
	populate(objectMap, "runningNodeCount", n.RunningNodeCount)
	populate(objectMap, "unusableNodeCount", n.UnusableNodeCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NodeStateCounts.
func (n *NodeStateCounts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "idleNodeCount":
			err = unpopulate(val, "IdleNodeCount", &n.IdleNodeCount)
			delete(rawMsg, key)
		case "leavingNodeCount":
			err = unpopulate(val, "LeavingNodeCount", &n.LeavingNodeCount)
			delete(rawMsg, key)
		case "preemptedNodeCount":
			err = unpopulate(val, "PreemptedNodeCount", &n.PreemptedNodeCount)
			delete(rawMsg, key)
		case "preparingNodeCount":
			err = unpopulate(val, "PreparingNodeCount", &n.PreparingNodeCount)
			delete(rawMsg, key)
		case "runningNodeCount":
			err = unpopulate(val, "RunningNodeCount", &n.RunningNodeCount)
			delete(rawMsg, key)
		case "unusableNodeCount":
			err = unpopulate(val, "UnusableNodeCount", &n.UnusableNodeCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NoneAuthTypeWorkspaceConnectionProperties.
func (n NoneAuthTypeWorkspaceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authType"] = ConnectionAuthTypeNone
	populate(objectMap, "category", n.Category)
	populate(objectMap, "target", n.Target)
	populate(objectMap, "value", n.Value)
	populate(objectMap, "valueFormat", n.ValueFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NoneAuthTypeWorkspaceConnectionProperties.
func (n *NoneAuthTypeWorkspaceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &n.AuthType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &n.Category)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &n.Target)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &n.Value)
			delete(rawMsg, key)
		case "valueFormat":
			err = unpopulate(val, "ValueFormat", &n.ValueFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NoneDatastoreCredentials.
func (n NoneDatastoreCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["credentialsType"] = CredentialsTypeNone
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NoneDatastoreCredentials.
func (n *NoneDatastoreCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentialsType":
			err = unpopulate(val, "CredentialsType", &n.CredentialsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotebookAccessTokenResult.
func (n NotebookAccessTokenResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessToken", n.AccessToken)
	populate(objectMap, "expiresIn", n.ExpiresIn)
	populate(objectMap, "hostName", n.HostName)
	populate(objectMap, "notebookResourceId", n.NotebookResourceID)
	populate(objectMap, "publicDns", n.PublicDNS)
	populate(objectMap, "refreshToken", n.RefreshToken)
	populate(objectMap, "scope", n.Scope)
	populate(objectMap, "tokenType", n.TokenType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotebookAccessTokenResult.
func (n *NotebookAccessTokenResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessToken":
			err = unpopulate(val, "AccessToken", &n.AccessToken)
			delete(rawMsg, key)
		case "expiresIn":
			err = unpopulate(val, "ExpiresIn", &n.ExpiresIn)
			delete(rawMsg, key)
		case "hostName":
			err = unpopulate(val, "HostName", &n.HostName)
			delete(rawMsg, key)
		case "notebookResourceId":
			err = unpopulate(val, "NotebookResourceID", &n.NotebookResourceID)
			delete(rawMsg, key)
		case "publicDns":
			err = unpopulate(val, "PublicDNS", &n.PublicDNS)
			delete(rawMsg, key)
		case "refreshToken":
			err = unpopulate(val, "RefreshToken", &n.RefreshToken)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &n.Scope)
			delete(rawMsg, key)
		case "tokenType":
			err = unpopulate(val, "TokenType", &n.TokenType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotebookPreparationError.
func (n NotebookPreparationError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", n.ErrorMessage)
	populate(objectMap, "statusCode", n.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotebookPreparationError.
func (n *NotebookPreparationError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &n.ErrorMessage)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &n.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotebookResourceInfo.
func (n NotebookResourceInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fqdn", n.Fqdn)
	populate(objectMap, "notebookPreparationError", n.NotebookPreparationError)
	populate(objectMap, "resourceId", n.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotebookResourceInfo.
func (n *NotebookResourceInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fqdn":
			err = unpopulate(val, "Fqdn", &n.Fqdn)
			delete(rawMsg, key)
		case "notebookPreparationError":
			err = unpopulate(val, "NotebookPreparationError", &n.NotebookPreparationError)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &n.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Objective.
func (o Objective) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "goal", o.Goal)
	populate(objectMap, "primaryMetric", o.PrimaryMetric)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Objective.
func (o *Objective) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "goal":
			err = unpopulate(val, "Goal", &o.Goal)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &o.PrimaryMetric)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineDeployment.
func (o OnlineDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "identity", o.Identity)
	populate(objectMap, "kind", o.Kind)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "sku", o.SKU)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "tags", o.Tags)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineDeployment.
func (o *OnlineDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &o.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &o.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			o.Properties, err = unmarshalOnlineDeploymentPropertiesClassification(val)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &o.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &o.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineDeploymentProperties.
func (o OnlineDeploymentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appInsightsEnabled", o.AppInsightsEnabled)
	populate(objectMap, "codeConfiguration", o.CodeConfiguration)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "egressPublicNetworkAccess", o.EgressPublicNetworkAccess)
	objectMap["endpointComputeType"] = o.EndpointComputeType
	populate(objectMap, "environmentId", o.EnvironmentID)
	populate(objectMap, "environmentVariables", o.EnvironmentVariables)
	populate(objectMap, "instanceType", o.InstanceType)
	populate(objectMap, "livenessProbe", o.LivenessProbe)
	populate(objectMap, "model", o.Model)
	populate(objectMap, "modelMountPath", o.ModelMountPath)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	populate(objectMap, "readinessProbe", o.ReadinessProbe)
	populate(objectMap, "requestSettings", o.RequestSettings)
	populate(objectMap, "scaleSettings", o.ScaleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineDeploymentProperties.
func (o *OnlineDeploymentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appInsightsEnabled":
			err = unpopulate(val, "AppInsightsEnabled", &o.AppInsightsEnabled)
			delete(rawMsg, key)
		case "codeConfiguration":
			err = unpopulate(val, "CodeConfiguration", &o.CodeConfiguration)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "egressPublicNetworkAccess":
			err = unpopulate(val, "EgressPublicNetworkAccess", &o.EgressPublicNetworkAccess)
			delete(rawMsg, key)
		case "endpointComputeType":
			err = unpopulate(val, "EndpointComputeType", &o.EndpointComputeType)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &o.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &o.EnvironmentVariables)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &o.InstanceType)
			delete(rawMsg, key)
		case "livenessProbe":
			err = unpopulate(val, "LivenessProbe", &o.LivenessProbe)
			delete(rawMsg, key)
		case "model":
			err = unpopulate(val, "Model", &o.Model)
			delete(rawMsg, key)
		case "modelMountPath":
			err = unpopulate(val, "ModelMountPath", &o.ModelMountPath)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		case "readinessProbe":
			err = unpopulate(val, "ReadinessProbe", &o.ReadinessProbe)
			delete(rawMsg, key)
		case "requestSettings":
			err = unpopulate(val, "RequestSettings", &o.RequestSettings)
			delete(rawMsg, key)
		case "scaleSettings":
			o.ScaleSettings, err = unmarshalOnlineScaleSettingsClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineDeploymentTrackedResourceArmPaginatedResult.
func (o OnlineDeploymentTrackedResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineDeploymentTrackedResourceArmPaginatedResult.
func (o *OnlineDeploymentTrackedResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineEndpoint.
func (o OnlineEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "identity", o.Identity)
	populate(objectMap, "kind", o.Kind)
	populate(objectMap, "location", o.Location)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "sku", o.SKU)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "tags", o.Tags)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineEndpoint.
func (o *OnlineEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &o.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &o.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &o.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &o.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &o.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineEndpointProperties.
func (o OnlineEndpointProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authMode", o.AuthMode)
	populate(objectMap, "compute", o.Compute)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "keys", o.Keys)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "provisioningState", o.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", o.PublicNetworkAccess)
	populate(objectMap, "scoringUri", o.ScoringURI)
	populate(objectMap, "swaggerUri", o.SwaggerURI)
	populate(objectMap, "traffic", o.Traffic)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineEndpointProperties.
func (o *OnlineEndpointProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authMode":
			err = unpopulate(val, "AuthMode", &o.AuthMode)
			delete(rawMsg, key)
		case "compute":
			err = unpopulate(val, "Compute", &o.Compute)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "keys":
			err = unpopulate(val, "Keys", &o.Keys)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &o.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &o.PublicNetworkAccess)
			delete(rawMsg, key)
		case "scoringUri":
			err = unpopulate(val, "ScoringURI", &o.ScoringURI)
			delete(rawMsg, key)
		case "swaggerUri":
			err = unpopulate(val, "SwaggerURI", &o.SwaggerURI)
			delete(rawMsg, key)
		case "traffic":
			err = unpopulate(val, "Traffic", &o.Traffic)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineEndpointTrackedResourceArmPaginatedResult.
func (o OnlineEndpointTrackedResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineEndpointTrackedResourceArmPaginatedResult.
func (o *OnlineEndpointTrackedResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineRequestSettings.
func (o OnlineRequestSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxConcurrentRequestsPerInstance", o.MaxConcurrentRequestsPerInstance)
	populate(objectMap, "maxQueueWait", o.MaxQueueWait)
	populate(objectMap, "requestTimeout", o.RequestTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineRequestSettings.
func (o *OnlineRequestSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxConcurrentRequestsPerInstance":
			err = unpopulate(val, "MaxConcurrentRequestsPerInstance", &o.MaxConcurrentRequestsPerInstance)
			delete(rawMsg, key)
		case "maxQueueWait":
			err = unpopulate(val, "MaxQueueWait", &o.MaxQueueWait)
			delete(rawMsg, key)
		case "requestTimeout":
			err = unpopulate(val, "RequestTimeout", &o.RequestTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OnlineScaleSettings.
func (o OnlineScaleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["scaleType"] = o.ScaleType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OnlineScaleSettings.
func (o *OnlineScaleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scaleType":
			err = unpopulate(val, "ScaleType", &o.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutputPathAssetReference.
func (o OutputPathAssetReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "jobId", o.JobID)
	populate(objectMap, "path", o.Path)
	objectMap["referenceType"] = ReferenceTypeOutputPath
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutputPathAssetReference.
func (o *OutputPathAssetReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobId":
			err = unpopulate(val, "JobID", &o.JobID)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &o.Path)
			delete(rawMsg, key)
		case "referenceType":
			err = unpopulate(val, "ReferenceType", &o.ReferenceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PATAuthTypeWorkspaceConnectionProperties.
func (p PATAuthTypeWorkspaceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authType"] = ConnectionAuthTypePAT
	populate(objectMap, "category", p.Category)
	populate(objectMap, "credentials", p.Credentials)
	populate(objectMap, "target", p.Target)
	populate(objectMap, "value", p.Value)
	populate(objectMap, "valueFormat", p.ValueFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PATAuthTypeWorkspaceConnectionProperties.
func (p *PATAuthTypeWorkspaceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &p.AuthType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &p.Category)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &p.Credentials)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &p.Target)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		case "valueFormat":
			err = unpopulate(val, "ValueFormat", &p.ValueFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PaginatedComputeResourcesList.
func (p PaginatedComputeResourcesList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PaginatedComputeResourcesList.
func (p *PaginatedComputeResourcesList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialBatchDeployment.
func (p PartialBatchDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialBatchDeployment.
func (p *PartialBatchDeployment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties.
func (p PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties.
func (p *PartialBatchDeploymentPartialMinimalTrackedResourceWithProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialManagedServiceIdentity.
func (p PartialManagedServiceIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "type", p.Type)
	populate(objectMap, "userAssignedIdentities", p.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialManagedServiceIdentity.
func (p *PartialManagedServiceIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &p.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialMinimalTrackedResource.
func (p PartialMinimalTrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialMinimalTrackedResource.
func (p *PartialMinimalTrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialMinimalTrackedResourceWithIdentity.
func (p PartialMinimalTrackedResourceWithIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialMinimalTrackedResourceWithIdentity.
func (p *PartialMinimalTrackedResourceWithIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialMinimalTrackedResourceWithSKU.
func (p PartialMinimalTrackedResourceWithSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialMinimalTrackedResourceWithSKU.
func (p *PartialMinimalTrackedResourceWithSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PartialSKU.
func (p PartialSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", p.Capacity)
	populate(objectMap, "family", p.Family)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "size", p.Size)
	populate(objectMap, "tier", p.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PartialSKU.
func (p *PartialSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &p.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &p.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &p.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &p.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Password.
func (p Password) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Password.
func (p *Password) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PersonalComputeInstanceSettings.
func (p PersonalComputeInstanceSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "assignedUser", p.AssignedUser)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PersonalComputeInstanceSettings.
func (p *PersonalComputeInstanceSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assignedUser":
			err = unpopulate(val, "AssignedUser", &p.AssignedUser)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PipelineJob.
func (p PipelineJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", p.ComponentID)
	populate(objectMap, "computeId", p.ComputeID)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "experimentName", p.ExperimentName)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "inputs", p.Inputs)
	populate(objectMap, "isArchived", p.IsArchived)
	objectMap["jobType"] = JobTypePipeline
	populate(objectMap, "jobs", p.Jobs)
	populate(objectMap, "outputs", p.Outputs)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "services", p.Services)
	populateAny(objectMap, "settings", p.Settings)
	populate(objectMap, "sourceJobId", p.SourceJobID)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "tags", p.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PipelineJob.
func (p *PipelineJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &p.ComponentID)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &p.ComputeID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &p.ExperimentName)
			delete(rawMsg, key)
		case "identity":
			p.Identity, err = unmarshalIdentityConfigurationClassification(val)
			delete(rawMsg, key)
		case "inputs":
			p.Inputs, err = unmarshalJobInputClassificationMap(val)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &p.IsArchived)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &p.JobType)
			delete(rawMsg, key)
		case "jobs":
			err = unpopulate(val, "Jobs", &p.Jobs)
			delete(rawMsg, key)
		case "outputs":
			p.Outputs, err = unmarshalJobOutputClassificationMap(val)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &p.Services)
			delete(rawMsg, key)
		case "settings":
			err = unpopulate(val, "Settings", &p.Settings)
			delete(rawMsg, key)
		case "sourceJobId":
			err = unpopulate(val, "SourceJobID", &p.SourceJobID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "subnetArmId", p.SubnetArmID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "subnetArmId":
			err = unpopulate(val, "SubnetArmID", &p.SubnetArmID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "identity", p.Identity)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "tags", p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &p.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &p.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceListResult.
func (p PrivateLinkResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceListResult.
func (p *PrivateLinkResourceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourceProperties.
func (p PrivateLinkResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "requiredZoneNames", p.RequiredZoneNames)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourceProperties.
func (p *PrivateLinkResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "requiredZoneNames":
			err = unpopulate(val, "RequiredZoneNames", &p.RequiredZoneNames)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionsRequired", p.ActionsRequired)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionsRequired":
			err = unpopulate(val, "ActionsRequired", &p.ActionsRequired)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProbeSettings.
func (p ProbeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failureThreshold", p.FailureThreshold)
	populate(objectMap, "initialDelay", p.InitialDelay)
	populate(objectMap, "period", p.Period)
	populate(objectMap, "successThreshold", p.SuccessThreshold)
	populate(objectMap, "timeout", p.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProbeSettings.
func (p *ProbeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failureThreshold":
			err = unpopulate(val, "FailureThreshold", &p.FailureThreshold)
			delete(rawMsg, key)
		case "initialDelay":
			err = unpopulate(val, "InitialDelay", &p.InitialDelay)
			delete(rawMsg, key)
		case "period":
			err = unpopulate(val, "Period", &p.Period)
			delete(rawMsg, key)
		case "successThreshold":
			err = unpopulate(val, "SuccessThreshold", &p.SuccessThreshold)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &p.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PyTorch.
func (p PyTorch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["distributionType"] = DistributionTypePyTorch
	populate(objectMap, "processCountPerInstance", p.ProcessCountPerInstance)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PyTorch.
func (p *PyTorch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributionType":
			err = unpopulate(val, "DistributionType", &p.DistributionType)
			delete(rawMsg, key)
		case "processCountPerInstance":
			err = unpopulate(val, "ProcessCountPerInstance", &p.ProcessCountPerInstance)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaBaseProperties.
func (q QuotaBaseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "limit", q.Limit)
	populate(objectMap, "type", q.Type)
	populate(objectMap, "unit", q.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaBaseProperties.
func (q *QuotaBaseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &q.Limit)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &q.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaUpdateParameters.
func (q QuotaUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", q.Location)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaUpdateParameters.
func (q *QuotaUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &q.Location)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RandomSamplingAlgorithm.
func (r RandomSamplingAlgorithm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "rule", r.Rule)
	objectMap["samplingAlgorithmType"] = SamplingAlgorithmTypeRandom
	populate(objectMap, "seed", r.Seed)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RandomSamplingAlgorithm.
func (r *RandomSamplingAlgorithm) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "rule":
			err = unpopulate(val, "Rule", &r.Rule)
			delete(rawMsg, key)
		case "samplingAlgorithmType":
			err = unpopulate(val, "SamplingAlgorithmType", &r.SamplingAlgorithmType)
			delete(rawMsg, key)
		case "seed":
			err = unpopulate(val, "Seed", &r.Seed)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceSchedule.
func (r RecurrenceSchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hours", r.Hours)
	populate(objectMap, "minutes", r.Minutes)
	populate(objectMap, "monthDays", r.MonthDays)
	populate(objectMap, "weekDays", r.WeekDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurrenceSchedule.
func (r *RecurrenceSchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hours":
			err = unpopulate(val, "Hours", &r.Hours)
			delete(rawMsg, key)
		case "minutes":
			err = unpopulate(val, "Minutes", &r.Minutes)
			delete(rawMsg, key)
		case "monthDays":
			err = unpopulate(val, "MonthDays", &r.MonthDays)
			delete(rawMsg, key)
		case "weekDays":
			err = unpopulate(val, "WeekDays", &r.WeekDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecurrenceTrigger.
func (r RecurrenceTrigger) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", r.EndTime)
	populate(objectMap, "frequency", r.Frequency)
	populate(objectMap, "interval", r.Interval)
	populate(objectMap, "schedule", r.Schedule)
	populate(objectMap, "startTime", r.StartTime)
	populate(objectMap, "timeZone", r.TimeZone)
	objectMap["triggerType"] = TriggerTypeRecurrence
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecurrenceTrigger.
func (r *RecurrenceTrigger) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &r.EndTime)
			delete(rawMsg, key)
		case "frequency":
			err = unpopulate(val, "Frequency", &r.Frequency)
			delete(rawMsg, key)
		case "interval":
			err = unpopulate(val, "Interval", &r.Interval)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &r.Schedule)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &r.StartTime)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &r.TimeZone)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &r.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegenerateEndpointKeysRequest.
func (r RegenerateEndpointKeysRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyType", r.KeyType)
	populate(objectMap, "keyValue", r.KeyValue)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegenerateEndpointKeysRequest.
func (r *RegenerateEndpointKeysRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyType":
			err = unpopulate(val, "KeyType", &r.KeyType)
			delete(rawMsg, key)
		case "keyValue":
			err = unpopulate(val, "KeyValue", &r.KeyValue)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegistryListCredentialsResult.
func (r RegistryListCredentialsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "passwords", r.Passwords)
	populate(objectMap, "username", r.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegistryListCredentialsResult.
func (r *RegistryListCredentialsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "passwords":
			err = unpopulate(val, "Passwords", &r.Passwords)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &r.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Regression.
func (r Regression) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cvSplitColumnNames", r.CvSplitColumnNames)
	populate(objectMap, "featurizationSettings", r.FeaturizationSettings)
	populate(objectMap, "limitSettings", r.LimitSettings)
	populate(objectMap, "logVerbosity", r.LogVerbosity)
	populate(objectMap, "nCrossValidations", r.NCrossValidations)
	populate(objectMap, "primaryMetric", r.PrimaryMetric)
	populate(objectMap, "targetColumnName", r.TargetColumnName)
	objectMap["taskType"] = TaskTypeRegression
	populate(objectMap, "testData", r.TestData)
	populate(objectMap, "testDataSize", r.TestDataSize)
	populate(objectMap, "trainingData", r.TrainingData)
	populate(objectMap, "trainingSettings", r.TrainingSettings)
	populate(objectMap, "validationData", r.ValidationData)
	populate(objectMap, "validationDataSize", r.ValidationDataSize)
	populate(objectMap, "weightColumnName", r.WeightColumnName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Regression.
func (r *Regression) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cvSplitColumnNames":
			err = unpopulate(val, "CvSplitColumnNames", &r.CvSplitColumnNames)
			delete(rawMsg, key)
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &r.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &r.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &r.LogVerbosity)
			delete(rawMsg, key)
		case "nCrossValidations":
			r.NCrossValidations, err = unmarshalNCrossValidationsClassification(val)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &r.PrimaryMetric)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &r.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &r.TaskType)
			delete(rawMsg, key)
		case "testData":
			err = unpopulate(val, "TestData", &r.TestData)
			delete(rawMsg, key)
		case "testDataSize":
			err = unpopulate(val, "TestDataSize", &r.TestDataSize)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &r.TrainingData)
			delete(rawMsg, key)
		case "trainingSettings":
			err = unpopulate(val, "TrainingSettings", &r.TrainingSettings)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &r.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &r.ValidationDataSize)
			delete(rawMsg, key)
		case "weightColumnName":
			err = unpopulate(val, "WeightColumnName", &r.WeightColumnName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RegressionTrainingSettings.
func (r RegressionTrainingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedTrainingAlgorithms", r.AllowedTrainingAlgorithms)
	populate(objectMap, "blockedTrainingAlgorithms", r.BlockedTrainingAlgorithms)
	populate(objectMap, "enableDnnTraining", r.EnableDnnTraining)
	populate(objectMap, "enableModelExplainability", r.EnableModelExplainability)
	populate(objectMap, "enableOnnxCompatibleModels", r.EnableOnnxCompatibleModels)
	populate(objectMap, "enableStackEnsemble", r.EnableStackEnsemble)
	populate(objectMap, "enableVoteEnsemble", r.EnableVoteEnsemble)
	populate(objectMap, "ensembleModelDownloadTimeout", r.EnsembleModelDownloadTimeout)
	populate(objectMap, "stackEnsembleSettings", r.StackEnsembleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RegressionTrainingSettings.
func (r *RegressionTrainingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedTrainingAlgorithms":
			err = unpopulate(val, "AllowedTrainingAlgorithms", &r.AllowedTrainingAlgorithms)
			delete(rawMsg, key)
		case "blockedTrainingAlgorithms":
			err = unpopulate(val, "BlockedTrainingAlgorithms", &r.BlockedTrainingAlgorithms)
			delete(rawMsg, key)
		case "enableDnnTraining":
			err = unpopulate(val, "EnableDnnTraining", &r.EnableDnnTraining)
			delete(rawMsg, key)
		case "enableModelExplainability":
			err = unpopulate(val, "EnableModelExplainability", &r.EnableModelExplainability)
			delete(rawMsg, key)
		case "enableOnnxCompatibleModels":
			err = unpopulate(val, "EnableOnnxCompatibleModels", &r.EnableOnnxCompatibleModels)
			delete(rawMsg, key)
		case "enableStackEnsemble":
			err = unpopulate(val, "EnableStackEnsemble", &r.EnableStackEnsemble)
			delete(rawMsg, key)
		case "enableVoteEnsemble":
			err = unpopulate(val, "EnableVoteEnsemble", &r.EnableVoteEnsemble)
			delete(rawMsg, key)
		case "ensembleModelDownloadTimeout":
			err = unpopulate(val, "EnsembleModelDownloadTimeout", &r.EnsembleModelDownloadTimeout)
			delete(rawMsg, key)
		case "stackEnsembleSettings":
			err = unpopulate(val, "StackEnsembleSettings", &r.StackEnsembleSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceBase.
func (r ResourceBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceBase.
func (r *ResourceBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &r.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceConfiguration.
func (r ResourceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceCount", r.InstanceCount)
	populate(objectMap, "instanceType", r.InstanceType)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceConfiguration.
func (r *ResourceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceCount":
			err = unpopulate(val, "InstanceCount", &r.InstanceCount)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceID.
func (r ResourceID) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceID.
func (r *ResourceID) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceName.
func (r ResourceName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", r.LocalizedValue)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceName.
func (r *ResourceName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &r.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceQuota.
func (r ResourceQuota) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amlWorkspaceLocation", r.AmlWorkspaceLocation)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "limit", r.Limit)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	populate(objectMap, "unit", r.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceQuota.
func (r *ResourceQuota) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amlWorkspaceLocation":
			err = unpopulate(val, "AmlWorkspaceLocation", &r.AmlWorkspaceLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &r.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &r.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Route.
func (r Route) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "path", r.Path)
	populate(objectMap, "port", r.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Route.
func (r *Route) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "path":
			err = unpopulate(val, "Path", &r.Path)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &r.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SASAuthTypeWorkspaceConnectionProperties.
func (s SASAuthTypeWorkspaceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authType"] = ConnectionAuthTypeSAS
	populate(objectMap, "category", s.Category)
	populate(objectMap, "credentials", s.Credentials)
	populate(objectMap, "target", s.Target)
	populate(objectMap, "value", s.Value)
	populate(objectMap, "valueFormat", s.ValueFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SASAuthTypeWorkspaceConnectionProperties.
func (s *SASAuthTypeWorkspaceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &s.AuthType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &s.Category)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &s.Credentials)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &s.Target)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		case "valueFormat":
			err = unpopulate(val, "ValueFormat", &s.ValueFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKU.
func (s SKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "family", s.Family)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "size", s.Size)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKU.
func (s *SKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &s.Family)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &s.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapacity.
func (s SKUCapacity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", s.Default)
	populate(objectMap, "maximum", s.Maximum)
	populate(objectMap, "minimum", s.Minimum)
	populate(objectMap, "scaleType", s.ScaleType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapacity.
func (s *SKUCapacity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &s.Default)
			delete(rawMsg, key)
		case "maximum":
			err = unpopulate(val, "Maximum", &s.Maximum)
			delete(rawMsg, key)
		case "minimum":
			err = unpopulate(val, "Minimum", &s.Minimum)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &s.ScaleType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUResource.
func (s SKUResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacity", s.Capacity)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "sku", s.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUResource.
func (s *SKUResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacity":
			err = unpopulate(val, "Capacity", &s.Capacity)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUResourceArmPaginatedResult.
func (s SKUResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUResourceArmPaginatedResult.
func (s *SKUResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUSetting.
func (s SKUSetting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "tier", s.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUSetting.
func (s *SKUSetting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &s.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSLConfiguration.
func (s SSLConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cert", s.Cert)
	populate(objectMap, "cname", s.Cname)
	populate(objectMap, "key", s.Key)
	populate(objectMap, "leafDomainLabel", s.LeafDomainLabel)
	populate(objectMap, "overwriteExistingDomain", s.OverwriteExistingDomain)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSLConfiguration.
func (s *SSLConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cert":
			err = unpopulate(val, "Cert", &s.Cert)
			delete(rawMsg, key)
		case "cname":
			err = unpopulate(val, "Cname", &s.Cname)
			delete(rawMsg, key)
		case "key":
			err = unpopulate(val, "Key", &s.Key)
			delete(rawMsg, key)
		case "leafDomainLabel":
			err = unpopulate(val, "LeafDomainLabel", &s.LeafDomainLabel)
			delete(rawMsg, key)
		case "overwriteExistingDomain":
			err = unpopulate(val, "OverwriteExistingDomain", &s.OverwriteExistingDomain)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SamplingAlgorithm.
func (s SamplingAlgorithm) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["samplingAlgorithmType"] = s.SamplingAlgorithmType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SamplingAlgorithm.
func (s *SamplingAlgorithm) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "samplingAlgorithmType":
			err = unpopulate(val, "SamplingAlgorithmType", &s.SamplingAlgorithmType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SasDatastoreCredentials.
func (s SasDatastoreCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["credentialsType"] = CredentialsTypeSas
	populate(objectMap, "secrets", s.Secrets)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SasDatastoreCredentials.
func (s *SasDatastoreCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "credentialsType":
			err = unpopulate(val, "CredentialsType", &s.CredentialsType)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &s.Secrets)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SasDatastoreSecrets.
func (s SasDatastoreSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sasToken", s.SasToken)
	objectMap["secretsType"] = SecretsTypeSas
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SasDatastoreSecrets.
func (s *SasDatastoreSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sasToken":
			err = unpopulate(val, "SasToken", &s.SasToken)
			delete(rawMsg, key)
		case "secretsType":
			err = unpopulate(val, "SecretsType", &s.SecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleSettings.
func (s ScaleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxNodeCount", s.MaxNodeCount)
	populate(objectMap, "minNodeCount", s.MinNodeCount)
	populate(objectMap, "nodeIdleTimeBeforeScaleDown", s.NodeIdleTimeBeforeScaleDown)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleSettings.
func (s *ScaleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxNodeCount":
			err = unpopulate(val, "MaxNodeCount", &s.MaxNodeCount)
			delete(rawMsg, key)
		case "minNodeCount":
			err = unpopulate(val, "MinNodeCount", &s.MinNodeCount)
			delete(rawMsg, key)
		case "nodeIdleTimeBeforeScaleDown":
			err = unpopulate(val, "NodeIdleTimeBeforeScaleDown", &s.NodeIdleTimeBeforeScaleDown)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScaleSettingsInformation.
func (s ScaleSettingsInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scaleSettings", s.ScaleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScaleSettingsInformation.
func (s *ScaleSettingsInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scaleSettings":
			err = unpopulate(val, "ScaleSettings", &s.ScaleSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Schedule.
func (s *Schedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleActionBase.
func (s ScheduleActionBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["actionType"] = s.ActionType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleActionBase.
func (s *ScheduleActionBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &s.ActionType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleBase.
func (s ScheduleBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "provisioningStatus", s.ProvisioningStatus)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleBase.
func (s *ScheduleBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "provisioningStatus":
			err = unpopulate(val, "ProvisioningStatus", &s.ProvisioningStatus)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleProperties.
func (s ScheduleProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", s.Action)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "isEnabled", s.IsEnabled)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "trigger", s.Trigger)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleProperties.
func (s *ScheduleProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			s.Action, err = unmarshalScheduleActionBaseClassification(val)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "isEnabled":
			err = unpopulate(val, "IsEnabled", &s.IsEnabled)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "trigger":
			s.Trigger, err = unmarshalTriggerBaseClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScheduleResourceArmPaginatedResult.
func (s ScheduleResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScheduleResourceArmPaginatedResult.
func (s *ScheduleResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptReference.
func (s ScriptReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scriptArguments", s.ScriptArguments)
	populate(objectMap, "scriptData", s.ScriptData)
	populate(objectMap, "scriptSource", s.ScriptSource)
	populate(objectMap, "timeout", s.Timeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptReference.
func (s *ScriptReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scriptArguments":
			err = unpopulate(val, "ScriptArguments", &s.ScriptArguments)
			delete(rawMsg, key)
		case "scriptData":
			err = unpopulate(val, "ScriptData", &s.ScriptData)
			delete(rawMsg, key)
		case "scriptSource":
			err = unpopulate(val, "ScriptSource", &s.ScriptSource)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &s.Timeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScriptsToExecute.
func (s ScriptsToExecute) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationScript", s.CreationScript)
	populate(objectMap, "startupScript", s.StartupScript)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScriptsToExecute.
func (s *ScriptsToExecute) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationScript":
			err = unpopulate(val, "CreationScript", &s.CreationScript)
			delete(rawMsg, key)
		case "startupScript":
			err = unpopulate(val, "StartupScript", &s.StartupScript)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Seasonality.
func (s Seasonality) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = s.Mode
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Seasonality.
func (s *Seasonality) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &s.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceManagedResourcesSettings.
func (s ServiceManagedResourcesSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cosmosDb", s.CosmosDb)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceManagedResourcesSettings.
func (s *ServiceManagedResourcesSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cosmosDb":
			err = unpopulate(val, "CosmosDb", &s.CosmosDb)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalDatastoreCredentials.
func (s ServicePrincipalDatastoreCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorityUrl", s.AuthorityURL)
	populate(objectMap, "clientId", s.ClientID)
	objectMap["credentialsType"] = CredentialsTypeServicePrincipal
	populate(objectMap, "resourceUrl", s.ResourceURL)
	populate(objectMap, "secrets", s.Secrets)
	populate(objectMap, "tenantId", s.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalDatastoreCredentials.
func (s *ServicePrincipalDatastoreCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorityUrl":
			err = unpopulate(val, "AuthorityURL", &s.AuthorityURL)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "credentialsType":
			err = unpopulate(val, "CredentialsType", &s.CredentialsType)
			delete(rawMsg, key)
		case "resourceUrl":
			err = unpopulate(val, "ResourceURL", &s.ResourceURL)
			delete(rawMsg, key)
		case "secrets":
			err = unpopulate(val, "Secrets", &s.Secrets)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalDatastoreSecrets.
func (s ServicePrincipalDatastoreSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientSecret", s.ClientSecret)
	objectMap["secretsType"] = SecretsTypeServicePrincipal
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalDatastoreSecrets.
func (s *ServicePrincipalDatastoreSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &s.ClientSecret)
			delete(rawMsg, key)
		case "secretsType":
			err = unpopulate(val, "SecretsType", &s.SecretsType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SetupScripts.
func (s SetupScripts) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scripts", s.Scripts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SetupScripts.
func (s *SetupScripts) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scripts":
			err = unpopulate(val, "Scripts", &s.Scripts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedPrivateLinkResource.
func (s SharedPrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedPrivateLinkResource.
func (s *SharedPrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SharedPrivateLinkResourceProperty.
func (s SharedPrivateLinkResourceProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", s.GroupID)
	populate(objectMap, "privateLinkResourceId", s.PrivateLinkResourceID)
	populate(objectMap, "requestMessage", s.RequestMessage)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SharedPrivateLinkResourceProperty.
func (s *SharedPrivateLinkResourceProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &s.GroupID)
			delete(rawMsg, key)
		case "privateLinkResourceId":
			err = unpopulate(val, "PrivateLinkResourceID", &s.PrivateLinkResourceID)
			delete(rawMsg, key)
		case "requestMessage":
			err = unpopulate(val, "RequestMessage", &s.RequestMessage)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StackEnsembleSettings.
func (s StackEnsembleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "stackMetaLearnerKWargs", s.StackMetaLearnerKWargs)
	populate(objectMap, "stackMetaLearnerTrainPercentage", s.StackMetaLearnerTrainPercentage)
	populate(objectMap, "stackMetaLearnerType", s.StackMetaLearnerType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StackEnsembleSettings.
func (s *StackEnsembleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "stackMetaLearnerKWargs":
			err = unpopulate(val, "StackMetaLearnerKWargs", &s.StackMetaLearnerKWargs)
			delete(rawMsg, key)
		case "stackMetaLearnerTrainPercentage":
			err = unpopulate(val, "StackMetaLearnerTrainPercentage", &s.StackMetaLearnerTrainPercentage)
			delete(rawMsg, key)
		case "stackMetaLearnerType":
			err = unpopulate(val, "StackMetaLearnerType", &s.StackMetaLearnerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SweepJob.
func (s SweepJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "componentId", s.ComponentID)
	populate(objectMap, "computeId", s.ComputeID)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "earlyTermination", s.EarlyTermination)
	populate(objectMap, "experimentName", s.ExperimentName)
	populate(objectMap, "identity", s.Identity)
	populate(objectMap, "inputs", s.Inputs)
	populate(objectMap, "isArchived", s.IsArchived)
	objectMap["jobType"] = JobTypeSweep
	populate(objectMap, "limits", s.Limits)
	populate(objectMap, "objective", s.Objective)
	populate(objectMap, "outputs", s.Outputs)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "samplingAlgorithm", s.SamplingAlgorithm)
	populateAny(objectMap, "searchSpace", s.SearchSpace)
	populate(objectMap, "services", s.Services)
	populate(objectMap, "status", s.Status)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "trial", s.Trial)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SweepJob.
func (s *SweepJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "componentId":
			err = unpopulate(val, "ComponentID", &s.ComponentID)
			delete(rawMsg, key)
		case "computeId":
			err = unpopulate(val, "ComputeID", &s.ComputeID)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "earlyTermination":
			s.EarlyTermination, err = unmarshalEarlyTerminationPolicyClassification(val)
			delete(rawMsg, key)
		case "experimentName":
			err = unpopulate(val, "ExperimentName", &s.ExperimentName)
			delete(rawMsg, key)
		case "identity":
			s.Identity, err = unmarshalIdentityConfigurationClassification(val)
			delete(rawMsg, key)
		case "inputs":
			s.Inputs, err = unmarshalJobInputClassificationMap(val)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &s.IsArchived)
			delete(rawMsg, key)
		case "jobType":
			err = unpopulate(val, "JobType", &s.JobType)
			delete(rawMsg, key)
		case "limits":
			err = unpopulate(val, "Limits", &s.Limits)
			delete(rawMsg, key)
		case "objective":
			err = unpopulate(val, "Objective", &s.Objective)
			delete(rawMsg, key)
		case "outputs":
			s.Outputs, err = unmarshalJobOutputClassificationMap(val)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "samplingAlgorithm":
			s.SamplingAlgorithm, err = unmarshalSamplingAlgorithmClassification(val)
			delete(rawMsg, key)
		case "searchSpace":
			err = unpopulate(val, "SearchSpace", &s.SearchSpace)
			delete(rawMsg, key)
		case "services":
			err = unpopulate(val, "Services", &s.Services)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "trial":
			err = unpopulate(val, "Trial", &s.Trial)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SweepJobLimits.
func (s SweepJobLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["jobLimitsType"] = JobLimitsTypeSweep
	populate(objectMap, "maxConcurrentTrials", s.MaxConcurrentTrials)
	populate(objectMap, "maxTotalTrials", s.MaxTotalTrials)
	populate(objectMap, "timeout", s.Timeout)
	populate(objectMap, "trialTimeout", s.TrialTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SweepJobLimits.
func (s *SweepJobLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "jobLimitsType":
			err = unpopulate(val, "JobLimitsType", &s.JobLimitsType)
			delete(rawMsg, key)
		case "maxConcurrentTrials":
			err = unpopulate(val, "MaxConcurrentTrials", &s.MaxConcurrentTrials)
			delete(rawMsg, key)
		case "maxTotalTrials":
			err = unpopulate(val, "MaxTotalTrials", &s.MaxTotalTrials)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &s.Timeout)
			delete(rawMsg, key)
		case "trialTimeout":
			err = unpopulate(val, "TrialTimeout", &s.TrialTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SynapseSpark.
func (s SynapseSpark) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", s.ComputeLocation)
	objectMap["computeType"] = ComputeTypeSynapseSpark
	populateDateTimeRFC3339(objectMap, "createdOn", s.CreatedOn)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "disableLocalAuth", s.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", s.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", s.ModifiedOn)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "provisioningErrors", s.ProvisioningErrors)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceId", s.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SynapseSpark.
func (s *SynapseSpark) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &s.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &s.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &s.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &s.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &s.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &s.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &s.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &s.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SynapseSparkProperties.
func (s SynapseSparkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoPauseProperties", s.AutoPauseProperties)
	populate(objectMap, "autoScaleProperties", s.AutoScaleProperties)
	populate(objectMap, "nodeCount", s.NodeCount)
	populate(objectMap, "nodeSize", s.NodeSize)
	populate(objectMap, "nodeSizeFamily", s.NodeSizeFamily)
	populate(objectMap, "poolName", s.PoolName)
	populate(objectMap, "resourceGroup", s.ResourceGroup)
	populate(objectMap, "sparkVersion", s.SparkVersion)
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	populate(objectMap, "workspaceName", s.WorkspaceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SynapseSparkProperties.
func (s *SynapseSparkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoPauseProperties":
			err = unpopulate(val, "AutoPauseProperties", &s.AutoPauseProperties)
			delete(rawMsg, key)
		case "autoScaleProperties":
			err = unpopulate(val, "AutoScaleProperties", &s.AutoScaleProperties)
			delete(rawMsg, key)
		case "nodeCount":
			err = unpopulate(val, "NodeCount", &s.NodeCount)
			delete(rawMsg, key)
		case "nodeSize":
			err = unpopulate(val, "NodeSize", &s.NodeSize)
			delete(rawMsg, key)
		case "nodeSizeFamily":
			err = unpopulate(val, "NodeSizeFamily", &s.NodeSizeFamily)
			delete(rawMsg, key)
		case "poolName":
			err = unpopulate(val, "PoolName", &s.PoolName)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &s.ResourceGroup)
			delete(rawMsg, key)
		case "sparkVersion":
			err = unpopulate(val, "SparkVersion", &s.SparkVersion)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		case "workspaceName":
			err = unpopulate(val, "WorkspaceName", &s.WorkspaceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemService.
func (s SystemService) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIpAddress", s.PublicIPAddress)
	populate(objectMap, "systemServiceType", s.SystemServiceType)
	populate(objectMap, "version", s.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemService.
func (s *SystemService) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIpAddress":
			err = unpopulate(val, "PublicIPAddress", &s.PublicIPAddress)
			delete(rawMsg, key)
		case "systemServiceType":
			err = unpopulate(val, "SystemServiceType", &s.SystemServiceType)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &s.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableVertical.
func (t TableVertical) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cvSplitColumnNames", t.CvSplitColumnNames)
	populate(objectMap, "featurizationSettings", t.FeaturizationSettings)
	populate(objectMap, "limitSettings", t.LimitSettings)
	populate(objectMap, "nCrossValidations", t.NCrossValidations)
	populate(objectMap, "testData", t.TestData)
	populate(objectMap, "testDataSize", t.TestDataSize)
	populate(objectMap, "validationData", t.ValidationData)
	populate(objectMap, "validationDataSize", t.ValidationDataSize)
	populate(objectMap, "weightColumnName", t.WeightColumnName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableVertical.
func (t *TableVertical) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cvSplitColumnNames":
			err = unpopulate(val, "CvSplitColumnNames", &t.CvSplitColumnNames)
			delete(rawMsg, key)
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &t.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &t.LimitSettings)
			delete(rawMsg, key)
		case "nCrossValidations":
			t.NCrossValidations, err = unmarshalNCrossValidationsClassification(val)
			delete(rawMsg, key)
		case "testData":
			err = unpopulate(val, "TestData", &t.TestData)
			delete(rawMsg, key)
		case "testDataSize":
			err = unpopulate(val, "TestDataSize", &t.TestDataSize)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &t.ValidationData)
			delete(rawMsg, key)
		case "validationDataSize":
			err = unpopulate(val, "ValidationDataSize", &t.ValidationDataSize)
			delete(rawMsg, key)
		case "weightColumnName":
			err = unpopulate(val, "WeightColumnName", &t.WeightColumnName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableVerticalFeaturizationSettings.
func (t TableVerticalFeaturizationSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blockedTransformers", t.BlockedTransformers)
	populate(objectMap, "columnNameAndTypes", t.ColumnNameAndTypes)
	populate(objectMap, "datasetLanguage", t.DatasetLanguage)
	populate(objectMap, "enableDnnFeaturization", t.EnableDnnFeaturization)
	populate(objectMap, "mode", t.Mode)
	populate(objectMap, "transformerParams", t.TransformerParams)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableVerticalFeaturizationSettings.
func (t *TableVerticalFeaturizationSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blockedTransformers":
			err = unpopulate(val, "BlockedTransformers", &t.BlockedTransformers)
			delete(rawMsg, key)
		case "columnNameAndTypes":
			err = unpopulate(val, "ColumnNameAndTypes", &t.ColumnNameAndTypes)
			delete(rawMsg, key)
		case "datasetLanguage":
			err = unpopulate(val, "DatasetLanguage", &t.DatasetLanguage)
			delete(rawMsg, key)
		case "enableDnnFeaturization":
			err = unpopulate(val, "EnableDnnFeaturization", &t.EnableDnnFeaturization)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &t.Mode)
			delete(rawMsg, key)
		case "transformerParams":
			err = unpopulate(val, "TransformerParams", &t.TransformerParams)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TableVerticalLimitSettings.
func (t TableVerticalLimitSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableEarlyTermination", t.EnableEarlyTermination)
	populate(objectMap, "exitScore", t.ExitScore)
	populate(objectMap, "maxConcurrentTrials", t.MaxConcurrentTrials)
	populate(objectMap, "maxCoresPerTrial", t.MaxCoresPerTrial)
	populate(objectMap, "maxTrials", t.MaxTrials)
	populate(objectMap, "timeout", t.Timeout)
	populate(objectMap, "trialTimeout", t.TrialTimeout)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TableVerticalLimitSettings.
func (t *TableVerticalLimitSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableEarlyTermination":
			err = unpopulate(val, "EnableEarlyTermination", &t.EnableEarlyTermination)
			delete(rawMsg, key)
		case "exitScore":
			err = unpopulate(val, "ExitScore", &t.ExitScore)
			delete(rawMsg, key)
		case "maxConcurrentTrials":
			err = unpopulate(val, "MaxConcurrentTrials", &t.MaxConcurrentTrials)
			delete(rawMsg, key)
		case "maxCoresPerTrial":
			err = unpopulate(val, "MaxCoresPerTrial", &t.MaxCoresPerTrial)
			delete(rawMsg, key)
		case "maxTrials":
			err = unpopulate(val, "MaxTrials", &t.MaxTrials)
			delete(rawMsg, key)
		case "timeout":
			err = unpopulate(val, "Timeout", &t.Timeout)
			delete(rawMsg, key)
		case "trialTimeout":
			err = unpopulate(val, "TrialTimeout", &t.TrialTimeout)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetLags.
func (t TargetLags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = t.Mode
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetLags.
func (t *TargetLags) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &t.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetRollingWindowSize.
func (t TargetRollingWindowSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["mode"] = t.Mode
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetRollingWindowSize.
func (t *TargetRollingWindowSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mode":
			err = unpopulate(val, "Mode", &t.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TargetUtilizationScaleSettings.
func (t TargetUtilizationScaleSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maxInstances", t.MaxInstances)
	populate(objectMap, "minInstances", t.MinInstances)
	populate(objectMap, "pollingInterval", t.PollingInterval)
	objectMap["scaleType"] = ScaleTypeTargetUtilization
	populate(objectMap, "targetUtilizationPercentage", t.TargetUtilizationPercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TargetUtilizationScaleSettings.
func (t *TargetUtilizationScaleSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maxInstances":
			err = unpopulate(val, "MaxInstances", &t.MaxInstances)
			delete(rawMsg, key)
		case "minInstances":
			err = unpopulate(val, "MinInstances", &t.MinInstances)
			delete(rawMsg, key)
		case "pollingInterval":
			err = unpopulate(val, "PollingInterval", &t.PollingInterval)
			delete(rawMsg, key)
		case "scaleType":
			err = unpopulate(val, "ScaleType", &t.ScaleType)
			delete(rawMsg, key)
		case "targetUtilizationPercentage":
			err = unpopulate(val, "TargetUtilizationPercentage", &t.TargetUtilizationPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TensorFlow.
func (t TensorFlow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["distributionType"] = DistributionTypeTensorFlow
	populate(objectMap, "parameterServerCount", t.ParameterServerCount)
	populate(objectMap, "workerCount", t.WorkerCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TensorFlow.
func (t *TensorFlow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "distributionType":
			err = unpopulate(val, "DistributionType", &t.DistributionType)
			delete(rawMsg, key)
		case "parameterServerCount":
			err = unpopulate(val, "ParameterServerCount", &t.ParameterServerCount)
			delete(rawMsg, key)
		case "workerCount":
			err = unpopulate(val, "WorkerCount", &t.WorkerCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TextClassification.
func (t TextClassification) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featurizationSettings", t.FeaturizationSettings)
	populate(objectMap, "limitSettings", t.LimitSettings)
	populate(objectMap, "logVerbosity", t.LogVerbosity)
	populate(objectMap, "primaryMetric", t.PrimaryMetric)
	populate(objectMap, "targetColumnName", t.TargetColumnName)
	objectMap["taskType"] = TaskTypeTextClassification
	populate(objectMap, "trainingData", t.TrainingData)
	populate(objectMap, "validationData", t.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TextClassification.
func (t *TextClassification) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &t.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &t.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &t.LogVerbosity)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &t.PrimaryMetric)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &t.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &t.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &t.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &t.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TextClassificationMultilabel.
func (t TextClassificationMultilabel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featurizationSettings", t.FeaturizationSettings)
	populate(objectMap, "limitSettings", t.LimitSettings)
	populate(objectMap, "logVerbosity", t.LogVerbosity)
	populate(objectMap, "primaryMetric", t.PrimaryMetric)
	populate(objectMap, "targetColumnName", t.TargetColumnName)
	objectMap["taskType"] = TaskTypeTextClassificationMultilabel
	populate(objectMap, "trainingData", t.TrainingData)
	populate(objectMap, "validationData", t.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TextClassificationMultilabel.
func (t *TextClassificationMultilabel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &t.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &t.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &t.LogVerbosity)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &t.PrimaryMetric)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &t.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &t.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &t.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &t.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TextNer.
func (t TextNer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "featurizationSettings", t.FeaturizationSettings)
	populate(objectMap, "limitSettings", t.LimitSettings)
	populate(objectMap, "logVerbosity", t.LogVerbosity)
	populate(objectMap, "primaryMetric", t.PrimaryMetric)
	populate(objectMap, "targetColumnName", t.TargetColumnName)
	objectMap["taskType"] = TaskTypeTextNER
	populate(objectMap, "trainingData", t.TrainingData)
	populate(objectMap, "validationData", t.ValidationData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TextNer.
func (t *TextNer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "featurizationSettings":
			err = unpopulate(val, "FeaturizationSettings", &t.FeaturizationSettings)
			delete(rawMsg, key)
		case "limitSettings":
			err = unpopulate(val, "LimitSettings", &t.LimitSettings)
			delete(rawMsg, key)
		case "logVerbosity":
			err = unpopulate(val, "LogVerbosity", &t.LogVerbosity)
			delete(rawMsg, key)
		case "primaryMetric":
			err = unpopulate(val, "PrimaryMetric", &t.PrimaryMetric)
			delete(rawMsg, key)
		case "targetColumnName":
			err = unpopulate(val, "TargetColumnName", &t.TargetColumnName)
			delete(rawMsg, key)
		case "taskType":
			err = unpopulate(val, "TaskType", &t.TaskType)
			delete(rawMsg, key)
		case "trainingData":
			err = unpopulate(val, "TrainingData", &t.TrainingData)
			delete(rawMsg, key)
		case "validationData":
			err = unpopulate(val, "ValidationData", &t.ValidationData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrackedResource.
func (t TrackedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "location", t.Location)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "tags", t.Tags)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrackedResource.
func (t *TrackedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &t.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrainingSettings.
func (t TrainingSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enableDnnTraining", t.EnableDnnTraining)
	populate(objectMap, "enableModelExplainability", t.EnableModelExplainability)
	populate(objectMap, "enableOnnxCompatibleModels", t.EnableOnnxCompatibleModels)
	populate(objectMap, "enableStackEnsemble", t.EnableStackEnsemble)
	populate(objectMap, "enableVoteEnsemble", t.EnableVoteEnsemble)
	populate(objectMap, "ensembleModelDownloadTimeout", t.EnsembleModelDownloadTimeout)
	populate(objectMap, "stackEnsembleSettings", t.StackEnsembleSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrainingSettings.
func (t *TrainingSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enableDnnTraining":
			err = unpopulate(val, "EnableDnnTraining", &t.EnableDnnTraining)
			delete(rawMsg, key)
		case "enableModelExplainability":
			err = unpopulate(val, "EnableModelExplainability", &t.EnableModelExplainability)
			delete(rawMsg, key)
		case "enableOnnxCompatibleModels":
			err = unpopulate(val, "EnableOnnxCompatibleModels", &t.EnableOnnxCompatibleModels)
			delete(rawMsg, key)
		case "enableStackEnsemble":
			err = unpopulate(val, "EnableStackEnsemble", &t.EnableStackEnsemble)
			delete(rawMsg, key)
		case "enableVoteEnsemble":
			err = unpopulate(val, "EnableVoteEnsemble", &t.EnableVoteEnsemble)
			delete(rawMsg, key)
		case "ensembleModelDownloadTimeout":
			err = unpopulate(val, "EnsembleModelDownloadTimeout", &t.EnsembleModelDownloadTimeout)
			delete(rawMsg, key)
		case "stackEnsembleSettings":
			err = unpopulate(val, "StackEnsembleSettings", &t.StackEnsembleSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrialComponent.
func (t TrialComponent) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "codeId", t.CodeID)
	populate(objectMap, "command", t.Command)
	populate(objectMap, "distribution", t.Distribution)
	populate(objectMap, "environmentId", t.EnvironmentID)
	populate(objectMap, "environmentVariables", t.EnvironmentVariables)
	populate(objectMap, "resources", t.Resources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrialComponent.
func (t *TrialComponent) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "codeId":
			err = unpopulate(val, "CodeID", &t.CodeID)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &t.Command)
			delete(rawMsg, key)
		case "distribution":
			t.Distribution, err = unmarshalDistributionConfigurationClassification(val)
			delete(rawMsg, key)
		case "environmentId":
			err = unpopulate(val, "EnvironmentID", &t.EnvironmentID)
			delete(rawMsg, key)
		case "environmentVariables":
			err = unpopulate(val, "EnvironmentVariables", &t.EnvironmentVariables)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &t.Resources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TriggerBase.
func (t TriggerBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", t.EndTime)
	populate(objectMap, "startTime", t.StartTime)
	populate(objectMap, "timeZone", t.TimeZone)
	objectMap["triggerType"] = t.TriggerType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TriggerBase.
func (t *TriggerBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &t.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		case "timeZone":
			err = unpopulate(val, "TimeZone", &t.TimeZone)
			delete(rawMsg, key)
		case "triggerType":
			err = unpopulate(val, "TriggerType", &t.TriggerType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TritonModelJobInput.
func (t TritonModelJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", t.Description)
	objectMap["jobInputType"] = JobInputTypeTritonModel
	populate(objectMap, "mode", t.Mode)
	populate(objectMap, "uri", t.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TritonModelJobInput.
func (t *TritonModelJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &t.JobInputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &t.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &t.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TritonModelJobOutput.
func (t TritonModelJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", t.Description)
	objectMap["jobOutputType"] = JobOutputTypeTritonModel
	populate(objectMap, "mode", t.Mode)
	populate(objectMap, "uri", t.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TritonModelJobOutput.
func (t *TritonModelJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &t.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &t.JobOutputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &t.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &t.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TruncationSelectionPolicy.
func (t TruncationSelectionPolicy) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delayEvaluation", t.DelayEvaluation)
	populate(objectMap, "evaluationInterval", t.EvaluationInterval)
	objectMap["policyType"] = EarlyTerminationPolicyTypeTruncationSelection
	populate(objectMap, "truncationPercentage", t.TruncationPercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TruncationSelectionPolicy.
func (t *TruncationSelectionPolicy) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delayEvaluation":
			err = unpopulate(val, "DelayEvaluation", &t.DelayEvaluation)
			delete(rawMsg, key)
		case "evaluationInterval":
			err = unpopulate(val, "EvaluationInterval", &t.EvaluationInterval)
			delete(rawMsg, key)
		case "policyType":
			err = unpopulate(val, "PolicyType", &t.PolicyType)
			delete(rawMsg, key)
		case "truncationPercentage":
			err = unpopulate(val, "TruncationPercentage", &t.TruncationPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URIFileDataVersion.
func (u URIFileDataVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataType"] = DataTypeURIFile
	populate(objectMap, "dataUri", u.DataURI)
	populate(objectMap, "description", u.Description)
	populate(objectMap, "isAnonymous", u.IsAnonymous)
	populate(objectMap, "isArchived", u.IsArchived)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URIFileDataVersion.
func (u *URIFileDataVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &u.DataType)
			delete(rawMsg, key)
		case "dataUri":
			err = unpopulate(val, "DataURI", &u.DataURI)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &u.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &u.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URIFileJobInput.
func (u URIFileJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	objectMap["jobInputType"] = JobInputTypeURIFile
	populate(objectMap, "mode", u.Mode)
	populate(objectMap, "uri", u.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URIFileJobInput.
func (u *URIFileJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &u.JobInputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &u.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &u.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URIFileJobOutput.
func (u URIFileJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	objectMap["jobOutputType"] = JobOutputTypeURIFile
	populate(objectMap, "mode", u.Mode)
	populate(objectMap, "uri", u.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URIFileJobOutput.
func (u *URIFileJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &u.JobOutputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &u.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &u.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URIFolderDataVersion.
func (u URIFolderDataVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["dataType"] = DataTypeURIFolder
	populate(objectMap, "dataUri", u.DataURI)
	populate(objectMap, "description", u.Description)
	populate(objectMap, "isAnonymous", u.IsAnonymous)
	populate(objectMap, "isArchived", u.IsArchived)
	populate(objectMap, "properties", u.Properties)
	populate(objectMap, "tags", u.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URIFolderDataVersion.
func (u *URIFolderDataVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dataType":
			err = unpopulate(val, "DataType", &u.DataType)
			delete(rawMsg, key)
		case "dataUri":
			err = unpopulate(val, "DataURI", &u.DataURI)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "isAnonymous":
			err = unpopulate(val, "IsAnonymous", &u.IsAnonymous)
			delete(rawMsg, key)
		case "isArchived":
			err = unpopulate(val, "IsArchived", &u.IsArchived)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &u.Properties)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &u.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URIFolderJobInput.
func (u URIFolderJobInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	objectMap["jobInputType"] = JobInputTypeURIFolder
	populate(objectMap, "mode", u.Mode)
	populate(objectMap, "uri", u.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URIFolderJobInput.
func (u *URIFolderJobInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "jobInputType":
			err = unpopulate(val, "JobInputType", &u.JobInputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &u.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &u.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type URIFolderJobOutput.
func (u URIFolderJobOutput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", u.Description)
	objectMap["jobOutputType"] = JobOutputTypeURIFolder
	populate(objectMap, "mode", u.Mode)
	populate(objectMap, "uri", u.URI)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type URIFolderJobOutput.
func (u *URIFolderJobOutput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &u.Description)
			delete(rawMsg, key)
		case "jobOutputType":
			err = unpopulate(val, "JobOutputType", &u.JobOutputType)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &u.Mode)
			delete(rawMsg, key)
		case "uri":
			err = unpopulate(val, "URI", &u.URI)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateWorkspaceQuotas.
func (u UpdateWorkspaceQuotas) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "status", u.Status)
	populate(objectMap, "type", u.Type)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateWorkspaceQuotas.
func (u *UpdateWorkspaceQuotas) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &u.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpdateWorkspaceQuotasResult.
func (u UpdateWorkspaceQuotasResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", u.NextLink)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpdateWorkspaceQuotasResult.
func (u *UpdateWorkspaceQuotasResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &u.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Usage.
func (u Usage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amlWorkspaceLocation", u.AmlWorkspaceLocation)
	populate(objectMap, "currentValue", u.CurrentValue)
	populate(objectMap, "id", u.ID)
	populate(objectMap, "limit", u.Limit)
	populate(objectMap, "name", u.Name)
	populate(objectMap, "type", u.Type)
	populate(objectMap, "unit", u.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Usage.
func (u *Usage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amlWorkspaceLocation":
			err = unpopulate(val, "AmlWorkspaceLocation", &u.AmlWorkspaceLocation)
			delete(rawMsg, key)
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &u.CurrentValue)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &u.ID)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &u.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &u.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &u.Type)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &u.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsageName.
func (u UsageName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", u.LocalizedValue)
	populate(objectMap, "value", u.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsageName.
func (u *UsageName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &u.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAccountCredentials.
func (u UserAccountCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminUserName", u.AdminUserName)
	populate(objectMap, "adminUserPassword", u.AdminUserPassword)
	populate(objectMap, "adminUserSshPublicKey", u.AdminUserSSHPublicKey)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAccountCredentials.
func (u *UserAccountCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUserName":
			err = unpopulate(val, "AdminUserName", &u.AdminUserName)
			delete(rawMsg, key)
		case "adminUserPassword":
			err = unpopulate(val, "AdminUserPassword", &u.AdminUserPassword)
			delete(rawMsg, key)
		case "adminUserSshPublicKey":
			err = unpopulate(val, "AdminUserSSHPublicKey", &u.AdminUserSSHPublicKey)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "principalId", u.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &u.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserIdentity.
func (u UserIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["identityType"] = IdentityConfigurationTypeUserIdentity
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserIdentity.
func (u *UserIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identityType":
			err = unpopulate(val, "IdentityType", &u.IdentityType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UsernamePasswordAuthTypeWorkspaceConnectionProperties.
func (u UsernamePasswordAuthTypeWorkspaceConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authType"] = ConnectionAuthTypeUsernamePassword
	populate(objectMap, "category", u.Category)
	populate(objectMap, "credentials", u.Credentials)
	populate(objectMap, "target", u.Target)
	populate(objectMap, "value", u.Value)
	populate(objectMap, "valueFormat", u.ValueFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UsernamePasswordAuthTypeWorkspaceConnectionProperties.
func (u *UsernamePasswordAuthTypeWorkspaceConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &u.AuthType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &u.Category)
			delete(rawMsg, key)
		case "credentials":
			err = unpopulate(val, "Credentials", &u.Credentials)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &u.Target)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &u.Value)
			delete(rawMsg, key)
		case "valueFormat":
			err = unpopulate(val, "ValueFormat", &u.ValueFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachine.
func (v VirtualMachine) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "computeLocation", v.ComputeLocation)
	objectMap["computeType"] = ComputeTypeVirtualMachine
	populateDateTimeRFC3339(objectMap, "createdOn", v.CreatedOn)
	populate(objectMap, "description", v.Description)
	populate(objectMap, "disableLocalAuth", v.DisableLocalAuth)
	populate(objectMap, "isAttachedCompute", v.IsAttachedCompute)
	populateDateTimeRFC3339(objectMap, "modifiedOn", v.ModifiedOn)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "provisioningErrors", v.ProvisioningErrors)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "resourceId", v.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachine.
func (v *VirtualMachine) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "computeLocation":
			err = unpopulate(val, "ComputeLocation", &v.ComputeLocation)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &v.ComputeType)
			delete(rawMsg, key)
		case "createdOn":
			err = unpopulateDateTimeRFC3339(val, "CreatedOn", &v.CreatedOn)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &v.Description)
			delete(rawMsg, key)
		case "disableLocalAuth":
			err = unpopulate(val, "DisableLocalAuth", &v.DisableLocalAuth)
			delete(rawMsg, key)
		case "isAttachedCompute":
			err = unpopulate(val, "IsAttachedCompute", &v.IsAttachedCompute)
			delete(rawMsg, key)
		case "modifiedOn":
			err = unpopulateDateTimeRFC3339(val, "ModifiedOn", &v.ModifiedOn)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "provisioningErrors":
			err = unpopulate(val, "ProvisioningErrors", &v.ProvisioningErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &v.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineImage.
func (v VirtualMachineImage) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineImage.
func (v *VirtualMachineImage) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSSHCredentials.
func (v VirtualMachineSSHCredentials) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", v.Password)
	populate(objectMap, "privateKeyData", v.PrivateKeyData)
	populate(objectMap, "publicKeyData", v.PublicKeyData)
	populate(objectMap, "username", v.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSSHCredentials.
func (v *VirtualMachineSSHCredentials) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &v.Password)
			delete(rawMsg, key)
		case "privateKeyData":
			err = unpopulate(val, "PrivateKeyData", &v.PrivateKeyData)
			delete(rawMsg, key)
		case "publicKeyData":
			err = unpopulate(val, "PublicKeyData", &v.PublicKeyData)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &v.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSchema.
func (v VirtualMachineSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", v.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSchema.
func (v *VirtualMachineSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSchemaProperties.
func (v VirtualMachineSchemaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "address", v.Address)
	populate(objectMap, "administratorAccount", v.AdministratorAccount)
	populate(objectMap, "isNotebookInstanceCompute", v.IsNotebookInstanceCompute)
	populate(objectMap, "notebookServerPort", v.NotebookServerPort)
	populate(objectMap, "sshPort", v.SSHPort)
	populate(objectMap, "virtualMachineSize", v.VirtualMachineSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSchemaProperties.
func (v *VirtualMachineSchemaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "address":
			err = unpopulate(val, "Address", &v.Address)
			delete(rawMsg, key)
		case "administratorAccount":
			err = unpopulate(val, "AdministratorAccount", &v.AdministratorAccount)
			delete(rawMsg, key)
		case "isNotebookInstanceCompute":
			err = unpopulate(val, "IsNotebookInstanceCompute", &v.IsNotebookInstanceCompute)
			delete(rawMsg, key)
		case "notebookServerPort":
			err = unpopulate(val, "NotebookServerPort", &v.NotebookServerPort)
			delete(rawMsg, key)
		case "sshPort":
			err = unpopulate(val, "SSHPort", &v.SSHPort)
			delete(rawMsg, key)
		case "virtualMachineSize":
			err = unpopulate(val, "VirtualMachineSize", &v.VirtualMachineSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSecrets.
func (v VirtualMachineSecrets) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorAccount", v.AdministratorAccount)
	objectMap["computeType"] = ComputeTypeVirtualMachine
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSecrets.
func (v *VirtualMachineSecrets) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorAccount":
			err = unpopulate(val, "AdministratorAccount", &v.AdministratorAccount)
			delete(rawMsg, key)
		case "computeType":
			err = unpopulate(val, "ComputeType", &v.ComputeType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSecretsSchema.
func (v VirtualMachineSecretsSchema) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "administratorAccount", v.AdministratorAccount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSecretsSchema.
func (v *VirtualMachineSecretsSchema) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "administratorAccount":
			err = unpopulate(val, "AdministratorAccount", &v.AdministratorAccount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSize.
func (v VirtualMachineSize) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "estimatedVMPrices", v.EstimatedVMPrices)
	populate(objectMap, "family", v.Family)
	populate(objectMap, "gpus", v.Gpus)
	populate(objectMap, "lowPriorityCapable", v.LowPriorityCapable)
	populate(objectMap, "maxResourceVolumeMB", v.MaxResourceVolumeMB)
	populate(objectMap, "memoryGB", v.MemoryGB)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "osVhdSizeMB", v.OSVhdSizeMB)
	populate(objectMap, "premiumIO", v.PremiumIO)
	populate(objectMap, "supportedComputeTypes", v.SupportedComputeTypes)
	populate(objectMap, "vCPUs", v.VCPUs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSize.
func (v *VirtualMachineSize) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "estimatedVMPrices":
			err = unpopulate(val, "EstimatedVMPrices", &v.EstimatedVMPrices)
			delete(rawMsg, key)
		case "family":
			err = unpopulate(val, "Family", &v.Family)
			delete(rawMsg, key)
		case "gpus":
			err = unpopulate(val, "Gpus", &v.Gpus)
			delete(rawMsg, key)
		case "lowPriorityCapable":
			err = unpopulate(val, "LowPriorityCapable", &v.LowPriorityCapable)
			delete(rawMsg, key)
		case "maxResourceVolumeMB":
			err = unpopulate(val, "MaxResourceVolumeMB", &v.MaxResourceVolumeMB)
			delete(rawMsg, key)
		case "memoryGB":
			err = unpopulate(val, "MemoryGB", &v.MemoryGB)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "osVhdSizeMB":
			err = unpopulate(val, "OSVhdSizeMB", &v.OSVhdSizeMB)
			delete(rawMsg, key)
		case "premiumIO":
			err = unpopulate(val, "PremiumIO", &v.PremiumIO)
			delete(rawMsg, key)
		case "supportedComputeTypes":
			err = unpopulate(val, "SupportedComputeTypes", &v.SupportedComputeTypes)
			delete(rawMsg, key)
		case "vCPUs":
			err = unpopulate(val, "VCPUs", &v.VCPUs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualMachineSizeListResult.
func (v VirtualMachineSizeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualMachineSizeListResult.
func (v *VirtualMachineSizeListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "location", w.Location)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "tags", w.Tags)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Workspace.
func (w *Workspace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &w.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionManagedIdentity.
func (w WorkspaceConnectionManagedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", w.ClientID)
	populate(objectMap, "resourceId", w.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionManagedIdentity.
func (w *WorkspaceConnectionManagedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &w.ClientID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &w.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionPersonalAccessToken.
func (w WorkspaceConnectionPersonalAccessToken) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "pat", w.Pat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionPersonalAccessToken.
func (w *WorkspaceConnectionPersonalAccessToken) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "pat":
			err = unpopulate(val, "Pat", &w.Pat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionPropertiesV2.
func (w WorkspaceConnectionPropertiesV2) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["authType"] = w.AuthType
	populate(objectMap, "category", w.Category)
	populate(objectMap, "target", w.Target)
	populate(objectMap, "value", w.Value)
	populate(objectMap, "valueFormat", w.ValueFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionPropertiesV2.
func (w *WorkspaceConnectionPropertiesV2) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authType":
			err = unpopulate(val, "AuthType", &w.AuthType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &w.Category)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &w.Target)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		case "valueFormat":
			err = unpopulate(val, "ValueFormat", &w.ValueFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionPropertiesV2BasicResource.
func (w WorkspaceConnectionPropertiesV2BasicResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionPropertiesV2BasicResource.
func (w *WorkspaceConnectionPropertiesV2BasicResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			w.Properties, err = unmarshalWorkspaceConnectionPropertiesV2Classification(val)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult.
func (w WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult.
func (w *WorkspaceConnectionPropertiesV2BasicResourceArmPaginatedResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionSharedAccessSignature.
func (w WorkspaceConnectionSharedAccessSignature) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sas", w.Sas)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionSharedAccessSignature.
func (w *WorkspaceConnectionSharedAccessSignature) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sas":
			err = unpopulate(val, "Sas", &w.Sas)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceConnectionUsernamePassword.
func (w WorkspaceConnectionUsernamePassword) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "password", w.Password)
	populate(objectMap, "username", w.Username)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceConnectionUsernamePassword.
func (w *WorkspaceConnectionUsernamePassword) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "password":
			err = unpopulate(val, "Password", &w.Password)
			delete(rawMsg, key)
		case "username":
			err = unpopulate(val, "Username", &w.Username)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceListResult.
func (w WorkspaceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceListResult.
func (w *WorkspaceListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceProperties.
func (w WorkspaceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowPublicAccessWhenBehindVnet", w.AllowPublicAccessWhenBehindVnet)
	populate(objectMap, "applicationInsights", w.ApplicationInsights)
	populate(objectMap, "containerRegistry", w.ContainerRegistry)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "discoveryUrl", w.DiscoveryURL)
	populate(objectMap, "encryption", w.Encryption)
	populate(objectMap, "friendlyName", w.FriendlyName)
	populate(objectMap, "hbiWorkspace", w.HbiWorkspace)
	populate(objectMap, "imageBuildCompute", w.ImageBuildCompute)
	populate(objectMap, "keyVault", w.KeyVault)
	populate(objectMap, "mlFlowTrackingUri", w.MlFlowTrackingURI)
	populate(objectMap, "notebookInfo", w.NotebookInfo)
	populate(objectMap, "primaryUserAssignedIdentity", w.PrimaryUserAssignedIdentity)
	populate(objectMap, "privateEndpointConnections", w.PrivateEndpointConnections)
	populate(objectMap, "privateLinkCount", w.PrivateLinkCount)
	populate(objectMap, "provisioningState", w.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	populate(objectMap, "serviceManagedResourcesSettings", w.ServiceManagedResourcesSettings)
	populate(objectMap, "serviceProvisionedResourceGroup", w.ServiceProvisionedResourceGroup)
	populate(objectMap, "sharedPrivateLinkResources", w.SharedPrivateLinkResources)
	populate(objectMap, "storageAccount", w.StorageAccount)
	populate(objectMap, "storageHnsEnabled", w.StorageHnsEnabled)
	populate(objectMap, "tenantId", w.TenantID)
	populate(objectMap, "v1LegacyMode", w.V1LegacyMode)
	populate(objectMap, "workspaceId", w.WorkspaceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceProperties.
func (w *WorkspaceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowPublicAccessWhenBehindVnet":
			err = unpopulate(val, "AllowPublicAccessWhenBehindVnet", &w.AllowPublicAccessWhenBehindVnet)
			delete(rawMsg, key)
		case "applicationInsights":
			err = unpopulate(val, "ApplicationInsights", &w.ApplicationInsights)
			delete(rawMsg, key)
		case "containerRegistry":
			err = unpopulate(val, "ContainerRegistry", &w.ContainerRegistry)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "discoveryUrl":
			err = unpopulate(val, "DiscoveryURL", &w.DiscoveryURL)
			delete(rawMsg, key)
		case "encryption":
			err = unpopulate(val, "Encryption", &w.Encryption)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &w.FriendlyName)
			delete(rawMsg, key)
		case "hbiWorkspace":
			err = unpopulate(val, "HbiWorkspace", &w.HbiWorkspace)
			delete(rawMsg, key)
		case "imageBuildCompute":
			err = unpopulate(val, "ImageBuildCompute", &w.ImageBuildCompute)
			delete(rawMsg, key)
		case "keyVault":
			err = unpopulate(val, "KeyVault", &w.KeyVault)
			delete(rawMsg, key)
		case "mlFlowTrackingUri":
			err = unpopulate(val, "MlFlowTrackingURI", &w.MlFlowTrackingURI)
			delete(rawMsg, key)
		case "notebookInfo":
			err = unpopulate(val, "NotebookInfo", &w.NotebookInfo)
			delete(rawMsg, key)
		case "primaryUserAssignedIdentity":
			err = unpopulate(val, "PrimaryUserAssignedIdentity", &w.PrimaryUserAssignedIdentity)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &w.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "privateLinkCount":
			err = unpopulate(val, "PrivateLinkCount", &w.PrivateLinkCount)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &w.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &w.PublicNetworkAccess)
			delete(rawMsg, key)
		case "serviceManagedResourcesSettings":
			err = unpopulate(val, "ServiceManagedResourcesSettings", &w.ServiceManagedResourcesSettings)
			delete(rawMsg, key)
		case "serviceProvisionedResourceGroup":
			err = unpopulate(val, "ServiceProvisionedResourceGroup", &w.ServiceProvisionedResourceGroup)
			delete(rawMsg, key)
		case "sharedPrivateLinkResources":
			err = unpopulate(val, "SharedPrivateLinkResources", &w.SharedPrivateLinkResources)
			delete(rawMsg, key)
		case "storageAccount":
			err = unpopulate(val, "StorageAccount", &w.StorageAccount)
			delete(rawMsg, key)
		case "storageHnsEnabled":
			err = unpopulate(val, "StorageHnsEnabled", &w.StorageHnsEnabled)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &w.TenantID)
			delete(rawMsg, key)
		case "v1LegacyMode":
			err = unpopulate(val, "V1LegacyMode", &w.V1LegacyMode)
			delete(rawMsg, key)
		case "workspaceId":
			err = unpopulate(val, "WorkspaceID", &w.WorkspaceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspacePropertiesUpdateParameters.
func (w WorkspacePropertiesUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applicationInsights", w.ApplicationInsights)
	populate(objectMap, "containerRegistry", w.ContainerRegistry)
	populate(objectMap, "description", w.Description)
	populate(objectMap, "friendlyName", w.FriendlyName)
	populate(objectMap, "imageBuildCompute", w.ImageBuildCompute)
	populate(objectMap, "primaryUserAssignedIdentity", w.PrimaryUserAssignedIdentity)
	populate(objectMap, "publicNetworkAccess", w.PublicNetworkAccess)
	populate(objectMap, "serviceManagedResourcesSettings", w.ServiceManagedResourcesSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspacePropertiesUpdateParameters.
func (w *WorkspacePropertiesUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applicationInsights":
			err = unpopulate(val, "ApplicationInsights", &w.ApplicationInsights)
			delete(rawMsg, key)
		case "containerRegistry":
			err = unpopulate(val, "ContainerRegistry", &w.ContainerRegistry)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &w.Description)
			delete(rawMsg, key)
		case "friendlyName":
			err = unpopulate(val, "FriendlyName", &w.FriendlyName)
			delete(rawMsg, key)
		case "imageBuildCompute":
			err = unpopulate(val, "ImageBuildCompute", &w.ImageBuildCompute)
			delete(rawMsg, key)
		case "primaryUserAssignedIdentity":
			err = unpopulate(val, "PrimaryUserAssignedIdentity", &w.PrimaryUserAssignedIdentity)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &w.PublicNetworkAccess)
			delete(rawMsg, key)
		case "serviceManagedResourcesSettings":
			err = unpopulate(val, "ServiceManagedResourcesSettings", &w.ServiceManagedResourcesSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkspaceUpdateParameters.
func (w WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "identity", w.Identity)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "sku", w.SKU)
	populate(objectMap, "tags", w.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkspaceUpdateParameters.
func (w *WorkspaceUpdateParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "identity":
			err = unpopulate(val, "Identity", &w.Identity)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &w.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &w.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
