//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/managednetworkfabric/armmanagednetworkfabric"
	"net/http"
	"net/url"
	"regexp"
)

// RoutePoliciesServer is a fake server for instances of the armmanagednetworkfabric.RoutePoliciesClient type.
type RoutePoliciesServer struct {
	// BeginCommitConfiguration is the fake for method RoutePoliciesClient.BeginCommitConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCommitConfiguration func(ctx context.Context, resourceGroupName string, routePolicyName string, options *armmanagednetworkfabric.RoutePoliciesClientBeginCommitConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientCommitConfigurationResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method RoutePoliciesClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, routePolicyName string, body armmanagednetworkfabric.RoutePolicy, options *armmanagednetworkfabric.RoutePoliciesClientBeginCreateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method RoutePoliciesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, routePolicyName string, options *armmanagednetworkfabric.RoutePoliciesClientBeginDeleteOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method RoutePoliciesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, routePolicyName string, options *armmanagednetworkfabric.RoutePoliciesClientGetOptions) (resp azfake.Responder[armmanagednetworkfabric.RoutePoliciesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method RoutePoliciesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armmanagednetworkfabric.RoutePoliciesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.RoutePoliciesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method RoutePoliciesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armmanagednetworkfabric.RoutePoliciesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armmanagednetworkfabric.RoutePoliciesClientListBySubscriptionResponse])

	// BeginUpdate is the fake for method RoutePoliciesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, routePolicyName string, body armmanagednetworkfabric.RoutePolicyPatch, options *armmanagednetworkfabric.RoutePoliciesClientBeginUpdateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientUpdateResponse], errResp azfake.ErrorResponder)

	// BeginUpdateAdministrativeState is the fake for method RoutePoliciesClient.BeginUpdateAdministrativeState
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateAdministrativeState func(ctx context.Context, resourceGroupName string, routePolicyName string, body armmanagednetworkfabric.UpdateAdministrativeState, options *armmanagednetworkfabric.RoutePoliciesClientBeginUpdateAdministrativeStateOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientUpdateAdministrativeStateResponse], errResp azfake.ErrorResponder)

	// BeginValidateConfiguration is the fake for method RoutePoliciesClient.BeginValidateConfiguration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginValidateConfiguration func(ctx context.Context, resourceGroupName string, routePolicyName string, options *armmanagednetworkfabric.RoutePoliciesClientBeginValidateConfigurationOptions) (resp azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientValidateConfigurationResponse], errResp azfake.ErrorResponder)
}

// NewRoutePoliciesServerTransport creates a new instance of RoutePoliciesServerTransport with the provided implementation.
// The returned RoutePoliciesServerTransport instance is connected to an instance of armmanagednetworkfabric.RoutePoliciesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewRoutePoliciesServerTransport(srv *RoutePoliciesServer) *RoutePoliciesServerTransport {
	return &RoutePoliciesServerTransport{
		srv:                            srv,
		beginCommitConfiguration:       newTracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientCommitConfigurationResponse]](),
		beginCreate:                    newTracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientCreateResponse]](),
		beginDelete:                    newTracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientDeleteResponse]](),
		newListByResourceGroupPager:    newTracker[azfake.PagerResponder[armmanagednetworkfabric.RoutePoliciesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:     newTracker[azfake.PagerResponder[armmanagednetworkfabric.RoutePoliciesClientListBySubscriptionResponse]](),
		beginUpdate:                    newTracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientUpdateResponse]](),
		beginUpdateAdministrativeState: newTracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientUpdateAdministrativeStateResponse]](),
		beginValidateConfiguration:     newTracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientValidateConfigurationResponse]](),
	}
}

// RoutePoliciesServerTransport connects instances of armmanagednetworkfabric.RoutePoliciesClient to instances of RoutePoliciesServer.
// Don't use this type directly, use NewRoutePoliciesServerTransport instead.
type RoutePoliciesServerTransport struct {
	srv                            *RoutePoliciesServer
	beginCommitConfiguration       *tracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientCommitConfigurationResponse]]
	beginCreate                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientCreateResponse]]
	beginDelete                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientDeleteResponse]]
	newListByResourceGroupPager    *tracker[azfake.PagerResponder[armmanagednetworkfabric.RoutePoliciesClientListByResourceGroupResponse]]
	newListBySubscriptionPager     *tracker[azfake.PagerResponder[armmanagednetworkfabric.RoutePoliciesClientListBySubscriptionResponse]]
	beginUpdate                    *tracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientUpdateResponse]]
	beginUpdateAdministrativeState *tracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientUpdateAdministrativeStateResponse]]
	beginValidateConfiguration     *tracker[azfake.PollerResponder[armmanagednetworkfabric.RoutePoliciesClientValidateConfigurationResponse]]
}

// Do implements the policy.Transporter interface for RoutePoliciesServerTransport.
func (r *RoutePoliciesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "RoutePoliciesClient.BeginCommitConfiguration":
		resp, err = r.dispatchBeginCommitConfiguration(req)
	case "RoutePoliciesClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "RoutePoliciesClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "RoutePoliciesClient.Get":
		resp, err = r.dispatchGet(req)
	case "RoutePoliciesClient.NewListByResourceGroupPager":
		resp, err = r.dispatchNewListByResourceGroupPager(req)
	case "RoutePoliciesClient.NewListBySubscriptionPager":
		resp, err = r.dispatchNewListBySubscriptionPager(req)
	case "RoutePoliciesClient.BeginUpdate":
		resp, err = r.dispatchBeginUpdate(req)
	case "RoutePoliciesClient.BeginUpdateAdministrativeState":
		resp, err = r.dispatchBeginUpdateAdministrativeState(req)
	case "RoutePoliciesClient.BeginValidateConfiguration":
		resp, err = r.dispatchBeginValidateConfiguration(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchBeginCommitConfiguration(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCommitConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCommitConfiguration not implemented")}
	}
	beginCommitConfiguration := r.beginCommitConfiguration.get(req)
	if beginCommitConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/commitConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCommitConfiguration(req.Context(), resourceGroupNameParam, routePolicyNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCommitConfiguration = &respr
		r.beginCommitConfiguration.add(req, beginCommitConfiguration)
	}

	resp, err := server.PollerResponderNext(beginCommitConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCommitConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCommitConfiguration) {
		r.beginCommitConfiguration.remove(req)
	}

	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.RoutePolicy](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceGroupNameParam, routePolicyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceGroupNameParam, routePolicyNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceGroupNameParam, routePolicyNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RoutePolicy, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := r.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		r.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armmanagednetworkfabric.RoutePoliciesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		r.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := r.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := r.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		r.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armmanagednetworkfabric.RoutePoliciesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		r.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := r.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.RoutePolicyPatch](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdate(req.Context(), resourceGroupNameParam, routePolicyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		r.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		r.beginUpdate.remove(req)
	}

	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchBeginUpdateAdministrativeState(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdateAdministrativeState == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateAdministrativeState not implemented")}
	}
	beginUpdateAdministrativeState := r.beginUpdateAdministrativeState.get(req)
	if beginUpdateAdministrativeState == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/updateAdministrativeState`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmanagednetworkfabric.UpdateAdministrativeState](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdateAdministrativeState(req.Context(), resourceGroupNameParam, routePolicyNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateAdministrativeState = &respr
		r.beginUpdateAdministrativeState.add(req, beginUpdateAdministrativeState)
	}

	resp, err := server.PollerResponderNext(beginUpdateAdministrativeState, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdateAdministrativeState.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateAdministrativeState) {
		r.beginUpdateAdministrativeState.remove(req)
	}

	return resp, nil
}

func (r *RoutePoliciesServerTransport) dispatchBeginValidateConfiguration(req *http.Request) (*http.Response, error) {
	if r.srv.BeginValidateConfiguration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginValidateConfiguration not implemented")}
	}
	beginValidateConfiguration := r.beginValidateConfiguration.get(req)
	if beginValidateConfiguration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ManagedNetworkFabric/routePolicies/(?P<routePolicyName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/validateConfiguration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		routePolicyNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("routePolicyName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginValidateConfiguration(req.Context(), resourceGroupNameParam, routePolicyNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginValidateConfiguration = &respr
		r.beginValidateConfiguration.add(req, beginValidateConfiguration)
	}

	resp, err := server.PollerResponderNext(beginValidateConfiguration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginValidateConfiguration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginValidateConfiguration) {
		r.beginValidateConfiguration.remove(req)
	}

	return resp, nil
}
