//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/mediaservices/armmediaservices/v3"
	"net/http"
	"net/url"
	"regexp"
)

// LiveOutputsServer is a fake server for instances of the armmediaservices.LiveOutputsClient type.
type LiveOutputsServer struct {
	// AsyncOperation is the fake for method LiveOutputsClient.AsyncOperation
	// HTTP status codes to indicate success: http.StatusOK
	AsyncOperation func(ctx context.Context, resourceGroupName string, accountName string, operationID string, options *armmediaservices.LiveOutputsClientAsyncOperationOptions) (resp azfake.Responder[armmediaservices.LiveOutputsClientAsyncOperationResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method LiveOutputsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreate func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, liveOutputName string, parameters armmediaservices.LiveOutput, options *armmediaservices.LiveOutputsClientBeginCreateOptions) (resp azfake.PollerResponder[armmediaservices.LiveOutputsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method LiveOutputsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, liveOutputName string, options *armmediaservices.LiveOutputsClientBeginDeleteOptions) (resp azfake.PollerResponder[armmediaservices.LiveOutputsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method LiveOutputsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, liveOutputName string, options *armmediaservices.LiveOutputsClientGetOptions) (resp azfake.Responder[armmediaservices.LiveOutputsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method LiveOutputsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, liveEventName string, options *armmediaservices.LiveOutputsClientListOptions) (resp azfake.PagerResponder[armmediaservices.LiveOutputsClientListResponse])

	// OperationLocation is the fake for method LiveOutputsClient.OperationLocation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	OperationLocation func(ctx context.Context, resourceGroupName string, accountName string, liveEventName string, liveOutputName string, operationID string, options *armmediaservices.LiveOutputsClientOperationLocationOptions) (resp azfake.Responder[armmediaservices.LiveOutputsClientOperationLocationResponse], errResp azfake.ErrorResponder)
}

// NewLiveOutputsServerTransport creates a new instance of LiveOutputsServerTransport with the provided implementation.
// The returned LiveOutputsServerTransport instance is connected to an instance of armmediaservices.LiveOutputsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewLiveOutputsServerTransport(srv *LiveOutputsServer) *LiveOutputsServerTransport {
	return &LiveOutputsServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armmediaservices.LiveOutputsClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armmediaservices.LiveOutputsClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armmediaservices.LiveOutputsClientListResponse]](),
	}
}

// LiveOutputsServerTransport connects instances of armmediaservices.LiveOutputsClient to instances of LiveOutputsServer.
// Don't use this type directly, use NewLiveOutputsServerTransport instead.
type LiveOutputsServerTransport struct {
	srv          *LiveOutputsServer
	beginCreate  *tracker[azfake.PollerResponder[armmediaservices.LiveOutputsClientCreateResponse]]
	beginDelete  *tracker[azfake.PollerResponder[armmediaservices.LiveOutputsClientDeleteResponse]]
	newListPager *tracker[azfake.PagerResponder[armmediaservices.LiveOutputsClientListResponse]]
}

// Do implements the policy.Transporter interface for LiveOutputsServerTransport.
func (l *LiveOutputsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "LiveOutputsClient.AsyncOperation":
		resp, err = l.dispatchAsyncOperation(req)
	case "LiveOutputsClient.BeginCreate":
		resp, err = l.dispatchBeginCreate(req)
	case "LiveOutputsClient.BeginDelete":
		resp, err = l.dispatchBeginDelete(req)
	case "LiveOutputsClient.Get":
		resp, err = l.dispatchGet(req)
	case "LiveOutputsClient.NewListPager":
		resp, err = l.dispatchNewListPager(req)
	case "LiveOutputsClient.OperationLocation":
		resp, err = l.dispatchOperationLocation(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (l *LiveOutputsServerTransport) dispatchAsyncOperation(req *http.Request) (*http.Response, error) {
	if l.srv.AsyncOperation == nil {
		return nil, &nonRetriableError{errors.New("fake for method AsyncOperation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveOutputOperations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.AsyncOperation(req.Context(), resourceGroupNameParam, accountNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AsyncOperationResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LiveOutputsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if l.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := l.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveOutputs/(?P<liveOutputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armmediaservices.LiveOutput](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		liveOutputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveOutputName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginCreate(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, liveOutputNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		l.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		l.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		l.beginCreate.remove(req)
	}

	return resp, nil
}

func (l *LiveOutputsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if l.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := l.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveOutputs/(?P<liveOutputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		liveOutputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveOutputName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := l.srv.BeginDelete(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, liveOutputNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		l.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		l.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		l.beginDelete.remove(req)
	}

	return resp, nil
}

func (l *LiveOutputsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if l.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveOutputs/(?P<liveOutputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
	if err != nil {
		return nil, err
	}
	liveOutputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveOutputName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.Get(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, liveOutputNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LiveOutput, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (l *LiveOutputsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if l.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := l.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveOutputs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
		if err != nil {
			return nil, err
		}
		resp := l.srv.NewListPager(resourceGroupNameParam, accountNameParam, liveEventNameParam, nil)
		newListPager = &resp
		l.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armmediaservices.LiveOutputsClientListResponse, createLink func() string) {
			page.ODataNextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		l.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		l.newListPager.remove(req)
	}
	return resp, nil
}

func (l *LiveOutputsServerTransport) dispatchOperationLocation(req *http.Request) (*http.Response, error) {
	if l.srv.OperationLocation == nil {
		return nil, &nonRetriableError{errors.New("fake for method OperationLocation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Media/mediaservices/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveEvents/(?P<liveEventName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/liveOutputs/(?P<liveOutputName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/operationLocations/(?P<operationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	liveEventNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveEventName")])
	if err != nil {
		return nil, err
	}
	liveOutputNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("liveOutputName")])
	if err != nil {
		return nil, err
	}
	operationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("operationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := l.srv.OperationLocation(req.Context(), resourceGroupNameParam, accountNameParam, liveEventNameParam, liveOutputNameParam, operationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LiveOutput, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
