//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armmonitor_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/monitor/armmonitor"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/preview/2023-03-01-preview/examples/createOrUpdateTenantActionGroup.json
func ExampleTenantActionGroupsClient_CreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantActionGroupsClient().CreateOrUpdate(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "testTenantActionGroup", "72f988bf-86f1-41af-91ab-2d7cd011db47", armmonitor.TenantActionGroupResource{
		Location: to.Ptr("Global"),
		Tags:     map[string]*string{},
		Properties: &armmonitor.TenantActionGroup{
			AzureAppPushReceivers: []*armmonitor.AzureAppPushReceiverAutoGenerated{
				{
					Name:         to.Ptr("Sample azureAppPush"),
					EmailAddress: to.Ptr("johndoe@email.com"),
				}},
			EmailReceivers: []*armmonitor.EmailReceiverAutoGenerated{
				{
					Name:                 to.Ptr("John Doe's email"),
					EmailAddress:         to.Ptr("johndoe@email.com"),
					UseCommonAlertSchema: to.Ptr(false),
				},
				{
					Name:                 to.Ptr("Jane Smith's email"),
					EmailAddress:         to.Ptr("janesmith@email.com"),
					UseCommonAlertSchema: to.Ptr(true),
				}},
			Enabled:        to.Ptr(true),
			GroupShortName: to.Ptr("sample"),
			SmsReceivers: []*armmonitor.SmsReceiverAutoGenerated{
				{
					Name:        to.Ptr("John Doe's mobile"),
					CountryCode: to.Ptr("1"),
					PhoneNumber: to.Ptr("2062022299"),
				},
				{
					Name:        to.Ptr("Jane Smith's mobile"),
					CountryCode: to.Ptr("1"),
					PhoneNumber: to.Ptr("0987654321"),
				}},
			VoiceReceivers: []*armmonitor.VoiceReceiverAutoGenerated{
				{
					Name:        to.Ptr("Sample voice"),
					CountryCode: to.Ptr("1"),
					PhoneNumber: to.Ptr("2062022299"),
				}},
			WebhookReceivers: []*armmonitor.WebhookReceiverAutoGenerated{
				{
					Name:                 to.Ptr("Sample webhook 1"),
					ServiceURI:           to.Ptr("http://www.example.com/webhook1"),
					UseCommonAlertSchema: to.Ptr(true),
				},
				{
					Name:                 to.Ptr("Sample webhook 2"),
					IdentifierURI:        to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
					ObjectID:             to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
					ServiceURI:           to.Ptr("http://www.example.com/webhook2"),
					TenantID:             to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
					UseAADAuth:           to.Ptr(true),
					UseCommonAlertSchema: to.Ptr(true),
				}},
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantActionGroupResource = armmonitor.TenantActionGroupResource{
	// 	Name: to.Ptr("testTenantActionGroup"),
	// 	Type: to.Ptr("Microsoft.Insights/TenantActionGroups"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/tenantActionGroups/testTenantActionGroup"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armmonitor.TenantActionGroup{
	// 		EmailReceivers: []*armmonitor.EmailReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("John Doe's email"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's email"),
	// 				EmailAddress: to.Ptr("janesmith@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		Enabled: to.Ptr(true),
	// 		GroupShortName: to.Ptr("sample"),
	// 		SmsReceivers: []*armmonitor.SmsReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("John Doe's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("2062022299"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("0987654321"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 		}},
	// 		VoiceReceivers: []*armmonitor.VoiceReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("Sample voice"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("2062022299"),
	// 		}},
	// 		WebhookReceivers: []*armmonitor.WebhookReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("Sample webhook 1"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook1"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 			},
	// 			{
	// 				Name: to.Ptr("Sample webhook 2"),
	// 				IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
	// 				ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook2"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseAADAuth: to.Ptr(true),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/preview/2023-03-01-preview/examples/getTenantActionGroup.json
func ExampleTenantActionGroupsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantActionGroupsClient().Get(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "testTenantActionGroup", "72f988bf-86f1-41af-91ab-2d7cd011db47", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantActionGroupResource = armmonitor.TenantActionGroupResource{
	// 	Name: to.Ptr("testTenantActionGroup"),
	// 	Type: to.Ptr("Microsoft.Insights/TenantActionGroups"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/tenantActionGroups/testTenantActionGroup"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 	},
	// 	Properties: &armmonitor.TenantActionGroup{
	// 		EmailReceivers: []*armmonitor.EmailReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("John Doe's email"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's email"),
	// 				EmailAddress: to.Ptr("janesmith@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		Enabled: to.Ptr(true),
	// 		GroupShortName: to.Ptr("sample"),
	// 		SmsReceivers: []*armmonitor.SmsReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("John Doe's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("2062022299"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("0987654321"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 		}},
	// 		VoiceReceivers: []*armmonitor.VoiceReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("Sample voice"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("2062022299"),
	// 		}},
	// 		WebhookReceivers: []*armmonitor.WebhookReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("Sample webhook 1"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook1"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 			},
	// 			{
	// 				Name: to.Ptr("Sample webhook 2"),
	// 				IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
	// 				ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook2"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseAADAuth: to.Ptr(true),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/preview/2023-03-01-preview/examples/deleteTenantActionGroup.json
func ExampleTenantActionGroupsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewTenantActionGroupsClient().Delete(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "testTenantActionGroup", "72f988bf-86f1-41af-91ab-2d7cd011db47", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/preview/2023-03-01-preview/examples/patchTenantActionGroup.json
func ExampleTenantActionGroupsClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantActionGroupsClient().Update(ctx, "72f988bf-86f1-41af-91ab-2d7cd011db47", "testTenantActionGroup", "72f988bf-86f1-41af-91ab-2d7cd011db47", armmonitor.ActionGroupPatchBodyAutoGenerated{
		Properties: &armmonitor.ActionGroupPatchAutoGenerated{
			Enabled: to.Ptr(false),
		},
		Tags: map[string]*string{
			"key1": to.Ptr("value1"),
			"key2": to.Ptr("value2"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantActionGroupResource = armmonitor.TenantActionGroupResource{
	// 	Name: to.Ptr("testTenantActionGroup"),
	// 	Type: to.Ptr("Microsoft.Insights/TenantActionGroups"),
	// 	ID: to.Ptr("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/tenantActionGroups/testTenantActionGroup"),
	// 	Location: to.Ptr("Global"),
	// 	Tags: map[string]*string{
	// 		"key1": to.Ptr("value1"),
	// 		"key2": to.Ptr("value2"),
	// 	},
	// 	Properties: &armmonitor.TenantActionGroup{
	// 		EmailReceivers: []*armmonitor.EmailReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("John Doe's email"),
	// 				EmailAddress: to.Ptr("johndoe@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(false),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's email"),
	// 				EmailAddress: to.Ptr("janesmith@email.com"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 		Enabled: to.Ptr(false),
	// 		GroupShortName: to.Ptr("sample"),
	// 		SmsReceivers: []*armmonitor.SmsReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("John Doe's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("2062022299"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 			},
	// 			{
	// 				Name: to.Ptr("Jane Smith's mobile"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("0987654321"),
	// 				Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
	// 		}},
	// 		VoiceReceivers: []*armmonitor.VoiceReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("Sample voice"),
	// 				CountryCode: to.Ptr("1"),
	// 				PhoneNumber: to.Ptr("2062022299"),
	// 		}},
	// 		WebhookReceivers: []*armmonitor.WebhookReceiverAutoGenerated{
	// 			{
	// 				Name: to.Ptr("Sample webhook 1"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook1"),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 			},
	// 			{
	// 				Name: to.Ptr("Sample webhook 2"),
	// 				IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
	// 				ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
	// 				ServiceURI: to.Ptr("http://www.example.com/webhook2"),
	// 				TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
	// 				UseAADAuth: to.Ptr(true),
	// 				UseCommonAlertSchema: to.Ptr(true),
	// 		}},
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/969fd0c2634fbcc1975d7abe3749330a5145a97c/specification/monitor/resource-manager/Microsoft.Insights/preview/2023-03-01-preview/examples/listTenantActionGroups.json
func ExampleTenantActionGroupsClient_NewListByManagementGroupIDPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armmonitor.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewTenantActionGroupsClient().NewListByManagementGroupIDPager("72f988bf-86f1-41af-91ab-2d7cd011db47", "72f988bf-86f1-41af-91ab-2d7cd011db47", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.TenantActionGroupList = armmonitor.TenantActionGroupList{
		// 	Value: []*armmonitor.TenantActionGroupResource{
		// 		{
		// 			Name: to.Ptr("testTenantActionGroup"),
		// 			Type: to.Ptr("Microsoft.Insights/TenantActionGroups"),
		// 			ID: to.Ptr("/providers/Microsoft.Management/managementGroups/72f988bf-86f1-41af-91ab-2d7cd011db47/providers/Microsoft.Insights/tenantActionGroups/testTenantActionGroup"),
		// 			Location: to.Ptr("Global"),
		// 			Tags: map[string]*string{
		// 			},
		// 			Properties: &armmonitor.TenantActionGroup{
		// 				EmailReceivers: []*armmonitor.EmailReceiverAutoGenerated{
		// 					{
		// 						Name: to.Ptr("John Doe's email"),
		// 						EmailAddress: to.Ptr("johndoe@email.com"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 						UseCommonAlertSchema: to.Ptr(false),
		// 					},
		// 					{
		// 						Name: to.Ptr("Jane Smith's email"),
		// 						EmailAddress: to.Ptr("janesmith@email.com"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 				}},
		// 				Enabled: to.Ptr(true),
		// 				GroupShortName: to.Ptr("sample"),
		// 				SmsReceivers: []*armmonitor.SmsReceiverAutoGenerated{
		// 					{
		// 						Name: to.Ptr("John Doe's mobile"),
		// 						CountryCode: to.Ptr("1"),
		// 						PhoneNumber: to.Ptr("2062022299"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 					},
		// 					{
		// 						Name: to.Ptr("Jane Smith's mobile"),
		// 						CountryCode: to.Ptr("1"),
		// 						PhoneNumber: to.Ptr("0987654321"),
		// 						Status: to.Ptr(armmonitor.ReceiverStatusEnabled),
		// 				}},
		// 				VoiceReceivers: []*armmonitor.VoiceReceiverAutoGenerated{
		// 					{
		// 						Name: to.Ptr("Sample voice"),
		// 						CountryCode: to.Ptr("1"),
		// 						PhoneNumber: to.Ptr("2062022299"),
		// 				}},
		// 				WebhookReceivers: []*armmonitor.WebhookReceiverAutoGenerated{
		// 					{
		// 						Name: to.Ptr("Sample webhook 1"),
		// 						ServiceURI: to.Ptr("http://www.example.com/webhook1"),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 					},
		// 					{
		// 						Name: to.Ptr("Sample webhook 2"),
		// 						IdentifierURI: to.Ptr("http://someidentifier/d7811ba3-7996-4a93-99b6-6b2f3f355f8a"),
		// 						ObjectID: to.Ptr("d3bb868c-fe44-452c-aa26-769a6538c808"),
		// 						ServiceURI: to.Ptr("http://www.example.com/webhook2"),
		// 						TenantID: to.Ptr("68a4459a-ccb8-493c-b9da-dd30457d1b84"),
		// 						UseAADAuth: to.Ptr(true),
		// 						UseCommonAlertSchema: to.Ptr(true),
		// 				}},
		// 			},
		// 	}},
		// }
	}
}
