//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armpolicyinsights_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/policyinsights/armpolicyinsights"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/05a9cdab363b8ec824094ee73950c04594325172/specification/policyinsights/resource-manager/Microsoft.PolicyInsights/stable/2019-10-01/examples/PolicyStates_ListOperations.json
func ExampleOperationsClient_List() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armpolicyinsights.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewOperationsClient().List(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationsListResults = armpolicyinsights.OperationsListResults{
	// 	ODataCount: to.Ptr[int32](3),
	// 	Value: []*armpolicyinsights.Operation{
	// 		{
	// 			Name: to.Ptr("Microsoft.PolicyInsights/policyEvents/queryResults/action"),
	// 			Display: &armpolicyinsights.OperationDisplay{
	// 				Description: to.Ptr("Query information about policy events."),
	// 				Operation: to.Ptr("Query Policy Events"),
	// 				Provider: to.Ptr("Microsoft Policy Insights"),
	// 				Resource: to.Ptr("Policy Events"),
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("Microsoft.PolicyInsights/policyStates/queryResults/action"),
	// 			Display: &armpolicyinsights.OperationDisplay{
	// 				Description: to.Ptr("Query information about policy states."),
	// 				Operation: to.Ptr("Query Policy States"),
	// 				Provider: to.Ptr("Microsoft Policy Insights"),
	// 				Resource: to.Ptr("Policy States"),
	// 			},
	// 		},
	// 		{
	// 			Name: to.Ptr("Microsoft.PolicyInsights/policyStates/summarize/action"),
	// 			Display: &armpolicyinsights.OperationDisplay{
	// 				Description: to.Ptr("Query summary information about policy latest states."),
	// 				Operation: to.Ptr("Query Policy Latest States Summary"),
	// 				Provider: to.Ptr("Microsoft Policy Insights"),
	// 				Resource: to.Ptr("Policy States"),
	// 			},
	// 	}},
	// }
}
