//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpurview

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
)

// DefaultAccountsClient contains the methods for the DefaultAccounts group.
// Don't use this type directly, use NewDefaultAccountsClient() instead.
type DefaultAccountsClient struct {
	internal *arm.Client
}

// NewDefaultAccountsClient creates a new instance of DefaultAccountsClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDefaultAccountsClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*DefaultAccountsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DefaultAccountsClient{
		internal: cl,
	}
	return client, nil
}

// Get - Get the default account for the scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-07-01
//   - scopeTenantID - The tenant ID.
//   - scopeType - The scope for the default account.
//   - options - DefaultAccountsClientGetOptions contains the optional parameters for the DefaultAccountsClient.Get method.
func (client *DefaultAccountsClient) Get(ctx context.Context, scopeTenantID string, scopeType ScopeType, options *DefaultAccountsClientGetOptions) (DefaultAccountsClientGetResponse, error) {
	var err error
	const operationName = "DefaultAccountsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, scopeTenantID, scopeType, options)
	if err != nil {
		return DefaultAccountsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DefaultAccountsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DefaultAccountsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DefaultAccountsClient) getCreateRequest(ctx context.Context, scopeTenantID string, scopeType ScopeType, options *DefaultAccountsClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Purview/getDefaultAccount"
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("scopeTenantId", scopeTenantID)
	reqQP.Set("scopeType", string(scopeType))
	if options != nil && options.Scope != nil {
		reqQP.Set("scope", *options.Scope)
	}
	reqQP.Set("api-version", "2021-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DefaultAccountsClient) getHandleResponse(resp *http.Response) (DefaultAccountsClientGetResponse, error) {
	result := DefaultAccountsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DefaultAccountPayload); err != nil {
		return DefaultAccountsClientGetResponse{}, err
	}
	return result, nil
}

// Remove - Removes the default account from the scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-07-01
//   - scopeTenantID - The tenant ID.
//   - scopeType - The scope for the default account.
//   - options - DefaultAccountsClientRemoveOptions contains the optional parameters for the DefaultAccountsClient.Remove method.
func (client *DefaultAccountsClient) Remove(ctx context.Context, scopeTenantID string, scopeType ScopeType, options *DefaultAccountsClientRemoveOptions) (DefaultAccountsClientRemoveResponse, error) {
	var err error
	const operationName = "DefaultAccountsClient.Remove"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.removeCreateRequest(ctx, scopeTenantID, scopeType, options)
	if err != nil {
		return DefaultAccountsClientRemoveResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DefaultAccountsClientRemoveResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DefaultAccountsClientRemoveResponse{}, err
	}
	return DefaultAccountsClientRemoveResponse{}, nil
}

// removeCreateRequest creates the Remove request.
func (client *DefaultAccountsClient) removeCreateRequest(ctx context.Context, scopeTenantID string, scopeType ScopeType, options *DefaultAccountsClientRemoveOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Purview/removeDefaultAccount"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("scopeTenantId", scopeTenantID)
	reqQP.Set("scopeType", string(scopeType))
	if options != nil && options.Scope != nil {
		reqQP.Set("scope", *options.Scope)
	}
	reqQP.Set("api-version", "2021-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Set - Sets the default account for the scope.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2021-07-01
//   - defaultAccountPayload - The payload containing the default account information and the scope.
//   - options - DefaultAccountsClientSetOptions contains the optional parameters for the DefaultAccountsClient.Set method.
func (client *DefaultAccountsClient) Set(ctx context.Context, defaultAccountPayload DefaultAccountPayload, options *DefaultAccountsClientSetOptions) (DefaultAccountsClientSetResponse, error) {
	var err error
	const operationName = "DefaultAccountsClient.Set"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.setCreateRequest(ctx, defaultAccountPayload, options)
	if err != nil {
		return DefaultAccountsClientSetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DefaultAccountsClientSetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DefaultAccountsClientSetResponse{}, err
	}
	resp, err := client.setHandleResponse(httpResp)
	return resp, err
}

// setCreateRequest creates the Set request.
func (client *DefaultAccountsClient) setCreateRequest(ctx context.Context, defaultAccountPayload DefaultAccountPayload, options *DefaultAccountsClientSetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Purview/setDefaultAccount"
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-07-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, defaultAccountPayload); err != nil {
		return nil, err
	}
	return req, nil
}

// setHandleResponse handles the Set response.
func (client *DefaultAccountsClient) setHandleResponse(resp *http.Response) (DefaultAccountsClientSetResponse, error) {
	result := DefaultAccountsClientSetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DefaultAccountPayload); err != nil {
		return DefaultAccountsClientSetResponse{}, err
	}
	return result, nil
}
