//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationProtectionContainersServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationProtectionContainersClient type.
type ReplicationProtectionContainersServer struct {
	// BeginCreate is the fake for method ReplicationProtectionContainersClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, creationInput armrecoveryservicessiterecovery.CreateProtectionContainerInput, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientBeginCreateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ReplicationProtectionContainersClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientBeginDeleteOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDiscoverProtectableItem is the fake for method ReplicationProtectionContainersClient.BeginDiscoverProtectableItem
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDiscoverProtectableItem func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, discoverProtectableItemRequest armrecoveryservicessiterecovery.DiscoverProtectableItemRequest, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientBeginDiscoverProtectableItemOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientDiscoverProtectableItemResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReplicationProtectionContainersClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ReplicationProtectionContainersClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListResponse])

	// NewListByReplicationFabricsPager is the fake for method ReplicationProtectionContainersClient.NewListByReplicationFabricsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReplicationFabricsPager func(resourceName string, resourceGroupName string, fabricName string, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListByReplicationFabricsOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListByReplicationFabricsResponse])

	// BeginSwitchProtection is the fake for method ReplicationProtectionContainersClient.BeginSwitchProtection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginSwitchProtection func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, switchInput armrecoveryservicessiterecovery.SwitchProtectionInput, options *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientBeginSwitchProtectionOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientSwitchProtectionResponse], errResp azfake.ErrorResponder)
}

// NewReplicationProtectionContainersServerTransport creates a new instance of ReplicationProtectionContainersServerTransport with the provided implementation.
// The returned ReplicationProtectionContainersServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationProtectionContainersClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationProtectionContainersServerTransport(srv *ReplicationProtectionContainersServer) *ReplicationProtectionContainersServerTransport {
	return &ReplicationProtectionContainersServerTransport{
		srv:                              srv,
		beginCreate:                      newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientCreateResponse]](),
		beginDelete:                      newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientDeleteResponse]](),
		beginDiscoverProtectableItem:     newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientDiscoverProtectableItemResponse]](),
		newListPager:                     newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListResponse]](),
		newListByReplicationFabricsPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListByReplicationFabricsResponse]](),
		beginSwitchProtection:            newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientSwitchProtectionResponse]](),
	}
}

// ReplicationProtectionContainersServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationProtectionContainersClient to instances of ReplicationProtectionContainersServer.
// Don't use this type directly, use NewReplicationProtectionContainersServerTransport instead.
type ReplicationProtectionContainersServerTransport struct {
	srv                              *ReplicationProtectionContainersServer
	beginCreate                      *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientCreateResponse]]
	beginDelete                      *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientDeleteResponse]]
	beginDiscoverProtectableItem     *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientDiscoverProtectableItemResponse]]
	newListPager                     *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListResponse]]
	newListByReplicationFabricsPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListByReplicationFabricsResponse]]
	beginSwitchProtection            *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationProtectionContainersClientSwitchProtectionResponse]]
}

// Do implements the policy.Transporter interface for ReplicationProtectionContainersServerTransport.
func (r *ReplicationProtectionContainersServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationProtectionContainersClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "ReplicationProtectionContainersClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "ReplicationProtectionContainersClient.BeginDiscoverProtectableItem":
		resp, err = r.dispatchBeginDiscoverProtectableItem(req)
	case "ReplicationProtectionContainersClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationProtectionContainersClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReplicationProtectionContainersClient.NewListByReplicationFabricsPager":
		resp, err = r.dispatchNewListByReplicationFabricsPager(req)
	case "ReplicationProtectionContainersClient.BeginSwitchProtection":
		resp, err = r.dispatchBeginSwitchProtection(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.CreateProtectionContainerInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/remove`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchBeginDiscoverProtectableItem(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDiscoverProtectableItem == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDiscoverProtectableItem not implemented")}
	}
	beginDiscoverProtectableItem := r.beginDiscoverProtectableItem.get(req)
	if beginDiscoverProtectableItem == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/discoverProtectableItem`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.DiscoverProtectableItemRequest](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginDiscoverProtectableItem(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDiscoverProtectableItem = &respr
		r.beginDiscoverProtectableItem.add(req, beginDiscoverProtectableItem)
	}

	resp, err := server.PollerResponderNext(beginDiscoverProtectableItem, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginDiscoverProtectableItem.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDiscoverProtectableItem) {
		r.beginDiscoverProtectableItem.remove(req)
	}

	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ProtectionContainer, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListPager(resourceNameParam, resourceGroupNameParam, nil)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchNewListByReplicationFabricsPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReplicationFabricsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReplicationFabricsPager not implemented")}
	}
	newListByReplicationFabricsPager := r.newListByReplicationFabricsPager.get(req)
	if newListByReplicationFabricsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		resp := r.srv.NewListByReplicationFabricsPager(resourceNameParam, resourceGroupNameParam, fabricNameParam, nil)
		newListByReplicationFabricsPager = &resp
		r.newListByReplicationFabricsPager.add(req, newListByReplicationFabricsPager)
		server.PagerResponderInjectNextLinks(newListByReplicationFabricsPager, req, func(page *armrecoveryservicessiterecovery.ReplicationProtectionContainersClientListByReplicationFabricsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReplicationFabricsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReplicationFabricsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReplicationFabricsPager) {
		r.newListByReplicationFabricsPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationProtectionContainersServerTransport) dispatchBeginSwitchProtection(req *http.Request) (*http.Response, error) {
	if r.srv.BeginSwitchProtection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSwitchProtection not implemented")}
	}
	beginSwitchProtection := r.beginSwitchProtection.get(req)
	if beginSwitchProtection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/switchprotection`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.SwitchProtectionInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginSwitchProtection(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSwitchProtection = &respr
		r.beginSwitchProtection.add(req, beginSwitchProtection)
	}

	resp, err := server.PollerResponderNext(beginSwitchProtection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginSwitchProtection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSwitchProtection) {
		r.beginSwitchProtection.remove(req)
	}

	return resp, nil
}
