//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"strings"
	"sync"
)

// ServerFactory is a fake server for instances of the armredhatopenshift.ClientFactory type.
type ServerFactory struct {
	MachinePoolsServer          MachinePoolsServer
	OpenShiftClustersServer     OpenShiftClustersServer
	OpenShiftVersionsServer     OpenShiftVersionsServer
	OperationsServer            OperationsServer
	SecretsServer               SecretsServer
	SyncIdentityProvidersServer SyncIdentityProvidersServer
	SyncSetsServer              SyncSetsServer
}

// NewServerFactoryTransport creates a new instance of ServerFactoryTransport with the provided implementation.
// The returned ServerFactoryTransport instance is connected to an instance of armredhatopenshift.ClientFactory via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerFactoryTransport(srv *ServerFactory) *ServerFactoryTransport {
	return &ServerFactoryTransport{
		srv: srv,
	}
}

// ServerFactoryTransport connects instances of armredhatopenshift.ClientFactory to instances of ServerFactory.
// Don't use this type directly, use NewServerFactoryTransport instead.
type ServerFactoryTransport struct {
	srv                           *ServerFactory
	trMu                          sync.Mutex
	trMachinePoolsServer          *MachinePoolsServerTransport
	trOpenShiftClustersServer     *OpenShiftClustersServerTransport
	trOpenShiftVersionsServer     *OpenShiftVersionsServerTransport
	trOperationsServer            *OperationsServerTransport
	trSecretsServer               *SecretsServerTransport
	trSyncIdentityProvidersServer *SyncIdentityProvidersServerTransport
	trSyncSetsServer              *SyncSetsServerTransport
}

// Do implements the policy.Transporter interface for ServerFactoryTransport.
func (s *ServerFactoryTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	client := method[:strings.Index(method, ".")]
	var resp *http.Response
	var err error

	switch client {
	case "MachinePoolsClient":
		initServer(s, &s.trMachinePoolsServer, func() *MachinePoolsServerTransport { return NewMachinePoolsServerTransport(&s.srv.MachinePoolsServer) })
		resp, err = s.trMachinePoolsServer.Do(req)
	case "OpenShiftClustersClient":
		initServer(s, &s.trOpenShiftClustersServer, func() *OpenShiftClustersServerTransport {
			return NewOpenShiftClustersServerTransport(&s.srv.OpenShiftClustersServer)
		})
		resp, err = s.trOpenShiftClustersServer.Do(req)
	case "OpenShiftVersionsClient":
		initServer(s, &s.trOpenShiftVersionsServer, func() *OpenShiftVersionsServerTransport {
			return NewOpenShiftVersionsServerTransport(&s.srv.OpenShiftVersionsServer)
		})
		resp, err = s.trOpenShiftVersionsServer.Do(req)
	case "OperationsClient":
		initServer(s, &s.trOperationsServer, func() *OperationsServerTransport { return NewOperationsServerTransport(&s.srv.OperationsServer) })
		resp, err = s.trOperationsServer.Do(req)
	case "SecretsClient":
		initServer(s, &s.trSecretsServer, func() *SecretsServerTransport { return NewSecretsServerTransport(&s.srv.SecretsServer) })
		resp, err = s.trSecretsServer.Do(req)
	case "SyncIdentityProvidersClient":
		initServer(s, &s.trSyncIdentityProvidersServer, func() *SyncIdentityProvidersServerTransport {
			return NewSyncIdentityProvidersServerTransport(&s.srv.SyncIdentityProvidersServer)
		})
		resp, err = s.trSyncIdentityProvidersServer.Do(req)
	case "SyncSetsClient":
		initServer(s, &s.trSyncSetsServer, func() *SyncSetsServerTransport { return NewSyncSetsServerTransport(&s.srv.SyncSetsServer) })
		resp, err = s.trSyncSetsServer.Do(req)
	default:
		err = fmt.Errorf("unhandled client %s", client)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func initServer[T any](s *ServerFactoryTransport, dst **T, src func() *T) {
	s.trMu.Lock()
	if *dst == nil {
		*dst = src()
	}
	s.trMu.Unlock()
}
