//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/reservations/armreservations/v3"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// AzureReservationAPIServer is a fake server for instances of the armreservations.AzureReservationAPIClient type.
type AzureReservationAPIServer struct {
	// GetAppliedReservationList is the fake for method AzureReservationAPIClient.GetAppliedReservationList
	// HTTP status codes to indicate success: http.StatusOK
	GetAppliedReservationList func(ctx context.Context, subscriptionID string, options *armreservations.AzureReservationAPIClientGetAppliedReservationListOptions) (resp azfake.Responder[armreservations.AzureReservationAPIClientGetAppliedReservationListResponse], errResp azfake.ErrorResponder)

	// NewGetCatalogPager is the fake for method AzureReservationAPIClient.NewGetCatalogPager
	// HTTP status codes to indicate success: http.StatusOK
	NewGetCatalogPager func(subscriptionID string, options *armreservations.AzureReservationAPIClientGetCatalogOptions) (resp azfake.PagerResponder[armreservations.AzureReservationAPIClientGetCatalogResponse])
}

// NewAzureReservationAPIServerTransport creates a new instance of AzureReservationAPIServerTransport with the provided implementation.
// The returned AzureReservationAPIServerTransport instance is connected to an instance of armreservations.AzureReservationAPIClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAzureReservationAPIServerTransport(srv *AzureReservationAPIServer) *AzureReservationAPIServerTransport {
	return &AzureReservationAPIServerTransport{
		srv:                srv,
		newGetCatalogPager: newTracker[azfake.PagerResponder[armreservations.AzureReservationAPIClientGetCatalogResponse]](),
	}
}

// AzureReservationAPIServerTransport connects instances of armreservations.AzureReservationAPIClient to instances of AzureReservationAPIServer.
// Don't use this type directly, use NewAzureReservationAPIServerTransport instead.
type AzureReservationAPIServerTransport struct {
	srv                *AzureReservationAPIServer
	newGetCatalogPager *tracker[azfake.PagerResponder[armreservations.AzureReservationAPIClientGetCatalogResponse]]
}

// Do implements the policy.Transporter interface for AzureReservationAPIServerTransport.
func (a *AzureReservationAPIServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AzureReservationAPIClient.GetAppliedReservationList":
		resp, err = a.dispatchGetAppliedReservationList(req)
	case "AzureReservationAPIClient.NewGetCatalogPager":
		resp, err = a.dispatchNewGetCatalogPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AzureReservationAPIServerTransport) dispatchGetAppliedReservationList(req *http.Request) (*http.Response, error) {
	if a.srv.GetAppliedReservationList == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetAppliedReservationList not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/appliedReservations`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetAppliedReservationList(req.Context(), subscriptionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AppliedReservations, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AzureReservationAPIServerTransport) dispatchNewGetCatalogPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewGetCatalogPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewGetCatalogPager not implemented")}
	}
	newGetCatalogPager := a.newGetCatalogPager.get(req)
	if newGetCatalogPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Capacity/catalogs`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		subscriptionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("subscriptionId")])
		if err != nil {
			return nil, err
		}
		reservedResourceTypeUnescaped, err := url.QueryUnescape(qp.Get("reservedResourceType"))
		if err != nil {
			return nil, err
		}
		reservedResourceTypeParam := getOptional(reservedResourceTypeUnescaped)
		locationUnescaped, err := url.QueryUnescape(qp.Get("location"))
		if err != nil {
			return nil, err
		}
		locationParam := getOptional(locationUnescaped)
		publisherIDUnescaped, err := url.QueryUnescape(qp.Get("publisherId"))
		if err != nil {
			return nil, err
		}
		publisherIDParam := getOptional(publisherIDUnescaped)
		offerIDUnescaped, err := url.QueryUnescape(qp.Get("offerId"))
		if err != nil {
			return nil, err
		}
		offerIDParam := getOptional(offerIDUnescaped)
		planIDUnescaped, err := url.QueryUnescape(qp.Get("planId"))
		if err != nil {
			return nil, err
		}
		planIDParam := getOptional(planIDUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		skipUnescaped, err := url.QueryUnescape(qp.Get("$skip"))
		if err != nil {
			return nil, err
		}
		skipParam, err := parseOptional(skipUnescaped, func(v string) (float32, error) {
			p, parseErr := strconv.ParseFloat(v, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return float32(p), nil
		})
		if err != nil {
			return nil, err
		}
		takeUnescaped, err := url.QueryUnescape(qp.Get("$take"))
		if err != nil {
			return nil, err
		}
		takeParam, err := parseOptional(takeUnescaped, func(v string) (float32, error) {
			p, parseErr := strconv.ParseFloat(v, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return float32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armreservations.AzureReservationAPIClientGetCatalogOptions
		if reservedResourceTypeParam != nil || locationParam != nil || publisherIDParam != nil || offerIDParam != nil || planIDParam != nil || filterParam != nil || skipParam != nil || takeParam != nil {
			options = &armreservations.AzureReservationAPIClientGetCatalogOptions{
				ReservedResourceType: reservedResourceTypeParam,
				Location:             locationParam,
				PublisherID:          publisherIDParam,
				OfferID:              offerIDParam,
				PlanID:               planIDParam,
				Filter:               filterParam,
				Skip:                 skipParam,
				Take:                 takeParam,
			}
		}
		resp := a.srv.NewGetCatalogPager(subscriptionIDParam, options)
		newGetCatalogPager = &resp
		a.newGetCatalogPager.add(req, newGetCatalogPager)
		server.PagerResponderInjectNextLinks(newGetCatalogPager, req, func(page *armreservations.AzureReservationAPIClientGetCatalogResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newGetCatalogPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newGetCatalogPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newGetCatalogPager) {
		a.newGetCatalogPager.remove(req)
	}
	return resp, nil
}
