//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armreservations

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AppliedReservationList.
func (a AppliedReservationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppliedReservationList.
func (a *AppliedReservationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppliedReservations.
func (a AppliedReservations) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppliedReservations.
func (a *AppliedReservations) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppliedReservationsProperties.
func (a AppliedReservationsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reservationOrderIds", a.ReservationOrderIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppliedReservationsProperties.
func (a *AppliedReservationsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reservationOrderIds":
			err = unpopulate(val, "ReservationOrderIDs", &a.ReservationOrderIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AppliedScopeProperties.
func (a AppliedScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "managementGroupId", a.ManagementGroupID)
	populate(objectMap, "resourceGroupId", a.ResourceGroupID)
	populate(objectMap, "subscriptionId", a.SubscriptionID)
	populate(objectMap, "tenantId", a.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AppliedScopeProperties.
func (a *AppliedScopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "managementGroupId":
			err = unpopulate(val, "ManagementGroupID", &a.ManagementGroupID)
			delete(rawMsg, key)
		case "resourceGroupId":
			err = unpopulate(val, "ResourceGroupID", &a.ResourceGroupID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &a.SubscriptionID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &a.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableScopeProperties.
func (a AvailableScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableScopeProperties.
func (a *AvailableScopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableScopeRequest.
func (a AvailableScopeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableScopeRequest.
func (a *AvailableScopeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AvailableScopeRequestProperties.
func (a AvailableScopeRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scopes", a.Scopes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AvailableScopeRequestProperties.
func (a *AvailableScopeRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scopes":
			err = unpopulate(val, "Scopes", &a.Scopes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingInformation.
func (b BillingInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyProratedAmount", b.BillingCurrencyProratedAmount)
	populate(objectMap, "billingCurrencyRemainingCommitmentAmount", b.BillingCurrencyRemainingCommitmentAmount)
	populate(objectMap, "billingCurrencyTotalPaidAmount", b.BillingCurrencyTotalPaidAmount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingInformation.
func (b *BillingInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyProratedAmount":
			err = unpopulate(val, "BillingCurrencyProratedAmount", &b.BillingCurrencyProratedAmount)
			delete(rawMsg, key)
		case "billingCurrencyRemainingCommitmentAmount":
			err = unpopulate(val, "BillingCurrencyRemainingCommitmentAmount", &b.BillingCurrencyRemainingCommitmentAmount)
			delete(rawMsg, key)
		case "billingCurrencyTotalPaidAmount":
			err = unpopulate(val, "BillingCurrencyTotalPaidAmount", &b.BillingCurrencyTotalPaidAmount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateExchangeOperationResultResponse.
func (c CalculateExchangeOperationResultResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "status", c.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateExchangeOperationResultResponse.
func (c *CalculateExchangeOperationResultResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &c.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateExchangeRequest.
func (c CalculateExchangeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateExchangeRequest.
func (c *CalculateExchangeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateExchangeRequestProperties.
func (c CalculateExchangeRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reservationsToExchange", c.ReservationsToExchange)
	populate(objectMap, "reservationsToPurchase", c.ReservationsToPurchase)
	populate(objectMap, "savingsPlansToPurchase", c.SavingsPlansToPurchase)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateExchangeRequestProperties.
func (c *CalculateExchangeRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reservationsToExchange":
			err = unpopulate(val, "ReservationsToExchange", &c.ReservationsToExchange)
			delete(rawMsg, key)
		case "reservationsToPurchase":
			err = unpopulate(val, "ReservationsToPurchase", &c.ReservationsToPurchase)
			delete(rawMsg, key)
		case "savingsPlansToPurchase":
			err = unpopulate(val, "SavingsPlansToPurchase", &c.SavingsPlansToPurchase)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateExchangeResponseProperties.
func (c CalculateExchangeResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "netPayable", c.NetPayable)
	populate(objectMap, "policyResult", c.PolicyResult)
	populate(objectMap, "purchasesTotal", c.PurchasesTotal)
	populate(objectMap, "refundsTotal", c.RefundsTotal)
	populate(objectMap, "reservationsToExchange", c.ReservationsToExchange)
	populate(objectMap, "reservationsToPurchase", c.ReservationsToPurchase)
	populate(objectMap, "savingsPlansToPurchase", c.SavingsPlansToPurchase)
	populate(objectMap, "sessionId", c.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateExchangeResponseProperties.
func (c *CalculateExchangeResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "netPayable":
			err = unpopulate(val, "NetPayable", &c.NetPayable)
			delete(rawMsg, key)
		case "policyResult":
			err = unpopulate(val, "PolicyResult", &c.PolicyResult)
			delete(rawMsg, key)
		case "purchasesTotal":
			err = unpopulate(val, "PurchasesTotal", &c.PurchasesTotal)
			delete(rawMsg, key)
		case "refundsTotal":
			err = unpopulate(val, "RefundsTotal", &c.RefundsTotal)
			delete(rawMsg, key)
		case "reservationsToExchange":
			err = unpopulate(val, "ReservationsToExchange", &c.ReservationsToExchange)
			delete(rawMsg, key)
		case "reservationsToPurchase":
			err = unpopulate(val, "ReservationsToPurchase", &c.ReservationsToPurchase)
			delete(rawMsg, key)
		case "savingsPlansToPurchase":
			err = unpopulate(val, "SavingsPlansToPurchase", &c.SavingsPlansToPurchase)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &c.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculatePriceResponse.
func (c CalculatePriceResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculatePriceResponse.
func (c *CalculatePriceResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculatePriceResponseProperties.
func (c CalculatePriceResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyTotal", c.BillingCurrencyTotal)
	populate(objectMap, "grandTotal", c.GrandTotal)
	populate(objectMap, "isBillingPartnerManaged", c.IsBillingPartnerManaged)
	populate(objectMap, "isTaxIncluded", c.IsTaxIncluded)
	populate(objectMap, "netTotal", c.NetTotal)
	populate(objectMap, "paymentSchedule", c.PaymentSchedule)
	populate(objectMap, "pricingCurrencyTotal", c.PricingCurrencyTotal)
	populate(objectMap, "reservationOrderId", c.ReservationOrderID)
	populate(objectMap, "skuDescription", c.SKUDescription)
	populate(objectMap, "skuTitle", c.SKUTitle)
	populate(objectMap, "taxTotal", c.TaxTotal)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculatePriceResponseProperties.
func (c *CalculatePriceResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &c.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "grandTotal":
			err = unpopulate(val, "GrandTotal", &c.GrandTotal)
			delete(rawMsg, key)
		case "isBillingPartnerManaged":
			err = unpopulate(val, "IsBillingPartnerManaged", &c.IsBillingPartnerManaged)
			delete(rawMsg, key)
		case "isTaxIncluded":
			err = unpopulate(val, "IsTaxIncluded", &c.IsTaxIncluded)
			delete(rawMsg, key)
		case "netTotal":
			err = unpopulate(val, "NetTotal", &c.NetTotal)
			delete(rawMsg, key)
		case "paymentSchedule":
			err = unpopulate(val, "PaymentSchedule", &c.PaymentSchedule)
			delete(rawMsg, key)
		case "pricingCurrencyTotal":
			err = unpopulate(val, "PricingCurrencyTotal", &c.PricingCurrencyTotal)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &c.ReservationOrderID)
			delete(rawMsg, key)
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &c.SKUDescription)
			delete(rawMsg, key)
		case "skuTitle":
			err = unpopulate(val, "SKUTitle", &c.SKUTitle)
			delete(rawMsg, key)
		case "taxTotal":
			err = unpopulate(val, "TaxTotal", &c.TaxTotal)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculatePriceResponsePropertiesBillingCurrencyTotal.
func (c CalculatePriceResponsePropertiesBillingCurrencyTotal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", c.Amount)
	populate(objectMap, "currencyCode", c.CurrencyCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculatePriceResponsePropertiesBillingCurrencyTotal.
func (c *CalculatePriceResponsePropertiesBillingCurrencyTotal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &c.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &c.CurrencyCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculatePriceResponsePropertiesPricingCurrencyTotal.
func (c CalculatePriceResponsePropertiesPricingCurrencyTotal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", c.Amount)
	populate(objectMap, "currencyCode", c.CurrencyCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculatePriceResponsePropertiesPricingCurrencyTotal.
func (c *CalculatePriceResponsePropertiesPricingCurrencyTotal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &c.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &c.CurrencyCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateRefundRequest.
func (c CalculateRefundRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateRefundRequest.
func (c *CalculateRefundRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateRefundRequestProperties.
func (c CalculateRefundRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reservationToReturn", c.ReservationToReturn)
	populate(objectMap, "scope", c.Scope)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateRefundRequestProperties.
func (c *CalculateRefundRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reservationToReturn":
			err = unpopulate(val, "ReservationToReturn", &c.ReservationToReturn)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &c.Scope)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CalculateRefundResponse.
func (c CalculateRefundResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CalculateRefundResponse.
func (c *CalculateRefundResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Catalog.
func (c Catalog) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingPlans", c.BillingPlans)
	populate(objectMap, "capabilities", c.Capabilities)
	populate(objectMap, "locations", c.Locations)
	populate(objectMap, "msrp", c.Msrp)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "resourceType", c.ResourceType)
	populate(objectMap, "restrictions", c.Restrictions)
	populate(objectMap, "skuProperties", c.SKUProperties)
	populate(objectMap, "size", c.Size)
	populate(objectMap, "terms", c.Terms)
	populate(objectMap, "tier", c.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Catalog.
func (c *Catalog) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingPlans":
			err = unpopulate(val, "BillingPlans", &c.BillingPlans)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &c.Capabilities)
			delete(rawMsg, key)
		case "locations":
			err = unpopulate(val, "Locations", &c.Locations)
			delete(rawMsg, key)
		case "msrp":
			err = unpopulate(val, "Msrp", &c.Msrp)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &c.ResourceType)
			delete(rawMsg, key)
		case "restrictions":
			err = unpopulate(val, "Restrictions", &c.Restrictions)
			delete(rawMsg, key)
		case "skuProperties":
			err = unpopulate(val, "SKUProperties", &c.SKUProperties)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &c.Size)
			delete(rawMsg, key)
		case "terms":
			err = unpopulate(val, "Terms", &c.Terms)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &c.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CatalogMsrp.
func (c CatalogMsrp) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "p1Y", c.P1Y)
	populate(objectMap, "p3Y", c.P3Y)
	populate(objectMap, "p5Y", c.P5Y)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CatalogMsrp.
func (c *CatalogMsrp) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "p1Y":
			err = unpopulate(val, "P1Y", &c.P1Y)
			delete(rawMsg, key)
		case "p3Y":
			err = unpopulate(val, "P3Y", &c.P3Y)
			delete(rawMsg, key)
		case "p5Y":
			err = unpopulate(val, "P5Y", &c.P5Y)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CatalogsResult.
func (c CatalogsResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "totalItems", c.TotalItems)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CatalogsResult.
func (c *CatalogsResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "totalItems":
			err = unpopulate(val, "TotalItems", &c.TotalItems)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDirectoryRequest.
func (c ChangeDirectoryRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "destinationTenantId", c.DestinationTenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDirectoryRequest.
func (c *ChangeDirectoryRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "destinationTenantId":
			err = unpopulate(val, "DestinationTenantID", &c.DestinationTenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDirectoryResponse.
func (c ChangeDirectoryResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reservationOrder", c.ReservationOrder)
	populate(objectMap, "reservations", c.Reservations)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDirectoryResponse.
func (c *ChangeDirectoryResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reservationOrder":
			err = unpopulate(val, "ReservationOrder", &c.ReservationOrder)
			delete(rawMsg, key)
		case "reservations":
			err = unpopulate(val, "Reservations", &c.Reservations)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ChangeDirectoryResult.
func (c ChangeDirectoryResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", c.Error)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "isSucceeded", c.IsSucceeded)
	populate(objectMap, "name", c.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ChangeDirectoryResult.
func (c *ChangeDirectoryResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &c.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "isSucceeded":
			err = unpopulate(val, "IsSucceeded", &c.IsSucceeded)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Commitment.
func (c Commitment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", c.Amount)
	populate(objectMap, "currencyCode", c.CurrencyCode)
	populate(objectMap, "grain", c.Grain)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Commitment.
func (c *Commitment) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &c.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &c.CurrencyCode)
			delete(rawMsg, key)
		case "grain":
			err = unpopulate(val, "Grain", &c.Grain)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreateGenericQuotaRequestParameters.
func (c CreateGenericQuotaRequestParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreateGenericQuotaRequestParameters.
func (c *CreateGenericQuotaRequestParameters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CurrentQuotaLimit.
func (c CurrentQuotaLimit) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "quotaInformation", c.QuotaInformation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentQuotaLimit.
func (c *CurrentQuotaLimit) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "quotaInformation":
			err = unpopulate(val, "QuotaInformation", &c.QuotaInformation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CurrentQuotaLimitBase.
func (c CurrentQuotaLimitBase) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CurrentQuotaLimitBase.
func (c *CurrentQuotaLimitBase) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Error.
func (e Error) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Error.
func (e *Error) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetails.
func (e ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetails.
func (e *ErrorDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExceptionResponse.
func (e ExceptionResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExceptionResponse.
func (e *ExceptionResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExchangeOperationResultResponse.
func (e ExchangeOperationResultResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "status", e.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExchangeOperationResultResponse.
func (e *ExchangeOperationResultResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &e.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExchangePolicyError.
func (e ExchangePolicyError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExchangePolicyError.
func (e *ExchangePolicyError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExchangePolicyErrors.
func (e ExchangePolicyErrors) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "policyErrors", e.PolicyErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExchangePolicyErrors.
func (e *ExchangePolicyErrors) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "policyErrors":
			err = unpopulate(val, "PolicyErrors", &e.PolicyErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExchangeRequest.
func (e ExchangeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", e.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExchangeRequest.
func (e *ExchangeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExchangeRequestProperties.
func (e ExchangeRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sessionId", e.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExchangeRequestProperties.
func (e *ExchangeRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sessionId":
			err = unpopulate(val, "SessionID", &e.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExchangeResponseProperties.
func (e ExchangeResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "netPayable", e.NetPayable)
	populate(objectMap, "policyResult", e.PolicyResult)
	populate(objectMap, "purchasesTotal", e.PurchasesTotal)
	populate(objectMap, "refundsTotal", e.RefundsTotal)
	populate(objectMap, "reservationsToExchange", e.ReservationsToExchange)
	populate(objectMap, "reservationsToPurchase", e.ReservationsToPurchase)
	populate(objectMap, "savingsPlansToPurchase", e.SavingsPlansToPurchase)
	populate(objectMap, "sessionId", e.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExchangeResponseProperties.
func (e *ExchangeResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "netPayable":
			err = unpopulate(val, "NetPayable", &e.NetPayable)
			delete(rawMsg, key)
		case "policyResult":
			err = unpopulate(val, "PolicyResult", &e.PolicyResult)
			delete(rawMsg, key)
		case "purchasesTotal":
			err = unpopulate(val, "PurchasesTotal", &e.PurchasesTotal)
			delete(rawMsg, key)
		case "refundsTotal":
			err = unpopulate(val, "RefundsTotal", &e.RefundsTotal)
			delete(rawMsg, key)
		case "reservationsToExchange":
			err = unpopulate(val, "ReservationsToExchange", &e.ReservationsToExchange)
			delete(rawMsg, key)
		case "reservationsToPurchase":
			err = unpopulate(val, "ReservationsToPurchase", &e.ReservationsToPurchase)
			delete(rawMsg, key)
		case "savingsPlansToPurchase":
			err = unpopulate(val, "SavingsPlansToPurchase", &e.SavingsPlansToPurchase)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &e.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedErrorInfo.
func (e ExtendedErrorInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedErrorInfo.
func (e *ExtendedErrorInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedStatusInfo.
func (e ExtendedStatusInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "statusCode", e.StatusCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedStatusInfo.
func (e *ExtendedStatusInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, "StatusCode", &e.StatusCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListResult.
func (l ListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", l.NextLink)
	populate(objectMap, "summary", l.Summary)
	populate(objectMap, "value", l.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListResult.
func (l *ListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &l.NextLink)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &l.Summary)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &l.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MergeProperties.
func (m MergeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sources", m.Sources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MergeProperties.
func (m *MergeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sources":
			err = unpopulate(val, "Sources", &m.Sources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MergeRequest.
func (m MergeRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", m.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MergeRequest.
func (m *MergeRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationList.
func (o OperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationList.
func (o *OperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResponse.
func (o OperationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	populateAny(objectMap, "properties", o.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResponse.
func (o *OperationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationResultError.
func (o OperationResultError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", o.Code)
	populate(objectMap, "message", o.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationResultError.
func (o *OperationResultError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &o.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &o.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Patch.
func (p Patch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Patch.
func (p *Patch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchProperties.
func (p PatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", p.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", p.AppliedScopeType)
	populate(objectMap, "appliedScopes", p.AppliedScopes)
	populate(objectMap, "instanceFlexibility", p.InstanceFlexibility)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "renew", p.Renew)
	populate(objectMap, "renewProperties", p.RenewProperties)
	populateDateTimeRFC3339(objectMap, "reviewDateTime", p.ReviewDateTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchProperties.
func (p *PatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &p.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &p.AppliedScopeType)
			delete(rawMsg, key)
		case "appliedScopes":
			err = unpopulate(val, "AppliedScopes", &p.AppliedScopes)
			delete(rawMsg, key)
		case "instanceFlexibility":
			err = unpopulate(val, "InstanceFlexibility", &p.InstanceFlexibility)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &p.Renew)
			delete(rawMsg, key)
		case "renewProperties":
			err = unpopulate(val, "RenewProperties", &p.RenewProperties)
			delete(rawMsg, key)
		case "reviewDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewDateTime", &p.ReviewDateTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchPropertiesRenewProperties.
func (p PatchPropertiesRenewProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "purchaseProperties", p.PurchaseProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchPropertiesRenewProperties.
func (p *PatchPropertiesRenewProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "purchaseProperties":
			err = unpopulate(val, "PurchaseProperties", &p.PurchaseProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PaymentDetail.
func (p PaymentDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingAccount", p.BillingAccount)
	populate(objectMap, "billingCurrencyTotal", p.BillingCurrencyTotal)
	populateDateType(objectMap, "dueDate", p.DueDate)
	populate(objectMap, "extendedStatusInfo", p.ExtendedStatusInfo)
	populateDateType(objectMap, "paymentDate", p.PaymentDate)
	populate(objectMap, "pricingCurrencyTotal", p.PricingCurrencyTotal)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PaymentDetail.
func (p *PaymentDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingAccount":
			err = unpopulate(val, "BillingAccount", &p.BillingAccount)
			delete(rawMsg, key)
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &p.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "dueDate":
			err = unpopulateDateType(val, "DueDate", &p.DueDate)
			delete(rawMsg, key)
		case "extendedStatusInfo":
			err = unpopulate(val, "ExtendedStatusInfo", &p.ExtendedStatusInfo)
			delete(rawMsg, key)
		case "paymentDate":
			err = unpopulateDateType(val, "PaymentDate", &p.PaymentDate)
			delete(rawMsg, key)
		case "pricingCurrencyTotal":
			err = unpopulate(val, "PricingCurrencyTotal", &p.PricingCurrencyTotal)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Price.
func (p Price) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", p.Amount)
	populate(objectMap, "currencyCode", p.CurrencyCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Price.
func (p *Price) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &p.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &p.CurrencyCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", p.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", p.AppliedScopeType)
	populate(objectMap, "appliedScopes", p.AppliedScopes)
	populate(objectMap, "archived", p.Archived)
	populateDateTimeRFC3339(objectMap, "benefitStartTime", p.BenefitStartTime)
	populate(objectMap, "billingPlan", p.BillingPlan)
	populate(objectMap, "billingScopeId", p.BillingScopeID)
	populate(objectMap, "capabilities", p.Capabilities)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "displayProvisioningState", p.DisplayProvisioningState)
	populateDateTimeRFC3339(objectMap, "effectiveDateTime", p.EffectiveDateTime)
	populateDateType(objectMap, "expiryDate", p.ExpiryDate)
	populateDateTimeRFC3339(objectMap, "expiryDateTime", p.ExpiryDateTime)
	populate(objectMap, "extendedStatusInfo", p.ExtendedStatusInfo)
	populate(objectMap, "instanceFlexibility", p.InstanceFlexibility)
	populateDateTimeRFC3339(objectMap, "lastUpdatedDateTime", p.LastUpdatedDateTime)
	populate(objectMap, "mergeProperties", p.MergeProperties)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "provisioningSubState", p.ProvisioningSubState)
	populateDateType(objectMap, "purchaseDate", p.PurchaseDate)
	populateDateTimeRFC3339(objectMap, "purchaseDateTime", p.PurchaseDateTime)
	populate(objectMap, "quantity", p.Quantity)
	populate(objectMap, "renew", p.Renew)
	populate(objectMap, "renewDestination", p.RenewDestination)
	populate(objectMap, "renewProperties", p.RenewProperties)
	populate(objectMap, "renewSource", p.RenewSource)
	populate(objectMap, "reservedResourceType", p.ReservedResourceType)
	populateDateTimeRFC3339(objectMap, "reviewDateTime", p.ReviewDateTime)
	populate(objectMap, "skuDescription", p.SKUDescription)
	populate(objectMap, "splitProperties", p.SplitProperties)
	populate(objectMap, "swapProperties", p.SwapProperties)
	populate(objectMap, "term", p.Term)
	populate(objectMap, "userFriendlyAppliedScopeType", p.UserFriendlyAppliedScopeType)
	populate(objectMap, "userFriendlyRenewState", p.UserFriendlyRenewState)
	populate(objectMap, "utilization", p.Utilization)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Properties.
func (p *Properties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &p.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &p.AppliedScopeType)
			delete(rawMsg, key)
		case "appliedScopes":
			err = unpopulate(val, "AppliedScopes", &p.AppliedScopes)
			delete(rawMsg, key)
		case "archived":
			err = unpopulate(val, "Archived", &p.Archived)
			delete(rawMsg, key)
		case "benefitStartTime":
			err = unpopulateDateTimeRFC3339(val, "BenefitStartTime", &p.BenefitStartTime)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &p.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &p.BillingScopeID)
			delete(rawMsg, key)
		case "capabilities":
			err = unpopulate(val, "Capabilities", &p.Capabilities)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "displayProvisioningState":
			err = unpopulate(val, "DisplayProvisioningState", &p.DisplayProvisioningState)
			delete(rawMsg, key)
		case "effectiveDateTime":
			err = unpopulateDateTimeRFC3339(val, "EffectiveDateTime", &p.EffectiveDateTime)
			delete(rawMsg, key)
		case "expiryDate":
			err = unpopulateDateType(val, "ExpiryDate", &p.ExpiryDate)
			delete(rawMsg, key)
		case "expiryDateTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryDateTime", &p.ExpiryDateTime)
			delete(rawMsg, key)
		case "extendedStatusInfo":
			err = unpopulate(val, "ExtendedStatusInfo", &p.ExtendedStatusInfo)
			delete(rawMsg, key)
		case "instanceFlexibility":
			err = unpopulate(val, "InstanceFlexibility", &p.InstanceFlexibility)
			delete(rawMsg, key)
		case "lastUpdatedDateTime":
			err = unpopulateDateTimeRFC3339(val, "LastUpdatedDateTime", &p.LastUpdatedDateTime)
			delete(rawMsg, key)
		case "mergeProperties":
			err = unpopulate(val, "MergeProperties", &p.MergeProperties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "provisioningSubState":
			err = unpopulate(val, "ProvisioningSubState", &p.ProvisioningSubState)
			delete(rawMsg, key)
		case "purchaseDate":
			err = unpopulateDateType(val, "PurchaseDate", &p.PurchaseDate)
			delete(rawMsg, key)
		case "purchaseDateTime":
			err = unpopulateDateTimeRFC3339(val, "PurchaseDateTime", &p.PurchaseDateTime)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &p.Quantity)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &p.Renew)
			delete(rawMsg, key)
		case "renewDestination":
			err = unpopulate(val, "RenewDestination", &p.RenewDestination)
			delete(rawMsg, key)
		case "renewProperties":
			err = unpopulate(val, "RenewProperties", &p.RenewProperties)
			delete(rawMsg, key)
		case "renewSource":
			err = unpopulate(val, "RenewSource", &p.RenewSource)
			delete(rawMsg, key)
		case "reservedResourceType":
			err = unpopulate(val, "ReservedResourceType", &p.ReservedResourceType)
			delete(rawMsg, key)
		case "reviewDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewDateTime", &p.ReviewDateTime)
			delete(rawMsg, key)
		case "skuDescription":
			err = unpopulate(val, "SKUDescription", &p.SKUDescription)
			delete(rawMsg, key)
		case "splitProperties":
			err = unpopulate(val, "SplitProperties", &p.SplitProperties)
			delete(rawMsg, key)
		case "swapProperties":
			err = unpopulate(val, "SwapProperties", &p.SwapProperties)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &p.Term)
			delete(rawMsg, key)
		case "userFriendlyAppliedScopeType":
			err = unpopulate(val, "UserFriendlyAppliedScopeType", &p.UserFriendlyAppliedScopeType)
			delete(rawMsg, key)
		case "userFriendlyRenewState":
			err = unpopulate(val, "UserFriendlyRenewState", &p.UserFriendlyRenewState)
			delete(rawMsg, key)
		case "utilization":
			err = unpopulate(val, "Utilization", &p.Utilization)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PropertiesUtilization.
func (p PropertiesUtilization) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aggregates", p.Aggregates)
	populate(objectMap, "trend", p.Trend)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PropertiesUtilization.
func (p *PropertiesUtilization) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aggregates":
			err = unpopulate(val, "Aggregates", &p.Aggregates)
			delete(rawMsg, key)
		case "trend":
			err = unpopulate(val, "Trend", &p.Trend)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchaseRequest.
func (p PurchaseRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "sku", p.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseRequest.
func (p *PurchaseRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &p.Location)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &p.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchaseRequestProperties.
func (p PurchaseRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", p.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", p.AppliedScopeType)
	populate(objectMap, "appliedScopes", p.AppliedScopes)
	populate(objectMap, "billingPlan", p.BillingPlan)
	populate(objectMap, "billingScopeId", p.BillingScopeID)
	populate(objectMap, "displayName", p.DisplayName)
	populate(objectMap, "quantity", p.Quantity)
	populate(objectMap, "renew", p.Renew)
	populate(objectMap, "reservedResourceProperties", p.ReservedResourceProperties)
	populate(objectMap, "reservedResourceType", p.ReservedResourceType)
	populateDateTimeRFC3339(objectMap, "reviewDateTime", p.ReviewDateTime)
	populate(objectMap, "term", p.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseRequestProperties.
func (p *PurchaseRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &p.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &p.AppliedScopeType)
			delete(rawMsg, key)
		case "appliedScopes":
			err = unpopulate(val, "AppliedScopes", &p.AppliedScopes)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &p.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &p.BillingScopeID)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &p.Quantity)
			delete(rawMsg, key)
		case "renew":
			err = unpopulate(val, "Renew", &p.Renew)
			delete(rawMsg, key)
		case "reservedResourceProperties":
			err = unpopulate(val, "ReservedResourceProperties", &p.ReservedResourceProperties)
			delete(rawMsg, key)
		case "reservedResourceType":
			err = unpopulate(val, "ReservedResourceType", &p.ReservedResourceType)
			delete(rawMsg, key)
		case "reviewDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewDateTime", &p.ReviewDateTime)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &p.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PurchaseRequestPropertiesReservedResourceProperties.
func (p PurchaseRequestPropertiesReservedResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceFlexibility", p.InstanceFlexibility)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PurchaseRequestPropertiesReservedResourceProperties.
func (p *PurchaseRequestPropertiesReservedResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceFlexibility":
			err = unpopulate(val, "InstanceFlexibility", &p.InstanceFlexibility)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaLimits.
func (q QuotaLimits) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaLimits.
func (q *QuotaLimits) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaLimitsResponse.
func (q QuotaLimitsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaLimitsResponse.
func (q *QuotaLimitsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaProperties.
func (q QuotaProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "currentValue", q.CurrentValue)
	populate(objectMap, "limit", q.Limit)
	populate(objectMap, "name", q.Name)
	populateAny(objectMap, "properties", q.Properties)
	populate(objectMap, "quotaPeriod", q.QuotaPeriod)
	populate(objectMap, "resourceType", q.ResourceType)
	populate(objectMap, "unit", q.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaProperties.
func (q *QuotaProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "currentValue":
			err = unpopulate(val, "CurrentValue", &q.CurrentValue)
			delete(rawMsg, key)
		case "limit":
			err = unpopulate(val, "Limit", &q.Limit)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "quotaPeriod":
			err = unpopulate(val, "QuotaPeriod", &q.QuotaPeriod)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &q.ResourceType)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &q.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestDetails.
func (q QuotaRequestDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.Properties)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestDetails.
func (q *QuotaRequestDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestDetailsList.
func (q QuotaRequestDetailsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestDetailsList.
func (q *QuotaRequestDetailsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestOneResourceProperties.
func (q QuotaRequestOneResourceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", q.Message)
	populate(objectMap, "properties", q.Properties)
	populate(objectMap, "provisioningState", q.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "requestSubmitTime", q.RequestSubmitTime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestOneResourceProperties.
func (q *QuotaRequestOneResourceProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &q.Message)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &q.ProvisioningState)
			delete(rawMsg, key)
		case "requestSubmitTime":
			err = unpopulateDateTimeRFC3339(val, "RequestSubmitTime", &q.RequestSubmitTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestOneResourceSubmitResponse.
func (q QuotaRequestOneResourceSubmitResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.Properties)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestOneResourceSubmitResponse.
func (q *QuotaRequestOneResourceSubmitResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestProperties.
func (q QuotaRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", q.Message)
	populate(objectMap, "provisioningState", q.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "requestSubmitTime", q.RequestSubmitTime)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestProperties.
func (q *QuotaRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &q.Message)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &q.ProvisioningState)
			delete(rawMsg, key)
		case "requestSubmitTime":
			err = unpopulateDateTimeRFC3339(val, "RequestSubmitTime", &q.RequestSubmitTime)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestStatusDetails.
func (q QuotaRequestStatusDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", q.Message)
	populate(objectMap, "provisioningState", q.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestStatusDetails.
func (q *QuotaRequestStatusDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &q.Message)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &q.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestSubmitResponse.
func (q QuotaRequestSubmitResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.Properties)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestSubmitResponse.
func (q *QuotaRequestSubmitResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QuotaRequestSubmitResponse201.
func (q QuotaRequestSubmitResponse201) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", q.ID)
	populate(objectMap, "name", q.Name)
	populate(objectMap, "properties", q.Properties)
	populate(objectMap, "type", q.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QuotaRequestSubmitResponse201.
func (q *QuotaRequestSubmitResponse201) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &q.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &q.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &q.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundBillingInformation.
func (r RefundBillingInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyProratedAmount", r.BillingCurrencyProratedAmount)
	populate(objectMap, "billingCurrencyRemainingCommitmentAmount", r.BillingCurrencyRemainingCommitmentAmount)
	populate(objectMap, "billingCurrencyTotalPaidAmount", r.BillingCurrencyTotalPaidAmount)
	populate(objectMap, "billingPlan", r.BillingPlan)
	populate(objectMap, "completedTransactions", r.CompletedTransactions)
	populate(objectMap, "totalTransactions", r.TotalTransactions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundBillingInformation.
func (r *RefundBillingInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyProratedAmount":
			err = unpopulate(val, "BillingCurrencyProratedAmount", &r.BillingCurrencyProratedAmount)
			delete(rawMsg, key)
		case "billingCurrencyRemainingCommitmentAmount":
			err = unpopulate(val, "BillingCurrencyRemainingCommitmentAmount", &r.BillingCurrencyRemainingCommitmentAmount)
			delete(rawMsg, key)
		case "billingCurrencyTotalPaidAmount":
			err = unpopulate(val, "BillingCurrencyTotalPaidAmount", &r.BillingCurrencyTotalPaidAmount)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &r.BillingPlan)
			delete(rawMsg, key)
		case "completedTransactions":
			err = unpopulate(val, "CompletedTransactions", &r.CompletedTransactions)
			delete(rawMsg, key)
		case "totalTransactions":
			err = unpopulate(val, "TotalTransactions", &r.TotalTransactions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundPolicyError.
func (r RefundPolicyError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", r.Code)
	populate(objectMap, "message", r.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundPolicyError.
func (r *RefundPolicyError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &r.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &r.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundPolicyResult.
func (r RefundPolicyResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundPolicyResult.
func (r *RefundPolicyResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundPolicyResultProperty.
func (r RefundPolicyResultProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "consumedRefundsTotal", r.ConsumedRefundsTotal)
	populate(objectMap, "maxRefundLimit", r.MaxRefundLimit)
	populate(objectMap, "policyErrors", r.PolicyErrors)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundPolicyResultProperty.
func (r *RefundPolicyResultProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "consumedRefundsTotal":
			err = unpopulate(val, "ConsumedRefundsTotal", &r.ConsumedRefundsTotal)
			delete(rawMsg, key)
		case "maxRefundLimit":
			err = unpopulate(val, "MaxRefundLimit", &r.MaxRefundLimit)
			delete(rawMsg, key)
		case "policyErrors":
			err = unpopulate(val, "PolicyErrors", &r.PolicyErrors)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundRequest.
func (r RefundRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundRequest.
func (r *RefundRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundRequestProperties.
func (r RefundRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reservationToReturn", r.ReservationToReturn)
	populate(objectMap, "returnReason", r.ReturnReason)
	populate(objectMap, "scope", r.Scope)
	populate(objectMap, "sessionId", r.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundRequestProperties.
func (r *RefundRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reservationToReturn":
			err = unpopulate(val, "ReservationToReturn", &r.ReservationToReturn)
			delete(rawMsg, key)
		case "returnReason":
			err = unpopulate(val, "ReturnReason", &r.ReturnReason)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &r.Scope)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &r.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundResponse.
func (r RefundResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundResponse.
func (r *RefundResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RefundResponseProperties.
func (r RefundResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingInformation", r.BillingInformation)
	populate(objectMap, "billingRefundAmount", r.BillingRefundAmount)
	populate(objectMap, "policyResult", r.PolicyResult)
	populate(objectMap, "pricingRefundAmount", r.PricingRefundAmount)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "sessionId", r.SessionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RefundResponseProperties.
func (r *RefundResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingInformation":
			err = unpopulate(val, "BillingInformation", &r.BillingInformation)
			delete(rawMsg, key)
		case "billingRefundAmount":
			err = unpopulate(val, "BillingRefundAmount", &r.BillingRefundAmount)
			delete(rawMsg, key)
		case "policyResult":
			err = unpopulate(val, "PolicyResult", &r.PolicyResult)
			delete(rawMsg, key)
		case "pricingRefundAmount":
			err = unpopulate(val, "PricingRefundAmount", &r.PricingRefundAmount)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "sessionId":
			err = unpopulate(val, "SessionID", &r.SessionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewPropertiesResponse.
func (r RenewPropertiesResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyTotal", r.BillingCurrencyTotal)
	populate(objectMap, "pricingCurrencyTotal", r.PricingCurrencyTotal)
	populate(objectMap, "purchaseProperties", r.PurchaseProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewPropertiesResponse.
func (r *RenewPropertiesResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &r.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "pricingCurrencyTotal":
			err = unpopulate(val, "PricingCurrencyTotal", &r.PricingCurrencyTotal)
			delete(rawMsg, key)
		case "purchaseProperties":
			err = unpopulate(val, "PurchaseProperties", &r.PurchaseProperties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewPropertiesResponseBillingCurrencyTotal.
func (r RenewPropertiesResponseBillingCurrencyTotal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", r.Amount)
	populate(objectMap, "currencyCode", r.CurrencyCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewPropertiesResponseBillingCurrencyTotal.
func (r *RenewPropertiesResponseBillingCurrencyTotal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &r.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &r.CurrencyCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RenewPropertiesResponsePricingCurrencyTotal.
func (r RenewPropertiesResponsePricingCurrencyTotal) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "amount", r.Amount)
	populate(objectMap, "currencyCode", r.CurrencyCode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RenewPropertiesResponsePricingCurrencyTotal.
func (r *RenewPropertiesResponsePricingCurrencyTotal) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "amount":
			err = unpopulate(val, "Amount", &r.Amount)
			delete(rawMsg, key)
		case "currencyCode":
			err = unpopulate(val, "CurrencyCode", &r.CurrencyCode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationList.
func (r ReservationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationList.
func (r *ReservationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationMergeProperties.
func (r ReservationMergeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mergeDestination", r.MergeDestination)
	populate(objectMap, "mergeSources", r.MergeSources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationMergeProperties.
func (r *ReservationMergeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mergeDestination":
			err = unpopulate(val, "MergeDestination", &r.MergeDestination)
			delete(rawMsg, key)
		case "mergeSources":
			err = unpopulate(val, "MergeSources", &r.MergeSources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderBillingPlanInformation.
func (r ReservationOrderBillingPlanInformation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateType(objectMap, "nextPaymentDueDate", r.NextPaymentDueDate)
	populate(objectMap, "pricingCurrencyTotal", r.PricingCurrencyTotal)
	populateDateType(objectMap, "startDate", r.StartDate)
	populate(objectMap, "transactions", r.Transactions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderBillingPlanInformation.
func (r *ReservationOrderBillingPlanInformation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextPaymentDueDate":
			err = unpopulateDateType(val, "NextPaymentDueDate", &r.NextPaymentDueDate)
			delete(rawMsg, key)
		case "pricingCurrencyTotal":
			err = unpopulate(val, "PricingCurrencyTotal", &r.PricingCurrencyTotal)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateType(val, "StartDate", &r.StartDate)
			delete(rawMsg, key)
		case "transactions":
			err = unpopulate(val, "Transactions", &r.Transactions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderList.
func (r ReservationOrderList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderList.
func (r *ReservationOrderList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderProperties.
func (r ReservationOrderProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "benefitStartTime", r.BenefitStartTime)
	populate(objectMap, "billingPlan", r.BillingPlan)
	populateDateTimeRFC3339(objectMap, "createdDateTime", r.CreatedDateTime)
	populate(objectMap, "displayName", r.DisplayName)
	populateDateType(objectMap, "expiryDate", r.ExpiryDate)
	populateDateTimeRFC3339(objectMap, "expiryDateTime", r.ExpiryDateTime)
	populate(objectMap, "originalQuantity", r.OriginalQuantity)
	populate(objectMap, "planInformation", r.PlanInformation)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	populateDateTimeRFC3339(objectMap, "requestDateTime", r.RequestDateTime)
	populate(objectMap, "reservations", r.Reservations)
	populateDateTimeRFC3339(objectMap, "reviewDateTime", r.ReviewDateTime)
	populate(objectMap, "term", r.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderProperties.
func (r *ReservationOrderProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "benefitStartTime":
			err = unpopulateDateTimeRFC3339(val, "BenefitStartTime", &r.BenefitStartTime)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &r.BillingPlan)
			delete(rawMsg, key)
		case "createdDateTime":
			err = unpopulateDateTimeRFC3339(val, "CreatedDateTime", &r.CreatedDateTime)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "expiryDate":
			err = unpopulateDateType(val, "ExpiryDate", &r.ExpiryDate)
			delete(rawMsg, key)
		case "expiryDateTime":
			err = unpopulateDateTimeRFC3339(val, "ExpiryDateTime", &r.ExpiryDateTime)
			delete(rawMsg, key)
		case "originalQuantity":
			err = unpopulate(val, "OriginalQuantity", &r.OriginalQuantity)
			delete(rawMsg, key)
		case "planInformation":
			err = unpopulate(val, "PlanInformation", &r.PlanInformation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		case "requestDateTime":
			err = unpopulateDateTimeRFC3339(val, "RequestDateTime", &r.RequestDateTime)
			delete(rawMsg, key)
		case "reservations":
			err = unpopulate(val, "Reservations", &r.Reservations)
			delete(rawMsg, key)
		case "reviewDateTime":
			err = unpopulateDateTimeRFC3339(val, "ReviewDateTime", &r.ReviewDateTime)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &r.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationOrderResponse.
func (r ReservationOrderResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationOrderResponse.
func (r *ReservationOrderResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationResponse.
func (r ReservationResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", r.Etag)
	populate(objectMap, "id", r.ID)
	objectMap["kind"] = "Microsoft.Compute"
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "sku", r.SKU)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationResponse.
func (r *ReservationResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &r.Etag)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &r.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &r.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &r.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSplitProperties.
func (r ReservationSplitProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "splitDestinations", r.SplitDestinations)
	populate(objectMap, "splitSource", r.SplitSource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSplitProperties.
func (r *ReservationSplitProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "splitDestinations":
			err = unpopulate(val, "SplitDestinations", &r.SplitDestinations)
			delete(rawMsg, key)
		case "splitSource":
			err = unpopulate(val, "SplitSource", &r.SplitSource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSummary.
func (r ReservationSummary) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cancelledCount", r.CancelledCount)
	populate(objectMap, "expiredCount", r.ExpiredCount)
	populate(objectMap, "expiringCount", r.ExpiringCount)
	populate(objectMap, "failedCount", r.FailedCount)
	populate(objectMap, "noBenefitCount", r.NoBenefitCount)
	populate(objectMap, "pendingCount", r.PendingCount)
	populate(objectMap, "processingCount", r.ProcessingCount)
	populate(objectMap, "succeededCount", r.SucceededCount)
	populate(objectMap, "warningCount", r.WarningCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSummary.
func (r *ReservationSummary) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cancelledCount":
			err = unpopulate(val, "CancelledCount", &r.CancelledCount)
			delete(rawMsg, key)
		case "expiredCount":
			err = unpopulate(val, "ExpiredCount", &r.ExpiredCount)
			delete(rawMsg, key)
		case "expiringCount":
			err = unpopulate(val, "ExpiringCount", &r.ExpiringCount)
			delete(rawMsg, key)
		case "failedCount":
			err = unpopulate(val, "FailedCount", &r.FailedCount)
			delete(rawMsg, key)
		case "noBenefitCount":
			err = unpopulate(val, "NoBenefitCount", &r.NoBenefitCount)
			delete(rawMsg, key)
		case "pendingCount":
			err = unpopulate(val, "PendingCount", &r.PendingCount)
			delete(rawMsg, key)
		case "processingCount":
			err = unpopulate(val, "ProcessingCount", &r.ProcessingCount)
			delete(rawMsg, key)
		case "succeededCount":
			err = unpopulate(val, "SucceededCount", &r.SucceededCount)
			delete(rawMsg, key)
		case "warningCount":
			err = unpopulate(val, "WarningCount", &r.WarningCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationSwapProperties.
func (r ReservationSwapProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "swapDestination", r.SwapDestination)
	populate(objectMap, "swapSource", r.SwapSource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationSwapProperties.
func (r *ReservationSwapProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "swapDestination":
			err = unpopulate(val, "SwapDestination", &r.SwapDestination)
			delete(rawMsg, key)
		case "swapSource":
			err = unpopulate(val, "SwapSource", &r.SwapSource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationToExchange.
func (r ReservationToExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingInformation", r.BillingInformation)
	populate(objectMap, "billingRefundAmount", r.BillingRefundAmount)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "reservationId", r.ReservationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationToExchange.
func (r *ReservationToExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingInformation":
			err = unpopulate(val, "BillingInformation", &r.BillingInformation)
			delete(rawMsg, key)
		case "billingRefundAmount":
			err = unpopulate(val, "BillingRefundAmount", &r.BillingRefundAmount)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationToPurchaseCalculateExchange.
func (r ReservationToPurchaseCalculateExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyTotal", r.BillingCurrencyTotal)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationToPurchaseCalculateExchange.
func (r *ReservationToPurchaseCalculateExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &r.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationToPurchaseExchange.
func (r ReservationToPurchaseExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyTotal", r.BillingCurrencyTotal)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "reservationId", r.ReservationID)
	populate(objectMap, "reservationOrderId", r.ReservationOrderID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationToPurchaseExchange.
func (r *ReservationToPurchaseExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &r.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		case "reservationOrderId":
			err = unpopulate(val, "ReservationOrderID", &r.ReservationOrderID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationToReturn.
func (r ReservationToReturn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "reservationId", r.ReservationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationToReturn.
func (r *ReservationToReturn) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationToReturnForExchange.
func (r ReservationToReturnForExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingInformation", r.BillingInformation)
	populate(objectMap, "billingRefundAmount", r.BillingRefundAmount)
	populate(objectMap, "quantity", r.Quantity)
	populate(objectMap, "reservationId", r.ReservationID)
	populate(objectMap, "status", r.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationToReturnForExchange.
func (r *ReservationToReturnForExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingInformation":
			err = unpopulate(val, "BillingInformation", &r.BillingInformation)
			delete(rawMsg, key)
		case "billingRefundAmount":
			err = unpopulate(val, "BillingRefundAmount", &r.BillingRefundAmount)
			delete(rawMsg, key)
		case "quantity":
			err = unpopulate(val, "Quantity", &r.Quantity)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &r.ReservationID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &r.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReservationUtilizationAggregates.
func (r ReservationUtilizationAggregates) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "grain", r.Grain)
	populate(objectMap, "grainUnit", r.GrainUnit)
	populate(objectMap, "value", r.Value)
	populate(objectMap, "valueUnit", r.ValueUnit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReservationUtilizationAggregates.
func (r *ReservationUtilizationAggregates) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "grain":
			err = unpopulate(val, "Grain", &r.Grain)
			delete(rawMsg, key)
		case "grainUnit":
			err = unpopulate(val, "GrainUnit", &r.GrainUnit)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		case "valueUnit":
			err = unpopulate(val, "ValueUnit", &r.ValueUnit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceName.
func (r ResourceName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "localizedValue", r.LocalizedValue)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceName.
func (r *ResourceName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "localizedValue":
			err = unpopulate(val, "LocalizedValue", &r.LocalizedValue)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUCapability.
func (s SKUCapability) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUCapability.
func (s *SKUCapability) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUName.
func (s SKUName) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUName.
func (s *SKUName) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKUProperty.
func (s SKUProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKUProperty.
func (s *SKUProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SKURestriction.
func (s SKURestriction) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "reasonCode", s.ReasonCode)
	populate(objectMap, "type", s.Type)
	populate(objectMap, "values", s.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SKURestriction.
func (s *SKURestriction) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "reasonCode":
			err = unpopulate(val, "ReasonCode", &s.ReasonCode)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &s.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanPurchaseRequest.
func (s SavingsPlanPurchaseRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "sku", s.SKU)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanPurchaseRequest.
func (s *SavingsPlanPurchaseRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &s.SKU)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanPurchaseRequestProperties.
func (s SavingsPlanPurchaseRequestProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedScopeProperties", s.AppliedScopeProperties)
	populate(objectMap, "appliedScopeType", s.AppliedScopeType)
	populate(objectMap, "billingPlan", s.BillingPlan)
	populate(objectMap, "billingScopeId", s.BillingScopeID)
	populate(objectMap, "commitment", s.Commitment)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "term", s.Term)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanPurchaseRequestProperties.
func (s *SavingsPlanPurchaseRequestProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedScopeProperties":
			err = unpopulate(val, "AppliedScopeProperties", &s.AppliedScopeProperties)
			delete(rawMsg, key)
		case "appliedScopeType":
			err = unpopulate(val, "AppliedScopeType", &s.AppliedScopeType)
			delete(rawMsg, key)
		case "billingPlan":
			err = unpopulate(val, "BillingPlan", &s.BillingPlan)
			delete(rawMsg, key)
		case "billingScopeId":
			err = unpopulate(val, "BillingScopeID", &s.BillingScopeID)
			delete(rawMsg, key)
		case "commitment":
			err = unpopulate(val, "Commitment", &s.Commitment)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "term":
			err = unpopulate(val, "Term", &s.Term)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanToPurchaseCalculateExchange.
func (s SavingsPlanToPurchaseCalculateExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyTotal", s.BillingCurrencyTotal)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanToPurchaseCalculateExchange.
func (s *SavingsPlanToPurchaseCalculateExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &s.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SavingsPlanToPurchaseExchange.
func (s SavingsPlanToPurchaseExchange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingCurrencyTotal", s.BillingCurrencyTotal)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "savingsPlanId", s.SavingsPlanID)
	populate(objectMap, "savingsPlanOrderId", s.SavingsPlanOrderID)
	populate(objectMap, "status", s.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SavingsPlanToPurchaseExchange.
func (s *SavingsPlanToPurchaseExchange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingCurrencyTotal":
			err = unpopulate(val, "BillingCurrencyTotal", &s.BillingCurrencyTotal)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "savingsPlanId":
			err = unpopulate(val, "SavingsPlanID", &s.SavingsPlanID)
			delete(rawMsg, key)
		case "savingsPlanOrderId":
			err = unpopulate(val, "SavingsPlanOrderID", &s.SavingsPlanOrderID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &s.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeProperties.
func (s ScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scope", s.Scope)
	populate(objectMap, "valid", s.Valid)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeProperties.
func (s *ScopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scope":
			err = unpopulate(val, "Scope", &s.Scope)
			delete(rawMsg, key)
		case "valid":
			err = unpopulate(val, "Valid", &s.Valid)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceError.
func (s ServiceError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", s.Code)
	populate(objectMap, "details", s.Details)
	populate(objectMap, "message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceError.
func (s *ServiceError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &s.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceErrorDetail.
func (s ServiceErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", s.Code)
	populate(objectMap, "message", s.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceErrorDetail.
func (s *ServiceErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &s.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SplitProperties.
func (s SplitProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "quantities", s.Quantities)
	populate(objectMap, "reservationId", s.ReservationID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SplitProperties.
func (s *SplitProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "quantities":
			err = unpopulate(val, "Quantities", &s.Quantities)
			delete(rawMsg, key)
		case "reservationId":
			err = unpopulate(val, "ReservationID", &s.ReservationID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SplitRequest.
func (s SplitRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SplitRequest.
func (s *SplitRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubRequest.
func (s SubRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "limit", s.Limit)
	populate(objectMap, "message", s.Message)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "resourceType", s.ResourceType)
	populate(objectMap, "subRequestId", s.SubRequestID)
	populate(objectMap, "unit", s.Unit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubRequest.
func (s *SubRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "limit":
			err = unpopulate(val, "Limit", &s.Limit)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &s.Message)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &s.ResourceType)
			delete(rawMsg, key)
		case "subRequestId":
			err = unpopulate(val, "SubRequestID", &s.SubRequestID)
			delete(rawMsg, key)
		case "unit":
			err = unpopulate(val, "Unit", &s.Unit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionScopeProperties.
func (s SubscriptionScopeProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "scopes", s.Scopes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionScopeProperties.
func (s *SubscriptionScopeProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "scopes":
			err = unpopulate(val, "Scopes", &s.Scopes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
