//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdeploymentscripts

import "time"

// AzureCliScript - Object model for the Azure CLI script.
type AzureCliScript struct {
	// REQUIRED; Type of the script.
	Kind *ScriptType

	// REQUIRED; The location of the ACI and the storage account for the deployment script.
	Location *string

	// REQUIRED; Properties of the Azure CLI script object.
	Properties *AzureCliScriptProperties

	// Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetDeploymentScript implements the DeploymentScriptClassification interface for type AzureCliScript.
func (a *AzureCliScript) GetDeploymentScript() *DeploymentScript {
	return &DeploymentScript{
		ID:         a.ID,
		Identity:   a.Identity,
		Kind:       a.Kind,
		Location:   a.Location,
		Name:       a.Name,
		SystemData: a.SystemData,
		Tags:       a.Tags,
		Type:       a.Type,
	}
}

// AzureCliScriptProperties - Properties of the Azure CLI script object.
type AzureCliScriptProperties struct {
	// REQUIRED; Azure CLI module version to be used.
	AzCliVersion *string

	// REQUIRED; Interval for which the service retains the script resource after it reaches a terminal state. Resource will be
	// deleted when this duration expires. Duration is based on ISO 8601 pattern (for example
	// P1D means one day).
	RetentionInterval *string

	// Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
	Arguments *string

	// The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
	CleanupPreference *CleanupOptions

	// Container settings.
	ContainerSettings *ContainerConfiguration

	// The environment variables to pass over to the script.
	EnvironmentVariables []*EnvironmentVariable

	// Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be
	// current time stamp or a GUID.
	ForceUpdateTag *string

	// Uri for the script. This is the entry point for the external script.
	PrimaryScriptURI *string

	// Script body.
	ScriptContent *string

	// Storage Account settings.
	StorageAccountSettings *StorageAccountConfiguration

	// Supporting files for the external script.
	SupportingScriptUris []*string

	// Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
	Timeout *string

	// READ-ONLY; List of script outputs.
	Outputs map[string]any

	// READ-ONLY; State of the script execution. This only appears in the response.
	ProvisioningState *ScriptProvisioningState

	// READ-ONLY; Contains the results of script execution.
	Status *ScriptStatus
}

// AzurePowerShellScript - Object model for the Azure PowerShell script.
type AzurePowerShellScript struct {
	// REQUIRED; Type of the script.
	Kind *ScriptType

	// REQUIRED; The location of the ACI and the storage account for the deployment script.
	Location *string

	// REQUIRED; Properties of the Azure PowerShell script object.
	Properties *AzurePowerShellScriptProperties

	// Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetDeploymentScript implements the DeploymentScriptClassification interface for type AzurePowerShellScript.
func (a *AzurePowerShellScript) GetDeploymentScript() *DeploymentScript {
	return &DeploymentScript{
		ID:         a.ID,
		Identity:   a.Identity,
		Kind:       a.Kind,
		Location:   a.Location,
		Name:       a.Name,
		SystemData: a.SystemData,
		Tags:       a.Tags,
		Type:       a.Type,
	}
}

// AzurePowerShellScriptProperties - Properties of the Azure PowerShell script object.
type AzurePowerShellScriptProperties struct {
	// REQUIRED; Azure PowerShell module version to be used.
	AzPowerShellVersion *string

	// REQUIRED; Interval for which the service retains the script resource after it reaches a terminal state. Resource will be
	// deleted when this duration expires. Duration is based on ISO 8601 pattern (for example
	// P1D means one day).
	RetentionInterval *string

	// Command line arguments to pass to the script. Arguments are separated by spaces. ex: -Name blue* -Location 'West US 2'
	Arguments *string

	// The clean up preference when the script execution gets in a terminal state. Default setting is 'Always'.
	CleanupPreference *CleanupOptions

	// Container settings.
	ContainerSettings *ContainerConfiguration

	// The environment variables to pass over to the script.
	EnvironmentVariables []*EnvironmentVariable

	// Gets or sets how the deployment script should be forced to execute even if the script resource has not changed. Can be
	// current time stamp or a GUID.
	ForceUpdateTag *string

	// Uri for the script. This is the entry point for the external script.
	PrimaryScriptURI *string

	// Script body.
	ScriptContent *string

	// Storage Account settings.
	StorageAccountSettings *StorageAccountConfiguration

	// Supporting files for the external script.
	SupportingScriptUris []*string

	// Maximum allowed script execution time specified in ISO 8601 format. Default value is P1D
	Timeout *string

	// READ-ONLY; List of script outputs.
	Outputs map[string]any

	// READ-ONLY; State of the script execution. This only appears in the response.
	ProvisioningState *ScriptProvisioningState

	// READ-ONLY; Contains the results of script execution.
	Status *ScriptStatus
}

// AzureResourceBase - Common properties for all Azure resources.
type AzureResourceBase struct {
	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// ContainerConfiguration - Settings to customize ACI container instance.
type ContainerConfiguration struct {
	// Container group name, if not specified then the name will get auto-generated. Not specifying a 'containerGroupName' indicates
	// the system to generate a unique name which might end up flagging an Azure
	// Policy as non-compliant. Use 'containerGroupName' when you have an Azure Policy that expects a specific naming convention
	// or when you want to fully control the name. 'containerGroupName' property must
	// be between 1 and 63 characters long, must contain only lowercase letters, numbers, and dashes and it cannot start or end
	// with a dash and consecutive dashes are not allowed. To specify a
	// 'containerGroupName', add the following object to properties: { "containerSettings": { "containerGroupName": "contoso-container"
	// } }. If you do not want to specify a 'containerGroupName' then do not
	// add 'containerSettings' property.
	ContainerGroupName *string
}

// DeploymentScript - Deployment script object.
type DeploymentScript struct {
	// REQUIRED; Type of the script.
	Kind *ScriptType

	// REQUIRED; The location of the ACI and the storage account for the deployment script.
	Location *string

	// Optional property. Managed identity to be used for this deployment script. Currently, only user-assigned MSI is supported.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; The system metadata related to this resource.
	SystemData *SystemData

	// READ-ONLY; Type of this resource.
	Type *string
}

// GetDeploymentScript implements the DeploymentScriptClassification interface for type DeploymentScript.
func (d *DeploymentScript) GetDeploymentScript() *DeploymentScript { return d }

// DeploymentScriptListResult - List of deployment scripts.
type DeploymentScriptListResult struct {
	// An array of deployment scripts.
	Value []DeploymentScriptClassification

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string
}

// DeploymentScriptUpdateParameter - Deployment script parameters to be updated.
type DeploymentScriptUpdateParameter struct {
	// Resource tags to be updated.
	Tags map[string]*string

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// EnvironmentVariable - The environment variable to pass to the script in the container instance.
type EnvironmentVariable struct {
	// REQUIRED; The name of the environment variable.
	Name *string

	// The value of the secure environment variable.
	SecureValue *string

	// The value of the environment variable.
	Value *string
}

// Error - Deployment scripts error response.
type Error struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorResponse

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// LogProperties - Script log properties.
type LogProperties struct {
	// READ-ONLY; Script execution logs in text format.
	Log *string
}

// ManagedServiceIdentity - Managed identity generic object.
type ManagedServiceIdentity struct {
	// Type of the managed identity.
	Type *ManagedServiceIdentityType

	// The list of user-assigned managed identities associated with the resource. Key is the Azure resource Id of the managed
	// identity.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; ID of the Azure Active Directory.
	TenantID *string
}

// ScriptLog - Script execution log object.
type ScriptLog struct {
	// Script log properties.
	Properties *LogProperties

	// READ-ONLY; String Id used to locate any resource on Azure.
	ID *string

	// READ-ONLY; Name of this resource.
	Name *string

	// READ-ONLY; Type of this resource.
	Type *string
}

// ScriptLogsList - Deployment script execution logs.
type ScriptLogsList struct {
	// Deployment scripts logs.
	Value []*ScriptLog
}

// ScriptStatus - Generic object modeling results of script execution.
type ScriptStatus struct {
	// Error that is relayed from the script execution.
	Error *ErrorResponse

	// READ-ONLY; ACI resource Id.
	ContainerInstanceID *string

	// READ-ONLY; End time of the script execution.
	EndTime *time.Time

	// READ-ONLY; Time the deployment script resource will expire.
	ExpirationTime *time.Time

	// READ-ONLY; Start time of the script execution.
	StartTime *time.Time

	// READ-ONLY; Storage account resource Id.
	StorageAccountID *string
}

// StorageAccountConfiguration - Settings to use an existing storage account. Valid storage account kinds are: Storage, StorageV2
// and FileStorage
type StorageAccountConfiguration struct {
	// The storage account access key.
	StorageAccountKey *string

	// The storage account name.
	StorageAccountName *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UserAssignedIdentity - User-assigned managed identity.
type UserAssignedIdentity struct {
	// READ-ONLY; Client App Id associated with this identity.
	ClientID *string

	// READ-ONLY; Azure Active Directory principal ID associated with this identity.
	PrincipalID *string
}
