//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// AdaptiveApplicationControlsServer is a fake server for instances of the armsecurity.AdaptiveApplicationControlsClient type.
type AdaptiveApplicationControlsServer struct {
	// Delete is the fake for method AdaptiveApplicationControlsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	Delete func(ctx context.Context, ascLocation string, groupName string, options *armsecurity.AdaptiveApplicationControlsClientDeleteOptions) (resp azfake.Responder[armsecurity.AdaptiveApplicationControlsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method AdaptiveApplicationControlsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, ascLocation string, groupName string, options *armsecurity.AdaptiveApplicationControlsClientGetOptions) (resp azfake.Responder[armsecurity.AdaptiveApplicationControlsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method AdaptiveApplicationControlsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armsecurity.AdaptiveApplicationControlsClientListOptions) (resp azfake.Responder[armsecurity.AdaptiveApplicationControlsClientListResponse], errResp azfake.ErrorResponder)

	// Put is the fake for method AdaptiveApplicationControlsClient.Put
	// HTTP status codes to indicate success: http.StatusOK
	Put func(ctx context.Context, ascLocation string, groupName string, body armsecurity.AdaptiveApplicationControlGroup, options *armsecurity.AdaptiveApplicationControlsClientPutOptions) (resp azfake.Responder[armsecurity.AdaptiveApplicationControlsClientPutResponse], errResp azfake.ErrorResponder)
}

// NewAdaptiveApplicationControlsServerTransport creates a new instance of AdaptiveApplicationControlsServerTransport with the provided implementation.
// The returned AdaptiveApplicationControlsServerTransport instance is connected to an instance of armsecurity.AdaptiveApplicationControlsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAdaptiveApplicationControlsServerTransport(srv *AdaptiveApplicationControlsServer) *AdaptiveApplicationControlsServerTransport {
	return &AdaptiveApplicationControlsServerTransport{srv: srv}
}

// AdaptiveApplicationControlsServerTransport connects instances of armsecurity.AdaptiveApplicationControlsClient to instances of AdaptiveApplicationControlsServer.
// Don't use this type directly, use NewAdaptiveApplicationControlsServerTransport instead.
type AdaptiveApplicationControlsServerTransport struct {
	srv *AdaptiveApplicationControlsServer
}

// Do implements the policy.Transporter interface for AdaptiveApplicationControlsServerTransport.
func (a *AdaptiveApplicationControlsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AdaptiveApplicationControlsClient.Delete":
		resp, err = a.dispatchDelete(req)
	case "AdaptiveApplicationControlsClient.Get":
		resp, err = a.dispatchGet(req)
	case "AdaptiveApplicationControlsClient.List":
		resp, err = a.dispatchList(req)
	case "AdaptiveApplicationControlsClient.Put":
		resp, err = a.dispatchPut(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AdaptiveApplicationControlsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applicationWhitelistings/(?P<groupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	groupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), ascLocationParam, groupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AdaptiveApplicationControlsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if a.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applicationWhitelistings/(?P<groupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	groupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Get(req.Context(), ascLocationParam, groupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdaptiveApplicationControlGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AdaptiveApplicationControlsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if a.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/applicationWhitelistings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	includePathRecommendationsUnescaped, err := url.QueryUnescape(qp.Get("includePathRecommendations"))
	if err != nil {
		return nil, err
	}
	includePathRecommendationsParam, err := parseOptional(includePathRecommendationsUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	summaryUnescaped, err := url.QueryUnescape(qp.Get("summary"))
	if err != nil {
		return nil, err
	}
	summaryParam, err := parseOptional(summaryUnescaped, strconv.ParseBool)
	if err != nil {
		return nil, err
	}
	var options *armsecurity.AdaptiveApplicationControlsClientListOptions
	if includePathRecommendationsParam != nil || summaryParam != nil {
		options = &armsecurity.AdaptiveApplicationControlsClientListOptions{
			IncludePathRecommendations: includePathRecommendationsParam,
			Summary:                    summaryParam,
		}
	}
	respr, errRespr := a.srv.List(req.Context(), options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdaptiveApplicationControlGroups, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AdaptiveApplicationControlsServerTransport) dispatchPut(req *http.Request) (*http.Response, error) {
	if a.srv.Put == nil {
		return nil, &nonRetriableError{errors.New("fake for method Put not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/applicationWhitelistings/(?P<groupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurity.AdaptiveApplicationControlGroup](req)
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	groupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Put(req.Context(), ascLocationParam, groupNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AdaptiveApplicationControlGroup, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
