//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armsecurity

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// GitLabProjectsClient contains the methods for the GitLabProjects group.
// Don't use this type directly, use NewGitLabProjectsClient() instead.
type GitLabProjectsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewGitLabProjectsClient creates a new instance of GitLabProjectsClient with the specified values.
//   - subscriptionID - Azure subscription ID
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewGitLabProjectsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*GitLabProjectsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &GitLabProjectsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Returns a monitored GitLab Project resource for a given fully-qualified group name and project name.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - securityConnectorName - The security connector name.
//   - groupFQName - The GitLab group fully-qualified name.
//   - projectName - The project name.
//   - options - GitLabProjectsClientGetOptions contains the optional parameters for the GitLabProjectsClient.Get method.
func (client *GitLabProjectsClient) Get(ctx context.Context, resourceGroupName string, securityConnectorName string, groupFQName string, projectName string, options *GitLabProjectsClientGetOptions) (GitLabProjectsClientGetResponse, error) {
	var err error
	const operationName = "GitLabProjectsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, securityConnectorName, groupFQName, projectName, options)
	if err != nil {
		return GitLabProjectsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return GitLabProjectsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return GitLabProjectsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *GitLabProjectsClient) getCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, groupFQName string, projectName string, options *GitLabProjectsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitLabGroups/{groupFQName}/projects/{projectName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if groupFQName == "" {
		return nil, errors.New("parameter groupFQName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupFQName}", url.PathEscape(groupFQName))
	if projectName == "" {
		return nil, errors.New("parameter projectName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{projectName}", url.PathEscape(projectName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *GitLabProjectsClient) getHandleResponse(resp *http.Response) (GitLabProjectsClientGetResponse, error) {
	result := GitLabProjectsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitLabProject); err != nil {
		return GitLabProjectsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets a list of GitLab projects that are directly owned by given group and onboarded to the connector.
//
// Generated from API version 2023-09-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - securityConnectorName - The security connector name.
//   - groupFQName - The GitLab group fully-qualified name.
//   - options - GitLabProjectsClientListOptions contains the optional parameters for the GitLabProjectsClient.NewListPager method.
func (client *GitLabProjectsClient) NewListPager(resourceGroupName string, securityConnectorName string, groupFQName string, options *GitLabProjectsClientListOptions) *runtime.Pager[GitLabProjectsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[GitLabProjectsClientListResponse]{
		More: func(page GitLabProjectsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *GitLabProjectsClientListResponse) (GitLabProjectsClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "GitLabProjectsClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, securityConnectorName, groupFQName, options)
			}, nil)
			if err != nil {
				return GitLabProjectsClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *GitLabProjectsClient) listCreateRequest(ctx context.Context, resourceGroupName string, securityConnectorName string, groupFQName string, options *GitLabProjectsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName}/devops/default/gitLabGroups/{groupFQName}/projects"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if securityConnectorName == "" {
		return nil, errors.New("parameter securityConnectorName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{securityConnectorName}", url.PathEscape(securityConnectorName))
	if groupFQName == "" {
		return nil, errors.New("parameter groupFQName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{groupFQName}", url.PathEscape(groupFQName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *GitLabProjectsClient) listHandleResponse(resp *http.Response) (GitLabProjectsClientListResponse, error) {
	result := GitLabProjectsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.GitLabProjectListResponse); err != nil {
		return GitLabProjectsClientListResponse{}, err
	}
	return result, nil
}
